/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.Serializable;

class SearchWindow
extends FixedFrame
implements CbButtonCallback,
MultiColumnCallback {
    TabbedPanel tab;
    MultiColumn list;
    CbButton search_b;
    CbButton cancel_b;
    CbButton down_b;
    FileManager filemgr;
    TextField dir;
    TextField match;
    TextField user;
    TextField group;
    Checkbox uany;
    Checkbox usel;
    Checkbox gany;
    Checkbox gsel;
    Choice type;
    Checkbox sany;
    Checkbox smore;
    Checkbox sless;
    TextField more;
    TextField less;
    Checkbox xon;
    Checkbox xoff;
    String[] types = new String[]{"", "f", "d", "l", "p"};
    TextField cont;
    RemoteFile[] results;

    SearchWindow(String string, FileManager fileManager) {
        Serializable serializable;
        Panel panel;
        Serializable serializable2;
        Serializable serializable3;
        this.filemgr = fileManager;
        this.setTitle(this.filemgr.text("search_title"));
        this.setLayout(new BorderLayout());
        this.tab = new TabbedPanel();
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        this.tab.addItem(this.filemgr.text("search_crit"), panel2);
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        panel3.setLayout(new GridLayout(0, 1));
        panel4.setLayout(new GridLayout(0, 1));
        String[] stringArray = new String[]{"", this.filemgr.text("right_name"), this.filemgr.text("right_size")};
        float[] fArray = new float[]{0.07f, 0.78f, 0.15f};
        this.list = new MultiColumn(stringArray, this);
        this.list.setWidths(fArray);
        this.list.setDrawLines(false);
        this.list.setFont(this.filemgr.fixed);
        this.tab.addItem(this.filemgr.text("search_list"), this.list);
        this.dir = new TextField(string, 30);
        this.add_item(this.filemgr.text("search_dir"), this.dir, panel3, panel4);
        this.dir.setFont(this.filemgr.fixed);
        this.match = new TextField(20);
        this.add_item(this.filemgr.text("search_match"), this.match, panel3, panel4);
        this.match.setFont(this.filemgr.fixed);
        if (this.filemgr.search_contents) {
            this.cont = new TextField(30);
            this.add_item(this.filemgr.text("search_cont"), this.cont, panel3, panel4);
            this.cont.setFont(this.filemgr.fixed);
        }
        if (this.filemgr.can_users) {
            serializable3 = new Panel();
            ((Container)serializable3).setLayout(new FlowLayout(0, 1, 1));
            serializable2 = new CheckboxGroup();
            this.uany = new Checkbox(this.filemgr.text("search_any"), (CheckboxGroup)serializable2, true);
            ((Container)serializable3).add(this.uany);
            this.usel = new Checkbox("", (CheckboxGroup)serializable2, false);
            ((Container)serializable3).add(this.usel);
            this.user = new TextField(10);
            ((Container)serializable3).add(this.user);
            this.user.setFont(this.filemgr.fixed);
            this.add_item(this.filemgr.text("search_user"), (Component)serializable3, panel3, panel4);
            panel = new Panel();
            panel.setLayout(new FlowLayout(0, 1, 1));
            serializable = new CheckboxGroup();
            this.gany = new Checkbox(this.filemgr.text("search_any"), (CheckboxGroup)serializable, true);
            panel.add(this.gany);
            this.gsel = new Checkbox("", (CheckboxGroup)serializable, false);
            panel.add(this.gsel);
            this.group = new TextField(10);
            panel.add(this.group);
            this.group.setFont(this.filemgr.fixed);
            this.add_item(this.filemgr.text("search_group"), panel, panel3, panel4);
        }
        if (!this.filemgr.follow_links) {
            this.type = new Choice();
            for (int i = 0; i < this.types.length; ++i) {
                this.type.addItem(this.filemgr.text("search_types_" + this.types[i]));
            }
            this.add_item(this.filemgr.text("search_type"), this.type, panel3, panel4);
        }
        serializable3 = new CheckboxGroup();
        this.sany = new Checkbox(this.filemgr.text("search_any"), (CheckboxGroup)serializable3, true);
        this.add_item(this.filemgr.text("search_size"), this.sany, panel3, panel4);
        serializable2 = new Panel();
        ((Container)serializable2).setLayout(new FlowLayout(0, 1, 1));
        this.smore = new Checkbox(this.filemgr.text("search_more"), (CheckboxGroup)serializable3, false);
        ((Container)serializable2).add(this.smore);
        this.more = new TextField(10);
        ((Container)serializable2).add(this.more);
        this.more.setFont(this.filemgr.fixed);
        this.add_item("", (Component)serializable2, panel3, panel4);
        panel = new Panel();
        panel.setLayout(new FlowLayout(0, 1, 1));
        this.sless = new Checkbox(this.filemgr.text("search_less"), (CheckboxGroup)serializable3, false);
        panel.add(this.sless);
        this.less = new TextField(10);
        panel.add(this.less);
        this.less.setFont(this.filemgr.fixed);
        this.add_item("", panel, panel3, panel4);
        if (this.filemgr.got_filesystems) {
            serializable = new CheckboxGroup();
            Panel panel5 = new Panel();
            panel5.setLayout(new FlowLayout(0, 1, 1));
            this.xoff = new Checkbox(this.filemgr.text("yes"), (CheckboxGroup)serializable, true);
            panel5.add(this.xoff);
            this.xon = new Checkbox(this.filemgr.text("no"), (CheckboxGroup)serializable, false);
            panel5.add(this.xon);
            this.add_item(this.filemgr.text("search_xdev"), panel5, panel3, panel4);
        }
        panel2.add("West", panel3);
        panel2.add("East", panel4);
        this.add("Center", this.tab);
        serializable = new Panel();
        ((Container)serializable).setLayout(new FlowLayout(2));
        this.down_b = new CbButton(this.filemgr.get_image("down.gif"), this.filemgr.text("search_down"), 0, this);
        ((Container)serializable).add(this.down_b);
        this.search_b = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("search_ok"), 0, this);
        ((Container)serializable).add(this.search_b);
        this.cancel_b = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("cancel"), 0, this);
        ((Container)serializable).add(this.cancel_b);
        this.add("South", (Component)serializable);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    void add_item(String string, Component component, Panel panel, Panel panel2) {
        panel.add(new Label(string));
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add("West", component);
        panel2.add(panel3);
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.cancel_b) {
            this.dispose();
        } else if (cbButton == this.search_b) {
            Object object;
            String string = "search.cgi";
            String string2 = this.dir.getText().trim();
            if (string2.length() == 0 || string2.charAt(0) != '/') {
                new ErrorWindow(this.filemgr.text("search_edir"));
                return;
            }
            string = string + "?dir=" + FileManager.urlize(string2);
            String string3 = this.match.getText().trim();
            if (string3.length() == 0) {
                string3 = "*";
            }
            string = string + "&match=" + FileManager.urlize(string3);
            if (this.type != null && this.type.getSelectedIndex() > 0) {
                string = string + "&type=" + this.types[this.type.getSelectedIndex()];
            }
            if (this.usel != null && this.usel.getState()) {
                object = this.user.getText().trim();
                if (object.length() == 0) {
                    new ErrorWindow(this.filemgr.text("search_euser"));
                    return;
                }
                string = string + "&user=" + FileManager.urlize((String)object);
            }
            if (this.gsel != null && this.gsel.getState()) {
                object = this.group.getText().trim();
                if (object.length() == 0) {
                    new ErrorWindow(this.filemgr.text("search_egroup"));
                    return;
                }
                string = string + "&group=" + FileManager.urlize((String)object);
            }
            if (this.smore.getState()) {
                object = this.more.getText().trim();
                try {
                    Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    new ErrorWindow(this.filemgr.text("search_esize"));
                    return;
                }
                string = string + "&size=%2B" + (String)object + "c";
            } else if (this.sless.getState()) {
                object = this.less.getText().trim();
                try {
                    Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    new ErrorWindow(this.filemgr.text("search_esize"));
                    return;
                }
                string = string + "&size=%2D" + (String)object + "c";
            }
            if (this.xon != null && this.xon.getState()) {
                string = string + "&xdev=1";
            }
            if (this.cont != null && this.cont.getText().trim().length() > 0) {
                string = string + "&cont=" + FileManager.urlize(this.cont.getText());
            }
            this.setCursor(3);
            object = this.filemgr.get_text(string);
            if (object[0].length() > 0) {
                new ErrorWindow(object[0]);
                return;
            }
            Object[][] objectArray = new Object[((String[])object).length - 1][];
            this.results = new RemoteFile[((String[])object).length - 1];
            for (int i = 1; i < ((String[])object).length; ++i) {
                RemoteFile remoteFile;
                this.results[i - 1] = remoteFile = new RemoteFile(this.filemgr, object[i], null);
                Object[] objectArray2 = new Object[3];
                objectArray[i - 1] = objectArray2;
                Object[] objectArray3 = objectArray2;
                objectArray3[0] = this.filemgr.get_image(RemoteFile.tmap[remoteFile.type]);
                objectArray3[1] = remoteFile.path;
                objectArray3[2] = remoteFile.size < 1000L ? this.filemgr.spad(remoteFile.size, 5) + " B" : (remoteFile.size < 1000000L ? this.filemgr.spad(remoteFile.size / 1000L, 5) + " kB" : this.filemgr.spad(remoteFile.size / 1000000L, 5) + " MB");
            }
            this.list.clear();
            this.list.addItems(objectArray);
            this.tab.select(this.filemgr.text("search_list"));
            this.setCursor(0);
        } else if (cbButton == this.down_b) {
            int n = this.list.selected();
            if (n < 0 || this.results.length == 0) {
                new ErrorWindow(this.filemgr.text("search_edown"));
                return;
            }
            this.filemgr.download_file(this.results[n]);
        }
    }

    public void singleClick(MultiColumn multiColumn, int n) {
    }

    public void doubleClick(MultiColumn multiColumn, int n) {
        RemoteFile remoteFile = this.results[n];
        int n2 = remoteFile.path.lastIndexOf(47);
        String string = n2 == 0 ? "/" : remoteFile.path.substring(0, n2);
        this.filemgr.find_directory(string, true);
        RemoteFile[] remoteFileArray = this.filemgr.showing_list;
        for (int i = 0; i < remoteFileArray.length; ++i) {
            if (!remoteFileArray[i].name.equals(remoteFile.name)) continue;
            this.filemgr.files.select(i + 1);
            this.filemgr.files.scrollto(i + 1);
            break;
        }
        this.dispose();
    }

    public void headingClicked(MultiColumn multiColumn, int n) {
    }
}

