### Description

Briefly describe the issue. Feel free to cross-reference your report with
another related GitHub or JIRA issue for additional context.

Before reporting an issue, check that you are using the most recent version of
the extension.

### Environment

What operating system and PHP version are you using? Mention if PHP was
installed through a third-party bundle (e.g. MAMP, XAMPP) and report its version
if applicable.

Include version information for the extension, libmongoc, and libbson. This may
be collected by grepping `phpinfo()` output like so:

```
$ php -i | grep -E 'mongodb|libmongoc|libbson'
```

In some cases, it may be helpful to provide all `phpinfo()` output from `php -i`
and a list of all install modules with `php -m`.

### Test Script

If possible, attach a complete PHP script that can be excuted on its own to
reproduce the issue. Clarify whether this script can be run from the CLI or if
it can only be reproduced through a web SAPI.

```
<?php

// TEST SCRIPT
```

If the error only presents itself in a web SAPI, report whether the issue can be
reproduced with PHP's built-in web server, which may be launched with
`php -S localhost:8000`. If not, please note your web server version in the
environment section.

http://php.net/manual/en/features.commandline.webserver.php

### Expected and Actual Behavior

How did the script fail to perform the expected task? Feel free to include debug
and/or `var_dump()` output.

If the observed behavior is an unexpected exception, please include its full
message and a backtrace (if relevant). If you encountered a segmentation fault,
please include a GDB backtrace.

https://bugs.php.net/bugs-generating-backtrace.php

```
DEBUG OR BACKTRACE
```

### Debug Log

If the issue relates to internal driver behavior (e.g. connection issues),
please include a debug log. This may be generated by setting the `mongodb.debug`
INI option to "stderr" or a directory (useful for web SAPIs).

http://php.net/manual/en/mongodb.configuration.php#ini.mongodb.debug

```
DEBUG LOG
```
