--TEST--
Array: Single Element Array with index set incorrectly
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('130000000461000B00000010000A0000000000');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

$canonicalBson = hex2bin('140000000461000C0000001030000A0000000000');

// Canonical BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($canonicalBson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"a" : [{"$numberInt": "10"}]}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

// Canonical BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($canonicalBson)), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
140000000461000c0000001030000a0000000000
140000000461000c0000001030000a0000000000
{"a":[{"$numberInt":"10"}]}
{"a":[{"$numberInt":"10"}]}
{"a":[{"$numberInt":"10"}]}
140000000461000c0000001030000a0000000000
===DONE===