--TEST--
Binary type: subtype 0x03
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('1D000000057800100000000373FFD26444B34C6990E8E7D1DFC035D400');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"x" : {"$binary" : "c//SZESzTGmQ6OfR38A11A==", "$type" : "03"}}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1d000000057800100000000373ffd26444b34c6990e8e7d1dfc035d400
{"x":{"$binary":"c\/\/SZESzTGmQ6OfR38A11A==","$type":"03"}}
{"x":{"$binary":"c\/\/SZESzTGmQ6OfR38A11A==","$type":"03"}}
1d000000057800100000000373ffd26444b34c6990e8e7d1dfc035d400
===DONE===