--TEST--
Binary type: subtype 0x04
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('1D000000057800100000000473FFD26444B34C6990E8E7D1DFC035D400');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"x" : {"$binary" : "c//SZESzTGmQ6OfR38A11A==", "$type" : "04"}}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1d000000057800100000000473ffd26444b34c6990e8e7d1dfc035d400
{"x":{"$binary":"c\/\/SZESzTGmQ6OfR38A11A==","$type":"04"}}
{"x":{"$binary":"c\/\/SZESzTGmQ6OfR38A11A==","$type":"04"}}
1d000000057800100000000473ffd26444b34c6990e8e7d1dfc035d400
===DONE===