--TEST--
Javascript Code with Scope: Non-empty code string, empty scope
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('1A0000000F610012000000050000006162636400050000000000');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"a" : {"$code" : "abcd", "$scope" : {}}}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1a0000000f610012000000050000006162636400050000000000
{"a":{"$code":"abcd","$scope":{}}}
{"a":{"$code":"abcd","$scope":{}}}
1a0000000f610012000000050000006162636400050000000000
===DONE===