--TEST--
Javascript Code with Scope: Unicode and embedded null in code string, empty scope
--SKIPIF--
<?php exit("skip Embedded null in code string is not supported in libbson (CDRIVER-1879)"); ?>
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('1A0000000F61001200000005000000C3A9006400050000000000');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"a" : {"$code" : "\\u00e9\\u0000d", "$scope" : {}}}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1a0000000f61001200000005000000c3a9006400050000000000
{"a":{"$code":"\u00e9\u0000d","$scope":{}}}
{"a":{"$code":"\u00e9\u0000d","$scope":{}}}
1a0000000f61001200000005000000c3a9006400050000000000
===DONE===