--TEST--
Decimal128: Non-Canonical Parsing - Long Significand with Exponent
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('1800000013640079D9E0F9763ADA429D0200000000583000');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"d" : {"$numberDecimal" : "12345689012345789012345E+12"}}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

$canonicalJson = '{"d" : {"$numberDecimal" : "1.2345689012345789012345E+34"}}';

// Canonical extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($canonicalJson))), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

// Canonical extJSON to Canonical BSON
echo bin2hex(fromJSON($canonicalJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1800000013640079d9e0f9763ada429d0200000000583000
{"d":{"$numberDecimal":"1.2345689012345789012345E+34"}}
{"d":{"$numberDecimal":"1.2345689012345789012345E+34"}}
{"d":{"$numberDecimal":"1.2345689012345789012345E+34"}}
1800000013640079d9e0f9763ada429d0200000000583000
1800000013640079d9e0f9763ada429d0200000000583000
===DONE===