--TEST--
Top-level document validity: Document that resembles extended JSON, but with extra keys
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('3f00000002247265676578000c0000006e6f742d612d72656765780002246f7074696f6e7300020000006900022462616e616e6100050000007065656c0000');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"$regex": "not-a-regex", "$options": "i", "$banana": "peel"}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
3f00000002247265676578000c0000006e6f742d612d72656765780002246f7074696f6e7300020000006900022462616e616e6100050000007065656c0000
{"$regex":"not-a-regex","$options":"i","$banana":"peel"}
{"$regex":"not-a-regex","$options":"i","$banana":"peel"}
3f00000002247265676578000c0000006e6f742d612d72656765780002246f7074696f6e7300020000006900022462616e616e6100050000007065656c0000
===DONE===