--TEST--
Top-level document validity: Document that resembles extended JSON, but with missing keys
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$bson = hex2bin('1a000000022462696e6172790008000000616263646566670000');

// BSON to Canonical BSON
echo bin2hex(fromPHP(toPHP($bson))), "\n";

// BSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON($bson)), "\n";

$json = '{"$binary": "abcdefg"}';

// extJSON to Canonical extJSON
echo json_canonicalize(toExtendedJSON(fromJSON($json))), "\n";

// extJSON to Canonical BSON
echo bin2hex(fromJSON($json)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
1a000000022462696e6172790008000000616263646566670000
{"$binary":"abcdefg"}
{"$binary":"abcdefg"}
1a000000022462696e6172790008000000616263646566670000
===DONE===