*Practical Node.js* Conclusion
==============================

Lo and behold, this is the end of the book. There was a study that showed that the majority of programmers read zero books per year ([source](http://blog.codinghorror.com/programmers-dont-read-books-but-you-should)). So, pat yourself on the back, because you’re on the road to awesomeness when it comes to building Node.js web apps. &#x263A;

Regarding the material covered in *Practical Node.js*, we explored real-world aspects of the Node.js stack. To do this, many things were essential, and by now you should have an awareness of how pieces fit together. For some technologies such as Pug and REST API, our coverage was quite extensive. However, most of the packages are very specific and tailored to our apps’ goals, so those topics were given a brief introduction, with references for further learning. Here’s a list of topics we covered:

-   Node.js and npm setup and development tools
-   Web apps with Express.js
-   TDD with Mocha
-   Pug and Handlebars
-   MongoDB and Mongoskin
-   Mongoose MongoDB ORM
-   Session, token authentication, and OAuth with Everyauth
-   REST APIs with Express and Hapi
-   WebSockets with ws, Socket.IO, and DerbyJS
-   Best practices for getting apps production ready
-   Deployment to Heroku and AWS
-   Structuring and publishing npm modules
-   Node HTTP/2 Servers
-   Asynchronous Code in Node
-  Node Microservices with Docker and AWS ECS
- Serverless Node with AWS Lambda

Author Contacts
==============

If you enjoyed this reading, you might like my programming blog about software engineering, startups, JavaScript and Node.js: [webapplog.com](http://webapplog.com).  

I speak at conferences and publish online courses. I am not active on Instagram or Snapchat but I post regularly on YouTube, Twitter, Facebook, LinkedIn and Google+. Follow me, the author of this book, on Twitter at [@azatmardan](http://twitter.com/azatmardan) for tips and news about Node.js. And subscribe to me on YouTube, connect with me on LinkedIn, and friend me on Facebook. I posted all my social media links: <http://azat.co>.

Further Learning
===============

I wrote 16 books to date. Here's just the short list of my other related books:

- [*React Quickly*](http://bit.ly/1RbD6l6) (Manning, 2017)
- [*Pro Express.js*](http://amzn.to/1D6qiqk) (Apress, 2014)
- [*Full Stack JavaScript, 2nd Edition*](https://github.com/azat-co/fullstack-javascript) (Apress, 2018)
-  *Write Your Way to Success* (Apress, 2018)
-  *Using Your Web Skills to Make Money* (Apress, 2018)

If you don't have much time to read, like most of us, then check out my podcast on iTunes, Google Play and Stitcher. It's called Node University. You can find the links at <https://nodeuniversity.simplecast.fm>.

Lastly, you can supplement your reading with videos and coding exercises at Node University: <https://node.university>.

Errata and Contacts
===================

If you spotted any mistakes (I'm sure you did), please open an issue or even better fix it and make a pull request to the GitHub repository of the book's examples: <https://github.com/azat-co/practicalnode>. For all other updates and contact information, the home of the Practical Node.js book on the Internet is <http://practicalnodebook.com>.