/*
 * Match tag expressions against sets of Debtags items
 *
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <apt-front/cache/component/debtags/expression.h>
#include <apt-front/cache/component/debtags/serializer.h>

using namespace std;
using namespace aptFront;
using namespace cache;

namespace Tagcoll {

template<>
bool Expression::operator()(const OpSet<entity::Tag>& tags) const
{
	Converter<entity::Tag, std::string> conv;
	return this->m_impl->eval(conv(tags));
}

template<>
bool Expression::operator()(const OpSet<entity::Facet>& tags) const
{
	Converter<entity::Facet, std::string> conv;
	return this->m_impl->eval(conv(tags));
}

}

#ifndef INSTANTIATING_TEMPLATES
#include <string>

namespace Tagcoll {
//	template class Expression<Debtags::Tag>;
//	template class Expression<Debtags::Facet>;
}
#endif


#ifdef COMPILE_TESTSUITE

#include <apt-front/cache/component/tags.h>
#include <tests/test-utils.h>

namespace tut {

using namespace aptFront;

struct cache_component_debtags_expression_shar {
	cache_component_debtags_expression_shar() {
		aptInit();
		c.open( Cache::OpenDefault | Cache::OpenTags | Cache::OpenReadOnly );
	}
	Cache c;
};
TESTGRP(cache_component_debtags_expression);


template<> template<>
void to::test< 1 >()
{
	c.tags(); // this will throw if the open above didn't work
}

template<> template<>
void to::test< 2 >()
{
	using namespace Tagcoll;

	OpSet<entity::Tag> test;
	test += c.tags().tagByName("use::editing");
	test += c.tags().tagByName("use::viewing");
	test += c.tags().tagByName("works-with::text");

	ensure_equals(test.size(), 3);

	Expression e1("use::editing");
	ensure(e1(test));

	Expression e2("use::editing && use::viewing");
	ensure(e2(test));

	e1 = Expression("!use::editing");
	ensure(!e1(test));

	e1 = Expression("use::editing || sugo");
	ensure(e1(test));

	e1 = Expression("use::editing && !sugo");
	ensure(e1(test));

	e1 = Expression("use::editing && !use::viewing");
	ensure(!e1(test));

	e1 = Expression("(use::editing || sugo) && (use::viewing && works-with::text)");
	ensure(e1(test));

	e1 = Expression("!(use::editinuse::editingra && works-with::text)");
	ensure(e1(test));

	e1 = Expression("works-with::*");
	ensure(e1(test));

	e1 = Expression("*::text");
	ensure(e1(test));

	e1 = Expression("!*::farts");
	ensure(e1(test));

	e1 = Expression("*::farts");
	ensure(!e1(test));
}

}

#endif
// vim:set ts=4 sw=4:
