#include <apt-front/cache/component/debtags/update.h>
#include <apt-front/utils/vocabularymerger.h>
#include <apt-front/utils/zlibparserinput.h>
#include <apt-front/utils/paths.h>

#include <tagcoll/Filter.h>
#include <tagcoll/TextFormat.h>
#include <tagcoll/StdioParserInput.h>
#include <tagcoll/TDBIndexer.h>

#include <apt-pkg/acquire.h>
#include <apt-pkg/acquire-item.h>
#include <apt-pkg/strutl.h>
#include <apt-pkg/error.h>
#include <apt-pkg/configuration.h>

// TODO: see if we really need to invoke pkgInitConfig or if we can delegate
// that to the rest of aptFront.  Maybe reinstate the old APTFilter
#include <apt-pkg/init.h>

#if 0
#include "config.h"

#include <debtags/Tags.h>
#include <debtags/Vocabulary.h>
#include <debtags/VocabularyMerger.h>
#include <debtags/ZlibParserInput.h>

#include <tagcoll/OpSet.h>

#include <tagcoll/Filters.h>

#include <string>


#include <iostream>
#include <stdio.h>	// For the fprintf (FIXME: remove this, and the printfs)
// s/printfs/std::cerr/ -- mornfall
#endif
#include <sys/types.h>	// chmod
#include <sys/stat.h>	// chmod
#include <dirent.h>		// opendir, closedir
#include <errno.h>



using namespace std;
using namespace Tagcoll;
using namespace aptFront;

#if 0
static const char* fn_sources = "/etc/debtags/sources.list";
static const char* path_cache = "/var/cache/debtags";
//static const char* fn_dist_vocab = "/usr/share/debtags/vocabulary";
static const char* path_tagvoc_d = "/etc/debtags/tagvoc.d";
#endif

//fn_dist_vocab = '$(usr/share/debtags)'/vocabulary
//path_tagpatch_d = '$(sysconfigdir)'/debtags/tagpatch.d
//path_tagvoc_d = '$(sysconfigdir)'/debtags/tagvoc.d
//remote_tags_fname = tags-current.gz
//remote_vocab_fname = vocabulary.gz


// TagcollFilter that removes tags not in the given Vocabulary
class VocabularyFilter : public Tagcoll::Filter<string, string>
{
protected:
	utils::VocabularyMerger& voc;

	virtual void consumeItemUntagged(const std::string& item);
	virtual void consumeItem(const std::string& item, const OpSet<std::string>& tags);
	virtual void consumeItemsUntagged(const OpSet<string>& items);
	virtual void consumeItems(const OpSet<string>& items, const OpSet<string>& tags);
	
public:
	VocabularyFilter(utils::VocabularyMerger& voc) : voc(voc) {}
};

void VocabularyFilter::consumeItemUntagged(const string& item)
{
	consumer->consume(item);
}
void VocabularyFilter::consumeItemsUntagged(const OpSet<string>& items)
{
	consumer->consume(items);
}


void VocabularyFilter::consumeItem(const string& item, const OpSet<string>& tags)
{
	OpSet<string> patched;
	for (OpSet<string>::const_iterator i = tags.begin();
			i != tags.end(); i++)
		if (voc.hasTag(*i) && *i != "special::invalid-tag")
			patched += *i;
//		else
//			fprintf(stderr, "Removing tag %.*s not found in vocabulary (package %.*s)\n", PFSTR(*i), PFSTR(item));

	if (patched.size())
		consumer->consume(item, patched);
	else
		consumer->consume(item);
}

// Process a set of items identically tagged, with their tags
void VocabularyFilter::consumeItems(const OpSet<string>& items, const OpSet<string>& tags)
{
	OpSet<string> patched;
	for (OpSet<string>::const_iterator i = tags.begin();
			i != tags.end(); i++)
		if (voc.hasTag(*i) && *i != "special::invalid-tag")
			patched += *i;
			/*
		else
		{
			string pkglist;
			for (typename OpSet<ITEM>::const_iterator j = items.begin();
					j != items.end(); j++)
			{
				if (j == items.begin())
					pkglist += *j;
				else
					pkglist += ", " + *j;
			}
//			fprintf(stderr, "Removing tag %.*s not found in vocabulary (package%s %.*s)\n", PFSTR(*i), items.size() > 1 ? "s" : "", PFSTR(pkglist));
		}
			*/

	if (patched.size())
		consumer->consume(items, patched);
	else
		consumer->consume(items);
}


struct source
{
	enum type_t { TAGS };

	type_t type;
	string uri;
	source(type_t type, const std::string& uri) : type(type), uri(uri) {}
};

static void zreadCollection(const std::string& local, utils::VocabularyMerger& voc, Tagcoll::Consumer<string, string>& consumer)
{
	// Read data from local
	utils::ZlibParserInput in(local);

	FilterChain<string, string> filters;

	// Filter out tags not in voc
	VocabularyFilter vocFilter(voc);
	filters.appendFilter(vocFilter);

	filters.setConsumer(consumer);

	// Read the collection
	Converter<string, string> conv;
	TextFormat<string, string>::parse(conv, conv, in, filters);

	// Add packages only in APT as untagged
	// (unneeded as InputMerger already returns an empty tagset for non-existing items)
}

static void importData(
		const std::string& local,
		Tagcoll::Consumer<string, string>& consumer,
		utils::VocabularyMerger& systemvoc)
{
	zreadCollection(local, systemvoc, consumer);
}

static void importData(
		const std::string& local,
		const std::string& localVoc,
		Tagcoll::Consumer<string, string>& consumer,
		utils::VocabularyMerger& systemvoc)
{
	utils::VocabularyMerger voc;
	utils::ZlibParserInput in(localVoc);
	voc.read(in);

	zreadCollection(local, voc, consumer);

	// Merge vocabularies together
	utils::ZlibParserInput in2(localVoc);
	systemvoc.read(in2);
}

static void readBasicVocabularies(utils::VocabularyMerger& systemvoc)
{
	/*
	StdioParserInput mainInput(fn_dist_vocab);
	systemvoc.read(mainInput);
	*/
	
#if 0
	DIR* dir = opendir(path_tagvoc_d);
	if (!dir)
		throw SystemException(errno, string("reading directory ") + path_tagvoc_d);

	while (struct dirent* d = readdir(dir))
	{
		if (d->d_name[0] != '.' &&
				d->d_name[strlen(d->d_name) - 1] != '~')
		{
			string fn = string(path_tagvoc_d) + '/' + d->d_name;
			if (access(fn.c_str(), R_OK) == 0)
			{
				StdioParserInput patchInput(fn);
				systemvoc.read(patchInput);
			}
		}
	}
	closedir(dir);
#endif
}

static vector<source> readSources()
    // TODO: remove in favor of apt-pkg sources.list parser?
{
	FILE* in = fopen(utils::Path::debtagssources().c_str(), "rt");
	if (!in)
		return vector <source>();
		// throw FileException(errno, string("reading ") + fn_sources);

	vector<source> res;

	string line;
	int c;
	while ((c = fgetc(in)) != EOF)
	{
		if (c != '\n')
			line += c;
		else
		{
			unsigned int i = 0;

			// Skip leading spaces
			while (i < line.size() && isspace(line[i]))
				i++;

			// If it's a tag source
			if (line.substr(i, 4) == "tags")
			{
				i += 4;
				// Skip further spaces
				while (i < line.size() && isspace(line[i]))
					i++;
				res.push_back(source(source::TAGS, line.substr(i)));
			}
			
			/*
			// If it's a debtags source
			if (line.substr(i, 4) == "debtags")
			{
				i += 7;
				// Skip further spaces
				while (i < line.size() && isspace(line[i]))
					i++;
				res.push_back(source(source::DEBTAGS, line.substr(i)));
			}
			*/
			
			line = string();
		}
	}

	fclose(in);

	return res;
}

// Item class for index files
class AcqTagfile: public pkgAcquire::Item
{
protected:
	pkgAcquire::ItemDesc Desc;
	string RealURI;

public:

	// Specialized action members
	virtual void Done(string Message,unsigned long Size,string Md5Hash,
			pkgAcquire::MethodConfig *Cnf);
	virtual string DescURI() {return RealURI + ".gz";};

	AcqTagfile(pkgAcquire *Owner,string URI,string URIDesc,
			string ShortDesct);
};

// AcqTagfile::AcqTagfile - Constructor                                     
// ---------------------------------------------------------------------
/* The package file is added to the queue and a second class is
   instantiated to fetch the revision file */
AcqTagfile::AcqTagfile(pkgAcquire *Owner,
                         string URI,string URIDesc,string ShortDesc) :
	Item(Owner), RealURI(URI)
{
	//fprintf(stderr, "AcqTagfile::AcqTagfile ('%.*s') called\n", PFSTR(URI));

	DestFile = utils::Path::downloadcache() + "/partial/"; //_config->FindDir("Dir::State::lists") + "partial/";
	DestFile += URItoFileName(URI);
	//fprintf(stderr, "DestFile: %.*s\n", PFSTR(DestFile));

	// Create the item
	Desc.URI = URI;
	Desc.Description = URIDesc;
	Desc.Owner = this;
	Desc.ShortDesc = ShortDesc;

	QueueURI(Desc);
}
                                                                        
// AcqTagfile::Done - Finished a fetch                                 
// ---------------------------------------------------------------------
/* This goes through a number of states.. On the initial fetch the
   method could possibly return an alternate filename which points
   to the uncompressed version of the file. If this is so the file
   is copied into the partial directory. In all other cases the file
   is decompressed with a gzip uri. */
void AcqTagfile::Done(string Message,unsigned long Size,string MD5,
                       pkgAcquire::MethodConfig *Cfg)
{
	Item::Done(Message,Size,MD5,Cfg);
	//fprintf(stderr, "AcqTagfile::Done (%.*s) called.\n", PFSTR(Message));

    /* if (MD5.empty())
    {
       MD5Summation sum;
       FileFd Fd(DestFile, FileFd::ReadOnly);
       sum.AddFD(Fd.Fd(), Fd.Size());
       Fd.Close();
       MD5 = (string)sum.Result();
    } */

	// Done, move it into position
	//string FinalFile = _config->FindDir("Dir::State::lists") + "tags/";
	string FinalFile = utils::Path::downloadcache();
	FinalFile += "/" + URItoFileName(RealURI);
	//fprintf(stderr, "FinalFile: %.*s\n", PFSTR(FinalFile));
	// TODO: replace this by a properly checked rename
	//Rename(DestFile,FinalFile);
	if (access(DestFile.c_str(), R_OK) != -1)
	{
//		fprintf(stderr, "%.*s -> %.*s\n",
//				PFSTR(DestFile), PFSTR(FinalFile));
		if (rename(DestFile.c_str(), FinalFile.c_str()) == -1)
			throw FileException(errno, "renaming " + DestFile + " to " + FinalFile);
		chmod(FinalFile.c_str(),0644);
	} else
		fprintf(stderr, "Skipping rename of %.*s\n", PFSTR(DestFile));

	/* We restore the original name to DestFile so that the clean operation
	   will work OK */
	//DestFile = _config->FindDir("Dir::State::lists") + "partial/";
	//DestFile += URItoFileName(RealURI);
	//fprintf(stderr, "DestFile: %.*s\n", PFSTR(DestFile));

	// Remove the compressed version.
	//if (erase == true)
		//unlink(DestFile.c_str());
	return;

/*
   erase = false;
   Complete = true;

   // Handle the unzipd case
   string FileName = LookupTag(Message,"Alt-Filename");
   if (FileName.empty() == false)
   {
      // The files timestamp matches
      if (StringToBool(LookupTag(Message,"Alt-IMS-Hit"),false) == true)
         return;

      decompression = true;
      Local = true;
      DestFile += ".decomp";
      Desc.URI = "copy:" + FileName;
      QueueURI(Desc);
      Mode = "copy";
      return;
   }
   FileName = LookupTag(Message,"Filename");
   if (FileName.empty() == true)
   {
      Status = StatError;
      ErrorText = "Method gave a blank filename";
   }

   // The files timestamp matches
   if (StringToBool(LookupTag(Message,"IMS-Hit"),false) == true)
      return;

   if (FileName == DestFile)
      erase = true;
   else
      Local = true;

   decompression = true;
   DestFile += ".decomp";
   Desc.URI = "gzip:" + FileName;
   QueueURI(Desc);
   Mode = "gzip";
*/
}

class basicAcquireStatus : public pkgAcquireStatus
{
public:
	virtual bool MediaChange(string Media,string Drive) { return true; }
	virtual void IMSHit(pkgAcquire::ItemDesc &/*Itm*/)
	{
		fprintf(stderr, "IMSHit\n");
	}
	virtual void Fetch(pkgAcquire::ItemDesc &/*Itm*/)
	{
		//fprintf(stderr, "Fetch\n");
	}
	virtual void Done(pkgAcquire::ItemDesc &/*Itm*/)
	{
		//fprintf(stderr, "Done\n");
	}
	virtual void Fail(pkgAcquire::ItemDesc &Itm)
	{
		fprintf(stderr, "Failed downloading from %.*s\n", PFSTR(Itm.URI));
		_error->DumpErrors();
	}
	/*
	virtual bool Pulse(pkgAcquire *Owner)
	{
		fprintf(stderr, "PULSE\n");
		return pkgAcquireStatus::Pulse(Owner);
	}
	virtual void Start()
	{
		fprintf(stderr, "START\n");
		pkgAcquireStatus::Start();
	}
	virtual void Stop()
	{
		fprintf(stderr, "STOP\n");
		pkgAcquireStatus::Stop();
	}
	*/
};

namespace aptFront {
namespace cache {
namespace component {
namespace debtags {

void updateDatabase()
{
	basicAcquireStatus status;
	updateDatabase(&status);
}

void updateDatabase(pkgAcquireStatus* status)
{
	if (!_config->Exists("Dir::State"))
	{
		// Need to read the libapt-pkg configuration...
		pkgInitConfig(*_config);
	}
	
	vector<source> sources = readSources();

	pkgAcquire fetcher(status);

	vector<AcqTagfile*> acquirers;
	// TODO: deallocate acquirers (or is pkgAcquire doing it?)
	for (vector<source>::const_iterator i = sources.begin();
			i != sources.end(); i++)
		switch (i->type)
		{
			case source::TAGS:
				acquirers.push_back(new AcqTagfile (&fetcher, i->uri + "tags-current.gz", i->uri + "tags-current.gz", "Tag database"));
				acquirers.push_back(new AcqTagfile (&fetcher, i->uri + "vocabulary.gz", i->uri + "vocabulary.gz", "Tag vocabulary"));
				break;
			/*
			case source::DEBTAGS:
				acquirers.push_back(new AcqTagfile (&fetcher, i->uri + "tags-current.gz", "", ""));
				acquirers.push_back(new AcqTagfile (&fetcher, i->uri + "vocabulary.gz", "", ""));
				break;
				*/
		}

	if (fetcher.Run() == pkgAcquire::Failed)
	{
		_error->DumpErrors();
		// FIXME: need a better message as soon as I understand what's going on
		throw ConsistencyCheckException("Acquirer failed");
	}

	for (pkgAcquire::ItemIterator it = fetcher.ItemsBegin (); it != fetcher.ItemsEnd (); it ++)
	{
		if ((*it)->Status == pkgAcquire::Item::StatDone)
			continue;
		(*it)->Finished();
		// TODO: warn user about failures
		// TODO: I would like to: how?
	}

    generateIndexes();

}

void generateIndexes()
{
	TDBIndexer<string, string> index;
	utils::VocabularyMerger voc;
	readBasicVocabularies(voc);
	vector<source> sources = readSources();

	int found = 0;
	for (vector<source>::const_iterator i = sources.begin();
			i != sources.end(); i++)
	{
		//fprintf(stderr, "Acquiring %s source %.*s...\n", i->type == source::TAGS ? "tags" : "debtags",
				//PFSTR(i->uri));

		try {
			//string local = _config->FindDir("Dir::State::lists") + "tags/";
			string local = utils::Path::downloadcache();
			local += "/" + URItoFileName(i->uri + "tags-current.gz");
			if (access(local.c_str(), R_OK) == -1)
			{
				fprintf(stderr, "Source %.*s has problems: ignoring it\n", PFSTR(i->uri));
                std::cerr << "tried file " << local << std::endl;
				continue;
			}

			//string localVoc = _config->FindDir("Dir::State::lists") + "tags/";
			string localVoc = utils::Path::downloadcache();
			localVoc += "/" + URItoFileName(i->uri + "vocabulary.gz");

			if (access(localVoc.c_str(), R_OK) == -1)
			{
				fprintf(stdout, "Reading tag data for %.*s...\n", PFSTR(i->uri));
				importData(local, index, voc);
			} else {
				fprintf(stdout, "Reading tag data and vocabulary for %.*s...\n", PFSTR(i->uri));
				importData(local, localVoc, index, voc);
			}

			found++;
		} catch (Exception& e) {
			fprintf(stderr, "%s: %.*s.  Ignoring source %.*s\n", e.type(), PFSTR(e.desc()), PFSTR(i->uri));
		}
	}

	if (!found)
	{
		_error->DumpErrors();
		throw ConsistencyCheckException("Unable to use any data source (not even previously cached ones)");
	}

	// Write the merged vocabulary
	fprintf(stdout, "Writing system vocabulary...\n");
	string vocfname = utils::Path::vocabulary();
	string tmpvocfname = vocfname + ".tmp";
	string vocidxfname = utils::Path::vocabularyIndex();
	string tmpvocidxfname = vocidxfname + ".tmp";
	voc.write(tmpvocfname);
	voc.writeIndex(tmpvocidxfname);

	// Write the tag database in text format
	fprintf(stdout, "Writing merged tag database...\n");
	string tagdb = utils::Path::tagdb();
	string tagdbpkgidx(utils::Path::tagdbIndexpkg());
	string tagdbtagidx(utils::Path::tagdbIndextag());
	string tmpdb = tagdb + ".tmp";
	string tmpdbpkgidx = tagdbpkgidx + ".tmp";
	string tmpdbtagidx = tagdbtagidx + ".tmp";
	FILE* out = fopen(tmpdb.c_str(), "wt");
	if (!out) throw FileException(errno, "opening " + tmpdb);
	Converter<string, string> conv;
	TextFormat<string, string> writer(conv, conv, out);
	index.output(writer);
	fclose(out);
	index.writeIndex(conv, conv, tmpdbpkgidx, tmpdbtagidx);

	// Perform atomic update of the tag database
	if (rename(tmpdb.c_str(), tagdb.c_str()) == -1)
		throw FileException(errno, "renaming " + tmpdb + " to " + tagdb);
	if (rename(tmpdbpkgidx.c_str(), tagdbpkgidx.c_str()) == -1)
		throw FileException(errno, "renaming " + tmpdbpkgidx + " to " + tagdbpkgidx);
	if (rename(tmpdbtagidx.c_str(), tagdbtagidx.c_str()) == -1)
		throw FileException(errno, "renaming " + tmpdbtagidx + " to " + tagdbtagidx);
	if (rename(tmpvocfname.c_str(), vocfname.c_str()) == -1)
		throw FileException(errno, "renaming " + tmpvocfname + " to " + vocfname);
	if (rename(tmpvocidxfname.c_str(), vocidxfname.c_str()) == -1)
		throw FileException(errno, "renaming " + tmpvocidxfname + " to " + vocidxfname);
}

/*
				// Prepare the input filter chain
				FilterChain<string> filters;

				// Build the patch list
				PatchList patches;
				int patchCount = 0;
				DIR* dir = opendir(path_tagpatch_d);
				if (!dir)
					throw SystemException(errno, string("reading directory ") + path_tagpatch_d);
				while (struct dirent* d = readdir(dir))
				{
					if (d->d_name[0] != '.' &&
							d->d_name[strlen(d->d_name) - 1] != '~')
					{
						string fn = string(path_tagpatch_d) + '/' + d->d_name;
						if (access(fn.c_str(), R_OK) == 0)
						{
							readCollection(fn, patches);
							patchCount++;
						}
					}
				}
				closedir(dir);


				// Prepare applying the patches
				if (patchCount)
					filters.appendFilter(new ApplyPatches(patches));

				ImplicationList implications;
				DerivedTagList derivedTags;

				voc.outputImplications(implications);
				voc.outputDerivedTags(derivedTags);

				implications.pack();

				// Prepare packing the database data

				// Expand implications
				filters.appendFilter(new ApplyImplications(implications));
				// Remove derived tags computing them using the expanded tag set
				filters.appendFilter(new CompressDerivedTags(derivedTags));
				// Compress implications
				filters.appendFilter(new CompressImplications(implications));
*/

}
}
}
}

// vim:set ts=4 sw=4:
