/**
 * @file cache/component/packages.cpp
 * @author Peter Rockai <me@mornfall.net>
 */
#include <apt-front/cache/component/packages.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/error.h>

using namespace aptFront;
using namespace cache;

int component::Packages::hashSize ()
{
    return sizeof (HeaderP->HashTable) / sizeof (HeaderP->HashTable[0]);
}

entity::Package component::Packages::packageByName( const std::string& n ) {
    return FindPkg( n );
}
/* List<PackageIterator> PackageCache::packageList() {
    return List<PackageIterator>( PackageIterator( PkgBegin() ) );
    } */


component::Packages::~Packages()
{
    delete &Map;
}

component::Packages::Packages( MMap *Map, bool DoMap )
    : pkgCache( Map, DoMap )
{
    m_data.resize( packageCount() );
}

#ifdef COMPILE_TESTSUITE
#include <apt-pkg/progress.h>
#include "test-utils.h"

namespace tut {

struct cache_component_packages_shar {
    cache_component_packages_shar () {
        aptInit ();
        c.open( Cache::OpenDefault | Cache::OpenReadOnly );
    }
    cache::Cache c;
    OpProgress progress;
};
TESTGRP( cache_component_packages );

template<> template<>
void to::test<1> ()
{
    /* cf.Open( progress, false );
    _error->DumpErrors();
    // std::cerr << std::endl << "package count: " << cf . pkgCache () -> HeaderP -> PackageCount;
    ensure_equals( cf.packageCache()->packageCount(), 19113 ); */
}

template<> template<>
void to::test<2> ()
{
    std::set<cache::entity::Package> v;
    std::set<cache::entity::Package>::iterator i;
    // c.packageCache().packages( inserter( v, v.begin() ) );
    /* std::copy( c.packageCache().packagesBegin(),
               c.packageCache().packagesEnd(),
               inserter( v, v.begin() )); */
    component::Packages::iterator j;
    int x = 0;
    for (j = c.packages().packagesBegin();
         j != c.packages().packagesEnd();
         ++ j) {
        /* if (x == 0 || x > 19100) {
            std::cerr << "pkg(" << x << "): ";
            std::cerr << j->name() << std::endl;
            } */
        ensure( x <= c.packages().packageCount() );
        ++ x;
    }
    // std::cerr << "x = " << x << ", count = " << c.packageCache().packageCount() << std::endl;
    ensure_equals( x, c.packages().packageCount() );
    /* filter::erase_if( 
        v, filter::Description<cache::entity::Package>(
        "exim4" )); */
    /* for (i = v.begin(); i != v.end(); ++i) {
        ensure_equals( i->name(), "exim4-config" );
        } */
}

template<> template<>
void to::test<3> ()
{
    std::set<cache::entity::Package>::iterator i;
    std::set<cache::entity::Package> v(
        c.packages().packagesBegin(),
        c.packages().packagesEnd());
    int x = 0;
    for (i = v.begin(); i != v.end(); ++ i) {
        ensure( x <= c.packages().packageCount() );
        ++x;
    }
    ensure_equals( x, c.packages().packageCount() );
}

template<> template<>
void to::test<4> ()
{
    entity::Package p = c.packages().packageByName( "purring-foo" );
    ensure( p == entity::Package() );
}

}
#endif
