/** -*- C++ -*-
	@file init.h
	@author Peter Rockai <me@mornfall.net>
*/

#ifndef APTFRONT_INIT_H
#define APTFRONT_INIT_H
#include <vector>

namespace aptFront {

void init();

struct Init {
    typedef void (*Function)( void );
    typedef std::vector<Function> FunctionVector;
    static FunctionVector *s_functions;
    static bool s_globalDone;
    static bool s_done;
    Init( Function f ) {
        if (!s_functions)
            s_functions = new std::vector<Function>;
        s_functions->push_back( f );
    }
};

}

#endif
