// -*- mode: c++; indent-tabs-mode: t -*-

/** \file
 * libdebtags paths
 */
 
/*
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>, Peter Rockai <me@mornfall.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <unistd.h>		// access
#include "config.h"
#include <apt-front/utils/paths.h>
#include <apt-front/utils/paths.cpp.h>

using namespace aptFront;
using namespace utils;

Path &Path::instance() {
	if (!s_instance) {
		s_instance = new Path;
		instance().m_prefix = DEBTAGS_DB_DIR;
		instance().m_debtagsDownloadDir = DEBTAGSDOWNLOADDIR;
		instance().m_debtagsConfigDir = DEBTAGSCONFIGDIR;
	}
	return *s_instance;
}

int Path::access( const std::string &s, int m ) {
	return ::access( s.c_str(), m );
}

void Path::setStateDir( const std::string &s ) {
	instance().m_prefix = s;
}

void Path::setDebtagsDownloadDir( const std::string &s ) {
	instance().m_debtagsDownloadDir = s;
}

void Path::setDebtagsConfigDir( const std::string &s ) {
	instance().m_debtagsConfigDir = s;
}

std::string Path::stateDir() {
	return instance().m_prefix;
}

std::string Path::vocabulary() {
	return stateDir() + "/vocabulary";
}

std::string Path::vocabularyIndex() {
	return stateDir() + "/vocabulary.idx";
}

std::string Path::tagdb() {
	return stateDir() + "/package-tags";
}

std::string Path::tagdbIndexpkg() {
	return stateDir() + "/package-tags.idxpkg";
}

std::string Path::tagdbIndextag() {
	return stateDir() + "/package-tags.idxtag";
}

std::string Path::debtagssources() {
	return instance().m_debtagsConfigDir + "/sources.list";
}

std::string Path::downloadcache() {
	return instance().m_debtagsDownloadDir;
}

Path *Path::s_instance = 0;

// vim:set ts=4 sw=4:
