%module(directors="1") aptfront
%feature("director");

#define %shared(cl) %feature("unref") cl "unref_SharedBase ($this);"; \
%feature("ref") cl "ref_SharedBase ($this);";

%{
/* Put header files here (optional) */
#include <list>
#include <apt-pkg/depcache.h>
#include <apt-pkg/acquire.h>
#include <apt-front/error.h>
#include <apt-front/init.h>
#include <apt-front/cache.h>
#include <apt-front/cache/entity.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/entity/version.h>
#include <apt-front/cache/entity/package-state.h>
#include <apt-front/packagemanager.h>
#include <apt-front/progresscallback.h>
#include <apt-front/cache/component/packages.h>
#include <apt-front/shared.h>

using namespace aptFront; // probably a SWIG bug... *sigh*
%}

#define %aptfrontlist(cl)

#ifdef SWIGRUBY
%include "ruby.i"
#endif

#ifdef SWIGPYTHON
%include "python.i"
#endif

%include "std_string.i"

%include "/usr/include/apt-pkg/error.h"
%include "/usr/include/apt-pkg/progress.h"
%include "/usr/include/apt-pkg/pkgcache.h"

%include <apt-front/error.h>
%include <apt-front/init.h>
%include <apt-front/cache.h>
%include <apt-front/cache/entity.h>
%include <apt-front/cache/entity/package.h>
%include <apt-front/cache/entity/version.h>
%include <apt-front/cache/entity/package-state.h>
%include <apt-front/packagemanager.h>
%include <apt-front/cache/component/packages.h>

class pkgAcquire;
class pkgAcquireStatus;
%include <apt-front/shared.h>

%shared(aptFront::ProgressCallback)
%include <apt-front/progresscallback.h>

%include "../apt-front/packagemanager.h"
%template(SharedPtrProgressCallback) aptFront::SharedPtr<aptFront::ProgressCallback>;

// %shared(aptFront::TreeFactory)
// %include "../apt-front/treefactory.h"


%{
static void unref_SharedBase(aptFront::SharedBase *ptr) {
    fprintf(stderr, "_unref-ing: %p, rc = %d\n",
	        ptr, ptr->_get_refCount());
	ptr->_unref();
}
static void ref_SharedBase(aptFront::SharedBase *ptr) {
    fprintf(stderr, "_ref-ing: %p, rc = %d\n",
	        ptr, ptr->_get_refCount());
	ptr->_ref();
}
%}
