/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-script-loader.h
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_SCRIPT_LOADER_H
#define __UNITY_WEBAPPS_SCRIPT_LOADER_H

#define UNITY_WEBAPPS_TYPE_SCRIPT_LOADER			(unity_webapps_script_loader_get_type())
#define UNITY_WEBAPPS_SCRIPT_LOADER(obj)        	(G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_SCRIPT_LOADER, UnityWebappsScriptLoader))
#define UNITY_WEBAPPS_SCRIPT_LOADER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_SCRIPT_LOADER, UnityWebappsScriptLoaderClass))
#define UNITY_WEBAPPS_IS_SCRIPT_LOADER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_SCRIPT_LOADER))
#define UNITY_WEBAPPS_IS_SCRIPT_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_SCRIPT_LOADER))
#define UNITY_WEBAPPS_SCRIPT_LOADER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_SCRIPT_LOADER, UnityWebappsScriptLoaderClass))

#include<glib.h>

#include "unity-webapps-local-available-application.h"

typedef struct _UnityWebappsScriptLoaderPrivate UnityWebappsScriptLoaderPrivate;

typedef struct _UnityWebappsScriptLoader UnityWebappsScriptLoader;

struct _UnityWebappsScriptLoader {
	GObject object;

	UnityWebappsScriptLoaderPrivate *priv;
};

typedef struct _UnityWebappsScriptLoaderClass UnityWebappsScriptLoaderClass;

struct _UnityWebappsScriptLoaderClass
{
	GObjectClass parent_class;
};

GType unity_webapps_script_loader_get_type (void) G_GNUC_CONST;

UnityWebappsScriptLoader *unity_webapps_script_loader_new ();
gchar *unity_webapps_script_loader_get_userscript_contents (UnityWebappsScriptLoader *loader, UnityWebappsLocalAvailableApplication *application);

#endif /* __UNITY_WEBAPPS_SCRIPT_LOADER_H */