/*
 * unity-webapps-service-preinstalled-app.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include "unity-webapps-service-preinstalled-app.h"

static GHashTable *
unity_webapps_service_get_preinstalled_desktop_ids_by_webapp_id ()
{
  GHashTable *desktop_ids;
  
  desktop_ids = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, NULL);

  g_hash_table_insert (desktop_ids, "(Amazon, amazon.com)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.com)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, amazon.ca)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.ca)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, amazon.cn)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.cn)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, amazon.co.uk)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.co.uk)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, amazon.fr)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.fr)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, amazon.it)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.it)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, amazon.es)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.es)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, amazon.de)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Amazon, www.amazon.de)", "ubuntu-amazon-default.desktop");
  g_hash_table_insert (desktop_ids, "(Ubuntu One Music, one.ubuntu.com)", "UbuntuOneMusiconeubuntucom.desktop");
  
  return desktop_ids;
}

const gchar *
unity_webapps_service_get_preinstalled_app_desktop_id (const gchar *name, const gchar *domain)
{
  // Note this is static if refactoring :)
  static GHashTable *desktop_ids = NULL;
  gchar *webapp_id, *desktop_id;
  
  if (desktop_ids == NULL)
    {
      desktop_ids = unity_webapps_service_get_preinstalled_desktop_ids_by_webapp_id ();
    }
  
  webapp_id = g_strdup_printf("(%s, %s)", name, domain);
  desktop_id = g_hash_table_lookup (desktop_ids, webapp_id);

  g_free (webapp_id);
  
  return desktop_id;
}
