/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDOMWindow_h
#define JSDOMWindow_h

#include "JSDOMWindowBase.h"
#include "DOMWindow.h"
namespace WebCore {

class DOMWindow;

class JSDOMWindowShell;

class JSDOMWindow : public JSDOMWindowBase {
    typedef JSDOMWindowBase Base;
public:
    JSDOMWindow(PassRefPtr<JSC::Structure>, PassRefPtr<DOMWindow>, JSDOMWindowShell*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    bool customGetOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValuePtr, JSC::PutPropertySlot&);
    bool customPut(JSC::ExecState*, const JSC::Identifier&, JSC::JSValuePtr, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValuePtr prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, JSC::ImplementsHasInstance | JSC::NeedsThisConversion));
    }

    virtual void mark();

    virtual bool deleteProperty(JSC::ExecState*, const JSC::Identifier&);
    virtual void getPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&);
    bool customGetPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&);
    virtual bool getPropertyAttributes(JSC::ExecState*, const JSC::Identifier&, unsigned& attributes) const;
    virtual void defineGetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* getterFunction);
    virtual void defineSetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* setterFunction);
    virtual JSC::JSValuePtr lookupGetter(JSC::ExecState*, const JSC::Identifier& propertyName);
    virtual JSC::JSValuePtr lookupSetter(JSC::ExecState*, const JSC::Identifier& propertyName);

    // Custom attributes
    void setLocation(JSC::ExecState*, JSC::JSValuePtr);

    // Custom functions
    JSC::JSValuePtr postMessage(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr setTimeout(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr clearTimeout(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr setInterval(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr clearInterval(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr atob(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr btoa(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr addEventListener(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValuePtr removeEventListener(JSC::ExecState*, const JSC::ArgList&);
    DOMWindow* impl() const
    {
        return static_cast<DOMWindow*>(Base::impl());
    }
};

DOMWindow* toDOMWindow(JSC::JSValuePtr);

class JSDOMWindowPrototype : public JSC::JSObject {
public:
    void* operator new(size_t);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValuePtr prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
    }
    JSDOMWindowPrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};

// Functions

JSC::JSValuePtr jsDOMWindowPrototypeFunctionGetSelection(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionFocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionBlur(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionClose(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionPrint(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionStop(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionAlert(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionConfirm(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionPrompt(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionFind(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionScrollBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionScrollTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionScroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionMoveBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionMoveTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionResizeBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionResizeTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionGetComputedStyle(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionGetMatchedCSSRules(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionOpenDatabase(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionPostMessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionSetTimeout(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionClearTimeout(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionSetInterval(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionClearInterval(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionAtob(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionBtoa(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionAddEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
JSC::JSValuePtr jsDOMWindowPrototypeFunctionRemoveEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr, const JSC::ArgList&);
// Attributes

JSC::JSValuePtr jsDOMWindowScreen(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowHistory(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowLocationbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLocationbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMenubar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMenubar(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowPersonalbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPersonalbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowScrollbars(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollbars(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowStatusbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStatusbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowToolbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowToolbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowNavigator(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNavigator(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowClientInformation(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClientInformation(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowLocation(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowFrameElement(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowOffscreenBuffering(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOffscreenBuffering(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOuterHeight(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOuterHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOuterWidth(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOuterWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowInnerHeight(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowInnerHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowInnerWidth(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowInnerWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowScreenX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenX(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowScreenY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenY(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowScreenLeft(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenLeft(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowScreenTop(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowScrollX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollX(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowScrollY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollY(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowPageXOffset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowPageYOffset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowClosed(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowLength(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLength(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowName(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowName(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDefaultStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDefaultStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDefaultstatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDefaultstatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSelf(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSelf(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowWindow(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowFrames(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFrames(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOpener(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOpener(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowParent(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowParent(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowTop(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDocument(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowDevicePixelRatio(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDevicePixelRatio(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowApplicationCache(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowSessionStorage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowLocalStorage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValuePtr jsDOMWindowConsole(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowConsole(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnabort(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnabort(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnblur(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnblur(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnchange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnclick(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOndblclick(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndblclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnerror(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnfocus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnfocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnkeydown(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeydown(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnkeypress(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeypress(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnkeyup(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeyup(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnmousedown(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousedown(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnmousemove(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousemove(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnmouseout(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseout(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnmouseover(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseover(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnmouseup(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseup(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnmousewheel(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousewheel(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnreset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnreset(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnresize(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnresize(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnscroll(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnscroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnsearch(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnsearch(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnselect(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnselect(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnsubmit(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnsubmit(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnunload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnbeforeunload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnbeforeunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnwebkitanimationstart(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnwebkitanimationiteration(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationiteration(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnwebkitanimationend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationend(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOnwebkittransitionend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkittransitionend(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowStyleSheetConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSValueListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSValueListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSImportRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSImportRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSPageRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSPageRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMediaListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMediaListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCounterConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCounterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCSSRuleListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSRuleListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowRectConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowStyleSheetListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStyleSheetListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDOMExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDOMStringListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMStringListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDOMImplementationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMImplementationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDocumentFragmentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentFragmentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowNodeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowNodeListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowNamedNodeMapConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNamedNodeMapConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCharacterDataConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCharacterDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowAttrConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowAttrConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowTextConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCommentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCommentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCDATASectionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCDATASectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDocumentTypeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowNotationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNotationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowEntityConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEntityConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowEntityReferenceConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEntityReferenceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowProcessingInstructionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowProcessingInstructionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLBRElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLDListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLDivElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDivElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLFontElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLFormElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFormElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLHRElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLImageElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLInputElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLInputElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLLIElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLIElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLMapElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMapElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLModElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLModElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLOListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLParamElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLParamElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLPreElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLPreElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTableElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLUListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLUListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLCollectionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowTextMetricsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextMetricsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowKeyboardEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowKeyboardEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMouseEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMouseEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMutationEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMutationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowOverflowEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOverflowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowProgressEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowProgressEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowTextEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowUIEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowUIEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowWheelEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWheelEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMessageEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMessageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowEventExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEventExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowClipboardConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClipboardConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowFileConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFileConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowFileListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFileListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowNodeFilterConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeFilterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowRangeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRangeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowRangeExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRangeExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowXMLDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowDOMParserConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMParserConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowXMLSerializerConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLSerializerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowPluginConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPluginConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowPluginArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPluginArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMimeTypeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMimeTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowStorageConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStorageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowStorageEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStorageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowMediaErrorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMediaErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowXPathResultConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXPathResultConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowXPathExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXPathExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGAngleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGColorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGGradientElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGLengthConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGPaintConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPaintConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGPathSegConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGTransformConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTransformConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);
JSC::JSValuePtr jsDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValuePtr);

} // namespace WebCore

#endif
