/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMimeType.h"

#include <wtf/GetPtr.h>

#include "JSPlugin.h"
#include "KURL.h"
#include "MimeType.h"
#include "Plugin.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMimeType)

/* Hash table */

static const HashTableValue JSMimeTypeTableValues[6] =
{
    { "type", DontDelete|ReadOnly, (intptr_t)jsMimeTypeType, (intptr_t)0 },
    { "suffixes", DontDelete|ReadOnly, (intptr_t)jsMimeTypeSuffixes, (intptr_t)0 },
    { "description", DontDelete|ReadOnly, (intptr_t)jsMimeTypeDescription, (intptr_t)0 },
    { "enabledPlugin", DontDelete|ReadOnly, (intptr_t)jsMimeTypeEnabledPlugin, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMimeTypeConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMimeTypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSMimeTypeTableValues, 0 };
#else
    { 16, 15, JSMimeTypeTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMimeTypeConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMimeTypeConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMimeTypeConstructorTableValues, 0 };
#else
    { 1, 0, JSMimeTypeConstructorTableValues, 0 };
#endif

class JSMimeTypeConstructor : public DOMObject {
public:
    JSMimeTypeConstructor(ExecState* exec)
        : DOMObject(JSMimeTypeConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSMimeTypePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSMimeTypeConstructor::s_info = { "MimeTypeConstructor", 0, &JSMimeTypeConstructorTable, 0 };

bool JSMimeTypeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMimeTypeConstructor, DOMObject>(exec, &JSMimeTypeConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSMimeTypePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMimeTypePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMimeTypePrototypeTableValues, 0 };
#else
    { 1, 0, JSMimeTypePrototypeTableValues, 0 };
#endif

const ClassInfo JSMimeTypePrototype::s_info = { "MimeTypePrototype", 0, &JSMimeTypePrototypeTable, 0 };

JSObject* JSMimeTypePrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSMimeType>(exec);
}

const ClassInfo JSMimeType::s_info = { "MimeType", 0, &JSMimeTypeTable, 0 };

JSMimeType::JSMimeType(PassRefPtr<Structure> structure, PassRefPtr<MimeType> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSMimeType::~JSMimeType()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSMimeType::createPrototype(ExecState* exec)
{
    return new (exec) JSMimeTypePrototype(JSMimeTypePrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSMimeType::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMimeType, Base>(exec, &JSMimeTypeTable, this, propertyName, slot);
}

JSValuePtr jsMimeTypeType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->type());
}

JSValuePtr jsMimeTypeSuffixes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->suffixes());
}

JSValuePtr jsMimeTypeDescription(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->description());
}

JSValuePtr jsMimeTypeEnabledPlugin(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MimeType* imp = static_cast<MimeType*>(static_cast<JSMimeType*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->enabledPlugin()));
}

JSValuePtr jsMimeTypeConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSMimeType*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSMimeType::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSMimeTypeConstructor>(exec);
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, MimeType* object)
{
    return getDOMObjectWrapper<JSMimeType>(exec, object);
}
MimeType* toMimeType(JSC::JSValuePtr value)
{
    return value->isObject(&JSMimeType::s_info) ? static_cast<JSMimeType*>(asObject(value))->impl() : 0;
}

}
