/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMouseEvent.h"

#include <wtf/GetPtr.h>

#include "Clipboard.h"
#include "EventTarget.h"
#include "JSClipboard.h"
#include "JSDOMWindow.h"
#include "JSEventTarget.h"
#include "JSEventTargetNode.h"
#include "JSNode.h"
#include "MouseEvent.h"
#include "Node.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMouseEvent)

/* Hash table */

static const HashTableValue JSMouseEventTableValues[19] =
{
    { "screenX", DontDelete|ReadOnly, (intptr_t)jsMouseEventScreenX, (intptr_t)0 },
    { "screenY", DontDelete|ReadOnly, (intptr_t)jsMouseEventScreenY, (intptr_t)0 },
    { "clientX", DontDelete|ReadOnly, (intptr_t)jsMouseEventClientX, (intptr_t)0 },
    { "clientY", DontDelete|ReadOnly, (intptr_t)jsMouseEventClientY, (intptr_t)0 },
    { "ctrlKey", DontDelete|ReadOnly, (intptr_t)jsMouseEventCtrlKey, (intptr_t)0 },
    { "shiftKey", DontDelete|ReadOnly, (intptr_t)jsMouseEventShiftKey, (intptr_t)0 },
    { "altKey", DontDelete|ReadOnly, (intptr_t)jsMouseEventAltKey, (intptr_t)0 },
    { "metaKey", DontDelete|ReadOnly, (intptr_t)jsMouseEventMetaKey, (intptr_t)0 },
    { "button", DontDelete|ReadOnly, (intptr_t)jsMouseEventButton, (intptr_t)0 },
    { "relatedTarget", DontDelete|ReadOnly, (intptr_t)jsMouseEventRelatedTarget, (intptr_t)0 },
    { "offsetX", DontDelete|ReadOnly, (intptr_t)jsMouseEventOffsetX, (intptr_t)0 },
    { "offsetY", DontDelete|ReadOnly, (intptr_t)jsMouseEventOffsetY, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsMouseEventX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsMouseEventY, (intptr_t)0 },
    { "fromElement", DontDelete|ReadOnly, (intptr_t)jsMouseEventFromElement, (intptr_t)0 },
    { "toElement", DontDelete|ReadOnly, (intptr_t)jsMouseEventToElement, (intptr_t)0 },
    { "dataTransfer", DontDelete|ReadOnly, (intptr_t)jsMouseEventDataTransfer, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMouseEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMouseEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSMouseEventTableValues, 0 };
#else
    { 65, 63, JSMouseEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMouseEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMouseEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMouseEventConstructorTableValues, 0 };
#else
    { 1, 0, JSMouseEventConstructorTableValues, 0 };
#endif

class JSMouseEventConstructor : public DOMObject {
public:
    JSMouseEventConstructor(ExecState* exec)
        : DOMObject(JSMouseEventConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSMouseEventPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSMouseEventConstructor::s_info = { "MouseEventConstructor", 0, &JSMouseEventConstructorTable, 0 };

bool JSMouseEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMouseEventConstructor, DOMObject>(exec, &JSMouseEventConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSMouseEventPrototypeTableValues[2] =
{
    { "initMouseEvent", DontDelete|Function, (intptr_t)jsMouseEventPrototypeFunctionInitMouseEvent, (intptr_t)15 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMouseEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMouseEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSMouseEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSMouseEventPrototype::s_info = { "MouseEventPrototype", 0, &JSMouseEventPrototypeTable, 0 };

JSObject* JSMouseEventPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSMouseEvent>(exec);
}

bool JSMouseEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMouseEventPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMouseEvent::s_info = { "MouseEvent", &JSUIEvent::s_info, &JSMouseEventTable, 0 };

JSMouseEvent::JSMouseEvent(PassRefPtr<Structure> structure, PassRefPtr<MouseEvent> impl)
    : JSUIEvent(structure, impl)
{
}

JSObject* JSMouseEvent::createPrototype(ExecState* exec)
{
    return new (exec) JSMouseEventPrototype(JSMouseEventPrototype::createStructure(JSUIEventPrototype::self(exec)));
}

bool JSMouseEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMouseEvent, Base>(exec, &JSMouseEventTable, this, propertyName, slot);
}

JSValuePtr jsMouseEventScreenX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenX());
}

JSValuePtr jsMouseEventScreenY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->screenY());
}

JSValuePtr jsMouseEventClientX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->clientX());
}

JSValuePtr jsMouseEventClientY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->clientY());
}

JSValuePtr jsMouseEventCtrlKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->ctrlKey());
}

JSValuePtr jsMouseEventShiftKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->shiftKey());
}

JSValuePtr jsMouseEventAltKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->altKey());
}

JSValuePtr jsMouseEventMetaKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->metaKey());
}

JSValuePtr jsMouseEventButton(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->button());
}

JSValuePtr jsMouseEventRelatedTarget(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->relatedTarget()));
}

JSValuePtr jsMouseEventOffsetX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->offsetX());
}

JSValuePtr jsMouseEventOffsetY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->offsetY());
}

JSValuePtr jsMouseEventX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->x());
}

JSValuePtr jsMouseEventY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->y());
}

JSValuePtr jsMouseEventFromElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->fromElement()));
}

JSValuePtr jsMouseEventToElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->toElement()));
}

JSValuePtr jsMouseEventDataTransfer(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MouseEvent* imp = static_cast<MouseEvent*>(static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->dataTransfer()));
}

JSValuePtr jsMouseEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSMouseEvent*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSMouseEvent::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSMouseEventConstructor>(exec);
}

JSValuePtr jsMouseEventPrototypeFunctionInitMouseEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMouseEvent::s_info))
        return throwError(exec, TypeError);
    JSMouseEvent* castedThisObj = static_cast<JSMouseEvent*>(asObject(thisValue));
    MouseEvent* imp = static_cast<MouseEvent*>(castedThisObj->impl());
    const UString& type = args.at(exec, 0)->toString(exec);
    bool canBubble = args.at(exec, 1)->toBoolean(exec);
    bool cancelable = args.at(exec, 2)->toBoolean(exec);
    DOMWindow* view = toDOMWindow(args.at(exec, 3));
    int detail = args.at(exec, 4)->toInt32(exec);
    int screenX = args.at(exec, 5)->toInt32(exec);
    int screenY = args.at(exec, 6)->toInt32(exec);
    int clientX = args.at(exec, 7)->toInt32(exec);
    int clientY = args.at(exec, 8)->toInt32(exec);
    bool ctrlKey = args.at(exec, 9)->toBoolean(exec);
    bool altKey = args.at(exec, 10)->toBoolean(exec);
    bool shiftKey = args.at(exec, 11)->toBoolean(exec);
    bool metaKey = args.at(exec, 12)->toBoolean(exec);
    unsigned short button = args.at(exec, 13)->toInt32(exec);
    EventTargetNode* relatedTarget = toEventTargetNode(args.at(exec, 14));

    imp->initMouseEvent(type, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedTarget);
    return jsUndefined();
}


}
