/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFEFloodElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEFloodElement.h"

#include <runtime/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEFloodElement)

/* Hash table */

static const HashTableValue JSSVGFEFloodElementTableValues[8] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEFloodElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEFloodElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEFloodElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEFloodElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEFloodElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEFloodElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEFloodElementStyle, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEFloodElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEFloodElementTableValues, 0 };
#else
    { 17, 15, JSSVGFEFloodElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGFEFloodElementPrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEFloodElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEFloodElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEFloodElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGFEFloodElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEFloodElementPrototype::s_info = { "SVGFEFloodElementPrototype", 0, &JSSVGFEFloodElementPrototypeTable, 0 };

JSObject* JSSVGFEFloodElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGFEFloodElement>(exec);
}

bool JSSVGFEFloodElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEFloodElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGFEFloodElement::s_info = { "SVGFEFloodElement", &JSSVGElement::s_info, &JSSVGFEFloodElementTable, 0 };

JSSVGFEFloodElement::JSSVGFEFloodElement(PassRefPtr<Structure> structure, PassRefPtr<SVGFEFloodElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFEFloodElement::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGFEFloodElementPrototype(JSSVGFEFloodElementPrototype::createStructure(JSSVGElementPrototype::self(exec)));
}

bool JSSVGFEFloodElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEFloodElement, Base>(exec, &JSSVGFEFloodElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGFEFloodElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(static_cast<JSSVGFEFloodElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEFloodElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(static_cast<JSSVGFEFloodElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEFloodElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(static_cast<JSSVGFEFloodElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEFloodElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(static_cast<JSSVGFEFloodElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEFloodElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(static_cast<JSSVGFEFloodElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEFloodElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(static_cast<JSSVGFEFloodElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEFloodElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(static_cast<JSSVGFEFloodElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsSVGFEFloodElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGFEFloodElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEFloodElement* castedThisObj = static_cast<JSSVGFEFloodElement*>(asObject(thisValue));
    SVGFEFloodElement* imp = static_cast<SVGFEFloodElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
