/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGTransform.h"

#include <wtf/GetPtr.h>

#include "JSSVGMatrix.h"
#include "SVGTransform.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTransform)

/* Hash table */

static const HashTableValue JSSVGTransformTableValues[5] =
{
    { "type", DontDelete|ReadOnly, (intptr_t)jsSVGTransformType, (intptr_t)0 },
    { "matrix", DontDelete|ReadOnly, (intptr_t)jsSVGTransformMatrix, (intptr_t)0 },
    { "angle", DontDelete|ReadOnly, (intptr_t)jsSVGTransformAngle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGTransformConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTransformTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGTransformTableValues, 0 };
#else
    { 9, 7, JSSVGTransformTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGTransformConstructorTableValues[8] =
{
    { "SVG_TRANSFORM_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_UNKNOWN, (intptr_t)0 },
    { "SVG_TRANSFORM_MATRIX", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_MATRIX, (intptr_t)0 },
    { "SVG_TRANSFORM_TRANSLATE", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_TRANSLATE, (intptr_t)0 },
    { "SVG_TRANSFORM_SCALE", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_SCALE, (intptr_t)0 },
    { "SVG_TRANSFORM_ROTATE", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_ROTATE, (intptr_t)0 },
    { "SVG_TRANSFORM_SKEWX", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_SKEWX, (intptr_t)0 },
    { "SVG_TRANSFORM_SKEWY", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_SKEWY, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTransformConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGTransformConstructorTableValues, 0 };
#else
    { 18, 15, JSSVGTransformConstructorTableValues, 0 };
#endif

class JSSVGTransformConstructor : public DOMObject {
public:
    JSSVGTransformConstructor(ExecState* exec)
        : DOMObject(JSSVGTransformConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSSVGTransformPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSSVGTransformConstructor::s_info = { "SVGTransformConstructor", 0, &JSSVGTransformConstructorTable, 0 };

bool JSSVGTransformConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTransformConstructor, DOMObject>(exec, &JSSVGTransformConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTransformPrototypeTableValues[14] =
{
    { "SVG_TRANSFORM_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_UNKNOWN, (intptr_t)0 },
    { "SVG_TRANSFORM_MATRIX", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_MATRIX, (intptr_t)0 },
    { "SVG_TRANSFORM_TRANSLATE", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_TRANSLATE, (intptr_t)0 },
    { "SVG_TRANSFORM_SCALE", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_SCALE, (intptr_t)0 },
    { "SVG_TRANSFORM_ROTATE", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_ROTATE, (intptr_t)0 },
    { "SVG_TRANSFORM_SKEWX", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_SKEWX, (intptr_t)0 },
    { "SVG_TRANSFORM_SKEWY", DontDelete|ReadOnly, (intptr_t)jsSVGTransformSVG_TRANSFORM_SKEWY, (intptr_t)0 },
    { "setMatrix", DontDelete|Function, (intptr_t)jsSVGTransformPrototypeFunctionSetMatrix, (intptr_t)1 },
    { "setTranslate", DontDelete|Function, (intptr_t)jsSVGTransformPrototypeFunctionSetTranslate, (intptr_t)2 },
    { "setScale", DontDelete|Function, (intptr_t)jsSVGTransformPrototypeFunctionSetScale, (intptr_t)2 },
    { "setRotate", DontDelete|Function, (intptr_t)jsSVGTransformPrototypeFunctionSetRotate, (intptr_t)3 },
    { "setSkewX", DontDelete|Function, (intptr_t)jsSVGTransformPrototypeFunctionSetSkewX, (intptr_t)1 },
    { "setSkewY", DontDelete|Function, (intptr_t)jsSVGTransformPrototypeFunctionSetSkewY, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGTransformPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGTransformPrototypeTableValues, 0 };
#else
    { 34, 31, JSSVGTransformPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGTransformPrototype::s_info = { "SVGTransformPrototype", 0, &JSSVGTransformPrototypeTable, 0 };

JSObject* JSSVGTransformPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSSVGTransform>(exec);
}

bool JSSVGTransformPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGTransformPrototype, JSObject>(exec, &JSSVGTransformPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGTransform::s_info = { "SVGTransform", 0, &JSSVGTransformTable, 0 };

JSSVGTransform::JSSVGTransform(PassRefPtr<Structure> structure, PassRefPtr<JSSVGPODTypeWrapper<SVGTransform> > impl, SVGElement* context)
    : DOMObject(structure)
    , m_context(context)
    , m_impl(impl)
{
}

JSSVGTransform::~JSSVGTransform()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGTransform::createPrototype(ExecState* exec)
{
    return new (exec) JSSVGTransformPrototype(JSSVGTransformPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSSVGTransform::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTransform, Base>(exec, &JSSVGTransformTable, this, propertyName, slot);
}

JSValuePtr jsSVGTransformType(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTransform imp(*static_cast<JSSVGTransform*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp.type());
}

JSValuePtr jsSVGTransformMatrix(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTransform imp(*static_cast<JSSVGTransform*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, JSSVGStaticPODTypeWrapperWithPODTypeParent<TransformationMatrix, SVGTransform>::create(imp.matrix(), static_cast<JSSVGTransform*>(asObject(slot.slotBase()))->impl()).get(), static_cast<JSSVGTransform*>(asObject(slot.slotBase()))->context());
}

JSValuePtr jsSVGTransformAngle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGTransform imp(*static_cast<JSSVGTransform*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp.angle());
}

JSValuePtr jsSVGTransformConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSSVGTransform*>(asObject(slot.slotBase()))->getConstructor(exec);
}
JSValuePtr JSSVGTransform::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSSVGTransformConstructor>(exec);
}

JSValuePtr jsSVGTransformPrototypeFunctionSetMatrix(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransform::s_info))
        return throwError(exec, TypeError);
    JSSVGTransform* castedThisObj = static_cast<JSSVGTransform*>(asObject(thisValue));
    JSSVGPODTypeWrapper<SVGTransform>* wrapper = castedThisObj->impl();
    SVGTransform imp(*wrapper);
    TransformationMatrix matrix = toSVGMatrix(args.at(exec, 0));

    imp.setMatrix(matrix);
    wrapper->commitChange(imp, castedThisObj->context());
    return jsUndefined();
}

JSValuePtr jsSVGTransformPrototypeFunctionSetTranslate(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransform::s_info))
        return throwError(exec, TypeError);
    JSSVGTransform* castedThisObj = static_cast<JSSVGTransform*>(asObject(thisValue));
    JSSVGPODTypeWrapper<SVGTransform>* wrapper = castedThisObj->impl();
    SVGTransform imp(*wrapper);
    float tx = args.at(exec, 0)->toFloat(exec);
    float ty = args.at(exec, 1)->toFloat(exec);

    imp.setTranslate(tx, ty);
    wrapper->commitChange(imp, castedThisObj->context());
    return jsUndefined();
}

JSValuePtr jsSVGTransformPrototypeFunctionSetScale(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransform::s_info))
        return throwError(exec, TypeError);
    JSSVGTransform* castedThisObj = static_cast<JSSVGTransform*>(asObject(thisValue));
    JSSVGPODTypeWrapper<SVGTransform>* wrapper = castedThisObj->impl();
    SVGTransform imp(*wrapper);
    float sx = args.at(exec, 0)->toFloat(exec);
    float sy = args.at(exec, 1)->toFloat(exec);

    imp.setScale(sx, sy);
    wrapper->commitChange(imp, castedThisObj->context());
    return jsUndefined();
}

JSValuePtr jsSVGTransformPrototypeFunctionSetRotate(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransform::s_info))
        return throwError(exec, TypeError);
    JSSVGTransform* castedThisObj = static_cast<JSSVGTransform*>(asObject(thisValue));
    JSSVGPODTypeWrapper<SVGTransform>* wrapper = castedThisObj->impl();
    SVGTransform imp(*wrapper);
    float angle = args.at(exec, 0)->toFloat(exec);
    float cx = args.at(exec, 1)->toFloat(exec);
    float cy = args.at(exec, 2)->toFloat(exec);

    imp.setRotate(angle, cx, cy);
    wrapper->commitChange(imp, castedThisObj->context());
    return jsUndefined();
}

JSValuePtr jsSVGTransformPrototypeFunctionSetSkewX(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransform::s_info))
        return throwError(exec, TypeError);
    JSSVGTransform* castedThisObj = static_cast<JSSVGTransform*>(asObject(thisValue));
    JSSVGPODTypeWrapper<SVGTransform>* wrapper = castedThisObj->impl();
    SVGTransform imp(*wrapper);
    float angle = args.at(exec, 0)->toFloat(exec);

    imp.setSkewX(angle);
    wrapper->commitChange(imp, castedThisObj->context());
    return jsUndefined();
}

JSValuePtr jsSVGTransformPrototypeFunctionSetSkewY(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGTransform::s_info))
        return throwError(exec, TypeError);
    JSSVGTransform* castedThisObj = static_cast<JSSVGTransform*>(asObject(thisValue));
    JSSVGPODTypeWrapper<SVGTransform>* wrapper = castedThisObj->impl();
    SVGTransform imp(*wrapper);
    float angle = args.at(exec, 0)->toFloat(exec);

    imp.setSkewY(angle);
    wrapper->commitChange(imp, castedThisObj->context());
    return jsUndefined();
}

// Constant getters

JSValuePtr jsSVGTransformSVG_TRANSFORM_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValuePtr jsSVGTransformSVG_TRANSFORM_MATRIX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValuePtr jsSVGTransformSVG_TRANSFORM_TRANSLATE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValuePtr jsSVGTransformSVG_TRANSFORM_SCALE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValuePtr jsSVGTransformSVG_TRANSFORM_ROTATE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValuePtr jsSVGTransformSVG_TRANSFORM_SKEWX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValuePtr jsSVGTransformSVG_TRANSFORM_SKEWY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(6));
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, JSSVGPODTypeWrapper<SVGTransform>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGTransform, JSSVGPODTypeWrapper<SVGTransform> >(exec, object, context);
}
SVGTransform toSVGTransform(JSC::JSValuePtr value)
{
    return value->isObject(&JSSVGTransform::s_info) ? (SVGTransform) *static_cast<JSSVGTransform*>(asObject(value))->impl() : SVGTransform();
}

}

#endif // ENABLE(SVG)
