package com.tildemh.debbug;

//import java.util.Locale;
//import java.util.ResourceBundle;

/**
 * Severity rating for a bug report
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: Severity.java,v 1.12 2003/09/30 08:52:11 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class Severity implements java.io.Serializable{

	private int severity;		// integer representation
	private String name;		// name 
	private String desc;		// resourceID for description

	/** 
	 * Creates a new severity rating
	 * @param severity unique id for the severity
	 * @param name the name of the severity
	 * @param desc resource id for severity description
	 */
	private Severity(int severity, String name, String desc){
		this.severity = severity;
		this.name = name;
		this.desc = desc;
	}

	public static transient Severity CRITICAL = new Severity(0, "critical", "Unrelated breakage; data loss; or security issues");
	public static transient Severity GRAVE = new Severity(1, "grave", "Makes the package (mostly) unusable");
	public static transient Severity SERIOUS = new Severity(2, "serious", "Violation of Debian policy, or RC issue");
	public static transient Severity IMPORTANT = new Severity(3, "important", "Major effect on usability");
	public static transient Severity DOES_NOT_BUILD = new Severity(4, "does-not-build", "An old severity");
	public static transient Severity NORMAL = new Severity(5, "normal", "Default value");
	public static transient Severity MINOR = new Severity(6, "minor", "Doesn't affect package's usefullness");
	public static transient Severity WISHLIST = new Severity(7, "wishlist", "Feature request, or bugs requiring major changes");
	public static transient Severity UNKNOWN = new Severity(8, "unknown", "debbuggtk doesn't know the severity yet");

	public static Severity fromValue(int val){
		switch (val){
			case 0: return CRITICAL;
			case 1: return GRAVE;
			case 2: return SERIOUS;
			case 3: return IMPORTANT;
			case 4: return DOES_NOT_BUILD;
			case 5: return NORMAL;
			case 6: return MINOR;
			case 7: return WISHLIST;
			default: return new Severity(-1, "Invalid", "Unknow Severity");
		}
	}

	public static Severity parse(String severity){
		if (severity.equals("critical")){
			return CRITICAL;
		}else if(severity.equals("grave")){
			return GRAVE;
		}else if (severity.equals("serious")){
			return SERIOUS;
		}else if (severity.equals("important")){
			return IMPORTANT;
		}else if (severity.equals("normal")){
			return NORMAL;
		}else if (severity.equals("minor")){
			return MINOR;
		}else if (severity.equals("wishlist")){
			return WISHLIST;
		}else{
			System.out.println( "ERROR: unable to parse severity \"" + severity + "\"." );
			return new Severity(-1, "unparsable - "+severity, "Unknown");
		}
	}

	/**
	 * @return true if two severities are equal
	 */
	public boolean equals ( Severity test ){
		return this.severity == test.getValue();
	}
	
	/** 
	 * @return internal representation of severity
	 */
	public int getValue(){
		return severity;
	}

	/**
	 * @return severity in words
	 */
	public String toString(){
		return name;
	}

	/**
	 * Returns a localised description of this deverity level
	 */
	public String getDesc(){
		return desc;
//		Locale currentLocale = Locale.getDefault();
  //  	ResourceBundle rb = ResourceBundle.getBundle("BTS_Strings",currentLocale);
	//	return rb.getString(desc);
	}
	
}
