package com.tildemh.debbug;

/**
 * Interface to receive notifications when a synchroniser thread makes progress. 
 * 
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: SynchroniserListener.java,v 1.3 2003/06/25 14:08:02 mark Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public interface SynchroniserListener{


	/**
	 * Called when the listings (without reports) are started to be downloaded
	 * @param count Number to be downloaded
	 */
	public void startListings(int count);

	/**
	 * Called when a listing is being updated
	 * @param number Listing number
	 * @param name Listing Name
	 */
	public void getListing(int number, String name);

	
	/**
	 * Called when the listings (with reports) are started to be downloaded
	 * @param count Number to be downloaded
	 */
	public void startFullListings(int count);

	/**
	 * Called when a listing is being updated
	 * @param number Listing number
	 * @param name Listing Name
	 */
	public void getFullListing(int number, String name);

	/**
	 * Called when starting to get the individual reports. Note that this
	 * includes ones set by addBug and also ones found in getFullListings
	 */
	public void startBugs(int count);

	/**
	 * called when a bug has been downloaded
	 */
	public void getBug(int number, int bugNumber);

	/** 
	 * called just before the synchroniser exits
	 */
	public void done();


	/**
	 * Called in the event of a listing not found or bug not found error message
	 */
	public void notFound(String item);
	
	/**
	 * Called in the event of a serverError
	 */
	public void serverError(ServerError e);
	
}
