
import org.qdwizard.Screen;
import org.qdwizard.Wizard;

import java.awt.Image;
import java.net.URL;
import java.util.Locale;

import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;
import junit.textui.TestRunner;

public class QDWizardTest2 extends TestCase {

	public static class Screen1 extends Screen {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jajuk.ui.wizard.Screen#getName()
		 */
		@Override
		public String getName() {
			return "Screen1";
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jajuk.ui.wizard.Screen#getDescription()
		 */
		@Override
		public String getDescription() {
			return "Screen1 description";
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.jajuk.ui.wizard.Screen#initUI()
		 */
		@Override
		public void initUI() {
			setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
			add(new JLabel("HOP"));
			final JSlider js = new JSlider(0,10,5);
			js.setToolTipText(""+js.getValue());
			js.addChangeListener(new ChangeListener() {
			
				public void stateChanged(ChangeEvent e) {
					if (js.getValue() == 6){
						setProblem("Value forbidden");
					}
					else{
						setProblem(null);
					}
				}
			
			});
			add(js);
		}

	}

	public static void main(String[] args) {
		TestRunner.run(QDWizardTest2.class);
	}

	public void testCreate() throws Exception {
		JFrame jf = new JFrame("Test");
		jf.setVisible(true);
		Image img = new ImageIcon(new URL(
				"http://www.joomla.fr/templates/cd_france/images/logo_red.png")).getImage();
		Wizard wizard = new Wizard("Test", Screen1.class, null, img, jf, Locale.GERMAN) {

			@Override
			public Class getPreviousScreen(Class arg0) {
				return null;
			}

			@Override
			public Class getNextScreen(Class arg0) {
				return null;
			}

			@Override
			public void finish() {
			}

		};
		wizard.show();

	}

}
