/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.jsf;

import java.util.*;

import xjavadoc.*;

import xdoclet.*;

/**
 * @author               <a href="mailto:markus.plattner at plattners.de">Markus Plattner</a>
 * @created              28. Juni 2004
 * @xdoclet.taghandler   namespace="FacesNavigation"
 */
public class NavigationTagsHandler extends XDocletTagSupport
{

    private JsfNavigationRule currentRule = null;
    private String  fromViewId = null;
    private HashMap rules = new HashMap();

    /**
     * @param template
     * @exception XDocletException
     * @doc.tag                     type="block"
     */
    public void forAllRules(String template) throws XDocletException
    {
        Collection viewRules = (Collection) rules.get(fromViewId);

        for (Iterator itr = viewRules.iterator(); itr.hasNext(); ) {
            currentRule = (JsfNavigationRule) itr.next();
            generate(template);
        }
    }

    /**
     * @return
     * @doc.tag   type="content"
     */
    public String fromView()
    {
        return this.fromViewId;
    }

    /**
     * @return
     * @doc.tag   type="content"
     */
    public String toView()
    {
        return this.currentRule.getToView();
    }

    /**
     * @return
     * @doc.tag   type="content"
     */
    public String outcome()
    {
        return this.currentRule.getOutcome();
    }


    /**
     * @param template
     * @exception XDocletException
     * @doc.tag                     type="block"
     */
    public void forAllViews(String template) throws XDocletException
    {
        Collection classes = getXJavaDoc().getSourceClasses();

        for (Iterator i = classes.iterator(); i.hasNext(); ) {
            XClass clazz = (XClass) i.next();

            setCurrentClass(clazz);
            if (DocletSupport.isDocletGenerated(getCurrentClass())) {
                continue;
            }
            if (hasRule(getCurrentClass())) {
                for (Iterator it = getCurrentClass().getDoc().getTags("jsf.navigation").iterator(); it.hasNext(); ) {
                    XTag tag = (XTag) it.next();
                    String fromView = tag.getAttributeValue("from");
                    String toView = tag.getAttributeValue("to");
                    String result = tag.getAttributeValue("result");
                    JsfNavigationRule rule = new JsfNavigationRule(fromView, result, toView);
                    Collection r = (Collection) rules.get(fromView);

                    if (r == null) {
                        r = new ArrayList();
                    }
                    r.add(rule);
                    rules.put(fromView, r);
                }
            }
        }
        for (Iterator it = rules.keySet().iterator(); it.hasNext(); ) {
            fromViewId = it.next().toString();
            generate(template);
        }
    }

    private boolean hasRule(XClass clazz)
    {
        return clazz.getDoc().hasTag("jsf.navigation", false);
    }

    /**
     * @created   28. Juni 2004
     */
    private class JsfNavigationRule
    {

        private String fromView = null;
        private String outcome = null;
        private String toView = null;

        public JsfNavigationRule(String fromView, String outcome, String toView)
        {
            this.fromView = fromView;
            this.outcome = outcome;
            this.toView = toView;
        }

        public String getFromView()
        {
            return fromView;
        }

        public String getOutcome()
        {
            return outcome;
        }

        public String getToView()
        {
            return toView;
        }

    }
}
