/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.BooleanExpr;
import com.jclark.xsl.expr.CloneableNodeIterator;
import com.jclark.xsl.expr.CloneableNodeIteratorImpl;
import com.jclark.xsl.expr.DelegateExprContext;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class FilterNodeIterator
extends DelegateExprContext
implements NodeIterator {
    private int pos = 0;
    private int lastPos = 0;
    private NodeIterator iter;
    private final BooleanExpr predicate;

    FilterNodeIterator(NodeIterator iter, ExprContext origContext, BooleanExpr predicate) {
        super(origContext);
        this.iter = iter;
        this.predicate = predicate;
    }

    public Node next() throws XSLException {
        Node tem;
        while ((tem = this.iter.next()) != null) {
            ++this.pos;
            if (!this.predicate.eval(tem, this)) continue;
            return tem;
        }
        return null;
    }

    public int getPosition() {
        return this.pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPosition() throws XSLException {
        if (this.lastPos == 0) {
            CloneableNodeIterator cloneIter = this.iter instanceof CloneableNodeIterator ? (CloneableNodeIterator)this.iter : new CloneableNodeIteratorImpl(this.iter);
            this.iter = (NodeIterator)cloneIter.clone();
            int savePosition = this.pos;
            try {
                while (this.next() != null) {
                }
                this.lastPos = this.pos;
            }
            finally {
                this.pos = savePosition;
                this.iter = cloneIter;
            }
        }
        return this.lastPos;
    }
}

