/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.Converter;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleNodeSetExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function;
import com.jclark.xsl.expr.KeyValuesTable;
import com.jclark.xsl.expr.MergeNodeIterator;
import com.jclark.xsl.expr.NodeSetExpr;
import com.jclark.xsl.expr.NullNodeIterator;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.expr.UnionNodeIterator;
import com.jclark.xsl.expr.Variant;
import com.jclark.xsl.expr.VariantExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class KeyFunction
implements Function {
    KeyFunction() {
    }

    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] e, Node exprNode) throws ParseException {
        if (e.length != 2) {
            throw new ParseException("Key function:: expected two argument's");
        }
        final ConvertibleStringExpr se = e[0].makeStringExpr();
        final NamespacePrefixMap prefixMap = exprNode.getNamespacePrefixMap();
        if (e[1] instanceof NodeSetExpr) {
            final NodeSetExpr nse = (NodeSetExpr)((Object)e[1]);
            return new ConvertibleNodeSetExpr(){

                public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                    Name keyName = prefixMap.expandAttributeName(se.eval(node, context), node);
                    return KeyFunction.getKeyedNodes(keyName, node, nse.eval(node, context), context);
                }
            };
        }
        if (e[1] instanceof VariantExpr) {
            final VariantExpr ve = (VariantExpr)((Object)e[1]);
            return new ConvertibleNodeSetExpr(){

                public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                    Name keyName = prefixMap.expandAttributeName(se.eval(node, context), node);
                    Variant v = ve.eval(node, context);
                    if (v.isNodeSet()) {
                        return KeyFunction.getKeyedNodes(keyName, node, v.convertToNodeSet(), context);
                    }
                    return KeyFunction.getKeyedNodes(keyName, node, v.convertToString(), context);
                }
            };
        }
        final ConvertibleStringExpr kvStrExpr = e[1].makeStringExpr();
        return new ConvertibleNodeSetExpr(){

            public NodeIterator eval(Node node, ExprContext context) throws XSLException {
                Name keyName = prefixMap.expandAttributeName(se.eval(node, context), node);
                return KeyFunction.getKeyedNodes(keyName, node, kvStrExpr.eval(node, context), context);
            }
        };
    }

    private static final NodeIterator getKeyedNodes(Name keyName, Node refNode, String keyValue, ExprContext context) throws XSLException {
        KeyValuesTable kvt = context.getKeyValuesTable(keyName, refNode);
        if (kvt == null) {
            return new NullNodeIterator();
        }
        return kvt.get(keyValue);
    }

    private static final NodeIterator getKeyedNodes(Name keyName, Node refNode, NodeIterator keyValues, ExprContext context) throws XSLException {
        Node tem;
        NodeIterator[] iters = new NodeIterator[10];
        int length = 0;
        while ((tem = keyValues.next()) != null) {
            if (length == iters.length) {
                NodeIterator[] oldIters = iters;
                iters = new NodeIterator[oldIters.length * 2];
                System.arraycopy(oldIters, 0, iters, 0, oldIters.length);
            }
            iters[length++] = KeyFunction.getKeyedNodes(keyName, refNode, Converter.toString(tem), context);
        }
        switch (length) {
            case 0: {
                return new NullNodeIterator();
            }
            case 1: {
                return iters[0];
            }
            case 2: {
                return new UnionNodeIterator(iters[0], iters[1]);
            }
        }
        return new MergeNodeIterator(iters, length);
    }
}

