#!/bin/bash
# Copyright 2018 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# Updates java_sources.gni with java files found in src/src
cd third_party/feed/
if ! [[ `pwd` =~ .*third_party/feed$ ]]; then
  echo "Not in third_party/feed directory: `pwd`"
  exit 1
fi
rm java_sources.gni
echo "# Copyright 2018 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# Auto-generated by update_java_sources.sh
" >> java_sources.gni

echo "feed_lib_java_sources = [" >> java_sources.gni
find src -wholename "*.java" | grep -v test | env LC_COLLATE=en_US.ASCII sort |\
    sed 's/^\(.*\)$/  "\1",/g' >> java_sources.gni
echo "]
" >> java_sources.gni

echo "feed_conformance_test_lib_sources = [" >> java_sources.gni
find src/src/main/java/com/google/android/libraries/feed -wholename "*/common/testing/*.java" |\
    env LC_COLLATE=en_US.ASCII sort | sed 's/^\(.*\)$/  "\1",/g' >> java_sources.gni
find src/src/main/java/com/google/android/libraries/feed/testing/conformance -wholename "*.java" |\
    env LC_COLLATE=en_US.ASCII sort | sed 's/^\(.*\)$/  "\1",/g' >> java_sources.gni
echo "]" >> java_sources.gni
echo "java_sources.gni generated successfully"
