// -*-objc-*-

#import <objc/objc.h>
#import <Foundation/Foundation.h>

#import "RSSArticle.h"


enum RSSFeedError
  {
    RSSFeedErrorNoError = 0,
    RSSFeedErrorNoFetcherError,
    RSSFeedErrorMalformedURL,
    RSSFeedErrorDomainNotKnown,
    RSSFeedErrorServerNotReachable,
    RSSFeedErrorDocumentNotPresent,
    RSSFeedErrorMalformedRSS
  };


// dummy implementation for now...

@interface RSSFeed : NSObject <NSCoding>
{
  BOOL              dirty;
  NSMutableArray*   articles;
  enum RSSFeedError lastError;
  NSString*         feedName;
  id                fetcher;
}


-init;
-initWithFetcher: (id) aFetcher;

-(NSString*) description;

// NSCoding methods
-(id)initWithCoder: (NSCoder*)coder;
-(void)encodeWithCoder: (NSCoder*)coder;
// end of NSCoding methods


// get the document from the http server
-(void) setDirty;
-(enum RSSFeedError) fetch;
-(enum RSSFeedError) setError: (enum RSSFeedError) err;

// access to the articles
- (RSSArticle*) articleAtIndex: (int) index;
- (NSString*) headlineAtIndex: (int) index;
- (NSString*) urlAtIndex: (int) index;
- (NSString*) descriptionAtIndex: (int) index;
- (unsigned int) timeAtIndex: (int) index;
- (unsigned int) count;

// access to the preferences
- (NSString*) feedName;

@end

