
#include "ytree.h"
#include "tilde.h"
#include "xmalloc.h"


/***************************************************************************
 * InputStr                                                                *
 * Liest eine Zeichenkette an Position (y,x) mit der max. Laenge length    *
 * Vorschlagswert fuer die Eingabe ist s selbst                            *
 * Zurueckgegeben wird das Zeichen, mit dem die Eingabe beendet wurde      *
 ***************************************************************************/


int InputString(char *s, int y, int x, int cursor_pos, int length, char *term)
                               /* Ein- und Ausgabestring              */
                               /* Position auf Bildschirm             */
                               /* max. Laenge                         */
                               /* Menge von Terminierungszeichen      */
{
  int p;                       /* Aktuelle Position                   */
  int c1;                      /* Gelesenes Zeichen                   */
  int i;                       /* Laufvariable                        */
  char *pp;
  BOOL key_pressed = FALSE;
  char path[PATH_LENGTH + 1];

  static BOOL insert_flag = TRUE;

  /* Feld gefuellt ausgeben */
  /*------------------------*/
  print_time = FALSE;
  curs_set(1);
  MvAddStr( y, x, s );
  leaveok(stdscr, FALSE);
  
  for(i=strlen(s); i < length; i++)
    addch( '_' );


  p = cursor_pos;

  do  /* until termkey pressed */
  {
    wmove( stdscr, y, x+p );

    RefreshWindow( stdscr );
    doupdate();

    c1 = Getch();

    if( c1 >= ' ' && c1 < 0xff && c1 != 127 ) 
    {
      /* Darstellbares Zeichen */
      /*-----------------------*/

      if( key_pressed == FALSE && cursor_pos == 0 )
      {
	s[0] = '\0';
        
	move( y, x );
        for(i=0; i < length; i++)
          addch( '_' );
	move( y, x );
      }

      if( p < length )
      {
        /* Platz zum einfuegen vorhanden */
        /*-------------------------------*/

        if( insert_flag )
        {
          /* Restliche Zeichen eine Position vorruecken */
          /*--------------------------------------------*/

          if( strlen( s ) == length ) s[length-1] = '\0';
          for(i=strlen(s); i >= p; i-- )
            s[i+1] = s[i];
        }
        else
        {
          /* Simples ueberschreiben */
          /*------------------------*/

          if( s[p] == '\0' )
            s[p+1] = '\0';
        }

        s[p] = (char) c1;

        addstr( &s[p] );
        p++;
      }
      else
      {
        /* Zeile voll */
        /*------------*/

        beep();
      }
    }
    else
    {
      /* Steuerzeichen */
      /*---------------*/

      switch( c1 )
      {
        case 'C' & 0x1f     : c1 = -1; 
			      break;
        case -1             : break;

        case KEY_LEFT       : if( p > 0 )
                                p--;
                              else
                                beep();
                              break;
/*        case KEY_LEFT & 0x1f: if( p > 2 )
                                p-=3;
                              else
                                beep();
                              break;*/
        case KEY_RIGHT      : if( p < (int) strlen( s ) )
                                p++;
                              else
                                beep();
                              break;
/*        case KEY_RIGHT & 0x1f: if( p < (int) strlen( s ) - 3 )
                                p += 3;
                              else
                                beep();
                              break;*/
	case KEY_UP         : 
                             if(( pp = GetHistory()) == NULL) {
			       break;
			     }
                             if(*pp)
                             {
                               strncpy(s, pp, length);
			       s[length] = '\0';
			       p = strlen(s);
                               MvAddStr( y, x, s );
                               for(i=p; i < length; i++)
                                 addch( '_' );
                               RefreshWindow( stdscr );
                               doupdate();
                             }
                             break;

        case KEY_HOME       : p = 0;
                              break;
        case KEY_END        : p = strlen( s );
                              break;
        case KEY_DC         : if( p < (int) strlen( s ) )
                              {
                                (void) strcpy( s+p, s+p+1 );
                                printw( "%s_", s+p );
                              }
                              break;
	case 0x08           :
        case 0x7F           :
        case KEY_BACKSPACE  : if( p > 0 )
                              {
                                (void) strcpy( s+p-1, s+p );
                                printw( "\b%s_", s+p-1 );
                                p--;
                              }
                              else
                                beep();
                              break;
/*	case 0x08 & 0x1f          :
        case 0x7F & 0x1f          :
        case KEY_BACKSPACE & 0x1f : if( p > 1 )
                              {
			        beep(); 
                                (void) strcpy( s+p-1, s+p );
                                printw( "\b%s_", s+p-1 );
                                p -= 1;
                              }
                              else
                                beep();
                              break;*/
        case KEY_DL         : for(i=0; i < (int) strlen(s) - p; i++)
			        addch( '_' );
                              s[p] = '\0';
                              break;
	case KEY_EIC        :
        case KEY_IC         : insert_flag ^= TRUE; 
                              break;
	case '\t'           : if(( pp = GetMatches(s)) == NULL) {
			       break;
			     }
                             if(*pp)
                             {
                               strncpy(s, pp, length);
			       s[length] = '\0';
			       free(pp);
			       p = strlen(s);
                               MvAddStr( y, x, s );
                               for(i=p; i < length; i++)
                                 addch( '_' );
                               RefreshWindow( stdscr );
                               doupdate();
                             }
                             break;
#ifdef KEY_F
        case KEY_F(2)       : 
#endif
        case 'F' & 0x1f     : if(KeyF2Get( statistic.tree,
                                           statistic.disp_begin_pos,
                                           statistic.cursor_pos, path)) 
                              {
			        /* beep(); */
				break;
			      }
                              if(*path)
                              {
                                strncpy(s, path, length);
			        s[length] = '\0';
			        p = strlen(s);
                                MvAddStr( y, x, s );
                                for(i=p; i < length; i++)
                                  addch( '_' );
                                RefreshWindow( stdscr );
                                doupdate();
                              }
                              break;

        default             : if( c1 == LF ) c1 = CR;
                              if( !strrchr( term, c1 ) )
                                beep();
                              break;
      }
    }
    key_pressed = TRUE;
  } while( c1 != -1 && !strrchr( term, c1 ) );

  p = strlen( s );
  move( y, x + p );

  for(i=0; i < length - p; i++ )
   addch( ' ' );

  move( y, x );
  leaveok( stdscr, TRUE);
  curs_set(0);
  print_time = TRUE;
  InsHistory( s );
#ifdef READLINE_SUPPORT
  pp = tilde_expand(s);
#else
  pp = Strdup(s);
#endif

  strncpy( s, pp, length - 1);
  s[length]='\0';
  xfree(pp);
  return( c1 );
}





int InputChoise(char *msg, char *term)
{
  int  c;

  ClearHelp();

  curs_set(1);
  leaveok(stdscr, FALSE);
  mvprintw( LINES - 2, 1, msg );
  RefreshWindow( stdscr );
  doupdate();
  do
  {
    c = Getch();
    if(c >= 0)
      if( islower( c ) ) c = toupper( c );
  } while( c != -1 && !strchr( term, c ) );
  
  if(c >= 0)
    echochar( c );

  move( LINES - 2, 1 ); clrtoeol();
  leaveok(stdscr, TRUE);
  curs_set(0);

  return( c );
}





int GetTapeDeviceName( void )
{
  int  result;
  char path[PATH_LENGTH+1];

  result = -1;

  ClearHelp();

  (void) strcpy( path, statistic.tape_name );

  MvAddStr( LINES - 2, 1, "Tape-Device:" );
  if( InputString( path, LINES - 2, 14, 0, COLS - 15, "\r\033" ) == CR )
  {
    result = 0;
    (void) strcpy( statistic.tape_name, path );
  }

  move( LINES - 2, 1 ); clrtoeol();

  return( result );
}


void HitReturnToContinue(void)
{
#ifndef XCURSES
  curs_set(1);
  vidattr( A_REVERSE );
  putp( "[Hit return to continue]" );
  vidattr( 0 );
  (void) fflush( stdout );
  (void) Getch();
#endif /* XCURSES */
  curs_set(0);
  doupdate();
}



BOOL KeyPressed()
{
  BOOL pressed = FALSE;

#if !defined( linux ) || !defined( TERMCAP )
  nodelay( stdscr, TRUE );
  if( wgetch( stdscr ) != ERR ) pressed = TRUE;
  nodelay( stdscr, FALSE );
#endif /* linux/TERMCAP */

  return( pressed );
}


BOOL EscapeKeyPressed()
{
  BOOL pressed = FALSE;
  int  c;

#if !defined( linux ) || !defined( TERMCAP )
  nodelay( stdscr, TRUE );
  if( ( c = wgetch( stdscr ) ) != ERR ) pressed = TRUE;
  nodelay( stdscr, FALSE );
#endif /* linux/TERMCAP */

  return( ( pressed && c == ESC ) ? TRUE : FALSE );
}




#ifdef VI_KEYS

int ViKey( int ch )
{
  switch( ch )
  {
    case VI_KEY_UP:    ch = KEY_UP;    break;
    case VI_KEY_DOWN:  ch = KEY_DOWN;  break;
    case VI_KEY_RIGHT: ch = KEY_RIGHT; break;
    case VI_KEY_LEFT:  ch = KEY_LEFT;  break;
    case VI_KEY_PPAGE: ch = KEY_PPAGE; break;
    case VI_KEY_NPAGE: ch = KEY_NPAGE; break;
  }
  return(ch);
}

#endif /* VI_KEYS */

  
#ifdef _IBMR2
#undef wgetch

int AixWgetch( WINDOW *w )
{
  int c;
  
  if( ( c = wgetch( w ) ) == KEY_ENTER ) c = LF;

  return( c );
}

#endif


int Getch()
{
  int c;

  c = getch();

#ifdef KEY_RESIZE
  if(c == KEY_RESIZE) {
    resize_request = TRUE;
    c = -1;
  }
#endif

  return(c);
}

