/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AdapterNotFoundException;
import Ice.BooleanHolder;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorRegistryPrx;
import Ice.LocatorRegistryPrxHelper;
import Ice.NotRegisteredException;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.Util;
import IceInternal.DirectReference;
import IceInternal.EndpointI;
import IceInternal.IndirectReference;
import IceInternal.LocatorTable;
import IceInternal.Reference;

public final class LocatorInfo {
    private final LocatorPrx _locator;
    private LocatorRegistryPrx _locatorRegistry;
    private final LocatorTable _table;

    LocatorInfo(LocatorPrx locator, LocatorTable table) {
        this._locator = locator;
        this._table = table;
    }

    public synchronized void destroy() {
        this._locatorRegistry = null;
        this._table.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LocatorInfo) {
            return this._locator.equals(((LocatorInfo)obj)._locator);
        }
        return false;
    }

    public LocatorPrx getLocator() {
        return this._locator;
    }

    public synchronized LocatorRegistryPrx getLocatorRegistry() {
        if (this._locatorRegistry == null) {
            this._locatorRegistry = this._locator.getRegistry();
            this._locatorRegistry = LocatorRegistryPrxHelper.uncheckedCast(this._locatorRegistry.ice_locator(null));
        }
        return this._locatorRegistry;
    }

    public EndpointI[] getEndpoints(IndirectReference ref, BooleanHolder cached) {
        EndpointI[] endpoints = null;
        ObjectPrx object = null;
        cached.value = true;
        String adapterId = ref.getAdapterId();
        Identity identity = ref.getIdentity();
        try {
            if (adapterId.length() > 0) {
                endpoints = this._table.getAdapterEndpoints(adapterId);
                if (endpoints == null) {
                    cached.value = false;
                    object = this._locator.findAdapterById(adapterId);
                    if (object != null && (endpoints = ((ObjectPrxHelperBase)object).__reference().getEndpoints()).length > 0) {
                        this._table.addAdapterEndpoints(adapterId, endpoints);
                    }
                }
            } else {
                boolean objectCached = true;
                object = this._table.getProxy(identity);
                if (object == null) {
                    objectCached = false;
                    object = this._locator.findObjectById(identity);
                }
                boolean endpointsCached = true;
                if (object != null) {
                    Reference r = ((ObjectPrxHelperBase)object).__reference();
                    if (r instanceof DirectReference) {
                        endpointsCached = false;
                        DirectReference odr = (DirectReference)r;
                        endpoints = odr.getEndpoints();
                    } else {
                        IndirectReference oir = (IndirectReference)r;
                        if (oir.getAdapterId().length() > 0) {
                            BooleanHolder c = new BooleanHolder();
                            endpoints = this.getEndpoints(oir, c);
                            endpointsCached = c.value;
                        }
                    }
                }
                if (!objectCached && endpoints != null && endpoints.length > 0) {
                    this._table.addProxy(identity, object);
                }
                cached.value = objectCached || endpointsCached;
            }
        }
        catch (AdapterNotFoundException ex) {
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object adapter";
            e.id = adapterId;
            throw e;
        }
        catch (ObjectNotFoundException ex) {
            NotRegisteredException e = new NotRegisteredException();
            e.kindOfObject = "object";
            e.id = Util.identityToString(identity);
            throw e;
        }
        catch (NotRegisteredException ex) {
            throw ex;
        }
        catch (LocalException ex) {
            if (ref.getInstance().traceLevels().location >= 1) {
                StringBuffer s = new StringBuffer();
                s.append("couldn't contact the locator to retrieve adapter endpoints\n");
                if (adapterId.length() > 0) {
                    s.append("adapter = " + adapterId + "\n");
                } else {
                    s.append("object = " + Util.identityToString(identity) + "\n");
                }
                s.append("reason = " + ex);
                ref.getInstance().logger().trace(ref.getInstance().traceLevels().locationCat, s.toString());
            }
            throw ex;
        }
        if (ref.getInstance().traceLevels().location >= 1 && endpoints != null && endpoints.length > 0) {
            if (cached.value) {
                this.trace("found endpoints in locator table", ref, endpoints);
            } else {
                this.trace("retrieved endpoints from locator, adding to locator table", ref, endpoints);
            }
        }
        return endpoints == null ? new EndpointI[]{} : endpoints;
    }

    public void clearObjectCache(IndirectReference ref) {
        ObjectPrx object;
        if (ref.getAdapterId().length() == 0 && (object = this._table.removeProxy(ref.getIdentity())) != null) {
            if (((ObjectPrxHelperBase)object).__reference() instanceof IndirectReference) {
                IndirectReference oir = (IndirectReference)((ObjectPrxHelperBase)object).__reference();
                if (oir.getAdapterId().length() > 0) {
                    this.clearCache(oir);
                }
            } else if (ref.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table", ref, ((ObjectPrxHelperBase)object).__reference().getEndpoints());
            }
        }
    }

    public void clearCache(IndirectReference ref) {
        if (ref.getAdapterId().length() > 0) {
            EndpointI[] endpoints = this._table.removeAdapterEndpoints(ref.getAdapterId());
            if (endpoints != null && ref.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table\n", ref, endpoints);
            }
        } else {
            ObjectPrx object = this._table.removeProxy(ref.getIdentity());
            if (object != null) {
                if (((ObjectPrxHelperBase)object).__reference() instanceof IndirectReference) {
                    IndirectReference oir = (IndirectReference)((ObjectPrxHelperBase)object).__reference();
                    if (oir.getAdapterId().length() > 0) {
                        this.clearCache(oir);
                    }
                } else if (ref.getInstance().traceLevels().location >= 2) {
                    this.trace("removed endpoints from locator table", ref, ((ObjectPrxHelperBase)object).__reference().getEndpoints());
                }
            }
        }
    }

    private void trace(String msg, IndirectReference ref, EndpointI[] endpoints) {
        StringBuffer s = new StringBuffer();
        s.append(msg + "\n");
        if (ref.getAdapterId().length() > 0) {
            s.append("adapter = " + ref.getAdapterId() + "\n");
        } else {
            s.append("object = " + Util.identityToString(ref.getIdentity()) + "\n");
        }
        s.append("endpoints = ");
        int sz = endpoints.length;
        for (int i = 0; i < sz; ++i) {
            s.append(endpoints[i].toString());
            if (i + 1 >= sz) continue;
            s.append(":");
        }
        ref.getInstance().logger().trace(ref.getInstance().traceLevels().locationCat, s.toString());
    }
}

