/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.RouterPrx;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceUtil.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Reference
implements Cloneable {
    public static final int ModeTwoway = 0;
    public static final int ModeOneway = 1;
    public static final int ModeBatchOneway = 2;
    public static final int ModeDatagram = 3;
    public static final int ModeBatchDatagram = 4;
    public static final int ModeLast = 4;
    private Instance _instance;
    private Communicator _communicator;
    private int _mode;
    private Identity _identity;
    private Map _context;
    private static HashMap _emptyContext;
    private String _facet;
    private int _hashValue;
    private boolean _hashInitialized;
    private static EndpointComparator _endpointComparator;
    private static ConnectionComparator _connectionComparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public final int getMode() {
        return this._mode;
    }

    public final Identity getIdentity() {
        return this._identity;
    }

    public final String getFacet() {
        return this._facet;
    }

    public final Instance getInstance() {
        return this._instance;
    }

    public final Map getContext() {
        return this._context;
    }

    public final Reference defaultContext() {
        Reference r = this._instance.referenceFactory().copy(this);
        r._context = this._instance.getDefaultContext();
        return r;
    }

    public final Communicator getCommunicator() {
        return this._communicator;
    }

    public abstract boolean getSecure();

    public abstract String getAdapterId();

    public abstract EndpointI[] getEndpoints();

    public abstract boolean getCollocationOptimization();

    public final Reference changeContext(Map newContext) {
        if (newContext == null) {
            newContext = _emptyContext;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._context = newContext.isEmpty() ? _emptyContext : new HashMap(newContext);
        return r;
    }

    public final Reference changeMode(int newMode) {
        if (newMode == this._mode) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._mode = newMode;
        return r;
    }

    public final Reference changeIdentity(Identity newIdentity) {
        if (newIdentity.equals(this._identity)) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._identity = (Identity)newIdentity.clone();
        return r;
    }

    public final Reference changeFacet(String newFacet) {
        if (newFacet.equals(this._facet)) {
            return this;
        }
        Reference r = this._instance.referenceFactory().copy(this);
        r._facet = newFacet;
        return r;
    }

    public abstract Reference changeSecure(boolean var1);

    public abstract Reference changeRouter(RouterPrx var1);

    public abstract Reference changeLocator(LocatorPrx var1);

    public abstract Reference changeCompress(boolean var1);

    public abstract Reference changeTimeout(int var1);

    public abstract Reference changeConnectionId(String var1);

    public abstract Reference changeCollocationOptimization(boolean var1);

    public abstract Reference changeAdapterId(String var1);

    public abstract Reference changeEndpoints(EndpointI[] var1);

    public final synchronized int hashCode() {
        int i;
        if (this._hashInitialized) {
            return this._hashValue;
        }
        int h = this._mode;
        int sz = this._identity.name.length();
        for (i = 0; i < sz; ++i) {
            h = 5 * h + this._identity.name.charAt(i);
        }
        sz = this._identity.category.length();
        for (i = 0; i < sz; ++i) {
            h = 5 * h + this._identity.category.charAt(i);
        }
        h = 5 * h + ((Object)this._context.entrySet()).hashCode();
        sz = this._facet.length();
        for (i = 0; i < sz; ++i) {
            h = 5 * h + this._facet.charAt(i);
        }
        this._hashValue = h = 5 * h + (this.getSecure() ? 1 : 0);
        this._hashInitialized = true;
        return h;
    }

    public void streamWrite(BasicStream s) {
        if (this._facet.length() == 0) {
            s.writeStringSeq(null);
        } else {
            String[] facetPath = new String[]{this._facet};
            s.writeStringSeq(facetPath);
        }
        s.writeByte((byte)this._mode);
        s.writeBool(this.getSecure());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        String id = Util.identityToString(this._identity);
        if (StringUtil.findFirstOf(id, " \t\n\r:@") != -1) {
            s.append('\"');
            s.append(id);
            s.append('\"');
        } else {
            s.append(id);
        }
        if (this._facet.length() > 0) {
            s.append(" -f ");
            String fs = StringUtil.escapeString(this._facet, "");
            if (StringUtil.findFirstOf(fs, " \t\n\r:@") != -1) {
                s.append('\"');
                s.append(fs);
                s.append('\"');
            } else {
                s.append(fs);
            }
        }
        switch (this._mode) {
            case 0: {
                s.append(" -t");
                break;
            }
            case 1: {
                s.append(" -o");
                break;
            }
            case 2: {
                s.append(" -O");
                break;
            }
            case 3: {
                s.append(" -d");
                break;
            }
            case 4: {
                s.append(" -D");
            }
        }
        if (this.getSecure()) {
            s.append(" -s");
        }
        return s.toString();
    }

    public abstract ConnectionI getConnection(BooleanHolder var1);

    public boolean equals(Object obj) {
        Reference r = (Reference)obj;
        if (this._mode != r._mode) {
            return false;
        }
        if (!this._identity.equals(r._identity)) {
            return false;
        }
        if (!((Object)this._context).equals(r._context)) {
            return false;
        }
        return this._facet.equals(r._facet);
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    protected Reference(Instance inst, Communicator communicator, Identity ident, Map ctx, String fac, int md) {
        if (!$assertionsDisabled && ident.name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ident.category == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && fac == null) {
            throw new AssertionError();
        }
        this._instance = inst;
        this._communicator = communicator;
        this._mode = md;
        this._identity = ident;
        this._context = ctx == null ? _emptyContext : ctx;
        this._facet = fac;
        this._hashInitialized = false;
    }

    protected EndpointI[] filterEndpoints(EndpointI[] allEndpoints) {
        EndpointI endpoint;
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        for (int i = 0; i < allEndpoints.length; ++i) {
            if (allEndpoints[i].unknown()) continue;
            endpoints.add(allEndpoints[i]);
        }
        switch (this._mode) {
            case 0: 
            case 1: 
            case 2: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    endpoint = (EndpointI)i.next();
                    if (!endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
            case 3: 
            case 4: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    endpoint = (EndpointI)i.next();
                    if (endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
        }
        Collections.shuffle(endpoints);
        if (this.getSecure()) {
            Iterator i = endpoints.iterator();
            while (i.hasNext()) {
                endpoint = (EndpointI)i.next();
                if (endpoint.secure()) continue;
                i.remove();
            }
        } else {
            Collections.sort(endpoints, _endpointComparator);
        }
        EndpointI[] arr = new EndpointI[endpoints.size()];
        endpoints.toArray(arr);
        return arr;
    }

    public ConnectionI[] filterConnections(ConnectionI[] allConnections) {
        ArrayList<ConnectionI> connections = new ArrayList<ConnectionI>(allConnections.length);
        switch (this._mode) {
            case 0: 
            case 1: 
            case 2: {
                int i;
                for (i = 0; i < allConnections.length; ++i) {
                    if (allConnections[i].endpoint().datagram()) continue;
                    connections.add(allConnections[i]);
                }
                break;
            }
            case 3: 
            case 4: {
                int i;
                for (i = 0; i < allConnections.length; ++i) {
                    if (!allConnections[i].endpoint().datagram()) continue;
                    connections.add(allConnections[i]);
                }
                break;
            }
        }
        Collections.shuffle(connections);
        if (this.getSecure()) {
            Iterator i = connections.iterator();
            while (i.hasNext()) {
                ConnectionI connection = (ConnectionI)i.next();
                if (connection.endpoint().secure()) continue;
                i.remove();
            }
        } else {
            Collections.sort(connections, _connectionComparator);
        }
        ConnectionI[] arr = new ConnectionI[connections.size()];
        connections.toArray(arr);
        return arr;
    }

    static {
        $assertionsDisabled = !Reference.class.desiredAssertionStatus();
        _emptyContext = new HashMap();
        _endpointComparator = new EndpointComparator();
        _connectionComparator = new ConnectionComparator();
    }

    static class ConnectionComparator
    implements Comparator {
        ConnectionComparator() {
        }

        public int compare(Object l, Object r) {
            ConnectionI lc = (ConnectionI)l;
            ConnectionI rc = (ConnectionI)r;
            boolean ls = lc.endpoint().secure();
            boolean rs = rc.endpoint().secure();
            if (ls && rs || !ls && !rs) {
                return 0;
            }
            if (!ls && rs) {
                return -1;
            }
            return 1;
        }
    }

    static class EndpointComparator
    implements Comparator {
        EndpointComparator() {
        }

        public int compare(Object l, Object r) {
            EndpointI le = (EndpointI)l;
            EndpointI re = (EndpointI)r;
            boolean ls = le.secure();
            boolean rs = re.secure();
            if (ls && rs || !ls && !rs) {
                return 0;
            }
            if (!ls && rs) {
                return -1;
            }
            return 1;
        }
    }
}

