/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import IceInternal.Acceptor;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TcpTransceiver;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtil.Assert;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

class TcpAcceptor
implements Acceptor {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private ServerSocketChannel _fd;
    private int _backlog;
    private InetSocketAddress _addr;

    public ServerSocketChannel fd() {
        return this._fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerSocketChannel fd;
        if (this._traceLevels.network >= 1) {
            String s = "stopping to accept tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        TcpAcceptor tcpAcceptor = this;
        synchronized (tcpAcceptor) {
            fd = this._fd;
            this._fd = null;
        }
        if (fd != null) {
            try {
                fd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void listen() {
        if (this._traceLevels.network >= 1) {
            String s = "accepting tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, s);
        }
    }

    public Transceiver accept(int timeout) {
        SocketChannel fd = Network.doAccept(this._fd, timeout);
        if (!this._instance.threadPerConnection()) {
            Network.setBlock(fd, false);
        }
        if (this._traceLevels.network >= 1) {
            String s = "accepted tcp connection\n" + Network.fdToString(fd);
            this._logger.trace(this._traceLevels.networkCat, s);
        }
        return new TcpTransceiver(this._instance, fd);
    }

    public void connectToSelf() {
        SocketChannel fd = Network.createTcpSocket();
        Network.setBlock(fd, false);
        Network.doConnect(fd, this._addr, -1);
        Network.closeSocket(fd);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    final boolean equivalent(String host, int port) {
        InetSocketAddress addr = Network.getAddress(host, port);
        return addr.equals(this._addr);
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    TcpAcceptor(Instance instance, String host, int port) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._backlog = 0;
        if (this._backlog <= 0) {
            this._backlog = 5;
        }
        try {
            this._fd = Network.createTcpServerSocket();
            Network.setBlock(this._fd, false);
            this._addr = new InetSocketAddress(host, port);
            if (this._traceLevels.network >= 2) {
                String s = "attempting to bind to tcp socket " + this.toString();
                this._logger.trace(this._traceLevels.networkCat, s);
            }
            this._addr = Network.doBind(this._fd, this._addr);
        }
        catch (RuntimeException ex) {
            this._fd = null;
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._fd == null);
        super.finalize();
    }
}

