/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BadMagicException;
import Ice.DatagramLimitException;
import Ice.IllegalMessageSizeException;
import Ice.LocalException;
import Ice.MemoryLimitException;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.BasicStream;
import IceInternal.EventHandler;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Protocol;
import IceUtil.Assert;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public final class ThreadPool {
    private static final boolean TRACE_REGISTRATION = false;
    private static final boolean TRACE_INTERRUPT = false;
    private static final boolean TRACE_SHUTDOWN = false;
    private static final boolean TRACE_SELECT = false;
    private static final boolean TRACE_EXCEPTION = false;
    private static final boolean TRACE_THREAD = false;
    private static final boolean TRACE_STACK_TRACE = false;
    private Instance _instance;
    private boolean _destroyed;
    private final String _prefix;
    private final String _programNamePrefix;
    private ReadableByteChannel _fdIntrRead;
    private SelectionKey _fdIntrReadKey;
    private WritableByteChannel _fdIntrWrite;
    private Selector _selector;
    private Set _keys;
    private LinkedList _changes = new LinkedList();
    private HashMap _handlerMap = new HashMap();
    private int _timeout;
    private final int _size;
    private final int _sizeMax;
    private final int _sizeWarn;
    private ArrayList _threads;
    private int _threadIndex;
    private int _running;
    private int _inUse;
    private double _load;
    private boolean _promote;
    private final boolean _warnUdp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ThreadPool(Instance instance, String prefix, int timeout) {
        int sizeMax;
        this._instance = instance;
        this._destroyed = false;
        this._prefix = prefix;
        this._timeout = timeout;
        this._threadIndex = 0;
        this._running = 0;
        this._inUse = 0;
        this._load = 1.0;
        this._promote = true;
        boolean bl = this._warnUdp = this._instance.properties().getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        String programName = this._instance.properties().getProperty("Ice.ProgramName");
        this._programNamePrefix = programName.length() > 0 ? programName + "-" : "";
        Network.SocketPair pair = Network.createPipe();
        this._fdIntrRead = (ReadableByteChannel)((Object)pair.source);
        this._fdIntrWrite = pair.sink;
        try {
            this._selector = Selector.open();
            pair.source.configureBlocking(false);
            this._fdIntrReadKey = pair.source.register(this._selector, 1);
        }
        catch (IOException ex) {
            SyscallException sys = new SyscallException();
            sys.initCause(ex);
            throw sys;
        }
        this._keys = this._selector.selectedKeys();
        int size = this._instance.properties().getPropertyAsIntWithDefault(this._prefix + ".Size", 1);
        if (size < 1) {
            size = 1;
        }
        if ((sizeMax = this._instance.properties().getPropertyAsIntWithDefault(this._prefix + ".SizeMax", size)) < size) {
            sizeMax = size;
        }
        int sizeWarn = this._instance.properties().getPropertyAsIntWithDefault(this._prefix + ".SizeWarn", sizeMax * 80 / 100);
        this._size = size;
        this._sizeMax = sizeMax;
        this._sizeWarn = sizeWarn;
        try {
            this._threads = new ArrayList();
            for (int i = 0; i < this._size; ++i) {
                EventHandlerThread thread = new EventHandlerThread(this._programNamePrefix + this._prefix + "-" + this._threadIndex++);
                this._threads.add(thread);
                thread.start();
                ++this._running;
            }
        }
        catch (RuntimeException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            String s = "cannot create thread for `" + this._prefix + "':\n" + sw.toString();
            this._instance.logger().error(s);
            this.destroy();
            this.joinWithAllThreads();
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._destroyed);
    }

    public synchronized void destroy() {
        if (!$assertionsDisabled && this._destroyed) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this._handlerMap.isEmpty()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this._changes.isEmpty()) {
            throw new AssertionError();
        }
        this._destroyed = true;
        this.setInterrupt();
    }

    public synchronized void _register(SelectableChannel fd, EventHandler handler) {
        if (!$assertionsDisabled && this._destroyed) {
            throw new AssertionError();
        }
        this._changes.add(new FdHandlerPair(fd, handler));
        this.setInterrupt();
    }

    public synchronized void unregister(SelectableChannel fd) {
        if (!$assertionsDisabled && this._destroyed) {
            throw new AssertionError();
        }
        this._changes.add(new FdHandlerPair(fd, null));
        this.setInterrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void promoteFollower() {
        if (this._sizeMax > 1) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (!$assertionsDisabled && this._promote) {
                    throw new AssertionError();
                }
                this._promote = true;
                this.notify();
                if (!this._destroyed) {
                    if (!$assertionsDisabled && this._inUse < 0) {
                        throw new AssertionError();
                    }
                    ++this._inUse;
                    if (this._inUse == this._sizeWarn) {
                        String s = "thread pool `" + this._prefix + "' is running low on threads\n" + "Size=" + this._size + ", " + "SizeMax=" + this._sizeMax + ", " + "SizeWarn=" + this._sizeWarn;
                        this._instance.logger().warning(s);
                    }
                    if (!$assertionsDisabled && this._inUse > this._running) {
                        throw new AssertionError();
                    }
                    if (this._inUse < this._sizeMax && this._inUse == this._running) {
                        try {
                            EventHandlerThread thread = new EventHandlerThread(this._programNamePrefix + this._prefix + "-" + this._threadIndex++);
                            this._threads.add(thread);
                            thread.start();
                            ++this._running;
                        }
                        catch (RuntimeException ex) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            ex.printStackTrace(pw);
                            pw.flush();
                            String s = "cannot create thread for `" + this._prefix + "':\n" + sw.toString();
                            this._instance.logger().error(s);
                        }
                    }
                }
            }
        }
    }

    public void joinWithAllThreads() {
        Iterator i = this._threads.iterator();
        block8: while (i.hasNext()) {
            EventHandlerThread thread = (EventHandlerThread)i.next();
            while (true) {
                try {
                    thread.join();
                    continue block8;
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }
        try {
            if (this._selector != null) {
                try {
                    this._selector.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this._selector = null;
            }
            if (this._fdIntrWrite != null) {
                try {
                    this._fdIntrWrite.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this._fdIntrWrite = null;
            }
            if (this._fdIntrRead != null) {
                this._fdIntrRead.close();
                this._fdIntrRead = null;
            }
        }
        catch (IOException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            String s = "exception in `" + this._prefix + "' while calling close():\n" + sw.toString();
            this._instance.logger().error(s);
        }
    }

    public String prefix() {
        return this._prefix;
    }

    private void clearInterrupt() {
        byte b = 0;
        ByteBuffer buf = ByteBuffer.allocate(1);
        try {
            buf.rewind();
            if (this._fdIntrRead.read(buf) == 1) {
                b = buf.get(0);
            }
        }
        catch (IOException ex) {
            SocketException se = new SocketException();
            se.initCause(ex);
            throw se;
        }
    }

    private void setInterrupt() {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put(0, (byte)0);
        while (buf.hasRemaining()) {
            try {
                this._fdIntrWrite.write(buf);
            }
            catch (IOException ex) {
                SocketException se = new SocketException();
                se.initCause(ex);
                throw se;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean run(BasicStream stream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void read(EventHandler handler) {
        BasicStream stream = handler._stream;
        if (stream.size() == 0) {
            stream.resize(14, true);
            stream.pos(0);
        }
        if (stream.pos() != stream.size()) {
            handler.read(stream);
            if (!$assertionsDisabled && stream.pos() != stream.size()) {
                throw new AssertionError();
            }
        }
        int pos = stream.pos();
        if (!$assertionsDisabled && pos < 14) {
            throw new AssertionError();
        }
        stream.pos(0);
        byte[] m = new byte[]{stream.readByte(), stream.readByte(), stream.readByte(), stream.readByte()};
        if (m[0] != Protocol.magic[0] || m[1] != Protocol.magic[1] || m[2] != Protocol.magic[2] || m[3] != Protocol.magic[3]) {
            BadMagicException ex = new BadMagicException();
            ex.badMagic = m;
            throw ex;
        }
        int pMajor = stream.readByte();
        int pMinor = stream.readByte();
        if (pMajor != 1 || pMinor > 0) {
            UnsupportedProtocolException e = new UnsupportedProtocolException();
            e.badMajor = pMajor < 0 ? pMajor + 255 : pMajor;
            e.badMinor = pMinor < 0 ? pMinor + 255 : pMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        int eMajor = stream.readByte();
        int eMinor = stream.readByte();
        if (eMajor != 1 || eMinor > 0) {
            UnsupportedEncodingException e = new UnsupportedEncodingException();
            e.badMajor = eMajor < 0 ? eMajor + 255 : eMajor;
            e.badMinor = eMinor < 0 ? eMinor + 255 : eMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        byte messageType = stream.readByte();
        byte compress = stream.readByte();
        int size = stream.readInt();
        if (size < 14) {
            throw new IllegalMessageSizeException();
        }
        if (size > this._instance.messageSizeMax()) {
            throw new MemoryLimitException();
        }
        if (size > stream.size()) {
            stream.resize(size, true);
        }
        stream.pos(pos);
        if (stream.pos() != stream.size()) {
            if (handler.datagram()) {
                if (this._warnUdp) {
                    this._instance.logger().warning("DatagramLimitException: maximum size of " + stream.pos() + " exceeded");
                }
                stream.pos(0);
                stream.resize(0, true);
                throw new DatagramLimitException();
            }
            handler.read(stream);
            if (!$assertionsDisabled && stream.pos() != stream.size()) {
                throw new AssertionError();
            }
        }
    }

    private void select() {
        int ret = 0;
        while (true) {
            try {
                if (this._timeout > 0) {
                    ret = this._selector.select(this._timeout * 1000);
                    break;
                }
                ret = this._selector.select();
            }
            catch (InterruptedIOException ex) {
                continue;
            }
            catch (IOException ex) {
                if (ex.getMessage().indexOf("Interrupted system call") != -1) continue;
                SocketException se = new SocketException();
                se.initCause(ex);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                se.printStackTrace(pw);
                pw.flush();
                String s = "exception in `" + this._prefix + "':\n" + sw.toString();
                this._instance.logger().error(s);
                continue;
            }
            break;
        }
    }

    private void trace(String msg) {
        System.err.println(this._prefix + ": " + msg);
    }

    private String keyToString(SelectionKey key) {
        String ops = "[";
        if (key.isAcceptable()) {
            ops = ops + " OP_ACCEPT";
        }
        if (key.isReadable()) {
            ops = ops + " OP_READ";
        }
        if (key.isConnectable()) {
            ops = ops + " OP_CONNECT";
        }
        if (key.isWritable()) {
            ops = ops + " OP_WRITE";
        }
        ops = ops + " ]";
        return key.channel() + " " + ops;
    }

    static {
        $assertionsDisabled = !ThreadPool.class.desiredAssertionStatus();
    }

    private final class EventHandlerThread
    extends Thread {
        static final /* synthetic */ boolean $assertionsDisabled;

        EventHandlerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean promote;
            BasicStream stream = new BasicStream(ThreadPool.this._instance);
            try {
                promote = ThreadPool.this.run(stream);
            }
            catch (LocalException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "exception in `" + ThreadPool.this._prefix + "' thread " + this.getName() + ":\n" + sw.toString();
                ThreadPool.this._instance.logger().error(s);
                promote = true;
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                pw.flush();
                String s = "unknown exception in `" + ThreadPool.this._prefix + "' thread " + this.getName() + ":\n" + sw.toString();
                ThreadPool.this._instance.logger().error(s);
                promote = true;
            }
            if (promote && ThreadPool.this._sizeMax > 1) {
                ThreadPool threadPool = ThreadPool.this;
                synchronized (threadPool) {
                    if (!$assertionsDisabled && ThreadPool.this._promote) {
                        throw new AssertionError();
                    }
                    ThreadPool.this._promote = true;
                    ThreadPool.this.notify();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$IceInternal$ThreadPool == null ? (class$IceInternal$ThreadPool = ThreadPool.class$("IceInternal.ThreadPool")) : class$IceInternal$ThreadPool).desiredAssertionStatus();
        }
    }

    private static final class HandlerKeyPair {
        EventHandler handler;
        SelectionKey key;

        HandlerKeyPair(EventHandler handler, SelectionKey key) {
            this.handler = handler;
            this.key = key;
        }
    }

    private static final class FdHandlerPair {
        SelectableChannel fd;
        EventHandler handler;

        FdHandlerPair(SelectableChannel fd, EventHandler handler) {
            this.fd = fd;
            this.handler = handler;
        }
    }
}

