/*
 * Decompiled with CFR 0.152.
 */
package IceSSL;

import Ice.ConnectFailedException;
import Ice.ConnectTimeoutException;
import Ice.ConnectionRefusedException;
import Ice.Logger;
import Ice.SocketException;
import IceInternal.Connector;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceSSL.Context;
import IceSSL.Instance;
import IceSSL.SslTransceiver;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

final class SslConnector
implements Connector {
    private Instance _instance;
    private Context _ctx;
    private Logger _logger;
    private InetSocketAddress _addr;

    public Transceiver connect(int timeout) {
        if (this._instance.networkTraceLevel() >= 2) {
            String s = "trying to establish ssl connection to " + this.toString();
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        Socket fd = null;
        try {
            if (timeout >= 0) {
                ConnectThread ct = new ConnectThread(this._ctx.sslContext(), this._addr);
                ct.start();
                fd = ct.getFd(timeout == 0 ? 1 : timeout);
                if (fd == null) {
                    throw new ConnectTimeoutException();
                }
            } else {
                SSLSocketFactory factory = this._ctx.sslContext().getSocketFactory();
                fd = (SSLSocket)factory.createSocket(this._addr.getAddress(), this._addr.getPort());
            }
            ((SSLSocket)fd).setUseClientMode(true);
            String[] cipherSuites = this._ctx.filterCiphers(((SSLSocket)fd).getSupportedCipherSuites(), ((SSLSocket)fd).getEnabledCipherSuites());
            if (this._instance.securityTraceLevel() > 0) {
                StringBuffer s = new StringBuffer();
                s.append("enabling ciphersuites for ssl socket\n" + Network.fdToString(fd) + ":");
                for (int i = 0; i < cipherSuites.length; ++i) {
                    s.append("\n  " + cipherSuites[i]);
                }
                this._logger.trace(this._instance.securityTraceCategory(), s.toString());
            }
            ((SSLSocket)fd).setEnabledCipherSuites(cipherSuites);
            if (timeout >= 0) {
                HandshakeThread ht = new HandshakeThread((SSLSocket)fd);
                ht.start();
                if (!ht.waitForHandshake(timeout == 0 ? 1 : timeout)) {
                    throw new ConnectTimeoutException();
                }
            } else {
                ((SSLSocket)fd).startHandshake();
            }
        }
        catch (ConnectException ex) {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ConnectFailedException se = Network.connectionRefused(ex) ? new ConnectionRefusedException() : new ConnectFailedException();
            se.initCause(ex);
            throw se;
        }
        catch (IOException ex) {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            SocketException e = new SocketException();
            e.initCause(ex);
            throw e;
        }
        catch (RuntimeException ex) {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            throw ex;
        }
        if (this._instance.networkTraceLevel() >= 1) {
            String s = "ssl connection established\n" + Network.fdToString(fd);
            this._logger.trace(this._instance.networkTraceCategory(), s);
        }
        return new SslTransceiver(this._instance, (SSLSocket)fd);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    SslConnector(Instance instance, String host, int port) {
        this._instance = instance;
        this._ctx = instance.clientContext();
        this._logger = instance.communicator().getLogger();
        this._addr = Network.getAddress(host, port);
    }

    private static class HandshakeThread
    extends Thread {
        private SSLSocket _fd;
        private boolean _ok;
        private IOException _ex;

        HandshakeThread(SSLSocket fd) {
            this._fd = fd;
            this._ok = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._fd.startHandshake();
                HandshakeThread handshakeThread = this;
                synchronized (handshakeThread) {
                    this._ok = true;
                    this.notifyAll();
                }
            }
            catch (IOException ex) {
                HandshakeThread handshakeThread = this;
                synchronized (handshakeThread) {
                    this._ex = ex;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForHandshake(int timeout) throws IOException {
            boolean result = false;
            HandshakeThread handshakeThread = this;
            synchronized (handshakeThread) {
                while (!this._ok && this._ex == null) {
                    try {
                        this.wait(timeout);
                        break;
                    }
                    catch (InterruptedException ex) {
                    }
                }
                if (this._ex != null) {
                    throw this._ex;
                }
                result = this._ok;
            }
            return result;
        }
    }

    private static class ConnectThread
    extends Thread {
        private SSLContext _ctx;
        private InetSocketAddress _addr;
        private SSLSocket _fd;
        private IOException _ex;

        ConnectThread(SSLContext ctx, InetSocketAddress addr) {
            this._ctx = ctx;
            this._addr = addr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SSLSocketFactory factory = this._ctx.getSocketFactory();
                SSLSocket fd = (SSLSocket)factory.createSocket(this._addr.getAddress(), this._addr.getPort());
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this._fd = fd;
                    this.notifyAll();
                }
            }
            catch (IOException ex) {
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this._ex = ex;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SSLSocket getFd(int timeout) throws IOException {
            SSLSocket fd = null;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this._fd == null && this._ex == null) {
                    try {
                        this.wait(timeout);
                        break;
                    }
                    catch (InterruptedException ex) {
                    }
                }
                if (this._ex != null) {
                    throw this._ex;
                }
                fd = this._fd;
                this._fd = null;
            }
            return fd;
        }
    }
}

