# Try to find the OpenEXR libraries
# This check defines:
#
#  OPENEXR_FOUND - system has OpenEXR
#  OPENEXR_INCLUDE_DIR - OpenEXR include directory
#  OPENEXR_LIBRARIES - Libraries needed to use OpenEXR
#  OPENEXR_DEFINITIONS - definitions required to use OpenEXR

# Copyright (c) 2006, Alexander Neundorf, <neundorf@kde.org>
#
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


if (OPENEXR_INCLUDE_DIR AND OPENEXR_LIBRARIES)
  # in cache already
  set(OPENEXR_FOUND TRUE)

else (OPENEXR_INCLUDE_DIR AND OPENEXR_LIBRARIES)

  # use pkg-config to get the directories and then use these values
  # in the FIND_PATH() and FIND_LIBRARY() calls
  find_package(PkgConfig)
  pkg_check_modules(PC_OPENEXR QUIET OpenEXR) 

  FIND_PATH(OPENEXR_INCLUDE_DIR ImfRgbaFile.h
     HINTS
     ${PC_OPENEXR_INCLUDEDIR}
     ${PC_OPENEXR_INCLUDE_DIRS}
     PATH_SUFFIXES OpenEXR
  )

  FIND_LIBRARY(OPENEXR_HALF_LIBRARY NAMES Half
    HINTS
    ${PC_OPENEXR_LIBDIR}
    ${PC_OPENEXR_LIBRARY_DIRS}
  )


  FIND_LIBRARY(OPENEXR_IEX_LIBRARY NAMES Iex
    PATHS
    ${PC_OPENEXR_LIBDIR}
    ${PC_OPENEXR_LIBRARY_DIRS}
  )

  FIND_LIBRARY(OPENEXR_IMATH_LIBRARY NAMES Imath
    HINTS
    ${PC_OPENEXR_LIBDIR}
    ${PC_OPENEXR_LIBRARY_DIRS}
  )

  FIND_LIBRARY(OPENEXR_ILMIMF_LIBRARY NAMES IlmImf 
    HINTS
    ${PC_OPENEXR_LIBDIR}
    ${PC_OPENEXR_LIBRARY_DIRS}
  )
  
  FIND_LIBRARY(OPENEXR_ILMTHREAD_LIBRARY NAMES IlmThread
    HINTS
    ${PC_OPENEXR_LIBDIR}
    ${PC_OPENEXR_LIBRARY_DIRS}
  )

  if (OPENEXR_INCLUDE_DIR AND OPENEXR_IMATH_LIBRARY AND OPENEXR_ILMIMF_LIBRARY AND OPENEXR_IEX_LIBRARY AND OPENEXR_HALF_LIBRARY)
     set(OPENEXR_FOUND TRUE)
     if (OPENEXR_ILMTHREAD_LIBRARY)
         set(OPENEXR_LIBRARIES ${OPENEXR_IMATH_LIBRARY} ${OPENEXR_ILMIMF_LIBRARY} ${OPENEXR_IEX_LIBRARY} ${OPENEXR_HALF_LIBRARY} ${OPENEXR_ILMTHREAD_LIBRARY} )
     else (OPENEXR_ILMTHREAD_LIBRARY)
         set(OPENEXR_LIBRARIES ${OPENEXR_IMATH_LIBRARY} ${OPENEXR_ILMIMF_LIBRARY} ${OPENEXR_IEX_LIBRARY} ${OPENEXR_HALF_LIBRARY} )
     endif (OPENEXR_ILMTHREAD_LIBRARY)

     if (WIN32)
        set(_OPENEXR_DEFINITIONS -DOPENEXR_DLL)
     else (WIN32)
        set(_OPENEXR_DEFINITIONS)
     endif (WIN32)

     set(OPENEXR_DEFINITIONS ${_OPENEXR_DEFINITIONS})

  endif (OPENEXR_INCLUDE_DIR AND OPENEXR_IMATH_LIBRARY AND OPENEXR_ILMIMF_LIBRARY AND OPENEXR_IEX_LIBRARY AND OPENEXR_HALF_LIBRARY)
  
  
  if (OPENEXR_FOUND)
    if (NOT OpenEXR_FIND_QUIETLY)
      message(STATUS "Found OPENEXR: ${OPENEXR_LIBRARIES}")
    endif (NOT OpenEXR_FIND_QUIETLY)
  else (OPENEXR_FOUND)
    if (OpenEXR_FIND_REQUIRED)
      message(FATAL_ERROR "Could NOT find OPENEXR")
    endif (OpenEXR_FIND_REQUIRED)
  endif (OPENEXR_FOUND)
  
  mark_as_advanced(
     OPENEXR_INCLUDE_DIR 
     OPENEXR_LIBRARIES 
     OPENEXR_ILMIMF_LIBRARY 
     OPENEXR_ILMTHREAD_LIBRARY
     OPENEXR_IMATH_LIBRARY 
     OPENEXR_IEX_LIBRARY 
     OPENEXR_HALF_LIBRARY
     OPENEXR_DEFINITIONS )
  
endif (OPENEXR_INCLUDE_DIR AND OPENEXR_LIBRARIES)
