// SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause
/* Copyright(c) 2022-2023  Realtek Corporation
 */

#include "phy.h"
#include "reg.h"
#include "rtw8851b_table.h"

static const struct rtw89_reg2_def rtw89_8851b_phy_bb_regs[] = {
	{0x704, 0x601E0500},
	{0x4000, 0x00000000},
	{0x4004, 0xCA014000},
	{0x4008, 0xC751D4F0},
	{0x400C, 0x44511475},
	{0x4010, 0x00000000},
	{0x4014, 0x00000000},
	{0x47BC, 0x00000380},
	{0x4018, 0x4F4C084B},
	{0x401C, 0x084A4E52},
	{0x4020, 0x4D504E4B},
	{0x4024, 0x4F4C0849},
	{0x4028, 0x08484C50},
	{0x402C, 0x4C50504C},
	{0x4030, 0x5454084A},
	{0x4034, 0x084B5654},
	{0x4038, 0x6A6C605A},
	{0x403C, 0x4C4C084C},
	{0x4040, 0x084B4E4D},
	{0x4044, 0x4E4C4B4B},
	{0x4048, 0x4B4B084A},
	{0x404C, 0x084A4E4C},
	{0x4050, 0x514F4C4A},
	{0x4054, 0x524E084A},
	{0x4058, 0x084A5154},
	{0x405C, 0x53555554},
	{0x4060, 0x45450845},
	{0x4064, 0x08454144},
	{0x4068, 0x40434445},
	{0x406C, 0x44450845},
	{0x4070, 0x08444043},
	{0x4074, 0x42434444},
	{0x4078, 0x46450844},
	{0x407C, 0x08444843},
	{0x4080, 0x4B4E4A47},
	{0x4084, 0x4F4C084B},
	{0x4088, 0x084A4E52},
	{0x408C, 0x4D504E4B},
	{0x4090, 0x4F4C0849},
	{0x4094, 0x08484C50},
	{0x4098, 0x4C50504C},
	{0x409C, 0x5454084A},
	{0x40A0, 0x084B5654},
	{0x40A4, 0x6A6C605A},
	{0x40A8, 0x4C4C084C},
	{0x40AC, 0x084B4E4D},
	{0x40B0, 0x4E4C4B4B},
	{0x40B4, 0x4B4B084A},
	{0x40B8, 0x084A4E4C},
	{0x40BC, 0x514F4C4A},
	{0x40C0, 0x524E084A},
	{0x40C4, 0x084A5154},
	{0x40C8, 0x53555554},
	{0x40CC, 0x45450845},
	{0x40D0, 0x08454144},
	{0x40D4, 0x40434445},
	{0x40D8, 0x44450845},
	{0x40DC, 0x08444043},
	{0x40E0, 0x42434444},
	{0x40E4, 0x46450844},
	{0x40E8, 0x08444843},
	{0x40EC, 0x4B4E4A47},
	{0x40F0, 0x00000000},
	{0x4A38, 0x00000000},
	{0x40F4, 0x00000006},
	{0x40F8, 0x00000000},
	{0x40FC, 0x8C30C30C},
	{0x4100, 0x4C30C30C},
	{0x4104, 0x0C30C30C},
	{0x4108, 0x0C30C30C},
	{0x410C, 0x0C30C30C},
	{0x4110, 0x0C30C30C},
	{0x4114, 0x28A28A28},
	{0x4118, 0x28A28A28},
	{0x411C, 0x28A28A28},
	{0x4120, 0x28A28A28},
	{0x4124, 0x28A28A28},
	{0x4128, 0x28A28A28},
	{0x412C, 0x06666666},
	{0x4130, 0x33333333},
	{0x4134, 0x33333333},
	{0x4138, 0x33333333},
	{0x413C, 0x00000031},
	{0x4140, 0x5100600A},
	{0x4144, 0x18363113},
	{0x4148, 0x1D976DDC},
	{0x414C, 0x1C072DD7},
	{0x4150, 0x1127CDF4},
	{0x4154, 0x1E37BDF1},
	{0x4158, 0x1FB7F1D6},
	{0x415C, 0x1EA7DDF9},
	{0x4160, 0x1FE445DD},
	{0x4164, 0x1F97F1FE},
	{0x4168, 0x1FF781ED},
	{0x416C, 0x1FA7F5FE},
	{0x4170, 0x1E07B913},
	{0x4174, 0x1FD7FDFF},
	{0x4178, 0x1E17B9FA},
	{0x417C, 0x19A66914},
	{0x4180, 0x10F65598},
	{0x4184, 0x14A5A111},
	{0x4188, 0x1D3765DB},
	{0x418C, 0x17C685CA},
	{0x4190, 0x1107C5F3},
	{0x4194, 0x1B5785EB},
	{0x4198, 0x1F97ED8F},
	{0x419C, 0x1BC7A5F3},
	{0x41A0, 0x1FE43595},
	{0x41A4, 0x1EB7D9FC},
	{0x41A8, 0x1FE65DBE},
	{0x41AC, 0x1EC7D9FC},
	{0x41B0, 0x1976FCFF},
	{0x41B4, 0x1F77F5FF},
	{0x41B8, 0x1976FDEC},
	{0x41BC, 0x198664EF},
	{0x41C0, 0x11062D93},
	{0x41C4, 0x10C4E910},
	{0x41C8, 0x1CA759DB},
	{0x41CC, 0x1335A9B5},
	{0x41D0, 0x1097B9F3},
	{0x41D4, 0x17B72DE1},
	{0x41D8, 0x1F67ED42},
	{0x41DC, 0x18074DE9},
	{0x41E0, 0x1FD40547},
	{0x41E4, 0x1D57ADF9},
	{0x41E8, 0x1FE52182},
	{0x41EC, 0x1D67B1F9},
	{0x41F0, 0x14860CE1},
	{0x41F4, 0x1EC7E9FE},
	{0x41F8, 0x14860DD6},
	{0x41FC, 0x195664C7},
	{0x4200, 0x0005E58A},
	{0x4204, 0x00000000},
	{0x4208, 0x00000000},
	{0x420C, 0x7A000000},
	{0x4210, 0x0F9F3D7A},
	{0x4214, 0x0040817C},
	{0x4218, 0x00E10204},
	{0x421C, 0x227D94CD},
	{0x4220, 0x08028A28},
	{0x4224, 0x00000200},
	{0x4228, 0x04688000},
	{0x47C0, 0x00000001},
	{0x4A48, 0x00000002},
	{0x4B04, 0x00000000},
	{0x4B08, 0x00000000},
	{0x422C, 0x0060B002},
	{0x4230, 0x9A8249A8},
	{0x4234, 0x26A1469E},
	{0x4238, 0x2099A824},
	{0x423C, 0x2359461C},
	{0x4240, 0x1631A675},
	{0x4244, 0x2C6B1D63},
	{0x4248, 0x0000000E},
	{0x424C, 0x00000001},
	{0x4250, 0x00000001},
	{0x4254, 0x00000000},
	{0x4258, 0x00000000},
	{0x425C, 0x00000000},
	{0x4260, 0x0020000C},
	{0x4A30, 0x00000000},
	{0x4264, 0x00000000},
	{0x4268, 0x00000000},
	{0x426C, 0x0418317C},
	{0x4270, 0x2B33135C},
	{0x4274, 0x00000002},
	{0x4278, 0x00000000},
	{0x427C, 0x00000000},
	{0x4280, 0x00000000},
	{0x4284, 0x00000000},
	{0x4288, 0x00000000},
	{0x428C, 0x00000000},
	{0x4290, 0x00000000},
	{0x4294, 0x00000000},
	{0x4298, 0x00000000},
	{0x429C, 0x84026000},
	{0x42A0, 0x0051AC20},
	{0x4A24, 0x0010C040},
	{0x42A4, 0x02024008},
	{0x42A8, 0x00000000},
	{0x42AC, 0x00000000},
	{0x42B0, 0x22CE803C},
	{0x42B4, 0xD8000000},
	{0x42B8, 0x596FD67E},
	{0x42BC, 0x7D67D67D},
	{0x42C0, 0x7D67D65B},
	{0x42C4, 0x28029F59},
	{0x42C8, 0x00280280},
	{0x4AF4, 0x00000000},
	{0x42CC, 0x00000000},
	{0x42D0, 0x00000000},
	{0x42D4, 0x00000003},
	{0x4AF8, 0x00280000},
	{0x42D8, 0x00000001},
	{0x42DC, 0x69AEC800},
	{0x42E0, 0x8B4CD3D1},
	{0x42E4, 0xC514534F},
	{0x42E8, 0x85145145},
	{0x42EC, 0x45145145},
	{0x42F0, 0x05145145},
	{0x42F4, 0x05145145},
	{0x42F8, 0x05145145},
	{0x42FC, 0x17659145},
	{0x4300, 0x176DD5D9},
	{0x4304, 0x0F65765B},
	{0x4308, 0x0F3CF3CF},
	{0x430C, 0x0F3CF3CF},
	{0x4310, 0x0F3CF3CF},
	{0x4314, 0x0F3CF3CF},
	{0x4318, 0x0F3CF3CF},
	{0x431C, 0x0F3CF3CF},
	{0x4320, 0x0F3CF3CF},
	{0x4324, 0x0F44F351},
	{0x4328, 0x192D7547},
	{0x432C, 0x0F5CF5CF},
	{0x4330, 0x051593D9},
	{0x4334, 0x05145145},
	{0x4338, 0x05145145},
	{0x433C, 0x05145145},
	{0x4340, 0x05145145},
	{0x4344, 0x05145145},
	{0x4348, 0x19545145},
	{0x434C, 0x1B65B5DB},
	{0x4350, 0x1965965B},
	{0x4354, 0x0F3CF3CF},
	{0x4358, 0x0F3CF3CF},
	{0x435C, 0x0F3CF1CF},
	{0x4360, 0x0F3CF3CF},
	{0x4364, 0x0F3CF3CF},
	{0x4368, 0x0F3CF3CF},
	{0x436C, 0x0F3CF3CF},
	{0x4370, 0x0934D2CF},
	{0x4374, 0x112CB3CF},
	{0x4378, 0x9777A777},
	{0x437C, 0xBB7BAC95},
	{0x4380, 0xB667B889},
	{0x4384, 0x7B9B8899},
	{0x4388, 0x7A5567C8},
	{0x438C, 0x2278CCCC},
	{0x4390, 0x7C222222},
	{0x4394, 0x0000029B},
	{0x4398, 0x001CCCCC},
	{0x4AAC, 0xCCCCC88C},
	{0x4AB0, 0x0000AACC},
	{0x439C, 0x00000000},
	{0x43A0, 0x00000008},
	{0x43A4, 0x00000000},
	{0x43A8, 0x00000000},
	{0x43AC, 0x00000000},
	{0x43B0, 0x10000000},
	{0x43B4, 0x00401001},
	{0x43B8, 0x00061003},
	{0x43BC, 0x000024D8},
	{0x43C0, 0x00000000},
	{0x43C4, 0x10000020},
	{0x43C8, 0x20000200},
	{0x43CC, 0x00000000},
	{0x43D0, 0x04000000},
	{0x43D4, 0x44000100},
	{0x43D8, 0x60804060},
	{0x43DC, 0x44204210},
	{0x43E0, 0x82108082},
	{0x43E4, 0x82108402},
	{0x43E8, 0xC8082108},
	{0x43EC, 0xC8202084},
	{0x43F0, 0x44208208},
	{0x43F4, 0x84108204},
	{0x43F8, 0xD0108104},
	{0x43FC, 0xF8210108},
	{0x4400, 0x6431E930},
	{0x4404, 0x02309468},
	{0x4408, 0x10C61C22},
	{0x440C, 0x02109469},
	{0x4410, 0x10C61C22},
	{0x4414, 0x00041049},
	{0x4A4C, 0x00060581},
	{0x4418, 0x00000000},
	{0x441C, 0x00000000},
	{0x4420, 0xEC000000},
	{0x4424, 0xB0200020},
	{0x4428, 0x00001FF0},
	{0x4AC8, 0x00000001},
	{0x4B0C, 0x00000000},
	{0x4CDC, 0x00000000},
	{0x442C, 0x00000000},
	{0x4430, 0x00000000},
	{0x4434, 0x00000000},
	{0x4438, 0x00000000},
	{0x443C, 0x190642D0},
	{0x4440, 0xA80668A0},
	{0x4444, 0x60900820},
	{0x4448, 0x9F28518C},
	{0x444C, 0x32488A62},
	{0x4450, 0x9C6E36DC},
	{0x4454, 0x0000F52B},
	{0x4A34, 0x00000007},
	{0x4CE0, 0x68120000},
	{0x4CE4, 0x1A0681E0},
	{0x4CE8, 0x94060180},
	{0x4CEC, 0x000603FF},
	{0x4CF0, 0xA0502000},
	{0x4CF4, 0x00001000},
	{0x4D00, 0x00000044},
	{0x4B14, 0x00000000},
	{0x4458, 0x00000000},
	{0x445C, 0x4801442E},
	{0x4460, 0x0051A0FA},
	{0x4B18, 0x0000011F},
	{0x4B1C, 0x0000011F},
	{0x4464, 0x00000000},
	{0x4468, 0x00000000},
	{0x446C, 0x00000000},
	{0x4470, 0x00000000},
	{0x4474, 0x00000000},
	{0x4478, 0x00000000},
	{0x447C, 0x00000000},
	{0x4480, 0x2A0A6040},
	{0x4484, 0x0A0A6829},
	{0x4488, 0x00000004},
	{0x448C, 0x00000000},
	{0x4490, 0x80000000},
	{0x4494, 0x10000000},
	{0x4498, 0xE0000000},
	{0x4A28, 0x000ED877},
	{0x4AB4, 0x00000000},
	{0x4B20, 0x00000000},
	{0x4B24, 0x00000000},
	{0x4B28, 0x00000000},
	{0x4B2C, 0x00000000},
	{0x449C, 0x0000001E},
	{0x44A0, 0x02B2C394},
	{0x44A4, 0x00000400},
	{0x4A2C, 0x0050240E},
	{0x4B30, 0x7FFFFD20},
	{0x4B34, 0x920823FF},
	{0x4B38, 0x7FFFFFFF},
	{0x4B3C, 0x01773773},
	{0x44A8, 0x00000001},
	{0x44AC, 0x000190C0},
	{0x44B0, 0x00000000},
	{0x44B4, 0x00000000},
	{0x44B8, 0x00000000},
	{0x44BC, 0x00000000},
	{0x44C0, 0x00000000},
	{0x44C4, 0x00000000},
	{0x44C8, 0x00000000},
	{0x44CC, 0x00000000},
	{0x44D0, 0x00000000},
	{0x44D4, 0x00000000},
	{0x44D8, 0x00000000},
	{0x44DC, 0x00000000},
	{0x44E0, 0x00000000},
	{0x44E4, 0x00000000},
	{0x44E8, 0x00000000},
	{0x44EC, 0x00000000},
	{0x44F0, 0x00000000},
	{0x44F4, 0x00000000},
	{0x44F8, 0x00000000},
	{0x44FC, 0x00000000},
	{0x4500, 0x00000000},
	{0x4504, 0x00000000},
	{0x4508, 0x00000000},
	{0x450C, 0x00000000},
	{0x4510, 0x00000000},
	{0x4514, 0x00000000},
	{0x4518, 0x00000000},
	{0x451C, 0x00000000},
	{0x4520, 0x00000000},
	{0x4524, 0x00000000},
	{0x4528, 0x00000000},
	{0x452C, 0x00000000},
	{0x4530, 0x4E830171},
	{0x4534, 0x00000870},
	{0x4538, 0x000000FF},
	{0x453C, 0x00000000},
	{0x4540, 0x00000000},
	{0x4544, 0x00000000},
	{0x4548, 0x00000000},
	{0x454C, 0x00000000},
	{0x4550, 0x00000000},
	{0x4554, 0x00000000},
	{0x4558, 0x00000000},
	{0x455C, 0x00000000},
	{0x4560, 0x40000000},
	{0x4564, 0x40000000},
	{0x4568, 0x00000000},
	{0x456C, 0x20000000},
	{0x4570, 0x04F040BB},
	{0x4574, 0x000E53FF},
	{0x4578, 0x000205CB},
	{0x457C, 0x00200000},
	{0x4580, 0x00000040},
	{0x4584, 0x00000000},
	{0x4588, 0x00000017},
	{0x458C, 0x30000000},
	{0x4590, 0x00000000},
	{0x4594, 0x00000000},
	{0x4598, 0x00000001},
	{0x459C, 0x0003FE00},
	{0x45A0, 0x00000086},
	{0x45A4, 0x00000000},
	{0x45A8, 0xC00001C0},
	{0x45AC, 0x78038000},
	{0x45B0, 0x8000004A},
	{0x45B4, 0x04094800},
	{0x45B8, 0x00280002},
	{0x45BC, 0x06748790},
	{0x45C0, 0x80000000},
	{0x45C4, 0x00000000},
	{0x45C8, 0x00000000},
	{0x45CC, 0x00558670},
	{0x45D0, 0x002883F0},
	{0x45D4, 0x00090120},
	{0x45D8, 0x00000000},
	{0x45E0, 0xA3A6D3C4},
	{0x45E4, 0xAB27B126},
	{0x45E8, 0x00006778},
	{0x45F4, 0x000001B5},
	{0x45EC, 0x11110F0A},
	{0x45F0, 0x00000003},
	{0x4A0C, 0x0000000A},
	{0x45F8, 0x0058BC3F},
	{0x45FC, 0x00000003},
	{0x462C, 0x00000020},
	{0x4600, 0x000003D9},
	{0x45F0, 0x00000004},
	{0x4604, 0x002B1CB0},
	{0x4A50, 0xC0000000},
	{0x4A54, 0x00001000},
	{0x4A58, 0x00000000},
	{0x4A18, 0x00000024},
	{0x4608, 0x00000001},
	{0x460C, 0x00000000},
	{0x4A10, 0x00000001},
	{0x4610, 0x00000001},
	{0x4614, 0x16E5298F},
	{0x4618, 0x18C6294A},
	{0x461C, 0x0E06318A},
	{0x4620, 0x0E539CE5},
	{0x4624, 0x00019287},
	{0x4A14, 0x000000BF},
	{0x4628, 0x00000001},
	{0x4630, 0x000001AA},
	{0x4A18, 0x00001900},
	{0x4A1C, 0x000002A6},
	{0x4634, 0x000000A3},
	{0x4A20, 0x00000086},
	{0x4638, 0x00045656},
	{0x49F8, 0x00000000},
	{0x463C, 0x00000000},
	{0x4640, 0x00000000},
	{0x4644, 0x00C8CC00},
	{0x4648, 0xC400B6B6},
	{0x464C, 0xDC400FC0},
	{0x4A44, 0x00000000},
	{0x4A8C, 0x00000110},
	{0x4BC4, 0x00000001},
	{0x4650, 0x08882550},
	{0x4654, 0x08CC2660},
	{0x4658, 0x09102660},
	{0x465C, 0x00000154},
	{0x45DC, 0xC39E38E8},
	{0x4660, 0x452607E6},
	{0x4664, 0x6750DC65},
	{0x4668, 0xF3F0F1ED},
	{0x466C, 0x30141506},
	{0x4670, 0x2C2B2B2B},
	{0x4674, 0x2C2C2C2C},
	{0x4678, 0xDDB738E8},
	{0x467C, 0x543618FB},
	{0x4680, 0x4F31DC6F},
	{0x4684, 0xFBEBDA00},
	{0x4688, 0x1A10FF04},
	{0x468C, 0x282A3000},
	{0x4690, 0x2A29292A},
	{0x4694, 0x04FA2A2A},
	{0x4698, 0xEE0F04D1},
	{0x469C, 0x99E91436},
	{0x46A0, 0x0701E79E},
	{0x46A4, 0x08D77CFF},
	{0x46A8, 0x321AFF14},
	{0x46AC, 0x60313447},
	{0x46B0, 0x63666666},
	{0x46B4, 0x35374425},
	{0x46B8, 0x35883042},
	{0x46BC, 0x5177C252},
	{0x4720, 0x7FFFFD63},
	{0x4724, 0xB58D11FF},
	{0x4728, 0x47FFFFFF},
	{0x472C, 0x0E7893B6},
	{0x4730, 0xE0391201},
	{0x4734, 0x00000020},
	{0x4738, 0x8325C500},
	{0x473C, 0x00000B7F},
	{0x46C0, 0x00000000},
	{0x46C4, 0x00000000},
	{0x46C8, 0x00000219},
	{0x4BDC, 0x00002020},
	{0x46CC, 0x00000000},
	{0x46D0, 0x00000000},
	{0x4A3C, 0x00000002},
	{0x46D4, 0x00000001},
	{0x46D8, 0x00000001},
	{0x46DC, 0x00000000},
	{0x46E0, 0x00000000},
	{0x46E4, 0x00000151},
	{0x46E8, 0x00000498},
	{0x46EC, 0x00000498},
	{0x46F0, 0x00000000},
	{0x46F4, 0x00000000},
	{0x46F8, 0x00001146},
	{0x46FC, 0x00000000},
	{0x4700, 0x00000000},
	{0x4704, 0x00C8CC00},
	{0x4708, 0xC400B6B6},
	{0x470C, 0xDC400FC0},
	{0x4A90, 0x00000110},
	{0x4B10, 0x00000000},
	{0x4BE0, 0x00000001},
	{0x4710, 0x08882550},
	{0x4714, 0x08CC2660},
	{0x4718, 0x09102660},
	{0x471C, 0x00000154},
	{0x4740, 0xC69F38E8},
	{0x4744, 0x462709E9},
	{0x4748, 0x6750DC67},
	{0x474C, 0xF3F0F1ED},
	{0x4750, 0x30141506},
	{0x4754, 0x2C2B2B2B},
	{0x4758, 0x2C2C2C2C},
	{0x475C, 0xE0B738E8},
	{0x4760, 0x52381BFE},
	{0x4764, 0x5031DC6C},
	{0x4768, 0xFBEBDA00},
	{0x476C, 0x1A10FF04},
	{0x4770, 0x282A3000},
	{0x4774, 0x2A29292A},
	{0x4778, 0x04FA2A2A},
	{0x477C, 0xEE0F04D1},
	{0x47C4, 0x00000000},
	{0x47C8, 0xA32103FE},
	{0x47CC, 0xB20A5328},
	{0x47D0, 0xC686314F},
	{0x47D4, 0x000004D7},
	{0x4BFC, 0x00000000},
	{0x4C00, 0x0C442416},
	{0x4C04, 0x00000000},
	{0x47D8, 0x009B902A},
	{0x47DC, 0x009B902A},
	{0x47E0, 0x98682C18},
	{0x47E4, 0x6318C4C1},
	{0x47E8, 0x6248C631},
	{0x47EC, 0x922A8253},
	{0x47F0, 0x00000005},
	{0x47F4, 0x00001759},
	{0x47F8, 0x4BB01800},
	{0x47FC, 0x831408BE},
	{0x4A84, 0x000000E9},
	{0x4C08, 0x0F801404},
	{0x4C0C, 0x00A2B404},
	{0x4800, 0x9ABBCACB},
	{0x4804, 0x56867578},
	{0x4808, 0xBCCBBB13},
	{0x480C, 0x7889989B},
	{0x4810, 0xBBB0F455},
	{0x4814, 0x777BBBBB},
	{0x4818, 0x15277777},
	{0x481C, 0x27039CE9},
	{0x4820, 0x42424432},
	{0x4824, 0x36058342},
	{0x4828, 0x00000006},
	{0x482C, 0x00000005},
	{0x4830, 0x00000005},
	{0x4834, 0xC7013016},
	{0x4838, 0x84413016},
	{0x483C, 0x84413016},
	{0x4840, 0x8C413016},
	{0x4844, 0x8C40B028},
	{0x4848, 0x3140B028},
	{0x484C, 0x2940B028},
	{0x4850, 0x8440B028},
	{0x4854, 0x2318C610},
	{0x4858, 0x45344753},
	{0x485C, 0x236A6A88},
	{0x4860, 0xAC8DF814},
	{0x4864, 0x08877ACB},
	{0x4868, 0x000107AA},
	{0x4A94, 0x00000000},
	{0x486C, 0xBCEB4A14},
	{0x4870, 0x000A3A4A},
	{0x4874, 0xBCEB4A14},
	{0x4878, 0x000A3A4A},
	{0x487C, 0xBCBDBD85},
	{0x4880, 0x0CABB99A},
	{0x4884, 0x38384242},
	{0x4888, 0x0086102E},
	{0x488C, 0xCA24C82A},
	{0x4AFC, 0x00000000},
	{0x4C14, 0x0000349D},
	{0x4CF8, 0x00000007},
	{0x4890, 0x00008A62},
	{0x4894, 0x00000008},
	{0x4958, 0x80040000},
	{0x495C, 0x80040000},
	{0x4960, 0xFE800000},
	{0x4964, 0x834C0000},
	{0x4968, 0x00000000},
	{0x496C, 0x00000000},
	{0x4970, 0x00000000},
	{0x4974, 0x00000000},
	{0x4978, 0x00000000},
	{0x497C, 0x00000000},
	{0x4980, 0x40000000},
	{0x4984, 0x00000000},
	{0x4988, 0x00000000},
	{0x498C, 0x00000000},
	{0x4990, 0x00000000},
	{0x4994, 0x04065800},
	{0x4998, 0x02004080},
	{0x499C, 0x0E1E3E05},
	{0x49A0, 0x0A163068},
	{0x49A4, 0x00206040},
	{0x49A8, 0x02020202},
	{0x49AC, 0x00002020},
	{0x49B0, 0xF8F8F418},
	{0x49B4, 0xF8E8F8F8},
	{0x49B8, 0xF80808E8},
	{0x4A00, 0xF8F8FA00},
	{0x4A04, 0xFAFAFAF8},
	{0x4A08, 0xFAFAFAFA},
	{0x49BC, 0x00000000},
	{0x49C0, 0x800C562D},
	{0x49C4, 0x00000101},
	{0x49C8, 0x00000000},
	{0x49CC, 0x00000000},
	{0x49D0, 0x00000000},
	{0x49D4, 0x00000000},
	{0x49D8, 0x00000000},
	{0x49DC, 0x00000000},
	{0x49E0, 0x00000000},
	{0x49E4, 0x00000000},
	{0x49E8, 0x00000000},
	{0x49EC, 0x00000000},
	{0x4C28, 0x00000000},
	{0x4C2C, 0x00000000},
	{0x4C30, 0x00000000},
	{0x4C34, 0x00000000},
	{0x4C38, 0x00000000},
	{0x4C3C, 0x00000000},
	{0x4C40, 0x00000000},
	{0x4C44, 0x01C0C832},
	{0x4C48, 0x03207032},
	{0x4C4C, 0x0320701C},
	{0x4C50, 0x03207032},
	{0x4C54, 0x01C0C81C},
	{0x4C58, 0x00A0281C},
	{0x4C5C, 0x0320C80A},
	{0x4C60, 0x00A0C832},
	{0x4C64, 0x01C0C832},
	{0x4C68, 0x03207032},
	{0x4C6C, 0x0320701C},
	{0x4C70, 0x03207032},
	{0x4C74, 0x01C0C81C},
	{0x4C78, 0x00A0281C},
	{0x4C7C, 0x0321A80A},
	{0x4C80, 0x0320C86A},
	{0x4C84, 0x12B02832},
	{0x4C88, 0x12B3292B},
	{0x4C8C, 0x0CA4ACCA},
	{0x4C90, 0x12B4AC6A},
	{0x4C94, 0x0CA4ACCA},
	{0x4C98, 0x06A3292B},
	{0x4C9C, 0x06A0280A},
	{0x4CA0, 0x0CA0286A},
	{0x4CA4, 0x0CA1A8CA},
	{0x4CA8, 0x06A3286A},
	{0x4CAC, 0x0000000A},
	{0x4CB0, 0x01209C27},
	{0x4CB4, 0x02704800},
	{0x4CB8, 0x02704812},
	{0x4CBC, 0x00004827},
	{0x4CC0, 0x01209C12},
	{0x4CC4, 0x00000012},
	{0x4CC8, 0x02718000},
	{0x4CCC, 0x02709C60},
	{0x4CD0, 0x00000027},
	{0x4CD4, 0x00000000},
	{0x4CD8, 0x0000014A},
	{0x994, 0x00000010},
	{0x904, 0x00000005},
	{0x708, 0x00000000},
	{0x884, 0x0043F01D},
	{0x710, 0xEF810000},
	{0x718, 0x1333233F},
	{0x604, 0x041E1E1E},
	{0x714, 0x00010000},
	{0x586C, 0x000000F0},
	{0x586C, 0x000000E0},
	{0x586C, 0x000000D0},
	{0x586C, 0x000000C0},
	{0x586C, 0x000000B0},
	{0x586C, 0x000000A0},
	{0x586C, 0x00000090},
	{0x586C, 0x00000080},
	{0x586C, 0x00000070},
	{0x586C, 0x00000060},
	{0x586C, 0x00000050},
	{0x586C, 0x00000040},
	{0x586C, 0x00000030},
	{0x586C, 0x00000020},
	{0x586C, 0x00000010},
	{0x586C, 0x00000000},
	{0xC0D4, 0xABA41460},
	{0xC0D8, 0xC43A7E87},
	{0xC0DC, 0x30C194B8},
	{0xC0E0, 0x75008138},
	{0xC0E4, 0x0000272B},
	{0xC0E8, 0x000A0C81},
	{0xC0EC, 0x00030003},
	{0xC0F0, 0x00000024},
	{0xC0C4, 0x005E3A00},
	{0xC004, 0x45800000},
	{0xC024, 0x45800000},
	{0x334, 0xFFFFFFFF},
	{0x33C, 0x55000000},
	{0x340, 0x00005555},
	{0x724, 0x00111200},
	{0x5868, 0xA9550000},
	{0x5870, 0x33221100},
	{0x5874, 0x77665544},
	{0x5878, 0xBBAA9988},
	{0x587C, 0xFFEEDDCC},
	{0x5880, 0x76543210},
	{0x5884, 0xFEDCBA98},
	{0x5888, 0x00000000},
	{0x588C, 0x00000000},
	{0x5894, 0x00000008},
	{0x650, 0x00200888},
	{0x710, 0xF3810000},
	{0x020, 0x0000F381},
	{0x024, 0x0000F381},
	{0x000, 0xC580801E},
	{0x980, 0x10002250},
	{0x988, 0x3C3C4107},
	{0x994, 0x00000010},
	{0x000, 0x0580801F},
	{0x240C, 0x00000000},
	{0x640, 0x210A141E},
	{0x640, 0x2114141E},
	{0x640, 0x2114141E},
	{0x644, 0x3414283C},
	{0x644, 0x3425283C},
	{0x644, 0x3426283C},
	{0x2640, 0x140A141E},
	{0x2640, 0x1414141E},
	{0x2640, 0x1414141E},
	{0x2644, 0x3414283C},
	{0x2644, 0x3425283C},
	{0x2644, 0x3425183C},
	{0x2300, 0x02748790},
	{0x2304, 0x00558670},
	{0x2308, 0x002883F0},
	{0x230C, 0x00090120},
	{0x2310, 0x00000000},
	{0x2314, 0x06000000},
	{0x2318, 0x00000000},
	{0x231C, 0x00000000},
	{0x2320, 0x03020100},
	{0x2324, 0x07060504},
	{0x2328, 0x0B0A0908},
	{0x232C, 0x0F0E0D0C},
	{0x2330, 0x13121110},
	{0x2334, 0x17161514},
	{0x2338, 0x0C700022},
	{0x233C, 0x0A0529D0},
	{0x2340, 0x000529D0},
	{0x2344, 0x0006318A},
	{0x2348, 0xB7E6318A},
	{0x234C, 0x80039C00},
	{0x2350, 0x80039C00},
	{0x2354, 0x0005298F},
	{0x2358, 0x0015296E},
	{0x235C, 0x0C07FC31},
	{0x2360, 0x0219AAAE},
	{0x2364, 0xE4F624C3},
	{0x2368, 0x53626F15},
	{0x236C, 0x48000000},
	{0x2370, 0x48000000},
	{0x2374, 0x07540000},
	{0x2378, 0x202401B9},
	{0x237C, 0x00F7000E},
	{0x2380, 0x0F0A1111},
	{0x2384, 0x30D9000F},
	{0x2388, 0x0200EA02},
	{0x238C, 0x003CB061},
	{0x2390, 0x69C00000},
	{0x2394, 0x00000000},
	{0x2398, 0x000000F0},
	{0x239C, 0x0001FFFF},
	{0x23A0, 0x00C80064},
	{0x23A4, 0x0190012C},
	{0x23A8, 0x001917BE},
	{0x23AC, 0x0B30880C},
	{0x23B0, 0x9281CE00},
	{0x23B4, 0x7F027C00},
	{0x704, 0x601E0502},
	{0x5600, 0x00000000},
	{0x5604, 0x802D2721},
	{0x5610, 0x00201020},
	{0x5618, 0x00801008},
	{0x5624, 0x0808081E},
	{0x562C, 0x0000081D},
	{0x5634, 0x3D2EE000},
	{0x5638, 0x0001AC42},
	{0x5640, 0x3D6EF000},
	{0x5644, 0x0001AC3E},
	{0x566C, 0x00210005},
	{0x5680, 0x20500010},
	{0x5684, 0x00020001},
	{0x56A0, 0x0034C000},
	{0x56BC, 0x04000000},
	{0x56C0, 0x00000688},
	{0x56C4, 0x00000010},
	{0x56C8, 0x0E800400},
	{0x56CC, 0x01E400FF},
	{0x5800, 0x003F807F},
	{0x5810, 0x59008400},
	{0x5814, 0x201AF000},
	{0x5818, 0x182C18E8},
	{0x581C, 0x3DD80280},
	{0x5820, 0x80000080},
	{0x5828, 0x023F8121},
	{0x5830, 0x023F8121},
	{0x5838, 0x003F8121},
	{0x5840, 0x023F8121},
	{0x5848, 0x023F8121},
	{0x5850, 0x023F8121},
	{0x5858, 0x003F7121},
	{0x5860, 0x023F7121},
	{0x5864, 0x1A1801FF},
	{0x5868, 0xA9A90002},
	{0x5880, 0x77777777},
	{0x5884, 0x77777777},
	{0x5894, 0x01080604},
	{0x5898, 0x00000000},
	{0x589C, 0x00000000},
	{0x58A0, 0x000000FE},
	{0x58B0, 0x00000800},
	{0x58BC, 0x07A7807F},
	{0x58C0, 0x007E0000},
	{0x58C4, 0x0003FFFF},
	{0x58D4, 0x7401FE00},
	{0x58D8, 0x8008016C},
	{0x58DC, 0xC000807F},
	{0x58E4, 0x3000881F},
	{0x58E8, 0x00000003},
	{0x58F0, 0x400401FF},
	{0x58F4, 0x80000000},
	{0x58F8, 0xC0000000},
	{0x58FC, 0x00000000},
	{0x700, 0x40000030},
	{0x704, 0x601E0502},
	{0x704, 0x601E0500},
	{0x704, 0x601E0502},
	{0x20FC, 0x00000000},
	{0x20F8, 0x00000000},
	{0x20F0, 0x00000000},
	{0x9C0, 0x00000001},
	{0x9C0, 0x00000000},
	{0x9C0, 0x00000001},
	{0x9C0, 0x00000000},
	{0x4AE8, 0x00000744},
	{0x4AD4, 0x00000040},
	{0x4AE4, 0x0079E99E},
	{0x4BC8, 0xFBD5B89F},
	{0x4BCC, 0x99563918},
	{0x4BD0, 0x12EED5B8},
	{0x4BD4, 0x6F7D542F},
	{0x4BD8, 0x0000001D},
	{0x300, 0xF30CE31C},
	{0x304, 0x13EF1F19},
	{0x308, 0x0C0CF3F3},
	{0x30C, 0x0CE30C0C},
	{0x310, 0x80496000},
	{0x314, 0x0041E000},
	{0x318, 0x20022042},
	{0x31C, 0x20448009},
	{0x320, 0x00010031},
	{0x324, 0xE000E000},
	{0x328, 0xE000E000},
	{0x32C, 0xE0008049},
	{0x12BC, 0x10104041},
	{0x12C0, 0x13311111},
	{0x12E4, 0x30D52A68},
	{0x010, 0x0005FFFF},
	{0x028, 0x0000F381},
	{0x02C, 0x0000F381},
	{0x620, 0x00141230},
	{0x70C, 0x00000020},
	{0x720, 0x20000000},
	{0x730, 0x00000002},
	{0x738, 0x004100C0},
	{0x73C, 0x00000002},
	{0x748, 0x01000002},
	{0x74C, 0x00000001},
	{0xA08, 0x00007800},
	{0xC14, 0x25010000},
	{0xC3C, 0x2840E1BF},
	{0xC40, 0x00000000},
	{0xC44, 0x00000007},
	{0xC48, 0x410E4000},
	{0xC54, 0x1EE14368},
	{0xC58, 0x41000000},
	{0xC5C, 0x80558000},
	{0xC60, 0x017FFFF2},
	{0xC64, 0x0010A130},
	{0xC68, 0x90000050},
	{0xC6C, 0x10201021},
	{0xC70, 0x071B0660},
	{0xC74, 0x00000000},
	{0xC78, 0x80000000},
	{0xC7C, 0x0020BFE0},
	{0xC88, 0xC2AC8000},
	{0xC8C, 0x02F2FC08},
	{0xD00, 0x77777777},
	{0xD04, 0xBBBBBBBB},
	{0xD08, 0xBBBBBBBB},
	{0xD0C, 0x000B2070},
	{0xD10, 0x20110FFF},
	{0xD18, 0x50009800},
	{0xD20, 0x01900000},
	{0xD30, 0x03FF8000},
	{0xD40, 0xF64FA0F7},
	{0xD44, 0x0401463F},
	{0xD48, 0x0003FF7F},
	{0xD4C, 0x00000000},
	{0xD50, 0xF64FA0F7},
	{0xD54, 0x04100437},
	{0xD58, 0x0000FF7F},
	{0xD5C, 0x00000000},
	{0xD60, 0x00000000},
	{0xD64, 0x00000000},
	{0xD70, 0x00000015},
	{0xD78, 0x00000001},
	{0xD7C, 0x001D050E},
	{0xD80, 0x00000100},
	{0xD84, 0x00006607},
	{0xD90, 0x000003FF},
	{0xD94, 0x00000000},
	{0xD98, 0x0000003F},
	{0xD9C, 0x00000000},
	{0xDA0, 0x000003FE},
	{0xDA4, 0x00000000},
	{0xDA8, 0x0000003F},
	{0xDAC, 0x00000000},
	{0xDD4, 0x00000000},
	{0x1010, 0x00000000},
	{0x2000, 0x50BBBF04},
	{0x2008, 0x000FFFFF},
	{0x5800, 0x03FF807F},
	{0x5804, 0x04237040},
	{0x5808, 0x04237040},
	{0x5818, 0x082C1800},
	{0x624, 0x0101030A},
	{0x241C, 0x00000001},
	{0xC0F8, 0x00000001},
	{0x35C, 0x000004C4},
	{0x1200, 0x00010142},
	{0x120C, 0x00012233},
	{0x1210, 0x8049E304},
	{0x12A0, 0x49107056},
	{0x12A8, 0x33337025},
	{0x12AC, 0x12333121},
	{0x12B8, 0x30020000},
	{0x0F0, 0x00000001},
	{0x0F4, 0x00000011},
	{0x0F8, 0x20230307},
};

static const struct rtw89_reg2_def rtw89_8851b_phy_bb_reg_gain[] = {
	{0xF00100FF, 0x00000000},
	{0xF00200FF, 0x00000001},
	{0xF00300FF, 0x00000002},
	{0xF00400FF, 0x00000003},
	{0xF00500FF, 0x00000004},
	{0xF00600FF, 0x00000005},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x000, 0x13F6D7B6},
	{0x001, 0x00725132},
	{0x002, 0x00005A38},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x000, 0x13F6D7B6},
	{0x001, 0x00725132},
	{0x002, 0x00005A38},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x000, 0x13F6D7B6},
	{0x001, 0x00725132},
	{0x002, 0x00005A38},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x000, 0x19FADCBC},
	{0x001, 0x007A5A3A},
	{0x002, 0x00005838},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x000, 0x19FADCBC},
	{0x001, 0x007A5A3A},
	{0x002, 0x00005838},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x000, 0x19FADCBC},
	{0x001, 0x007A5A3A},
	{0x002, 0x00005838},
	{0xA0000000, 0x00000000},
	{0x000, 0x13F6D7B6},
	{0x001, 0x00725132},
	{0x002, 0x00005A38},
	{0xB0000000, 0x00000000},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x100, 0x1BFEE0B7},
	{0x101, 0x006C5238},
	{0x102, 0x00005031},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x100, 0x1BFEE0B7},
	{0x101, 0x006C5238},
	{0x102, 0x00005031},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x100, 0x1BFEE0B7},
	{0x101, 0x006C5238},
	{0x102, 0x00005031},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x100, 0x1BFEE0B7},
	{0x101, 0x006C5238},
	{0x102, 0x00005031},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x100, 0x1BFEE0B7},
	{0x101, 0x006C5238},
	{0x102, 0x00005031},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x100, 0x1BFEE0B7},
	{0x101, 0x006C5238},
	{0x102, 0x00005031},
	{0xA0000000, 0x00000000},
	{0x100, 0x1BFEE0B7},
	{0x101, 0x006C5238},
	{0x102, 0x00005031},
	{0xB0000000, 0x00000000},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x19F8D8C1},
	{0x10001, 0x006F4F31},
	{0x10002, 0x00006F58},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x19F8D8C1},
	{0x10001, 0x006F4F31},
	{0x10002, 0x00006F58},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x19F8D8C1},
	{0x10001, 0x006F4F31},
	{0x10002, 0x00006F58},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x1DF8DAC1},
	{0x10001, 0x00755437},
	{0x10002, 0x00007058},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x1DF8DAC1},
	{0x10001, 0x00755437},
	{0x10002, 0x00007058},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10000, 0x1DF8DAC1},
	{0x10001, 0x00755437},
	{0x10002, 0x00007058},
	{0xA0000000, 0x00000000},
	{0x10000, 0x19F8D8C1},
	{0x10001, 0x006F4F31},
	{0x10002, 0x00006F58},
	{0xB0000000, 0x00000000},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x09E9C69F},
	{0x10101, 0x00674627},
	{0x10102, 0x00006750},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x09E9C69F},
	{0x10101, 0x00674627},
	{0x10102, 0x00006750},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x09E9C69F},
	{0x10101, 0x00674627},
	{0x10102, 0x00006750},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x09E9C69F},
	{0x10101, 0x00674627},
	{0x10102, 0x00006750},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x09E9C69F},
	{0x10101, 0x00674627},
	{0x10102, 0x00006750},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x10100, 0x09E9C69F},
	{0x10101, 0x00674627},
	{0x10102, 0x00006750},
	{0xA0000000, 0x00000000},
	{0x10100, 0x09E9C69F},
	{0x10101, 0x00674627},
	{0x10102, 0x00006750},
	{0xB0000000, 0x00000000},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x1AF0D2B8},
	{0x20001, 0x00755334},
	{0x20002, 0x00006F58},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x1AF0D2B8},
	{0x20001, 0x00755334},
	{0x20002, 0x00006F58},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x1AF0D2B8},
	{0x20001, 0x00755334},
	{0x20002, 0x00006F58},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x1D00E2C8},
	{0x20001, 0x00775336},
	{0x20002, 0x00006D58},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x1D00E2C8},
	{0x20001, 0x00775336},
	{0x20002, 0x00006D58},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20000, 0x1D00E2C8},
	{0x20001, 0x00775336},
	{0x20002, 0x00006D58},
	{0xA0000000, 0x00000000},
	{0x20000, 0x1AF0D2B8},
	{0x20001, 0x00755334},
	{0x20002, 0x00006F58},
	{0xB0000000, 0x00000000},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x07E9C6A0},
	{0x20101, 0x00674728},
	{0x20102, 0x00006850},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x07E9C6A0},
	{0x20101, 0x00674728},
	{0x20102, 0x00006850},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x07E9C6A0},
	{0x20101, 0x00674728},
	{0x20102, 0x00006850},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x07E9C6A0},
	{0x20101, 0x00674728},
	{0x20102, 0x00006850},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x07E9C6A0},
	{0x20101, 0x00674728},
	{0x20102, 0x00006850},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x20100, 0x07E9C6A0},
	{0x20101, 0x00674728},
	{0x20102, 0x00006850},
	{0xA0000000, 0x00000000},
	{0x20100, 0x07E9C6A0},
	{0x20101, 0x00674728},
	{0x20102, 0x00006850},
	{0xB0000000, 0x00000000},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x15EED2B6},
	{0x30001, 0x006F4D2F},
	{0x30002, 0x00006F58},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x15EED2B6},
	{0x30001, 0x006F4D2F},
	{0x30002, 0x00006F58},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x15EED2B6},
	{0x30001, 0x006F4D2F},
	{0x30002, 0x00006F58},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x1F00E2C6},
	{0x30001, 0x00795739},
	{0x30002, 0x00006F58},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x1F00E2C6},
	{0x30001, 0x00795739},
	{0x30002, 0x00006F58},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30000, 0x1F00E2C6},
	{0x30001, 0x00795739},
	{0x30002, 0x00006F58},
	{0xA0000000, 0x00000000},
	{0x30000, 0x15EED2B6},
	{0x30001, 0x006F4D2F},
	{0x30002, 0x00006F58},
	{0xB0000000, 0x00000000},
	{0x800100ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x06E9C69F},
	{0x30101, 0x00654527},
	{0x30102, 0x00006750},
	{0x900200ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x06E9C69F},
	{0x30101, 0x00654527},
	{0x30102, 0x00006750},
	{0x900300ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x06E9C69F},
	{0x30101, 0x00654527},
	{0x30102, 0x00006750},
	{0x900400ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x06E9C69F},
	{0x30101, 0x00654527},
	{0x30102, 0x00006750},
	{0x900500ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x06E9C69F},
	{0x30101, 0x00654527},
	{0x30102, 0x00006750},
	{0x900600ff, 0x00000000}, {0x40000000, 0x00000000},
	{0x30100, 0x06E9C69F},
	{0x30101, 0x00654527},
	{0x30102, 0x00006750},
	{0xA0000000, 0x00000000},
	{0x30100, 0x06E9C69F},
	{0x30101, 0x00654527},
	{0x30102, 0x00006750},
	{0xB0000000, 0x00000000},
	{0x1000000, 0x000000F4},
	{0x1000010, 0x000000F8},
	{0x1000011, 0x0000F8F8},
	{0x1000100, 0x000000F8},
	{0x1000110, 0x00000000},
	{0x1000111, 0x00000000},
	{0x1010000, 0x000000F4},
	{0x1010010, 0x000000F8},
	{0x1010011, 0x0000F8F8},
	{0x1010020, 0x000000F8},
	{0x1010021, 0x0808E8E8},
	{0x1010029, 0x0000F8F8},
	{0x1010100, 0x000000F4},
	{0x1010110, 0x000000F8},
	{0x1010111, 0x0000F8F8},
	{0x1010120, 0x000000F8},
	{0x1010121, 0x0808E8E8},
	{0x1010129, 0x0000F8F8},
	{0x1020000, 0x000000F4},
	{0x1020010, 0x000000F8},
	{0x1020011, 0x0000F8F8},
	{0x1020020, 0x000000F8},
	{0x1020021, 0x0808E8E8},
	{0x1020029, 0x0000F8F8},
	{0x1020100, 0x000000F4},
	{0x1020110, 0x000000F8},
	{0x1020111, 0x0000F8F8},
	{0x1020120, 0x000000F8},
	{0x1020121, 0x0808E8E8},
	{0x1020129, 0x0000F8F8},
	{0x1030000, 0x000000F4},
	{0x1030010, 0x000000F8},
	{0x1030011, 0x0000F8F8},
	{0x1030020, 0x000000F8},
	{0x1030021, 0x0808E8E8},
	{0x1030029, 0x0000F8F8},
	{0x1030100, 0x000000F4},
	{0x1030110, 0x000000F8},
	{0x1030111, 0x0000F8F8},
	{0x1030120, 0x000000F8},
	{0x1030121, 0x0808E8E8},
	{0x1030129, 0x0000F8F8},
};

static const struct rtw89_reg2_def rtw89_8851b_phy_radioa_regs[] = {
	{0xF0010000, 0x00000000},
	{0xF0020000, 0x00000001},
	{0xF0030000, 0x00000002},
	{0xF0010001, 0x00000003},
	{0xF0020001, 0x00000004},
	{0xF0030001, 0x00000005},
	{0xF0040001, 0x00000006},
	{0xF0050001, 0x00000007},
	{0xF0060001, 0x00000008},
	{0x000, 0x00000000},
	{0x0EF, 0x00080000},
	{0x033, 0x00000003},
	{0x03E, 0x00000150},
	{0x03F, 0x0000D79C},
	{0x0EF, 0x00000000},
	{0x052, 0x000C3338},
	{0x053, 0x000608AF},
	{0x054, 0x00006C04},
	{0x063, 0x000FC082},
	{0x065, 0x00018122},
	{0x000, 0x00010000},
	{0x0FE, 0x0000005A},
	{0x000, 0x00030000},
	{0x018, 0x00013124},
	{0x0EF, 0x00080000},
	{0x033, 0x00000008},
	{0x03E, 0x00000110},
	{0x03F, 0x0000D39C},
	{0x033, 0x0000000C},
	{0x03E, 0x00000110},
	{0x03F, 0x0000F79E},
	{0x0EF, 0x00000000},
	{0x01B, 0x00003A40},
	{0x08F, 0x000C170E},
	{0x08E, 0x00005160},
	{0x002, 0x00000600},
	{0x0EE, 0x00000002},
	{0x033, 0x00000002},
	{0x03F, 0x0000003F},
	{0x033, 0x00000003},
	{0x03F, 0x0000003F},
	{0x033, 0x00000004},
	{0x03F, 0x0000003F},
	{0x033, 0x00000005},
	{0x03F, 0x0000003F},
	{0x033, 0x00000006},
	{0x03F, 0x0000003F},
	{0x033, 0x00000007},
	{0x03F, 0x0000003F},
	{0x033, 0x00000008},
	{0x03F, 0x0000003F},
	{0x033, 0x0000000C},
	{0x03F, 0x0000003F},
	{0x033, 0x0000000D},
	{0x03F, 0x0000003F},
	{0x033, 0x0000000E},
	{0x03F, 0x0000003F},
	{0x0EE, 0x00000000},
	{0x0EF, 0x00004000},
	{0x033, 0x00000007},
	{0x03E, 0x00000000},
	{0x03F, 0x00000707},
	{0x033, 0x00000006},
	{0x03E, 0x00000000},
	{0x03F, 0x00000704},
	{0x033, 0x00000005},
	{0x03E, 0x00000000},
	{0x03F, 0x00020500},
	{0x033, 0x00000004},
	{0x03E, 0x00000000},
	{0x03F, 0x00010404},
	{0x033, 0x00000003},
	{0x03E, 0x00000000},
	{0x03F, 0x00099B04},
	{0x033, 0x00000002},
	{0x03E, 0x00000000},
	{0x03F, 0x00092B04},
	{0x033, 0x00000001},
	{0x03E, 0x00000000},
	{0x03F, 0x000B3204},
	{0x033, 0x00000000},
	{0x03E, 0x00000000},
	{0x03F, 0x00003000},
	{0x033, 0x00000017},
	{0x03E, 0x00000000},
	{0x03F, 0x00000787},
	{0x033, 0x00000016},
	{0x03E, 0x00000000},
	{0x03F, 0x00000784},
	{0x033, 0x00000015},
	{0x03E, 0x00000000},
	{0x03F, 0x00020580},
	{0x033, 0x00000014},
	{0x03E, 0x00000000},
	{0x03F, 0x00010484},
	{0x033, 0x00000013},
	{0x03E, 0x00000000},
	{0x03F, 0x00099B84},
	{0x033, 0x00000012},
	{0x03E, 0x00000000},
	{0x03F, 0x00092B84},
	{0x033, 0x00000011},
	{0x03E, 0x00000000},
	{0x03F, 0x000B3284},
	{0x033, 0x00000010},
	{0x03E, 0x00000000},
	{0x03F, 0x00003080},
	{0x0EF, 0x00000000},
	{0x0EE, 0x00000010},
	{0x033, 0x00000006},
	{0x03F, 0x00000003},
	{0x033, 0x00000007},
	{0x03F, 0x00000003},
	{0x0EE, 0x00000000},
	{0x0EF, 0x00001000},
	{0x033, 0x00000000},
	{0x03F, 0x00000034},
	{0x033, 0x00000001},
	{0x03F, 0x00000037},
	{0x033, 0x00000002},
	{0x03F, 0x00000034},
	{0x033, 0x00000003},
	{0x03F, 0x00000024},
	{0x033, 0x00000004},
	{0x03F, 0x00000037},
	{0x033, 0x00000005},
	{0x03F, 0x00000027},
	{0x0EF, 0x00000000},
	{0x0EC, 0x00000400},
	{0x033, 0x00000001},
	{0x03F, 0x00000022},
	{0x033, 0x00000003},
	{0x03F, 0x00000022},
	{0x033, 0x00000009},
	{0x03F, 0x00000022},
	{0x0EC, 0x00000000},
	{0x0EC, 0x00000004},
	{0x033, 0x00000000},
	{0x03F, 0x000000AE},
	{0x033, 0x00000001},
	{0x03F, 0x0000008C},
	{0x033, 0x00000002},
	{0x03F, 0x0000006A},
	{0x033, 0x00000003},
	{0x03F, 0x00000048},
	{0x033, 0x00000004},
	{0x03F, 0x00000026},
	{0x033, 0x00000005},
	{0x03F, 0x00000004},
	{0x033, 0x00000006},
	{0x03F, 0x00000002},
	{0x033, 0x00000007},
	{0x03F, 0x00000000},
	{0x0EC, 0x00000000},
	{0x0EF, 0x00008000},
	{0x033, 0x00000007},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x00000006},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x00000005},
	{0x03E, 0x00000003},
	{0x03F, 0x00001DB0},
	{0x033, 0x00000004},
	{0x03E, 0x00000003},
	{0x03F, 0x00001CB0},
	{0x033, 0x00000003},
	{0x03E, 0x00000003},
	{0x03F, 0x00001BB0},
	{0x033, 0x00000002},
	{0x03E, 0x00000003},
	{0x03F, 0x00001AB0},
	{0x033, 0x00000001},
	{0x03E, 0x00000003},
	{0x03F, 0x0000D9BC},
	{0x033, 0x00000000},
	{0x03E, 0x00000003},
	{0x03F, 0x0000D4BC},
	{0x033, 0x00000017},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x00000016},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x00000015},
	{0x03E, 0x00000003},
	{0x03F, 0x00001DB0},
	{0x033, 0x00000014},
	{0x03E, 0x00000003},
	{0x03F, 0x00001CB0},
	{0x033, 0x00000013},
	{0x03E, 0x00000003},
	{0x03F, 0x00001BB0},
	{0x033, 0x00000012},
	{0x03E, 0x00000003},
	{0x03F, 0x00001AB0},
	{0x033, 0x00000011},
	{0x03E, 0x00000003},
	{0x03F, 0x0000D9BC},
	{0x033, 0x00000010},
	{0x03E, 0x00000003},
	{0x03F, 0x0000D4BC},
	{0x033, 0x00000027},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x00000026},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x00000025},
	{0x03E, 0x00000003},
	{0x03F, 0x00001DB0},
	{0x033, 0x00000024},
	{0x03E, 0x00000003},
	{0x03F, 0x00001CB0},
	{0x033, 0x00000023},
	{0x03E, 0x00000003},
	{0x03F, 0x00001BB0},
	{0x033, 0x00000022},
	{0x03E, 0x00000003},
	{0x03F, 0x00001AB0},
	{0x033, 0x00000021},
	{0x03E, 0x00000003},
	{0x03F, 0x0000D9BC},
	{0x033, 0x00000020},
	{0x03E, 0x00000003},
	{0x03F, 0x0000D4BC},
	{0x033, 0x0000000E},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x0000000D},
	{0x03E, 0x00000003},
	{0x03F, 0x00001DB0},
	{0x033, 0x0000000C},
	{0x03E, 0x00000003},
	{0x03F, 0x00001CB0},
	{0x033, 0x0000000B},
	{0x03E, 0x00000003},
	{0x03F, 0x00091BB0},
	{0x033, 0x0000000A},
	{0x03E, 0x00000003},
	{0x03F, 0x000A9AB0},
	{0x033, 0x00000009},
	{0x03E, 0x00000003},
	{0x03F, 0x000BD9BC},
	{0x033, 0x00000008},
	{0x03E, 0x00000003},
	{0x03F, 0x0009D4BC},
	{0x033, 0x0000001E},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x0000001D},
	{0x03E, 0x00000003},
	{0x03F, 0x00001DB0},
	{0x033, 0x0000001C},
	{0x03E, 0x00000003},
	{0x03F, 0x00001CB0},
	{0x033, 0x0000001B},
	{0x03E, 0x00000003},
	{0x03F, 0x00091BB0},
	{0x033, 0x0000001A},
	{0x03E, 0x00000003},
	{0x03F, 0x00099AB0},
	{0x033, 0x00000019},
	{0x03E, 0x00000003},
	{0x03F, 0x000AD9BC},
	{0x033, 0x00000018},
	{0x03E, 0x00000003},
	{0x03F, 0x0009D4BC},
	{0x033, 0x0000002E},
	{0x03E, 0x00000003},
	{0x03F, 0x00001FB0},
	{0x033, 0x0000002D},
	{0x03E, 0x00000003},
	{0x03F, 0x00001DB0},
	{0x033, 0x0000002C},
	{0x03E, 0x00000003},
	{0x03F, 0x00001CB0},
	{0x033, 0x0000002B},
	{0x03E, 0x00000003},
	{0x03F, 0x00001BB0},
	{0x033, 0x0000002A},
	{0x03E, 0x00000003},
	{0x03F, 0x00009AB0},
	{0x033, 0x00000029},
	{0x03E, 0x00000003},
	{0x03F, 0x0009D9BC},
	{0x033, 0x00000028},
	{0x03E, 0x00000003},
	{0x03F, 0x0000D4BC},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00002000},
	{0x033, 0x00000000},
	{0x03F, 0x00000005},
	{0x033, 0x00000001},
	{0x03F, 0x00000004},
	{0x033, 0x00000002},
	{0x03F, 0x00000004},
	{0x033, 0x00000004},
	{0x03F, 0x0000000C},
	{0x033, 0x00000005},
	{0x03F, 0x00000003},
	{0x033, 0x00000006},
	{0x03F, 0x00000003},
	{0x0EF, 0x00000000},
	{0x06C, 0x00038085},
	{0x06D, 0x00000D6B},
	{0x06E, 0x0001FB89},
	{0x06F, 0x00097B99},
	{0x069, 0x00008040},
	{0x0EF, 0x00000200},
	{0x033, 0x00000004},
	{0x03F, 0x000008FF},
	{0x033, 0x00000005},
	{0x03F, 0x000004F2},
	{0x033, 0x00000006},
	{0x03F, 0x00000217},
	{0x033, 0x00000007},
	{0x03F, 0x00000131},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000400},
	{0x033, 0x00000004},
	{0x03F, 0x000004F7},
	{0x033, 0x00000005},
	{0x03F, 0x000004F7},
	{0x033, 0x00000006},
	{0x03F, 0x000004F2},
	{0x033, 0x00000007},
	{0x03F, 0x00000117},
	{0x0EF, 0x00000000},
	{0x043, 0x00005000},
	{0x036, 0x000147D0},
	{0x0B0, 0x0008677C},
	{0x0B1, 0x00012920},
	{0x0BB, 0x000EF000},
	{0x0CB, 0x000A9594},
	{0x0CC, 0x000C36D2},
	{0x0CD, 0x00024923},
	{0x0CE, 0x00020180},
	{0x0CF, 0x00000000},
	{0x0D5, 0x0006E27A},
	{0x0D8, 0x00000044},
	{0x0D9, 0x00000007},
	{0x0DD, 0x00000020},
	{0x0E3, 0x0000002C},
	{0x0B7, 0x0000000C},
	{0x0E1, 0x000080C0},
	{0x0E4, 0x00000380},
	{0x0ED, 0x00002000},
	{0x033, 0x00000001},
	{0x03D, 0x000A6094},
	{0x03E, 0x00003449},
	{0x03F, 0x00000001},
	{0x033, 0x00000003},
	{0x03D, 0x000AA094},
	{0x03E, 0x00003449},
	{0x03F, 0x00000001},
	{0x0ED, 0x00000000},
	{0x0ED, 0x00000100},
	{0x033, 0x00000000},
	{0x03F, 0x0000007F},
	{0x033, 0x00000001},
	{0x03F, 0x0000007F},
	{0x033, 0x00000002},
	{0x03F, 0x0000007F},
	{0x033, 0x00000003},
	{0x03F, 0x0000007F},
	{0x033, 0x00000004},
	{0x03F, 0x0000007F},
	{0x033, 0x00000005},
	{0x03F, 0x0000007F},
	{0x033, 0x00000007},
	{0x03F, 0x0000007F},
	{0x033, 0x00000008},
	{0x03F, 0x0000007F},
	{0x033, 0x00000009},
	{0x03F, 0x0000007F},
	{0x0ED, 0x00000000},
	{0x0ED, 0x00000080},
	{0x033, 0x00000000},
	{0x03E, 0x000007E1},
	{0x03F, 0x0001F87F},
	{0x033, 0x00000010},
	{0x03E, 0x000007E1},
	{0x03F, 0x0001F87F},
	{0x033, 0x00000030},
	{0x03E, 0x000007E1},
	{0x03F, 0x0001F87F},
	{0x033, 0x00000040},
	{0x03E, 0x000007E1},
	{0x03F, 0x0001F87F},
	{0x033, 0x00000050},
	{0x03E, 0x000007E1},
	{0x03F, 0x0001F87F},
	{0x033, 0x00000070},
	{0x03E, 0x000007E1},
	{0x03F, 0x0001F87F},
	{0x0ED, 0x00000000},
	{0x0ED, 0x00000004},
	{0x033, 0x00000000},
	{0x03F, 0x00008420},
	{0x0ED, 0x00000000},
	{0x018, 0x00011108},
	{0x0B9, 0x00000000},
	{0x0B9, 0x00000000},
	{0x0B9, 0x00000200},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0FF, 0x00000000},
	{0x0B9, 0x00000000},
	{0x018, 0x00013124},
	{0x05A, 0x0006808F},
	{0x0ED, 0x00000008},
	{0x033, 0x00000001},
	{0x03F, 0x0000000F},
	{0x0ED, 0x00000000},
	{0x000, 0x00020000},
	{0x018, 0x00010124},
	{0x0EE, 0x00000800},
	{0x033, 0x00000004},
	{0x03F, 0x00000002},
	{0x033, 0x00000005},
	{0x03F, 0x00000003},
	{0x033, 0x00000006},
	{0x03F, 0x00000006},
	{0x033, 0x00000007},
	{0x03F, 0x00000007},
	{0x0EE, 0x00000000},
	{0x0EE, 0x00001000},
	{0x033, 0x00000008},
	{0x03F, 0x00000000},
	{0x033, 0x00000009},
	{0x03F, 0x00000001},
	{0x033, 0x0000000A},
	{0x03F, 0x00000003},
	{0x033, 0x0000000B},
	{0x03F, 0x00000103},
	{0x033, 0x0000000C},
	{0x03F, 0x00000107},
	{0x033, 0x0000000D},
	{0x03F, 0x00000207},
	{0x033, 0x0000000E},
	{0x03F, 0x00000307},
	{0x033, 0x0000000F},
	{0x03F, 0x00000307},
	{0x0EE, 0x00000000},
	{0x0EE, 0x00000200},
	{0x033, 0x00000004},
	{0x03F, 0x00000000},
	{0x033, 0x00000005},
	{0x03F, 0x00000001},
	{0x033, 0x00000006},
	{0x03F, 0x00000002},
	{0x033, 0x00000007},
	{0x03F, 0x00000003},
	{0x0EE, 0x00000000},
	{0x011, 0x00014062},
	{0x0EF, 0x00000010},
	{0x033, 0x00000001},
	{0x03F, 0x00000DF3},
	{0x033, 0x00000002},
	{0x03F, 0x00000DF3},
	{0x033, 0x00000003},
	{0x03F, 0x00000A83},
	{0x033, 0x00000004},
	{0x03F, 0x00000A83},
	{0x033, 0x00000005},
	{0x03F, 0x00000643},
	{0x033, 0x00000006},
	{0x03F, 0x00000643},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000100},
	{0x033, 0x00000001},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000002},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000003},
	{0x03F, 0x0001B5A9},
	{0x033, 0x00000004},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000005},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000006},
	{0x03F, 0x0001B589},
	{0x033, 0x00000007},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000008},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000009},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000000A},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000000B},
	{0x03F, 0x0001B5A9},
	{0x033, 0x0000000C},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000000D},
	{0x03F, 0x0001B5A9},
	{0x033, 0x0000000E},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000000F},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000010},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000011},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000012},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000013},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000014},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000015},
	{0x03F, 0x0001B589},
	{0x033, 0x00000016},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000017},
	{0x03F, 0x0001B5A9},
	{0x033, 0x00000018},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000019},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000001A},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000001B},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000001C},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000001D},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000001E},
	{0x03F, 0x0001B5A8},
	{0x033, 0x0000001F},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000020},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000021},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000022},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000023},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000024},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000025},
	{0x03F, 0x0001B5A8},
	{0x033, 0x00000022},
	{0x03F, 0x0001B5A8},
	{0x0EF, 0x00000000},
	{0x0EF, 0x00000040},
	{0x033, 0x00000001},
	{0x03F, 0x000002C5},
	{0x033, 0x00000002},
	{0x03F, 0x000002C5},
	{0x033, 0x00000003},
	{0x03F, 0x000002C5},
	{0x033, 0x00000004},
	{0x03F, 0x000002C5},
	{0x033, 0x00000005},
	{0x03F, 0x000002C5},
	{0x033, 0x00000006},
	{0x03F, 0x000002C5},
	{0x033, 0x00000007},
	{0x03F, 0x000002C5},
	{0x033, 0x00000008},
	{0x03F, 0x000002C5},
	{0x033, 0x00000009},
	{0x03F, 0x000002C5},
	{0x033, 0x0000000A},
	{0x03F, 0x000002C5},
	{0x033, 0x0000000B},
	{0x03F, 0x000002C5},
	{0x0EF, 0x00000000},
	{0x059, 0x00050033},
	{0x061, 0x0005F48A},
	{0x062, 0x00077435},
	{0x067, 0x00008060},
	{0x07E, 0x0009780B},
	{0x0EE, 0x00000004},
	{0x033, 0x0000000B},
	{0x03F, 0x0000000B},
	{0x033, 0x0000000C},
	{0x03F, 0x00000012},
	{0x033, 0x0000000D},
	{0x03F, 0x00000019},
	{0x033, 0x0000000F},
	{0x03F, 0x0000000B},
	{0x033, 0x00000010},
	{0x03F, 0x00000012},
	{0x033, 0x00000011},
	{0x03F, 0x00000019},
	{0x03F, 0x00000000},
	{0x0EE, 0x00000000},
	{0x0EE, 0x00000800},
	{0x033, 0x00000000},
	{0x03F, 0x00000001},
	{0x033, 0x00000001},
	{0x03F, 0x00000002},
	{0x033, 0x00000002},
	{0x03F, 0x00000003},
	{0x033, 0x00000003},
	{0x03F, 0x00000007},
	{0x0EE, 0x00000000},
	{0x0EE, 0x00001000},
	{0x033, 0x00000000},
	{0x03F, 0x00003000},
	{0x033, 0x00000001},
	{0x03F, 0x00000000},
	{0x033, 0x00000002},
	{0x03F, 0x00000001},
	{0x033, 0x00000003},
	{0x03F, 0x00000003},
	{0x033, 0x00000004},
	{0x03F, 0x00000007},
	{0x033, 0x00000005},
	{0x03F, 0x0000000F},
	{0x033, 0x00000006},
	{0x03F, 0x0000010F},
	{0x033, 0x00000007},
	{0x03F, 0x0000030F},
	{0x0EE, 0x00000000},
	{0x0EE, 0x00000200},
	{0x033, 0x00000000},
	{0x03F, 0x00000004},
	{0x033, 0x00000001},
	{0x03F, 0x00000005},
	{0x033, 0x00000002},
	{0x03F, 0x00000006},
	{0x033, 0x00000003},
	{0x03F, 0x00000007},
	{0x0EE, 0x00000000},
	{0x0EF, 0x00000080},
	{0x033, 0x00000004},
	{0x03E, 0x0000001D},
	{0x03F, 0x0001A241},
	{0x033, 0x00000005},
	{0x03E, 0x0000001D},
	{0x03F, 0x0001A241},
	{0x033, 0x00000006},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000007},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000008},
	{0x03E, 0x0000001D},
	{0x03F, 0x0001A241},
	{0x033, 0x00000009},
	{0x03E, 0x0001A241},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000000A},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000000B},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000000C},
	{0x03E, 0x0000001D},
	{0x03F, 0x0001A241},
	{0x033, 0x0000000D},
	{0x03E, 0x0000001D},
	{0x03F, 0x0001A241},
	{0x033, 0x0000000E},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000000F},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000010},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x00000011},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x00000012},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000013},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000014},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x00000015},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x00000016},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000017},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000018},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x00000019},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x0000001A},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000001B},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000001C},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x0000001D},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x0000001E},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000001F},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000020},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x00000021},
	{0x03E, 0x0000001C},
	{0x03F, 0x000199C1},
	{0x033, 0x00000022},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000023},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000024},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x00000025},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x00000026},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000027},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000028},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x00000029},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x0000002A},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000002B},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000002C},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x0000002D},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x0000002E},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000002F},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000030},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x00000031},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x00000032},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000033},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000034},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x00000035},
	{0x03E, 0x0000001C},
	{0x03F, 0x0001E141},
	{0x033, 0x00000036},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000037},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000038},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x00000039},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C1},
	{0x033, 0x0000003A},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C3},
	{0x033, 0x0000003B},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C3},
	{0x033, 0x0000003C},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C3},
	{0x033, 0x0000003D},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C3},
	{0x033, 0x0000003E},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C3},
	{0x033, 0x0000003F},
	{0x03E, 0x0000001B},
	{0x03F, 0x0001C3C3},
	{0x0EF, 0x00000000},
	{0x051, 0x0003D368},
	{0x058, 0x00084221},
	{0x05B, 0x000EB000},
	{0x100EE, 0x00002000},
	{0x10030, 0x000000F9},
	{0x10030, 0x000004F6},
	{0x10030, 0x000008F3},
	{0x10030, 0x00000CF0},
	{0x10030, 0x000010ED},
	{0x10030, 0x000014EA},
	{0x10030, 0x000018E7},
	{0x10030, 0x00001CE4},
	{0x10030, 0x000020E1},
	{0x10030, 0x000024A4},
	{0x10030, 0x000028A1},
	{0x10030, 0x00002C9E},
	{0x10030, 0x0000309B},
	{0x10030, 0x0000341E},
	{0x10030, 0x0000381B},
	{0x10030, 0x00003C18},
	{0x10030, 0x00004015},
	{0x10030, 0x000200BC},
	{0x10030, 0x000204B9},
	{0x10030, 0x000208B6},
	{0x10030, 0x00020CB3},
	{0x10030, 0x000210B0},
	{0x10030, 0x000214AD},
	{0x10030, 0x0002186C},
	{0x10030, 0x00021C69},
	{0x10030, 0x00022066},
	{0x10030, 0x00022426},
	{0x10030, 0x00022823},
	{0x10030, 0x00022C20},
	{0x10030, 0x0002301D},
	{0x10030, 0x0002341A},
	{0x10030, 0x00023817},
	{0x10030, 0x00023C14},
	{0x10030, 0x00024011},
	{0x10030, 0x000280BC},
	{0x10030, 0x000284B9},
	{0x10030, 0x000288B6},
	{0x10030, 0x00028CB3},
	{0x10030, 0x000290B0},
	{0x10030, 0x000294AD},
	{0x10030, 0x0002986C},
	{0x10030, 0x00029C69},
	{0x10030, 0x0002A066},
	{0x10030, 0x0002A426},
	{0x10030, 0x0002A823},
	{0x10030, 0x0002AC20},
	{0x10030, 0x0002B01D},
	{0x10030, 0x0002B41A},
	{0x10030, 0x0002B817},
	{0x10030, 0x0002BC14},
	{0x10030, 0x0002C011},
	{0x10030, 0x000300BC},
	{0x10030, 0x000304B9},
	{0x10030, 0x000308B6},
	{0x10030, 0x00030CB3},
	{0x10030, 0x000310B0},
	{0x10030, 0x000314AD},
	{0x10030, 0x0003186C},
	{0x10030, 0x00031C69},
	{0x10030, 0x00032066},
	{0x10030, 0x00032426},
	{0x10030, 0x00032823},
	{0x10030, 0x00032C20},
	{0x10030, 0x0003301D},
	{0x10030, 0x0003341A},
	{0x10030, 0x00033817},
	{0x10030, 0x00033C14},
	{0x10030, 0x00034011},
	{0x100EE, 0x00000000},
	{0x100EE, 0x00004000},
	{0x10030, 0x000201EF},
	{0x10030, 0x000205E9},
	{0x10030, 0x000209E3},
	{0x10030, 0x00020DDD},
	{0x10030, 0x000211D7},
	{0x10030, 0x000215D1},
	{0x10030, 0x00021919},
	{0x10030, 0x00021D13},
	{0x10030, 0x000220D9},
	{0x10030, 0x000224D3},
	{0x10030, 0x00022899},
	{0x10030, 0x00022C93},
	{0x10030, 0x00023059},
	{0x10030, 0x00023453},
	{0x10030, 0x00023819},
	{0x10030, 0x00023C13},
	{0x10030, 0x0002400D},
	{0x10030, 0x00024407},
	{0x10030, 0x000281EF},
	{0x10030, 0x000285E9},
	{0x10030, 0x000289E3},
	{0x10030, 0x00028DDD},
	{0x10030, 0x000291D7},
	{0x10030, 0x000295D1},
	{0x10030, 0x00029919},
	{0x10030, 0x00029D13},
	{0x10030, 0x0002A0D9},
	{0x10030, 0x0002A4D3},
	{0x10030, 0x0002A899},
	{0x10030, 0x0002AC93},
	{0x10030, 0x0002B059},
	{0x10030, 0x0002B453},
	{0x10030, 0x0002B819},
	{0x10030, 0x0002BC13},
	{0x10030, 0x0002C00D},
	{0x10030, 0x0002C407},
	{0x10030, 0x000301EF},
	{0x10030, 0x000305E9},
	{0x10030, 0x000309E3},
	{0x10030, 0x00030DDD},
	{0x10030, 0x000311D7},
	{0x10030, 0x000315D1},
	{0x10030, 0x00031919},
	{0x10030, 0x00031D13},
	{0x10030, 0x000320D9},
	{0x10030, 0x000324D3},
	{0x10030, 0x00032899},
	{0x10030, 0x00032C93},
	{0x10030, 0x00033059},
	{0x10030, 0x00033453},
	{0x10030, 0x00033819},
	{0x10030, 0x00033C13},
	{0x10030, 0x0003400D},
	{0x10030, 0x00034407},
	{0x100EE, 0x00000000},
	{0x100EE, 0x00004000},
	{0x10030, 0x000001EF},
	{0x10030, 0x000005E9},
	{0x10030, 0x000009E3},
	{0x10030, 0x00000DDD},
	{0x10030, 0x000011A5},
	{0x10030, 0x0000159F},
	{0x10030, 0x00001965},
	{0x10030, 0x00001D5F},
	{0x10030, 0x00002125},
	{0x10030, 0x0000251F},
	{0x10030, 0x000028E5},
	{0x10030, 0x00002CDF},
	{0x10030, 0x000030A5},
	{0x10030, 0x0000349F},
	{0x10030, 0x00003865},
	{0x10030, 0x00003C5F},
	{0x10030, 0x00004025},
	{0x10030, 0x0000441F},
	{0x100EE, 0x00000000},
	{0x0EF, 0x00000008},
	{0x033, 0x00000000},
	{0x03F, 0x00000004},
	{0x0EF, 0x00000000},
	{0x000, 0x00010000},
	{0x0FE, 0x0000005A},
	{0x005, 0x00000001},
	{0x10005, 0x00000001},
	{0x0FE, 0x00000028},
};

static const struct rtw89_reg2_def rtw89_8851b_phy_nctl_regs[] = {
	{0x8000, 0x00000008},
	{0x8008, 0x00000000},
	{0x8004, 0xe8862b66},
	{0x800c, 0x78000000},
	{0x8010, 0x88015000},
	{0x8014, 0x80010100},
	{0x8018, 0x10010100},
	{0x801c, 0xa210bc00},
	{0x8020, 0x000403e0},
	{0x8024, 0x00072160},
	{0x8028, 0x00180e00},
	{0x8030, 0x400000c0},
	{0x8034, 0x11000830},
	{0x8038, 0x40000000},
	{0x803c, 0x00000008},
	{0x8040, 0x00000046},
	{0x8044, 0x0010001f},
	{0x8048, 0x00000003},
	{0x804c, 0x420840e0},
	{0x8050, 0xce08cce0},
	{0x8054, 0x420840e0},
	{0x8058, 0xce08cce0},
	{0x805c, 0x150c0b02},
	{0x8060, 0x150c0b02},
	{0x8064, 0x2aa00047},
	{0x8074, 0x80000000},
	{0x807c, 0x000000ee},
	{0x8088, 0x80000000},
	{0x808c, 0x00000000},
	{0x80b0, 0x00000000},
	{0x80cc, 0x00000000},
	{0x80d0, 0x00000000},
	{0x80ec, 0x00000002},
	{0x8098, 0x0000ff00},
	{0x8070, 0x00e80000},
	{0x80b0, 0xffe00fff},
	{0x809c, 0x0000001f},
	{0x80b8, 0x00002000},
	{0x80bc, 0x00050033},
	{0xa400, 0x00000000},
	{0xa404, 0x00000180},
	{0xa408, 0x000001af},
	{0xa40c, 0x000001e3},
	{0xa410, 0x00000220},
	{0xa414, 0x00000262},
	{0xa418, 0x000002ac},
	{0xa41c, 0x0000035e},
	{0xa420, 0x000003c7},
	{0xa424, 0x0000043d},
	{0xa428, 0x000004c1},
	{0xa42c, 0x00000556},
	{0xa430, 0x000005fc},
	{0xa434, 0x000006b7},
	{0xa438, 0x00000789},
	{0xa43c, 0x00000875},
	{0xa440, 0x0000011f},
	{0x8104, 0x00000000},
	{0x810c, 0x00000000},
	{0x8110, 0x00000000},
	{0x8114, 0x00000000},
	{0x8120, 0x10010000},
	{0x8124, 0x00000000},
	{0x8128, 0x00000200},
	{0x812c, 0x0000c000},
	{0x8130, 0x40000000},
	{0x8138, 0x40000000},
	{0x813c, 0x40000000},
	{0x8140, 0x00000000},
	{0x8144, 0x0b040b03},
	{0x8148, 0x07020b04},
	{0x814c, 0x07020b04},
	{0x8150, 0xa0a00000},
	{0x8158, 0xffffffff},
	{0x815c, 0xffffffff},
	{0x8160, 0xffffffff},
	{0x8164, 0xffffffff},
	{0x8168, 0xffffffff},
	{0x816c, 0x1fffffff},
	{0x81cc, 0x00000000},
	{0x81dc, 0x00000002},
	{0x81e0, 0x00000000},
	{0x81e4, 0x00000001},
	{0x81a0, 0x00000000},
	{0x81ac, 0x3fc20400},
	{0x81b0, 0x3f914100},
	{0x81bc, 0x0000005b},
	{0x81c0, 0x0000005b},
	{0x81b4, 0x01e0f078},
	{0x81b8, 0x01e0f078},
	{0x81f0, 0x0000f078},
	{0x81d8, 0x00000001},
	{0x9500, 0x00000000},
	{0x9504, 0x00000000},
	{0x9508, 0x00000000},
	{0x950c, 0x00000000},
	{0x9510, 0x00000000},
	{0x9514, 0x00000000},
	{0x9518, 0x00000000},
	{0x951c, 0x00000000},
	{0x9520, 0x00000000},
	{0x9524, 0x00000000},
	{0x9528, 0x00000000},
	{0x952c, 0x00000000},
	{0x9530, 0x00000000},
	{0x9534, 0x00000000},
	{0x9538, 0x00000000},
	{0x953c, 0x00000000},
	{0x9540, 0x04000000},
	{0x9544, 0x00000000},
	{0x9548, 0x00000000},
	{0x954c, 0x00000000},
	{0x9550, 0x00000000},
	{0x9554, 0x00000000},
	{0x9558, 0x00000000},
	{0x955c, 0x00000000},
	{0x9560, 0x00000000},
	{0x9564, 0x00000000},
	{0x9568, 0x00000000},
	{0x956c, 0x00000000},
	{0x9570, 0x00000000},
	{0x9574, 0x00000000},
	{0x9578, 0x00000000},
	{0x957c, 0x00000000},
	{0x9580, 0x00000000},
	{0x9584, 0x04000000},
	{0x9588, 0x00000000},
	{0x958c, 0x00000000},
	{0x9590, 0x00000000},
	{0x9594, 0x00000000},
	{0x9598, 0x00000000},
	{0x959c, 0x00000000},
	{0x95a0, 0x00000000},
	{0x95a4, 0x00000000},
	{0x95a8, 0x00000000},
	{0x95ac, 0x00000000},
	{0x95b0, 0x00000000},
	{0x95b4, 0x00000000},
	{0x95b8, 0x00000000},
	{0x95bc, 0x00000000},
	{0x95c0, 0x00000000},
	{0x95c4, 0x00000000},
	{0x95c8, 0x04000000},
	{0x95cc, 0x00000000},
	{0x95d0, 0x00000000},
	{0x95d4, 0x00000000},
	{0x95d8, 0x00000000},
	{0x95dc, 0x00000000},
	{0x95e0, 0x00000000},
	{0x95e4, 0x00000000},
	{0x95e8, 0x00000000},
	{0x95ec, 0x00000000},
	{0x95f0, 0x00000000},
	{0x95f4, 0x00000000},
	{0x95f8, 0x00000000},
	{0x95fc, 0x00000000},
	{0x9600, 0x00000000},
	{0x9604, 0x00000000},
	{0x9608, 0x00000000},
	{0x960c, 0x04000000},
	{0x9610, 0x00000000},
	{0x9614, 0x00000000},
	{0x9618, 0x00000000},
	{0x961c, 0x00000000},
	{0x9620, 0x00000000},
	{0x9624, 0x00000000},
	{0x9628, 0x00000000},
	{0x962c, 0x00000000},
	{0x9630, 0x00000000},
	{0x9634, 0x00000000},
	{0x9638, 0x00000000},
	{0x963c, 0x00000000},
	{0x9640, 0x00000000},
	{0x9644, 0x00000000},
	{0x9648, 0x00000000},
	{0x964c, 0x00000000},
	{0x9650, 0x04000000},
	{0x9654, 0x00000000},
	{0x9658, 0x00000000},
	{0x965c, 0x00000000},
	{0x9660, 0x00000000},
	{0x9664, 0x00000000},
	{0x9668, 0x00000000},
	{0x966c, 0x00000000},
	{0x9670, 0x00000000},
	{0x9674, 0x00000000},
	{0x9678, 0x00000000},
	{0x967c, 0x00000000},
	{0x9680, 0x00000000},
	{0x9684, 0x00000000},
	{0x9688, 0x00000000},
	{0x968c, 0x00000000},
	{0x9690, 0x00000000},
	{0x9694, 0x04000000},
	{0x9698, 0x00000000},
	{0x969c, 0x00000000},
	{0x96a0, 0x00000000},
	{0x96a4, 0x00000000},
	{0x96a8, 0x00000000},
	{0x96ac, 0x00000000},
	{0x96b0, 0x00000000},
	{0x96b4, 0x00000000},
	{0x96b8, 0x00000000},
	{0x96bc, 0x00000000},
	{0x96c0, 0x00000000},
	{0x96c4, 0x00000000},
	{0x96c8, 0x00000000},
	{0x96cc, 0x00000000},
	{0x96d0, 0x00000000},
	{0x96d4, 0x00000000},
	{0x96d8, 0x04000000},
	{0x96dc, 0x00000000},
	{0x96e0, 0x00000000},
	{0x96e4, 0x00000000},
	{0x96e8, 0x00000000},
	{0x96ec, 0x00000000},
	{0x96f0, 0x00000000},
	{0x96f4, 0x00000000},
	{0x96f8, 0x00000000},
	{0x96fc, 0x00000000},
	{0x9700, 0x00000000},
	{0x9704, 0x00000000},
	{0x9708, 0x00000000},
	{0x970c, 0x00000000},
	{0x9710, 0x00000000},
	{0x9714, 0x00000000},
	{0x9718, 0x00000000},
	{0x971c, 0x04000000},
	{0x9720, 0x00000000},
	{0x9724, 0x00000000},
	{0x9728, 0x00000000},
	{0x972c, 0x00000000},
	{0x9730, 0x00000000},
	{0x9734, 0x00000000},
	{0x9738, 0x00000000},
	{0x973c, 0x00000000},
	{0x9740, 0x00000000},
	{0x9744, 0x00000000},
	{0x9748, 0x00000000},
	{0x974c, 0x00000000},
	{0x9750, 0x00000000},
	{0x9754, 0x00000000},
	{0x9758, 0x00000000},
	{0x975c, 0x00000000},
	{0x9760, 0x04000000},
	{0x9764, 0x00000000},
	{0x9768, 0x00000000},
	{0x976c, 0x00000000},
	{0x9770, 0x00000000},
	{0x9774, 0x00000000},
	{0x9778, 0x00000000},
	{0x977c, 0x00000000},
	{0x9780, 0x00000000},
	{0x9784, 0x00000000},
	{0x9788, 0x00000000},
	{0x978c, 0x00000000},
	{0x9790, 0x00000000},
	{0x9794, 0x00000000},
	{0x9798, 0x00000000},
	{0x979c, 0x00000000},
	{0x97a0, 0x00000000},
	{0x97a4, 0x04000000},
	{0x97a8, 0x00000000},
	{0x97ac, 0x00000000},
	{0x97b0, 0x00000000},
	{0x97b4, 0x00000000},
	{0x97b8, 0x00000000},
	{0x97bc, 0x00000000},
	{0x97c0, 0x00000000},
	{0x97c4, 0x00000000},
	{0x97c8, 0x00000000},
	{0x97cc, 0x00000000},
	{0x97d0, 0x00000000},
	{0x97d4, 0x00000000},
	{0x97d8, 0x00000000},
	{0x97dc, 0x00000000},
	{0x97e0, 0x00000000},
	{0x97e4, 0x00000000},
	{0x97e8, 0x04000000},
	{0x97ec, 0x00000000},
	{0x97f0, 0x00000000},
	{0x97f4, 0x00000000},
	{0x97f8, 0x00000000},
	{0x97fc, 0x00000000},
	{0x9800, 0x00000000},
	{0x9804, 0x00000000},
	{0x9808, 0x00000000},
	{0x980c, 0x00000000},
	{0x9810, 0x00000000},
	{0x9814, 0x00000000},
	{0x9818, 0x00000000},
	{0x981c, 0x00000000},
	{0x9820, 0x00000000},
	{0x9824, 0x00000000},
	{0x9828, 0x00000000},
	{0x982c, 0x04000000},
	{0x81d8, 0x00000000},
	{0xb104, 0x2b251f19},
	{0xb108, 0x433d3731},
	{0xb10c, 0x5b554f49},
	{0xb110, 0x736d6761},
	{0xb114, 0x7f7f7f79},
	{0xb118, 0x120f7f7f},
	{0xb11c, 0x1e1b1815},
	{0xb120, 0x2a272421},
	{0xb124, 0x3633302d},
	{0xb128, 0x3f3f3c39},
	{0xb12c, 0x3f3f3f3f},
	{0x8088, 0x00000110},
	{0x8000, 0x00000008},
	{0x8080, 0x00000005},
	{0x8500, 0x80000008},
	{0x8504, 0x43000004},
	{0x8508, 0x4b044a00},
	{0x850c, 0x40098604},
	{0x8510, 0x0004e01f},
	{0x8514, 0x74104b00},
	{0x8518, 0x000021e0},
	{0x851c, 0x74301658},
	{0x8520, 0x43800004},
	{0x8524, 0x4c000007},
	{0x8528, 0x43000004},
	{0x852c, 0x56030007},
	{0x8530, 0x57000004},
	{0x8534, 0x400042fe},
	{0x8538, 0x50554200},
	{0x853c, 0xb4183000},
	{0x8540, 0xe537a50f},
	{0x8544, 0xf12bf02b},
	{0x8548, 0xf32bf22b},
	{0x854c, 0xf62bf42b},
	{0x8550, 0xf82bf72b},
	{0x8554, 0xfa2bf92b},
	{0x8558, 0xfd2bfc2b},
	{0x855c, 0xe537fe2b},
	{0x8560, 0xf12af02a},
	{0x8564, 0xf32af22a},
	{0x8568, 0xf52af42a},
	{0x856c, 0x000bf62a},
	{0x8570, 0xf028a511},
	{0x8574, 0xf228f128},
	{0x8578, 0xf428f328},
	{0x857c, 0xf628f528},
	{0x8580, 0xf828f728},
	{0x8584, 0xfa28f928},
	{0x8588, 0xfc28fb28},
	{0x858c, 0xfe28fd28},
	{0x8590, 0xf028ff28},
	{0x8594, 0xf228f128},
	{0x8598, 0x30750001},
	{0x859c, 0x30753075},
	{0x85a0, 0x30b63097},
	{0x85a4, 0x30be30bb},
	{0x85a8, 0x30d930cc},
	{0x85ac, 0x316d30e6},
	{0x85b0, 0x3189317f},
	{0x85b4, 0x31d23193},
	{0x85b8, 0x31e43210},
	{0x85bc, 0x31e831dd},
	{0x85c0, 0x322831e1},
	{0x85c4, 0x323c3232},
	{0x85c8, 0x32503246},
	{0x85cc, 0x3264325a},
	{0x85d0, 0x3278326e},
	{0x85d4, 0x32983285},
	{0x85d8, 0x32aa32a6},
	{0x85dc, 0x330b32f3},
	{0x85e0, 0x333f330c},
	{0x85e4, 0x334c3341},
	{0x85e8, 0xe35e0001},
	{0x85ec, 0x20887410},
	{0x85f0, 0x140f0200},
	{0x85f4, 0x02002098},
	{0x85f8, 0x7430140f},
	{0x85fc, 0x5b10e39c},
	{0x8600, 0x20807410},
	{0x8604, 0x140f0000},
	{0x8608, 0x56015507},
	{0x860c, 0x7410e382},
	{0x8610, 0x02002088},
	{0x8614, 0x5517140f},
	{0x8618, 0xe34ee382},
	{0x861c, 0x468e7508},
	{0x8620, 0xe0ace38c},
	{0x8624, 0x5500f0e2},
	{0x8628, 0x5501e37e},
	{0x862c, 0x5b10f1de},
	{0x8630, 0x20907410},
	{0x8634, 0x140f0000},
	{0x8638, 0xe3825507},
	{0x863c, 0x20987410},
	{0x8640, 0x140f0200},
	{0x8644, 0xe3825517},
	{0x8648, 0x46967509},
	{0x864c, 0xe0ace38c},
	{0x8650, 0xe37e5500},
	{0x8654, 0x00015501},
	{0x8658, 0x4d000007},
	{0x865c, 0x74200004},
	{0x8660, 0x57005710},
	{0x8664, 0x9700140f},
	{0x8668, 0x00017430},
	{0x866c, 0xe39ce35e},
	{0x8670, 0xe52a0bbd},
	{0x8674, 0xe36a0001},
	{0x8678, 0x0001e3c4},
	{0x867c, 0x55005b30},
	{0x8680, 0x46500005},
	{0x8684, 0x74000004},
	{0x8688, 0x1658e37e},
	{0x868c, 0x74305501},
	{0x8690, 0x46100005},
	{0x8694, 0x00010004},
	{0x8698, 0x30f8e35e},
	{0x869c, 0xe52a0023},
	{0x86a0, 0x54ed0002},
	{0x86a4, 0x00230baa},
	{0x86a8, 0x0002e52a},
	{0x86ac, 0xe356e3e4},
	{0x86b0, 0xe35e0001},
	{0x86b4, 0x002230f3},
	{0x86b8, 0x0002e52a},
	{0x86bc, 0x0baa54ec},
	{0x86c0, 0xe52a0022},
	{0x86c4, 0xe3e40002},
	{0x86c8, 0x0001e356},
	{0x86cc, 0x0baae35e},
	{0x86d0, 0xe3e430ec},
	{0x86d4, 0x0001e356},
	{0x86d8, 0x6d0f6c67},
	{0x86dc, 0xe52ae39c},
	{0x86e0, 0xe39c6c8b},
	{0x86e4, 0x0bace52a},
	{0x86e8, 0x6d0f6cb3},
	{0x86ec, 0xe52ae39c},
	{0x86f0, 0x6cdb0bad},
	{0x86f4, 0xe39c6d0f},
	{0x86f8, 0x6cf5e52a},
	{0x86fc, 0xe39c6d0f},
	{0x8700, 0x6c0be52a},
	{0x8704, 0xe39c6d00},
	{0x8708, 0x6c25e52a},
	{0x870c, 0xe52ae39c},
	{0x8710, 0x6c4df8c6},
	{0x8714, 0xe52ae39c},
	{0x8718, 0x6c75f9cf},
	{0x871c, 0xe52ae39c},
	{0x8720, 0xe39c6c99},
	{0x8724, 0xfad6e52a},
	{0x8728, 0x21e87410},
	{0x872c, 0x6e670009},
	{0x8730, 0xe3c46f0f},
	{0x8734, 0x7410e52f},
	{0x8738, 0x000b21e8},
	{0x873c, 0xe3c46e8b},
	{0x8740, 0x7410e52f},
	{0x8744, 0x000d21e8},
	{0x8748, 0x6f0f6eb3},
	{0x874c, 0xe52fe3c4},
	{0x8750, 0xfe07ff08},
	{0x8754, 0x21e87410},
	{0x8758, 0x6ec7000e},
	{0x875c, 0xe52fe3c4},
	{0x8760, 0x21e87410},
	{0x8764, 0x6edb000f},
	{0x8768, 0xe3c46f0f},
	{0x876c, 0x7410e52f},
	{0x8770, 0x001021e8},
	{0x8774, 0xe3c46eef},
	{0x8778, 0xff03e52f},
	{0x877c, 0xe52ffe02},
	{0x8780, 0x21e87410},
	{0x8784, 0x6e110013},
	{0x8788, 0xe3c46f00},
	{0x878c, 0xff03e52f},
	{0x8790, 0xe52ffe02},
	{0x8794, 0x21e87410},
	{0x8798, 0x6e250014},
	{0x879c, 0xe52fe3c4},
	{0x87a0, 0xff08fc24},
	{0x87a4, 0x7410fe07},
	{0x87a8, 0x001521e8},
	{0x87ac, 0xe3c46e39},
	{0x87b0, 0x7410e52f},
	{0x87b4, 0x001621e8},
	{0x87b8, 0xe3c46e4d},
	{0x87bc, 0xfd27e52f},
	{0x87c0, 0x21e87410},
	{0x87c4, 0x6e750018},
	{0x87c8, 0xe52fe3c4},
	{0x87cc, 0x21e87410},
	{0x87d0, 0x6e99001a},
	{0x87d4, 0xe52fe3c4},
	{0x87d8, 0xe36afe24},
	{0x87dc, 0x63404380},
	{0x87e0, 0x43006880},
	{0x87e4, 0x31300bac},
	{0x87e8, 0xe52f0022},
	{0x87ec, 0x54ec0002},
	{0x87f0, 0x00220baa},
	{0x87f4, 0x0002e52f},
	{0x87f8, 0xe362e3e4},
	{0x87fc, 0xe36a0001},
	{0x8800, 0x63404380},
	{0x8804, 0x43006881},
	{0x8808, 0x31210baa},
	{0x880c, 0xe362e3e4},
	{0x8810, 0xe36a0001},
	{0x8814, 0x63414380},
	{0x8818, 0x43006882},
	{0x881c, 0x31140baa},
	{0x8820, 0xe362e3e4},
	{0x8824, 0x00040001},
	{0x8828, 0x000742fc},
	{0x882c, 0x00046001},
	{0x8830, 0x00074200},
	{0x8834, 0x62006220},
	{0x8838, 0x55010004},
	{0x883c, 0x66055b40},
	{0x8840, 0x62000007},
	{0x8844, 0xe40e6300},
	{0x8848, 0x09000004},
	{0x884c, 0x0b400a01},
	{0x8850, 0x0e010d00},
	{0x8854, 0x00040032},
	{0x8858, 0x42fb950b},
	{0x885c, 0x4d040007},
	{0x8860, 0x42000004},
	{0x8864, 0x00074380},
	{0x8868, 0x00044d01},
	{0x886c, 0x00074300},
	{0x8870, 0x05a30562},
	{0x8874, 0xe40e961f},
	{0x8878, 0xe37e0004},
	{0x887c, 0x06a20007},
	{0x8880, 0xe40e07a3},
	{0x8884, 0xe37e0004},
	{0x8888, 0x0002e3fe},
	{0x888c, 0x4380e406},
	{0x8890, 0x4d000007},
	{0x8894, 0x43000004},
	{0x8898, 0x000742fe},
	{0x889c, 0x00044d00},
	{0x88a0, 0x00014200},
	{0x88a4, 0x42fc0004},
	{0x88a8, 0x60030007},
	{0x88ac, 0x42000004},
	{0x88b0, 0x00073199},
	{0x88b4, 0x07a306a2},
	{0x88b8, 0xe1eb31c5},
	{0x88bc, 0xe1fee1f9},
	{0x88c0, 0xe1eb0001},
	{0x88c4, 0x0001e1fe},
	{0x88c8, 0xe1f9e1f2},
	{0x88cc, 0x0001e1fe},
	{0x88d0, 0xe1fee1f2},
	{0x88d4, 0x00040001},
	{0x88d8, 0x000742fc},
	{0x88dc, 0x00046003},
	{0x88e0, 0x00014200},
	{0x88e4, 0x42fc0004},
	{0x88e8, 0x60010007},
	{0x88ec, 0x42000004},
	{0x88f0, 0x00070001},
	{0x88f4, 0x62006220},
	{0x88f8, 0x0001e406},
	{0x88fc, 0x63000007},
	{0x8900, 0x09000004},
	{0x8904, 0x0e010a00},
	{0x8908, 0x00070032},
	{0x890c, 0xe40e06a2},
	{0x8910, 0x0002e41a},
	{0x8914, 0x000742fe},
	{0x8918, 0x00044d00},
	{0x891c, 0x00014200},
	{0x8920, 0x77000005},
	{0x8924, 0x52000007},
	{0x8928, 0x42fe0004},
	{0x892c, 0x60000007},
	{0x8930, 0x42000004},
	{0x8934, 0x60004380},
	{0x8938, 0x62016100},
	{0x893c, 0x68046310},
	{0x8940, 0x41000005},
	{0x8944, 0x00075500},
	{0x8948, 0x00045c02},
	{0x894c, 0x00014300},
	{0x8950, 0x6c060005},
	{0x8954, 0xe2aae298},
	{0x8958, 0xe42ae285},
	{0x895c, 0xe432e2f3},
	{0x8960, 0x0001e30c},
	{0x8964, 0x0005e285},
	{0x8968, 0xe2986c06},
	{0x896c, 0xe42ae4a9},
	{0x8970, 0xe432e2f3},
	{0x8974, 0x0001e30c},
	{0x8978, 0x6c000005},
	{0x897c, 0xe2aae298},
	{0x8980, 0xe445e285},
	{0x8984, 0xe44de2f3},
	{0x8988, 0x0001e30c},
	{0x898c, 0x0005e285},
	{0x8990, 0xe2986c00},
	{0x8994, 0xe445e4a9},
	{0x8998, 0xe44de2f3},
	{0x899c, 0x0001e30c},
	{0x89a0, 0x6c040005},
	{0x89a4, 0xe2aae298},
	{0x89a8, 0xe460e285},
	{0x89ac, 0xe468e2f3},
	{0x89b0, 0x0001e30c},
	{0x89b4, 0x0005e285},
	{0x89b8, 0xe2986c04},
	{0x89bc, 0xe460e4a9},
	{0x89c0, 0xe468e2f3},
	{0x89c4, 0x0001e30c},
	{0x89c8, 0x6c020005},
	{0x89cc, 0xe2aae298},
	{0x89d0, 0xe47be285},
	{0x89d4, 0xe483e2f3},
	{0x89d8, 0x0001e30c},
	{0x89dc, 0x0005e285},
	{0x89e0, 0xe2986c02},
	{0x89e4, 0xe47be4a9},
	{0x89e8, 0xe483e2f3},
	{0x89ec, 0x0001e30c},
	{0x89f0, 0x43800004},
	{0x89f4, 0x610a6008},
	{0x89f8, 0x63ce6200},
	{0x89fc, 0x60800006},
	{0x8a00, 0x00047f00},
	{0x8a04, 0xe4e04300},
	{0x8a08, 0x00070001},
	{0x8a0c, 0x4d015500},
	{0x8a10, 0x74200004},
	{0x8a14, 0x57107711},
	{0x8a18, 0x140f5700},
	{0x8a1c, 0x00077430},
	{0x8a20, 0x00044d00},
	{0x8a24, 0x00074380},
	{0x8a28, 0x00047200},
	{0x8a2c, 0x00014300},
	{0x8a30, 0x74200004},
	{0x8a34, 0x77000005},
	{0x8a38, 0x73887e07},
	{0x8a3c, 0x8f007380},
	{0x8a40, 0x0004140f},
	{0x8a44, 0x00057430},
	{0x8a48, 0x00017300},
	{0x8a4c, 0x0005e496},
	{0x8a50, 0x00017300},
	{0x8a54, 0x43800004},
	{0x8a58, 0x0006b103},
	{0x8a5c, 0x91037cdb},
	{0x8a60, 0x40db0007},
	{0x8a64, 0x43000004},
	{0x8a68, 0x0005e496},
	{0x8a6c, 0x00067380},
	{0x8a70, 0x60025d01},
	{0x8a74, 0xe4ba6200},
	{0x8a78, 0x73000005},
	{0x8a7c, 0x76080007},
	{0x8a80, 0x00047578},
	{0x8a84, 0x00074380},
	{0x8a88, 0x5e005e01},
	{0x8a8c, 0x0006140a},
	{0x8a90, 0x7f006380},
	{0x8a94, 0x00076080},
	{0x8a98, 0x4e204c3f},
	{0x8a9c, 0x73047280},
	{0x8aa0, 0x140a7300},
	{0x8aa4, 0x00044d20},
	{0x8aa8, 0x00064300},
	{0x8aac, 0x00077402},
	{0x8ab0, 0x40004001},
	{0x8ab4, 0x0006ab00},
	{0x8ab8, 0x00077404},
	{0x8abc, 0x40004001},
	{0x8ac0, 0x140aab00},
	{0x8ac4, 0x43800004},
	{0x8ac8, 0x52800007},
	{0x8acc, 0x140a5200},
	{0x8ad0, 0x4d004c00},
	{0x8ad4, 0x00064e00},
	{0x8ad8, 0x63006080},
	{0x8adc, 0x43000004},
	{0x8ae0, 0x76000007},
	{0x8ae4, 0x00040001},
	{0x8ae8, 0xb1034380},
	{0x8aec, 0x7cdb0006},
	{0x8af0, 0x00079103},
	{0x8af4, 0x000440db},
	{0x8af8, 0xe4964300},
	{0x8afc, 0xe4ba7e03},
	{0x8b00, 0x43800004},
	{0x8b04, 0x0006b103},
	{0x8b08, 0x91037c5b},
	{0x8b0c, 0x405b0007},
	{0x8b10, 0x43000004},
	{0x8b14, 0x00010001},
	{0x8b18, 0x43800004},
	{0x8b1c, 0x4e200007},
	{0x8b20, 0x63800006},
	{0x8b24, 0x5f807cdb},
	{0x8b28, 0x43000004},
	{0x8b2c, 0x76080007},
	{0x8b30, 0x00057560},
	{0x8b34, 0x00047380},
	{0x8b38, 0x0005420e},
	{0x8b3c, 0x14c86c01},
	{0x8b40, 0x6c001432},
	{0x8b44, 0x42000004},
	{0x8b48, 0x43800004},
	{0x8b4c, 0x5f000006},
	{0x8b50, 0x73010007},
	{0x8b54, 0x00047300},
	{0x8b58, 0x0007420f},
	{0x8b5c, 0x52005280},
	{0x8b60, 0x0004140a},
	{0x8b64, 0x00064200},
	{0x8b68, 0x7c5b6300},
	{0x8b6c, 0x4e000007},
	{0x8b70, 0x43000004},
	{0x8b74, 0x73000005},
	{0x8b78, 0x76000007},
	{0x8b7c, 0xe4c30001},
	{0x8b80, 0x00040001},
	{0x8b84, 0x60004380},
	{0x8b88, 0x62016100},
	{0x8b8c, 0x00066310},
	{0x8b90, 0x00046000},
	{0x8b94, 0x00014300},
	{0x8b98, 0x0001e4e0},
	{0x8b9c, 0x4e004f02},
	{0x8ba0, 0x52015302},
	{0x8ba4, 0x140f0001},
	{0x8ba8, 0x00019700},
	{0x8bac, 0x65014380},
	{0x8bb0, 0x79007800},
	{0x8bb4, 0x7b407a00},
	{0x8bb8, 0x00014300},
	{0x8bbc, 0x65004380},
	{0x8bc0, 0x00014300},
	{0x8bc4, 0x64014380},
	{0x8bc8, 0x7d007c00},
	{0x8bcc, 0x7f407e00},
	{0x8bd0, 0x00014300},
	{0x8bd4, 0x64004380},
	{0x8bd8, 0x00014300},
	{0x8bdc, 0x7b004380},
	{0x8be0, 0x79007a04},
	{0x8be4, 0x43007802},
	{0x8be8, 0x33825509},
	{0x8bec, 0x43800001},
	{0x8bf0, 0x7a007b40},
	{0x8bf4, 0x55194300},
	{0x8bf8, 0x00013382},
	{0x8bfc, 0x74007401},
	{0x8c00, 0x00018e00},
	{0x8c04, 0x52300007},
	{0x8c08, 0x74310004},
	{0x8c0c, 0x8e007430},
	{0x8c10, 0x52200007},
	{0x8c14, 0x00010004},
	{0x8c18, 0x57005702},
	{0x8c1c, 0x00018e00},
	{0x8c20, 0x57425740},
	{0x8c24, 0x8e005740},
	{0x8c28, 0x00015700},
	{0x8c2c, 0x561042ef},
	{0x8c30, 0x42005600},
	{0x8c34, 0x00018c00},
	{0x8c38, 0xe3a75b20},
	{0x8c3c, 0x54005480},
	{0x8c40, 0x54005481},
	{0x8c44, 0x54005482},
	{0x8c48, 0xbf1ae3ac},
	{0x8c4c, 0xe36e300b},
	{0x8c50, 0xe390e377},
	{0x8c54, 0x0001e523},
	{0x8c58, 0x54c054bf},
	{0x8c5c, 0x54c154a3},
	{0x8c60, 0x4c1854a4},
	{0x8c64, 0xbf091402},
	{0x8c68, 0x54a454c2},
	{0x8c6c, 0xbf051402},
	{0x8c70, 0x54a354c1},
	{0x8c74, 0xbf011402},
	{0x8c78, 0x54dfe534},
	{0x8c7c, 0x54bf0001},
	{0x8c80, 0x050a54e5},
	{0x8c84, 0x000154df},
	{0x8c88, 0x00071657},
	{0x8c8c, 0x00044c80},
	{0x8c90, 0x43807430},
	{0x8c94, 0x7e007f40},
	{0x8c98, 0x7c027d00},
	{0x8c9c, 0x5b404300},
	{0x8ca0, 0x5c015501},
	{0x8ca4, 0x5480e396},
	{0x8ca8, 0x54815400},
	{0x8cac, 0x54825400},
	{0x8cb0, 0x00075400},
	{0x8cb4, 0x00044c00},
	{0x8cb8, 0xe3ac7410},
	{0x8cbc, 0x300bbfe1},
	{0x8cc0, 0x56005610},
	{0x8cc4, 0x00018c00},
	{0x8cc8, 0x57005704},
	{0x8ccc, 0xa7038e00},
	{0x8cd0, 0x33f0aff7},
	{0x8cd4, 0xaf034019},
	{0x8cd8, 0x33f0402b},
	{0x8cdc, 0x33df402b},
	{0x8ce0, 0x57005708},
	{0x8ce4, 0x57818e00},
	{0x8ce8, 0x8e005780},
	{0x8cec, 0x00074380},
	{0x8cf0, 0x5c005c01},
	{0x8cf4, 0x00041403},
	{0x8cf8, 0x00014300},
	{0x8cfc, 0x0007427f},
	{0x8d00, 0x62006280},
	{0x8d04, 0x00049200},
	{0x8d08, 0x00014200},
	{0x8d0c, 0x0007427f},
	{0x8d10, 0x63146394},
	{0x8d14, 0x00049200},
	{0x8d18, 0x00014200},
	{0x8d1c, 0x42fe0004},
	{0x8d20, 0x4d010007},
	{0x8d24, 0x42000004},
	{0x8d28, 0x140f7420},
	{0x8d2c, 0x57005710},
	{0x8d30, 0x0001141f},
	{0x8d34, 0x42fe0004},
	{0x8d38, 0x4d010007},
	{0x8d3c, 0x42000004},
	{0x8d40, 0x140f7420},
	{0x8d44, 0x000742bf},
	{0x8d48, 0x62006240},
	{0x8d4c, 0x0004141f},
	{0x8d50, 0x00014200},
	{0x8d54, 0x5d060006},
	{0x8d58, 0x61046003},
	{0x8d5c, 0x00056201},
	{0x8d60, 0x00017310},
	{0x8d64, 0x43800004},
	{0x8d68, 0x5e010007},
	{0x8d6c, 0x140a5e00},
	{0x8d70, 0x0006b103},
	{0x8d74, 0x91037f07},
	{0x8d78, 0x43070007},
	{0x8d7c, 0x5c000006},
	{0x8d80, 0x5e035d02},
	{0x8d84, 0x43000004},
	{0x8d88, 0x00060001},
	{0x8d8c, 0x60005d04},
	{0x8d90, 0x62016104},
	{0x8d94, 0x73100005},
	{0x8d98, 0x00040001},
	{0x8d9c, 0x00074380},
	{0x8da0, 0x5e005e01},
	{0x8da4, 0xb103140a},
	{0x8da8, 0x7fc60006},
	{0x8dac, 0x00079103},
	{0x8db0, 0x000643c6},
	{0x8db4, 0x5d025c00},
	{0x8db8, 0x00045e03},
	{0x8dbc, 0x00014300},
	{0x8dc0, 0x5d040006},
	{0x8dc4, 0x61046000},
	{0x8dc8, 0x00056201},
	{0x8dcc, 0x00017310},
	{0x8dd0, 0x43800004},
	{0x8dd4, 0x5e010007},
	{0x8dd8, 0x140a5e00},
	{0x8ddc, 0x0006b103},
	{0x8de0, 0x91037fc6},
	{0x8de4, 0x43c60007},
	{0x8de8, 0x5c000006},
	{0x8dec, 0x5e035d02},
	{0x8df0, 0x43000004},
	{0x8df4, 0x00060001},
	{0x8df8, 0x60025d00},
	{0x8dfc, 0x62016100},
	{0x8e00, 0x73000005},
	{0x8e04, 0x00040001},
	{0x8e08, 0x00074380},
	{0x8e0c, 0x5e005e01},
	{0x8e10, 0xb103140a},
	{0x8e14, 0x7fc00006},
	{0x8e18, 0x00079103},
	{0x8e1c, 0x000643c0},
	{0x8e20, 0x5d025c00},
	{0x8e24, 0x00045e03},
	{0x8e28, 0x00014300},
	{0x8e2c, 0x7e020005},
	{0x8e30, 0x42f70004},
	{0x8e34, 0x6c080005},
	{0x8e38, 0x42700004},
	{0x8e3c, 0x73810005},
	{0x8e40, 0x93007380},
	{0x8e44, 0x42f70004},
	{0x8e48, 0x6c000005},
	{0x8e4c, 0x42000004},
	{0x8e50, 0x00040001},
	{0x8e54, 0x00074380},
	{0x8e58, 0x73007304},
	{0x8e5c, 0x72401405},
	{0x8e60, 0x43000004},
	{0x8e64, 0x74040006},
	{0x8e68, 0x40010007},
	{0x8e6c, 0xab004000},
	{0x8e70, 0x0001140f},
	{0x8e74, 0x140ae517},
	{0x8e78, 0x140ae4c3},
	{0x8e7c, 0x0001e51e},
	{0x8e80, 0xe4c3e517},
	{0x8e84, 0x00040001},
	{0x8e88, 0x00047410},
	{0x8e8c, 0x42f04380},
	{0x8e90, 0x62080007},
	{0x8e94, 0x24206301},
	{0x8e98, 0x14c80000},
	{0x8e9c, 0x00002428},
	{0x8ea0, 0x1a4215f4},
	{0x8ea4, 0x6300000b},
	{0x8ea8, 0x42000004},
	{0x8eac, 0x74304300},
	{0x8eb0, 0x4380140f},
	{0x8eb4, 0x73080007},
	{0x8eb8, 0x00047300},
	{0x8ebc, 0x00014300},
	{0x8ec0, 0x4bf00007},
	{0x8ec4, 0x490b4a8f},
	{0x8ec8, 0x4a8e48f1},
	{0x8ecc, 0x48a5490a},
	{0x8ed0, 0x49094a8d},
	{0x8ed4, 0x4a8c487d},
	{0x8ed8, 0x48754908},
	{0x8edc, 0x49074a8b},
	{0x8ee0, 0x4a8a4889},
	{0x8ee4, 0x48b74906},
	{0x8ee8, 0x49054a89},
	{0x8eec, 0x4a8848fc},
	{0x8ef0, 0x48564905},
	{0x8ef4, 0x49044a87},
	{0x8ef8, 0x4a8648c1},
	{0x8efc, 0x483d4904},
	{0x8f00, 0x49034a85},
	{0x8f04, 0x4a8448c7},
	{0x8f08, 0x485e4903},
	{0x8f0c, 0x49024a83},
	{0x8f10, 0x4a8248ac},
	{0x8f14, 0x48624902},
	{0x8f18, 0x49024a81},
	{0x8f1c, 0x4a804820},
	{0x8f20, 0x48004900},
	{0x8f24, 0x49014a90},
	{0x8f28, 0x4a10481f},
	{0x8f2c, 0x00060001},
	{0x8f30, 0x5f005f80},
	{0x8f34, 0x00059900},
	{0x8f38, 0x00017300},
	{0x8f3c, 0x63800006},
	{0x8f40, 0x98006300},
	{0x8f44, 0x549f0001},
	{0x8f48, 0x5c015400},
	{0x8f4c, 0x540054df},
	{0x8f50, 0x00015c02},
	{0x8f54, 0x07145c01},
	{0x8f58, 0x5c025400},
	{0x8f5c, 0x5c020001},
	{0x8f60, 0x54000714},
	{0x8f64, 0x00015c01},
	{0x8f68, 0x4c184c98},
	{0x8f6c, 0x00080001},
	{0x8f70, 0x5c020004},
	{0x8f74, 0x09017430},
	{0x8f78, 0x0ba60c01},
	{0x8f7c, 0x77800005},
	{0x8f80, 0x52200007},
	{0x8f84, 0x43800004},
	{0x8f88, 0x610a6008},
	{0x8f8c, 0x63c26200},
	{0x8f90, 0x5c000007},
	{0x8f94, 0x43000004},
	{0x8f98, 0x00000001},
	{0x8080, 0x00000004},
	{0x8080, 0x00000000},
	{0x8088, 0x00000000},
};

static const struct rtw89_txpwr_byrate_cfg rtw89_8851b_txpwr_byrate[] = {
	{ 0, 0, 0, 0, 4, 0x50505050, },
	{ 0, 0, 1, 0, 4, 0x58585858, },
	{ 0, 0, 1, 4, 4, 0x484c5054, },
	{ 0, 0, 2, 0, 4, 0x54585858, },
	{ 0, 0, 2, 4, 4, 0x44484c50, },
	{ 0, 0, 2, 8, 4, 0x34383c40, },
	{ 0, 0, 3, 0, 4, 0x58585858, },
	{ 0, 1, 2, 0, 4, 0x50545858, },
	{ 0, 1, 2, 4, 4, 0x4044484c, },
	{ 0, 1, 2, 8, 4, 0x3034383c, },
	{ 0, 1, 3, 0, 4, 0x50505050, },
	{ 0, 0, 4, 1, 4, 0x00000000, },
	{ 0, 0, 4, 0, 1, 0x00000000, },
	{ 1, 0, 1, 0, 4, 0x58585858, },
	{ 1, 0, 1, 4, 4, 0x484c5054, },
	{ 1, 0, 2, 0, 4, 0x54585858, },
	{ 1, 0, 2, 4, 4, 0x44484c50, },
	{ 1, 0, 2, 8, 4, 0x34383c40, },
	{ 1, 0, 3, 0, 4, 0x54585858, },
	{ 1, 1, 2, 0, 4, 0x54585858, },
	{ 1, 1, 2, 4, 4, 0x44484c50, },
	{ 1, 1, 2, 8, 4, 0x34383c40, },
	{ 1, 1, 3, 0, 4, 0x48484848, },
	{ 1, 0, 4, 0, 4, 0x00000000, },
	{ 2, 0, 1, 0, 4, 0x40404040, },
	{ 2, 0, 1, 4, 4, 0x383c4040, },
	{ 2, 0, 2, 0, 4, 0x40404040, },
	{ 2, 0, 2, 4, 4, 0x34383c40, },
	{ 2, 0, 2, 8, 4, 0x24282c30, },
	{ 2, 0, 3, 0, 4, 0x40404040, },
	{ 2, 1, 2, 0, 4, 0x40404040, },
	{ 2, 1, 2, 4, 4, 0x34383c40, },
	{ 2, 1, 2, 8, 4, 0x24282c30, },
	{ 2, 1, 3, 0, 4, 0x40404040, },
	{ 2, 0, 4, 0, 4, 0x00000000, },
};

static const struct rtw89_txpwr_byrate_cfg rtw89_8851b_txpwr_byrate_type2[] = {
	{ 0, 0, 0, 0, 4, 0x50505050, },
	{ 0, 0, 1, 0, 4, 0x54585858, },
	{ 0, 0, 1, 4, 4, 0x44484c50, },
	{ 0, 0, 2, 0, 4, 0x50545858, },
	{ 0, 0, 2, 4, 4, 0x4044484c, },
	{ 0, 0, 2, 8, 4, 0x3034383c, },
	{ 0, 0, 3, 0, 4, 0x58585858, },
	{ 0, 1, 2, 0, 4, 0x50545858, },
	{ 0, 1, 2, 4, 4, 0x4044484c, },
	{ 0, 1, 2, 8, 4, 0x3034383c, },
	{ 0, 1, 3, 0, 4, 0x50505050, },
	{ 0, 0, 4, 1, 4, 0x00000000, },
	{ 0, 0, 4, 0, 1, 0x00000000, },
	{ 1, 0, 1, 0, 4, 0x58585858, },
	{ 1, 0, 1, 4, 4, 0x484c5054, },
	{ 1, 0, 2, 0, 4, 0x54585858, },
	{ 1, 0, 2, 4, 4, 0x44484c50, },
	{ 1, 0, 2, 8, 4, 0x34383c40, },
	{ 1, 0, 3, 0, 4, 0x54585858, },
	{ 1, 1, 2, 0, 4, 0x54585858, },
	{ 1, 1, 2, 4, 4, 0x44484c50, },
	{ 1, 1, 2, 8, 4, 0x34383c40, },
	{ 1, 1, 3, 0, 4, 0x48484848, },
	{ 1, 0, 4, 0, 4, 0x00000000, },
	{ 2, 0, 1, 0, 4, 0x40404040, },
	{ 2, 0, 1, 4, 4, 0x383c4040, },
	{ 2, 0, 2, 0, 4, 0x40404040, },
	{ 2, 0, 2, 4, 4, 0x34383c40, },
	{ 2, 0, 2, 8, 4, 0x24282c30, },
	{ 2, 0, 3, 0, 4, 0x40404040, },
	{ 2, 1, 2, 0, 4, 0x40404040, },
	{ 2, 1, 2, 4, 4, 0x34383c40, },
	{ 2, 1, 2, 8, 4, 0x24282c30, },
	{ 2, 1, 3, 0, 4, 0x40404040, },
	{ 2, 0, 4, 0, 4, 0x00000000, },
};

static const s8 _txpwr_track_delta_swingidx_5ga_n[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1,
	 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4},
};

static const s8 _txpwr_track_delta_swingidx_5ga_p[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
	 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2},
};

static const s8 _txpwr_track_delta_swingidx_2ga_n[] = {
	0, 0, 0, 0, -1, -1, -1, -2, -2, -2, -2, -3, -3, -3, -3, -3,
	 -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -6, -6, -6
};

static const s8 _txpwr_track_delta_swingidx_2ga_p[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4
};

static const s8 _txpwr_track_delta_swingidx_2g_cck_a_n[] = {
	0, 0, 0, 0, -1, -1, -1, -2, -2, -2, -2, -3, -3, -3, -3, -3,
	 -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -6, -6, -6
};

static const s8 _txpwr_track_delta_swingidx_2g_cck_a_p[] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4
};

static
const u8 rtw89_8851b_tx_shape_lmt[RTW89_BAND_NUM][RTW89_RS_TX_SHAPE_NUM]
				 [RTW89_REGD_NUM] = {
	[0][0][RTW89_ACMA] = 0,
	[0][0][RTW89_CN] = 0,
	[0][0][RTW89_ETSI] = 0,
	[0][0][RTW89_FCC] = 1,
	[0][0][RTW89_IC] = 1,
	[0][0][RTW89_KCC] = 0,
	[0][0][RTW89_MKK] = 0,
	[0][0][RTW89_UK] = 0,
	[0][1][RTW89_ACMA] = 0,
	[0][1][RTW89_CN] = 0,
	[0][1][RTW89_ETSI] = 0,
	[0][1][RTW89_FCC] = 3,
	[0][1][RTW89_IC] = 3,
	[0][1][RTW89_KCC] = 0,
	[0][1][RTW89_MKK] = 0,
	[0][1][RTW89_UK] = 0,
	[1][1][RTW89_ACMA] = 0,
	[1][1][RTW89_CN] = 0,
	[1][1][RTW89_ETSI] = 0,
	[1][1][RTW89_FCC] = 3,
	[1][1][RTW89_IC] = 3,
	[1][1][RTW89_KCC] = 0,
	[1][1][RTW89_MKK] = 0,
	[1][1][RTW89_UK] = 0,
};

static
const u8 rtw89_8851b_tx_shape_lmt_ru[RTW89_BAND_NUM][RTW89_REGD_NUM] = {
	[0][RTW89_ACMA] = 0,
	[0][RTW89_CN] = 0,
	[0][RTW89_ETSI] = 0,
	[0][RTW89_FCC] = 3,
	[0][RTW89_IC] = 3,
	[0][RTW89_KCC] = 0,
	[0][RTW89_MKK] = 0,
	[0][RTW89_UK] = 0,
	[1][RTW89_ACMA] = 0,
	[1][RTW89_CN] = 0,
	[1][RTW89_ETSI] = 0,
	[1][RTW89_FCC] = 3,
	[1][RTW89_IC] = 3,
	[1][RTW89_KCC] = 0,
	[1][RTW89_MKK] = 0,
	[1][RTW89_UK] = 0,
};

static
const s8 rtw89_8851b_txpwr_lmt_2g[RTW89_2G_BW_NUM][RTW89_NTX_NUM]
				 [RTW89_RS_LMT_NUM][RTW89_BF_NUM]
				 [RTW89_REGD_NUM][RTW89_2G_CH_NUM] = {
	[0][0][0][0][RTW89_WW][0] = 58,
	[0][0][0][0][RTW89_WW][1] = 58,
	[0][0][0][0][RTW89_WW][2] = 58,
	[0][0][0][0][RTW89_WW][3] = 58,
	[0][0][0][0][RTW89_WW][4] = 58,
	[0][0][0][0][RTW89_WW][5] = 58,
	[0][0][0][0][RTW89_WW][6] = 58,
	[0][0][0][0][RTW89_WW][7] = 58,
	[0][0][0][0][RTW89_WW][8] = 58,
	[0][0][0][0][RTW89_WW][9] = 58,
	[0][0][0][0][RTW89_WW][10] = 58,
	[0][0][0][0][RTW89_WW][11] = 58,
	[0][0][0][0][RTW89_WW][12] = 50,
	[0][0][0][0][RTW89_WW][13] = 76,
	[0][1][0][0][RTW89_WW][0] = 0,
	[0][1][0][0][RTW89_WW][1] = 0,
	[0][1][0][0][RTW89_WW][2] = 0,
	[0][1][0][0][RTW89_WW][3] = 0,
	[0][1][0][0][RTW89_WW][4] = 0,
	[0][1][0][0][RTW89_WW][5] = 0,
	[0][1][0][0][RTW89_WW][6] = 0,
	[0][1][0][0][RTW89_WW][7] = 0,
	[0][1][0][0][RTW89_WW][8] = 0,
	[0][1][0][0][RTW89_WW][9] = 0,
	[0][1][0][0][RTW89_WW][10] = 0,
	[0][1][0][0][RTW89_WW][11] = 0,
	[0][1][0][0][RTW89_WW][12] = 0,
	[0][1][0][0][RTW89_WW][13] = 0,
	[1][0][0][0][RTW89_WW][0] = 0,
	[1][0][0][0][RTW89_WW][1] = 0,
	[1][0][0][0][RTW89_WW][2] = 58,
	[1][0][0][0][RTW89_WW][3] = 58,
	[1][0][0][0][RTW89_WW][4] = 58,
	[1][0][0][0][RTW89_WW][5] = 58,
	[1][0][0][0][RTW89_WW][6] = 58,
	[1][0][0][0][RTW89_WW][7] = 58,
	[1][0][0][0][RTW89_WW][8] = 58,
	[1][0][0][0][RTW89_WW][9] = 58,
	[1][0][0][0][RTW89_WW][10] = 50,
	[1][0][0][0][RTW89_WW][11] = 0,
	[1][0][0][0][RTW89_WW][12] = 0,
	[1][0][0][0][RTW89_WW][13] = 0,
	[1][1][0][0][RTW89_WW][0] = 0,
	[1][1][0][0][RTW89_WW][1] = 0,
	[1][1][0][0][RTW89_WW][2] = 0,
	[1][1][0][0][RTW89_WW][3] = 0,
	[1][1][0][0][RTW89_WW][4] = 0,
	[1][1][0][0][RTW89_WW][5] = 0,
	[1][1][0][0][RTW89_WW][6] = 0,
	[1][1][0][0][RTW89_WW][7] = 0,
	[1][1][0][0][RTW89_WW][8] = 0,
	[1][1][0][0][RTW89_WW][9] = 0,
	[1][1][0][0][RTW89_WW][10] = 0,
	[1][1][0][0][RTW89_WW][11] = 0,
	[1][1][0][0][RTW89_WW][12] = 0,
	[1][1][0][0][RTW89_WW][13] = 0,
	[0][0][1][0][RTW89_WW][0] = 58,
	[0][0][1][0][RTW89_WW][1] = 60,
	[0][0][1][0][RTW89_WW][2] = 60,
	[0][0][1][0][RTW89_WW][3] = 60,
	[0][0][1][0][RTW89_WW][4] = 60,
	[0][0][1][0][RTW89_WW][5] = 60,
	[0][0][1][0][RTW89_WW][6] = 60,
	[0][0][1][0][RTW89_WW][7] = 60,
	[0][0][1][0][RTW89_WW][8] = 60,
	[0][0][1][0][RTW89_WW][9] = 60,
	[0][0][1][0][RTW89_WW][10] = 60,
	[0][0][1][0][RTW89_WW][11] = 60,
	[0][0][1][0][RTW89_WW][12] = 40,
	[0][0][1][0][RTW89_WW][13] = 0,
	[0][1][1][0][RTW89_WW][0] = 0,
	[0][1][1][0][RTW89_WW][1] = 0,
	[0][1][1][0][RTW89_WW][2] = 0,
	[0][1][1][0][RTW89_WW][3] = 0,
	[0][1][1][0][RTW89_WW][4] = 0,
	[0][1][1][0][RTW89_WW][5] = 0,
	[0][1][1][0][RTW89_WW][6] = 0,
	[0][1][1][0][RTW89_WW][7] = 0,
	[0][1][1][0][RTW89_WW][8] = 0,
	[0][1][1][0][RTW89_WW][9] = 0,
	[0][1][1][0][RTW89_WW][10] = 0,
	[0][1][1][0][RTW89_WW][11] = 0,
	[0][1][1][0][RTW89_WW][12] = 0,
	[0][1][1][0][RTW89_WW][13] = 0,
	[0][0][2][0][RTW89_WW][0] = 60,
	[0][0][2][0][RTW89_WW][1] = 60,
	[0][0][2][0][RTW89_WW][2] = 60,
	[0][0][2][0][RTW89_WW][3] = 60,
	[0][0][2][0][RTW89_WW][4] = 60,
	[0][0][2][0][RTW89_WW][5] = 60,
	[0][0][2][0][RTW89_WW][6] = 60,
	[0][0][2][0][RTW89_WW][7] = 60,
	[0][0][2][0][RTW89_WW][8] = 60,
	[0][0][2][0][RTW89_WW][9] = 60,
	[0][0][2][0][RTW89_WW][10] = 60,
	[0][0][2][0][RTW89_WW][11] = 60,
	[0][0][2][0][RTW89_WW][12] = 38,
	[0][0][2][0][RTW89_WW][13] = 0,
	[0][1][2][0][RTW89_WW][0] = 0,
	[0][1][2][0][RTW89_WW][1] = 0,
	[0][1][2][0][RTW89_WW][2] = 0,
	[0][1][2][0][RTW89_WW][3] = 0,
	[0][1][2][0][RTW89_WW][4] = 0,
	[0][1][2][0][RTW89_WW][5] = 0,
	[0][1][2][0][RTW89_WW][6] = 0,
	[0][1][2][0][RTW89_WW][7] = 0,
	[0][1][2][0][RTW89_WW][8] = 0,
	[0][1][2][0][RTW89_WW][9] = 0,
	[0][1][2][0][RTW89_WW][10] = 0,
	[0][1][2][0][RTW89_WW][11] = 0,
	[0][1][2][0][RTW89_WW][12] = 0,
	[0][1][2][0][RTW89_WW][13] = 0,
	[0][1][2][1][RTW89_WW][0] = 0,
	[0][1][2][1][RTW89_WW][1] = 0,
	[0][1][2][1][RTW89_WW][2] = 0,
	[0][1][2][1][RTW89_WW][3] = 0,
	[0][1][2][1][RTW89_WW][4] = 0,
	[0][1][2][1][RTW89_WW][5] = 0,
	[0][1][2][1][RTW89_WW][6] = 0,
	[0][1][2][1][RTW89_WW][7] = 0,
	[0][1][2][1][RTW89_WW][8] = 0,
	[0][1][2][1][RTW89_WW][9] = 0,
	[0][1][2][1][RTW89_WW][10] = 0,
	[0][1][2][1][RTW89_WW][11] = 0,
	[0][1][2][1][RTW89_WW][12] = 0,
	[0][1][2][1][RTW89_WW][13] = 0,
	[1][0][2][0][RTW89_WW][0] = 0,
	[1][0][2][0][RTW89_WW][1] = 0,
	[1][0][2][0][RTW89_WW][2] = 58,
	[1][0][2][0][RTW89_WW][3] = 58,
	[1][0][2][0][RTW89_WW][4] = 58,
	[1][0][2][0][RTW89_WW][5] = 58,
	[1][0][2][0][RTW89_WW][6] = 58,
	[1][0][2][0][RTW89_WW][7] = 58,
	[1][0][2][0][RTW89_WW][8] = 58,
	[1][0][2][0][RTW89_WW][9] = 58,
	[1][0][2][0][RTW89_WW][10] = 46,
	[1][0][2][0][RTW89_WW][11] = 0,
	[1][0][2][0][RTW89_WW][12] = 0,
	[1][0][2][0][RTW89_WW][13] = 0,
	[1][1][2][0][RTW89_WW][0] = 0,
	[1][1][2][0][RTW89_WW][1] = 0,
	[1][1][2][0][RTW89_WW][2] = 0,
	[1][1][2][0][RTW89_WW][3] = 0,
	[1][1][2][0][RTW89_WW][4] = 0,
	[1][1][2][0][RTW89_WW][5] = 0,
	[1][1][2][0][RTW89_WW][6] = 0,
	[1][1][2][0][RTW89_WW][7] = 0,
	[1][1][2][0][RTW89_WW][8] = 0,
	[1][1][2][0][RTW89_WW][9] = 0,
	[1][1][2][0][RTW89_WW][10] = 0,
	[1][1][2][0][RTW89_WW][11] = 0,
	[1][1][2][0][RTW89_WW][12] = 0,
	[1][1][2][0][RTW89_WW][13] = 0,
	[1][1][2][1][RTW89_WW][0] = 0,
	[1][1][2][1][RTW89_WW][1] = 0,
	[1][1][2][1][RTW89_WW][2] = 0,
	[1][1][2][1][RTW89_WW][3] = 0,
	[1][1][2][1][RTW89_WW][4] = 0,
	[1][1][2][1][RTW89_WW][5] = 0,
	[1][1][2][1][RTW89_WW][6] = 0,
	[1][1][2][1][RTW89_WW][7] = 0,
	[1][1][2][1][RTW89_WW][8] = 0,
	[1][1][2][1][RTW89_WW][9] = 0,
	[1][1][2][1][RTW89_WW][10] = 0,
	[1][1][2][1][RTW89_WW][11] = 0,
	[1][1][2][1][RTW89_WW][12] = 0,
	[1][1][2][1][RTW89_WW][13] = 0,
	[0][0][0][0][RTW89_FCC][0] = 84,
	[0][0][0][0][RTW89_ETSI][0] = 58,
	[0][0][0][0][RTW89_MKK][0] = 68,
	[0][0][0][0][RTW89_IC][0] = 84,
	[0][0][0][0][RTW89_KCC][0] = 68,
	[0][0][0][0][RTW89_ACMA][0] = 58,
	[0][0][0][0][RTW89_CN][0] = 58,
	[0][0][0][0][RTW89_UK][0] = 58,
	[0][0][0][0][RTW89_FCC][1] = 84,
	[0][0][0][0][RTW89_ETSI][1] = 58,
	[0][0][0][0][RTW89_MKK][1] = 68,
	[0][0][0][0][RTW89_IC][1] = 84,
	[0][0][0][0][RTW89_KCC][1] = 68,
	[0][0][0][0][RTW89_ACMA][1] = 58,
	[0][0][0][0][RTW89_CN][1] = 58,
	[0][0][0][0][RTW89_UK][1] = 58,
	[0][0][0][0][RTW89_FCC][2] = 84,
	[0][0][0][0][RTW89_ETSI][2] = 58,
	[0][0][0][0][RTW89_MKK][2] = 68,
	[0][0][0][0][RTW89_IC][2] = 84,
	[0][0][0][0][RTW89_KCC][2] = 68,
	[0][0][0][0][RTW89_ACMA][2] = 58,
	[0][0][0][0][RTW89_CN][2] = 58,
	[0][0][0][0][RTW89_UK][2] = 58,
	[0][0][0][0][RTW89_FCC][3] = 84,
	[0][0][0][0][RTW89_ETSI][3] = 58,
	[0][0][0][0][RTW89_MKK][3] = 68,
	[0][0][0][0][RTW89_IC][3] = 84,
	[0][0][0][0][RTW89_KCC][3] = 68,
	[0][0][0][0][RTW89_ACMA][3] = 58,
	[0][0][0][0][RTW89_CN][3] = 58,
	[0][0][0][0][RTW89_UK][3] = 58,
	[0][0][0][0][RTW89_FCC][4] = 84,
	[0][0][0][0][RTW89_ETSI][4] = 58,
	[0][0][0][0][RTW89_MKK][4] = 68,
	[0][0][0][0][RTW89_IC][4] = 84,
	[0][0][0][0][RTW89_KCC][4] = 68,
	[0][0][0][0][RTW89_ACMA][4] = 58,
	[0][0][0][0][RTW89_CN][4] = 58,
	[0][0][0][0][RTW89_UK][4] = 58,
	[0][0][0][0][RTW89_FCC][5] = 84,
	[0][0][0][0][RTW89_ETSI][5] = 58,
	[0][0][0][0][RTW89_MKK][5] = 68,
	[0][0][0][0][RTW89_IC][5] = 84,
	[0][0][0][0][RTW89_KCC][5] = 68,
	[0][0][0][0][RTW89_ACMA][5] = 58,
	[0][0][0][0][RTW89_CN][5] = 58,
	[0][0][0][0][RTW89_UK][5] = 58,
	[0][0][0][0][RTW89_FCC][6] = 84,
	[0][0][0][0][RTW89_ETSI][6] = 58,
	[0][0][0][0][RTW89_MKK][6] = 68,
	[0][0][0][0][RTW89_IC][6] = 84,
	[0][0][0][0][RTW89_KCC][6] = 68,
	[0][0][0][0][RTW89_ACMA][6] = 58,
	[0][0][0][0][RTW89_CN][6] = 58,
	[0][0][0][0][RTW89_UK][6] = 58,
	[0][0][0][0][RTW89_FCC][7] = 84,
	[0][0][0][0][RTW89_ETSI][7] = 58,
	[0][0][0][0][RTW89_MKK][7] = 68,
	[0][0][0][0][RTW89_IC][7] = 84,
	[0][0][0][0][RTW89_KCC][7] = 68,
	[0][0][0][0][RTW89_ACMA][7] = 58,
	[0][0][0][0][RTW89_CN][7] = 58,
	[0][0][0][0][RTW89_UK][7] = 58,
	[0][0][0][0][RTW89_FCC][8] = 84,
	[0][0][0][0][RTW89_ETSI][8] = 58,
	[0][0][0][0][RTW89_MKK][8] = 68,
	[0][0][0][0][RTW89_IC][8] = 84,
	[0][0][0][0][RTW89_KCC][8] = 68,
	[0][0][0][0][RTW89_ACMA][8] = 58,
	[0][0][0][0][RTW89_CN][8] = 58,
	[0][0][0][0][RTW89_UK][8] = 58,
	[0][0][0][0][RTW89_FCC][9] = 84,
	[0][0][0][0][RTW89_ETSI][9] = 58,
	[0][0][0][0][RTW89_MKK][9] = 68,
	[0][0][0][0][RTW89_IC][9] = 84,
	[0][0][0][0][RTW89_KCC][9] = 68,
	[0][0][0][0][RTW89_ACMA][9] = 58,
	[0][0][0][0][RTW89_CN][9] = 58,
	[0][0][0][0][RTW89_UK][9] = 58,
	[0][0][0][0][RTW89_FCC][10] = 82,
	[0][0][0][0][RTW89_ETSI][10] = 58,
	[0][0][0][0][RTW89_MKK][10] = 68,
	[0][0][0][0][RTW89_IC][10] = 82,
	[0][0][0][0][RTW89_KCC][10] = 68,
	[0][0][0][0][RTW89_ACMA][10] = 58,
	[0][0][0][0][RTW89_CN][10] = 58,
	[0][0][0][0][RTW89_UK][10] = 58,
	[0][0][0][0][RTW89_FCC][11] = 62,
	[0][0][0][0][RTW89_ETSI][11] = 58,
	[0][0][0][0][RTW89_MKK][11] = 68,
	[0][0][0][0][RTW89_IC][11] = 62,
	[0][0][0][0][RTW89_KCC][11] = 68,
	[0][0][0][0][RTW89_ACMA][11] = 58,
	[0][0][0][0][RTW89_CN][11] = 58,
	[0][0][0][0][RTW89_UK][11] = 58,
	[0][0][0][0][RTW89_FCC][12] = 52,
	[0][0][0][0][RTW89_ETSI][12] = 58,
	[0][0][0][0][RTW89_MKK][12] = 68,
	[0][0][0][0][RTW89_IC][12] = 52,
	[0][0][0][0][RTW89_KCC][12] = 68,
	[0][0][0][0][RTW89_ACMA][12] = 58,
	[0][0][0][0][RTW89_CN][12] = 50,
	[0][0][0][0][RTW89_UK][12] = 58,
	[0][0][0][0][RTW89_FCC][13] = 127,
	[0][0][0][0][RTW89_ETSI][13] = 127,
	[0][0][0][0][RTW89_MKK][13] = 76,
	[0][0][0][0][RTW89_IC][13] = 127,
	[0][0][0][0][RTW89_KCC][13] = 127,
	[0][0][0][0][RTW89_ACMA][13] = 127,
	[0][0][0][0][RTW89_CN][13] = 127,
	[0][0][0][0][RTW89_UK][13] = 127,
	[0][1][0][0][RTW89_FCC][0] = 127,
	[0][1][0][0][RTW89_ETSI][0] = 127,
	[0][1][0][0][RTW89_MKK][0] = 127,
	[0][1][0][0][RTW89_IC][0] = 127,
	[0][1][0][0][RTW89_KCC][0] = 127,
	[0][1][0][0][RTW89_ACMA][0] = 127,
	[0][1][0][0][RTW89_CN][0] = 127,
	[0][1][0][0][RTW89_UK][0] = 127,
	[0][1][0][0][RTW89_FCC][1] = 127,
	[0][1][0][0][RTW89_ETSI][1] = 127,
	[0][1][0][0][RTW89_MKK][1] = 127,
	[0][1][0][0][RTW89_IC][1] = 127,
	[0][1][0][0][RTW89_KCC][1] = 127,
	[0][1][0][0][RTW89_ACMA][1] = 127,
	[0][1][0][0][RTW89_CN][1] = 127,
	[0][1][0][0][RTW89_UK][1] = 127,
	[0][1][0][0][RTW89_FCC][2] = 127,
	[0][1][0][0][RTW89_ETSI][2] = 127,
	[0][1][0][0][RTW89_MKK][2] = 127,
	[0][1][0][0][RTW89_IC][2] = 127,
	[0][1][0][0][RTW89_KCC][2] = 127,
	[0][1][0][0][RTW89_ACMA][2] = 127,
	[0][1][0][0][RTW89_CN][2] = 127,
	[0][1][0][0][RTW89_UK][2] = 127,
	[0][1][0][0][RTW89_FCC][3] = 127,
	[0][1][0][0][RTW89_ETSI][3] = 127,
	[0][1][0][0][RTW89_MKK][3] = 127,
	[0][1][0][0][RTW89_IC][3] = 127,
	[0][1][0][0][RTW89_KCC][3] = 127,
	[0][1][0][0][RTW89_ACMA][3] = 127,
	[0][1][0][0][RTW89_CN][3] = 127,
	[0][1][0][0][RTW89_UK][3] = 127,
	[0][1][0][0][RTW89_FCC][4] = 127,
	[0][1][0][0][RTW89_ETSI][4] = 127,
	[0][1][0][0][RTW89_MKK][4] = 127,
	[0][1][0][0][RTW89_IC][4] = 127,
	[0][1][0][0][RTW89_KCC][4] = 127,
	[0][1][0][0][RTW89_ACMA][4] = 127,
	[0][1][0][0][RTW89_CN][4] = 127,
	[0][1][0][0][RTW89_UK][4] = 127,
	[0][1][0][0][RTW89_FCC][5] = 127,
	[0][1][0][0][RTW89_ETSI][5] = 127,
	[0][1][0][0][RTW89_MKK][5] = 127,
	[0][1][0][0][RTW89_IC][5] = 127,
	[0][1][0][0][RTW89_KCC][5] = 127,
	[0][1][0][0][RTW89_ACMA][5] = 127,
	[0][1][0][0][RTW89_CN][5] = 127,
	[0][1][0][0][RTW89_UK][5] = 127,
	[0][1][0][0][RTW89_FCC][6] = 127,
	[0][1][0][0][RTW89_ETSI][6] = 127,
	[0][1][0][0][RTW89_MKK][6] = 127,
	[0][1][0][0][RTW89_IC][6] = 127,
	[0][1][0][0][RTW89_KCC][6] = 127,
	[0][1][0][0][RTW89_ACMA][6] = 127,
	[0][1][0][0][RTW89_CN][6] = 127,
	[0][1][0][0][RTW89_UK][6] = 127,
	[0][1][0][0][RTW89_FCC][7] = 127,
	[0][1][0][0][RTW89_ETSI][7] = 127,
	[0][1][0][0][RTW89_MKK][7] = 127,
	[0][1][0][0][RTW89_IC][7] = 127,
	[0][1][0][0][RTW89_KCC][7] = 127,
	[0][1][0][0][RTW89_ACMA][7] = 127,
	[0][1][0][0][RTW89_CN][7] = 127,
	[0][1][0][0][RTW89_UK][7] = 127,
	[0][1][0][0][RTW89_FCC][8] = 127,
	[0][1][0][0][RTW89_ETSI][8] = 127,
	[0][1][0][0][RTW89_MKK][8] = 127,
	[0][1][0][0][RTW89_IC][8] = 127,
	[0][1][0][0][RTW89_KCC][8] = 127,
	[0][1][0][0][RTW89_ACMA][8] = 127,
	[0][1][0][0][RTW89_CN][8] = 127,
	[0][1][0][0][RTW89_UK][8] = 127,
	[0][1][0][0][RTW89_FCC][9] = 127,
	[0][1][0][0][RTW89_ETSI][9] = 127,
	[0][1][0][0][RTW89_MKK][9] = 127,
	[0][1][0][0][RTW89_IC][9] = 127,
	[0][1][0][0][RTW89_KCC][9] = 127,
	[0][1][0][0][RTW89_ACMA][9] = 127,
	[0][1][0][0][RTW89_CN][9] = 127,
	[0][1][0][0][RTW89_UK][9] = 127,
	[0][1][0][0][RTW89_FCC][10] = 127,
	[0][1][0][0][RTW89_ETSI][10] = 127,
	[0][1][0][0][RTW89_MKK][10] = 127,
	[0][1][0][0][RTW89_IC][10] = 127,
	[0][1][0][0][RTW89_KCC][10] = 127,
	[0][1][0][0][RTW89_ACMA][10] = 127,
	[0][1][0][0][RTW89_CN][10] = 127,
	[0][1][0][0][RTW89_UK][10] = 127,
	[0][1][0][0][RTW89_FCC][11] = 127,
	[0][1][0][0][RTW89_ETSI][11] = 127,
	[0][1][0][0][RTW89_MKK][11] = 127,
	[0][1][0][0][RTW89_IC][11] = 127,
	[0][1][0][0][RTW89_KCC][11] = 127,
	[0][1][0][0][RTW89_ACMA][11] = 127,
	[0][1][0][0][RTW89_CN][11] = 127,
	[0][1][0][0][RTW89_UK][11] = 127,
	[0][1][0][0][RTW89_FCC][12] = 127,
	[0][1][0][0][RTW89_ETSI][12] = 127,
	[0][1][0][0][RTW89_MKK][12] = 127,
	[0][1][0][0][RTW89_IC][12] = 127,
	[0][1][0][0][RTW89_KCC][12] = 127,
	[0][1][0][0][RTW89_ACMA][12] = 127,
	[0][1][0][0][RTW89_CN][12] = 127,
	[0][1][0][0][RTW89_UK][12] = 127,
	[0][1][0][0][RTW89_FCC][13] = 127,
	[0][1][0][0][RTW89_ETSI][13] = 127,
	[0][1][0][0][RTW89_MKK][13] = 127,
	[0][1][0][0][RTW89_IC][13] = 127,
	[0][1][0][0][RTW89_KCC][13] = 127,
	[0][1][0][0][RTW89_ACMA][13] = 127,
	[0][1][0][0][RTW89_CN][13] = 127,
	[0][1][0][0][RTW89_UK][13] = 127,
	[1][0][0][0][RTW89_FCC][0] = 127,
	[1][0][0][0][RTW89_ETSI][0] = 127,
	[1][0][0][0][RTW89_MKK][0] = 127,
	[1][0][0][0][RTW89_IC][0] = 127,
	[1][0][0][0][RTW89_KCC][0] = 127,
	[1][0][0][0][RTW89_ACMA][0] = 127,
	[1][0][0][0][RTW89_CN][0] = 127,
	[1][0][0][0][RTW89_UK][0] = 127,
	[1][0][0][0][RTW89_FCC][1] = 127,
	[1][0][0][0][RTW89_ETSI][1] = 127,
	[1][0][0][0][RTW89_MKK][1] = 127,
	[1][0][0][0][RTW89_IC][1] = 127,
	[1][0][0][0][RTW89_KCC][1] = 127,
	[1][0][0][0][RTW89_ACMA][1] = 127,
	[1][0][0][0][RTW89_CN][1] = 127,
	[1][0][0][0][RTW89_UK][1] = 127,
	[1][0][0][0][RTW89_FCC][2] = 127,
	[1][0][0][0][RTW89_ETSI][2] = 58,
	[1][0][0][0][RTW89_MKK][2] = 70,
	[1][0][0][0][RTW89_IC][2] = 127,
	[1][0][0][0][RTW89_KCC][2] = 68,
	[1][0][0][0][RTW89_ACMA][2] = 58,
	[1][0][0][0][RTW89_CN][2] = 58,
	[1][0][0][0][RTW89_UK][2] = 58,
	[1][0][0][0][RTW89_FCC][3] = 127,
	[1][0][0][0][RTW89_ETSI][3] = 58,
	[1][0][0][0][RTW89_MKK][3] = 76,
	[1][0][0][0][RTW89_IC][3] = 127,
	[1][0][0][0][RTW89_KCC][3] = 68,
	[1][0][0][0][RTW89_ACMA][3] = 58,
	[1][0][0][0][RTW89_CN][3] = 58,
	[1][0][0][0][RTW89_UK][3] = 58,
	[1][0][0][0][RTW89_FCC][4] = 127,
	[1][0][0][0][RTW89_ETSI][4] = 58,
	[1][0][0][0][RTW89_MKK][4] = 76,
	[1][0][0][0][RTW89_IC][4] = 127,
	[1][0][0][0][RTW89_KCC][4] = 68,
	[1][0][0][0][RTW89_ACMA][4] = 58,
	[1][0][0][0][RTW89_CN][4] = 58,
	[1][0][0][0][RTW89_UK][4] = 58,
	[1][0][0][0][RTW89_FCC][5] = 127,
	[1][0][0][0][RTW89_ETSI][5] = 58,
	[1][0][0][0][RTW89_MKK][5] = 76,
	[1][0][0][0][RTW89_IC][5] = 127,
	[1][0][0][0][RTW89_KCC][5] = 68,
	[1][0][0][0][RTW89_ACMA][5] = 58,
	[1][0][0][0][RTW89_CN][5] = 58,
	[1][0][0][0][RTW89_UK][5] = 58,
	[1][0][0][0][RTW89_FCC][6] = 127,
	[1][0][0][0][RTW89_ETSI][6] = 58,
	[1][0][0][0][RTW89_MKK][6] = 76,
	[1][0][0][0][RTW89_IC][6] = 127,
	[1][0][0][0][RTW89_KCC][6] = 68,
	[1][0][0][0][RTW89_ACMA][6] = 58,
	[1][0][0][0][RTW89_CN][6] = 58,
	[1][0][0][0][RTW89_UK][6] = 58,
	[1][0][0][0][RTW89_FCC][7] = 127,
	[1][0][0][0][RTW89_ETSI][7] = 58,
	[1][0][0][0][RTW89_MKK][7] = 76,
	[1][0][0][0][RTW89_IC][7] = 127,
	[1][0][0][0][RTW89_KCC][7] = 68,
	[1][0][0][0][RTW89_ACMA][7] = 58,
	[1][0][0][0][RTW89_CN][7] = 58,
	[1][0][0][0][RTW89_UK][7] = 58,
	[1][0][0][0][RTW89_FCC][8] = 127,
	[1][0][0][0][RTW89_ETSI][8] = 58,
	[1][0][0][0][RTW89_MKK][8] = 76,
	[1][0][0][0][RTW89_IC][8] = 127,
	[1][0][0][0][RTW89_KCC][8] = 68,
	[1][0][0][0][RTW89_ACMA][8] = 58,
	[1][0][0][0][RTW89_CN][8] = 58,
	[1][0][0][0][RTW89_UK][8] = 58,
	[1][0][0][0][RTW89_FCC][9] = 127,
	[1][0][0][0][RTW89_ETSI][9] = 58,
	[1][0][0][0][RTW89_MKK][9] = 76,
	[1][0][0][0][RTW89_IC][9] = 127,
	[1][0][0][0][RTW89_KCC][9] = 68,
	[1][0][0][0][RTW89_ACMA][9] = 58,
	[1][0][0][0][RTW89_CN][9] = 58,
	[1][0][0][0][RTW89_UK][9] = 58,
	[1][0][0][0][RTW89_FCC][10] = 127,
	[1][0][0][0][RTW89_ETSI][10] = 58,
	[1][0][0][0][RTW89_MKK][10] = 66,
	[1][0][0][0][RTW89_IC][10] = 127,
	[1][0][0][0][RTW89_KCC][10] = 68,
	[1][0][0][0][RTW89_ACMA][10] = 58,
	[1][0][0][0][RTW89_CN][10] = 50,
	[1][0][0][0][RTW89_UK][10] = 58,
	[1][0][0][0][RTW89_FCC][11] = 127,
	[1][0][0][0][RTW89_ETSI][11] = 127,
	[1][0][0][0][RTW89_MKK][11] = 127,
	[1][0][0][0][RTW89_IC][11] = 127,
	[1][0][0][0][RTW89_KCC][11] = 127,
	[1][0][0][0][RTW89_ACMA][11] = 127,
	[1][0][0][0][RTW89_CN][11] = 127,
	[1][0][0][0][RTW89_UK][11] = 127,
	[1][0][0][0][RTW89_FCC][12] = 127,
	[1][0][0][0][RTW89_ETSI][12] = 127,
	[1][0][0][0][RTW89_MKK][12] = 127,
	[1][0][0][0][RTW89_IC][12] = 127,
	[1][0][0][0][RTW89_KCC][12] = 127,
	[1][0][0][0][RTW89_ACMA][12] = 127,
	[1][0][0][0][RTW89_CN][12] = 127,
	[1][0][0][0][RTW89_UK][12] = 127,
	[1][0][0][0][RTW89_FCC][13] = 127,
	[1][0][0][0][RTW89_ETSI][13] = 127,
	[1][0][0][0][RTW89_MKK][13] = 127,
	[1][0][0][0][RTW89_IC][13] = 127,
	[1][0][0][0][RTW89_KCC][13] = 127,
	[1][0][0][0][RTW89_ACMA][13] = 127,
	[1][0][0][0][RTW89_CN][13] = 127,
	[1][0][0][0][RTW89_UK][13] = 127,
	[1][1][0][0][RTW89_FCC][0] = 127,
	[1][1][0][0][RTW89_ETSI][0] = 127,
	[1][1][0][0][RTW89_MKK][0] = 127,
	[1][1][0][0][RTW89_IC][0] = 127,
	[1][1][0][0][RTW89_KCC][0] = 127,
	[1][1][0][0][RTW89_ACMA][0] = 127,
	[1][1][0][0][RTW89_CN][0] = 127,
	[1][1][0][0][RTW89_UK][0] = 127,
	[1][1][0][0][RTW89_FCC][1] = 127,
	[1][1][0][0][RTW89_ETSI][1] = 127,
	[1][1][0][0][RTW89_MKK][1] = 127,
	[1][1][0][0][RTW89_IC][1] = 127,
	[1][1][0][0][RTW89_KCC][1] = 127,
	[1][1][0][0][RTW89_ACMA][1] = 127,
	[1][1][0][0][RTW89_CN][1] = 127,
	[1][1][0][0][RTW89_UK][1] = 127,
	[1][1][0][0][RTW89_FCC][2] = 127,
	[1][1][0][0][RTW89_ETSI][2] = 127,
	[1][1][0][0][RTW89_MKK][2] = 127,
	[1][1][0][0][RTW89_IC][2] = 127,
	[1][1][0][0][RTW89_KCC][2] = 127,
	[1][1][0][0][RTW89_ACMA][2] = 127,
	[1][1][0][0][RTW89_CN][2] = 127,
	[1][1][0][0][RTW89_UK][2] = 127,
	[1][1][0][0][RTW89_FCC][3] = 127,
	[1][1][0][0][RTW89_ETSI][3] = 127,
	[1][1][0][0][RTW89_MKK][3] = 127,
	[1][1][0][0][RTW89_IC][3] = 127,
	[1][1][0][0][RTW89_KCC][3] = 127,
	[1][1][0][0][RTW89_ACMA][3] = 127,
	[1][1][0][0][RTW89_CN][3] = 127,
	[1][1][0][0][RTW89_UK][3] = 127,
	[1][1][0][0][RTW89_FCC][4] = 127,
	[1][1][0][0][RTW89_ETSI][4] = 127,
	[1][1][0][0][RTW89_MKK][4] = 127,
	[1][1][0][0][RTW89_IC][4] = 127,
	[1][1][0][0][RTW89_KCC][4] = 127,
	[1][1][0][0][RTW89_ACMA][4] = 127,
	[1][1][0][0][RTW89_CN][4] = 127,
	[1][1][0][0][RTW89_UK][4] = 127,
	[1][1][0][0][RTW89_FCC][5] = 127,
	[1][1][0][0][RTW89_ETSI][5] = 127,
	[1][1][0][0][RTW89_MKK][5] = 127,
	[1][1][0][0][RTW89_IC][5] = 127,
	[1][1][0][0][RTW89_KCC][5] = 127,
	[1][1][0][0][RTW89_ACMA][5] = 127,
	[1][1][0][0][RTW89_CN][5] = 127,
	[1][1][0][0][RTW89_UK][5] = 127,
	[1][1][0][0][RTW89_FCC][6] = 127,
	[1][1][0][0][RTW89_ETSI][6] = 127,
	[1][1][0][0][RTW89_MKK][6] = 127,
	[1][1][0][0][RTW89_IC][6] = 127,
	[1][1][0][0][RTW89_KCC][6] = 127,
	[1][1][0][0][RTW89_ACMA][6] = 127,
	[1][1][0][0][RTW89_CN][6] = 127,
	[1][1][0][0][RTW89_UK][6] = 127,
	[1][1][0][0][RTW89_FCC][7] = 127,
	[1][1][0][0][RTW89_ETSI][7] = 127,
	[1][1][0][0][RTW89_MKK][7] = 127,
	[1][1][0][0][RTW89_IC][7] = 127,
	[1][1][0][0][RTW89_KCC][7] = 127,
	[1][1][0][0][RTW89_ACMA][7] = 127,
	[1][1][0][0][RTW89_CN][7] = 127,
	[1][1][0][0][RTW89_UK][7] = 127,
	[1][1][0][0][RTW89_FCC][8] = 127,
	[1][1][0][0][RTW89_ETSI][8] = 127,
	[1][1][0][0][RTW89_MKK][8] = 127,
	[1][1][0][0][RTW89_IC][8] = 127,
	[1][1][0][0][RTW89_KCC][8] = 127,
	[1][1][0][0][RTW89_ACMA][8] = 127,
	[1][1][0][0][RTW89_CN][8] = 127,
	[1][1][0][0][RTW89_UK][8] = 127,
	[1][1][0][0][RTW89_FCC][9] = 127,
	[1][1][0][0][RTW89_ETSI][9] = 127,
	[1][1][0][0][RTW89_MKK][9] = 127,
	[1][1][0][0][RTW89_IC][9] = 127,
	[1][1][0][0][RTW89_KCC][9] = 127,
	[1][1][0][0][RTW89_ACMA][9] = 127,
	[1][1][0][0][RTW89_CN][9] = 127,
	[1][1][0][0][RTW89_UK][9] = 127,
	[1][1][0][0][RTW89_FCC][10] = 127,
	[1][1][0][0][RTW89_ETSI][10] = 127,
	[1][1][0][0][RTW89_MKK][10] = 127,
	[1][1][0][0][RTW89_IC][10] = 127,
	[1][1][0][0][RTW89_KCC][10] = 127,
	[1][1][0][0][RTW89_ACMA][10] = 127,
	[1][1][0][0][RTW89_CN][10] = 127,
	[1][1][0][0][RTW89_UK][10] = 127,
	[1][1][0][0][RTW89_FCC][11] = 127,
	[1][1][0][0][RTW89_ETSI][11] = 127,
	[1][1][0][0][RTW89_MKK][11] = 127,
	[1][1][0][0][RTW89_IC][11] = 127,
	[1][1][0][0][RTW89_KCC][11] = 127,
	[1][1][0][0][RTW89_ACMA][11] = 127,
	[1][1][0][0][RTW89_CN][11] = 127,
	[1][1][0][0][RTW89_UK][11] = 127,
	[1][1][0][0][RTW89_FCC][12] = 127,
	[1][1][0][0][RTW89_ETSI][12] = 127,
	[1][1][0][0][RTW89_MKK][12] = 127,
	[1][1][0][0][RTW89_IC][12] = 127,
	[1][1][0][0][RTW89_KCC][12] = 127,
	[1][1][0][0][RTW89_ACMA][12] = 127,
	[1][1][0][0][RTW89_CN][12] = 127,
	[1][1][0][0][RTW89_UK][12] = 127,
	[1][1][0][0][RTW89_FCC][13] = 127,
	[1][1][0][0][RTW89_ETSI][13] = 127,
	[1][1][0][0][RTW89_MKK][13] = 127,
	[1][1][0][0][RTW89_IC][13] = 127,
	[1][1][0][0][RTW89_KCC][13] = 127,
	[1][1][0][0][RTW89_ACMA][13] = 127,
	[1][1][0][0][RTW89_CN][13] = 127,
	[1][1][0][0][RTW89_UK][13] = 127,
	[0][0][1][0][RTW89_FCC][0] = 80,
	[0][0][1][0][RTW89_ETSI][0] = 58,
	[0][0][1][0][RTW89_MKK][0] = 72,
	[0][0][1][0][RTW89_IC][0] = 80,
	[0][0][1][0][RTW89_KCC][0] = 78,
	[0][0][1][0][RTW89_ACMA][0] = 58,
	[0][0][1][0][RTW89_CN][0] = 60,
	[0][0][1][0][RTW89_UK][0] = 58,
	[0][0][1][0][RTW89_FCC][1] = 80,
	[0][0][1][0][RTW89_ETSI][1] = 60,
	[0][0][1][0][RTW89_MKK][1] = 74,
	[0][0][1][0][RTW89_IC][1] = 80,
	[0][0][1][0][RTW89_KCC][1] = 78,
	[0][0][1][0][RTW89_ACMA][1] = 60,
	[0][0][1][0][RTW89_CN][1] = 60,
	[0][0][1][0][RTW89_UK][1] = 60,
	[0][0][1][0][RTW89_FCC][2] = 84,
	[0][0][1][0][RTW89_ETSI][2] = 60,
	[0][0][1][0][RTW89_MKK][2] = 74,
	[0][0][1][0][RTW89_IC][2] = 84,
	[0][0][1][0][RTW89_KCC][2] = 78,
	[0][0][1][0][RTW89_ACMA][2] = 60,
	[0][0][1][0][RTW89_CN][2] = 60,
	[0][0][1][0][RTW89_UK][2] = 60,
	[0][0][1][0][RTW89_FCC][3] = 84,
	[0][0][1][0][RTW89_ETSI][3] = 60,
	[0][0][1][0][RTW89_MKK][3] = 74,
	[0][0][1][0][RTW89_IC][3] = 84,
	[0][0][1][0][RTW89_KCC][3] = 78,
	[0][0][1][0][RTW89_ACMA][3] = 60,
	[0][0][1][0][RTW89_CN][3] = 60,
	[0][0][1][0][RTW89_UK][3] = 60,
	[0][0][1][0][RTW89_FCC][4] = 84,
	[0][0][1][0][RTW89_ETSI][4] = 60,
	[0][0][1][0][RTW89_MKK][4] = 74,
	[0][0][1][0][RTW89_IC][4] = 84,
	[0][0][1][0][RTW89_KCC][4] = 76,
	[0][0][1][0][RTW89_ACMA][4] = 60,
	[0][0][1][0][RTW89_CN][4] = 60,
	[0][0][1][0][RTW89_UK][4] = 60,
	[0][0][1][0][RTW89_FCC][5] = 84,
	[0][0][1][0][RTW89_ETSI][5] = 60,
	[0][0][1][0][RTW89_MKK][5] = 74,
	[0][0][1][0][RTW89_IC][5] = 84,
	[0][0][1][0][RTW89_KCC][5] = 76,
	[0][0][1][0][RTW89_ACMA][5] = 60,
	[0][0][1][0][RTW89_CN][5] = 60,
	[0][0][1][0][RTW89_UK][5] = 60,
	[0][0][1][0][RTW89_FCC][6] = 84,
	[0][0][1][0][RTW89_ETSI][6] = 60,
	[0][0][1][0][RTW89_MKK][6] = 74,
	[0][0][1][0][RTW89_IC][6] = 84,
	[0][0][1][0][RTW89_KCC][6] = 76,
	[0][0][1][0][RTW89_ACMA][6] = 60,
	[0][0][1][0][RTW89_CN][6] = 60,
	[0][0][1][0][RTW89_UK][6] = 60,
	[0][0][1][0][RTW89_FCC][7] = 84,
	[0][0][1][0][RTW89_ETSI][7] = 60,
	[0][0][1][0][RTW89_MKK][7] = 74,
	[0][0][1][0][RTW89_IC][7] = 84,
	[0][0][1][0][RTW89_KCC][7] = 76,
	[0][0][1][0][RTW89_ACMA][7] = 60,
	[0][0][1][0][RTW89_CN][7] = 60,
	[0][0][1][0][RTW89_UK][7] = 60,
	[0][0][1][0][RTW89_FCC][8] = 80,
	[0][0][1][0][RTW89_ETSI][8] = 60,
	[0][0][1][0][RTW89_MKK][8] = 74,
	[0][0][1][0][RTW89_IC][8] = 80,
	[0][0][1][0][RTW89_KCC][8] = 76,
	[0][0][1][0][RTW89_ACMA][8] = 60,
	[0][0][1][0][RTW89_CN][8] = 60,
	[0][0][1][0][RTW89_UK][8] = 60,
	[0][0][1][0][RTW89_FCC][9] = 76,
	[0][0][1][0][RTW89_ETSI][9] = 60,
	[0][0][1][0][RTW89_MKK][9] = 74,
	[0][0][1][0][RTW89_IC][9] = 76,
	[0][0][1][0][RTW89_KCC][9] = 74,
	[0][0][1][0][RTW89_ACMA][9] = 60,
	[0][0][1][0][RTW89_CN][9] = 60,
	[0][0][1][0][RTW89_UK][9] = 60,
	[0][0][1][0][RTW89_FCC][10] = 76,
	[0][0][1][0][RTW89_ETSI][10] = 60,
	[0][0][1][0][RTW89_MKK][10] = 74,
	[0][0][1][0][RTW89_IC][10] = 76,
	[0][0][1][0][RTW89_KCC][10] = 74,
	[0][0][1][0][RTW89_ACMA][10] = 60,
	[0][0][1][0][RTW89_CN][10] = 60,
	[0][0][1][0][RTW89_UK][10] = 60,
	[0][0][1][0][RTW89_FCC][11] = 68,
	[0][0][1][0][RTW89_ETSI][11] = 60,
	[0][0][1][0][RTW89_MKK][11] = 74,
	[0][0][1][0][RTW89_IC][11] = 68,
	[0][0][1][0][RTW89_KCC][11] = 74,
	[0][0][1][0][RTW89_ACMA][11] = 60,
	[0][0][1][0][RTW89_CN][11] = 60,
	[0][0][1][0][RTW89_UK][11] = 60,
	[0][0][1][0][RTW89_FCC][12] = 64,
	[0][0][1][0][RTW89_ETSI][12] = 58,
	[0][0][1][0][RTW89_MKK][12] = 70,
	[0][0][1][0][RTW89_IC][12] = 64,
	[0][0][1][0][RTW89_KCC][12] = 74,
	[0][0][1][0][RTW89_ACMA][12] = 58,
	[0][0][1][0][RTW89_CN][12] = 40,
	[0][0][1][0][RTW89_UK][12] = 58,
	[0][0][1][0][RTW89_FCC][13] = 127,
	[0][0][1][0][RTW89_ETSI][13] = 127,
	[0][0][1][0][RTW89_MKK][13] = 127,
	[0][0][1][0][RTW89_IC][13] = 127,
	[0][0][1][0][RTW89_KCC][13] = 127,
	[0][0][1][0][RTW89_ACMA][13] = 127,
	[0][0][1][0][RTW89_CN][13] = 127,
	[0][0][1][0][RTW89_UK][13] = 127,
	[0][1][1][0][RTW89_FCC][0] = 127,
	[0][1][1][0][RTW89_ETSI][0] = 127,
	[0][1][1][0][RTW89_MKK][0] = 127,
	[0][1][1][0][RTW89_IC][0] = 127,
	[0][1][1][0][RTW89_KCC][0] = 127,
	[0][1][1][0][RTW89_ACMA][0] = 127,
	[0][1][1][0][RTW89_CN][0] = 127,
	[0][1][1][0][RTW89_UK][0] = 127,
	[0][1][1][0][RTW89_FCC][1] = 127,
	[0][1][1][0][RTW89_ETSI][1] = 127,
	[0][1][1][0][RTW89_MKK][1] = 127,
	[0][1][1][0][RTW89_IC][1] = 127,
	[0][1][1][0][RTW89_KCC][1] = 127,
	[0][1][1][0][RTW89_ACMA][1] = 127,
	[0][1][1][0][RTW89_CN][1] = 127,
	[0][1][1][0][RTW89_UK][1] = 127,
	[0][1][1][0][RTW89_FCC][2] = 127,
	[0][1][1][0][RTW89_ETSI][2] = 127,
	[0][1][1][0][RTW89_MKK][2] = 127,
	[0][1][1][0][RTW89_IC][2] = 127,
	[0][1][1][0][RTW89_KCC][2] = 127,
	[0][1][1][0][RTW89_ACMA][2] = 127,
	[0][1][1][0][RTW89_CN][2] = 127,
	[0][1][1][0][RTW89_UK][2] = 127,
	[0][1][1][0][RTW89_FCC][3] = 127,
	[0][1][1][0][RTW89_ETSI][3] = 127,
	[0][1][1][0][RTW89_MKK][3] = 127,
	[0][1][1][0][RTW89_IC][3] = 127,
	[0][1][1][0][RTW89_KCC][3] = 127,
	[0][1][1][0][RTW89_ACMA][3] = 127,
	[0][1][1][0][RTW89_CN][3] = 127,
	[0][1][1][0][RTW89_UK][3] = 127,
	[0][1][1][0][RTW89_FCC][4] = 127,
	[0][1][1][0][RTW89_ETSI][4] = 127,
	[0][1][1][0][RTW89_MKK][4] = 127,
	[0][1][1][0][RTW89_IC][4] = 127,
	[0][1][1][0][RTW89_KCC][4] = 127,
	[0][1][1][0][RTW89_ACMA][4] = 127,
	[0][1][1][0][RTW89_CN][4] = 127,
	[0][1][1][0][RTW89_UK][4] = 127,
	[0][1][1][0][RTW89_FCC][5] = 127,
	[0][1][1][0][RTW89_ETSI][5] = 127,
	[0][1][1][0][RTW89_MKK][5] = 127,
	[0][1][1][0][RTW89_IC][5] = 127,
	[0][1][1][0][RTW89_KCC][5] = 127,
	[0][1][1][0][RTW89_ACMA][5] = 127,
	[0][1][1][0][RTW89_CN][5] = 127,
	[0][1][1][0][RTW89_UK][5] = 127,
	[0][1][1][0][RTW89_FCC][6] = 127,
	[0][1][1][0][RTW89_ETSI][6] = 127,
	[0][1][1][0][RTW89_MKK][6] = 127,
	[0][1][1][0][RTW89_IC][6] = 127,
	[0][1][1][0][RTW89_KCC][6] = 127,
	[0][1][1][0][RTW89_ACMA][6] = 127,
	[0][1][1][0][RTW89_CN][6] = 127,
	[0][1][1][0][RTW89_UK][6] = 127,
	[0][1][1][0][RTW89_FCC][7] = 127,
	[0][1][1][0][RTW89_ETSI][7] = 127,
	[0][1][1][0][RTW89_MKK][7] = 127,
	[0][1][1][0][RTW89_IC][7] = 127,
	[0][1][1][0][RTW89_KCC][7] = 127,
	[0][1][1][0][RTW89_ACMA][7] = 127,
	[0][1][1][0][RTW89_CN][7] = 127,
	[0][1][1][0][RTW89_UK][7] = 127,
	[0][1][1][0][RTW89_FCC][8] = 127,
	[0][1][1][0][RTW89_ETSI][8] = 127,
	[0][1][1][0][RTW89_MKK][8] = 127,
	[0][1][1][0][RTW89_IC][8] = 127,
	[0][1][1][0][RTW89_KCC][8] = 127,
	[0][1][1][0][RTW89_ACMA][8] = 127,
	[0][1][1][0][RTW89_CN][8] = 127,
	[0][1][1][0][RTW89_UK][8] = 127,
	[0][1][1][0][RTW89_FCC][9] = 127,
	[0][1][1][0][RTW89_ETSI][9] = 127,
	[0][1][1][0][RTW89_MKK][9] = 127,
	[0][1][1][0][RTW89_IC][9] = 127,
	[0][1][1][0][RTW89_KCC][9] = 127,
	[0][1][1][0][RTW89_ACMA][9] = 127,
	[0][1][1][0][RTW89_CN][9] = 127,
	[0][1][1][0][RTW89_UK][9] = 127,
	[0][1][1][0][RTW89_FCC][10] = 127,
	[0][1][1][0][RTW89_ETSI][10] = 127,
	[0][1][1][0][RTW89_MKK][10] = 127,
	[0][1][1][0][RTW89_IC][10] = 127,
	[0][1][1][0][RTW89_KCC][10] = 127,
	[0][1][1][0][RTW89_ACMA][10] = 127,
	[0][1][1][0][RTW89_CN][10] = 127,
	[0][1][1][0][RTW89_UK][10] = 127,
	[0][1][1][0][RTW89_FCC][11] = 127,
	[0][1][1][0][RTW89_ETSI][11] = 127,
	[0][1][1][0][RTW89_MKK][11] = 127,
	[0][1][1][0][RTW89_IC][11] = 127,
	[0][1][1][0][RTW89_KCC][11] = 127,
	[0][1][1][0][RTW89_ACMA][11] = 127,
	[0][1][1][0][RTW89_CN][11] = 127,
	[0][1][1][0][RTW89_UK][11] = 127,
	[0][1][1][0][RTW89_FCC][12] = 127,
	[0][1][1][0][RTW89_ETSI][12] = 127,
	[0][1][1][0][RTW89_MKK][12] = 127,
	[0][1][1][0][RTW89_IC][12] = 127,
	[0][1][1][0][RTW89_KCC][12] = 127,
	[0][1][1][0][RTW89_ACMA][12] = 127,
	[0][1][1][0][RTW89_CN][12] = 127,
	[0][1][1][0][RTW89_UK][12] = 127,
	[0][1][1][0][RTW89_FCC][13] = 127,
	[0][1][1][0][RTW89_ETSI][13] = 127,
	[0][1][1][0][RTW89_MKK][13] = 127,
	[0][1][1][0][RTW89_IC][13] = 127,
	[0][1][1][0][RTW89_KCC][13] = 127,
	[0][1][1][0][RTW89_ACMA][13] = 127,
	[0][1][1][0][RTW89_CN][13] = 127,
	[0][1][1][0][RTW89_UK][13] = 127,
	[0][0][2][0][RTW89_FCC][0] = 78,
	[0][0][2][0][RTW89_ETSI][0] = 60,
	[0][0][2][0][RTW89_MKK][0] = 72,
	[0][0][2][0][RTW89_IC][0] = 78,
	[0][0][2][0][RTW89_KCC][0] = 78,
	[0][0][2][0][RTW89_ACMA][0] = 60,
	[0][0][2][0][RTW89_CN][0] = 60,
	[0][0][2][0][RTW89_UK][0] = 60,
	[0][0][2][0][RTW89_FCC][1] = 78,
	[0][0][2][0][RTW89_ETSI][1] = 60,
	[0][0][2][0][RTW89_MKK][1] = 78,
	[0][0][2][0][RTW89_IC][1] = 78,
	[0][0][2][0][RTW89_KCC][1] = 78,
	[0][0][2][0][RTW89_ACMA][1] = 60,
	[0][0][2][0][RTW89_CN][1] = 60,
	[0][0][2][0][RTW89_UK][1] = 60,
	[0][0][2][0][RTW89_FCC][2] = 82,
	[0][0][2][0][RTW89_ETSI][2] = 60,
	[0][0][2][0][RTW89_MKK][2] = 78,
	[0][0][2][0][RTW89_IC][2] = 82,
	[0][0][2][0][RTW89_KCC][2] = 78,
	[0][0][2][0][RTW89_ACMA][2] = 60,
	[0][0][2][0][RTW89_CN][2] = 60,
	[0][0][2][0][RTW89_UK][2] = 60,
	[0][0][2][0][RTW89_FCC][3] = 82,
	[0][0][2][0][RTW89_ETSI][3] = 60,
	[0][0][2][0][RTW89_MKK][3] = 78,
	[0][0][2][0][RTW89_IC][3] = 82,
	[0][0][2][0][RTW89_KCC][3] = 78,
	[0][0][2][0][RTW89_ACMA][3] = 60,
	[0][0][2][0][RTW89_CN][3] = 60,
	[0][0][2][0][RTW89_UK][3] = 60,
	[0][0][2][0][RTW89_FCC][4] = 82,
	[0][0][2][0][RTW89_ETSI][4] = 60,
	[0][0][2][0][RTW89_MKK][4] = 78,
	[0][0][2][0][RTW89_IC][4] = 82,
	[0][0][2][0][RTW89_KCC][4] = 78,
	[0][0][2][0][RTW89_ACMA][4] = 60,
	[0][0][2][0][RTW89_CN][4] = 60,
	[0][0][2][0][RTW89_UK][4] = 60,
	[0][0][2][0][RTW89_FCC][5] = 82,
	[0][0][2][0][RTW89_ETSI][5] = 60,
	[0][0][2][0][RTW89_MKK][5] = 78,
	[0][0][2][0][RTW89_IC][5] = 82,
	[0][0][2][0][RTW89_KCC][5] = 78,
	[0][0][2][0][RTW89_ACMA][5] = 60,
	[0][0][2][0][RTW89_CN][5] = 60,
	[0][0][2][0][RTW89_UK][5] = 60,
	[0][0][2][0][RTW89_FCC][6] = 82,
	[0][0][2][0][RTW89_ETSI][6] = 60,
	[0][0][2][0][RTW89_MKK][6] = 78,
	[0][0][2][0][RTW89_IC][6] = 82,
	[0][0][2][0][RTW89_KCC][6] = 78,
	[0][0][2][0][RTW89_ACMA][6] = 60,
	[0][0][2][0][RTW89_CN][6] = 60,
	[0][0][2][0][RTW89_UK][6] = 60,
	[0][0][2][0][RTW89_FCC][7] = 82,
	[0][0][2][0][RTW89_ETSI][7] = 60,
	[0][0][2][0][RTW89_MKK][7] = 78,
	[0][0][2][0][RTW89_IC][7] = 82,
	[0][0][2][0][RTW89_KCC][7] = 78,
	[0][0][2][0][RTW89_ACMA][7] = 60,
	[0][0][2][0][RTW89_CN][7] = 60,
	[0][0][2][0][RTW89_UK][7] = 60,
	[0][0][2][0][RTW89_FCC][8] = 80,
	[0][0][2][0][RTW89_ETSI][8] = 60,
	[0][0][2][0][RTW89_MKK][8] = 78,
	[0][0][2][0][RTW89_IC][8] = 80,
	[0][0][2][0][RTW89_KCC][8] = 78,
	[0][0][2][0][RTW89_ACMA][8] = 60,
	[0][0][2][0][RTW89_CN][8] = 60,
	[0][0][2][0][RTW89_UK][8] = 60,
	[0][0][2][0][RTW89_FCC][9] = 76,
	[0][0][2][0][RTW89_ETSI][9] = 60,
	[0][0][2][0][RTW89_MKK][9] = 78,
	[0][0][2][0][RTW89_IC][9] = 76,
	[0][0][2][0][RTW89_KCC][9] = 78,
	[0][0][2][0][RTW89_ACMA][9] = 60,
	[0][0][2][0][RTW89_CN][9] = 60,
	[0][0][2][0][RTW89_UK][9] = 60,
	[0][0][2][0][RTW89_FCC][10] = 76,
	[0][0][2][0][RTW89_ETSI][10] = 60,
	[0][0][2][0][RTW89_MKK][10] = 78,
	[0][0][2][0][RTW89_IC][10] = 76,
	[0][0][2][0][RTW89_KCC][10] = 78,
	[0][0][2][0][RTW89_ACMA][10] = 60,
	[0][0][2][0][RTW89_CN][10] = 60,
	[0][0][2][0][RTW89_UK][10] = 60,
	[0][0][2][0][RTW89_FCC][11] = 70,
	[0][0][2][0][RTW89_ETSI][11] = 60,
	[0][0][2][0][RTW89_MKK][11] = 78,
	[0][0][2][0][RTW89_IC][11] = 70,
	[0][0][2][0][RTW89_KCC][11] = 78,
	[0][0][2][0][RTW89_ACMA][11] = 60,
	[0][0][2][0][RTW89_CN][11] = 60,
	[0][0][2][0][RTW89_UK][11] = 60,
	[0][0][2][0][RTW89_FCC][12] = 70,
	[0][0][2][0][RTW89_ETSI][12] = 60,
	[0][0][2][0][RTW89_MKK][12] = 70,
	[0][0][2][0][RTW89_IC][12] = 70,
	[0][0][2][0][RTW89_KCC][12] = 78,
	[0][0][2][0][RTW89_ACMA][12] = 60,
	[0][0][2][0][RTW89_CN][12] = 38,
	[0][0][2][0][RTW89_UK][12] = 60,
	[0][0][2][0][RTW89_FCC][13] = 127,
	[0][0][2][0][RTW89_ETSI][13] = 127,
	[0][0][2][0][RTW89_MKK][13] = 127,
	[0][0][2][0][RTW89_IC][13] = 127,
	[0][0][2][0][RTW89_KCC][13] = 127,
	[0][0][2][0][RTW89_ACMA][13] = 127,
	[0][0][2][0][RTW89_CN][13] = 127,
	[0][0][2][0][RTW89_UK][13] = 127,
	[0][1][2][0][RTW89_FCC][0] = 127,
	[0][1][2][0][RTW89_ETSI][0] = 127,
	[0][1][2][0][RTW89_MKK][0] = 127,
	[0][1][2][0][RTW89_IC][0] = 127,
	[0][1][2][0][RTW89_KCC][0] = 127,
	[0][1][2][0][RTW89_ACMA][0] = 127,
	[0][1][2][0][RTW89_CN][0] = 127,
	[0][1][2][0][RTW89_UK][0] = 127,
	[0][1][2][0][RTW89_FCC][1] = 127,
	[0][1][2][0][RTW89_ETSI][1] = 127,
	[0][1][2][0][RTW89_MKK][1] = 127,
	[0][1][2][0][RTW89_IC][1] = 127,
	[0][1][2][0][RTW89_KCC][1] = 127,
	[0][1][2][0][RTW89_ACMA][1] = 127,
	[0][1][2][0][RTW89_CN][1] = 127,
	[0][1][2][0][RTW89_UK][1] = 127,
	[0][1][2][0][RTW89_FCC][2] = 127,
	[0][1][2][0][RTW89_ETSI][2] = 127,
	[0][1][2][0][RTW89_MKK][2] = 127,
	[0][1][2][0][RTW89_IC][2] = 127,
	[0][1][2][0][RTW89_KCC][2] = 127,
	[0][1][2][0][RTW89_ACMA][2] = 127,
	[0][1][2][0][RTW89_CN][2] = 127,
	[0][1][2][0][RTW89_UK][2] = 127,
	[0][1][2][0][RTW89_FCC][3] = 127,
	[0][1][2][0][RTW89_ETSI][3] = 127,
	[0][1][2][0][RTW89_MKK][3] = 127,
	[0][1][2][0][RTW89_IC][3] = 127,
	[0][1][2][0][RTW89_KCC][3] = 127,
	[0][1][2][0][RTW89_ACMA][3] = 127,
	[0][1][2][0][RTW89_CN][3] = 127,
	[0][1][2][0][RTW89_UK][3] = 127,
	[0][1][2][0][RTW89_FCC][4] = 127,
	[0][1][2][0][RTW89_ETSI][4] = 127,
	[0][1][2][0][RTW89_MKK][4] = 127,
	[0][1][2][0][RTW89_IC][4] = 127,
	[0][1][2][0][RTW89_KCC][4] = 127,
	[0][1][2][0][RTW89_ACMA][4] = 127,
	[0][1][2][0][RTW89_CN][4] = 127,
	[0][1][2][0][RTW89_UK][4] = 127,
	[0][1][2][0][RTW89_FCC][5] = 127,
	[0][1][2][0][RTW89_ETSI][5] = 127,
	[0][1][2][0][RTW89_MKK][5] = 127,
	[0][1][2][0][RTW89_IC][5] = 127,
	[0][1][2][0][RTW89_KCC][5] = 127,
	[0][1][2][0][RTW89_ACMA][5] = 127,
	[0][1][2][0][RTW89_CN][5] = 127,
	[0][1][2][0][RTW89_UK][5] = 127,
	[0][1][2][0][RTW89_FCC][6] = 127,
	[0][1][2][0][RTW89_ETSI][6] = 127,
	[0][1][2][0][RTW89_MKK][6] = 127,
	[0][1][2][0][RTW89_IC][6] = 127,
	[0][1][2][0][RTW89_KCC][6] = 127,
	[0][1][2][0][RTW89_ACMA][6] = 127,
	[0][1][2][0][RTW89_CN][6] = 127,
	[0][1][2][0][RTW89_UK][6] = 127,
	[0][1][2][0][RTW89_FCC][7] = 127,
	[0][1][2][0][RTW89_ETSI][7] = 127,
	[0][1][2][0][RTW89_MKK][7] = 127,
	[0][1][2][0][RTW89_IC][7] = 127,
	[0][1][2][0][RTW89_KCC][7] = 127,
	[0][1][2][0][RTW89_ACMA][7] = 127,
	[0][1][2][0][RTW89_CN][7] = 127,
	[0][1][2][0][RTW89_UK][7] = 127,
	[0][1][2][0][RTW89_FCC][8] = 127,
	[0][1][2][0][RTW89_ETSI][8] = 127,
	[0][1][2][0][RTW89_MKK][8] = 127,
	[0][1][2][0][RTW89_IC][8] = 127,
	[0][1][2][0][RTW89_KCC][8] = 127,
	[0][1][2][0][RTW89_ACMA][8] = 127,
	[0][1][2][0][RTW89_CN][8] = 127,
	[0][1][2][0][RTW89_UK][8] = 127,
	[0][1][2][0][RTW89_FCC][9] = 127,
	[0][1][2][0][RTW89_ETSI][9] = 127,
	[0][1][2][0][RTW89_MKK][9] = 127,
	[0][1][2][0][RTW89_IC][9] = 127,
	[0][1][2][0][RTW89_KCC][9] = 127,
	[0][1][2][0][RTW89_ACMA][9] = 127,
	[0][1][2][0][RTW89_CN][9] = 127,
	[0][1][2][0][RTW89_UK][9] = 127,
	[0][1][2][0][RTW89_FCC][10] = 127,
	[0][1][2][0][RTW89_ETSI][10] = 127,
	[0][1][2][0][RTW89_MKK][10] = 127,
	[0][1][2][0][RTW89_IC][10] = 127,
	[0][1][2][0][RTW89_KCC][10] = 127,
	[0][1][2][0][RTW89_ACMA][10] = 127,
	[0][1][2][0][RTW89_CN][10] = 127,
	[0][1][2][0][RTW89_UK][10] = 127,
	[0][1][2][0][RTW89_FCC][11] = 127,
	[0][1][2][0][RTW89_ETSI][11] = 127,
	[0][1][2][0][RTW89_MKK][11] = 127,
	[0][1][2][0][RTW89_IC][11] = 127,
	[0][1][2][0][RTW89_KCC][11] = 127,
	[0][1][2][0][RTW89_ACMA][11] = 127,
	[0][1][2][0][RTW89_CN][11] = 127,
	[0][1][2][0][RTW89_UK][11] = 127,
	[0][1][2][0][RTW89_FCC][12] = 127,
	[0][1][2][0][RTW89_ETSI][12] = 127,
	[0][1][2][0][RTW89_MKK][12] = 127,
	[0][1][2][0][RTW89_IC][12] = 127,
	[0][1][2][0][RTW89_KCC][12] = 127,
	[0][1][2][0][RTW89_ACMA][12] = 127,
	[0][1][2][0][RTW89_CN][12] = 127,
	[0][1][2][0][RTW89_UK][12] = 127,
	[0][1][2][0][RTW89_FCC][13] = 127,
	[0][1][2][0][RTW89_ETSI][13] = 127,
	[0][1][2][0][RTW89_MKK][13] = 127,
	[0][1][2][0][RTW89_IC][13] = 127,
	[0][1][2][0][RTW89_KCC][13] = 127,
	[0][1][2][0][RTW89_ACMA][13] = 127,
	[0][1][2][0][RTW89_CN][13] = 127,
	[0][1][2][0][RTW89_UK][13] = 127,
	[0][1][2][1][RTW89_FCC][0] = 127,
	[0][1][2][1][RTW89_ETSI][0] = 127,
	[0][1][2][1][RTW89_MKK][0] = 127,
	[0][1][2][1][RTW89_IC][0] = 127,
	[0][1][2][1][RTW89_KCC][0] = 127,
	[0][1][2][1][RTW89_ACMA][0] = 127,
	[0][1][2][1][RTW89_CN][0] = 127,
	[0][1][2][1][RTW89_UK][0] = 127,
	[0][1][2][1][RTW89_FCC][1] = 127,
	[0][1][2][1][RTW89_ETSI][1] = 127,
	[0][1][2][1][RTW89_MKK][1] = 127,
	[0][1][2][1][RTW89_IC][1] = 127,
	[0][1][2][1][RTW89_KCC][1] = 127,
	[0][1][2][1][RTW89_ACMA][1] = 127,
	[0][1][2][1][RTW89_CN][1] = 127,
	[0][1][2][1][RTW89_UK][1] = 127,
	[0][1][2][1][RTW89_FCC][2] = 127,
	[0][1][2][1][RTW89_ETSI][2] = 127,
	[0][1][2][1][RTW89_MKK][2] = 127,
	[0][1][2][1][RTW89_IC][2] = 127,
	[0][1][2][1][RTW89_KCC][2] = 127,
	[0][1][2][1][RTW89_ACMA][2] = 127,
	[0][1][2][1][RTW89_CN][2] = 127,
	[0][1][2][1][RTW89_UK][2] = 127,
	[0][1][2][1][RTW89_FCC][3] = 127,
	[0][1][2][1][RTW89_ETSI][3] = 127,
	[0][1][2][1][RTW89_MKK][3] = 127,
	[0][1][2][1][RTW89_IC][3] = 127,
	[0][1][2][1][RTW89_KCC][3] = 127,
	[0][1][2][1][RTW89_ACMA][3] = 127,
	[0][1][2][1][RTW89_CN][3] = 127,
	[0][1][2][1][RTW89_UK][3] = 127,
	[0][1][2][1][RTW89_FCC][4] = 127,
	[0][1][2][1][RTW89_ETSI][4] = 127,
	[0][1][2][1][RTW89_MKK][4] = 127,
	[0][1][2][1][RTW89_IC][4] = 127,
	[0][1][2][1][RTW89_KCC][4] = 127,
	[0][1][2][1][RTW89_ACMA][4] = 127,
	[0][1][2][1][RTW89_CN][4] = 127,
	[0][1][2][1][RTW89_UK][4] = 127,
	[0][1][2][1][RTW89_FCC][5] = 127,
	[0][1][2][1][RTW89_ETSI][5] = 127,
	[0][1][2][1][RTW89_MKK][5] = 127,
	[0][1][2][1][RTW89_IC][5] = 127,
	[0][1][2][1][RTW89_KCC][5] = 127,
	[0][1][2][1][RTW89_ACMA][5] = 127,
	[0][1][2][1][RTW89_CN][5] = 127,
	[0][1][2][1][RTW89_UK][5] = 127,
	[0][1][2][1][RTW89_FCC][6] = 127,
	[0][1][2][1][RTW89_ETSI][6] = 127,
	[0][1][2][1][RTW89_MKK][6] = 127,
	[0][1][2][1][RTW89_IC][6] = 127,
	[0][1][2][1][RTW89_KCC][6] = 127,
	[0][1][2][1][RTW89_ACMA][6] = 127,
	[0][1][2][1][RTW89_CN][6] = 127,
	[0][1][2][1][RTW89_UK][6] = 127,
	[0][1][2][1][RTW89_FCC][7] = 127,
	[0][1][2][1][RTW89_ETSI][7] = 127,
	[0][1][2][1][RTW89_MKK][7] = 127,
	[0][1][2][1][RTW89_IC][7] = 127,
	[0][1][2][1][RTW89_KCC][7] = 127,
	[0][1][2][1][RTW89_ACMA][7] = 127,
	[0][1][2][1][RTW89_CN][7] = 127,
	[0][1][2][1][RTW89_UK][7] = 127,
	[0][1][2][1][RTW89_FCC][8] = 127,
	[0][1][2][1][RTW89_ETSI][8] = 127,
	[0][1][2][1][RTW89_MKK][8] = 127,
	[0][1][2][1][RTW89_IC][8] = 127,
	[0][1][2][1][RTW89_KCC][8] = 127,
	[0][1][2][1][RTW89_ACMA][8] = 127,
	[0][1][2][1][RTW89_CN][8] = 127,
	[0][1][2][1][RTW89_UK][8] = 127,
	[0][1][2][1][RTW89_FCC][9] = 127,
	[0][1][2][1][RTW89_ETSI][9] = 127,
	[0][1][2][1][RTW89_MKK][9] = 127,
	[0][1][2][1][RTW89_IC][9] = 127,
	[0][1][2][1][RTW89_KCC][9] = 127,
	[0][1][2][1][RTW89_ACMA][9] = 127,
	[0][1][2][1][RTW89_CN][9] = 127,
	[0][1][2][1][RTW89_UK][9] = 127,
	[0][1][2][1][RTW89_FCC][10] = 127,
	[0][1][2][1][RTW89_ETSI][10] = 127,
	[0][1][2][1][RTW89_MKK][10] = 127,
	[0][1][2][1][RTW89_IC][10] = 127,
	[0][1][2][1][RTW89_KCC][10] = 127,
	[0][1][2][1][RTW89_ACMA][10] = 127,
	[0][1][2][1][RTW89_CN][10] = 127,
	[0][1][2][1][RTW89_UK][10] = 127,
	[0][1][2][1][RTW89_FCC][11] = 127,
	[0][1][2][1][RTW89_ETSI][11] = 127,
	[0][1][2][1][RTW89_MKK][11] = 127,
	[0][1][2][1][RTW89_IC][11] = 127,
	[0][1][2][1][RTW89_KCC][11] = 127,
	[0][1][2][1][RTW89_ACMA][11] = 127,
	[0][1][2][1][RTW89_CN][11] = 127,
	[0][1][2][1][RTW89_UK][11] = 127,
	[0][1][2][1][RTW89_FCC][12] = 127,
	[0][1][2][1][RTW89_ETSI][12] = 127,
	[0][1][2][1][RTW89_MKK][12] = 127,
	[0][1][2][1][RTW89_IC][12] = 127,
	[0][1][2][1][RTW89_KCC][12] = 127,
	[0][1][2][1][RTW89_ACMA][12] = 127,
	[0][1][2][1][RTW89_CN][12] = 127,
	[0][1][2][1][RTW89_UK][12] = 127,
	[0][1][2][1][RTW89_FCC][13] = 127,
	[0][1][2][1][RTW89_ETSI][13] = 127,
	[0][1][2][1][RTW89_MKK][13] = 127,
	[0][1][2][1][RTW89_IC][13] = 127,
	[0][1][2][1][RTW89_KCC][13] = 127,
	[0][1][2][1][RTW89_ACMA][13] = 127,
	[0][1][2][1][RTW89_CN][13] = 127,
	[0][1][2][1][RTW89_UK][13] = 127,
	[1][0][2][0][RTW89_FCC][0] = 127,
	[1][0][2][0][RTW89_ETSI][0] = 127,
	[1][0][2][0][RTW89_MKK][0] = 127,
	[1][0][2][0][RTW89_IC][0] = 127,
	[1][0][2][0][RTW89_KCC][0] = 127,
	[1][0][2][0][RTW89_ACMA][0] = 127,
	[1][0][2][0][RTW89_CN][0] = 127,
	[1][0][2][0][RTW89_UK][0] = 127,
	[1][0][2][0][RTW89_FCC][1] = 127,
	[1][0][2][0][RTW89_ETSI][1] = 127,
	[1][0][2][0][RTW89_MKK][1] = 127,
	[1][0][2][0][RTW89_IC][1] = 127,
	[1][0][2][0][RTW89_KCC][1] = 127,
	[1][0][2][0][RTW89_ACMA][1] = 127,
	[1][0][2][0][RTW89_CN][1] = 127,
	[1][0][2][0][RTW89_UK][1] = 127,
	[1][0][2][0][RTW89_FCC][2] = 72,
	[1][0][2][0][RTW89_ETSI][2] = 58,
	[1][0][2][0][RTW89_MKK][2] = 80,
	[1][0][2][0][RTW89_IC][2] = 72,
	[1][0][2][0][RTW89_KCC][2] = 80,
	[1][0][2][0][RTW89_ACMA][2] = 58,
	[1][0][2][0][RTW89_CN][2] = 58,
	[1][0][2][0][RTW89_UK][2] = 58,
	[1][0][2][0][RTW89_FCC][3] = 72,
	[1][0][2][0][RTW89_ETSI][3] = 58,
	[1][0][2][0][RTW89_MKK][3] = 80,
	[1][0][2][0][RTW89_IC][3] = 72,
	[1][0][2][0][RTW89_KCC][3] = 80,
	[1][0][2][0][RTW89_ACMA][3] = 58,
	[1][0][2][0][RTW89_CN][3] = 58,
	[1][0][2][0][RTW89_UK][3] = 58,
	[1][0][2][0][RTW89_FCC][4] = 76,
	[1][0][2][0][RTW89_ETSI][4] = 58,
	[1][0][2][0][RTW89_MKK][4] = 80,
	[1][0][2][0][RTW89_IC][4] = 76,
	[1][0][2][0][RTW89_KCC][4] = 80,
	[1][0][2][0][RTW89_ACMA][4] = 58,
	[1][0][2][0][RTW89_CN][4] = 58,
	[1][0][2][0][RTW89_UK][4] = 58,
	[1][0][2][0][RTW89_FCC][5] = 78,
	[1][0][2][0][RTW89_ETSI][5] = 58,
	[1][0][2][0][RTW89_MKK][5] = 80,
	[1][0][2][0][RTW89_IC][5] = 78,
	[1][0][2][0][RTW89_KCC][5] = 80,
	[1][0][2][0][RTW89_ACMA][5] = 58,
	[1][0][2][0][RTW89_CN][5] = 58,
	[1][0][2][0][RTW89_UK][5] = 58,
	[1][0][2][0][RTW89_FCC][6] = 78,
	[1][0][2][0][RTW89_ETSI][6] = 58,
	[1][0][2][0][RTW89_MKK][6] = 78,
	[1][0][2][0][RTW89_IC][6] = 78,
	[1][0][2][0][RTW89_KCC][6] = 80,
	[1][0][2][0][RTW89_ACMA][6] = 58,
	[1][0][2][0][RTW89_CN][6] = 58,
	[1][0][2][0][RTW89_UK][6] = 58,
	[1][0][2][0][RTW89_FCC][7] = 78,
	[1][0][2][0][RTW89_ETSI][7] = 58,
	[1][0][2][0][RTW89_MKK][7] = 80,
	[1][0][2][0][RTW89_IC][7] = 78,
	[1][0][2][0][RTW89_KCC][7] = 80,
	[1][0][2][0][RTW89_ACMA][7] = 58,
	[1][0][2][0][RTW89_CN][7] = 58,
	[1][0][2][0][RTW89_UK][7] = 58,
	[1][0][2][0][RTW89_FCC][8] = 78,
	[1][0][2][0][RTW89_ETSI][8] = 58,
	[1][0][2][0][RTW89_MKK][8] = 80,
	[1][0][2][0][RTW89_IC][8] = 78,
	[1][0][2][0][RTW89_KCC][8] = 78,
	[1][0][2][0][RTW89_ACMA][8] = 58,
	[1][0][2][0][RTW89_CN][8] = 58,
	[1][0][2][0][RTW89_UK][8] = 58,
	[1][0][2][0][RTW89_FCC][9] = 76,
	[1][0][2][0][RTW89_ETSI][9] = 58,
	[1][0][2][0][RTW89_MKK][9] = 80,
	[1][0][2][0][RTW89_IC][9] = 76,
	[1][0][2][0][RTW89_KCC][9] = 78,
	[1][0][2][0][RTW89_ACMA][9] = 58,
	[1][0][2][0][RTW89_CN][9] = 58,
	[1][0][2][0][RTW89_UK][9] = 58,
	[1][0][2][0][RTW89_FCC][10] = 70,
	[1][0][2][0][RTW89_ETSI][10] = 58,
	[1][0][2][0][RTW89_MKK][10] = 78,
	[1][0][2][0][RTW89_IC][10] = 70,
	[1][0][2][0][RTW89_KCC][10] = 78,
	[1][0][2][0][RTW89_ACMA][10] = 58,
	[1][0][2][0][RTW89_CN][10] = 46,
	[1][0][2][0][RTW89_UK][10] = 58,
	[1][0][2][0][RTW89_FCC][11] = 127,
	[1][0][2][0][RTW89_ETSI][11] = 127,
	[1][0][2][0][RTW89_MKK][11] = 127,
	[1][0][2][0][RTW89_IC][11] = 127,
	[1][0][2][0][RTW89_KCC][11] = 127,
	[1][0][2][0][RTW89_ACMA][11] = 127,
	[1][0][2][0][RTW89_CN][11] = 127,
	[1][0][2][0][RTW89_UK][11] = 127,
	[1][0][2][0][RTW89_FCC][12] = 127,
	[1][0][2][0][RTW89_ETSI][12] = 127,
	[1][0][2][0][RTW89_MKK][12] = 127,
	[1][0][2][0][RTW89_IC][12] = 127,
	[1][0][2][0][RTW89_KCC][12] = 127,
	[1][0][2][0][RTW89_ACMA][12] = 127,
	[1][0][2][0][RTW89_CN][12] = 127,
	[1][0][2][0][RTW89_UK][12] = 127,
	[1][0][2][0][RTW89_FCC][13] = 127,
	[1][0][2][0][RTW89_ETSI][13] = 127,
	[1][0][2][0][RTW89_MKK][13] = 127,
	[1][0][2][0][RTW89_IC][13] = 127,
	[1][0][2][0][RTW89_KCC][13] = 127,
	[1][0][2][0][RTW89_ACMA][13] = 127,
	[1][0][2][0][RTW89_CN][13] = 127,
	[1][0][2][0][RTW89_UK][13] = 127,
	[1][1][2][0][RTW89_FCC][0] = 127,
	[1][1][2][0][RTW89_ETSI][0] = 127,
	[1][1][2][0][RTW89_MKK][0] = 127,
	[1][1][2][0][RTW89_IC][0] = 127,
	[1][1][2][0][RTW89_KCC][0] = 127,
	[1][1][2][0][RTW89_ACMA][0] = 127,
	[1][1][2][0][RTW89_CN][0] = 127,
	[1][1][2][0][RTW89_UK][0] = 127,
	[1][1][2][0][RTW89_FCC][1] = 127,
	[1][1][2][0][RTW89_ETSI][1] = 127,
	[1][1][2][0][RTW89_MKK][1] = 127,
	[1][1][2][0][RTW89_IC][1] = 127,
	[1][1][2][0][RTW89_KCC][1] = 127,
	[1][1][2][0][RTW89_ACMA][1] = 127,
	[1][1][2][0][RTW89_CN][1] = 127,
	[1][1][2][0][RTW89_UK][1] = 127,
	[1][1][2][0][RTW89_FCC][2] = 127,
	[1][1][2][0][RTW89_ETSI][2] = 127,
	[1][1][2][0][RTW89_MKK][2] = 127,
	[1][1][2][0][RTW89_IC][2] = 127,
	[1][1][2][0][RTW89_KCC][2] = 127,
	[1][1][2][0][RTW89_ACMA][2] = 127,
	[1][1][2][0][RTW89_CN][2] = 127,
	[1][1][2][0][RTW89_UK][2] = 127,
	[1][1][2][0][RTW89_FCC][3] = 127,
	[1][1][2][0][RTW89_ETSI][3] = 127,
	[1][1][2][0][RTW89_MKK][3] = 127,
	[1][1][2][0][RTW89_IC][3] = 127,
	[1][1][2][0][RTW89_KCC][3] = 127,
	[1][1][2][0][RTW89_ACMA][3] = 127,
	[1][1][2][0][RTW89_CN][3] = 127,
	[1][1][2][0][RTW89_UK][3] = 127,
	[1][1][2][0][RTW89_FCC][4] = 127,
	[1][1][2][0][RTW89_ETSI][4] = 127,
	[1][1][2][0][RTW89_MKK][4] = 127,
	[1][1][2][0][RTW89_IC][4] = 127,
	[1][1][2][0][RTW89_KCC][4] = 127,
	[1][1][2][0][RTW89_ACMA][4] = 127,
	[1][1][2][0][RTW89_CN][4] = 127,
	[1][1][2][0][RTW89_UK][4] = 127,
	[1][1][2][0][RTW89_FCC][5] = 127,
	[1][1][2][0][RTW89_ETSI][5] = 127,
	[1][1][2][0][RTW89_MKK][5] = 127,
	[1][1][2][0][RTW89_IC][5] = 127,
	[1][1][2][0][RTW89_KCC][5] = 127,
	[1][1][2][0][RTW89_ACMA][5] = 127,
	[1][1][2][0][RTW89_CN][5] = 127,
	[1][1][2][0][RTW89_UK][5] = 127,
	[1][1][2][0][RTW89_FCC][6] = 127,
	[1][1][2][0][RTW89_ETSI][6] = 127,
	[1][1][2][0][RTW89_MKK][6] = 127,
	[1][1][2][0][RTW89_IC][6] = 127,
	[1][1][2][0][RTW89_KCC][6] = 127,
	[1][1][2][0][RTW89_ACMA][6] = 127,
	[1][1][2][0][RTW89_CN][6] = 127,
	[1][1][2][0][RTW89_UK][6] = 127,
	[1][1][2][0][RTW89_FCC][7] = 127,
	[1][1][2][0][RTW89_ETSI][7] = 127,
	[1][1][2][0][RTW89_MKK][7] = 127,
	[1][1][2][0][RTW89_IC][7] = 127,
	[1][1][2][0][RTW89_KCC][7] = 127,
	[1][1][2][0][RTW89_ACMA][7] = 127,
	[1][1][2][0][RTW89_CN][7] = 127,
	[1][1][2][0][RTW89_UK][7] = 127,
	[1][1][2][0][RTW89_FCC][8] = 127,
	[1][1][2][0][RTW89_ETSI][8] = 127,
	[1][1][2][0][RTW89_MKK][8] = 127,
	[1][1][2][0][RTW89_IC][8] = 127,
	[1][1][2][0][RTW89_KCC][8] = 127,
	[1][1][2][0][RTW89_ACMA][8] = 127,
	[1][1][2][0][RTW89_CN][8] = 127,
	[1][1][2][0][RTW89_UK][8] = 127,
	[1][1][2][0][RTW89_FCC][9] = 127,
	[1][1][2][0][RTW89_ETSI][9] = 127,
	[1][1][2][0][RTW89_MKK][9] = 127,
	[1][1][2][0][RTW89_IC][9] = 127,
	[1][1][2][0][RTW89_KCC][9] = 127,
	[1][1][2][0][RTW89_ACMA][9] = 127,
	[1][1][2][0][RTW89_CN][9] = 127,
	[1][1][2][0][RTW89_UK][9] = 127,
	[1][1][2][0][RTW89_FCC][10] = 127,
	[1][1][2][0][RTW89_ETSI][10] = 127,
	[1][1][2][0][RTW89_MKK][10] = 127,
	[1][1][2][0][RTW89_IC][10] = 127,
	[1][1][2][0][RTW89_KCC][10] = 127,
	[1][1][2][0][RTW89_ACMA][10] = 127,
	[1][1][2][0][RTW89_CN][10] = 127,
	[1][1][2][0][RTW89_UK][10] = 127,
	[1][1][2][0][RTW89_FCC][11] = 127,
	[1][1][2][0][RTW89_ETSI][11] = 127,
	[1][1][2][0][RTW89_MKK][11] = 127,
	[1][1][2][0][RTW89_IC][11] = 127,
	[1][1][2][0][RTW89_KCC][11] = 127,
	[1][1][2][0][RTW89_ACMA][11] = 127,
	[1][1][2][0][RTW89_CN][11] = 127,
	[1][1][2][0][RTW89_UK][11] = 127,
	[1][1][2][0][RTW89_FCC][12] = 127,
	[1][1][2][0][RTW89_ETSI][12] = 127,
	[1][1][2][0][RTW89_MKK][12] = 127,
	[1][1][2][0][RTW89_IC][12] = 127,
	[1][1][2][0][RTW89_KCC][12] = 127,
	[1][1][2][0][RTW89_ACMA][12] = 127,
	[1][1][2][0][RTW89_CN][12] = 127,
	[1][1][2][0][RTW89_UK][12] = 127,
	[1][1][2][0][RTW89_FCC][13] = 127,
	[1][1][2][0][RTW89_ETSI][13] = 127,
	[1][1][2][0][RTW89_MKK][13] = 127,
	[1][1][2][0][RTW89_IC][13] = 127,
	[1][1][2][0][RTW89_KCC][13] = 127,
	[1][1][2][0][RTW89_ACMA][13] = 127,
	[1][1][2][0][RTW89_CN][13] = 127,
	[1][1][2][0][RTW89_UK][13] = 127,
	[1][1][2][1][RTW89_FCC][0] = 127,
	[1][1][2][1][RTW89_ETSI][0] = 127,
	[1][1][2][1][RTW89_MKK][0] = 127,
	[1][1][2][1][RTW89_IC][0] = 127,
	[1][1][2][1][RTW89_KCC][0] = 127,
	[1][1][2][1][RTW89_ACMA][0] = 127,
	[1][1][2][1][RTW89_CN][0] = 127,
	[1][1][2][1][RTW89_UK][0] = 127,
	[1][1][2][1][RTW89_FCC][1] = 127,
	[1][1][2][1][RTW89_ETSI][1] = 127,
	[1][1][2][1][RTW89_MKK][1] = 127,
	[1][1][2][1][RTW89_IC][1] = 127,
	[1][1][2][1][RTW89_KCC][1] = 127,
	[1][1][2][1][RTW89_ACMA][1] = 127,
	[1][1][2][1][RTW89_CN][1] = 127,
	[1][1][2][1][RTW89_UK][1] = 127,
	[1][1][2][1][RTW89_FCC][2] = 127,
	[1][1][2][1][RTW89_ETSI][2] = 127,
	[1][1][2][1][RTW89_MKK][2] = 127,
	[1][1][2][1][RTW89_IC][2] = 127,
	[1][1][2][1][RTW89_KCC][2] = 127,
	[1][1][2][1][RTW89_ACMA][2] = 127,
	[1][1][2][1][RTW89_CN][2] = 127,
	[1][1][2][1][RTW89_UK][2] = 127,
	[1][1][2][1][RTW89_FCC][3] = 127,
	[1][1][2][1][RTW89_ETSI][3] = 127,
	[1][1][2][1][RTW89_MKK][3] = 127,
	[1][1][2][1][RTW89_IC][3] = 127,
	[1][1][2][1][RTW89_KCC][3] = 127,
	[1][1][2][1][RTW89_ACMA][3] = 127,
	[1][1][2][1][RTW89_CN][3] = 127,
	[1][1][2][1][RTW89_UK][3] = 127,
	[1][1][2][1][RTW89_FCC][4] = 127,
	[1][1][2][1][RTW89_ETSI][4] = 127,
	[1][1][2][1][RTW89_MKK][4] = 127,
	[1][1][2][1][RTW89_IC][4] = 127,
	[1][1][2][1][RTW89_KCC][4] = 127,
	[1][1][2][1][RTW89_ACMA][4] = 127,
	[1][1][2][1][RTW89_CN][4] = 127,
	[1][1][2][1][RTW89_UK][4] = 127,
	[1][1][2][1][RTW89_FCC][5] = 127,
	[1][1][2][1][RTW89_ETSI][5] = 127,
	[1][1][2][1][RTW89_MKK][5] = 127,
	[1][1][2][1][RTW89_IC][5] = 127,
	[1][1][2][1][RTW89_KCC][5] = 127,
	[1][1][2][1][RTW89_ACMA][5] = 127,
	[1][1][2][1][RTW89_CN][5] = 127,
	[1][1][2][1][RTW89_UK][5] = 127,
	[1][1][2][1][RTW89_FCC][6] = 127,
	[1][1][2][1][RTW89_ETSI][6] = 127,
	[1][1][2][1][RTW89_MKK][6] = 127,
	[1][1][2][1][RTW89_IC][6] = 127,
	[1][1][2][1][RTW89_KCC][6] = 127,
	[1][1][2][1][RTW89_ACMA][6] = 127,
	[1][1][2][1][RTW89_CN][6] = 127,
	[1][1][2][1][RTW89_UK][6] = 127,
	[1][1][2][1][RTW89_FCC][7] = 127,
	[1][1][2][1][RTW89_ETSI][7] = 127,
	[1][1][2][1][RTW89_MKK][7] = 127,
	[1][1][2][1][RTW89_IC][7] = 127,
	[1][1][2][1][RTW89_KCC][7] = 127,
	[1][1][2][1][RTW89_ACMA][7] = 127,
	[1][1][2][1][RTW89_CN][7] = 127,
	[1][1][2][1][RTW89_UK][7] = 127,
	[1][1][2][1][RTW89_FCC][8] = 127,
	[1][1][2][1][RTW89_ETSI][8] = 127,
	[1][1][2][1][RTW89_MKK][8] = 127,
	[1][1][2][1][RTW89_IC][8] = 127,
	[1][1][2][1][RTW89_KCC][8] = 127,
	[1][1][2][1][RTW89_ACMA][8] = 127,
	[1][1][2][1][RTW89_CN][8] = 127,
	[1][1][2][1][RTW89_UK][8] = 127,
	[1][1][2][1][RTW89_FCC][9] = 127,
	[1][1][2][1][RTW89_ETSI][9] = 127,
	[1][1][2][1][RTW89_MKK][9] = 127,
	[1][1][2][1][RTW89_IC][9] = 127,
	[1][1][2][1][RTW89_KCC][9] = 127,
	[1][1][2][1][RTW89_ACMA][9] = 127,
	[1][1][2][1][RTW89_CN][9] = 127,
	[1][1][2][1][RTW89_UK][9] = 127,
	[1][1][2][1][RTW89_FCC][10] = 127,
	[1][1][2][1][RTW89_ETSI][10] = 127,
	[1][1][2][1][RTW89_MKK][10] = 127,
	[1][1][2][1][RTW89_IC][10] = 127,
	[1][1][2][1][RTW89_KCC][10] = 127,
	[1][1][2][1][RTW89_ACMA][10] = 127,
	[1][1][2][1][RTW89_CN][10] = 127,
	[1][1][2][1][RTW89_UK][10] = 127,
	[1][1][2][1][RTW89_FCC][11] = 127,
	[1][1][2][1][RTW89_ETSI][11] = 127,
	[1][1][2][1][RTW89_MKK][11] = 127,
	[1][1][2][1][RTW89_IC][11] = 127,
	[1][1][2][1][RTW89_KCC][11] = 127,
	[1][1][2][1][RTW89_ACMA][11] = 127,
	[1][1][2][1][RTW89_CN][11] = 127,
	[1][1][2][1][RTW89_UK][11] = 127,
	[1][1][2][1][RTW89_FCC][12] = 127,
	[1][1][2][1][RTW89_ETSI][12] = 127,
	[1][1][2][1][RTW89_MKK][12] = 127,
	[1][1][2][1][RTW89_IC][12] = 127,
	[1][1][2][1][RTW89_KCC][12] = 127,
	[1][1][2][1][RTW89_ACMA][12] = 127,
	[1][1][2][1][RTW89_CN][12] = 127,
	[1][1][2][1][RTW89_UK][12] = 127,
	[1][1][2][1][RTW89_FCC][13] = 127,
	[1][1][2][1][RTW89_ETSI][13] = 127,
	[1][1][2][1][RTW89_MKK][13] = 127,
	[1][1][2][1][RTW89_IC][13] = 127,
	[1][1][2][1][RTW89_KCC][13] = 127,
	[1][1][2][1][RTW89_ACMA][13] = 127,
	[1][1][2][1][RTW89_CN][13] = 127,
	[1][1][2][1][RTW89_UK][13] = 127,
};

static
const s8 rtw89_8851b_txpwr_lmt_5g[RTW89_5G_BW_NUM][RTW89_NTX_NUM]
				 [RTW89_RS_LMT_NUM][RTW89_BF_NUM]
				 [RTW89_REGD_NUM][RTW89_5G_CH_NUM] = {
	[0][0][1][0][RTW89_WW][0] = 58,
	[0][0][1][0][RTW89_WW][2] = 58,
	[0][0][1][0][RTW89_WW][4] = 58,
	[0][0][1][0][RTW89_WW][6] = 50,
	[0][0][1][0][RTW89_WW][8] = 58,
	[0][0][1][0][RTW89_WW][10] = 58,
	[0][0][1][0][RTW89_WW][12] = 58,
	[0][0][1][0][RTW89_WW][14] = 58,
	[0][0][1][0][RTW89_WW][15] = 58,
	[0][0][1][0][RTW89_WW][17] = 60,
	[0][0][1][0][RTW89_WW][19] = 60,
	[0][0][1][0][RTW89_WW][21] = 60,
	[0][0][1][0][RTW89_WW][23] = 60,
	[0][0][1][0][RTW89_WW][25] = 60,
	[0][0][1][0][RTW89_WW][27] = 60,
	[0][0][1][0][RTW89_WW][29] = 60,
	[0][0][1][0][RTW89_WW][31] = 60,
	[0][0][1][0][RTW89_WW][33] = 60,
	[0][0][1][0][RTW89_WW][35] = 60,
	[0][0][1][0][RTW89_WW][37] = 74,
	[0][0][1][0][RTW89_WW][38] = 30,
	[0][0][1][0][RTW89_WW][40] = 30,
	[0][0][1][0][RTW89_WW][42] = 30,
	[0][0][1][0][RTW89_WW][44] = 30,
	[0][0][1][0][RTW89_WW][46] = 30,
	[0][0][1][0][RTW89_WW][48] = 72,
	[0][0][1][0][RTW89_WW][50] = 72,
	[0][0][1][0][RTW89_WW][52] = 72,
	[0][1][1][0][RTW89_WW][0] = 0,
	[0][1][1][0][RTW89_WW][2] = 0,
	[0][1][1][0][RTW89_WW][4] = 0,
	[0][1][1][0][RTW89_WW][6] = 0,
	[0][1][1][0][RTW89_WW][8] = 0,
	[0][1][1][0][RTW89_WW][10] = 0,
	[0][1][1][0][RTW89_WW][12] = 0,
	[0][1][1][0][RTW89_WW][14] = 0,
	[0][1][1][0][RTW89_WW][15] = 0,
	[0][1][1][0][RTW89_WW][17] = 0,
	[0][1][1][0][RTW89_WW][19] = 0,
	[0][1][1][0][RTW89_WW][21] = 0,
	[0][1][1][0][RTW89_WW][23] = 0,
	[0][1][1][0][RTW89_WW][25] = 0,
	[0][1][1][0][RTW89_WW][27] = 0,
	[0][1][1][0][RTW89_WW][29] = 0,
	[0][1][1][0][RTW89_WW][31] = 0,
	[0][1][1][0][RTW89_WW][33] = 0,
	[0][1][1][0][RTW89_WW][35] = 0,
	[0][1][1][0][RTW89_WW][37] = 0,
	[0][1][1][0][RTW89_WW][38] = 0,
	[0][1][1][0][RTW89_WW][40] = 0,
	[0][1][1][0][RTW89_WW][42] = 0,
	[0][1][1][0][RTW89_WW][44] = 0,
	[0][1][1][0][RTW89_WW][46] = 0,
	[0][1][1][0][RTW89_WW][48] = 0,
	[0][1][1][0][RTW89_WW][50] = 0,
	[0][1][1][0][RTW89_WW][52] = 0,
	[0][0][2][0][RTW89_WW][0] = 60,
	[0][0][2][0][RTW89_WW][2] = 60,
	[0][0][2][0][RTW89_WW][4] = 60,
	[0][0][2][0][RTW89_WW][6] = 54,
	[0][0][2][0][RTW89_WW][8] = 60,
	[0][0][2][0][RTW89_WW][10] = 60,
	[0][0][2][0][RTW89_WW][12] = 60,
	[0][0][2][0][RTW89_WW][14] = 60,
	[0][0][2][0][RTW89_WW][15] = 60,
	[0][0][2][0][RTW89_WW][17] = 62,
	[0][0][2][0][RTW89_WW][19] = 62,
	[0][0][2][0][RTW89_WW][21] = 62,
	[0][0][2][0][RTW89_WW][23] = 62,
	[0][0][2][0][RTW89_WW][25] = 62,
	[0][0][2][0][RTW89_WW][27] = 62,
	[0][0][2][0][RTW89_WW][29] = 62,
	[0][0][2][0][RTW89_WW][31] = 62,
	[0][0][2][0][RTW89_WW][33] = 62,
	[0][0][2][0][RTW89_WW][35] = 62,
	[0][0][2][0][RTW89_WW][37] = 76,
	[0][0][2][0][RTW89_WW][38] = 30,
	[0][0][2][0][RTW89_WW][40] = 30,
	[0][0][2][0][RTW89_WW][42] = 30,
	[0][0][2][0][RTW89_WW][44] = 30,
	[0][0][2][0][RTW89_WW][46] = 30,
	[0][0][2][0][RTW89_WW][48] = 74,
	[0][0][2][0][RTW89_WW][50] = 76,
	[0][0][2][0][RTW89_WW][52] = 76,
	[0][1][2][0][RTW89_WW][0] = 0,
	[0][1][2][0][RTW89_WW][2] = 0,
	[0][1][2][0][RTW89_WW][4] = 0,
	[0][1][2][0][RTW89_WW][6] = 0,
	[0][1][2][0][RTW89_WW][8] = 0,
	[0][1][2][0][RTW89_WW][10] = 0,
	[0][1][2][0][RTW89_WW][12] = 0,
	[0][1][2][0][RTW89_WW][14] = 0,
	[0][1][2][0][RTW89_WW][15] = 0,
	[0][1][2][0][RTW89_WW][17] = 0,
	[0][1][2][0][RTW89_WW][19] = 0,
	[0][1][2][0][RTW89_WW][21] = 0,
	[0][1][2][0][RTW89_WW][23] = 0,
	[0][1][2][0][RTW89_WW][25] = 0,
	[0][1][2][0][RTW89_WW][27] = 0,
	[0][1][2][0][RTW89_WW][29] = 0,
	[0][1][2][0][RTW89_WW][31] = 0,
	[0][1][2][0][RTW89_WW][33] = 0,
	[0][1][2][0][RTW89_WW][35] = 0,
	[0][1][2][0][RTW89_WW][37] = 0,
	[0][1][2][0][RTW89_WW][38] = 0,
	[0][1][2][0][RTW89_WW][40] = 0,
	[0][1][2][0][RTW89_WW][42] = 0,
	[0][1][2][0][RTW89_WW][44] = 0,
	[0][1][2][0][RTW89_WW][46] = 0,
	[0][1][2][0][RTW89_WW][48] = 0,
	[0][1][2][0][RTW89_WW][50] = 0,
	[0][1][2][0][RTW89_WW][52] = 0,
	[0][1][2][1][RTW89_WW][0] = 0,
	[0][1][2][1][RTW89_WW][2] = 0,
	[0][1][2][1][RTW89_WW][4] = 0,
	[0][1][2][1][RTW89_WW][6] = 0,
	[0][1][2][1][RTW89_WW][8] = 0,
	[0][1][2][1][RTW89_WW][10] = 0,
	[0][1][2][1][RTW89_WW][12] = 0,
	[0][1][2][1][RTW89_WW][14] = 0,
	[0][1][2][1][RTW89_WW][15] = 0,
	[0][1][2][1][RTW89_WW][17] = 0,
	[0][1][2][1][RTW89_WW][19] = 0,
	[0][1][2][1][RTW89_WW][21] = 0,
	[0][1][2][1][RTW89_WW][23] = 0,
	[0][1][2][1][RTW89_WW][25] = 0,
	[0][1][2][1][RTW89_WW][27] = 0,
	[0][1][2][1][RTW89_WW][29] = 0,
	[0][1][2][1][RTW89_WW][31] = 0,
	[0][1][2][1][RTW89_WW][33] = 0,
	[0][1][2][1][RTW89_WW][35] = 0,
	[0][1][2][1][RTW89_WW][37] = 0,
	[0][1][2][1][RTW89_WW][38] = 0,
	[0][1][2][1][RTW89_WW][40] = 0,
	[0][1][2][1][RTW89_WW][42] = 0,
	[0][1][2][1][RTW89_WW][44] = 0,
	[0][1][2][1][RTW89_WW][46] = 0,
	[0][1][2][1][RTW89_WW][48] = 0,
	[0][1][2][1][RTW89_WW][50] = 0,
	[0][1][2][1][RTW89_WW][52] = 0,
	[1][0][2][0][RTW89_WW][1] = 62,
	[1][0][2][0][RTW89_WW][5] = 62,
	[1][0][2][0][RTW89_WW][9] = 62,
	[1][0][2][0][RTW89_WW][13] = 62,
	[1][0][2][0][RTW89_WW][16] = 66,
	[1][0][2][0][RTW89_WW][20] = 66,
	[1][0][2][0][RTW89_WW][24] = 66,
	[1][0][2][0][RTW89_WW][28] = 66,
	[1][0][2][0][RTW89_WW][32] = 66,
	[1][0][2][0][RTW89_WW][36] = 76,
	[1][0][2][0][RTW89_WW][39] = 30,
	[1][0][2][0][RTW89_WW][43] = 30,
	[1][0][2][0][RTW89_WW][47] = 84,
	[1][0][2][0][RTW89_WW][51] = 84,
	[1][1][2][0][RTW89_WW][1] = 0,
	[1][1][2][0][RTW89_WW][5] = 0,
	[1][1][2][0][RTW89_WW][9] = 0,
	[1][1][2][0][RTW89_WW][13] = 0,
	[1][1][2][0][RTW89_WW][16] = 0,
	[1][1][2][0][RTW89_WW][20] = 0,
	[1][1][2][0][RTW89_WW][24] = 0,
	[1][1][2][0][RTW89_WW][28] = 0,
	[1][1][2][0][RTW89_WW][32] = 0,
	[1][1][2][0][RTW89_WW][36] = 0,
	[1][1][2][0][RTW89_WW][39] = 0,
	[1][1][2][0][RTW89_WW][43] = 0,
	[1][1][2][0][RTW89_WW][47] = 0,
	[1][1][2][0][RTW89_WW][51] = 0,
	[1][1][2][1][RTW89_WW][1] = 0,
	[1][1][2][1][RTW89_WW][5] = 0,
	[1][1][2][1][RTW89_WW][9] = 0,
	[1][1][2][1][RTW89_WW][13] = 0,
	[1][1][2][1][RTW89_WW][16] = 0,
	[1][1][2][1][RTW89_WW][20] = 0,
	[1][1][2][1][RTW89_WW][24] = 0,
	[1][1][2][1][RTW89_WW][28] = 0,
	[1][1][2][1][RTW89_WW][32] = 0,
	[1][1][2][1][RTW89_WW][36] = 0,
	[1][1][2][1][RTW89_WW][39] = 0,
	[1][1][2][1][RTW89_WW][43] = 0,
	[1][1][2][1][RTW89_WW][47] = 0,
	[1][1][2][1][RTW89_WW][51] = 0,
	[2][0][2][0][RTW89_WW][3] = 60,
	[2][0][2][0][RTW89_WW][11] = 56,
	[2][0][2][0][RTW89_WW][18] = 64,
	[2][0][2][0][RTW89_WW][26] = 64,
	[2][0][2][0][RTW89_WW][34] = 72,
	[2][0][2][0][RTW89_WW][41] = 30,
	[2][0][2][0][RTW89_WW][49] = 74,
	[2][1][2][0][RTW89_WW][3] = 0,
	[2][1][2][0][RTW89_WW][11] = 0,
	[2][1][2][0][RTW89_WW][18] = 0,
	[2][1][2][0][RTW89_WW][26] = 0,
	[2][1][2][0][RTW89_WW][34] = 0,
	[2][1][2][0][RTW89_WW][41] = 0,
	[2][1][2][0][RTW89_WW][49] = 0,
	[2][1][2][1][RTW89_WW][3] = 0,
	[2][1][2][1][RTW89_WW][11] = 0,
	[2][1][2][1][RTW89_WW][18] = 0,
	[2][1][2][1][RTW89_WW][26] = 0,
	[2][1][2][1][RTW89_WW][34] = 0,
	[2][1][2][1][RTW89_WW][41] = 0,
	[2][1][2][1][RTW89_WW][49] = 0,
	[3][0][2][0][RTW89_WW][7] = 0,
	[3][0][2][0][RTW89_WW][22] = 0,
	[3][0][2][0][RTW89_WW][45] = 0,
	[3][1][2][0][RTW89_WW][7] = 0,
	[3][1][2][0][RTW89_WW][22] = 0,
	[3][1][2][0][RTW89_WW][45] = 0,
	[3][1][2][1][RTW89_WW][7] = 0,
	[3][1][2][1][RTW89_WW][22] = 0,
	[3][1][2][1][RTW89_WW][45] = 0,
	[0][0][1][0][RTW89_FCC][0] = 80,
	[0][0][1][0][RTW89_ETSI][0] = 58,
	[0][0][1][0][RTW89_MKK][0] = 60,
	[0][0][1][0][RTW89_IC][0] = 62,
	[0][0][1][0][RTW89_KCC][0] = 74,
	[0][0][1][0][RTW89_ACMA][0] = 58,
	[0][0][1][0][RTW89_CN][0] = 60,
	[0][0][1][0][RTW89_UK][0] = 58,
	[0][0][1][0][RTW89_FCC][2] = 82,
	[0][0][1][0][RTW89_ETSI][2] = 58,
	[0][0][1][0][RTW89_MKK][2] = 60,
	[0][0][1][0][RTW89_IC][2] = 62,
	[0][0][1][0][RTW89_KCC][2] = 74,
	[0][0][1][0][RTW89_ACMA][2] = 58,
	[0][0][1][0][RTW89_CN][2] = 60,
	[0][0][1][0][RTW89_UK][2] = 58,
	[0][0][1][0][RTW89_FCC][4] = 82,
	[0][0][1][0][RTW89_ETSI][4] = 58,
	[0][0][1][0][RTW89_MKK][4] = 60,
	[0][0][1][0][RTW89_IC][4] = 62,
	[0][0][1][0][RTW89_KCC][4] = 74,
	[0][0][1][0][RTW89_ACMA][4] = 58,
	[0][0][1][0][RTW89_CN][4] = 60,
	[0][0][1][0][RTW89_UK][4] = 58,
	[0][0][1][0][RTW89_FCC][6] = 82,
	[0][0][1][0][RTW89_ETSI][6] = 58,
	[0][0][1][0][RTW89_MKK][6] = 60,
	[0][0][1][0][RTW89_IC][6] = 62,
	[0][0][1][0][RTW89_KCC][6] = 50,
	[0][0][1][0][RTW89_ACMA][6] = 58,
	[0][0][1][0][RTW89_CN][6] = 60,
	[0][0][1][0][RTW89_UK][6] = 58,
	[0][0][1][0][RTW89_FCC][8] = 82,
	[0][0][1][0][RTW89_ETSI][8] = 58,
	[0][0][1][0][RTW89_MKK][8] = 60,
	[0][0][1][0][RTW89_IC][8] = 64,
	[0][0][1][0][RTW89_KCC][8] = 74,
	[0][0][1][0][RTW89_ACMA][8] = 58,
	[0][0][1][0][RTW89_CN][8] = 60,
	[0][0][1][0][RTW89_UK][8] = 58,
	[0][0][1][0][RTW89_FCC][10] = 82,
	[0][0][1][0][RTW89_ETSI][10] = 58,
	[0][0][1][0][RTW89_MKK][10] = 60,
	[0][0][1][0][RTW89_IC][10] = 64,
	[0][0][1][0][RTW89_KCC][10] = 74,
	[0][0][1][0][RTW89_ACMA][10] = 58,
	[0][0][1][0][RTW89_CN][10] = 60,
	[0][0][1][0][RTW89_UK][10] = 58,
	[0][0][1][0][RTW89_FCC][12] = 82,
	[0][0][1][0][RTW89_ETSI][12] = 58,
	[0][0][1][0][RTW89_MKK][12] = 60,
	[0][0][1][0][RTW89_IC][12] = 64,
	[0][0][1][0][RTW89_KCC][12] = 76,
	[0][0][1][0][RTW89_ACMA][12] = 58,
	[0][0][1][0][RTW89_CN][12] = 60,
	[0][0][1][0][RTW89_UK][12] = 58,
	[0][0][1][0][RTW89_FCC][14] = 78,
	[0][0][1][0][RTW89_ETSI][14] = 58,
	[0][0][1][0][RTW89_MKK][14] = 60,
	[0][0][1][0][RTW89_IC][14] = 64,
	[0][0][1][0][RTW89_KCC][14] = 76,
	[0][0][1][0][RTW89_ACMA][14] = 58,
	[0][0][1][0][RTW89_CN][14] = 60,
	[0][0][1][0][RTW89_UK][14] = 58,
	[0][0][1][0][RTW89_FCC][15] = 78,
	[0][0][1][0][RTW89_ETSI][15] = 58,
	[0][0][1][0][RTW89_MKK][15] = 78,
	[0][0][1][0][RTW89_IC][15] = 78,
	[0][0][1][0][RTW89_KCC][15] = 78,
	[0][0][1][0][RTW89_ACMA][15] = 58,
	[0][0][1][0][RTW89_CN][15] = 127,
	[0][0][1][0][RTW89_UK][15] = 58,
	[0][0][1][0][RTW89_FCC][17] = 82,
	[0][0][1][0][RTW89_ETSI][17] = 60,
	[0][0][1][0][RTW89_MKK][17] = 78,
	[0][0][1][0][RTW89_IC][17] = 82,
	[0][0][1][0][RTW89_KCC][17] = 78,
	[0][0][1][0][RTW89_ACMA][17] = 60,
	[0][0][1][0][RTW89_CN][17] = 127,
	[0][0][1][0][RTW89_UK][17] = 60,
	[0][0][1][0][RTW89_FCC][19] = 82,
	[0][0][1][0][RTW89_ETSI][19] = 60,
	[0][0][1][0][RTW89_MKK][19] = 78,
	[0][0][1][0][RTW89_IC][19] = 82,
	[0][0][1][0][RTW89_KCC][19] = 78,
	[0][0][1][0][RTW89_ACMA][19] = 60,
	[0][0][1][0][RTW89_CN][19] = 127,
	[0][0][1][0][RTW89_UK][19] = 60,
	[0][0][1][0][RTW89_FCC][21] = 82,
	[0][0][1][0][RTW89_ETSI][21] = 60,
	[0][0][1][0][RTW89_MKK][21] = 78,
	[0][0][1][0][RTW89_IC][21] = 82,
	[0][0][1][0][RTW89_KCC][21] = 78,
	[0][0][1][0][RTW89_ACMA][21] = 60,
	[0][0][1][0][RTW89_CN][21] = 127,
	[0][0][1][0][RTW89_UK][21] = 60,
	[0][0][1][0][RTW89_FCC][23] = 82,
	[0][0][1][0][RTW89_ETSI][23] = 60,
	[0][0][1][0][RTW89_MKK][23] = 78,
	[0][0][1][0][RTW89_IC][23] = 82,
	[0][0][1][0][RTW89_KCC][23] = 78,
	[0][0][1][0][RTW89_ACMA][23] = 60,
	[0][0][1][0][RTW89_CN][23] = 127,
	[0][0][1][0][RTW89_UK][23] = 60,
	[0][0][1][0][RTW89_FCC][25] = 82,
	[0][0][1][0][RTW89_ETSI][25] = 60,
	[0][0][1][0][RTW89_MKK][25] = 78,
	[0][0][1][0][RTW89_IC][25] = 127,
	[0][0][1][0][RTW89_KCC][25] = 78,
	[0][0][1][0][RTW89_ACMA][25] = 127,
	[0][0][1][0][RTW89_CN][25] = 127,
	[0][0][1][0][RTW89_UK][25] = 60,
	[0][0][1][0][RTW89_FCC][27] = 82,
	[0][0][1][0][RTW89_ETSI][27] = 60,
	[0][0][1][0][RTW89_MKK][27] = 78,
	[0][0][1][0][RTW89_IC][27] = 127,
	[0][0][1][0][RTW89_KCC][27] = 78,
	[0][0][1][0][RTW89_ACMA][27] = 127,
	[0][0][1][0][RTW89_CN][27] = 127,
	[0][0][1][0][RTW89_UK][27] = 60,
	[0][0][1][0][RTW89_FCC][29] = 82,
	[0][0][1][0][RTW89_ETSI][29] = 60,
	[0][0][1][0][RTW89_MKK][29] = 78,
	[0][0][1][0][RTW89_IC][29] = 127,
	[0][0][1][0][RTW89_KCC][29] = 78,
	[0][0][1][0][RTW89_ACMA][29] = 127,
	[0][0][1][0][RTW89_CN][29] = 127,
	[0][0][1][0][RTW89_UK][29] = 60,
	[0][0][1][0][RTW89_FCC][31] = 82,
	[0][0][1][0][RTW89_ETSI][31] = 60,
	[0][0][1][0][RTW89_MKK][31] = 78,
	[0][0][1][0][RTW89_IC][31] = 82,
	[0][0][1][0][RTW89_KCC][31] = 74,
	[0][0][1][0][RTW89_ACMA][31] = 60,
	[0][0][1][0][RTW89_CN][31] = 127,
	[0][0][1][0][RTW89_UK][31] = 60,
	[0][0][1][0][RTW89_FCC][33] = 82,
	[0][0][1][0][RTW89_ETSI][33] = 60,
	[0][0][1][0][RTW89_MKK][33] = 78,
	[0][0][1][0][RTW89_IC][33] = 82,
	[0][0][1][0][RTW89_KCC][33] = 74,
	[0][0][1][0][RTW89_ACMA][33] = 60,
	[0][0][1][0][RTW89_CN][33] = 127,
	[0][0][1][0][RTW89_UK][33] = 60,
	[0][0][1][0][RTW89_FCC][35] = 72,
	[0][0][1][0][RTW89_ETSI][35] = 60,
	[0][0][1][0][RTW89_MKK][35] = 78,
	[0][0][1][0][RTW89_IC][35] = 72,
	[0][0][1][0][RTW89_KCC][35] = 74,
	[0][0][1][0][RTW89_ACMA][35] = 60,
	[0][0][1][0][RTW89_CN][35] = 127,
	[0][0][1][0][RTW89_UK][35] = 60,
	[0][0][1][0][RTW89_FCC][37] = 82,
	[0][0][1][0][RTW89_ETSI][37] = 127,
	[0][0][1][0][RTW89_MKK][37] = 78,
	[0][0][1][0][RTW89_IC][37] = 82,
	[0][0][1][0][RTW89_KCC][37] = 74,
	[0][0][1][0][RTW89_ACMA][37] = 78,
	[0][0][1][0][RTW89_CN][37] = 127,
	[0][0][1][0][RTW89_UK][37] = 78,
	[0][0][1][0][RTW89_FCC][38] = 82,
	[0][0][1][0][RTW89_ETSI][38] = 30,
	[0][0][1][0][RTW89_MKK][38] = 127,
	[0][0][1][0][RTW89_IC][38] = 82,
	[0][0][1][0][RTW89_KCC][38] = 70,
	[0][0][1][0][RTW89_ACMA][38] = 78,
	[0][0][1][0][RTW89_CN][38] = 74,
	[0][0][1][0][RTW89_UK][38] = 58,
	[0][0][1][0][RTW89_FCC][40] = 82,
	[0][0][1][0][RTW89_ETSI][40] = 30,
	[0][0][1][0][RTW89_MKK][40] = 127,
	[0][0][1][0][RTW89_IC][40] = 82,
	[0][0][1][0][RTW89_KCC][40] = 76,
	[0][0][1][0][RTW89_ACMA][40] = 78,
	[0][0][1][0][RTW89_CN][40] = 74,
	[0][0][1][0][RTW89_UK][40] = 58,
	[0][0][1][0][RTW89_FCC][42] = 82,
	[0][0][1][0][RTW89_ETSI][42] = 30,
	[0][0][1][0][RTW89_MKK][42] = 127,
	[0][0][1][0][RTW89_IC][42] = 82,
	[0][0][1][0][RTW89_KCC][42] = 76,
	[0][0][1][0][RTW89_ACMA][42] = 78,
	[0][0][1][0][RTW89_CN][42] = 74,
	[0][0][1][0][RTW89_UK][42] = 58,
	[0][0][1][0][RTW89_FCC][44] = 82,
	[0][0][1][0][RTW89_ETSI][44] = 30,
	[0][0][1][0][RTW89_MKK][44] = 127,
	[0][0][1][0][RTW89_IC][44] = 82,
	[0][0][1][0][RTW89_KCC][44] = 76,
	[0][0][1][0][RTW89_ACMA][44] = 78,
	[0][0][1][0][RTW89_CN][44] = 58,
	[0][0][1][0][RTW89_UK][44] = 58,
	[0][0][1][0][RTW89_FCC][46] = 82,
	[0][0][1][0][RTW89_ETSI][46] = 30,
	[0][0][1][0][RTW89_MKK][46] = 127,
	[0][0][1][0][RTW89_IC][46] = 82,
	[0][0][1][0][RTW89_KCC][46] = 76,
	[0][0][1][0][RTW89_ACMA][46] = 78,
	[0][0][1][0][RTW89_CN][46] = 58,
	[0][0][1][0][RTW89_UK][46] = 58,
	[0][0][1][0][RTW89_FCC][48] = 72,
	[0][0][1][0][RTW89_ETSI][48] = 127,
	[0][0][1][0][RTW89_MKK][48] = 127,
	[0][0][1][0][RTW89_IC][48] = 127,
	[0][0][1][0][RTW89_KCC][48] = 127,
	[0][0][1][0][RTW89_ACMA][48] = 127,
	[0][0][1][0][RTW89_CN][48] = 127,
	[0][0][1][0][RTW89_UK][48] = 127,
	[0][0][1][0][RTW89_FCC][50] = 72,
	[0][0][1][0][RTW89_ETSI][50] = 127,
	[0][0][1][0][RTW89_MKK][50] = 127,
	[0][0][1][0][RTW89_IC][50] = 127,
	[0][0][1][0][RTW89_KCC][50] = 127,
	[0][0][1][0][RTW89_ACMA][50] = 127,
	[0][0][1][0][RTW89_CN][50] = 127,
	[0][0][1][0][RTW89_UK][50] = 127,
	[0][0][1][0][RTW89_FCC][52] = 72,
	[0][0][1][0][RTW89_ETSI][52] = 127,
	[0][0][1][0][RTW89_MKK][52] = 127,
	[0][0][1][0][RTW89_IC][52] = 127,
	[0][0][1][0][RTW89_KCC][52] = 127,
	[0][0][1][0][RTW89_ACMA][52] = 127,
	[0][0][1][0][RTW89_CN][52] = 127,
	[0][0][1][0][RTW89_UK][52] = 127,
	[0][1][1][0][RTW89_FCC][0] = 127,
	[0][1][1][0][RTW89_ETSI][0] = 127,
	[0][1][1][0][RTW89_MKK][0] = 127,
	[0][1][1][0][RTW89_IC][0] = 127,
	[0][1][1][0][RTW89_KCC][0] = 127,
	[0][1][1][0][RTW89_ACMA][0] = 127,
	[0][1][1][0][RTW89_CN][0] = 127,
	[0][1][1][0][RTW89_UK][0] = 127,
	[0][1][1][0][RTW89_FCC][2] = 127,
	[0][1][1][0][RTW89_ETSI][2] = 127,
	[0][1][1][0][RTW89_MKK][2] = 127,
	[0][1][1][0][RTW89_IC][2] = 127,
	[0][1][1][0][RTW89_KCC][2] = 127,
	[0][1][1][0][RTW89_ACMA][2] = 127,
	[0][1][1][0][RTW89_CN][2] = 127,
	[0][1][1][0][RTW89_UK][2] = 127,
	[0][1][1][0][RTW89_FCC][4] = 127,
	[0][1][1][0][RTW89_ETSI][4] = 127,
	[0][1][1][0][RTW89_MKK][4] = 127,
	[0][1][1][0][RTW89_IC][4] = 127,
	[0][1][1][0][RTW89_KCC][4] = 127,
	[0][1][1][0][RTW89_ACMA][4] = 127,
	[0][1][1][0][RTW89_CN][4] = 127,
	[0][1][1][0][RTW89_UK][4] = 127,
	[0][1][1][0][RTW89_FCC][6] = 127,
	[0][1][1][0][RTW89_ETSI][6] = 127,
	[0][1][1][0][RTW89_MKK][6] = 127,
	[0][1][1][0][RTW89_IC][6] = 127,
	[0][1][1][0][RTW89_KCC][6] = 127,
	[0][1][1][0][RTW89_ACMA][6] = 127,
	[0][1][1][0][RTW89_CN][6] = 127,
	[0][1][1][0][RTW89_UK][6] = 127,
	[0][1][1][0][RTW89_FCC][8] = 127,
	[0][1][1][0][RTW89_ETSI][8] = 127,
	[0][1][1][0][RTW89_MKK][8] = 127,
	[0][1][1][0][RTW89_IC][8] = 127,
	[0][1][1][0][RTW89_KCC][8] = 127,
	[0][1][1][0][RTW89_ACMA][8] = 127,
	[0][1][1][0][RTW89_CN][8] = 127,
	[0][1][1][0][RTW89_UK][8] = 127,
	[0][1][1][0][RTW89_FCC][10] = 127,
	[0][1][1][0][RTW89_ETSI][10] = 127,
	[0][1][1][0][RTW89_MKK][10] = 127,
	[0][1][1][0][RTW89_IC][10] = 127,
	[0][1][1][0][RTW89_KCC][10] = 127,
	[0][1][1][0][RTW89_ACMA][10] = 127,
	[0][1][1][0][RTW89_CN][10] = 127,
	[0][1][1][0][RTW89_UK][10] = 127,
	[0][1][1][0][RTW89_FCC][12] = 127,
	[0][1][1][0][RTW89_ETSI][12] = 127,
	[0][1][1][0][RTW89_MKK][12] = 127,
	[0][1][1][0][RTW89_IC][12] = 127,
	[0][1][1][0][RTW89_KCC][12] = 127,
	[0][1][1][0][RTW89_ACMA][12] = 127,
	[0][1][1][0][RTW89_CN][12] = 127,
	[0][1][1][0][RTW89_UK][12] = 127,
	[0][1][1][0][RTW89_FCC][14] = 127,
	[0][1][1][0][RTW89_ETSI][14] = 127,
	[0][1][1][0][RTW89_MKK][14] = 127,
	[0][1][1][0][RTW89_IC][14] = 127,
	[0][1][1][0][RTW89_KCC][14] = 127,
	[0][1][1][0][RTW89_ACMA][14] = 127,
	[0][1][1][0][RTW89_CN][14] = 127,
	[0][1][1][0][RTW89_UK][14] = 127,
	[0][1][1][0][RTW89_FCC][15] = 127,
	[0][1][1][0][RTW89_ETSI][15] = 127,
	[0][1][1][0][RTW89_MKK][15] = 127,
	[0][1][1][0][RTW89_IC][15] = 127,
	[0][1][1][0][RTW89_KCC][15] = 127,
	[0][1][1][0][RTW89_ACMA][15] = 127,
	[0][1][1][0][RTW89_CN][15] = 127,
	[0][1][1][0][RTW89_UK][15] = 127,
	[0][1][1][0][RTW89_FCC][17] = 127,
	[0][1][1][0][RTW89_ETSI][17] = 127,
	[0][1][1][0][RTW89_MKK][17] = 127,
	[0][1][1][0][RTW89_IC][17] = 127,
	[0][1][1][0][RTW89_KCC][17] = 127,
	[0][1][1][0][RTW89_ACMA][17] = 127,
	[0][1][1][0][RTW89_CN][17] = 127,
	[0][1][1][0][RTW89_UK][17] = 127,
	[0][1][1][0][RTW89_FCC][19] = 127,
	[0][1][1][0][RTW89_ETSI][19] = 127,
	[0][1][1][0][RTW89_MKK][19] = 127,
	[0][1][1][0][RTW89_IC][19] = 127,
	[0][1][1][0][RTW89_KCC][19] = 127,
	[0][1][1][0][RTW89_ACMA][19] = 127,
	[0][1][1][0][RTW89_CN][19] = 127,
	[0][1][1][0][RTW89_UK][19] = 127,
	[0][1][1][0][RTW89_FCC][21] = 127,
	[0][1][1][0][RTW89_ETSI][21] = 127,
	[0][1][1][0][RTW89_MKK][21] = 127,
	[0][1][1][0][RTW89_IC][21] = 127,
	[0][1][1][0][RTW89_KCC][21] = 127,
	[0][1][1][0][RTW89_ACMA][21] = 127,
	[0][1][1][0][RTW89_CN][21] = 127,
	[0][1][1][0][RTW89_UK][21] = 127,
	[0][1][1][0][RTW89_FCC][23] = 127,
	[0][1][1][0][RTW89_ETSI][23] = 127,
	[0][1][1][0][RTW89_MKK][23] = 127,
	[0][1][1][0][RTW89_IC][23] = 127,
	[0][1][1][0][RTW89_KCC][23] = 127,
	[0][1][1][0][RTW89_ACMA][23] = 127,
	[0][1][1][0][RTW89_CN][23] = 127,
	[0][1][1][0][RTW89_UK][23] = 127,
	[0][1][1][0][RTW89_FCC][25] = 127,
	[0][1][1][0][RTW89_ETSI][25] = 127,
	[0][1][1][0][RTW89_MKK][25] = 127,
	[0][1][1][0][RTW89_IC][25] = 127,
	[0][1][1][0][RTW89_KCC][25] = 127,
	[0][1][1][0][RTW89_ACMA][25] = 127,
	[0][1][1][0][RTW89_CN][25] = 127,
	[0][1][1][0][RTW89_UK][25] = 127,
	[0][1][1][0][RTW89_FCC][27] = 127,
	[0][1][1][0][RTW89_ETSI][27] = 127,
	[0][1][1][0][RTW89_MKK][27] = 127,
	[0][1][1][0][RTW89_IC][27] = 127,
	[0][1][1][0][RTW89_KCC][27] = 127,
	[0][1][1][0][RTW89_ACMA][27] = 127,
	[0][1][1][0][RTW89_CN][27] = 127,
	[0][1][1][0][RTW89_UK][27] = 127,
	[0][1][1][0][RTW89_FCC][29] = 127,
	[0][1][1][0][RTW89_ETSI][29] = 127,
	[0][1][1][0][RTW89_MKK][29] = 127,
	[0][1][1][0][RTW89_IC][29] = 127,
	[0][1][1][0][RTW89_KCC][29] = 127,
	[0][1][1][0][RTW89_ACMA][29] = 127,
	[0][1][1][0][RTW89_CN][29] = 127,
	[0][1][1][0][RTW89_UK][29] = 127,
	[0][1][1][0][RTW89_FCC][31] = 127,
	[0][1][1][0][RTW89_ETSI][31] = 127,
	[0][1][1][0][RTW89_MKK][31] = 127,
	[0][1][1][0][RTW89_IC][31] = 127,
	[0][1][1][0][RTW89_KCC][31] = 127,
	[0][1][1][0][RTW89_ACMA][31] = 127,
	[0][1][1][0][RTW89_CN][31] = 127,
	[0][1][1][0][RTW89_UK][31] = 127,
	[0][1][1][0][RTW89_FCC][33] = 127,
	[0][1][1][0][RTW89_ETSI][33] = 127,
	[0][1][1][0][RTW89_MKK][33] = 127,
	[0][1][1][0][RTW89_IC][33] = 127,
	[0][1][1][0][RTW89_KCC][33] = 127,
	[0][1][1][0][RTW89_ACMA][33] = 127,
	[0][1][1][0][RTW89_CN][33] = 127,
	[0][1][1][0][RTW89_UK][33] = 127,
	[0][1][1][0][RTW89_FCC][35] = 127,
	[0][1][1][0][RTW89_ETSI][35] = 127,
	[0][1][1][0][RTW89_MKK][35] = 127,
	[0][1][1][0][RTW89_IC][35] = 127,
	[0][1][1][0][RTW89_KCC][35] = 127,
	[0][1][1][0][RTW89_ACMA][35] = 127,
	[0][1][1][0][RTW89_CN][35] = 127,
	[0][1][1][0][RTW89_UK][35] = 127,
	[0][1][1][0][RTW89_FCC][37] = 127,
	[0][1][1][0][RTW89_ETSI][37] = 127,
	[0][1][1][0][RTW89_MKK][37] = 127,
	[0][1][1][0][RTW89_IC][37] = 127,
	[0][1][1][0][RTW89_KCC][37] = 127,
	[0][1][1][0][RTW89_ACMA][37] = 127,
	[0][1][1][0][RTW89_CN][37] = 127,
	[0][1][1][0][RTW89_UK][37] = 127,
	[0][1][1][0][RTW89_FCC][38] = 127,
	[0][1][1][0][RTW89_ETSI][38] = 127,
	[0][1][1][0][RTW89_MKK][38] = 127,
	[0][1][1][0][RTW89_IC][38] = 127,
	[0][1][1][0][RTW89_KCC][38] = 127,
	[0][1][1][0][RTW89_ACMA][38] = 127,
	[0][1][1][0][RTW89_CN][38] = 127,
	[0][1][1][0][RTW89_UK][38] = 127,
	[0][1][1][0][RTW89_FCC][40] = 127,
	[0][1][1][0][RTW89_ETSI][40] = 127,
	[0][1][1][0][RTW89_MKK][40] = 127,
	[0][1][1][0][RTW89_IC][40] = 127,
	[0][1][1][0][RTW89_KCC][40] = 127,
	[0][1][1][0][RTW89_ACMA][40] = 127,
	[0][1][1][0][RTW89_CN][40] = 127,
	[0][1][1][0][RTW89_UK][40] = 127,
	[0][1][1][0][RTW89_FCC][42] = 127,
	[0][1][1][0][RTW89_ETSI][42] = 127,
	[0][1][1][0][RTW89_MKK][42] = 127,
	[0][1][1][0][RTW89_IC][42] = 127,
	[0][1][1][0][RTW89_KCC][42] = 127,
	[0][1][1][0][RTW89_ACMA][42] = 127,
	[0][1][1][0][RTW89_CN][42] = 127,
	[0][1][1][0][RTW89_UK][42] = 127,
	[0][1][1][0][RTW89_FCC][44] = 127,
	[0][1][1][0][RTW89_ETSI][44] = 127,
	[0][1][1][0][RTW89_MKK][44] = 127,
	[0][1][1][0][RTW89_IC][44] = 127,
	[0][1][1][0][RTW89_KCC][44] = 127,
	[0][1][1][0][RTW89_ACMA][44] = 127,
	[0][1][1][0][RTW89_CN][44] = 127,
	[0][1][1][0][RTW89_UK][44] = 127,
	[0][1][1][0][RTW89_FCC][46] = 127,
	[0][1][1][0][RTW89_ETSI][46] = 127,
	[0][1][1][0][RTW89_MKK][46] = 127,
	[0][1][1][0][RTW89_IC][46] = 127,
	[0][1][1][0][RTW89_KCC][46] = 127,
	[0][1][1][0][RTW89_ACMA][46] = 127,
	[0][1][1][0][RTW89_CN][46] = 127,
	[0][1][1][0][RTW89_UK][46] = 127,
	[0][1][1][0][RTW89_FCC][48] = 127,
	[0][1][1][0][RTW89_ETSI][48] = 127,
	[0][1][1][0][RTW89_MKK][48] = 127,
	[0][1][1][0][RTW89_IC][48] = 127,
	[0][1][1][0][RTW89_KCC][48] = 127,
	[0][1][1][0][RTW89_ACMA][48] = 127,
	[0][1][1][0][RTW89_CN][48] = 127,
	[0][1][1][0][RTW89_UK][48] = 127,
	[0][1][1][0][RTW89_FCC][50] = 127,
	[0][1][1][0][RTW89_ETSI][50] = 127,
	[0][1][1][0][RTW89_MKK][50] = 127,
	[0][1][1][0][RTW89_IC][50] = 127,
	[0][1][1][0][RTW89_KCC][50] = 127,
	[0][1][1][0][RTW89_ACMA][50] = 127,
	[0][1][1][0][RTW89_CN][50] = 127,
	[0][1][1][0][RTW89_UK][50] = 127,
	[0][1][1][0][RTW89_FCC][52] = 127,
	[0][1][1][0][RTW89_ETSI][52] = 127,
	[0][1][1][0][RTW89_MKK][52] = 127,
	[0][1][1][0][RTW89_IC][52] = 127,
	[0][1][1][0][RTW89_KCC][52] = 127,
	[0][1][1][0][RTW89_ACMA][52] = 127,
	[0][1][1][0][RTW89_CN][52] = 127,
	[0][1][1][0][RTW89_UK][52] = 127,
	[0][0][2][0][RTW89_FCC][0] = 78,
	[0][0][2][0][RTW89_ETSI][0] = 62,
	[0][0][2][0][RTW89_MKK][0] = 62,
	[0][0][2][0][RTW89_IC][0] = 64,
	[0][0][2][0][RTW89_KCC][0] = 76,
	[0][0][2][0][RTW89_ACMA][0] = 62,
	[0][0][2][0][RTW89_CN][0] = 60,
	[0][0][2][0][RTW89_UK][0] = 62,
	[0][0][2][0][RTW89_FCC][2] = 82,
	[0][0][2][0][RTW89_ETSI][2] = 62,
	[0][0][2][0][RTW89_MKK][2] = 62,
	[0][0][2][0][RTW89_IC][2] = 64,
	[0][0][2][0][RTW89_KCC][2] = 76,
	[0][0][2][0][RTW89_ACMA][2] = 62,
	[0][0][2][0][RTW89_CN][2] = 60,
	[0][0][2][0][RTW89_UK][2] = 62,
	[0][0][2][0][RTW89_FCC][4] = 82,
	[0][0][2][0][RTW89_ETSI][4] = 62,
	[0][0][2][0][RTW89_MKK][4] = 62,
	[0][0][2][0][RTW89_IC][4] = 64,
	[0][0][2][0][RTW89_KCC][4] = 76,
	[0][0][2][0][RTW89_ACMA][4] = 62,
	[0][0][2][0][RTW89_CN][4] = 60,
	[0][0][2][0][RTW89_UK][4] = 62,
	[0][0][2][0][RTW89_FCC][6] = 82,
	[0][0][2][0][RTW89_ETSI][6] = 62,
	[0][0][2][0][RTW89_MKK][6] = 62,
	[0][0][2][0][RTW89_IC][6] = 64,
	[0][0][2][0][RTW89_KCC][6] = 54,
	[0][0][2][0][RTW89_ACMA][6] = 62,
	[0][0][2][0][RTW89_CN][6] = 60,
	[0][0][2][0][RTW89_UK][6] = 62,
	[0][0][2][0][RTW89_FCC][8] = 82,
	[0][0][2][0][RTW89_ETSI][8] = 62,
	[0][0][2][0][RTW89_MKK][8] = 62,
	[0][0][2][0][RTW89_IC][8] = 64,
	[0][0][2][0][RTW89_KCC][8] = 76,
	[0][0][2][0][RTW89_ACMA][8] = 62,
	[0][0][2][0][RTW89_CN][8] = 60,
	[0][0][2][0][RTW89_UK][8] = 62,
	[0][0][2][0][RTW89_FCC][10] = 82,
	[0][0][2][0][RTW89_ETSI][10] = 62,
	[0][0][2][0][RTW89_MKK][10] = 62,
	[0][0][2][0][RTW89_IC][10] = 64,
	[0][0][2][0][RTW89_KCC][10] = 76,
	[0][0][2][0][RTW89_ACMA][10] = 62,
	[0][0][2][0][RTW89_CN][10] = 60,
	[0][0][2][0][RTW89_UK][10] = 62,
	[0][0][2][0][RTW89_FCC][12] = 82,
	[0][0][2][0][RTW89_ETSI][12] = 62,
	[0][0][2][0][RTW89_MKK][12] = 62,
	[0][0][2][0][RTW89_IC][12] = 64,
	[0][0][2][0][RTW89_KCC][12] = 78,
	[0][0][2][0][RTW89_ACMA][12] = 62,
	[0][0][2][0][RTW89_CN][12] = 60,
	[0][0][2][0][RTW89_UK][12] = 62,
	[0][0][2][0][RTW89_FCC][14] = 76,
	[0][0][2][0][RTW89_ETSI][14] = 62,
	[0][0][2][0][RTW89_MKK][14] = 62,
	[0][0][2][0][RTW89_IC][14] = 64,
	[0][0][2][0][RTW89_KCC][14] = 78,
	[0][0][2][0][RTW89_ACMA][14] = 62,
	[0][0][2][0][RTW89_CN][14] = 60,
	[0][0][2][0][RTW89_UK][14] = 62,
	[0][0][2][0][RTW89_FCC][15] = 76,
	[0][0][2][0][RTW89_ETSI][15] = 60,
	[0][0][2][0][RTW89_MKK][15] = 78,
	[0][0][2][0][RTW89_IC][15] = 76,
	[0][0][2][0][RTW89_KCC][15] = 78,
	[0][0][2][0][RTW89_ACMA][15] = 60,
	[0][0][2][0][RTW89_CN][15] = 127,
	[0][0][2][0][RTW89_UK][15] = 60,
	[0][0][2][0][RTW89_FCC][17] = 82,
	[0][0][2][0][RTW89_ETSI][17] = 62,
	[0][0][2][0][RTW89_MKK][17] = 78,
	[0][0][2][0][RTW89_IC][17] = 82,
	[0][0][2][0][RTW89_KCC][17] = 78,
	[0][0][2][0][RTW89_ACMA][17] = 62,
	[0][0][2][0][RTW89_CN][17] = 127,
	[0][0][2][0][RTW89_UK][17] = 62,
	[0][0][2][0][RTW89_FCC][19] = 82,
	[0][0][2][0][RTW89_ETSI][19] = 62,
	[0][0][2][0][RTW89_MKK][19] = 78,
	[0][0][2][0][RTW89_IC][19] = 82,
	[0][0][2][0][RTW89_KCC][19] = 78,
	[0][0][2][0][RTW89_ACMA][19] = 62,
	[0][0][2][0][RTW89_CN][19] = 127,
	[0][0][2][0][RTW89_UK][19] = 62,
	[0][0][2][0][RTW89_FCC][21] = 82,
	[0][0][2][0][RTW89_ETSI][21] = 62,
	[0][0][2][0][RTW89_MKK][21] = 78,
	[0][0][2][0][RTW89_IC][21] = 82,
	[0][0][2][0][RTW89_KCC][21] = 78,
	[0][0][2][0][RTW89_ACMA][21] = 62,
	[0][0][2][0][RTW89_CN][21] = 127,
	[0][0][2][0][RTW89_UK][21] = 62,
	[0][0][2][0][RTW89_FCC][23] = 82,
	[0][0][2][0][RTW89_ETSI][23] = 62,
	[0][0][2][0][RTW89_MKK][23] = 78,
	[0][0][2][0][RTW89_IC][23] = 82,
	[0][0][2][0][RTW89_KCC][23] = 78,
	[0][0][2][0][RTW89_ACMA][23] = 62,
	[0][0][2][0][RTW89_CN][23] = 127,
	[0][0][2][0][RTW89_UK][23] = 62,
	[0][0][2][0][RTW89_FCC][25] = 82,
	[0][0][2][0][RTW89_ETSI][25] = 62,
	[0][0][2][0][RTW89_MKK][25] = 78,
	[0][0][2][0][RTW89_IC][25] = 127,
	[0][0][2][0][RTW89_KCC][25] = 78,
	[0][0][2][0][RTW89_ACMA][25] = 127,
	[0][0][2][0][RTW89_CN][25] = 127,
	[0][0][2][0][RTW89_UK][25] = 62,
	[0][0][2][0][RTW89_FCC][27] = 82,
	[0][0][2][0][RTW89_ETSI][27] = 62,
	[0][0][2][0][RTW89_MKK][27] = 78,
	[0][0][2][0][RTW89_IC][27] = 127,
	[0][0][2][0][RTW89_KCC][27] = 78,
	[0][0][2][0][RTW89_ACMA][27] = 127,
	[0][0][2][0][RTW89_CN][27] = 127,
	[0][0][2][0][RTW89_UK][27] = 62,
	[0][0][2][0][RTW89_FCC][29] = 82,
	[0][0][2][0][RTW89_ETSI][29] = 62,
	[0][0][2][0][RTW89_MKK][29] = 78,
	[0][0][2][0][RTW89_IC][29] = 127,
	[0][0][2][0][RTW89_KCC][29] = 78,
	[0][0][2][0][RTW89_ACMA][29] = 127,
	[0][0][2][0][RTW89_CN][29] = 127,
	[0][0][2][0][RTW89_UK][29] = 62,
	[0][0][2][0][RTW89_FCC][31] = 82,
	[0][0][2][0][RTW89_ETSI][31] = 62,
	[0][0][2][0][RTW89_MKK][31] = 78,
	[0][0][2][0][RTW89_IC][31] = 82,
	[0][0][2][0][RTW89_KCC][31] = 74,
	[0][0][2][0][RTW89_ACMA][31] = 62,
	[0][0][2][0][RTW89_CN][31] = 127,
	[0][0][2][0][RTW89_UK][31] = 62,
	[0][0][2][0][RTW89_FCC][33] = 82,
	[0][0][2][0][RTW89_ETSI][33] = 62,
	[0][0][2][0][RTW89_MKK][33] = 78,
	[0][0][2][0][RTW89_IC][33] = 82,
	[0][0][2][0][RTW89_KCC][33] = 74,
	[0][0][2][0][RTW89_ACMA][33] = 62,
	[0][0][2][0][RTW89_CN][33] = 127,
	[0][0][2][0][RTW89_UK][33] = 62,
	[0][0][2][0][RTW89_FCC][35] = 72,
	[0][0][2][0][RTW89_ETSI][35] = 62,
	[0][0][2][0][RTW89_MKK][35] = 78,
	[0][0][2][0][RTW89_IC][35] = 72,
	[0][0][2][0][RTW89_KCC][35] = 74,
	[0][0][2][0][RTW89_ACMA][35] = 62,
	[0][0][2][0][RTW89_CN][35] = 127,
	[0][0][2][0][RTW89_UK][35] = 62,
	[0][0][2][0][RTW89_FCC][37] = 82,
	[0][0][2][0][RTW89_ETSI][37] = 127,
	[0][0][2][0][RTW89_MKK][37] = 78,
	[0][0][2][0][RTW89_IC][37] = 82,
	[0][0][2][0][RTW89_KCC][37] = 76,
	[0][0][2][0][RTW89_ACMA][37] = 78,
	[0][0][2][0][RTW89_CN][37] = 127,
	[0][0][2][0][RTW89_UK][37] = 78,
	[0][0][2][0][RTW89_FCC][38] = 82,
	[0][0][2][0][RTW89_ETSI][38] = 30,
	[0][0][2][0][RTW89_MKK][38] = 127,
	[0][0][2][0][RTW89_IC][38] = 82,
	[0][0][2][0][RTW89_KCC][38] = 66,
	[0][0][2][0][RTW89_ACMA][38] = 78,
	[0][0][2][0][RTW89_CN][38] = 70,
	[0][0][2][0][RTW89_UK][38] = 60,
	[0][0][2][0][RTW89_FCC][40] = 82,
	[0][0][2][0][RTW89_ETSI][40] = 30,
	[0][0][2][0][RTW89_MKK][40] = 127,
	[0][0][2][0][RTW89_IC][40] = 82,
	[0][0][2][0][RTW89_KCC][40] = 74,
	[0][0][2][0][RTW89_ACMA][40] = 78,
	[0][0][2][0][RTW89_CN][40] = 70,
	[0][0][2][0][RTW89_UK][40] = 60,
	[0][0][2][0][RTW89_FCC][42] = 82,
	[0][0][2][0][RTW89_ETSI][42] = 30,
	[0][0][2][0][RTW89_MKK][42] = 127,
	[0][0][2][0][RTW89_IC][42] = 82,
	[0][0][2][0][RTW89_KCC][42] = 74,
	[0][0][2][0][RTW89_ACMA][42] = 78,
	[0][0][2][0][RTW89_CN][42] = 70,
	[0][0][2][0][RTW89_UK][42] = 60,
	[0][0][2][0][RTW89_FCC][44] = 82,
	[0][0][2][0][RTW89_ETSI][44] = 30,
	[0][0][2][0][RTW89_MKK][44] = 127,
	[0][0][2][0][RTW89_IC][44] = 82,
	[0][0][2][0][RTW89_KCC][44] = 74,
	[0][0][2][0][RTW89_ACMA][44] = 78,
	[0][0][2][0][RTW89_CN][44] = 58,
	[0][0][2][0][RTW89_UK][44] = 60,
	[0][0][2][0][RTW89_FCC][46] = 82,
	[0][0][2][0][RTW89_ETSI][46] = 30,
	[0][0][2][0][RTW89_MKK][46] = 127,
	[0][0][2][0][RTW89_IC][46] = 82,
	[0][0][2][0][RTW89_KCC][46] = 74,
	[0][0][2][0][RTW89_ACMA][46] = 78,
	[0][0][2][0][RTW89_CN][46] = 58,
	[0][0][2][0][RTW89_UK][46] = 60,
	[0][0][2][0][RTW89_FCC][48] = 74,
	[0][0][2][0][RTW89_ETSI][48] = 127,
	[0][0][2][0][RTW89_MKK][48] = 127,
	[0][0][2][0][RTW89_IC][48] = 127,
	[0][0][2][0][RTW89_KCC][48] = 127,
	[0][0][2][0][RTW89_ACMA][48] = 127,
	[0][0][2][0][RTW89_CN][48] = 127,
	[0][0][2][0][RTW89_UK][48] = 127,
	[0][0][2][0][RTW89_FCC][50] = 76,
	[0][0][2][0][RTW89_ETSI][50] = 127,
	[0][0][2][0][RTW89_MKK][50] = 127,
	[0][0][2][0][RTW89_IC][50] = 127,
	[0][0][2][0][RTW89_KCC][50] = 127,
	[0][0][2][0][RTW89_ACMA][50] = 127,
	[0][0][2][0][RTW89_CN][50] = 127,
	[0][0][2][0][RTW89_UK][50] = 127,
	[0][0][2][0][RTW89_FCC][52] = 76,
	[0][0][2][0][RTW89_ETSI][52] = 127,
	[0][0][2][0][RTW89_MKK][52] = 127,
	[0][0][2][0][RTW89_IC][52] = 127,
	[0][0][2][0][RTW89_KCC][52] = 127,
	[0][0][2][0][RTW89_ACMA][52] = 127,
	[0][0][2][0][RTW89_CN][52] = 127,
	[0][0][2][0][RTW89_UK][52] = 127,
	[0][1][2][0][RTW89_FCC][0] = 127,
	[0][1][2][0][RTW89_ETSI][0] = 127,
	[0][1][2][0][RTW89_MKK][0] = 127,
	[0][1][2][0][RTW89_IC][0] = 127,
	[0][1][2][0][RTW89_KCC][0] = 127,
	[0][1][2][0][RTW89_ACMA][0] = 127,
	[0][1][2][0][RTW89_CN][0] = 127,
	[0][1][2][0][RTW89_UK][0] = 127,
	[0][1][2][0][RTW89_FCC][2] = 127,
	[0][1][2][0][RTW89_ETSI][2] = 127,
	[0][1][2][0][RTW89_MKK][2] = 127,
	[0][1][2][0][RTW89_IC][2] = 127,
	[0][1][2][0][RTW89_KCC][2] = 127,
	[0][1][2][0][RTW89_ACMA][2] = 127,
	[0][1][2][0][RTW89_CN][2] = 127,
	[0][1][2][0][RTW89_UK][2] = 127,
	[0][1][2][0][RTW89_FCC][4] = 127,
	[0][1][2][0][RTW89_ETSI][4] = 127,
	[0][1][2][0][RTW89_MKK][4] = 127,
	[0][1][2][0][RTW89_IC][4] = 127,
	[0][1][2][0][RTW89_KCC][4] = 127,
	[0][1][2][0][RTW89_ACMA][4] = 127,
	[0][1][2][0][RTW89_CN][4] = 127,
	[0][1][2][0][RTW89_UK][4] = 127,
	[0][1][2][0][RTW89_FCC][6] = 127,
	[0][1][2][0][RTW89_ETSI][6] = 127,
	[0][1][2][0][RTW89_MKK][6] = 127,
	[0][1][2][0][RTW89_IC][6] = 127,
	[0][1][2][0][RTW89_KCC][6] = 127,
	[0][1][2][0][RTW89_ACMA][6] = 127,
	[0][1][2][0][RTW89_CN][6] = 127,
	[0][1][2][0][RTW89_UK][6] = 127,
	[0][1][2][0][RTW89_FCC][8] = 127,
	[0][1][2][0][RTW89_ETSI][8] = 127,
	[0][1][2][0][RTW89_MKK][8] = 127,
	[0][1][2][0][RTW89_IC][8] = 127,
	[0][1][2][0][RTW89_KCC][8] = 127,
	[0][1][2][0][RTW89_ACMA][8] = 127,
	[0][1][2][0][RTW89_CN][8] = 127,
	[0][1][2][0][RTW89_UK][8] = 127,
	[0][1][2][0][RTW89_FCC][10] = 127,
	[0][1][2][0][RTW89_ETSI][10] = 127,
	[0][1][2][0][RTW89_MKK][10] = 127,
	[0][1][2][0][RTW89_IC][10] = 127,
	[0][1][2][0][RTW89_KCC][10] = 127,
	[0][1][2][0][RTW89_ACMA][10] = 127,
	[0][1][2][0][RTW89_CN][10] = 127,
	[0][1][2][0][RTW89_UK][10] = 127,
	[0][1][2][0][RTW89_FCC][12] = 127,
	[0][1][2][0][RTW89_ETSI][12] = 127,
	[0][1][2][0][RTW89_MKK][12] = 127,
	[0][1][2][0][RTW89_IC][12] = 127,
	[0][1][2][0][RTW89_KCC][12] = 127,
	[0][1][2][0][RTW89_ACMA][12] = 127,
	[0][1][2][0][RTW89_CN][12] = 127,
	[0][1][2][0][RTW89_UK][12] = 127,
	[0][1][2][0][RTW89_FCC][14] = 127,
	[0][1][2][0][RTW89_ETSI][14] = 127,
	[0][1][2][0][RTW89_MKK][14] = 127,
	[0][1][2][0][RTW89_IC][14] = 127,
	[0][1][2][0][RTW89_KCC][14] = 127,
	[0][1][2][0][RTW89_ACMA][14] = 127,
	[0][1][2][0][RTW89_CN][14] = 127,
	[0][1][2][0][RTW89_UK][14] = 127,
	[0][1][2][0][RTW89_FCC][15] = 127,
	[0][1][2][0][RTW89_ETSI][15] = 127,
	[0][1][2][0][RTW89_MKK][15] = 127,
	[0][1][2][0][RTW89_IC][15] = 127,
	[0][1][2][0][RTW89_KCC][15] = 127,
	[0][1][2][0][RTW89_ACMA][15] = 127,
	[0][1][2][0][RTW89_CN][15] = 127,
	[0][1][2][0][RTW89_UK][15] = 127,
	[0][1][2][0][RTW89_FCC][17] = 127,
	[0][1][2][0][RTW89_ETSI][17] = 127,
	[0][1][2][0][RTW89_MKK][17] = 127,
	[0][1][2][0][RTW89_IC][17] = 127,
	[0][1][2][0][RTW89_KCC][17] = 127,
	[0][1][2][0][RTW89_ACMA][17] = 127,
	[0][1][2][0][RTW89_CN][17] = 127,
	[0][1][2][0][RTW89_UK][17] = 127,
	[0][1][2][0][RTW89_FCC][19] = 127,
	[0][1][2][0][RTW89_ETSI][19] = 127,
	[0][1][2][0][RTW89_MKK][19] = 127,
	[0][1][2][0][RTW89_IC][19] = 127,
	[0][1][2][0][RTW89_KCC][19] = 127,
	[0][1][2][0][RTW89_ACMA][19] = 127,
	[0][1][2][0][RTW89_CN][19] = 127,
	[0][1][2][0][RTW89_UK][19] = 127,
	[0][1][2][0][RTW89_FCC][21] = 127,
	[0][1][2][0][RTW89_ETSI][21] = 127,
	[0][1][2][0][RTW89_MKK][21] = 127,
	[0][1][2][0][RTW89_IC][21] = 127,
	[0][1][2][0][RTW89_KCC][21] = 127,
	[0][1][2][0][RTW89_ACMA][21] = 127,
	[0][1][2][0][RTW89_CN][21] = 127,
	[0][1][2][0][RTW89_UK][21] = 127,
	[0][1][2][0][RTW89_FCC][23] = 127,
	[0][1][2][0][RTW89_ETSI][23] = 127,
	[0][1][2][0][RTW89_MKK][23] = 127,
	[0][1][2][0][RTW89_IC][23] = 127,
	[0][1][2][0][RTW89_KCC][23] = 127,
	[0][1][2][0][RTW89_ACMA][23] = 127,
	[0][1][2][0][RTW89_CN][23] = 127,
	[0][1][2][0][RTW89_UK][23] = 127,
	[0][1][2][0][RTW89_FCC][25] = 127,
	[0][1][2][0][RTW89_ETSI][25] = 127,
	[0][1][2][0][RTW89_MKK][25] = 127,
	[0][1][2][0][RTW89_IC][25] = 127,
	[0][1][2][0][RTW89_KCC][25] = 127,
	[0][1][2][0][RTW89_ACMA][25] = 127,
	[0][1][2][0][RTW89_CN][25] = 127,
	[0][1][2][0][RTW89_UK][25] = 127,
	[0][1][2][0][RTW89_FCC][27] = 127,
	[0][1][2][0][RTW89_ETSI][27] = 127,
	[0][1][2][0][RTW89_MKK][27] = 127,
	[0][1][2][0][RTW89_IC][27] = 127,
	[0][1][2][0][RTW89_KCC][27] = 127,
	[0][1][2][0][RTW89_ACMA][27] = 127,
	[0][1][2][0][RTW89_CN][27] = 127,
	[0][1][2][0][RTW89_UK][27] = 127,
	[0][1][2][0][RTW89_FCC][29] = 127,
	[0][1][2][0][RTW89_ETSI][29] = 127,
	[0][1][2][0][RTW89_MKK][29] = 127,
	[0][1][2][0][RTW89_IC][29] = 127,
	[0][1][2][0][RTW89_KCC][29] = 127,
	[0][1][2][0][RTW89_ACMA][29] = 127,
	[0][1][2][0][RTW89_CN][29] = 127,
	[0][1][2][0][RTW89_UK][29] = 127,
	[0][1][2][0][RTW89_FCC][31] = 127,
	[0][1][2][0][RTW89_ETSI][31] = 127,
	[0][1][2][0][RTW89_MKK][31] = 127,
	[0][1][2][0][RTW89_IC][31] = 127,
	[0][1][2][0][RTW89_KCC][31] = 127,
	[0][1][2][0][RTW89_ACMA][31] = 127,
	[0][1][2][0][RTW89_CN][31] = 127,
	[0][1][2][0][RTW89_UK][31] = 127,
	[0][1][2][0][RTW89_FCC][33] = 127,
	[0][1][2][0][RTW89_ETSI][33] = 127,
	[0][1][2][0][RTW89_MKK][33] = 127,
	[0][1][2][0][RTW89_IC][33] = 127,
	[0][1][2][0][RTW89_KCC][33] = 127,
	[0][1][2][0][RTW89_ACMA][33] = 127,
	[0][1][2][0][RTW89_CN][33] = 127,
	[0][1][2][0][RTW89_UK][33] = 127,
	[0][1][2][0][RTW89_FCC][35] = 127,
	[0][1][2][0][RTW89_ETSI][35] = 127,
	[0][1][2][0][RTW89_MKK][35] = 127,
	[0][1][2][0][RTW89_IC][35] = 127,
	[0][1][2][0][RTW89_KCC][35] = 127,
	[0][1][2][0][RTW89_ACMA][35] = 127,
	[0][1][2][0][RTW89_CN][35] = 127,
	[0][1][2][0][RTW89_UK][35] = 127,
	[0][1][2][0][RTW89_FCC][37] = 127,
	[0][1][2][0][RTW89_ETSI][37] = 127,
	[0][1][2][0][RTW89_MKK][37] = 127,
	[0][1][2][0][RTW89_IC][37] = 127,
	[0][1][2][0][RTW89_KCC][37] = 127,
	[0][1][2][0][RTW89_ACMA][37] = 127,
	[0][1][2][0][RTW89_CN][37] = 127,
	[0][1][2][0][RTW89_UK][37] = 127,
	[0][1][2][0][RTW89_FCC][38] = 127,
	[0][1][2][0][RTW89_ETSI][38] = 127,
	[0][1][2][0][RTW89_MKK][38] = 127,
	[0][1][2][0][RTW89_IC][38] = 127,
	[0][1][2][0][RTW89_KCC][38] = 127,
	[0][1][2][0][RTW89_ACMA][38] = 127,
	[0][1][2][0][RTW89_CN][38] = 127,
	[0][1][2][0][RTW89_UK][38] = 127,
	[0][1][2][0][RTW89_FCC][40] = 127,
	[0][1][2][0][RTW89_ETSI][40] = 127,
	[0][1][2][0][RTW89_MKK][40] = 127,
	[0][1][2][0][RTW89_IC][40] = 127,
	[0][1][2][0][RTW89_KCC][40] = 127,
	[0][1][2][0][RTW89_ACMA][40] = 127,
	[0][1][2][0][RTW89_CN][40] = 127,
	[0][1][2][0][RTW89_UK][40] = 127,
	[0][1][2][0][RTW89_FCC][42] = 127,
	[0][1][2][0][RTW89_ETSI][42] = 127,
	[0][1][2][0][RTW89_MKK][42] = 127,
	[0][1][2][0][RTW89_IC][42] = 127,
	[0][1][2][0][RTW89_KCC][42] = 127,
	[0][1][2][0][RTW89_ACMA][42] = 127,
	[0][1][2][0][RTW89_CN][42] = 127,
	[0][1][2][0][RTW89_UK][42] = 127,
	[0][1][2][0][RTW89_FCC][44] = 127,
	[0][1][2][0][RTW89_ETSI][44] = 127,
	[0][1][2][0][RTW89_MKK][44] = 127,
	[0][1][2][0][RTW89_IC][44] = 127,
	[0][1][2][0][RTW89_KCC][44] = 127,
	[0][1][2][0][RTW89_ACMA][44] = 127,
	[0][1][2][0][RTW89_CN][44] = 127,
	[0][1][2][0][RTW89_UK][44] = 127,
	[0][1][2][0][RTW89_FCC][46] = 127,
	[0][1][2][0][RTW89_ETSI][46] = 127,
	[0][1][2][0][RTW89_MKK][46] = 127,
	[0][1][2][0][RTW89_IC][46] = 127,
	[0][1][2][0][RTW89_KCC][46] = 127,
	[0][1][2][0][RTW89_ACMA][46] = 127,
	[0][1][2][0][RTW89_CN][46] = 127,
	[0][1][2][0][RTW89_UK][46] = 127,
	[0][1][2][0][RTW89_FCC][48] = 127,
	[0][1][2][0][RTW89_ETSI][48] = 127,
	[0][1][2][0][RTW89_MKK][48] = 127,
	[0][1][2][0][RTW89_IC][48] = 127,
	[0][1][2][0][RTW89_KCC][48] = 127,
	[0][1][2][0][RTW89_ACMA][48] = 127,
	[0][1][2][0][RTW89_CN][48] = 127,
	[0][1][2][0][RTW89_UK][48] = 127,
	[0][1][2][0][RTW89_FCC][50] = 127,
	[0][1][2][0][RTW89_ETSI][50] = 127,
	[0][1][2][0][RTW89_MKK][50] = 127,
	[0][1][2][0][RTW89_IC][50] = 127,
	[0][1][2][0][RTW89_KCC][50] = 127,
	[0][1][2][0][RTW89_ACMA][50] = 127,
	[0][1][2][0][RTW89_CN][50] = 127,
	[0][1][2][0][RTW89_UK][50] = 127,
	[0][1][2][0][RTW89_FCC][52] = 127,
	[0][1][2][0][RTW89_ETSI][52] = 127,
	[0][1][2][0][RTW89_MKK][52] = 127,
	[0][1][2][0][RTW89_IC][52] = 127,
	[0][1][2][0][RTW89_KCC][52] = 127,
	[0][1][2][0][RTW89_ACMA][52] = 127,
	[0][1][2][0][RTW89_CN][52] = 127,
	[0][1][2][0][RTW89_UK][52] = 127,
	[0][1][2][1][RTW89_FCC][0] = 127,
	[0][1][2][1][RTW89_ETSI][0] = 127,
	[0][1][2][1][RTW89_MKK][0] = 127,
	[0][1][2][1][RTW89_IC][0] = 127,
	[0][1][2][1][RTW89_KCC][0] = 127,
	[0][1][2][1][RTW89_ACMA][0] = 127,
	[0][1][2][1][RTW89_CN][0] = 127,
	[0][1][2][1][RTW89_UK][0] = 127,
	[0][1][2][1][RTW89_FCC][2] = 127,
	[0][1][2][1][RTW89_ETSI][2] = 127,
	[0][1][2][1][RTW89_MKK][2] = 127,
	[0][1][2][1][RTW89_IC][2] = 127,
	[0][1][2][1][RTW89_KCC][2] = 127,
	[0][1][2][1][RTW89_ACMA][2] = 127,
	[0][1][2][1][RTW89_CN][2] = 127,
	[0][1][2][1][RTW89_UK][2] = 127,
	[0][1][2][1][RTW89_FCC][4] = 127,
	[0][1][2][1][RTW89_ETSI][4] = 127,
	[0][1][2][1][RTW89_MKK][4] = 127,
	[0][1][2][1][RTW89_IC][4] = 127,
	[0][1][2][1][RTW89_KCC][4] = 127,
	[0][1][2][1][RTW89_ACMA][4] = 127,
	[0][1][2][1][RTW89_CN][4] = 127,
	[0][1][2][1][RTW89_UK][4] = 127,
	[0][1][2][1][RTW89_FCC][6] = 127,
	[0][1][2][1][RTW89_ETSI][6] = 127,
	[0][1][2][1][RTW89_MKK][6] = 127,
	[0][1][2][1][RTW89_IC][6] = 127,
	[0][1][2][1][RTW89_KCC][6] = 127,
	[0][1][2][1][RTW89_ACMA][6] = 127,
	[0][1][2][1][RTW89_CN][6] = 127,
	[0][1][2][1][RTW89_UK][6] = 127,
	[0][1][2][1][RTW89_FCC][8] = 127,
	[0][1][2][1][RTW89_ETSI][8] = 127,
	[0][1][2][1][RTW89_MKK][8] = 127,
	[0][1][2][1][RTW89_IC][8] = 127,
	[0][1][2][1][RTW89_KCC][8] = 127,
	[0][1][2][1][RTW89_ACMA][8] = 127,
	[0][1][2][1][RTW89_CN][8] = 127,
	[0][1][2][1][RTW89_UK][8] = 127,
	[0][1][2][1][RTW89_FCC][10] = 127,
	[0][1][2][1][RTW89_ETSI][10] = 127,
	[0][1][2][1][RTW89_MKK][10] = 127,
	[0][1][2][1][RTW89_IC][10] = 127,
	[0][1][2][1][RTW89_KCC][10] = 127,
	[0][1][2][1][RTW89_ACMA][10] = 127,
	[0][1][2][1][RTW89_CN][10] = 127,
	[0][1][2][1][RTW89_UK][10] = 127,
	[0][1][2][1][RTW89_FCC][12] = 127,
	[0][1][2][1][RTW89_ETSI][12] = 127,
	[0][1][2][1][RTW89_MKK][12] = 127,
	[0][1][2][1][RTW89_IC][12] = 127,
	[0][1][2][1][RTW89_KCC][12] = 127,
	[0][1][2][1][RTW89_ACMA][12] = 127,
	[0][1][2][1][RTW89_CN][12] = 127,
	[0][1][2][1][RTW89_UK][12] = 127,
	[0][1][2][1][RTW89_FCC][14] = 127,
	[0][1][2][1][RTW89_ETSI][14] = 127,
	[0][1][2][1][RTW89_MKK][14] = 127,
	[0][1][2][1][RTW89_IC][14] = 127,
	[0][1][2][1][RTW89_KCC][14] = 127,
	[0][1][2][1][RTW89_ACMA][14] = 127,
	[0][1][2][1][RTW89_CN][14] = 127,
	[0][1][2][1][RTW89_UK][14] = 127,
	[0][1][2][1][RTW89_FCC][15] = 127,
	[0][1][2][1][RTW89_ETSI][15] = 127,
	[0][1][2][1][RTW89_MKK][15] = 127,
	[0][1][2][1][RTW89_IC][15] = 127,
	[0][1][2][1][RTW89_KCC][15] = 127,
	[0][1][2][1][RTW89_ACMA][15] = 127,
	[0][1][2][1][RTW89_CN][15] = 127,
	[0][1][2][1][RTW89_UK][15] = 127,
	[0][1][2][1][RTW89_FCC][17] = 127,
	[0][1][2][1][RTW89_ETSI][17] = 127,
	[0][1][2][1][RTW89_MKK][17] = 127,
	[0][1][2][1][RTW89_IC][17] = 127,
	[0][1][2][1][RTW89_KCC][17] = 127,
	[0][1][2][1][RTW89_ACMA][17] = 127,
	[0][1][2][1][RTW89_CN][17] = 127,
	[0][1][2][1][RTW89_UK][17] = 127,
	[0][1][2][1][RTW89_FCC][19] = 127,
	[0][1][2][1][RTW89_ETSI][19] = 127,
	[0][1][2][1][RTW89_MKK][19] = 127,
	[0][1][2][1][RTW89_IC][19] = 127,
	[0][1][2][1][RTW89_KCC][19] = 127,
	[0][1][2][1][RTW89_ACMA][19] = 127,
	[0][1][2][1][RTW89_CN][19] = 127,
	[0][1][2][1][RTW89_UK][19] = 127,
	[0][1][2][1][RTW89_FCC][21] = 127,
	[0][1][2][1][RTW89_ETSI][21] = 127,
	[0][1][2][1][RTW89_MKK][21] = 127,
	[0][1][2][1][RTW89_IC][21] = 127,
	[0][1][2][1][RTW89_KCC][21] = 127,
	[0][1][2][1][RTW89_ACMA][21] = 127,
	[0][1][2][1][RTW89_CN][21] = 127,
	[0][1][2][1][RTW89_UK][21] = 127,
	[0][1][2][1][RTW89_FCC][23] = 127,
	[0][1][2][1][RTW89_ETSI][23] = 127,
	[0][1][2][1][RTW89_MKK][23] = 127,
	[0][1][2][1][RTW89_IC][23] = 127,
	[0][1][2][1][RTW89_KCC][23] = 127,
	[0][1][2][1][RTW89_ACMA][23] = 127,
	[0][1][2][1][RTW89_CN][23] = 127,
	[0][1][2][1][RTW89_UK][23] = 127,
	[0][1][2][1][RTW89_FCC][25] = 127,
	[0][1][2][1][RTW89_ETSI][25] = 127,
	[0][1][2][1][RTW89_MKK][25] = 127,
	[0][1][2][1][RTW89_IC][25] = 127,
	[0][1][2][1][RTW89_KCC][25] = 127,
	[0][1][2][1][RTW89_ACMA][25] = 127,
	[0][1][2][1][RTW89_CN][25] = 127,
	[0][1][2][1][RTW89_UK][25] = 127,
	[0][1][2][1][RTW89_FCC][27] = 127,
	[0][1][2][1][RTW89_ETSI][27] = 127,
	[0][1][2][1][RTW89_MKK][27] = 127,
	[0][1][2][1][RTW89_IC][27] = 127,
	[0][1][2][1][RTW89_KCC][27] = 127,
	[0][1][2][1][RTW89_ACMA][27] = 127,
	[0][1][2][1][RTW89_CN][27] = 127,
	[0][1][2][1][RTW89_UK][27] = 127,
	[0][1][2][1][RTW89_FCC][29] = 127,
	[0][1][2][1][RTW89_ETSI][29] = 127,
	[0][1][2][1][RTW89_MKK][29] = 127,
	[0][1][2][1][RTW89_IC][29] = 127,
	[0][1][2][1][RTW89_KCC][29] = 127,
	[0][1][2][1][RTW89_ACMA][29] = 127,
	[0][1][2][1][RTW89_CN][29] = 127,
	[0][1][2][1][RTW89_UK][29] = 127,
	[0][1][2][1][RTW89_FCC][31] = 127,
	[0][1][2][1][RTW89_ETSI][31] = 127,
	[0][1][2][1][RTW89_MKK][31] = 127,
	[0][1][2][1][RTW89_IC][31] = 127,
	[0][1][2][1][RTW89_KCC][31] = 127,
	[0][1][2][1][RTW89_ACMA][31] = 127,
	[0][1][2][1][RTW89_CN][31] = 127,
	[0][1][2][1][RTW89_UK][31] = 127,
	[0][1][2][1][RTW89_FCC][33] = 127,
	[0][1][2][1][RTW89_ETSI][33] = 127,
	[0][1][2][1][RTW89_MKK][33] = 127,
	[0][1][2][1][RTW89_IC][33] = 127,
	[0][1][2][1][RTW89_KCC][33] = 127,
	[0][1][2][1][RTW89_ACMA][33] = 127,
	[0][1][2][1][RTW89_CN][33] = 127,
	[0][1][2][1][RTW89_UK][33] = 127,
	[0][1][2][1][RTW89_FCC][35] = 127,
	[0][1][2][1][RTW89_ETSI][35] = 127,
	[0][1][2][1][RTW89_MKK][35] = 127,
	[0][1][2][1][RTW89_IC][35] = 127,
	[0][1][2][1][RTW89_KCC][35] = 127,
	[0][1][2][1][RTW89_ACMA][35] = 127,
	[0][1][2][1][RTW89_CN][35] = 127,
	[0][1][2][1][RTW89_UK][35] = 127,
	[0][1][2][1][RTW89_FCC][37] = 127,
	[0][1][2][1][RTW89_ETSI][37] = 127,
	[0][1][2][1][RTW89_MKK][37] = 127,
	[0][1][2][1][RTW89_IC][37] = 127,
	[0][1][2][1][RTW89_KCC][37] = 127,
	[0][1][2][1][RTW89_ACMA][37] = 127,
	[0][1][2][1][RTW89_CN][37] = 127,
	[0][1][2][1][RTW89_UK][37] = 127,
	[0][1][2][1][RTW89_FCC][38] = 127,
	[0][1][2][1][RTW89_ETSI][38] = 127,
	[0][1][2][1][RTW89_MKK][38] = 127,
	[0][1][2][1][RTW89_IC][38] = 127,
	[0][1][2][1][RTW89_KCC][38] = 127,
	[0][1][2][1][RTW89_ACMA][38] = 127,
	[0][1][2][1][RTW89_CN][38] = 127,
	[0][1][2][1][RTW89_UK][38] = 127,
	[0][1][2][1][RTW89_FCC][40] = 127,
	[0][1][2][1][RTW89_ETSI][40] = 127,
	[0][1][2][1][RTW89_MKK][40] = 127,
	[0][1][2][1][RTW89_IC][40] = 127,
	[0][1][2][1][RTW89_KCC][40] = 127,
	[0][1][2][1][RTW89_ACMA][40] = 127,
	[0][1][2][1][RTW89_CN][40] = 127,
	[0][1][2][1][RTW89_UK][40] = 127,
	[0][1][2][1][RTW89_FCC][42] = 127,
	[0][1][2][1][RTW89_ETSI][42] = 127,
	[0][1][2][1][RTW89_MKK][42] = 127,
	[0][1][2][1][RTW89_IC][42] = 127,
	[0][1][2][1][RTW89_KCC][42] = 127,
	[0][1][2][1][RTW89_ACMA][42] = 127,
	[0][1][2][1][RTW89_CN][42] = 127,
	[0][1][2][1][RTW89_UK][42] = 127,
	[0][1][2][1][RTW89_FCC][44] = 127,
	[0][1][2][1][RTW89_ETSI][44] = 127,
	[0][1][2][1][RTW89_MKK][44] = 127,
	[0][1][2][1][RTW89_IC][44] = 127,
	[0][1][2][1][RTW89_KCC][44] = 127,
	[0][1][2][1][RTW89_ACMA][44] = 127,
	[0][1][2][1][RTW89_CN][44] = 127,
	[0][1][2][1][RTW89_UK][44] = 127,
	[0][1][2][1][RTW89_FCC][46] = 127,
	[0][1][2][1][RTW89_ETSI][46] = 127,
	[0][1][2][1][RTW89_MKK][46] = 127,
	[0][1][2][1][RTW89_IC][46] = 127,
	[0][1][2][1][RTW89_KCC][46] = 127,
	[0][1][2][1][RTW89_ACMA][46] = 127,
	[0][1][2][1][RTW89_CN][46] = 127,
	[0][1][2][1][RTW89_UK][46] = 127,
	[0][1][2][1][RTW89_FCC][48] = 127,
	[0][1][2][1][RTW89_ETSI][48] = 127,
	[0][1][2][1][RTW89_MKK][48] = 127,
	[0][1][2][1][RTW89_IC][48] = 127,
	[0][1][2][1][RTW89_KCC][48] = 127,
	[0][1][2][1][RTW89_ACMA][48] = 127,
	[0][1][2][1][RTW89_CN][48] = 127,
	[0][1][2][1][RTW89_UK][48] = 127,
	[0][1][2][1][RTW89_FCC][50] = 127,
	[0][1][2][1][RTW89_ETSI][50] = 127,
	[0][1][2][1][RTW89_MKK][50] = 127,
	[0][1][2][1][RTW89_IC][50] = 127,
	[0][1][2][1][RTW89_KCC][50] = 127,
	[0][1][2][1][RTW89_ACMA][50] = 127,
	[0][1][2][1][RTW89_CN][50] = 127,
	[0][1][2][1][RTW89_UK][50] = 127,
	[0][1][2][1][RTW89_FCC][52] = 127,
	[0][1][2][1][RTW89_ETSI][52] = 127,
	[0][1][2][1][RTW89_MKK][52] = 127,
	[0][1][2][1][RTW89_IC][52] = 127,
	[0][1][2][1][RTW89_KCC][52] = 127,
	[0][1][2][1][RTW89_ACMA][52] = 127,
	[0][1][2][1][RTW89_CN][52] = 127,
	[0][1][2][1][RTW89_UK][52] = 127,
	[1][0][2][0][RTW89_FCC][1] = 68,
	[1][0][2][0][RTW89_ETSI][1] = 64,
	[1][0][2][0][RTW89_MKK][1] = 64,
	[1][0][2][0][RTW89_IC][1] = 64,
	[1][0][2][0][RTW89_KCC][1] = 74,
	[1][0][2][0][RTW89_ACMA][1] = 64,
	[1][0][2][0][RTW89_CN][1] = 62,
	[1][0][2][0][RTW89_UK][1] = 64,
	[1][0][2][0][RTW89_FCC][5] = 82,
	[1][0][2][0][RTW89_ETSI][5] = 64,
	[1][0][2][0][RTW89_MKK][5] = 62,
	[1][0][2][0][RTW89_IC][5] = 64,
	[1][0][2][0][RTW89_KCC][5] = 66,
	[1][0][2][0][RTW89_ACMA][5] = 64,
	[1][0][2][0][RTW89_CN][5] = 62,
	[1][0][2][0][RTW89_UK][5] = 64,
	[1][0][2][0][RTW89_FCC][9] = 82,
	[1][0][2][0][RTW89_ETSI][9] = 64,
	[1][0][2][0][RTW89_MKK][9] = 64,
	[1][0][2][0][RTW89_IC][9] = 64,
	[1][0][2][0][RTW89_KCC][9] = 78,
	[1][0][2][0][RTW89_ACMA][9] = 64,
	[1][0][2][0][RTW89_CN][9] = 62,
	[1][0][2][0][RTW89_UK][9] = 64,
	[1][0][2][0][RTW89_FCC][13] = 66,
	[1][0][2][0][RTW89_ETSI][13] = 64,
	[1][0][2][0][RTW89_MKK][13] = 64,
	[1][0][2][0][RTW89_IC][13] = 64,
	[1][0][2][0][RTW89_KCC][13] = 72,
	[1][0][2][0][RTW89_ACMA][13] = 64,
	[1][0][2][0][RTW89_CN][13] = 62,
	[1][0][2][0][RTW89_UK][13] = 64,
	[1][0][2][0][RTW89_FCC][16] = 66,
	[1][0][2][0][RTW89_ETSI][16] = 66,
	[1][0][2][0][RTW89_MKK][16] = 80,
	[1][0][2][0][RTW89_IC][16] = 66,
	[1][0][2][0][RTW89_KCC][16] = 74,
	[1][0][2][0][RTW89_ACMA][16] = 66,
	[1][0][2][0][RTW89_CN][16] = 127,
	[1][0][2][0][RTW89_UK][16] = 66,
	[1][0][2][0][RTW89_FCC][20] = 80,
	[1][0][2][0][RTW89_ETSI][20] = 66,
	[1][0][2][0][RTW89_MKK][20] = 80,
	[1][0][2][0][RTW89_IC][20] = 80,
	[1][0][2][0][RTW89_KCC][20] = 74,
	[1][0][2][0][RTW89_ACMA][20] = 66,
	[1][0][2][0][RTW89_CN][20] = 127,
	[1][0][2][0][RTW89_UK][20] = 66,
	[1][0][2][0][RTW89_FCC][24] = 80,
	[1][0][2][0][RTW89_ETSI][24] = 66,
	[1][0][2][0][RTW89_MKK][24] = 80,
	[1][0][2][0][RTW89_IC][24] = 127,
	[1][0][2][0][RTW89_KCC][24] = 74,
	[1][0][2][0][RTW89_ACMA][24] = 127,
	[1][0][2][0][RTW89_CN][24] = 127,
	[1][0][2][0][RTW89_UK][24] = 66,
	[1][0][2][0][RTW89_FCC][28] = 80,
	[1][0][2][0][RTW89_ETSI][28] = 66,
	[1][0][2][0][RTW89_MKK][28] = 80,
	[1][0][2][0][RTW89_IC][28] = 127,
	[1][0][2][0][RTW89_KCC][28] = 74,
	[1][0][2][0][RTW89_ACMA][28] = 127,
	[1][0][2][0][RTW89_CN][28] = 127,
	[1][0][2][0][RTW89_UK][28] = 66,
	[1][0][2][0][RTW89_FCC][32] = 76,
	[1][0][2][0][RTW89_ETSI][32] = 66,
	[1][0][2][0][RTW89_MKK][32] = 80,
	[1][0][2][0][RTW89_IC][32] = 76,
	[1][0][2][0][RTW89_KCC][32] = 78,
	[1][0][2][0][RTW89_ACMA][32] = 66,
	[1][0][2][0][RTW89_CN][32] = 127,
	[1][0][2][0][RTW89_UK][32] = 66,
	[1][0][2][0][RTW89_FCC][36] = 80,
	[1][0][2][0][RTW89_ETSI][36] = 127,
	[1][0][2][0][RTW89_MKK][36] = 80,
	[1][0][2][0][RTW89_IC][36] = 80,
	[1][0][2][0][RTW89_KCC][36] = 76,
	[1][0][2][0][RTW89_ACMA][36] = 78,
	[1][0][2][0][RTW89_CN][36] = 127,
	[1][0][2][0][RTW89_UK][36] = 80,
	[1][0][2][0][RTW89_FCC][39] = 84,
	[1][0][2][0][RTW89_ETSI][39] = 30,
	[1][0][2][0][RTW89_MKK][39] = 127,
	[1][0][2][0][RTW89_IC][39] = 84,
	[1][0][2][0][RTW89_KCC][39] = 68,
	[1][0][2][0][RTW89_ACMA][39] = 80,
	[1][0][2][0][RTW89_CN][39] = 60,
	[1][0][2][0][RTW89_UK][39] = 64,
	[1][0][2][0][RTW89_FCC][43] = 84,
	[1][0][2][0][RTW89_ETSI][43] = 30,
	[1][0][2][0][RTW89_MKK][43] = 127,
	[1][0][2][0][RTW89_IC][43] = 84,
	[1][0][2][0][RTW89_KCC][43] = 78,
	[1][0][2][0][RTW89_ACMA][43] = 80,
	[1][0][2][0][RTW89_CN][43] = 62,
	[1][0][2][0][RTW89_UK][43] = 64,
	[1][0][2][0][RTW89_FCC][47] = 84,
	[1][0][2][0][RTW89_ETSI][47] = 127,
	[1][0][2][0][RTW89_MKK][47] = 127,
	[1][0][2][0][RTW89_IC][47] = 127,
	[1][0][2][0][RTW89_KCC][47] = 127,
	[1][0][2][0][RTW89_ACMA][47] = 127,
	[1][0][2][0][RTW89_CN][47] = 127,
	[1][0][2][0][RTW89_UK][47] = 127,
	[1][0][2][0][RTW89_FCC][51] = 84,
	[1][0][2][0][RTW89_ETSI][51] = 127,
	[1][0][2][0][RTW89_MKK][51] = 127,
	[1][0][2][0][RTW89_IC][51] = 127,
	[1][0][2][0][RTW89_KCC][51] = 127,
	[1][0][2][0][RTW89_ACMA][51] = 127,
	[1][0][2][0][RTW89_CN][51] = 127,
	[1][0][2][0][RTW89_UK][51] = 127,
	[1][1][2][0][RTW89_FCC][1] = 127,
	[1][1][2][0][RTW89_ETSI][1] = 127,
	[1][1][2][0][RTW89_MKK][1] = 127,
	[1][1][2][0][RTW89_IC][1] = 127,
	[1][1][2][0][RTW89_KCC][1] = 127,
	[1][1][2][0][RTW89_ACMA][1] = 127,
	[1][1][2][0][RTW89_CN][1] = 127,
	[1][1][2][0][RTW89_UK][1] = 127,
	[1][1][2][0][RTW89_FCC][5] = 127,
	[1][1][2][0][RTW89_ETSI][5] = 127,
	[1][1][2][0][RTW89_MKK][5] = 127,
	[1][1][2][0][RTW89_IC][5] = 127,
	[1][1][2][0][RTW89_KCC][5] = 127,
	[1][1][2][0][RTW89_ACMA][5] = 127,
	[1][1][2][0][RTW89_CN][5] = 127,
	[1][1][2][0][RTW89_UK][5] = 127,
	[1][1][2][0][RTW89_FCC][9] = 127,
	[1][1][2][0][RTW89_ETSI][9] = 127,
	[1][1][2][0][RTW89_MKK][9] = 127,
	[1][1][2][0][RTW89_IC][9] = 127,
	[1][1][2][0][RTW89_KCC][9] = 127,
	[1][1][2][0][RTW89_ACMA][9] = 127,
	[1][1][2][0][RTW89_CN][9] = 127,
	[1][1][2][0][RTW89_UK][9] = 127,
	[1][1][2][0][RTW89_FCC][13] = 127,
	[1][1][2][0][RTW89_ETSI][13] = 127,
	[1][1][2][0][RTW89_MKK][13] = 127,
	[1][1][2][0][RTW89_IC][13] = 127,
	[1][1][2][0][RTW89_KCC][13] = 127,
	[1][1][2][0][RTW89_ACMA][13] = 127,
	[1][1][2][0][RTW89_CN][13] = 127,
	[1][1][2][0][RTW89_UK][13] = 127,
	[1][1][2][0][RTW89_FCC][16] = 127,
	[1][1][2][0][RTW89_ETSI][16] = 127,
	[1][1][2][0][RTW89_MKK][16] = 127,
	[1][1][2][0][RTW89_IC][16] = 127,
	[1][1][2][0][RTW89_KCC][16] = 127,
	[1][1][2][0][RTW89_ACMA][16] = 127,
	[1][1][2][0][RTW89_CN][16] = 127,
	[1][1][2][0][RTW89_UK][16] = 127,
	[1][1][2][0][RTW89_FCC][20] = 127,
	[1][1][2][0][RTW89_ETSI][20] = 127,
	[1][1][2][0][RTW89_MKK][20] = 127,
	[1][1][2][0][RTW89_IC][20] = 127,
	[1][1][2][0][RTW89_KCC][20] = 127,
	[1][1][2][0][RTW89_ACMA][20] = 127,
	[1][1][2][0][RTW89_CN][20] = 127,
	[1][1][2][0][RTW89_UK][20] = 127,
	[1][1][2][0][RTW89_FCC][24] = 127,
	[1][1][2][0][RTW89_ETSI][24] = 127,
	[1][1][2][0][RTW89_MKK][24] = 127,
	[1][1][2][0][RTW89_IC][24] = 127,
	[1][1][2][0][RTW89_KCC][24] = 127,
	[1][1][2][0][RTW89_ACMA][24] = 127,
	[1][1][2][0][RTW89_CN][24] = 127,
	[1][1][2][0][RTW89_UK][24] = 127,
	[1][1][2][0][RTW89_FCC][28] = 127,
	[1][1][2][0][RTW89_ETSI][28] = 127,
	[1][1][2][0][RTW89_MKK][28] = 127,
	[1][1][2][0][RTW89_IC][28] = 127,
	[1][1][2][0][RTW89_KCC][28] = 127,
	[1][1][2][0][RTW89_ACMA][28] = 127,
	[1][1][2][0][RTW89_CN][28] = 127,
	[1][1][2][0][RTW89_UK][28] = 127,
	[1][1][2][0][RTW89_FCC][32] = 127,
	[1][1][2][0][RTW89_ETSI][32] = 127,
	[1][1][2][0][RTW89_MKK][32] = 127,
	[1][1][2][0][RTW89_IC][32] = 127,
	[1][1][2][0][RTW89_KCC][32] = 127,
	[1][1][2][0][RTW89_ACMA][32] = 127,
	[1][1][2][0][RTW89_CN][32] = 127,
	[1][1][2][0][RTW89_UK][32] = 127,
	[1][1][2][0][RTW89_FCC][36] = 127,
	[1][1][2][0][RTW89_ETSI][36] = 127,
	[1][1][2][0][RTW89_MKK][36] = 127,
	[1][1][2][0][RTW89_IC][36] = 127,
	[1][1][2][0][RTW89_KCC][36] = 127,
	[1][1][2][0][RTW89_ACMA][36] = 127,
	[1][1][2][0][RTW89_CN][36] = 127,
	[1][1][2][0][RTW89_UK][36] = 127,
	[1][1][2][0][RTW89_FCC][39] = 127,
	[1][1][2][0][RTW89_ETSI][39] = 127,
	[1][1][2][0][RTW89_MKK][39] = 127,
	[1][1][2][0][RTW89_IC][39] = 127,
	[1][1][2][0][RTW89_KCC][39] = 127,
	[1][1][2][0][RTW89_ACMA][39] = 127,
	[1][1][2][0][RTW89_CN][39] = 127,
	[1][1][2][0][RTW89_UK][39] = 127,
	[1][1][2][0][RTW89_FCC][43] = 127,
	[1][1][2][0][RTW89_ETSI][43] = 127,
	[1][1][2][0][RTW89_MKK][43] = 127,
	[1][1][2][0][RTW89_IC][43] = 127,
	[1][1][2][0][RTW89_KCC][43] = 127,
	[1][1][2][0][RTW89_ACMA][43] = 127,
	[1][1][2][0][RTW89_CN][43] = 127,
	[1][1][2][0][RTW89_UK][43] = 127,
	[1][1][2][0][RTW89_FCC][47] = 127,
	[1][1][2][0][RTW89_ETSI][47] = 127,
	[1][1][2][0][RTW89_MKK][47] = 127,
	[1][1][2][0][RTW89_IC][47] = 127,
	[1][1][2][0][RTW89_KCC][47] = 127,
	[1][1][2][0][RTW89_ACMA][47] = 127,
	[1][1][2][0][RTW89_CN][47] = 127,
	[1][1][2][0][RTW89_UK][47] = 127,
	[1][1][2][0][RTW89_FCC][51] = 127,
	[1][1][2][0][RTW89_ETSI][51] = 127,
	[1][1][2][0][RTW89_MKK][51] = 127,
	[1][1][2][0][RTW89_IC][51] = 127,
	[1][1][2][0][RTW89_KCC][51] = 127,
	[1][1][2][0][RTW89_ACMA][51] = 127,
	[1][1][2][0][RTW89_CN][51] = 127,
	[1][1][2][0][RTW89_UK][51] = 127,
	[1][1][2][1][RTW89_FCC][1] = 127,
	[1][1][2][1][RTW89_ETSI][1] = 127,
	[1][1][2][1][RTW89_MKK][1] = 127,
	[1][1][2][1][RTW89_IC][1] = 127,
	[1][1][2][1][RTW89_KCC][1] = 127,
	[1][1][2][1][RTW89_ACMA][1] = 127,
	[1][1][2][1][RTW89_CN][1] = 127,
	[1][1][2][1][RTW89_UK][1] = 127,
	[1][1][2][1][RTW89_FCC][5] = 127,
	[1][1][2][1][RTW89_ETSI][5] = 127,
	[1][1][2][1][RTW89_MKK][5] = 127,
	[1][1][2][1][RTW89_IC][5] = 127,
	[1][1][2][1][RTW89_KCC][5] = 127,
	[1][1][2][1][RTW89_ACMA][5] = 127,
	[1][1][2][1][RTW89_CN][5] = 127,
	[1][1][2][1][RTW89_UK][5] = 127,
	[1][1][2][1][RTW89_FCC][9] = 127,
	[1][1][2][1][RTW89_ETSI][9] = 127,
	[1][1][2][1][RTW89_MKK][9] = 127,
	[1][1][2][1][RTW89_IC][9] = 127,
	[1][1][2][1][RTW89_KCC][9] = 127,
	[1][1][2][1][RTW89_ACMA][9] = 127,
	[1][1][2][1][RTW89_CN][9] = 127,
	[1][1][2][1][RTW89_UK][9] = 127,
	[1][1][2][1][RTW89_FCC][13] = 127,
	[1][1][2][1][RTW89_ETSI][13] = 127,
	[1][1][2][1][RTW89_MKK][13] = 127,
	[1][1][2][1][RTW89_IC][13] = 127,
	[1][1][2][1][RTW89_KCC][13] = 127,
	[1][1][2][1][RTW89_ACMA][13] = 127,
	[1][1][2][1][RTW89_CN][13] = 127,
	[1][1][2][1][RTW89_UK][13] = 127,
	[1][1][2][1][RTW89_FCC][16] = 127,
	[1][1][2][1][RTW89_ETSI][16] = 127,
	[1][1][2][1][RTW89_MKK][16] = 127,
	[1][1][2][1][RTW89_IC][16] = 127,
	[1][1][2][1][RTW89_KCC][16] = 127,
	[1][1][2][1][RTW89_ACMA][16] = 127,
	[1][1][2][1][RTW89_CN][16] = 127,
	[1][1][2][1][RTW89_UK][16] = 127,
	[1][1][2][1][RTW89_FCC][20] = 127,
	[1][1][2][1][RTW89_ETSI][20] = 127,
	[1][1][2][1][RTW89_MKK][20] = 127,
	[1][1][2][1][RTW89_IC][20] = 127,
	[1][1][2][1][RTW89_KCC][20] = 127,
	[1][1][2][1][RTW89_ACMA][20] = 127,
	[1][1][2][1][RTW89_CN][20] = 127,
	[1][1][2][1][RTW89_UK][20] = 127,
	[1][1][2][1][RTW89_FCC][24] = 127,
	[1][1][2][1][RTW89_ETSI][24] = 127,
	[1][1][2][1][RTW89_MKK][24] = 127,
	[1][1][2][1][RTW89_IC][24] = 127,
	[1][1][2][1][RTW89_KCC][24] = 127,
	[1][1][2][1][RTW89_ACMA][24] = 127,
	[1][1][2][1][RTW89_CN][24] = 127,
	[1][1][2][1][RTW89_UK][24] = 127,
	[1][1][2][1][RTW89_FCC][28] = 127,
	[1][1][2][1][RTW89_ETSI][28] = 127,
	[1][1][2][1][RTW89_MKK][28] = 127,
	[1][1][2][1][RTW89_IC][28] = 127,
	[1][1][2][1][RTW89_KCC][28] = 127,
	[1][1][2][1][RTW89_ACMA][28] = 127,
	[1][1][2][1][RTW89_CN][28] = 127,
	[1][1][2][1][RTW89_UK][28] = 127,
	[1][1][2][1][RTW89_FCC][32] = 127,
	[1][1][2][1][RTW89_ETSI][32] = 127,
	[1][1][2][1][RTW89_MKK][32] = 127,
	[1][1][2][1][RTW89_IC][32] = 127,
	[1][1][2][1][RTW89_KCC][32] = 127,
	[1][1][2][1][RTW89_ACMA][32] = 127,
	[1][1][2][1][RTW89_CN][32] = 127,
	[1][1][2][1][RTW89_UK][32] = 127,
	[1][1][2][1][RTW89_FCC][36] = 127,
	[1][1][2][1][RTW89_ETSI][36] = 127,
	[1][1][2][1][RTW89_MKK][36] = 127,
	[1][1][2][1][RTW89_IC][36] = 127,
	[1][1][2][1][RTW89_KCC][36] = 127,
	[1][1][2][1][RTW89_ACMA][36] = 127,
	[1][1][2][1][RTW89_CN][36] = 127,
	[1][1][2][1][RTW89_UK][36] = 127,
	[1][1][2][1][RTW89_FCC][39] = 127,
	[1][1][2][1][RTW89_ETSI][39] = 127,
	[1][1][2][1][RTW89_MKK][39] = 127,
	[1][1][2][1][RTW89_IC][39] = 127,
	[1][1][2][1][RTW89_KCC][39] = 127,
	[1][1][2][1][RTW89_ACMA][39] = 127,
	[1][1][2][1][RTW89_CN][39] = 127,
	[1][1][2][1][RTW89_UK][39] = 127,
	[1][1][2][1][RTW89_FCC][43] = 127,
	[1][1][2][1][RTW89_ETSI][43] = 127,
	[1][1][2][1][RTW89_MKK][43] = 127,
	[1][1][2][1][RTW89_IC][43] = 127,
	[1][1][2][1][RTW89_KCC][43] = 127,
	[1][1][2][1][RTW89_ACMA][43] = 127,
	[1][1][2][1][RTW89_CN][43] = 127,
	[1][1][2][1][RTW89_UK][43] = 127,
	[1][1][2][1][RTW89_FCC][47] = 127,
	[1][1][2][1][RTW89_ETSI][47] = 127,
	[1][1][2][1][RTW89_MKK][47] = 127,
	[1][1][2][1][RTW89_IC][47] = 127,
	[1][1][2][1][RTW89_KCC][47] = 127,
	[1][1][2][1][RTW89_ACMA][47] = 127,
	[1][1][2][1][RTW89_CN][47] = 127,
	[1][1][2][1][RTW89_UK][47] = 127,
	[1][1][2][1][RTW89_FCC][51] = 127,
	[1][1][2][1][RTW89_ETSI][51] = 127,
	[1][1][2][1][RTW89_MKK][51] = 127,
	[1][1][2][1][RTW89_IC][51] = 127,
	[1][1][2][1][RTW89_KCC][51] = 127,
	[1][1][2][1][RTW89_ACMA][51] = 127,
	[1][1][2][1][RTW89_CN][51] = 127,
	[1][1][2][1][RTW89_UK][51] = 127,
	[2][0][2][0][RTW89_FCC][3] = 76,
	[2][0][2][0][RTW89_ETSI][3] = 64,
	[2][0][2][0][RTW89_MKK][3] = 62,
	[2][0][2][0][RTW89_IC][3] = 64,
	[2][0][2][0][RTW89_KCC][3] = 72,
	[2][0][2][0][RTW89_ACMA][3] = 64,
	[2][0][2][0][RTW89_CN][3] = 60,
	[2][0][2][0][RTW89_UK][3] = 64,
	[2][0][2][0][RTW89_FCC][11] = 64,
	[2][0][2][0][RTW89_ETSI][11] = 64,
	[2][0][2][0][RTW89_MKK][11] = 64,
	[2][0][2][0][RTW89_IC][11] = 62,
	[2][0][2][0][RTW89_KCC][11] = 72,
	[2][0][2][0][RTW89_ACMA][11] = 64,
	[2][0][2][0][RTW89_CN][11] = 56,
	[2][0][2][0][RTW89_UK][11] = 64,
	[2][0][2][0][RTW89_FCC][18] = 66,
	[2][0][2][0][RTW89_ETSI][18] = 64,
	[2][0][2][0][RTW89_MKK][18] = 72,
	[2][0][2][0][RTW89_IC][18] = 66,
	[2][0][2][0][RTW89_KCC][18] = 72,
	[2][0][2][0][RTW89_ACMA][18] = 64,
	[2][0][2][0][RTW89_CN][18] = 127,
	[2][0][2][0][RTW89_UK][18] = 64,
	[2][0][2][0][RTW89_FCC][26] = 76,
	[2][0][2][0][RTW89_ETSI][26] = 64,
	[2][0][2][0][RTW89_MKK][26] = 72,
	[2][0][2][0][RTW89_IC][26] = 127,
	[2][0][2][0][RTW89_KCC][26] = 72,
	[2][0][2][0][RTW89_ACMA][26] = 127,
	[2][0][2][0][RTW89_CN][26] = 127,
	[2][0][2][0][RTW89_UK][26] = 64,
	[2][0][2][0][RTW89_FCC][34] = 76,
	[2][0][2][0][RTW89_ETSI][34] = 127,
	[2][0][2][0][RTW89_MKK][34] = 72,
	[2][0][2][0][RTW89_IC][34] = 76,
	[2][0][2][0][RTW89_KCC][34] = 72,
	[2][0][2][0][RTW89_ACMA][34] = 72,
	[2][0][2][0][RTW89_CN][34] = 127,
	[2][0][2][0][RTW89_UK][34] = 72,
	[2][0][2][0][RTW89_FCC][41] = 76,
	[2][0][2][0][RTW89_ETSI][41] = 30,
	[2][0][2][0][RTW89_MKK][41] = 127,
	[2][0][2][0][RTW89_IC][41] = 76,
	[2][0][2][0][RTW89_KCC][41] = 64,
	[2][0][2][0][RTW89_ACMA][41] = 72,
	[2][0][2][0][RTW89_CN][41] = 40,
	[2][0][2][0][RTW89_UK][41] = 64,
	[2][0][2][0][RTW89_FCC][49] = 74,
	[2][0][2][0][RTW89_ETSI][49] = 127,
	[2][0][2][0][RTW89_MKK][49] = 127,
	[2][0][2][0][RTW89_IC][49] = 127,
	[2][0][2][0][RTW89_KCC][49] = 127,
	[2][0][2][0][RTW89_ACMA][49] = 127,
	[2][0][2][0][RTW89_CN][49] = 127,
	[2][0][2][0][RTW89_UK][49] = 127,
	[2][1][2][0][RTW89_FCC][3] = 127,
	[2][1][2][0][RTW89_ETSI][3] = 127,
	[2][1][2][0][RTW89_MKK][3] = 127,
	[2][1][2][0][RTW89_IC][3] = 127,
	[2][1][2][0][RTW89_KCC][3] = 127,
	[2][1][2][0][RTW89_ACMA][3] = 127,
	[2][1][2][0][RTW89_CN][3] = 127,
	[2][1][2][0][RTW89_UK][3] = 127,
	[2][1][2][0][RTW89_FCC][11] = 127,
	[2][1][2][0][RTW89_ETSI][11] = 127,
	[2][1][2][0][RTW89_MKK][11] = 127,
	[2][1][2][0][RTW89_IC][11] = 127,
	[2][1][2][0][RTW89_KCC][11] = 127,
	[2][1][2][0][RTW89_ACMA][11] = 127,
	[2][1][2][0][RTW89_CN][11] = 127,
	[2][1][2][0][RTW89_UK][11] = 127,
	[2][1][2][0][RTW89_FCC][18] = 127,
	[2][1][2][0][RTW89_ETSI][18] = 127,
	[2][1][2][0][RTW89_MKK][18] = 127,
	[2][1][2][0][RTW89_IC][18] = 127,
	[2][1][2][0][RTW89_KCC][18] = 127,
	[2][1][2][0][RTW89_ACMA][18] = 127,
	[2][1][2][0][RTW89_CN][18] = 127,
	[2][1][2][0][RTW89_UK][18] = 127,
	[2][1][2][0][RTW89_FCC][26] = 127,
	[2][1][2][0][RTW89_ETSI][26] = 127,
	[2][1][2][0][RTW89_MKK][26] = 127,
	[2][1][2][0][RTW89_IC][26] = 127,
	[2][1][2][0][RTW89_KCC][26] = 127,
	[2][1][2][0][RTW89_ACMA][26] = 127,
	[2][1][2][0][RTW89_CN][26] = 127,
	[2][1][2][0][RTW89_UK][26] = 127,
	[2][1][2][0][RTW89_FCC][34] = 127,
	[2][1][2][0][RTW89_ETSI][34] = 127,
	[2][1][2][0][RTW89_MKK][34] = 127,
	[2][1][2][0][RTW89_IC][34] = 127,
	[2][1][2][0][RTW89_KCC][34] = 127,
	[2][1][2][0][RTW89_ACMA][34] = 127,
	[2][1][2][0][RTW89_CN][34] = 127,
	[2][1][2][0][RTW89_UK][34] = 127,
	[2][1][2][0][RTW89_FCC][41] = 127,
	[2][1][2][0][RTW89_ETSI][41] = 127,
	[2][1][2][0][RTW89_MKK][41] = 127,
	[2][1][2][0][RTW89_IC][41] = 127,
	[2][1][2][0][RTW89_KCC][41] = 127,
	[2][1][2][0][RTW89_ACMA][41] = 127,
	[2][1][2][0][RTW89_CN][41] = 127,
	[2][1][2][0][RTW89_UK][41] = 127,
	[2][1][2][0][RTW89_FCC][49] = 127,
	[2][1][2][0][RTW89_ETSI][49] = 127,
	[2][1][2][0][RTW89_MKK][49] = 127,
	[2][1][2][0][RTW89_IC][49] = 127,
	[2][1][2][0][RTW89_KCC][49] = 127,
	[2][1][2][0][RTW89_ACMA][49] = 127,
	[2][1][2][0][RTW89_CN][49] = 127,
	[2][1][2][0][RTW89_UK][49] = 127,
	[2][1][2][1][RTW89_FCC][3] = 127,
	[2][1][2][1][RTW89_ETSI][3] = 127,
	[2][1][2][1][RTW89_MKK][3] = 127,
	[2][1][2][1][RTW89_IC][3] = 127,
	[2][1][2][1][RTW89_KCC][3] = 127,
	[2][1][2][1][RTW89_ACMA][3] = 127,
	[2][1][2][1][RTW89_CN][3] = 127,
	[2][1][2][1][RTW89_UK][3] = 127,
	[2][1][2][1][RTW89_FCC][11] = 127,
	[2][1][2][1][RTW89_ETSI][11] = 127,
	[2][1][2][1][RTW89_MKK][11] = 127,
	[2][1][2][1][RTW89_IC][11] = 127,
	[2][1][2][1][RTW89_KCC][11] = 127,
	[2][1][2][1][RTW89_ACMA][11] = 127,
	[2][1][2][1][RTW89_CN][11] = 127,
	[2][1][2][1][RTW89_UK][11] = 127,
	[2][1][2][1][RTW89_FCC][18] = 127,
	[2][1][2][1][RTW89_ETSI][18] = 127,
	[2][1][2][1][RTW89_MKK][18] = 127,
	[2][1][2][1][RTW89_IC][18] = 127,
	[2][1][2][1][RTW89_KCC][18] = 127,
	[2][1][2][1][RTW89_ACMA][18] = 127,
	[2][1][2][1][RTW89_CN][18] = 127,
	[2][1][2][1][RTW89_UK][18] = 127,
	[2][1][2][1][RTW89_FCC][26] = 127,
	[2][1][2][1][RTW89_ETSI][26] = 127,
	[2][1][2][1][RTW89_MKK][26] = 127,
	[2][1][2][1][RTW89_IC][26] = 127,
	[2][1][2][1][RTW89_KCC][26] = 127,
	[2][1][2][1][RTW89_ACMA][26] = 127,
	[2][1][2][1][RTW89_CN][26] = 127,
	[2][1][2][1][RTW89_UK][26] = 127,
	[2][1][2][1][RTW89_FCC][34] = 127,
	[2][1][2][1][RTW89_ETSI][34] = 127,
	[2][1][2][1][RTW89_MKK][34] = 127,
	[2][1][2][1][RTW89_IC][34] = 127,
	[2][1][2][1][RTW89_KCC][34] = 127,
	[2][1][2][1][RTW89_ACMA][34] = 127,
	[2][1][2][1][RTW89_CN][34] = 127,
	[2][1][2][1][RTW89_UK][34] = 127,
	[2][1][2][1][RTW89_FCC][41] = 127,
	[2][1][2][1][RTW89_ETSI][41] = 127,
	[2][1][2][1][RTW89_MKK][41] = 127,
	[2][1][2][1][RTW89_IC][41] = 127,
	[2][1][2][1][RTW89_KCC][41] = 127,
	[2][1][2][1][RTW89_ACMA][41] = 127,
	[2][1][2][1][RTW89_CN][41] = 127,
	[2][1][2][1][RTW89_UK][41] = 127,
	[2][1][2][1][RTW89_FCC][49] = 127,
	[2][1][2][1][RTW89_ETSI][49] = 127,
	[2][1][2][1][RTW89_MKK][49] = 127,
	[2][1][2][1][RTW89_IC][49] = 127,
	[2][1][2][1][RTW89_KCC][49] = 127,
	[2][1][2][1][RTW89_ACMA][49] = 127,
	[2][1][2][1][RTW89_CN][49] = 127,
	[2][1][2][1][RTW89_UK][49] = 127,
	[3][0][2][0][RTW89_FCC][7] = 127,
	[3][0][2][0][RTW89_ETSI][7] = 127,
	[3][0][2][0][RTW89_MKK][7] = 127,
	[3][0][2][0][RTW89_IC][7] = 127,
	[3][0][2][0][RTW89_KCC][7] = 127,
	[3][0][2][0][RTW89_ACMA][7] = 127,
	[3][0][2][0][RTW89_CN][7] = 127,
	[3][0][2][0][RTW89_UK][7] = 127,
	[3][0][2][0][RTW89_FCC][22] = 127,
	[3][0][2][0][RTW89_ETSI][22] = 127,
	[3][0][2][0][RTW89_MKK][22] = 127,
	[3][0][2][0][RTW89_IC][22] = 127,
	[3][0][2][0][RTW89_KCC][22] = 127,
	[3][0][2][0][RTW89_ACMA][22] = 127,
	[3][0][2][0][RTW89_CN][22] = 127,
	[3][0][2][0][RTW89_UK][22] = 127,
	[3][0][2][0][RTW89_FCC][45] = 127,
	[3][0][2][0][RTW89_ETSI][45] = 127,
	[3][0][2][0][RTW89_MKK][45] = 127,
	[3][0][2][0][RTW89_IC][45] = 127,
	[3][0][2][0][RTW89_KCC][45] = 127,
	[3][0][2][0][RTW89_ACMA][45] = 127,
	[3][0][2][0][RTW89_CN][45] = 127,
	[3][0][2][0][RTW89_UK][45] = 127,
	[3][1][2][0][RTW89_FCC][7] = 127,
	[3][1][2][0][RTW89_ETSI][7] = 127,
	[3][1][2][0][RTW89_MKK][7] = 127,
	[3][1][2][0][RTW89_IC][7] = 127,
	[3][1][2][0][RTW89_KCC][7] = 127,
	[3][1][2][0][RTW89_ACMA][7] = 127,
	[3][1][2][0][RTW89_CN][7] = 127,
	[3][1][2][0][RTW89_UK][7] = 127,
	[3][1][2][0][RTW89_FCC][22] = 127,
	[3][1][2][0][RTW89_ETSI][22] = 127,
	[3][1][2][0][RTW89_MKK][22] = 127,
	[3][1][2][0][RTW89_IC][22] = 127,
	[3][1][2][0][RTW89_KCC][22] = 127,
	[3][1][2][0][RTW89_ACMA][22] = 127,
	[3][1][2][0][RTW89_CN][22] = 127,
	[3][1][2][0][RTW89_UK][22] = 127,
	[3][1][2][0][RTW89_FCC][45] = 127,
	[3][1][2][0][RTW89_ETSI][45] = 127,
	[3][1][2][0][RTW89_MKK][45] = 127,
	[3][1][2][0][RTW89_IC][45] = 127,
	[3][1][2][0][RTW89_KCC][45] = 127,
	[3][1][2][0][RTW89_ACMA][45] = 127,
	[3][1][2][0][RTW89_CN][45] = 127,
	[3][1][2][0][RTW89_UK][45] = 127,
	[3][1][2][1][RTW89_FCC][7] = 127,
	[3][1][2][1][RTW89_ETSI][7] = 127,
	[3][1][2][1][RTW89_MKK][7] = 127,
	[3][1][2][1][RTW89_IC][7] = 127,
	[3][1][2][1][RTW89_KCC][7] = 127,
	[3][1][2][1][RTW89_ACMA][7] = 127,
	[3][1][2][1][RTW89_CN][7] = 127,
	[3][1][2][1][RTW89_UK][7] = 127,
	[3][1][2][1][RTW89_FCC][22] = 127,
	[3][1][2][1][RTW89_ETSI][22] = 127,
	[3][1][2][1][RTW89_MKK][22] = 127,
	[3][1][2][1][RTW89_IC][22] = 127,
	[3][1][2][1][RTW89_KCC][22] = 127,
	[3][1][2][1][RTW89_ACMA][22] = 127,
	[3][1][2][1][RTW89_CN][22] = 127,
	[3][1][2][1][RTW89_UK][22] = 127,
	[3][1][2][1][RTW89_FCC][45] = 127,
	[3][1][2][1][RTW89_ETSI][45] = 127,
	[3][1][2][1][RTW89_MKK][45] = 127,
	[3][1][2][1][RTW89_IC][45] = 127,
	[3][1][2][1][RTW89_KCC][45] = 127,
	[3][1][2][1][RTW89_ACMA][45] = 127,
	[3][1][2][1][RTW89_CN][45] = 127,
	[3][1][2][1][RTW89_UK][45] = 127,
};

static
const s8 rtw89_8851b_txpwr_lmt_ru_2g[RTW89_RU_NUM][RTW89_NTX_NUM]
				    [RTW89_REGD_NUM][RTW89_2G_CH_NUM] = {
	[0][0][RTW89_WW][0] = 30,
	[0][0][RTW89_WW][1] = 30,
	[0][0][RTW89_WW][2] = 30,
	[0][0][RTW89_WW][3] = 30,
	[0][0][RTW89_WW][4] = 30,
	[0][0][RTW89_WW][5] = 30,
	[0][0][RTW89_WW][6] = 30,
	[0][0][RTW89_WW][7] = 30,
	[0][0][RTW89_WW][8] = 30,
	[0][0][RTW89_WW][9] = 30,
	[0][0][RTW89_WW][10] = 30,
	[0][0][RTW89_WW][11] = 30,
	[0][0][RTW89_WW][12] = 30,
	[0][0][RTW89_WW][13] = 0,
	[0][1][RTW89_WW][0] = 0,
	[0][1][RTW89_WW][1] = 0,
	[0][1][RTW89_WW][2] = 0,
	[0][1][RTW89_WW][3] = 0,
	[0][1][RTW89_WW][4] = 0,
	[0][1][RTW89_WW][5] = 0,
	[0][1][RTW89_WW][6] = 0,
	[0][1][RTW89_WW][7] = 0,
	[0][1][RTW89_WW][8] = 0,
	[0][1][RTW89_WW][9] = 0,
	[0][1][RTW89_WW][10] = 0,
	[0][1][RTW89_WW][11] = 0,
	[0][1][RTW89_WW][12] = 0,
	[0][1][RTW89_WW][13] = 0,
	[1][0][RTW89_WW][0] = 42,
	[1][0][RTW89_WW][1] = 42,
	[1][0][RTW89_WW][2] = 42,
	[1][0][RTW89_WW][3] = 42,
	[1][0][RTW89_WW][4] = 42,
	[1][0][RTW89_WW][5] = 42,
	[1][0][RTW89_WW][6] = 42,
	[1][0][RTW89_WW][7] = 42,
	[1][0][RTW89_WW][8] = 42,
	[1][0][RTW89_WW][9] = 42,
	[1][0][RTW89_WW][10] = 42,
	[1][0][RTW89_WW][11] = 42,
	[1][0][RTW89_WW][12] = 34,
	[1][0][RTW89_WW][13] = 0,
	[1][1][RTW89_WW][0] = 0,
	[1][1][RTW89_WW][1] = 0,
	[1][1][RTW89_WW][2] = 0,
	[1][1][RTW89_WW][3] = 0,
	[1][1][RTW89_WW][4] = 0,
	[1][1][RTW89_WW][5] = 0,
	[1][1][RTW89_WW][6] = 0,
	[1][1][RTW89_WW][7] = 0,
	[1][1][RTW89_WW][8] = 0,
	[1][1][RTW89_WW][9] = 0,
	[1][1][RTW89_WW][10] = 0,
	[1][1][RTW89_WW][11] = 0,
	[1][1][RTW89_WW][12] = 0,
	[1][1][RTW89_WW][13] = 0,
	[2][0][RTW89_WW][0] = 54,
	[2][0][RTW89_WW][1] = 54,
	[2][0][RTW89_WW][2] = 54,
	[2][0][RTW89_WW][3] = 54,
	[2][0][RTW89_WW][4] = 54,
	[2][0][RTW89_WW][5] = 54,
	[2][0][RTW89_WW][6] = 54,
	[2][0][RTW89_WW][7] = 54,
	[2][0][RTW89_WW][8] = 54,
	[2][0][RTW89_WW][9] = 54,
	[2][0][RTW89_WW][10] = 54,
	[2][0][RTW89_WW][11] = 54,
	[2][0][RTW89_WW][12] = 34,
	[2][0][RTW89_WW][13] = 0,
	[2][1][RTW89_WW][0] = 0,
	[2][1][RTW89_WW][1] = 0,
	[2][1][RTW89_WW][2] = 0,
	[2][1][RTW89_WW][3] = 0,
	[2][1][RTW89_WW][4] = 0,
	[2][1][RTW89_WW][5] = 0,
	[2][1][RTW89_WW][6] = 0,
	[2][1][RTW89_WW][7] = 0,
	[2][1][RTW89_WW][8] = 0,
	[2][1][RTW89_WW][9] = 0,
	[2][1][RTW89_WW][10] = 0,
	[2][1][RTW89_WW][11] = 0,
	[2][1][RTW89_WW][12] = 0,
	[2][1][RTW89_WW][13] = 0,
	[0][0][RTW89_FCC][0] = 62,
	[0][0][RTW89_ETSI][0] = 30,
	[0][0][RTW89_MKK][0] = 40,
	[0][0][RTW89_IC][0] = 62,
	[0][0][RTW89_KCC][0] = 46,
	[0][0][RTW89_ACMA][0] = 30,
	[0][0][RTW89_CN][0] = 32,
	[0][0][RTW89_UK][0] = 30,
	[0][0][RTW89_FCC][1] = 62,
	[0][0][RTW89_ETSI][1] = 30,
	[0][0][RTW89_MKK][1] = 44,
	[0][0][RTW89_IC][1] = 62,
	[0][0][RTW89_KCC][1] = 46,
	[0][0][RTW89_ACMA][1] = 30,
	[0][0][RTW89_CN][1] = 32,
	[0][0][RTW89_UK][1] = 30,
	[0][0][RTW89_FCC][2] = 66,
	[0][0][RTW89_ETSI][2] = 30,
	[0][0][RTW89_MKK][2] = 44,
	[0][0][RTW89_IC][2] = 66,
	[0][0][RTW89_KCC][2] = 46,
	[0][0][RTW89_ACMA][2] = 30,
	[0][0][RTW89_CN][2] = 32,
	[0][0][RTW89_UK][2] = 30,
	[0][0][RTW89_FCC][3] = 70,
	[0][0][RTW89_ETSI][3] = 30,
	[0][0][RTW89_MKK][3] = 44,
	[0][0][RTW89_IC][3] = 70,
	[0][0][RTW89_KCC][3] = 46,
	[0][0][RTW89_ACMA][3] = 30,
	[0][0][RTW89_CN][3] = 32,
	[0][0][RTW89_UK][3] = 30,
	[0][0][RTW89_FCC][4] = 70,
	[0][0][RTW89_ETSI][4] = 30,
	[0][0][RTW89_MKK][4] = 44,
	[0][0][RTW89_IC][4] = 70,
	[0][0][RTW89_KCC][4] = 48,
	[0][0][RTW89_ACMA][4] = 30,
	[0][0][RTW89_CN][4] = 32,
	[0][0][RTW89_UK][4] = 30,
	[0][0][RTW89_FCC][5] = 84,
	[0][0][RTW89_ETSI][5] = 30,
	[0][0][RTW89_MKK][5] = 44,
	[0][0][RTW89_IC][5] = 84,
	[0][0][RTW89_KCC][5] = 48,
	[0][0][RTW89_ACMA][5] = 30,
	[0][0][RTW89_CN][5] = 32,
	[0][0][RTW89_UK][5] = 30,
	[0][0][RTW89_FCC][6] = 66,
	[0][0][RTW89_ETSI][6] = 30,
	[0][0][RTW89_MKK][6] = 44,
	[0][0][RTW89_IC][6] = 66,
	[0][0][RTW89_KCC][6] = 48,
	[0][0][RTW89_ACMA][6] = 30,
	[0][0][RTW89_CN][6] = 32,
	[0][0][RTW89_UK][6] = 30,
	[0][0][RTW89_FCC][7] = 66,
	[0][0][RTW89_ETSI][7] = 30,
	[0][0][RTW89_MKK][7] = 44,
	[0][0][RTW89_IC][7] = 66,
	[0][0][RTW89_KCC][7] = 48,
	[0][0][RTW89_ACMA][7] = 30,
	[0][0][RTW89_CN][7] = 32,
	[0][0][RTW89_UK][7] = 30,
	[0][0][RTW89_FCC][8] = 62,
	[0][0][RTW89_ETSI][8] = 30,
	[0][0][RTW89_MKK][8] = 44,
	[0][0][RTW89_IC][8] = 62,
	[0][0][RTW89_KCC][8] = 48,
	[0][0][RTW89_ACMA][8] = 30,
	[0][0][RTW89_CN][8] = 32,
	[0][0][RTW89_UK][8] = 30,
	[0][0][RTW89_FCC][9] = 58,
	[0][0][RTW89_ETSI][9] = 30,
	[0][0][RTW89_MKK][9] = 44,
	[0][0][RTW89_IC][9] = 58,
	[0][0][RTW89_KCC][9] = 44,
	[0][0][RTW89_ACMA][9] = 30,
	[0][0][RTW89_CN][9] = 32,
	[0][0][RTW89_UK][9] = 30,
	[0][0][RTW89_FCC][10] = 58,
	[0][0][RTW89_ETSI][10] = 30,
	[0][0][RTW89_MKK][10] = 44,
	[0][0][RTW89_IC][10] = 58,
	[0][0][RTW89_KCC][10] = 44,
	[0][0][RTW89_ACMA][10] = 30,
	[0][0][RTW89_CN][10] = 32,
	[0][0][RTW89_UK][10] = 30,
	[0][0][RTW89_FCC][11] = 54,
	[0][0][RTW89_ETSI][11] = 30,
	[0][0][RTW89_MKK][11] = 44,
	[0][0][RTW89_IC][11] = 54,
	[0][0][RTW89_KCC][11] = 44,
	[0][0][RTW89_ACMA][11] = 30,
	[0][0][RTW89_CN][11] = 32,
	[0][0][RTW89_UK][11] = 30,
	[0][0][RTW89_FCC][12] = 36,
	[0][0][RTW89_ETSI][12] = 30,
	[0][0][RTW89_MKK][12] = 40,
	[0][0][RTW89_IC][12] = 36,
	[0][0][RTW89_KCC][12] = 44,
	[0][0][RTW89_ACMA][12] = 30,
	[0][0][RTW89_CN][12] = 32,
	[0][0][RTW89_UK][12] = 30,
	[0][0][RTW89_FCC][13] = 127,
	[0][0][RTW89_ETSI][13] = 127,
	[0][0][RTW89_MKK][13] = 127,
	[0][0][RTW89_IC][13] = 127,
	[0][0][RTW89_KCC][13] = 127,
	[0][0][RTW89_ACMA][13] = 127,
	[0][0][RTW89_CN][13] = 127,
	[0][0][RTW89_UK][13] = 127,
	[0][1][RTW89_FCC][0] = 127,
	[0][1][RTW89_ETSI][0] = 127,
	[0][1][RTW89_MKK][0] = 127,
	[0][1][RTW89_IC][0] = 127,
	[0][1][RTW89_KCC][0] = 127,
	[0][1][RTW89_ACMA][0] = 127,
	[0][1][RTW89_CN][0] = 127,
	[0][1][RTW89_UK][0] = 127,
	[0][1][RTW89_FCC][1] = 127,
	[0][1][RTW89_ETSI][1] = 127,
	[0][1][RTW89_MKK][1] = 127,
	[0][1][RTW89_IC][1] = 127,
	[0][1][RTW89_KCC][1] = 127,
	[0][1][RTW89_ACMA][1] = 127,
	[0][1][RTW89_CN][1] = 127,
	[0][1][RTW89_UK][1] = 127,
	[0][1][RTW89_FCC][2] = 127,
	[0][1][RTW89_ETSI][2] = 127,
	[0][1][RTW89_MKK][2] = 127,
	[0][1][RTW89_IC][2] = 127,
	[0][1][RTW89_KCC][2] = 127,
	[0][1][RTW89_ACMA][2] = 127,
	[0][1][RTW89_CN][2] = 127,
	[0][1][RTW89_UK][2] = 127,
	[0][1][RTW89_FCC][3] = 127,
	[0][1][RTW89_ETSI][3] = 127,
	[0][1][RTW89_MKK][3] = 127,
	[0][1][RTW89_IC][3] = 127,
	[0][1][RTW89_KCC][3] = 127,
	[0][1][RTW89_ACMA][3] = 127,
	[0][1][RTW89_CN][3] = 127,
	[0][1][RTW89_UK][3] = 127,
	[0][1][RTW89_FCC][4] = 127,
	[0][1][RTW89_ETSI][4] = 127,
	[0][1][RTW89_MKK][4] = 127,
	[0][1][RTW89_IC][4] = 127,
	[0][1][RTW89_KCC][4] = 127,
	[0][1][RTW89_ACMA][4] = 127,
	[0][1][RTW89_CN][4] = 127,
	[0][1][RTW89_UK][4] = 127,
	[0][1][RTW89_FCC][5] = 127,
	[0][1][RTW89_ETSI][5] = 127,
	[0][1][RTW89_MKK][5] = 127,
	[0][1][RTW89_IC][5] = 127,
	[0][1][RTW89_KCC][5] = 127,
	[0][1][RTW89_ACMA][5] = 127,
	[0][1][RTW89_CN][5] = 127,
	[0][1][RTW89_UK][5] = 127,
	[0][1][RTW89_FCC][6] = 127,
	[0][1][RTW89_ETSI][6] = 127,
	[0][1][RTW89_MKK][6] = 127,
	[0][1][RTW89_IC][6] = 127,
	[0][1][RTW89_KCC][6] = 127,
	[0][1][RTW89_ACMA][6] = 127,
	[0][1][RTW89_CN][6] = 127,
	[0][1][RTW89_UK][6] = 127,
	[0][1][RTW89_FCC][7] = 127,
	[0][1][RTW89_ETSI][7] = 127,
	[0][1][RTW89_MKK][7] = 127,
	[0][1][RTW89_IC][7] = 127,
	[0][1][RTW89_KCC][7] = 127,
	[0][1][RTW89_ACMA][7] = 127,
	[0][1][RTW89_CN][7] = 127,
	[0][1][RTW89_UK][7] = 127,
	[0][1][RTW89_FCC][8] = 127,
	[0][1][RTW89_ETSI][8] = 127,
	[0][1][RTW89_MKK][8] = 127,
	[0][1][RTW89_IC][8] = 127,
	[0][1][RTW89_KCC][8] = 127,
	[0][1][RTW89_ACMA][8] = 127,
	[0][1][RTW89_CN][8] = 127,
	[0][1][RTW89_UK][8] = 127,
	[0][1][RTW89_FCC][9] = 127,
	[0][1][RTW89_ETSI][9] = 127,
	[0][1][RTW89_MKK][9] = 127,
	[0][1][RTW89_IC][9] = 127,
	[0][1][RTW89_KCC][9] = 127,
	[0][1][RTW89_ACMA][9] = 127,
	[0][1][RTW89_CN][9] = 127,
	[0][1][RTW89_UK][9] = 127,
	[0][1][RTW89_FCC][10] = 127,
	[0][1][RTW89_ETSI][10] = 127,
	[0][1][RTW89_MKK][10] = 127,
	[0][1][RTW89_IC][10] = 127,
	[0][1][RTW89_KCC][10] = 127,
	[0][1][RTW89_ACMA][10] = 127,
	[0][1][RTW89_CN][10] = 127,
	[0][1][RTW89_UK][10] = 127,
	[0][1][RTW89_FCC][11] = 127,
	[0][1][RTW89_ETSI][11] = 127,
	[0][1][RTW89_MKK][11] = 127,
	[0][1][RTW89_IC][11] = 127,
	[0][1][RTW89_KCC][11] = 127,
	[0][1][RTW89_ACMA][11] = 127,
	[0][1][RTW89_CN][11] = 127,
	[0][1][RTW89_UK][11] = 127,
	[0][1][RTW89_FCC][12] = 127,
	[0][1][RTW89_ETSI][12] = 127,
	[0][1][RTW89_MKK][12] = 127,
	[0][1][RTW89_IC][12] = 127,
	[0][1][RTW89_KCC][12] = 127,
	[0][1][RTW89_ACMA][12] = 127,
	[0][1][RTW89_CN][12] = 127,
	[0][1][RTW89_UK][12] = 127,
	[0][1][RTW89_FCC][13] = 127,
	[0][1][RTW89_ETSI][13] = 127,
	[0][1][RTW89_MKK][13] = 127,
	[0][1][RTW89_IC][13] = 127,
	[0][1][RTW89_KCC][13] = 127,
	[0][1][RTW89_ACMA][13] = 127,
	[0][1][RTW89_CN][13] = 127,
	[0][1][RTW89_UK][13] = 127,
	[1][0][RTW89_FCC][0] = 70,
	[1][0][RTW89_ETSI][0] = 42,
	[1][0][RTW89_MKK][0] = 52,
	[1][0][RTW89_IC][0] = 70,
	[1][0][RTW89_KCC][0] = 56,
	[1][0][RTW89_ACMA][0] = 42,
	[1][0][RTW89_CN][0] = 42,
	[1][0][RTW89_UK][0] = 42,
	[1][0][RTW89_FCC][1] = 70,
	[1][0][RTW89_ETSI][1] = 42,
	[1][0][RTW89_MKK][1] = 52,
	[1][0][RTW89_IC][1] = 70,
	[1][0][RTW89_KCC][1] = 56,
	[1][0][RTW89_ACMA][1] = 42,
	[1][0][RTW89_CN][1] = 44,
	[1][0][RTW89_UK][1] = 42,
	[1][0][RTW89_FCC][2] = 74,
	[1][0][RTW89_ETSI][2] = 42,
	[1][0][RTW89_MKK][2] = 52,
	[1][0][RTW89_IC][2] = 74,
	[1][0][RTW89_KCC][2] = 56,
	[1][0][RTW89_ACMA][2] = 42,
	[1][0][RTW89_CN][2] = 44,
	[1][0][RTW89_UK][2] = 42,
	[1][0][RTW89_FCC][3] = 76,
	[1][0][RTW89_ETSI][3] = 42,
	[1][0][RTW89_MKK][3] = 52,
	[1][0][RTW89_IC][3] = 76,
	[1][0][RTW89_KCC][3] = 56,
	[1][0][RTW89_ACMA][3] = 42,
	[1][0][RTW89_CN][3] = 44,
	[1][0][RTW89_UK][3] = 42,
	[1][0][RTW89_FCC][4] = 76,
	[1][0][RTW89_ETSI][4] = 42,
	[1][0][RTW89_MKK][4] = 52,
	[1][0][RTW89_IC][4] = 76,
	[1][0][RTW89_KCC][4] = 56,
	[1][0][RTW89_ACMA][4] = 42,
	[1][0][RTW89_CN][4] = 44,
	[1][0][RTW89_UK][4] = 42,
	[1][0][RTW89_FCC][5] = 82,
	[1][0][RTW89_ETSI][5] = 42,
	[1][0][RTW89_MKK][5] = 52,
	[1][0][RTW89_IC][5] = 82,
	[1][0][RTW89_KCC][5] = 56,
	[1][0][RTW89_ACMA][5] = 42,
	[1][0][RTW89_CN][5] = 44,
	[1][0][RTW89_UK][5] = 42,
	[1][0][RTW89_FCC][6] = 74,
	[1][0][RTW89_ETSI][6] = 42,
	[1][0][RTW89_MKK][6] = 52,
	[1][0][RTW89_IC][6] = 74,
	[1][0][RTW89_KCC][6] = 56,
	[1][0][RTW89_ACMA][6] = 42,
	[1][0][RTW89_CN][6] = 44,
	[1][0][RTW89_UK][6] = 42,
	[1][0][RTW89_FCC][7] = 74,
	[1][0][RTW89_ETSI][7] = 42,
	[1][0][RTW89_MKK][7] = 52,
	[1][0][RTW89_IC][7] = 74,
	[1][0][RTW89_KCC][7] = 56,
	[1][0][RTW89_ACMA][7] = 42,
	[1][0][RTW89_CN][7] = 44,
	[1][0][RTW89_UK][7] = 42,
	[1][0][RTW89_FCC][8] = 74,
	[1][0][RTW89_ETSI][8] = 42,
	[1][0][RTW89_MKK][8] = 52,
	[1][0][RTW89_IC][8] = 74,
	[1][0][RTW89_KCC][8] = 56,
	[1][0][RTW89_ACMA][8] = 42,
	[1][0][RTW89_CN][8] = 44,
	[1][0][RTW89_UK][8] = 42,
	[1][0][RTW89_FCC][9] = 70,
	[1][0][RTW89_ETSI][9] = 42,
	[1][0][RTW89_MKK][9] = 52,
	[1][0][RTW89_IC][9] = 70,
	[1][0][RTW89_KCC][9] = 58,
	[1][0][RTW89_ACMA][9] = 42,
	[1][0][RTW89_CN][9] = 44,
	[1][0][RTW89_UK][9] = 42,
	[1][0][RTW89_FCC][10] = 70,
	[1][0][RTW89_ETSI][10] = 42,
	[1][0][RTW89_MKK][10] = 52,
	[1][0][RTW89_IC][10] = 70,
	[1][0][RTW89_KCC][10] = 58,
	[1][0][RTW89_ACMA][10] = 42,
	[1][0][RTW89_CN][10] = 44,
	[1][0][RTW89_UK][10] = 42,
	[1][0][RTW89_FCC][11] = 66,
	[1][0][RTW89_ETSI][11] = 42,
	[1][0][RTW89_MKK][11] = 52,
	[1][0][RTW89_IC][11] = 66,
	[1][0][RTW89_KCC][11] = 58,
	[1][0][RTW89_ACMA][11] = 42,
	[1][0][RTW89_CN][11] = 44,
	[1][0][RTW89_UK][11] = 42,
	[1][0][RTW89_FCC][12] = 34,
	[1][0][RTW89_ETSI][12] = 42,
	[1][0][RTW89_MKK][12] = 52,
	[1][0][RTW89_IC][12] = 34,
	[1][0][RTW89_KCC][12] = 58,
	[1][0][RTW89_ACMA][12] = 42,
	[1][0][RTW89_CN][12] = 42,
	[1][0][RTW89_UK][12] = 42,
	[1][0][RTW89_FCC][13] = 127,
	[1][0][RTW89_ETSI][13] = 127,
	[1][0][RTW89_MKK][13] = 127,
	[1][0][RTW89_IC][13] = 127,
	[1][0][RTW89_KCC][13] = 127,
	[1][0][RTW89_ACMA][13] = 127,
	[1][0][RTW89_CN][13] = 127,
	[1][0][RTW89_UK][13] = 127,
	[1][1][RTW89_FCC][0] = 127,
	[1][1][RTW89_ETSI][0] = 127,
	[1][1][RTW89_MKK][0] = 127,
	[1][1][RTW89_IC][0] = 127,
	[1][1][RTW89_KCC][0] = 127,
	[1][1][RTW89_ACMA][0] = 127,
	[1][1][RTW89_CN][0] = 127,
	[1][1][RTW89_UK][0] = 127,
	[1][1][RTW89_FCC][1] = 127,
	[1][1][RTW89_ETSI][1] = 127,
	[1][1][RTW89_MKK][1] = 127,
	[1][1][RTW89_IC][1] = 127,
	[1][1][RTW89_KCC][1] = 127,
	[1][1][RTW89_ACMA][1] = 127,
	[1][1][RTW89_CN][1] = 127,
	[1][1][RTW89_UK][1] = 127,
	[1][1][RTW89_FCC][2] = 127,
	[1][1][RTW89_ETSI][2] = 127,
	[1][1][RTW89_MKK][2] = 127,
	[1][1][RTW89_IC][2] = 127,
	[1][1][RTW89_KCC][2] = 127,
	[1][1][RTW89_ACMA][2] = 127,
	[1][1][RTW89_CN][2] = 127,
	[1][1][RTW89_UK][2] = 127,
	[1][1][RTW89_FCC][3] = 127,
	[1][1][RTW89_ETSI][3] = 127,
	[1][1][RTW89_MKK][3] = 127,
	[1][1][RTW89_IC][3] = 127,
	[1][1][RTW89_KCC][3] = 127,
	[1][1][RTW89_ACMA][3] = 127,
	[1][1][RTW89_CN][3] = 127,
	[1][1][RTW89_UK][3] = 127,
	[1][1][RTW89_FCC][4] = 127,
	[1][1][RTW89_ETSI][4] = 127,
	[1][1][RTW89_MKK][4] = 127,
	[1][1][RTW89_IC][4] = 127,
	[1][1][RTW89_KCC][4] = 127,
	[1][1][RTW89_ACMA][4] = 127,
	[1][1][RTW89_CN][4] = 127,
	[1][1][RTW89_UK][4] = 127,
	[1][1][RTW89_FCC][5] = 127,
	[1][1][RTW89_ETSI][5] = 127,
	[1][1][RTW89_MKK][5] = 127,
	[1][1][RTW89_IC][5] = 127,
	[1][1][RTW89_KCC][5] = 127,
	[1][1][RTW89_ACMA][5] = 127,
	[1][1][RTW89_CN][5] = 127,
	[1][1][RTW89_UK][5] = 127,
	[1][1][RTW89_FCC][6] = 127,
	[1][1][RTW89_ETSI][6] = 127,
	[1][1][RTW89_MKK][6] = 127,
	[1][1][RTW89_IC][6] = 127,
	[1][1][RTW89_KCC][6] = 127,
	[1][1][RTW89_ACMA][6] = 127,
	[1][1][RTW89_CN][6] = 127,
	[1][1][RTW89_UK][6] = 127,
	[1][1][RTW89_FCC][7] = 127,
	[1][1][RTW89_ETSI][7] = 127,
	[1][1][RTW89_MKK][7] = 127,
	[1][1][RTW89_IC][7] = 127,
	[1][1][RTW89_KCC][7] = 127,
	[1][1][RTW89_ACMA][7] = 127,
	[1][1][RTW89_CN][7] = 127,
	[1][1][RTW89_UK][7] = 127,
	[1][1][RTW89_FCC][8] = 127,
	[1][1][RTW89_ETSI][8] = 127,
	[1][1][RTW89_MKK][8] = 127,
	[1][1][RTW89_IC][8] = 127,
	[1][1][RTW89_KCC][8] = 127,
	[1][1][RTW89_ACMA][8] = 127,
	[1][1][RTW89_CN][8] = 127,
	[1][1][RTW89_UK][8] = 127,
	[1][1][RTW89_FCC][9] = 127,
	[1][1][RTW89_ETSI][9] = 127,
	[1][1][RTW89_MKK][9] = 127,
	[1][1][RTW89_IC][9] = 127,
	[1][1][RTW89_KCC][9] = 127,
	[1][1][RTW89_ACMA][9] = 127,
	[1][1][RTW89_CN][9] = 127,
	[1][1][RTW89_UK][9] = 127,
	[1][1][RTW89_FCC][10] = 127,
	[1][1][RTW89_ETSI][10] = 127,
	[1][1][RTW89_MKK][10] = 127,
	[1][1][RTW89_IC][10] = 127,
	[1][1][RTW89_KCC][10] = 127,
	[1][1][RTW89_ACMA][10] = 127,
	[1][1][RTW89_CN][10] = 127,
	[1][1][RTW89_UK][10] = 127,
	[1][1][RTW89_FCC][11] = 127,
	[1][1][RTW89_ETSI][11] = 127,
	[1][1][RTW89_MKK][11] = 127,
	[1][1][RTW89_IC][11] = 127,
	[1][1][RTW89_KCC][11] = 127,
	[1][1][RTW89_ACMA][11] = 127,
	[1][1][RTW89_CN][11] = 127,
	[1][1][RTW89_UK][11] = 127,
	[1][1][RTW89_FCC][12] = 127,
	[1][1][RTW89_ETSI][12] = 127,
	[1][1][RTW89_MKK][12] = 127,
	[1][1][RTW89_IC][12] = 127,
	[1][1][RTW89_KCC][12] = 127,
	[1][1][RTW89_ACMA][12] = 127,
	[1][1][RTW89_CN][12] = 127,
	[1][1][RTW89_UK][12] = 127,
	[1][1][RTW89_FCC][13] = 127,
	[1][1][RTW89_ETSI][13] = 127,
	[1][1][RTW89_MKK][13] = 127,
	[1][1][RTW89_IC][13] = 127,
	[1][1][RTW89_KCC][13] = 127,
	[1][1][RTW89_ACMA][13] = 127,
	[1][1][RTW89_CN][13] = 127,
	[1][1][RTW89_UK][13] = 127,
	[2][0][RTW89_FCC][0] = 76,
	[2][0][RTW89_ETSI][0] = 54,
	[2][0][RTW89_MKK][0] = 64,
	[2][0][RTW89_IC][0] = 76,
	[2][0][RTW89_KCC][0] = 68,
	[2][0][RTW89_ACMA][0] = 54,
	[2][0][RTW89_CN][0] = 56,
	[2][0][RTW89_UK][0] = 54,
	[2][0][RTW89_FCC][1] = 76,
	[2][0][RTW89_ETSI][1] = 54,
	[2][0][RTW89_MKK][1] = 64,
	[2][0][RTW89_IC][1] = 76,
	[2][0][RTW89_KCC][1] = 68,
	[2][0][RTW89_ACMA][1] = 54,
	[2][0][RTW89_CN][1] = 56,
	[2][0][RTW89_UK][1] = 54,
	[2][0][RTW89_FCC][2] = 78,
	[2][0][RTW89_ETSI][2] = 54,
	[2][0][RTW89_MKK][2] = 64,
	[2][0][RTW89_IC][2] = 78,
	[2][0][RTW89_KCC][2] = 68,
	[2][0][RTW89_ACMA][2] = 54,
	[2][0][RTW89_CN][2] = 56,
	[2][0][RTW89_UK][2] = 54,
	[2][0][RTW89_FCC][3] = 78,
	[2][0][RTW89_ETSI][3] = 54,
	[2][0][RTW89_MKK][3] = 64,
	[2][0][RTW89_IC][3] = 78,
	[2][0][RTW89_KCC][3] = 68,
	[2][0][RTW89_ACMA][3] = 54,
	[2][0][RTW89_CN][3] = 56,
	[2][0][RTW89_UK][3] = 54,
	[2][0][RTW89_FCC][4] = 78,
	[2][0][RTW89_ETSI][4] = 54,
	[2][0][RTW89_MKK][4] = 64,
	[2][0][RTW89_IC][4] = 78,
	[2][0][RTW89_KCC][4] = 68,
	[2][0][RTW89_ACMA][4] = 54,
	[2][0][RTW89_CN][4] = 56,
	[2][0][RTW89_UK][4] = 54,
	[2][0][RTW89_FCC][5] = 82,
	[2][0][RTW89_ETSI][5] = 54,
	[2][0][RTW89_MKK][5] = 64,
	[2][0][RTW89_IC][5] = 82,
	[2][0][RTW89_KCC][5] = 68,
	[2][0][RTW89_ACMA][5] = 54,
	[2][0][RTW89_CN][5] = 56,
	[2][0][RTW89_UK][5] = 54,
	[2][0][RTW89_FCC][6] = 74,
	[2][0][RTW89_ETSI][6] = 54,
	[2][0][RTW89_MKK][6] = 64,
	[2][0][RTW89_IC][6] = 74,
	[2][0][RTW89_KCC][6] = 68,
	[2][0][RTW89_ACMA][6] = 54,
	[2][0][RTW89_CN][6] = 56,
	[2][0][RTW89_UK][6] = 54,
	[2][0][RTW89_FCC][7] = 74,
	[2][0][RTW89_ETSI][7] = 54,
	[2][0][RTW89_MKK][7] = 64,
	[2][0][RTW89_IC][7] = 74,
	[2][0][RTW89_KCC][7] = 68,
	[2][0][RTW89_ACMA][7] = 54,
	[2][0][RTW89_CN][7] = 56,
	[2][0][RTW89_UK][7] = 54,
	[2][0][RTW89_FCC][8] = 74,
	[2][0][RTW89_ETSI][8] = 54,
	[2][0][RTW89_MKK][8] = 64,
	[2][0][RTW89_IC][8] = 74,
	[2][0][RTW89_KCC][8] = 68,
	[2][0][RTW89_ACMA][8] = 54,
	[2][0][RTW89_CN][8] = 56,
	[2][0][RTW89_UK][8] = 54,
	[2][0][RTW89_FCC][9] = 72,
	[2][0][RTW89_ETSI][9] = 54,
	[2][0][RTW89_MKK][9] = 64,
	[2][0][RTW89_IC][9] = 72,
	[2][0][RTW89_KCC][9] = 68,
	[2][0][RTW89_ACMA][9] = 54,
	[2][0][RTW89_CN][9] = 56,
	[2][0][RTW89_UK][9] = 54,
	[2][0][RTW89_FCC][10] = 72,
	[2][0][RTW89_ETSI][10] = 54,
	[2][0][RTW89_MKK][10] = 64,
	[2][0][RTW89_IC][10] = 72,
	[2][0][RTW89_KCC][10] = 68,
	[2][0][RTW89_ACMA][10] = 54,
	[2][0][RTW89_CN][10] = 56,
	[2][0][RTW89_UK][10] = 54,
	[2][0][RTW89_FCC][11] = 64,
	[2][0][RTW89_ETSI][11] = 54,
	[2][0][RTW89_MKK][11] = 64,
	[2][0][RTW89_IC][11] = 64,
	[2][0][RTW89_KCC][11] = 68,
	[2][0][RTW89_ACMA][11] = 54,
	[2][0][RTW89_CN][11] = 56,
	[2][0][RTW89_UK][11] = 54,
	[2][0][RTW89_FCC][12] = 34,
	[2][0][RTW89_ETSI][12] = 54,
	[2][0][RTW89_MKK][12] = 64,
	[2][0][RTW89_IC][12] = 34,
	[2][0][RTW89_KCC][12] = 68,
	[2][0][RTW89_ACMA][12] = 54,
	[2][0][RTW89_CN][12] = 56,
	[2][0][RTW89_UK][12] = 54,
	[2][0][RTW89_FCC][13] = 127,
	[2][0][RTW89_ETSI][13] = 127,
	[2][0][RTW89_MKK][13] = 127,
	[2][0][RTW89_IC][13] = 127,
	[2][0][RTW89_KCC][13] = 127,
	[2][0][RTW89_ACMA][13] = 127,
	[2][0][RTW89_CN][13] = 127,
	[2][0][RTW89_UK][13] = 127,
	[2][1][RTW89_FCC][0] = 127,
	[2][1][RTW89_ETSI][0] = 127,
	[2][1][RTW89_MKK][0] = 127,
	[2][1][RTW89_IC][0] = 127,
	[2][1][RTW89_KCC][0] = 127,
	[2][1][RTW89_ACMA][0] = 127,
	[2][1][RTW89_CN][0] = 127,
	[2][1][RTW89_UK][0] = 127,
	[2][1][RTW89_FCC][1] = 127,
	[2][1][RTW89_ETSI][1] = 127,
	[2][1][RTW89_MKK][1] = 127,
	[2][1][RTW89_IC][1] = 127,
	[2][1][RTW89_KCC][1] = 127,
	[2][1][RTW89_ACMA][1] = 127,
	[2][1][RTW89_CN][1] = 127,
	[2][1][RTW89_UK][1] = 127,
	[2][1][RTW89_FCC][2] = 127,
	[2][1][RTW89_ETSI][2] = 127,
	[2][1][RTW89_MKK][2] = 127,
	[2][1][RTW89_IC][2] = 127,
	[2][1][RTW89_KCC][2] = 127,
	[2][1][RTW89_ACMA][2] = 127,
	[2][1][RTW89_CN][2] = 127,
	[2][1][RTW89_UK][2] = 127,
	[2][1][RTW89_FCC][3] = 127,
	[2][1][RTW89_ETSI][3] = 127,
	[2][1][RTW89_MKK][3] = 127,
	[2][1][RTW89_IC][3] = 127,
	[2][1][RTW89_KCC][3] = 127,
	[2][1][RTW89_ACMA][3] = 127,
	[2][1][RTW89_CN][3] = 127,
	[2][1][RTW89_UK][3] = 127,
	[2][1][RTW89_FCC][4] = 127,
	[2][1][RTW89_ETSI][4] = 127,
	[2][1][RTW89_MKK][4] = 127,
	[2][1][RTW89_IC][4] = 127,
	[2][1][RTW89_KCC][4] = 127,
	[2][1][RTW89_ACMA][4] = 127,
	[2][1][RTW89_CN][4] = 127,
	[2][1][RTW89_UK][4] = 127,
	[2][1][RTW89_FCC][5] = 127,
	[2][1][RTW89_ETSI][5] = 127,
	[2][1][RTW89_MKK][5] = 127,
	[2][1][RTW89_IC][5] = 127,
	[2][1][RTW89_KCC][5] = 127,
	[2][1][RTW89_ACMA][5] = 127,
	[2][1][RTW89_CN][5] = 127,
	[2][1][RTW89_UK][5] = 127,
	[2][1][RTW89_FCC][6] = 127,
	[2][1][RTW89_ETSI][6] = 127,
	[2][1][RTW89_MKK][6] = 127,
	[2][1][RTW89_IC][6] = 127,
	[2][1][RTW89_KCC][6] = 127,
	[2][1][RTW89_ACMA][6] = 127,
	[2][1][RTW89_CN][6] = 127,
	[2][1][RTW89_UK][6] = 127,
	[2][1][RTW89_FCC][7] = 127,
	[2][1][RTW89_ETSI][7] = 127,
	[2][1][RTW89_MKK][7] = 127,
	[2][1][RTW89_IC][7] = 127,
	[2][1][RTW89_KCC][7] = 127,
	[2][1][RTW89_ACMA][7] = 127,
	[2][1][RTW89_CN][7] = 127,
	[2][1][RTW89_UK][7] = 127,
	[2][1][RTW89_FCC][8] = 127,
	[2][1][RTW89_ETSI][8] = 127,
	[2][1][RTW89_MKK][8] = 127,
	[2][1][RTW89_IC][8] = 127,
	[2][1][RTW89_KCC][8] = 127,
	[2][1][RTW89_ACMA][8] = 127,
	[2][1][RTW89_CN][8] = 127,
	[2][1][RTW89_UK][8] = 127,
	[2][1][RTW89_FCC][9] = 127,
	[2][1][RTW89_ETSI][9] = 127,
	[2][1][RTW89_MKK][9] = 127,
	[2][1][RTW89_IC][9] = 127,
	[2][1][RTW89_KCC][9] = 127,
	[2][1][RTW89_ACMA][9] = 127,
	[2][1][RTW89_CN][9] = 127,
	[2][1][RTW89_UK][9] = 127,
	[2][1][RTW89_FCC][10] = 127,
	[2][1][RTW89_ETSI][10] = 127,
	[2][1][RTW89_MKK][10] = 127,
	[2][1][RTW89_IC][10] = 127,
	[2][1][RTW89_KCC][10] = 127,
	[2][1][RTW89_ACMA][10] = 127,
	[2][1][RTW89_CN][10] = 127,
	[2][1][RTW89_UK][10] = 127,
	[2][1][RTW89_FCC][11] = 127,
	[2][1][RTW89_ETSI][11] = 127,
	[2][1][RTW89_MKK][11] = 127,
	[2][1][RTW89_IC][11] = 127,
	[2][1][RTW89_KCC][11] = 127,
	[2][1][RTW89_ACMA][11] = 127,
	[2][1][RTW89_CN][11] = 127,
	[2][1][RTW89_UK][11] = 127,
	[2][1][RTW89_FCC][12] = 127,
	[2][1][RTW89_ETSI][12] = 127,
	[2][1][RTW89_MKK][12] = 127,
	[2][1][RTW89_IC][12] = 127,
	[2][1][RTW89_KCC][12] = 127,
	[2][1][RTW89_ACMA][12] = 127,
	[2][1][RTW89_CN][12] = 127,
	[2][1][RTW89_UK][12] = 127,
	[2][1][RTW89_FCC][13] = 127,
	[2][1][RTW89_ETSI][13] = 127,
	[2][1][RTW89_MKK][13] = 127,
	[2][1][RTW89_IC][13] = 127,
	[2][1][RTW89_KCC][13] = 127,
	[2][1][RTW89_ACMA][13] = 127,
	[2][1][RTW89_CN][13] = 127,
	[2][1][RTW89_UK][13] = 127,
};

static
const s8 rtw89_8851b_txpwr_lmt_ru_5g[RTW89_RU_NUM][RTW89_NTX_NUM]
				    [RTW89_REGD_NUM][RTW89_5G_CH_NUM] = {
	[0][0][RTW89_WW][0] = 16,
	[0][0][RTW89_WW][2] = 16,
	[0][0][RTW89_WW][4] = 16,
	[0][0][RTW89_WW][6] = 16,
	[0][0][RTW89_WW][8] = 16,
	[0][0][RTW89_WW][10] = 16,
	[0][0][RTW89_WW][12] = 16,
	[0][0][RTW89_WW][14] = 16,
	[0][0][RTW89_WW][15] = 24,
	[0][0][RTW89_WW][17] = 24,
	[0][0][RTW89_WW][19] = 24,
	[0][0][RTW89_WW][21] = 24,
	[0][0][RTW89_WW][23] = 24,
	[0][0][RTW89_WW][25] = 24,
	[0][0][RTW89_WW][27] = 24,
	[0][0][RTW89_WW][29] = 24,
	[0][0][RTW89_WW][31] = 24,
	[0][0][RTW89_WW][33] = 24,
	[0][0][RTW89_WW][35] = 24,
	[0][0][RTW89_WW][37] = 44,
	[0][0][RTW89_WW][38] = 24,
	[0][0][RTW89_WW][40] = 24,
	[0][0][RTW89_WW][42] = 24,
	[0][0][RTW89_WW][44] = 24,
	[0][0][RTW89_WW][46] = 24,
	[0][0][RTW89_WW][48] = 42,
	[0][0][RTW89_WW][50] = 42,
	[0][0][RTW89_WW][52] = 40,
	[0][1][RTW89_WW][0] = 0,
	[0][1][RTW89_WW][2] = 0,
	[0][1][RTW89_WW][4] = 0,
	[0][1][RTW89_WW][6] = 0,
	[0][1][RTW89_WW][8] = 0,
	[0][1][RTW89_WW][10] = 0,
	[0][1][RTW89_WW][12] = 0,
	[0][1][RTW89_WW][14] = 0,
	[0][1][RTW89_WW][15] = 0,
	[0][1][RTW89_WW][17] = 0,
	[0][1][RTW89_WW][19] = 0,
	[0][1][RTW89_WW][21] = 0,
	[0][1][RTW89_WW][23] = 0,
	[0][1][RTW89_WW][25] = 0,
	[0][1][RTW89_WW][27] = 0,
	[0][1][RTW89_WW][29] = 0,
	[0][1][RTW89_WW][31] = 0,
	[0][1][RTW89_WW][33] = 0,
	[0][1][RTW89_WW][35] = 0,
	[0][1][RTW89_WW][37] = 0,
	[0][1][RTW89_WW][38] = 0,
	[0][1][RTW89_WW][40] = 0,
	[0][1][RTW89_WW][42] = 0,
	[0][1][RTW89_WW][44] = 0,
	[0][1][RTW89_WW][46] = 0,
	[0][1][RTW89_WW][48] = 0,
	[0][1][RTW89_WW][50] = 0,
	[0][1][RTW89_WW][52] = 0,
	[1][0][RTW89_WW][0] = 26,
	[1][0][RTW89_WW][2] = 26,
	[1][0][RTW89_WW][4] = 26,
	[1][0][RTW89_WW][6] = 26,
	[1][0][RTW89_WW][8] = 26,
	[1][0][RTW89_WW][10] = 26,
	[1][0][RTW89_WW][12] = 26,
	[1][0][RTW89_WW][14] = 26,
	[1][0][RTW89_WW][15] = 34,
	[1][0][RTW89_WW][17] = 34,
	[1][0][RTW89_WW][19] = 34,
	[1][0][RTW89_WW][21] = 34,
	[1][0][RTW89_WW][23] = 34,
	[1][0][RTW89_WW][25] = 34,
	[1][0][RTW89_WW][27] = 34,
	[1][0][RTW89_WW][29] = 34,
	[1][0][RTW89_WW][31] = 34,
	[1][0][RTW89_WW][33] = 34,
	[1][0][RTW89_WW][35] = 34,
	[1][0][RTW89_WW][37] = 54,
	[1][0][RTW89_WW][38] = 28,
	[1][0][RTW89_WW][40] = 28,
	[1][0][RTW89_WW][42] = 28,
	[1][0][RTW89_WW][44] = 28,
	[1][0][RTW89_WW][46] = 28,
	[1][0][RTW89_WW][48] = 52,
	[1][0][RTW89_WW][50] = 52,
	[1][0][RTW89_WW][52] = 52,
	[1][1][RTW89_WW][0] = 0,
	[1][1][RTW89_WW][2] = 0,
	[1][1][RTW89_WW][4] = 0,
	[1][1][RTW89_WW][6] = 0,
	[1][1][RTW89_WW][8] = 0,
	[1][1][RTW89_WW][10] = 0,
	[1][1][RTW89_WW][12] = 0,
	[1][1][RTW89_WW][14] = 0,
	[1][1][RTW89_WW][15] = 0,
	[1][1][RTW89_WW][17] = 0,
	[1][1][RTW89_WW][19] = 0,
	[1][1][RTW89_WW][21] = 0,
	[1][1][RTW89_WW][23] = 0,
	[1][1][RTW89_WW][25] = 0,
	[1][1][RTW89_WW][27] = 0,
	[1][1][RTW89_WW][29] = 0,
	[1][1][RTW89_WW][31] = 0,
	[1][1][RTW89_WW][33] = 0,
	[1][1][RTW89_WW][35] = 0,
	[1][1][RTW89_WW][37] = 0,
	[1][1][RTW89_WW][38] = 0,
	[1][1][RTW89_WW][40] = 0,
	[1][1][RTW89_WW][42] = 0,
	[1][1][RTW89_WW][44] = 0,
	[1][1][RTW89_WW][46] = 0,
	[1][1][RTW89_WW][48] = 0,
	[1][1][RTW89_WW][50] = 0,
	[1][1][RTW89_WW][52] = 0,
	[2][0][RTW89_WW][0] = 40,
	[2][0][RTW89_WW][2] = 40,
	[2][0][RTW89_WW][4] = 40,
	[2][0][RTW89_WW][6] = 40,
	[2][0][RTW89_WW][8] = 40,
	[2][0][RTW89_WW][10] = 40,
	[2][0][RTW89_WW][12] = 40,
	[2][0][RTW89_WW][14] = 40,
	[2][0][RTW89_WW][15] = 46,
	[2][0][RTW89_WW][17] = 46,
	[2][0][RTW89_WW][19] = 46,
	[2][0][RTW89_WW][21] = 46,
	[2][0][RTW89_WW][23] = 46,
	[2][0][RTW89_WW][25] = 46,
	[2][0][RTW89_WW][27] = 46,
	[2][0][RTW89_WW][29] = 46,
	[2][0][RTW89_WW][31] = 46,
	[2][0][RTW89_WW][33] = 46,
	[2][0][RTW89_WW][35] = 46,
	[2][0][RTW89_WW][37] = 66,
	[2][0][RTW89_WW][38] = 28,
	[2][0][RTW89_WW][40] = 28,
	[2][0][RTW89_WW][42] = 28,
	[2][0][RTW89_WW][44] = 28,
	[2][0][RTW89_WW][46] = 28,
	[2][0][RTW89_WW][48] = 64,
	[2][0][RTW89_WW][50] = 64,
	[2][0][RTW89_WW][52] = 60,
	[2][1][RTW89_WW][0] = 0,
	[2][1][RTW89_WW][2] = 0,
	[2][1][RTW89_WW][4] = 0,
	[2][1][RTW89_WW][6] = 0,
	[2][1][RTW89_WW][8] = 0,
	[2][1][RTW89_WW][10] = 0,
	[2][1][RTW89_WW][12] = 0,
	[2][1][RTW89_WW][14] = 0,
	[2][1][RTW89_WW][15] = 0,
	[2][1][RTW89_WW][17] = 0,
	[2][1][RTW89_WW][19] = 0,
	[2][1][RTW89_WW][21] = 0,
	[2][1][RTW89_WW][23] = 0,
	[2][1][RTW89_WW][25] = 0,
	[2][1][RTW89_WW][27] = 0,
	[2][1][RTW89_WW][29] = 0,
	[2][1][RTW89_WW][31] = 0,
	[2][1][RTW89_WW][33] = 0,
	[2][1][RTW89_WW][35] = 0,
	[2][1][RTW89_WW][37] = 0,
	[2][1][RTW89_WW][38] = 0,
	[2][1][RTW89_WW][40] = 0,
	[2][1][RTW89_WW][42] = 0,
	[2][1][RTW89_WW][44] = 0,
	[2][1][RTW89_WW][46] = 0,
	[2][1][RTW89_WW][48] = 0,
	[2][1][RTW89_WW][50] = 0,
	[2][1][RTW89_WW][52] = 0,
	[0][0][RTW89_FCC][0] = 52,
	[0][0][RTW89_ETSI][0] = 24,
	[0][0][RTW89_MKK][0] = 26,
	[0][0][RTW89_IC][0] = 28,
	[0][0][RTW89_KCC][0] = 42,
	[0][0][RTW89_ACMA][0] = 24,
	[0][0][RTW89_CN][0] = 16,
	[0][0][RTW89_UK][0] = 24,
	[0][0][RTW89_FCC][2] = 54,
	[0][0][RTW89_ETSI][2] = 24,
	[0][0][RTW89_MKK][2] = 26,
	[0][0][RTW89_IC][2] = 28,
	[0][0][RTW89_KCC][2] = 42,
	[0][0][RTW89_ACMA][2] = 24,
	[0][0][RTW89_CN][2] = 16,
	[0][0][RTW89_UK][2] = 24,
	[0][0][RTW89_FCC][4] = 52,
	[0][0][RTW89_ETSI][4] = 24,
	[0][0][RTW89_MKK][4] = 26,
	[0][0][RTW89_IC][4] = 28,
	[0][0][RTW89_KCC][4] = 42,
	[0][0][RTW89_ACMA][4] = 24,
	[0][0][RTW89_CN][4] = 16,
	[0][0][RTW89_UK][4] = 24,
	[0][0][RTW89_FCC][6] = 52,
	[0][0][RTW89_ETSI][6] = 24,
	[0][0][RTW89_MKK][6] = 26,
	[0][0][RTW89_IC][6] = 28,
	[0][0][RTW89_KCC][6] = 18,
	[0][0][RTW89_ACMA][6] = 24,
	[0][0][RTW89_CN][6] = 16,
	[0][0][RTW89_UK][6] = 24,
	[0][0][RTW89_FCC][8] = 52,
	[0][0][RTW89_ETSI][8] = 24,
	[0][0][RTW89_MKK][8] = 26,
	[0][0][RTW89_IC][8] = 52,
	[0][0][RTW89_KCC][8] = 42,
	[0][0][RTW89_ACMA][8] = 24,
	[0][0][RTW89_CN][8] = 16,
	[0][0][RTW89_UK][8] = 24,
	[0][0][RTW89_FCC][10] = 52,
	[0][0][RTW89_ETSI][10] = 24,
	[0][0][RTW89_MKK][10] = 26,
	[0][0][RTW89_IC][10] = 52,
	[0][0][RTW89_KCC][10] = 42,
	[0][0][RTW89_ACMA][10] = 24,
	[0][0][RTW89_CN][10] = 16,
	[0][0][RTW89_UK][10] = 24,
	[0][0][RTW89_FCC][12] = 56,
	[0][0][RTW89_ETSI][12] = 24,
	[0][0][RTW89_MKK][12] = 26,
	[0][0][RTW89_IC][12] = 56,
	[0][0][RTW89_KCC][12] = 44,
	[0][0][RTW89_ACMA][12] = 24,
	[0][0][RTW89_CN][12] = 16,
	[0][0][RTW89_UK][12] = 24,
	[0][0][RTW89_FCC][14] = 56,
	[0][0][RTW89_ETSI][14] = 24,
	[0][0][RTW89_MKK][14] = 26,
	[0][0][RTW89_IC][14] = 56,
	[0][0][RTW89_KCC][14] = 44,
	[0][0][RTW89_ACMA][14] = 24,
	[0][0][RTW89_CN][14] = 16,
	[0][0][RTW89_UK][14] = 24,
	[0][0][RTW89_FCC][15] = 54,
	[0][0][RTW89_ETSI][15] = 24,
	[0][0][RTW89_MKK][15] = 46,
	[0][0][RTW89_IC][15] = 54,
	[0][0][RTW89_KCC][15] = 44,
	[0][0][RTW89_ACMA][15] = 24,
	[0][0][RTW89_CN][15] = 127,
	[0][0][RTW89_UK][15] = 24,
	[0][0][RTW89_FCC][17] = 54,
	[0][0][RTW89_ETSI][17] = 24,
	[0][0][RTW89_MKK][17] = 50,
	[0][0][RTW89_IC][17] = 54,
	[0][0][RTW89_KCC][17] = 44,
	[0][0][RTW89_ACMA][17] = 24,
	[0][0][RTW89_CN][17] = 127,
	[0][0][RTW89_UK][17] = 24,
	[0][0][RTW89_FCC][19] = 54,
	[0][0][RTW89_ETSI][19] = 24,
	[0][0][RTW89_MKK][19] = 50,
	[0][0][RTW89_IC][19] = 54,
	[0][0][RTW89_KCC][19] = 44,
	[0][0][RTW89_ACMA][19] = 24,
	[0][0][RTW89_CN][19] = 127,
	[0][0][RTW89_UK][19] = 24,
	[0][0][RTW89_FCC][21] = 54,
	[0][0][RTW89_ETSI][21] = 24,
	[0][0][RTW89_MKK][21] = 50,
	[0][0][RTW89_IC][21] = 54,
	[0][0][RTW89_KCC][21] = 44,
	[0][0][RTW89_ACMA][21] = 24,
	[0][0][RTW89_CN][21] = 127,
	[0][0][RTW89_UK][21] = 24,
	[0][0][RTW89_FCC][23] = 54,
	[0][0][RTW89_ETSI][23] = 24,
	[0][0][RTW89_MKK][23] = 50,
	[0][0][RTW89_IC][23] = 54,
	[0][0][RTW89_KCC][23] = 44,
	[0][0][RTW89_ACMA][23] = 24,
	[0][0][RTW89_CN][23] = 127,
	[0][0][RTW89_UK][23] = 24,
	[0][0][RTW89_FCC][25] = 54,
	[0][0][RTW89_ETSI][25] = 24,
	[0][0][RTW89_MKK][25] = 50,
	[0][0][RTW89_IC][25] = 127,
	[0][0][RTW89_KCC][25] = 44,
	[0][0][RTW89_ACMA][25] = 127,
	[0][0][RTW89_CN][25] = 127,
	[0][0][RTW89_UK][25] = 24,
	[0][0][RTW89_FCC][27] = 54,
	[0][0][RTW89_ETSI][27] = 24,
	[0][0][RTW89_MKK][27] = 50,
	[0][0][RTW89_IC][27] = 127,
	[0][0][RTW89_KCC][27] = 42,
	[0][0][RTW89_ACMA][27] = 127,
	[0][0][RTW89_CN][27] = 127,
	[0][0][RTW89_UK][27] = 24,
	[0][0][RTW89_FCC][29] = 54,
	[0][0][RTW89_ETSI][29] = 24,
	[0][0][RTW89_MKK][29] = 50,
	[0][0][RTW89_IC][29] = 127,
	[0][0][RTW89_KCC][29] = 42,
	[0][0][RTW89_ACMA][29] = 127,
	[0][0][RTW89_CN][29] = 127,
	[0][0][RTW89_UK][29] = 24,
	[0][0][RTW89_FCC][31] = 54,
	[0][0][RTW89_ETSI][31] = 24,
	[0][0][RTW89_MKK][31] = 50,
	[0][0][RTW89_IC][31] = 56,
	[0][0][RTW89_KCC][31] = 42,
	[0][0][RTW89_ACMA][31] = 24,
	[0][0][RTW89_CN][31] = 127,
	[0][0][RTW89_UK][31] = 24,
	[0][0][RTW89_FCC][33] = 56,
	[0][0][RTW89_ETSI][33] = 24,
	[0][0][RTW89_MKK][33] = 50,
	[0][0][RTW89_IC][33] = 56,
	[0][0][RTW89_KCC][33] = 42,
	[0][0][RTW89_ACMA][33] = 24,
	[0][0][RTW89_CN][33] = 127,
	[0][0][RTW89_UK][33] = 24,
	[0][0][RTW89_FCC][35] = 56,
	[0][0][RTW89_ETSI][35] = 24,
	[0][0][RTW89_MKK][35] = 50,
	[0][0][RTW89_IC][35] = 56,
	[0][0][RTW89_KCC][35] = 42,
	[0][0][RTW89_ACMA][35] = 24,
	[0][0][RTW89_CN][35] = 127,
	[0][0][RTW89_UK][35] = 24,
	[0][0][RTW89_FCC][37] = 86,
	[0][0][RTW89_ETSI][37] = 127,
	[0][0][RTW89_MKK][37] = 46,
	[0][0][RTW89_IC][37] = 86,
	[0][0][RTW89_KCC][37] = 44,
	[0][0][RTW89_ACMA][37] = 50,
	[0][0][RTW89_CN][37] = 127,
	[0][0][RTW89_UK][37] = 52,
	[0][0][RTW89_FCC][38] = 68,
	[0][0][RTW89_ETSI][38] = 28,
	[0][0][RTW89_MKK][38] = 127,
	[0][0][RTW89_IC][38] = 68,
	[0][0][RTW89_KCC][38] = 44,
	[0][0][RTW89_ACMA][38] = 84,
	[0][0][RTW89_CN][38] = 54,
	[0][0][RTW89_UK][38] = 24,
	[0][0][RTW89_FCC][40] = 68,
	[0][0][RTW89_ETSI][40] = 28,
	[0][0][RTW89_MKK][40] = 127,
	[0][0][RTW89_IC][40] = 68,
	[0][0][RTW89_KCC][40] = 44,
	[0][0][RTW89_ACMA][40] = 84,
	[0][0][RTW89_CN][40] = 54,
	[0][0][RTW89_UK][40] = 24,
	[0][0][RTW89_FCC][42] = 70,
	[0][0][RTW89_ETSI][42] = 28,
	[0][0][RTW89_MKK][42] = 127,
	[0][0][RTW89_IC][42] = 70,
	[0][0][RTW89_KCC][42] = 44,
	[0][0][RTW89_ACMA][42] = 84,
	[0][0][RTW89_CN][42] = 54,
	[0][0][RTW89_UK][42] = 24,
	[0][0][RTW89_FCC][44] = 62,
	[0][0][RTW89_ETSI][44] = 28,
	[0][0][RTW89_MKK][44] = 127,
	[0][0][RTW89_IC][44] = 62,
	[0][0][RTW89_KCC][44] = 44,
	[0][0][RTW89_ACMA][44] = 84,
	[0][0][RTW89_CN][44] = 54,
	[0][0][RTW89_UK][44] = 24,
	[0][0][RTW89_FCC][46] = 62,
	[0][0][RTW89_ETSI][46] = 28,
	[0][0][RTW89_MKK][46] = 127,
	[0][0][RTW89_IC][46] = 62,
	[0][0][RTW89_KCC][46] = 44,
	[0][0][RTW89_ACMA][46] = 84,
	[0][0][RTW89_CN][46] = 54,
	[0][0][RTW89_UK][46] = 24,
	[0][0][RTW89_FCC][48] = 42,
	[0][0][RTW89_ETSI][48] = 127,
	[0][0][RTW89_MKK][48] = 127,
	[0][0][RTW89_IC][48] = 127,
	[0][0][RTW89_KCC][48] = 127,
	[0][0][RTW89_ACMA][48] = 127,
	[0][0][RTW89_CN][48] = 127,
	[0][0][RTW89_UK][48] = 127,
	[0][0][RTW89_FCC][50] = 42,
	[0][0][RTW89_ETSI][50] = 127,
	[0][0][RTW89_MKK][50] = 127,
	[0][0][RTW89_IC][50] = 127,
	[0][0][RTW89_KCC][50] = 127,
	[0][0][RTW89_ACMA][50] = 127,
	[0][0][RTW89_CN][50] = 127,
	[0][0][RTW89_UK][50] = 127,
	[0][0][RTW89_FCC][52] = 40,
	[0][0][RTW89_ETSI][52] = 127,
	[0][0][RTW89_MKK][52] = 127,
	[0][0][RTW89_IC][52] = 127,
	[0][0][RTW89_KCC][52] = 127,
	[0][0][RTW89_ACMA][52] = 127,
	[0][0][RTW89_CN][52] = 127,
	[0][0][RTW89_UK][52] = 127,
	[0][1][RTW89_FCC][0] = 127,
	[0][1][RTW89_ETSI][0] = 127,
	[0][1][RTW89_MKK][0] = 127,
	[0][1][RTW89_IC][0] = 127,
	[0][1][RTW89_KCC][0] = 127,
	[0][1][RTW89_ACMA][0] = 127,
	[0][1][RTW89_CN][0] = 127,
	[0][1][RTW89_UK][0] = 127,
	[0][1][RTW89_FCC][2] = 127,
	[0][1][RTW89_ETSI][2] = 127,
	[0][1][RTW89_MKK][2] = 127,
	[0][1][RTW89_IC][2] = 127,
	[0][1][RTW89_KCC][2] = 127,
	[0][1][RTW89_ACMA][2] = 127,
	[0][1][RTW89_CN][2] = 127,
	[0][1][RTW89_UK][2] = 127,
	[0][1][RTW89_FCC][4] = 127,
	[0][1][RTW89_ETSI][4] = 127,
	[0][1][RTW89_MKK][4] = 127,
	[0][1][RTW89_IC][4] = 127,
	[0][1][RTW89_KCC][4] = 127,
	[0][1][RTW89_ACMA][4] = 127,
	[0][1][RTW89_CN][4] = 127,
	[0][1][RTW89_UK][4] = 127,
	[0][1][RTW89_FCC][6] = 127,
	[0][1][RTW89_ETSI][6] = 127,
	[0][1][RTW89_MKK][6] = 127,
	[0][1][RTW89_IC][6] = 127,
	[0][1][RTW89_KCC][6] = 127,
	[0][1][RTW89_ACMA][6] = 127,
	[0][1][RTW89_CN][6] = 127,
	[0][1][RTW89_UK][6] = 127,
	[0][1][RTW89_FCC][8] = 127,
	[0][1][RTW89_ETSI][8] = 127,
	[0][1][RTW89_MKK][8] = 127,
	[0][1][RTW89_IC][8] = 127,
	[0][1][RTW89_KCC][8] = 127,
	[0][1][RTW89_ACMA][8] = 127,
	[0][1][RTW89_CN][8] = 127,
	[0][1][RTW89_UK][8] = 127,
	[0][1][RTW89_FCC][10] = 127,
	[0][1][RTW89_ETSI][10] = 127,
	[0][1][RTW89_MKK][10] = 127,
	[0][1][RTW89_IC][10] = 127,
	[0][1][RTW89_KCC][10] = 127,
	[0][1][RTW89_ACMA][10] = 127,
	[0][1][RTW89_CN][10] = 127,
	[0][1][RTW89_UK][10] = 127,
	[0][1][RTW89_FCC][12] = 127,
	[0][1][RTW89_ETSI][12] = 127,
	[0][1][RTW89_MKK][12] = 127,
	[0][1][RTW89_IC][12] = 127,
	[0][1][RTW89_KCC][12] = 127,
	[0][1][RTW89_ACMA][12] = 127,
	[0][1][RTW89_CN][12] = 127,
	[0][1][RTW89_UK][12] = 127,
	[0][1][RTW89_FCC][14] = 127,
	[0][1][RTW89_ETSI][14] = 127,
	[0][1][RTW89_MKK][14] = 127,
	[0][1][RTW89_IC][14] = 127,
	[0][1][RTW89_KCC][14] = 127,
	[0][1][RTW89_ACMA][14] = 127,
	[0][1][RTW89_CN][14] = 127,
	[0][1][RTW89_UK][14] = 127,
	[0][1][RTW89_FCC][15] = 127,
	[0][1][RTW89_ETSI][15] = 127,
	[0][1][RTW89_MKK][15] = 127,
	[0][1][RTW89_IC][15] = 127,
	[0][1][RTW89_KCC][15] = 127,
	[0][1][RTW89_ACMA][15] = 127,
	[0][1][RTW89_CN][15] = 127,
	[0][1][RTW89_UK][15] = 127,
	[0][1][RTW89_FCC][17] = 127,
	[0][1][RTW89_ETSI][17] = 127,
	[0][1][RTW89_MKK][17] = 127,
	[0][1][RTW89_IC][17] = 127,
	[0][1][RTW89_KCC][17] = 127,
	[0][1][RTW89_ACMA][17] = 127,
	[0][1][RTW89_CN][17] = 127,
	[0][1][RTW89_UK][17] = 127,
	[0][1][RTW89_FCC][19] = 127,
	[0][1][RTW89_ETSI][19] = 127,
	[0][1][RTW89_MKK][19] = 127,
	[0][1][RTW89_IC][19] = 127,
	[0][1][RTW89_KCC][19] = 127,
	[0][1][RTW89_ACMA][19] = 127,
	[0][1][RTW89_CN][19] = 127,
	[0][1][RTW89_UK][19] = 127,
	[0][1][RTW89_FCC][21] = 127,
	[0][1][RTW89_ETSI][21] = 127,
	[0][1][RTW89_MKK][21] = 127,
	[0][1][RTW89_IC][21] = 127,
	[0][1][RTW89_KCC][21] = 127,
	[0][1][RTW89_ACMA][21] = 127,
	[0][1][RTW89_CN][21] = 127,
	[0][1][RTW89_UK][21] = 127,
	[0][1][RTW89_FCC][23] = 127,
	[0][1][RTW89_ETSI][23] = 127,
	[0][1][RTW89_MKK][23] = 127,
	[0][1][RTW89_IC][23] = 127,
	[0][1][RTW89_KCC][23] = 127,
	[0][1][RTW89_ACMA][23] = 127,
	[0][1][RTW89_CN][23] = 127,
	[0][1][RTW89_UK][23] = 127,
	[0][1][RTW89_FCC][25] = 127,
	[0][1][RTW89_ETSI][25] = 127,
	[0][1][RTW89_MKK][25] = 127,
	[0][1][RTW89_IC][25] = 127,
	[0][1][RTW89_KCC][25] = 127,
	[0][1][RTW89_ACMA][25] = 127,
	[0][1][RTW89_CN][25] = 127,
	[0][1][RTW89_UK][25] = 127,
	[0][1][RTW89_FCC][27] = 127,
	[0][1][RTW89_ETSI][27] = 127,
	[0][1][RTW89_MKK][27] = 127,
	[0][1][RTW89_IC][27] = 127,
	[0][1][RTW89_KCC][27] = 127,
	[0][1][RTW89_ACMA][27] = 127,
	[0][1][RTW89_CN][27] = 127,
	[0][1][RTW89_UK][27] = 127,
	[0][1][RTW89_FCC][29] = 127,
	[0][1][RTW89_ETSI][29] = 127,
	[0][1][RTW89_MKK][29] = 127,
	[0][1][RTW89_IC][29] = 127,
	[0][1][RTW89_KCC][29] = 127,
	[0][1][RTW89_ACMA][29] = 127,
	[0][1][RTW89_CN][29] = 127,
	[0][1][RTW89_UK][29] = 127,
	[0][1][RTW89_FCC][31] = 127,
	[0][1][RTW89_ETSI][31] = 127,
	[0][1][RTW89_MKK][31] = 127,
	[0][1][RTW89_IC][31] = 127,
	[0][1][RTW89_KCC][31] = 127,
	[0][1][RTW89_ACMA][31] = 127,
	[0][1][RTW89_CN][31] = 127,
	[0][1][RTW89_UK][31] = 127,
	[0][1][RTW89_FCC][33] = 127,
	[0][1][RTW89_ETSI][33] = 127,
	[0][1][RTW89_MKK][33] = 127,
	[0][1][RTW89_IC][33] = 127,
	[0][1][RTW89_KCC][33] = 127,
	[0][1][RTW89_ACMA][33] = 127,
	[0][1][RTW89_CN][33] = 127,
	[0][1][RTW89_UK][33] = 127,
	[0][1][RTW89_FCC][35] = 127,
	[0][1][RTW89_ETSI][35] = 127,
	[0][1][RTW89_MKK][35] = 127,
	[0][1][RTW89_IC][35] = 127,
	[0][1][RTW89_KCC][35] = 127,
	[0][1][RTW89_ACMA][35] = 127,
	[0][1][RTW89_CN][35] = 127,
	[0][1][RTW89_UK][35] = 127,
	[0][1][RTW89_FCC][37] = 127,
	[0][1][RTW89_ETSI][37] = 127,
	[0][1][RTW89_MKK][37] = 127,
	[0][1][RTW89_IC][37] = 127,
	[0][1][RTW89_KCC][37] = 127,
	[0][1][RTW89_ACMA][37] = 127,
	[0][1][RTW89_CN][37] = 127,
	[0][1][RTW89_UK][37] = 127,
	[0][1][RTW89_FCC][38] = 127,
	[0][1][RTW89_ETSI][38] = 127,
	[0][1][RTW89_MKK][38] = 127,
	[0][1][RTW89_IC][38] = 127,
	[0][1][RTW89_KCC][38] = 127,
	[0][1][RTW89_ACMA][38] = 127,
	[0][1][RTW89_CN][38] = 127,
	[0][1][RTW89_UK][38] = 127,
	[0][1][RTW89_FCC][40] = 127,
	[0][1][RTW89_ETSI][40] = 127,
	[0][1][RTW89_MKK][40] = 127,
	[0][1][RTW89_IC][40] = 127,
	[0][1][RTW89_KCC][40] = 127,
	[0][1][RTW89_ACMA][40] = 127,
	[0][1][RTW89_CN][40] = 127,
	[0][1][RTW89_UK][40] = 127,
	[0][1][RTW89_FCC][42] = 127,
	[0][1][RTW89_ETSI][42] = 127,
	[0][1][RTW89_MKK][42] = 127,
	[0][1][RTW89_IC][42] = 127,
	[0][1][RTW89_KCC][42] = 127,
	[0][1][RTW89_ACMA][42] = 127,
	[0][1][RTW89_CN][42] = 127,
	[0][1][RTW89_UK][42] = 127,
	[0][1][RTW89_FCC][44] = 127,
	[0][1][RTW89_ETSI][44] = 127,
	[0][1][RTW89_MKK][44] = 127,
	[0][1][RTW89_IC][44] = 127,
	[0][1][RTW89_KCC][44] = 127,
	[0][1][RTW89_ACMA][44] = 127,
	[0][1][RTW89_CN][44] = 127,
	[0][1][RTW89_UK][44] = 127,
	[0][1][RTW89_FCC][46] = 127,
	[0][1][RTW89_ETSI][46] = 127,
	[0][1][RTW89_MKK][46] = 127,
	[0][1][RTW89_IC][46] = 127,
	[0][1][RTW89_KCC][46] = 127,
	[0][1][RTW89_ACMA][46] = 127,
	[0][1][RTW89_CN][46] = 127,
	[0][1][RTW89_UK][46] = 127,
	[0][1][RTW89_FCC][48] = 127,
	[0][1][RTW89_ETSI][48] = 127,
	[0][1][RTW89_MKK][48] = 127,
	[0][1][RTW89_IC][48] = 127,
	[0][1][RTW89_KCC][48] = 127,
	[0][1][RTW89_ACMA][48] = 127,
	[0][1][RTW89_CN][48] = 127,
	[0][1][RTW89_UK][48] = 127,
	[0][1][RTW89_FCC][50] = 127,
	[0][1][RTW89_ETSI][50] = 127,
	[0][1][RTW89_MKK][50] = 127,
	[0][1][RTW89_IC][50] = 127,
	[0][1][RTW89_KCC][50] = 127,
	[0][1][RTW89_ACMA][50] = 127,
	[0][1][RTW89_CN][50] = 127,
	[0][1][RTW89_UK][50] = 127,
	[0][1][RTW89_FCC][52] = 127,
	[0][1][RTW89_ETSI][52] = 127,
	[0][1][RTW89_MKK][52] = 127,
	[0][1][RTW89_IC][52] = 127,
	[0][1][RTW89_KCC][52] = 127,
	[0][1][RTW89_ACMA][52] = 127,
	[0][1][RTW89_CN][52] = 127,
	[0][1][RTW89_UK][52] = 127,
	[1][0][RTW89_FCC][0] = 64,
	[1][0][RTW89_ETSI][0] = 34,
	[1][0][RTW89_MKK][0] = 38,
	[1][0][RTW89_IC][0] = 38,
	[1][0][RTW89_KCC][0] = 52,
	[1][0][RTW89_ACMA][0] = 34,
	[1][0][RTW89_CN][0] = 26,
	[1][0][RTW89_UK][0] = 34,
	[1][0][RTW89_FCC][2] = 66,
	[1][0][RTW89_ETSI][2] = 34,
	[1][0][RTW89_MKK][2] = 38,
	[1][0][RTW89_IC][2] = 38,
	[1][0][RTW89_KCC][2] = 52,
	[1][0][RTW89_ACMA][2] = 34,
	[1][0][RTW89_CN][2] = 26,
	[1][0][RTW89_UK][2] = 34,
	[1][0][RTW89_FCC][4] = 62,
	[1][0][RTW89_ETSI][4] = 34,
	[1][0][RTW89_MKK][4] = 36,
	[1][0][RTW89_IC][4] = 38,
	[1][0][RTW89_KCC][4] = 52,
	[1][0][RTW89_ACMA][4] = 34,
	[1][0][RTW89_CN][4] = 26,
	[1][0][RTW89_UK][4] = 34,
	[1][0][RTW89_FCC][6] = 62,
	[1][0][RTW89_ETSI][6] = 34,
	[1][0][RTW89_MKK][6] = 36,
	[1][0][RTW89_IC][6] = 38,
	[1][0][RTW89_KCC][6] = 32,
	[1][0][RTW89_ACMA][6] = 34,
	[1][0][RTW89_CN][6] = 26,
	[1][0][RTW89_UK][6] = 34,
	[1][0][RTW89_FCC][8] = 62,
	[1][0][RTW89_ETSI][8] = 34,
	[1][0][RTW89_MKK][8] = 38,
	[1][0][RTW89_IC][8] = 62,
	[1][0][RTW89_KCC][8] = 52,
	[1][0][RTW89_ACMA][8] = 34,
	[1][0][RTW89_CN][8] = 26,
	[1][0][RTW89_UK][8] = 34,
	[1][0][RTW89_FCC][10] = 62,
	[1][0][RTW89_ETSI][10] = 34,
	[1][0][RTW89_MKK][10] = 38,
	[1][0][RTW89_IC][10] = 62,
	[1][0][RTW89_KCC][10] = 52,
	[1][0][RTW89_ACMA][10] = 34,
	[1][0][RTW89_CN][10] = 26,
	[1][0][RTW89_UK][10] = 34,
	[1][0][RTW89_FCC][12] = 62,
	[1][0][RTW89_ETSI][12] = 34,
	[1][0][RTW89_MKK][12] = 38,
	[1][0][RTW89_IC][12] = 62,
	[1][0][RTW89_KCC][12] = 54,
	[1][0][RTW89_ACMA][12] = 34,
	[1][0][RTW89_CN][12] = 26,
	[1][0][RTW89_UK][12] = 34,
	[1][0][RTW89_FCC][14] = 64,
	[1][0][RTW89_ETSI][14] = 34,
	[1][0][RTW89_MKK][14] = 38,
	[1][0][RTW89_IC][14] = 64,
	[1][0][RTW89_KCC][14] = 54,
	[1][0][RTW89_ACMA][14] = 34,
	[1][0][RTW89_CN][14] = 26,
	[1][0][RTW89_UK][14] = 34,
	[1][0][RTW89_FCC][15] = 62,
	[1][0][RTW89_ETSI][15] = 34,
	[1][0][RTW89_MKK][15] = 58,
	[1][0][RTW89_IC][15] = 62,
	[1][0][RTW89_KCC][15] = 54,
	[1][0][RTW89_ACMA][15] = 34,
	[1][0][RTW89_CN][15] = 127,
	[1][0][RTW89_UK][15] = 34,
	[1][0][RTW89_FCC][17] = 62,
	[1][0][RTW89_ETSI][17] = 34,
	[1][0][RTW89_MKK][17] = 58,
	[1][0][RTW89_IC][17] = 62,
	[1][0][RTW89_KCC][17] = 54,
	[1][0][RTW89_ACMA][17] = 34,
	[1][0][RTW89_CN][17] = 127,
	[1][0][RTW89_UK][17] = 34,
	[1][0][RTW89_FCC][19] = 64,
	[1][0][RTW89_ETSI][19] = 34,
	[1][0][RTW89_MKK][19] = 58,
	[1][0][RTW89_IC][19] = 64,
	[1][0][RTW89_KCC][19] = 54,
	[1][0][RTW89_ACMA][19] = 34,
	[1][0][RTW89_CN][19] = 127,
	[1][0][RTW89_UK][19] = 34,
	[1][0][RTW89_FCC][21] = 64,
	[1][0][RTW89_ETSI][21] = 34,
	[1][0][RTW89_MKK][21] = 58,
	[1][0][RTW89_IC][21] = 64,
	[1][0][RTW89_KCC][21] = 54,
	[1][0][RTW89_ACMA][21] = 34,
	[1][0][RTW89_CN][21] = 127,
	[1][0][RTW89_UK][21] = 34,
	[1][0][RTW89_FCC][23] = 64,
	[1][0][RTW89_ETSI][23] = 34,
	[1][0][RTW89_MKK][23] = 58,
	[1][0][RTW89_IC][23] = 64,
	[1][0][RTW89_KCC][23] = 54,
	[1][0][RTW89_ACMA][23] = 34,
	[1][0][RTW89_CN][23] = 127,
	[1][0][RTW89_UK][23] = 34,
	[1][0][RTW89_FCC][25] = 64,
	[1][0][RTW89_ETSI][25] = 34,
	[1][0][RTW89_MKK][25] = 58,
	[1][0][RTW89_IC][25] = 127,
	[1][0][RTW89_KCC][25] = 54,
	[1][0][RTW89_ACMA][25] = 127,
	[1][0][RTW89_CN][25] = 127,
	[1][0][RTW89_UK][25] = 34,
	[1][0][RTW89_FCC][27] = 64,
	[1][0][RTW89_ETSI][27] = 34,
	[1][0][RTW89_MKK][27] = 58,
	[1][0][RTW89_IC][27] = 127,
	[1][0][RTW89_KCC][27] = 54,
	[1][0][RTW89_ACMA][27] = 127,
	[1][0][RTW89_CN][27] = 127,
	[1][0][RTW89_UK][27] = 34,
	[1][0][RTW89_FCC][29] = 64,
	[1][0][RTW89_ETSI][29] = 34,
	[1][0][RTW89_MKK][29] = 58,
	[1][0][RTW89_IC][29] = 127,
	[1][0][RTW89_KCC][29] = 54,
	[1][0][RTW89_ACMA][29] = 127,
	[1][0][RTW89_CN][29] = 127,
	[1][0][RTW89_UK][29] = 34,
	[1][0][RTW89_FCC][31] = 64,
	[1][0][RTW89_ETSI][31] = 34,
	[1][0][RTW89_MKK][31] = 58,
	[1][0][RTW89_IC][31] = 64,
	[1][0][RTW89_KCC][31] = 54,
	[1][0][RTW89_ACMA][31] = 34,
	[1][0][RTW89_CN][31] = 127,
	[1][0][RTW89_UK][31] = 34,
	[1][0][RTW89_FCC][33] = 64,
	[1][0][RTW89_ETSI][33] = 34,
	[1][0][RTW89_MKK][33] = 58,
	[1][0][RTW89_IC][33] = 64,
	[1][0][RTW89_KCC][33] = 54,
	[1][0][RTW89_ACMA][33] = 34,
	[1][0][RTW89_CN][33] = 127,
	[1][0][RTW89_UK][33] = 34,
	[1][0][RTW89_FCC][35] = 64,
	[1][0][RTW89_ETSI][35] = 34,
	[1][0][RTW89_MKK][35] = 58,
	[1][0][RTW89_IC][35] = 64,
	[1][0][RTW89_KCC][35] = 54,
	[1][0][RTW89_ACMA][35] = 34,
	[1][0][RTW89_CN][35] = 127,
	[1][0][RTW89_UK][35] = 34,
	[1][0][RTW89_FCC][37] = 78,
	[1][0][RTW89_ETSI][37] = 127,
	[1][0][RTW89_MKK][37] = 56,
	[1][0][RTW89_IC][37] = 78,
	[1][0][RTW89_KCC][37] = 54,
	[1][0][RTW89_ACMA][37] = 62,
	[1][0][RTW89_CN][37] = 127,
	[1][0][RTW89_UK][37] = 62,
	[1][0][RTW89_FCC][38] = 82,
	[1][0][RTW89_ETSI][38] = 28,
	[1][0][RTW89_MKK][38] = 127,
	[1][0][RTW89_IC][38] = 82,
	[1][0][RTW89_KCC][38] = 54,
	[1][0][RTW89_ACMA][38] = 84,
	[1][0][RTW89_CN][38] = 66,
	[1][0][RTW89_UK][38] = 34,
	[1][0][RTW89_FCC][40] = 82,
	[1][0][RTW89_ETSI][40] = 28,
	[1][0][RTW89_MKK][40] = 127,
	[1][0][RTW89_IC][40] = 82,
	[1][0][RTW89_KCC][40] = 54,
	[1][0][RTW89_ACMA][40] = 84,
	[1][0][RTW89_CN][40] = 66,
	[1][0][RTW89_UK][40] = 34,
	[1][0][RTW89_FCC][42] = 78,
	[1][0][RTW89_ETSI][42] = 28,
	[1][0][RTW89_MKK][42] = 127,
	[1][0][RTW89_IC][42] = 78,
	[1][0][RTW89_KCC][42] = 54,
	[1][0][RTW89_ACMA][42] = 84,
	[1][0][RTW89_CN][42] = 66,
	[1][0][RTW89_UK][42] = 34,
	[1][0][RTW89_FCC][44] = 82,
	[1][0][RTW89_ETSI][44] = 28,
	[1][0][RTW89_MKK][44] = 127,
	[1][0][RTW89_IC][44] = 82,
	[1][0][RTW89_KCC][44] = 54,
	[1][0][RTW89_ACMA][44] = 84,
	[1][0][RTW89_CN][44] = 66,
	[1][0][RTW89_UK][44] = 34,
	[1][0][RTW89_FCC][46] = 82,
	[1][0][RTW89_ETSI][46] = 28,
	[1][0][RTW89_MKK][46] = 127,
	[1][0][RTW89_IC][46] = 82,
	[1][0][RTW89_KCC][46] = 54,
	[1][0][RTW89_ACMA][46] = 84,
	[1][0][RTW89_CN][46] = 66,
	[1][0][RTW89_UK][46] = 34,
	[1][0][RTW89_FCC][48] = 52,
	[1][0][RTW89_ETSI][48] = 127,
	[1][0][RTW89_MKK][48] = 127,
	[1][0][RTW89_IC][48] = 127,
	[1][0][RTW89_KCC][48] = 127,
	[1][0][RTW89_ACMA][48] = 127,
	[1][0][RTW89_CN][48] = 127,
	[1][0][RTW89_UK][48] = 127,
	[1][0][RTW89_FCC][50] = 52,
	[1][0][RTW89_ETSI][50] = 127,
	[1][0][RTW89_MKK][50] = 127,
	[1][0][RTW89_IC][50] = 127,
	[1][0][RTW89_KCC][50] = 127,
	[1][0][RTW89_ACMA][50] = 127,
	[1][0][RTW89_CN][50] = 127,
	[1][0][RTW89_UK][50] = 127,
	[1][0][RTW89_FCC][52] = 52,
	[1][0][RTW89_ETSI][52] = 127,
	[1][0][RTW89_MKK][52] = 127,
	[1][0][RTW89_IC][52] = 127,
	[1][0][RTW89_KCC][52] = 127,
	[1][0][RTW89_ACMA][52] = 127,
	[1][0][RTW89_CN][52] = 127,
	[1][0][RTW89_UK][52] = 127,
	[1][1][RTW89_FCC][0] = 127,
	[1][1][RTW89_ETSI][0] = 127,
	[1][1][RTW89_MKK][0] = 127,
	[1][1][RTW89_IC][0] = 127,
	[1][1][RTW89_KCC][0] = 127,
	[1][1][RTW89_ACMA][0] = 127,
	[1][1][RTW89_CN][0] = 127,
	[1][1][RTW89_UK][0] = 127,
	[1][1][RTW89_FCC][2] = 127,
	[1][1][RTW89_ETSI][2] = 127,
	[1][1][RTW89_MKK][2] = 127,
	[1][1][RTW89_IC][2] = 127,
	[1][1][RTW89_KCC][2] = 127,
	[1][1][RTW89_ACMA][2] = 127,
	[1][1][RTW89_CN][2] = 127,
	[1][1][RTW89_UK][2] = 127,
	[1][1][RTW89_FCC][4] = 127,
	[1][1][RTW89_ETSI][4] = 127,
	[1][1][RTW89_MKK][4] = 127,
	[1][1][RTW89_IC][4] = 127,
	[1][1][RTW89_KCC][4] = 127,
	[1][1][RTW89_ACMA][4] = 127,
	[1][1][RTW89_CN][4] = 127,
	[1][1][RTW89_UK][4] = 127,
	[1][1][RTW89_FCC][6] = 127,
	[1][1][RTW89_ETSI][6] = 127,
	[1][1][RTW89_MKK][6] = 127,
	[1][1][RTW89_IC][6] = 127,
	[1][1][RTW89_KCC][6] = 127,
	[1][1][RTW89_ACMA][6] = 127,
	[1][1][RTW89_CN][6] = 127,
	[1][1][RTW89_UK][6] = 127,
	[1][1][RTW89_FCC][8] = 127,
	[1][1][RTW89_ETSI][8] = 127,
	[1][1][RTW89_MKK][8] = 127,
	[1][1][RTW89_IC][8] = 127,
	[1][1][RTW89_KCC][8] = 127,
	[1][1][RTW89_ACMA][8] = 127,
	[1][1][RTW89_CN][8] = 127,
	[1][1][RTW89_UK][8] = 127,
	[1][1][RTW89_FCC][10] = 127,
	[1][1][RTW89_ETSI][10] = 127,
	[1][1][RTW89_MKK][10] = 127,
	[1][1][RTW89_IC][10] = 127,
	[1][1][RTW89_KCC][10] = 127,
	[1][1][RTW89_ACMA][10] = 127,
	[1][1][RTW89_CN][10] = 127,
	[1][1][RTW89_UK][10] = 127,
	[1][1][RTW89_FCC][12] = 127,
	[1][1][RTW89_ETSI][12] = 127,
	[1][1][RTW89_MKK][12] = 127,
	[1][1][RTW89_IC][12] = 127,
	[1][1][RTW89_KCC][12] = 127,
	[1][1][RTW89_ACMA][12] = 127,
	[1][1][RTW89_CN][12] = 127,
	[1][1][RTW89_UK][12] = 127,
	[1][1][RTW89_FCC][14] = 127,
	[1][1][RTW89_ETSI][14] = 127,
	[1][1][RTW89_MKK][14] = 127,
	[1][1][RTW89_IC][14] = 127,
	[1][1][RTW89_KCC][14] = 127,
	[1][1][RTW89_ACMA][14] = 127,
	[1][1][RTW89_CN][14] = 127,
	[1][1][RTW89_UK][14] = 127,
	[1][1][RTW89_FCC][15] = 127,
	[1][1][RTW89_ETSI][15] = 127,
	[1][1][RTW89_MKK][15] = 127,
	[1][1][RTW89_IC][15] = 127,
	[1][1][RTW89_KCC][15] = 127,
	[1][1][RTW89_ACMA][15] = 127,
	[1][1][RTW89_CN][15] = 127,
	[1][1][RTW89_UK][15] = 127,
	[1][1][RTW89_FCC][17] = 127,
	[1][1][RTW89_ETSI][17] = 127,
	[1][1][RTW89_MKK][17] = 127,
	[1][1][RTW89_IC][17] = 127,
	[1][1][RTW89_KCC][17] = 127,
	[1][1][RTW89_ACMA][17] = 127,
	[1][1][RTW89_CN][17] = 127,
	[1][1][RTW89_UK][17] = 127,
	[1][1][RTW89_FCC][19] = 127,
	[1][1][RTW89_ETSI][19] = 127,
	[1][1][RTW89_MKK][19] = 127,
	[1][1][RTW89_IC][19] = 127,
	[1][1][RTW89_KCC][19] = 127,
	[1][1][RTW89_ACMA][19] = 127,
	[1][1][RTW89_CN][19] = 127,
	[1][1][RTW89_UK][19] = 127,
	[1][1][RTW89_FCC][21] = 127,
	[1][1][RTW89_ETSI][21] = 127,
	[1][1][RTW89_MKK][21] = 127,
	[1][1][RTW89_IC][21] = 127,
	[1][1][RTW89_KCC][21] = 127,
	[1][1][RTW89_ACMA][21] = 127,
	[1][1][RTW89_CN][21] = 127,
	[1][1][RTW89_UK][21] = 127,
	[1][1][RTW89_FCC][23] = 127,
	[1][1][RTW89_ETSI][23] = 127,
	[1][1][RTW89_MKK][23] = 127,
	[1][1][RTW89_IC][23] = 127,
	[1][1][RTW89_KCC][23] = 127,
	[1][1][RTW89_ACMA][23] = 127,
	[1][1][RTW89_CN][23] = 127,
	[1][1][RTW89_UK][23] = 127,
	[1][1][RTW89_FCC][25] = 127,
	[1][1][RTW89_ETSI][25] = 127,
	[1][1][RTW89_MKK][25] = 127,
	[1][1][RTW89_IC][25] = 127,
	[1][1][RTW89_KCC][25] = 127,
	[1][1][RTW89_ACMA][25] = 127,
	[1][1][RTW89_CN][25] = 127,
	[1][1][RTW89_UK][25] = 127,
	[1][1][RTW89_FCC][27] = 127,
	[1][1][RTW89_ETSI][27] = 127,
	[1][1][RTW89_MKK][27] = 127,
	[1][1][RTW89_IC][27] = 127,
	[1][1][RTW89_KCC][27] = 127,
	[1][1][RTW89_ACMA][27] = 127,
	[1][1][RTW89_CN][27] = 127,
	[1][1][RTW89_UK][27] = 127,
	[1][1][RTW89_FCC][29] = 127,
	[1][1][RTW89_ETSI][29] = 127,
	[1][1][RTW89_MKK][29] = 127,
	[1][1][RTW89_IC][29] = 127,
	[1][1][RTW89_KCC][29] = 127,
	[1][1][RTW89_ACMA][29] = 127,
	[1][1][RTW89_CN][29] = 127,
	[1][1][RTW89_UK][29] = 127,
	[1][1][RTW89_FCC][31] = 127,
	[1][1][RTW89_ETSI][31] = 127,
	[1][1][RTW89_MKK][31] = 127,
	[1][1][RTW89_IC][31] = 127,
	[1][1][RTW89_KCC][31] = 127,
	[1][1][RTW89_ACMA][31] = 127,
	[1][1][RTW89_CN][31] = 127,
	[1][1][RTW89_UK][31] = 127,
	[1][1][RTW89_FCC][33] = 127,
	[1][1][RTW89_ETSI][33] = 127,
	[1][1][RTW89_MKK][33] = 127,
	[1][1][RTW89_IC][33] = 127,
	[1][1][RTW89_KCC][33] = 127,
	[1][1][RTW89_ACMA][33] = 127,
	[1][1][RTW89_CN][33] = 127,
	[1][1][RTW89_UK][33] = 127,
	[1][1][RTW89_FCC][35] = 127,
	[1][1][RTW89_ETSI][35] = 127,
	[1][1][RTW89_MKK][35] = 127,
	[1][1][RTW89_IC][35] = 127,
	[1][1][RTW89_KCC][35] = 127,
	[1][1][RTW89_ACMA][35] = 127,
	[1][1][RTW89_CN][35] = 127,
	[1][1][RTW89_UK][35] = 127,
	[1][1][RTW89_FCC][37] = 127,
	[1][1][RTW89_ETSI][37] = 127,
	[1][1][RTW89_MKK][37] = 127,
	[1][1][RTW89_IC][37] = 127,
	[1][1][RTW89_KCC][37] = 127,
	[1][1][RTW89_ACMA][37] = 127,
	[1][1][RTW89_CN][37] = 127,
	[1][1][RTW89_UK][37] = 127,
	[1][1][RTW89_FCC][38] = 127,
	[1][1][RTW89_ETSI][38] = 127,
	[1][1][RTW89_MKK][38] = 127,
	[1][1][RTW89_IC][38] = 127,
	[1][1][RTW89_KCC][38] = 127,
	[1][1][RTW89_ACMA][38] = 127,
	[1][1][RTW89_CN][38] = 127,
	[1][1][RTW89_UK][38] = 127,
	[1][1][RTW89_FCC][40] = 127,
	[1][1][RTW89_ETSI][40] = 127,
	[1][1][RTW89_MKK][40] = 127,
	[1][1][RTW89_IC][40] = 127,
	[1][1][RTW89_KCC][40] = 127,
	[1][1][RTW89_ACMA][40] = 127,
	[1][1][RTW89_CN][40] = 127,
	[1][1][RTW89_UK][40] = 127,
	[1][1][RTW89_FCC][42] = 127,
	[1][1][RTW89_ETSI][42] = 127,
	[1][1][RTW89_MKK][42] = 127,
	[1][1][RTW89_IC][42] = 127,
	[1][1][RTW89_KCC][42] = 127,
	[1][1][RTW89_ACMA][42] = 127,
	[1][1][RTW89_CN][42] = 127,
	[1][1][RTW89_UK][42] = 127,
	[1][1][RTW89_FCC][44] = 127,
	[1][1][RTW89_ETSI][44] = 127,
	[1][1][RTW89_MKK][44] = 127,
	[1][1][RTW89_IC][44] = 127,
	[1][1][RTW89_KCC][44] = 127,
	[1][1][RTW89_ACMA][44] = 127,
	[1][1][RTW89_CN][44] = 127,
	[1][1][RTW89_UK][44] = 127,
	[1][1][RTW89_FCC][46] = 127,
	[1][1][RTW89_ETSI][46] = 127,
	[1][1][RTW89_MKK][46] = 127,
	[1][1][RTW89_IC][46] = 127,
	[1][1][RTW89_KCC][46] = 127,
	[1][1][RTW89_ACMA][46] = 127,
	[1][1][RTW89_CN][46] = 127,
	[1][1][RTW89_UK][46] = 127,
	[1][1][RTW89_FCC][48] = 127,
	[1][1][RTW89_ETSI][48] = 127,
	[1][1][RTW89_MKK][48] = 127,
	[1][1][RTW89_IC][48] = 127,
	[1][1][RTW89_KCC][48] = 127,
	[1][1][RTW89_ACMA][48] = 127,
	[1][1][RTW89_CN][48] = 127,
	[1][1][RTW89_UK][48] = 127,
	[1][1][RTW89_FCC][50] = 127,
	[1][1][RTW89_ETSI][50] = 127,
	[1][1][RTW89_MKK][50] = 127,
	[1][1][RTW89_IC][50] = 127,
	[1][1][RTW89_KCC][50] = 127,
	[1][1][RTW89_ACMA][50] = 127,
	[1][1][RTW89_CN][50] = 127,
	[1][1][RTW89_UK][50] = 127,
	[1][1][RTW89_FCC][52] = 127,
	[1][1][RTW89_ETSI][52] = 127,
	[1][1][RTW89_MKK][52] = 127,
	[1][1][RTW89_IC][52] = 127,
	[1][1][RTW89_KCC][52] = 127,
	[1][1][RTW89_ACMA][52] = 127,
	[1][1][RTW89_CN][52] = 127,
	[1][1][RTW89_UK][52] = 127,
	[2][0][RTW89_FCC][0] = 78,
	[2][0][RTW89_ETSI][0] = 46,
	[2][0][RTW89_MKK][0] = 48,
	[2][0][RTW89_IC][0] = 50,
	[2][0][RTW89_KCC][0] = 64,
	[2][0][RTW89_ACMA][0] = 46,
	[2][0][RTW89_CN][0] = 40,
	[2][0][RTW89_UK][0] = 46,
	[2][0][RTW89_FCC][2] = 74,
	[2][0][RTW89_ETSI][2] = 46,
	[2][0][RTW89_MKK][2] = 48,
	[2][0][RTW89_IC][2] = 48,
	[2][0][RTW89_KCC][2] = 64,
	[2][0][RTW89_ACMA][2] = 46,
	[2][0][RTW89_CN][2] = 40,
	[2][0][RTW89_UK][2] = 46,
	[2][0][RTW89_FCC][4] = 74,
	[2][0][RTW89_ETSI][4] = 46,
	[2][0][RTW89_MKK][4] = 48,
	[2][0][RTW89_IC][4] = 48,
	[2][0][RTW89_KCC][4] = 64,
	[2][0][RTW89_ACMA][4] = 46,
	[2][0][RTW89_CN][4] = 40,
	[2][0][RTW89_UK][4] = 46,
	[2][0][RTW89_FCC][6] = 74,
	[2][0][RTW89_ETSI][6] = 46,
	[2][0][RTW89_MKK][6] = 48,
	[2][0][RTW89_IC][6] = 48,
	[2][0][RTW89_KCC][6] = 40,
	[2][0][RTW89_ACMA][6] = 46,
	[2][0][RTW89_CN][6] = 40,
	[2][0][RTW89_UK][6] = 46,
	[2][0][RTW89_FCC][8] = 74,
	[2][0][RTW89_ETSI][8] = 46,
	[2][0][RTW89_MKK][8] = 48,
	[2][0][RTW89_IC][8] = 64,
	[2][0][RTW89_KCC][8] = 66,
	[2][0][RTW89_ACMA][8] = 46,
	[2][0][RTW89_CN][8] = 40,
	[2][0][RTW89_UK][8] = 46,
	[2][0][RTW89_FCC][10] = 74,
	[2][0][RTW89_ETSI][10] = 46,
	[2][0][RTW89_MKK][10] = 48,
	[2][0][RTW89_IC][10] = 64,
	[2][0][RTW89_KCC][10] = 66,
	[2][0][RTW89_ACMA][10] = 46,
	[2][0][RTW89_CN][10] = 40,
	[2][0][RTW89_UK][10] = 46,
	[2][0][RTW89_FCC][12] = 74,
	[2][0][RTW89_ETSI][12] = 46,
	[2][0][RTW89_MKK][12] = 48,
	[2][0][RTW89_IC][12] = 64,
	[2][0][RTW89_KCC][12] = 64,
	[2][0][RTW89_ACMA][12] = 46,
	[2][0][RTW89_CN][12] = 40,
	[2][0][RTW89_UK][12] = 46,
	[2][0][RTW89_FCC][14] = 80,
	[2][0][RTW89_ETSI][14] = 46,
	[2][0][RTW89_MKK][14] = 48,
	[2][0][RTW89_IC][14] = 64,
	[2][0][RTW89_KCC][14] = 64,
	[2][0][RTW89_ACMA][14] = 46,
	[2][0][RTW89_CN][14] = 40,
	[2][0][RTW89_UK][14] = 46,
	[2][0][RTW89_FCC][15] = 72,
	[2][0][RTW89_ETSI][15] = 46,
	[2][0][RTW89_MKK][15] = 70,
	[2][0][RTW89_IC][15] = 72,
	[2][0][RTW89_KCC][15] = 66,
	[2][0][RTW89_ACMA][15] = 46,
	[2][0][RTW89_CN][15] = 127,
	[2][0][RTW89_UK][15] = 46,
	[2][0][RTW89_FCC][17] = 72,
	[2][0][RTW89_ETSI][17] = 46,
	[2][0][RTW89_MKK][17] = 70,
	[2][0][RTW89_IC][17] = 72,
	[2][0][RTW89_KCC][17] = 66,
	[2][0][RTW89_ACMA][17] = 46,
	[2][0][RTW89_CN][17] = 127,
	[2][0][RTW89_UK][17] = 46,
	[2][0][RTW89_FCC][19] = 70,
	[2][0][RTW89_ETSI][19] = 46,
	[2][0][RTW89_MKK][19] = 70,
	[2][0][RTW89_IC][19] = 70,
	[2][0][RTW89_KCC][19] = 66,
	[2][0][RTW89_ACMA][19] = 46,
	[2][0][RTW89_CN][19] = 127,
	[2][0][RTW89_UK][19] = 46,
	[2][0][RTW89_FCC][21] = 70,
	[2][0][RTW89_ETSI][21] = 46,
	[2][0][RTW89_MKK][21] = 70,
	[2][0][RTW89_IC][21] = 70,
	[2][0][RTW89_KCC][21] = 66,
	[2][0][RTW89_ACMA][21] = 46,
	[2][0][RTW89_CN][21] = 127,
	[2][0][RTW89_UK][21] = 46,
	[2][0][RTW89_FCC][23] = 70,
	[2][0][RTW89_ETSI][23] = 46,
	[2][0][RTW89_MKK][23] = 70,
	[2][0][RTW89_IC][23] = 70,
	[2][0][RTW89_KCC][23] = 66,
	[2][0][RTW89_ACMA][23] = 46,
	[2][0][RTW89_CN][23] = 127,
	[2][0][RTW89_UK][23] = 46,
	[2][0][RTW89_FCC][25] = 70,
	[2][0][RTW89_ETSI][25] = 46,
	[2][0][RTW89_MKK][25] = 70,
	[2][0][RTW89_IC][25] = 127,
	[2][0][RTW89_KCC][25] = 66,
	[2][0][RTW89_ACMA][25] = 127,
	[2][0][RTW89_CN][25] = 127,
	[2][0][RTW89_UK][25] = 46,
	[2][0][RTW89_FCC][27] = 70,
	[2][0][RTW89_ETSI][27] = 46,
	[2][0][RTW89_MKK][27] = 70,
	[2][0][RTW89_IC][27] = 127,
	[2][0][RTW89_KCC][27] = 64,
	[2][0][RTW89_ACMA][27] = 127,
	[2][0][RTW89_CN][27] = 127,
	[2][0][RTW89_UK][27] = 46,
	[2][0][RTW89_FCC][29] = 70,
	[2][0][RTW89_ETSI][29] = 46,
	[2][0][RTW89_MKK][29] = 70,
	[2][0][RTW89_IC][29] = 127,
	[2][0][RTW89_KCC][29] = 64,
	[2][0][RTW89_ACMA][29] = 127,
	[2][0][RTW89_CN][29] = 127,
	[2][0][RTW89_UK][29] = 46,
	[2][0][RTW89_FCC][31] = 70,
	[2][0][RTW89_ETSI][31] = 46,
	[2][0][RTW89_MKK][31] = 70,
	[2][0][RTW89_IC][31] = 70,
	[2][0][RTW89_KCC][31] = 64,
	[2][0][RTW89_ACMA][31] = 46,
	[2][0][RTW89_CN][31] = 127,
	[2][0][RTW89_UK][31] = 46,
	[2][0][RTW89_FCC][33] = 70,
	[2][0][RTW89_ETSI][33] = 46,
	[2][0][RTW89_MKK][33] = 70,
	[2][0][RTW89_IC][33] = 70,
	[2][0][RTW89_KCC][33] = 64,
	[2][0][RTW89_ACMA][33] = 46,
	[2][0][RTW89_CN][33] = 127,
	[2][0][RTW89_UK][33] = 46,
	[2][0][RTW89_FCC][35] = 70,
	[2][0][RTW89_ETSI][35] = 46,
	[2][0][RTW89_MKK][35] = 70,
	[2][0][RTW89_IC][35] = 70,
	[2][0][RTW89_KCC][35] = 64,
	[2][0][RTW89_ACMA][35] = 46,
	[2][0][RTW89_CN][35] = 127,
	[2][0][RTW89_UK][35] = 46,
	[2][0][RTW89_FCC][37] = 84,
	[2][0][RTW89_ETSI][37] = 127,
	[2][0][RTW89_MKK][37] = 68,
	[2][0][RTW89_IC][37] = 84,
	[2][0][RTW89_KCC][37] = 66,
	[2][0][RTW89_ACMA][37] = 74,
	[2][0][RTW89_CN][37] = 127,
	[2][0][RTW89_UK][37] = 74,
	[2][0][RTW89_FCC][38] = 84,
	[2][0][RTW89_ETSI][38] = 28,
	[2][0][RTW89_MKK][38] = 127,
	[2][0][RTW89_IC][38] = 84,
	[2][0][RTW89_KCC][38] = 64,
	[2][0][RTW89_ACMA][38] = 84,
	[2][0][RTW89_CN][38] = 68,
	[2][0][RTW89_UK][38] = 46,
	[2][0][RTW89_FCC][40] = 84,
	[2][0][RTW89_ETSI][40] = 28,
	[2][0][RTW89_MKK][40] = 127,
	[2][0][RTW89_IC][40] = 84,
	[2][0][RTW89_KCC][40] = 64,
	[2][0][RTW89_ACMA][40] = 84,
	[2][0][RTW89_CN][40] = 68,
	[2][0][RTW89_UK][40] = 46,
	[2][0][RTW89_FCC][42] = 80,
	[2][0][RTW89_ETSI][42] = 28,
	[2][0][RTW89_MKK][42] = 127,
	[2][0][RTW89_IC][42] = 80,
	[2][0][RTW89_KCC][42] = 66,
	[2][0][RTW89_ACMA][42] = 84,
	[2][0][RTW89_CN][42] = 68,
	[2][0][RTW89_UK][42] = 46,
	[2][0][RTW89_FCC][44] = 82,
	[2][0][RTW89_ETSI][44] = 28,
	[2][0][RTW89_MKK][44] = 127,
	[2][0][RTW89_IC][44] = 82,
	[2][0][RTW89_KCC][44] = 66,
	[2][0][RTW89_ACMA][44] = 84,
	[2][0][RTW89_CN][44] = 68,
	[2][0][RTW89_UK][44] = 46,
	[2][0][RTW89_FCC][46] = 82,
	[2][0][RTW89_ETSI][46] = 28,
	[2][0][RTW89_MKK][46] = 127,
	[2][0][RTW89_IC][46] = 82,
	[2][0][RTW89_KCC][46] = 66,
	[2][0][RTW89_ACMA][46] = 84,
	[2][0][RTW89_CN][46] = 68,
	[2][0][RTW89_UK][46] = 46,
	[2][0][RTW89_FCC][48] = 64,
	[2][0][RTW89_ETSI][48] = 127,
	[2][0][RTW89_MKK][48] = 127,
	[2][0][RTW89_IC][48] = 127,
	[2][0][RTW89_KCC][48] = 127,
	[2][0][RTW89_ACMA][48] = 127,
	[2][0][RTW89_CN][48] = 127,
	[2][0][RTW89_UK][48] = 127,
	[2][0][RTW89_FCC][50] = 64,
	[2][0][RTW89_ETSI][50] = 127,
	[2][0][RTW89_MKK][50] = 127,
	[2][0][RTW89_IC][50] = 127,
	[2][0][RTW89_KCC][50] = 127,
	[2][0][RTW89_ACMA][50] = 127,
	[2][0][RTW89_CN][50] = 127,
	[2][0][RTW89_UK][50] = 127,
	[2][0][RTW89_FCC][52] = 60,
	[2][0][RTW89_ETSI][52] = 127,
	[2][0][RTW89_MKK][52] = 127,
	[2][0][RTW89_IC][52] = 127,
	[2][0][RTW89_KCC][52] = 127,
	[2][0][RTW89_ACMA][52] = 127,
	[2][0][RTW89_CN][52] = 127,
	[2][0][RTW89_UK][52] = 127,
	[2][1][RTW89_FCC][0] = 127,
	[2][1][RTW89_ETSI][0] = 127,
	[2][1][RTW89_MKK][0] = 127,
	[2][1][RTW89_IC][0] = 127,
	[2][1][RTW89_KCC][0] = 127,
	[2][1][RTW89_ACMA][0] = 127,
	[2][1][RTW89_CN][0] = 127,
	[2][1][RTW89_UK][0] = 127,
	[2][1][RTW89_FCC][2] = 127,
	[2][1][RTW89_ETSI][2] = 127,
	[2][1][RTW89_MKK][2] = 127,
	[2][1][RTW89_IC][2] = 127,
	[2][1][RTW89_KCC][2] = 127,
	[2][1][RTW89_ACMA][2] = 127,
	[2][1][RTW89_CN][2] = 127,
	[2][1][RTW89_UK][2] = 127,
	[2][1][RTW89_FCC][4] = 127,
	[2][1][RTW89_ETSI][4] = 127,
	[2][1][RTW89_MKK][4] = 127,
	[2][1][RTW89_IC][4] = 127,
	[2][1][RTW89_KCC][4] = 127,
	[2][1][RTW89_ACMA][4] = 127,
	[2][1][RTW89_CN][4] = 127,
	[2][1][RTW89_UK][4] = 127,
	[2][1][RTW89_FCC][6] = 127,
	[2][1][RTW89_ETSI][6] = 127,
	[2][1][RTW89_MKK][6] = 127,
	[2][1][RTW89_IC][6] = 127,
	[2][1][RTW89_KCC][6] = 127,
	[2][1][RTW89_ACMA][6] = 127,
	[2][1][RTW89_CN][6] = 127,
	[2][1][RTW89_UK][6] = 127,
	[2][1][RTW89_FCC][8] = 127,
	[2][1][RTW89_ETSI][8] = 127,
	[2][1][RTW89_MKK][8] = 127,
	[2][1][RTW89_IC][8] = 127,
	[2][1][RTW89_KCC][8] = 127,
	[2][1][RTW89_ACMA][8] = 127,
	[2][1][RTW89_CN][8] = 127,
	[2][1][RTW89_UK][8] = 127,
	[2][1][RTW89_FCC][10] = 127,
	[2][1][RTW89_ETSI][10] = 127,
	[2][1][RTW89_MKK][10] = 127,
	[2][1][RTW89_IC][10] = 127,
	[2][1][RTW89_KCC][10] = 127,
	[2][1][RTW89_ACMA][10] = 127,
	[2][1][RTW89_CN][10] = 127,
	[2][1][RTW89_UK][10] = 127,
	[2][1][RTW89_FCC][12] = 127,
	[2][1][RTW89_ETSI][12] = 127,
	[2][1][RTW89_MKK][12] = 127,
	[2][1][RTW89_IC][12] = 127,
	[2][1][RTW89_KCC][12] = 127,
	[2][1][RTW89_ACMA][12] = 127,
	[2][1][RTW89_CN][12] = 127,
	[2][1][RTW89_UK][12] = 127,
	[2][1][RTW89_FCC][14] = 127,
	[2][1][RTW89_ETSI][14] = 127,
	[2][1][RTW89_MKK][14] = 127,
	[2][1][RTW89_IC][14] = 127,
	[2][1][RTW89_KCC][14] = 127,
	[2][1][RTW89_ACMA][14] = 127,
	[2][1][RTW89_CN][14] = 127,
	[2][1][RTW89_UK][14] = 127,
	[2][1][RTW89_FCC][15] = 127,
	[2][1][RTW89_ETSI][15] = 127,
	[2][1][RTW89_MKK][15] = 127,
	[2][1][RTW89_IC][15] = 127,
	[2][1][RTW89_KCC][15] = 127,
	[2][1][RTW89_ACMA][15] = 127,
	[2][1][RTW89_CN][15] = 127,
	[2][1][RTW89_UK][15] = 127,
	[2][1][RTW89_FCC][17] = 127,
	[2][1][RTW89_ETSI][17] = 127,
	[2][1][RTW89_MKK][17] = 127,
	[2][1][RTW89_IC][17] = 127,
	[2][1][RTW89_KCC][17] = 127,
	[2][1][RTW89_ACMA][17] = 127,
	[2][1][RTW89_CN][17] = 127,
	[2][1][RTW89_UK][17] = 127,
	[2][1][RTW89_FCC][19] = 127,
	[2][1][RTW89_ETSI][19] = 127,
	[2][1][RTW89_MKK][19] = 127,
	[2][1][RTW89_IC][19] = 127,
	[2][1][RTW89_KCC][19] = 127,
	[2][1][RTW89_ACMA][19] = 127,
	[2][1][RTW89_CN][19] = 127,
	[2][1][RTW89_UK][19] = 127,
	[2][1][RTW89_FCC][21] = 127,
	[2][1][RTW89_ETSI][21] = 127,
	[2][1][RTW89_MKK][21] = 127,
	[2][1][RTW89_IC][21] = 127,
	[2][1][RTW89_KCC][21] = 127,
	[2][1][RTW89_ACMA][21] = 127,
	[2][1][RTW89_CN][21] = 127,
	[2][1][RTW89_UK][21] = 127,
	[2][1][RTW89_FCC][23] = 127,
	[2][1][RTW89_ETSI][23] = 127,
	[2][1][RTW89_MKK][23] = 127,
	[2][1][RTW89_IC][23] = 127,
	[2][1][RTW89_KCC][23] = 127,
	[2][1][RTW89_ACMA][23] = 127,
	[2][1][RTW89_CN][23] = 127,
	[2][1][RTW89_UK][23] = 127,
	[2][1][RTW89_FCC][25] = 127,
	[2][1][RTW89_ETSI][25] = 127,
	[2][1][RTW89_MKK][25] = 127,
	[2][1][RTW89_IC][25] = 127,
	[2][1][RTW89_KCC][25] = 127,
	[2][1][RTW89_ACMA][25] = 127,
	[2][1][RTW89_CN][25] = 127,
	[2][1][RTW89_UK][25] = 127,
	[2][1][RTW89_FCC][27] = 127,
	[2][1][RTW89_ETSI][27] = 127,
	[2][1][RTW89_MKK][27] = 127,
	[2][1][RTW89_IC][27] = 127,
	[2][1][RTW89_KCC][27] = 127,
	[2][1][RTW89_ACMA][27] = 127,
	[2][1][RTW89_CN][27] = 127,
	[2][1][RTW89_UK][27] = 127,
	[2][1][RTW89_FCC][29] = 127,
	[2][1][RTW89_ETSI][29] = 127,
	[2][1][RTW89_MKK][29] = 127,
	[2][1][RTW89_IC][29] = 127,
	[2][1][RTW89_KCC][29] = 127,
	[2][1][RTW89_ACMA][29] = 127,
	[2][1][RTW89_CN][29] = 127,
	[2][1][RTW89_UK][29] = 127,
	[2][1][RTW89_FCC][31] = 127,
	[2][1][RTW89_ETSI][31] = 127,
	[2][1][RTW89_MKK][31] = 127,
	[2][1][RTW89_IC][31] = 127,
	[2][1][RTW89_KCC][31] = 127,
	[2][1][RTW89_ACMA][31] = 127,
	[2][1][RTW89_CN][31] = 127,
	[2][1][RTW89_UK][31] = 127,
	[2][1][RTW89_FCC][33] = 127,
	[2][1][RTW89_ETSI][33] = 127,
	[2][1][RTW89_MKK][33] = 127,
	[2][1][RTW89_IC][33] = 127,
	[2][1][RTW89_KCC][33] = 127,
	[2][1][RTW89_ACMA][33] = 127,
	[2][1][RTW89_CN][33] = 127,
	[2][1][RTW89_UK][33] = 127,
	[2][1][RTW89_FCC][35] = 127,
	[2][1][RTW89_ETSI][35] = 127,
	[2][1][RTW89_MKK][35] = 127,
	[2][1][RTW89_IC][35] = 127,
	[2][1][RTW89_KCC][35] = 127,
	[2][1][RTW89_ACMA][35] = 127,
	[2][1][RTW89_CN][35] = 127,
	[2][1][RTW89_UK][35] = 127,
	[2][1][RTW89_FCC][37] = 127,
	[2][1][RTW89_ETSI][37] = 127,
	[2][1][RTW89_MKK][37] = 127,
	[2][1][RTW89_IC][37] = 127,
	[2][1][RTW89_KCC][37] = 127,
	[2][1][RTW89_ACMA][37] = 127,
	[2][1][RTW89_CN][37] = 127,
	[2][1][RTW89_UK][37] = 127,
	[2][1][RTW89_FCC][38] = 127,
	[2][1][RTW89_ETSI][38] = 127,
	[2][1][RTW89_MKK][38] = 127,
	[2][1][RTW89_IC][38] = 127,
	[2][1][RTW89_KCC][38] = 127,
	[2][1][RTW89_ACMA][38] = 127,
	[2][1][RTW89_CN][38] = 127,
	[2][1][RTW89_UK][38] = 127,
	[2][1][RTW89_FCC][40] = 127,
	[2][1][RTW89_ETSI][40] = 127,
	[2][1][RTW89_MKK][40] = 127,
	[2][1][RTW89_IC][40] = 127,
	[2][1][RTW89_KCC][40] = 127,
	[2][1][RTW89_ACMA][40] = 127,
	[2][1][RTW89_CN][40] = 127,
	[2][1][RTW89_UK][40] = 127,
	[2][1][RTW89_FCC][42] = 127,
	[2][1][RTW89_ETSI][42] = 127,
	[2][1][RTW89_MKK][42] = 127,
	[2][1][RTW89_IC][42] = 127,
	[2][1][RTW89_KCC][42] = 127,
	[2][1][RTW89_ACMA][42] = 127,
	[2][1][RTW89_CN][42] = 127,
	[2][1][RTW89_UK][42] = 127,
	[2][1][RTW89_FCC][44] = 127,
	[2][1][RTW89_ETSI][44] = 127,
	[2][1][RTW89_MKK][44] = 127,
	[2][1][RTW89_IC][44] = 127,
	[2][1][RTW89_KCC][44] = 127,
	[2][1][RTW89_ACMA][44] = 127,
	[2][1][RTW89_CN][44] = 127,
	[2][1][RTW89_UK][44] = 127,
	[2][1][RTW89_FCC][46] = 127,
	[2][1][RTW89_ETSI][46] = 127,
	[2][1][RTW89_MKK][46] = 127,
	[2][1][RTW89_IC][46] = 127,
	[2][1][RTW89_KCC][46] = 127,
	[2][1][RTW89_ACMA][46] = 127,
	[2][1][RTW89_CN][46] = 127,
	[2][1][RTW89_UK][46] = 127,
	[2][1][RTW89_FCC][48] = 127,
	[2][1][RTW89_ETSI][48] = 127,
	[2][1][RTW89_MKK][48] = 127,
	[2][1][RTW89_IC][48] = 127,
	[2][1][RTW89_KCC][48] = 127,
	[2][1][RTW89_ACMA][48] = 127,
	[2][1][RTW89_CN][48] = 127,
	[2][1][RTW89_UK][48] = 127,
	[2][1][RTW89_FCC][50] = 127,
	[2][1][RTW89_ETSI][50] = 127,
	[2][1][RTW89_MKK][50] = 127,
	[2][1][RTW89_IC][50] = 127,
	[2][1][RTW89_KCC][50] = 127,
	[2][1][RTW89_ACMA][50] = 127,
	[2][1][RTW89_CN][50] = 127,
	[2][1][RTW89_UK][50] = 127,
	[2][1][RTW89_FCC][52] = 127,
	[2][1][RTW89_ETSI][52] = 127,
	[2][1][RTW89_MKK][52] = 127,
	[2][1][RTW89_IC][52] = 127,
	[2][1][RTW89_KCC][52] = 127,
	[2][1][RTW89_ACMA][52] = 127,
	[2][1][RTW89_CN][52] = 127,
	[2][1][RTW89_UK][52] = 127,
};

static
const s8 rtw89_8851b_txpwr_lmt_2g_type2[RTW89_2G_BW_NUM][RTW89_NTX_NUM]
				       [RTW89_RS_LMT_NUM][RTW89_BF_NUM]
				       [RTW89_REGD_NUM][RTW89_2G_CH_NUM] = {
	[0][0][0][0][RTW89_WW][0] = 56,
	[0][0][0][0][RTW89_WW][1] = 56,
	[0][0][0][0][RTW89_WW][2] = 56,
	[0][0][0][0][RTW89_WW][3] = 56,
	[0][0][0][0][RTW89_WW][4] = 56,
	[0][0][0][0][RTW89_WW][5] = 56,
	[0][0][0][0][RTW89_WW][6] = 56,
	[0][0][0][0][RTW89_WW][7] = 56,
	[0][0][0][0][RTW89_WW][8] = 56,
	[0][0][0][0][RTW89_WW][9] = 56,
	[0][0][0][0][RTW89_WW][10] = 56,
	[0][0][0][0][RTW89_WW][11] = 56,
	[0][0][0][0][RTW89_WW][12] = 42,
	[0][0][0][0][RTW89_WW][13] = 76,
	[0][1][0][0][RTW89_WW][0] = 0,
	[0][1][0][0][RTW89_WW][1] = 0,
	[0][1][0][0][RTW89_WW][2] = 0,
	[0][1][0][0][RTW89_WW][3] = 0,
	[0][1][0][0][RTW89_WW][4] = 0,
	[0][1][0][0][RTW89_WW][5] = 0,
	[0][1][0][0][RTW89_WW][6] = 0,
	[0][1][0][0][RTW89_WW][7] = 0,
	[0][1][0][0][RTW89_WW][8] = 0,
	[0][1][0][0][RTW89_WW][9] = 0,
	[0][1][0][0][RTW89_WW][10] = 0,
	[0][1][0][0][RTW89_WW][11] = 0,
	[0][1][0][0][RTW89_WW][12] = 0,
	[0][1][0][0][RTW89_WW][13] = 0,
	[1][0][0][0][RTW89_WW][0] = 0,
	[1][0][0][0][RTW89_WW][1] = 0,
	[1][0][0][0][RTW89_WW][2] = 56,
	[1][0][0][0][RTW89_WW][3] = 56,
	[1][0][0][0][RTW89_WW][4] = 56,
	[1][0][0][0][RTW89_WW][5] = 56,
	[1][0][0][0][RTW89_WW][6] = 56,
	[1][0][0][0][RTW89_WW][7] = 56,
	[1][0][0][0][RTW89_WW][8] = 56,
	[1][0][0][0][RTW89_WW][9] = 56,
	[1][0][0][0][RTW89_WW][10] = 42,
	[1][0][0][0][RTW89_WW][11] = 0,
	[1][0][0][0][RTW89_WW][12] = 0,
	[1][0][0][0][RTW89_WW][13] = 0,
	[1][1][0][0][RTW89_WW][0] = 0,
	[1][1][0][0][RTW89_WW][1] = 0,
	[1][1][0][0][RTW89_WW][2] = 0,
	[1][1][0][0][RTW89_WW][3] = 0,
	[1][1][0][0][RTW89_WW][4] = 0,
	[1][1][0][0][RTW89_WW][5] = 0,
	[1][1][0][0][RTW89_WW][6] = 0,
	[1][1][0][0][RTW89_WW][7] = 0,
	[1][1][0][0][RTW89_WW][8] = 0,
	[1][1][0][0][RTW89_WW][9] = 0,
	[1][1][0][0][RTW89_WW][10] = 0,
	[1][1][0][0][RTW89_WW][11] = 0,
	[1][1][0][0][RTW89_WW][12] = 0,
	[1][1][0][0][RTW89_WW][13] = 0,
	[0][0][1][0][RTW89_WW][0] = 58,
	[0][0][1][0][RTW89_WW][1] = 60,
	[0][0][1][0][RTW89_WW][2] = 60,
	[0][0][1][0][RTW89_WW][3] = 60,
	[0][0][1][0][RTW89_WW][4] = 60,
	[0][0][1][0][RTW89_WW][5] = 60,
	[0][0][1][0][RTW89_WW][6] = 60,
	[0][0][1][0][RTW89_WW][7] = 60,
	[0][0][1][0][RTW89_WW][8] = 60,
	[0][0][1][0][RTW89_WW][9] = 60,
	[0][0][1][0][RTW89_WW][10] = 60,
	[0][0][1][0][RTW89_WW][11] = 60,
	[0][0][1][0][RTW89_WW][12] = 40,
	[0][0][1][0][RTW89_WW][13] = 0,
	[0][1][1][0][RTW89_WW][0] = 0,
	[0][1][1][0][RTW89_WW][1] = 0,
	[0][1][1][0][RTW89_WW][2] = 0,
	[0][1][1][0][RTW89_WW][3] = 0,
	[0][1][1][0][RTW89_WW][4] = 0,
	[0][1][1][0][RTW89_WW][5] = 0,
	[0][1][1][0][RTW89_WW][6] = 0,
	[0][1][1][0][RTW89_WW][7] = 0,
	[0][1][1][0][RTW89_WW][8] = 0,
	[0][1][1][0][RTW89_WW][9] = 0,
	[0][1][1][0][RTW89_WW][10] = 0,
	[0][1][1][0][RTW89_WW][11] = 0,
	[0][1][1][0][RTW89_WW][12] = 0,
	[0][1][1][0][RTW89_WW][13] = 0,
	[0][0][2][0][RTW89_WW][0] = 58,
	[0][0][2][0][RTW89_WW][1] = 58,
	[0][0][2][0][RTW89_WW][2] = 58,
	[0][0][2][0][RTW89_WW][3] = 58,
	[0][0][2][0][RTW89_WW][4] = 58,
	[0][0][2][0][RTW89_WW][5] = 58,
	[0][0][2][0][RTW89_WW][6] = 58,
	[0][0][2][0][RTW89_WW][7] = 58,
	[0][0][2][0][RTW89_WW][8] = 58,
	[0][0][2][0][RTW89_WW][9] = 58,
	[0][0][2][0][RTW89_WW][10] = 58,
	[0][0][2][0][RTW89_WW][11] = 58,
	[0][0][2][0][RTW89_WW][12] = 38,
	[0][0][2][0][RTW89_WW][13] = 0,
	[0][1][2][0][RTW89_WW][0] = 0,
	[0][1][2][0][RTW89_WW][1] = 0,
	[0][1][2][0][RTW89_WW][2] = 0,
	[0][1][2][0][RTW89_WW][3] = 0,
	[0][1][2][0][RTW89_WW][4] = 0,
	[0][1][2][0][RTW89_WW][5] = 0,
	[0][1][2][0][RTW89_WW][6] = 0,
	[0][1][2][0][RTW89_WW][7] = 0,
	[0][1][2][0][RTW89_WW][8] = 0,
	[0][1][2][0][RTW89_WW][9] = 0,
	[0][1][2][0][RTW89_WW][10] = 0,
	[0][1][2][0][RTW89_WW][11] = 0,
	[0][1][2][0][RTW89_WW][12] = 0,
	[0][1][2][0][RTW89_WW][13] = 0,
	[0][1][2][1][RTW89_WW][0] = 0,
	[0][1][2][1][RTW89_WW][1] = 0,
	[0][1][2][1][RTW89_WW][2] = 0,
	[0][1][2][1][RTW89_WW][3] = 0,
	[0][1][2][1][RTW89_WW][4] = 0,
	[0][1][2][1][RTW89_WW][5] = 0,
	[0][1][2][1][RTW89_WW][6] = 0,
	[0][1][2][1][RTW89_WW][7] = 0,
	[0][1][2][1][RTW89_WW][8] = 0,
	[0][1][2][1][RTW89_WW][9] = 0,
	[0][1][2][1][RTW89_WW][10] = 0,
	[0][1][2][1][RTW89_WW][11] = 0,
	[0][1][2][1][RTW89_WW][12] = 0,
	[0][1][2][1][RTW89_WW][13] = 0,
	[1][0][2][0][RTW89_WW][0] = 0,
	[1][0][2][0][RTW89_WW][1] = 0,
	[1][0][2][0][RTW89_WW][2] = 56,
	[1][0][2][0][RTW89_WW][3] = 56,
	[1][0][2][0][RTW89_WW][4] = 56,
	[1][0][2][0][RTW89_WW][5] = 56,
	[1][0][2][0][RTW89_WW][6] = 56,
	[1][0][2][0][RTW89_WW][7] = 56,
	[1][0][2][0][RTW89_WW][8] = 56,
	[1][0][2][0][RTW89_WW][9] = 56,
	[1][0][2][0][RTW89_WW][10] = 48,
	[1][0][2][0][RTW89_WW][11] = 0,
	[1][0][2][0][RTW89_WW][12] = 0,
	[1][0][2][0][RTW89_WW][13] = 0,
	[1][1][2][0][RTW89_WW][0] = 0,
	[1][1][2][0][RTW89_WW][1] = 0,
	[1][1][2][0][RTW89_WW][2] = 0,
	[1][1][2][0][RTW89_WW][3] = 0,
	[1][1][2][0][RTW89_WW][4] = 0,
	[1][1][2][0][RTW89_WW][5] = 0,
	[1][1][2][0][RTW89_WW][6] = 0,
	[1][1][2][0][RTW89_WW][7] = 0,
	[1][1][2][0][RTW89_WW][8] = 0,
	[1][1][2][0][RTW89_WW][9] = 0,
	[1][1][2][0][RTW89_WW][10] = 0,
	[1][1][2][0][RTW89_WW][11] = 0,
	[1][1][2][0][RTW89_WW][12] = 0,
	[1][1][2][0][RTW89_WW][13] = 0,
	[1][1][2][1][RTW89_WW][0] = 0,
	[1][1][2][1][RTW89_WW][1] = 0,
	[1][1][2][1][RTW89_WW][2] = 0,
	[1][1][2][1][RTW89_WW][3] = 0,
	[1][1][2][1][RTW89_WW][4] = 0,
	[1][1][2][1][RTW89_WW][5] = 0,
	[1][1][2][1][RTW89_WW][6] = 0,
	[1][1][2][1][RTW89_WW][7] = 0,
	[1][1][2][1][RTW89_WW][8] = 0,
	[1][1][2][1][RTW89_WW][9] = 0,
	[1][1][2][1][RTW89_WW][10] = 0,
	[1][1][2][1][RTW89_WW][11] = 0,
	[1][1][2][1][RTW89_WW][12] = 0,
	[1][1][2][1][RTW89_WW][13] = 0,
	[0][0][0][0][RTW89_FCC][0] = 82,
	[0][0][0][0][RTW89_ETSI][0] = 58,
	[0][0][0][0][RTW89_MKK][0] = 68,
	[0][0][0][0][RTW89_IC][0] = 82,
	[0][0][0][0][RTW89_KCC][0] = 68,
	[0][0][0][0][RTW89_ACMA][0] = 58,
	[0][0][0][0][RTW89_CN][0] = 56,
	[0][0][0][0][RTW89_UK][0] = 58,
	[0][0][0][0][RTW89_FCC][1] = 82,
	[0][0][0][0][RTW89_ETSI][1] = 58,
	[0][0][0][0][RTW89_MKK][1] = 68,
	[0][0][0][0][RTW89_IC][1] = 82,
	[0][0][0][0][RTW89_KCC][1] = 68,
	[0][0][0][0][RTW89_ACMA][1] = 58,
	[0][0][0][0][RTW89_CN][1] = 56,
	[0][0][0][0][RTW89_UK][1] = 58,
	[0][0][0][0][RTW89_FCC][2] = 82,
	[0][0][0][0][RTW89_ETSI][2] = 58,
	[0][0][0][0][RTW89_MKK][2] = 68,
	[0][0][0][0][RTW89_IC][2] = 82,
	[0][0][0][0][RTW89_KCC][2] = 68,
	[0][0][0][0][RTW89_ACMA][2] = 58,
	[0][0][0][0][RTW89_CN][2] = 56,
	[0][0][0][0][RTW89_UK][2] = 58,
	[0][0][0][0][RTW89_FCC][3] = 82,
	[0][0][0][0][RTW89_ETSI][3] = 58,
	[0][0][0][0][RTW89_MKK][3] = 68,
	[0][0][0][0][RTW89_IC][3] = 82,
	[0][0][0][0][RTW89_KCC][3] = 68,
	[0][0][0][0][RTW89_ACMA][3] = 58,
	[0][0][0][0][RTW89_CN][3] = 56,
	[0][0][0][0][RTW89_UK][3] = 58,
	[0][0][0][0][RTW89_FCC][4] = 82,
	[0][0][0][0][RTW89_ETSI][4] = 58,
	[0][0][0][0][RTW89_MKK][4] = 68,
	[0][0][0][0][RTW89_IC][4] = 82,
	[0][0][0][0][RTW89_KCC][4] = 68,
	[0][0][0][0][RTW89_ACMA][4] = 58,
	[0][0][0][0][RTW89_CN][4] = 56,
	[0][0][0][0][RTW89_UK][4] = 58,
	[0][0][0][0][RTW89_FCC][5] = 82,
	[0][0][0][0][RTW89_ETSI][5] = 58,
	[0][0][0][0][RTW89_MKK][5] = 68,
	[0][0][0][0][RTW89_IC][5] = 82,
	[0][0][0][0][RTW89_KCC][5] = 68,
	[0][0][0][0][RTW89_ACMA][5] = 58,
	[0][0][0][0][RTW89_CN][5] = 56,
	[0][0][0][0][RTW89_UK][5] = 58,
	[0][0][0][0][RTW89_FCC][6] = 82,
	[0][0][0][0][RTW89_ETSI][6] = 58,
	[0][0][0][0][RTW89_MKK][6] = 68,
	[0][0][0][0][RTW89_IC][6] = 82,
	[0][0][0][0][RTW89_KCC][6] = 68,
	[0][0][0][0][RTW89_ACMA][6] = 58,
	[0][0][0][0][RTW89_CN][6] = 56,
	[0][0][0][0][RTW89_UK][6] = 58,
	[0][0][0][0][RTW89_FCC][7] = 82,
	[0][0][0][0][RTW89_ETSI][7] = 58,
	[0][0][0][0][RTW89_MKK][7] = 68,
	[0][0][0][0][RTW89_IC][7] = 82,
	[0][0][0][0][RTW89_KCC][7] = 68,
	[0][0][0][0][RTW89_ACMA][7] = 58,
	[0][0][0][0][RTW89_CN][7] = 56,
	[0][0][0][0][RTW89_UK][7] = 58,
	[0][0][0][0][RTW89_FCC][8] = 82,
	[0][0][0][0][RTW89_ETSI][8] = 58,
	[0][0][0][0][RTW89_MKK][8] = 68,
	[0][0][0][0][RTW89_IC][8] = 82,
	[0][0][0][0][RTW89_KCC][8] = 68,
	[0][0][0][0][RTW89_ACMA][8] = 58,
	[0][0][0][0][RTW89_CN][8] = 56,
	[0][0][0][0][RTW89_UK][8] = 58,
	[0][0][0][0][RTW89_FCC][9] = 82,
	[0][0][0][0][RTW89_ETSI][9] = 58,
	[0][0][0][0][RTW89_MKK][9] = 68,
	[0][0][0][0][RTW89_IC][9] = 82,
	[0][0][0][0][RTW89_KCC][9] = 68,
	[0][0][0][0][RTW89_ACMA][9] = 58,
	[0][0][0][0][RTW89_CN][9] = 56,
	[0][0][0][0][RTW89_UK][9] = 58,
	[0][0][0][0][RTW89_FCC][10] = 80,
	[0][0][0][0][RTW89_ETSI][10] = 58,
	[0][0][0][0][RTW89_MKK][10] = 68,
	[0][0][0][0][RTW89_IC][10] = 80,
	[0][0][0][0][RTW89_KCC][10] = 68,
	[0][0][0][0][RTW89_ACMA][10] = 58,
	[0][0][0][0][RTW89_CN][10] = 56,
	[0][0][0][0][RTW89_UK][10] = 58,
	[0][0][0][0][RTW89_FCC][11] = 60,
	[0][0][0][0][RTW89_ETSI][11] = 58,
	[0][0][0][0][RTW89_MKK][11] = 68,
	[0][0][0][0][RTW89_IC][11] = 60,
	[0][0][0][0][RTW89_KCC][11] = 68,
	[0][0][0][0][RTW89_ACMA][11] = 58,
	[0][0][0][0][RTW89_CN][11] = 56,
	[0][0][0][0][RTW89_UK][11] = 58,
	[0][0][0][0][RTW89_FCC][12] = 52,
	[0][0][0][0][RTW89_ETSI][12] = 58,
	[0][0][0][0][RTW89_MKK][12] = 68,
	[0][0][0][0][RTW89_IC][12] = 52,
	[0][0][0][0][RTW89_KCC][12] = 68,
	[0][0][0][0][RTW89_ACMA][12] = 58,
	[0][0][0][0][RTW89_CN][12] = 42,
	[0][0][0][0][RTW89_UK][12] = 58,
	[0][0][0][0][RTW89_FCC][13] = 127,
	[0][0][0][0][RTW89_ETSI][13] = 127,
	[0][0][0][0][RTW89_MKK][13] = 76,
	[0][0][0][0][RTW89_IC][13] = 127,
	[0][0][0][0][RTW89_KCC][13] = 127,
	[0][0][0][0][RTW89_ACMA][13] = 127,
	[0][0][0][0][RTW89_CN][13] = 127,
	[0][0][0][0][RTW89_UK][13] = 127,
	[0][1][0][0][RTW89_FCC][0] = 127,
	[0][1][0][0][RTW89_ETSI][0] = 127,
	[0][1][0][0][RTW89_MKK][0] = 127,
	[0][1][0][0][RTW89_IC][0] = 127,
	[0][1][0][0][RTW89_KCC][0] = 127,
	[0][1][0][0][RTW89_ACMA][0] = 127,
	[0][1][0][0][RTW89_CN][0] = 127,
	[0][1][0][0][RTW89_UK][0] = 127,
	[0][1][0][0][RTW89_FCC][1] = 127,
	[0][1][0][0][RTW89_ETSI][1] = 127,
	[0][1][0][0][RTW89_MKK][1] = 127,
	[0][1][0][0][RTW89_IC][1] = 127,
	[0][1][0][0][RTW89_KCC][1] = 127,
	[0][1][0][0][RTW89_ACMA][1] = 127,
	[0][1][0][0][RTW89_CN][1] = 127,
	[0][1][0][0][RTW89_UK][1] = 127,
	[0][1][0][0][RTW89_FCC][2] = 127,
	[0][1][0][0][RTW89_ETSI][2] = 127,
	[0][1][0][0][RTW89_MKK][2] = 127,
	[0][1][0][0][RTW89_IC][2] = 127,
	[0][1][0][0][RTW89_KCC][2] = 127,
	[0][1][0][0][RTW89_ACMA][2] = 127,
	[0][1][0][0][RTW89_CN][2] = 127,
	[0][1][0][0][RTW89_UK][2] = 127,
	[0][1][0][0][RTW89_FCC][3] = 127,
	[0][1][0][0][RTW89_ETSI][3] = 127,
	[0][1][0][0][RTW89_MKK][3] = 127,
	[0][1][0][0][RTW89_IC][3] = 127,
	[0][1][0][0][RTW89_KCC][3] = 127,
	[0][1][0][0][RTW89_ACMA][3] = 127,
	[0][1][0][0][RTW89_CN][3] = 127,
	[0][1][0][0][RTW89_UK][3] = 127,
	[0][1][0][0][RTW89_FCC][4] = 127,
	[0][1][0][0][RTW89_ETSI][4] = 127,
	[0][1][0][0][RTW89_MKK][4] = 127,
	[0][1][0][0][RTW89_IC][4] = 127,
	[0][1][0][0][RTW89_KCC][4] = 127,
	[0][1][0][0][RTW89_ACMA][4] = 127,
	[0][1][0][0][RTW89_CN][4] = 127,
	[0][1][0][0][RTW89_UK][4] = 127,
	[0][1][0][0][RTW89_FCC][5] = 127,
	[0][1][0][0][RTW89_ETSI][5] = 127,
	[0][1][0][0][RTW89_MKK][5] = 127,
	[0][1][0][0][RTW89_IC][5] = 127,
	[0][1][0][0][RTW89_KCC][5] = 127,
	[0][1][0][0][RTW89_ACMA][5] = 127,
	[0][1][0][0][RTW89_CN][5] = 127,
	[0][1][0][0][RTW89_UK][5] = 127,
	[0][1][0][0][RTW89_FCC][6] = 127,
	[0][1][0][0][RTW89_ETSI][6] = 127,
	[0][1][0][0][RTW89_MKK][6] = 127,
	[0][1][0][0][RTW89_IC][6] = 127,
	[0][1][0][0][RTW89_KCC][6] = 127,
	[0][1][0][0][RTW89_ACMA][6] = 127,
	[0][1][0][0][RTW89_CN][6] = 127,
	[0][1][0][0][RTW89_UK][6] = 127,
	[0][1][0][0][RTW89_FCC][7] = 127,
	[0][1][0][0][RTW89_ETSI][7] = 127,
	[0][1][0][0][RTW89_MKK][7] = 127,
	[0][1][0][0][RTW89_IC][7] = 127,
	[0][1][0][0][RTW89_KCC][7] = 127,
	[0][1][0][0][RTW89_ACMA][7] = 127,
	[0][1][0][0][RTW89_CN][7] = 127,
	[0][1][0][0][RTW89_UK][7] = 127,
	[0][1][0][0][RTW89_FCC][8] = 127,
	[0][1][0][0][RTW89_ETSI][8] = 127,
	[0][1][0][0][RTW89_MKK][8] = 127,
	[0][1][0][0][RTW89_IC][8] = 127,
	[0][1][0][0][RTW89_KCC][8] = 127,
	[0][1][0][0][RTW89_ACMA][8] = 127,
	[0][1][0][0][RTW89_CN][8] = 127,
	[0][1][0][0][RTW89_UK][8] = 127,
	[0][1][0][0][RTW89_FCC][9] = 127,
	[0][1][0][0][RTW89_ETSI][9] = 127,
	[0][1][0][0][RTW89_MKK][9] = 127,
	[0][1][0][0][RTW89_IC][9] = 127,
	[0][1][0][0][RTW89_KCC][9] = 127,
	[0][1][0][0][RTW89_ACMA][9] = 127,
	[0][1][0][0][RTW89_CN][9] = 127,
	[0][1][0][0][RTW89_UK][9] = 127,
	[0][1][0][0][RTW89_FCC][10] = 127,
	[0][1][0][0][RTW89_ETSI][10] = 127,
	[0][1][0][0][RTW89_MKK][10] = 127,
	[0][1][0][0][RTW89_IC][10] = 127,
	[0][1][0][0][RTW89_KCC][10] = 127,
	[0][1][0][0][RTW89_ACMA][10] = 127,
	[0][1][0][0][RTW89_CN][10] = 127,
	[0][1][0][0][RTW89_UK][10] = 127,
	[0][1][0][0][RTW89_FCC][11] = 127,
	[0][1][0][0][RTW89_ETSI][11] = 127,
	[0][1][0][0][RTW89_MKK][11] = 127,
	[0][1][0][0][RTW89_IC][11] = 127,
	[0][1][0][0][RTW89_KCC][11] = 127,
	[0][1][0][0][RTW89_ACMA][11] = 127,
	[0][1][0][0][RTW89_CN][11] = 127,
	[0][1][0][0][RTW89_UK][11] = 127,
	[0][1][0][0][RTW89_FCC][12] = 127,
	[0][1][0][0][RTW89_ETSI][12] = 127,
	[0][1][0][0][RTW89_MKK][12] = 127,
	[0][1][0][0][RTW89_IC][12] = 127,
	[0][1][0][0][RTW89_KCC][12] = 127,
	[0][1][0][0][RTW89_ACMA][12] = 127,
	[0][1][0][0][RTW89_CN][12] = 127,
	[0][1][0][0][RTW89_UK][12] = 127,
	[0][1][0][0][RTW89_FCC][13] = 127,
	[0][1][0][0][RTW89_ETSI][13] = 127,
	[0][1][0][0][RTW89_MKK][13] = 127,
	[0][1][0][0][RTW89_IC][13] = 127,
	[0][1][0][0][RTW89_KCC][13] = 127,
	[0][1][0][0][RTW89_ACMA][13] = 127,
	[0][1][0][0][RTW89_CN][13] = 127,
	[0][1][0][0][RTW89_UK][13] = 127,
	[1][0][0][0][RTW89_FCC][0] = 127,
	[1][0][0][0][RTW89_ETSI][0] = 127,
	[1][0][0][0][RTW89_MKK][0] = 127,
	[1][0][0][0][RTW89_IC][0] = 127,
	[1][0][0][0][RTW89_KCC][0] = 127,
	[1][0][0][0][RTW89_ACMA][0] = 127,
	[1][0][0][0][RTW89_CN][0] = 127,
	[1][0][0][0][RTW89_UK][0] = 127,
	[1][0][0][0][RTW89_FCC][1] = 127,
	[1][0][0][0][RTW89_ETSI][1] = 127,
	[1][0][0][0][RTW89_MKK][1] = 127,
	[1][0][0][0][RTW89_IC][1] = 127,
	[1][0][0][0][RTW89_KCC][1] = 127,
	[1][0][0][0][RTW89_ACMA][1] = 127,
	[1][0][0][0][RTW89_CN][1] = 127,
	[1][0][0][0][RTW89_UK][1] = 127,
	[1][0][0][0][RTW89_FCC][2] = 127,
	[1][0][0][0][RTW89_ETSI][2] = 58,
	[1][0][0][0][RTW89_MKK][2] = 70,
	[1][0][0][0][RTW89_IC][2] = 127,
	[1][0][0][0][RTW89_KCC][2] = 68,
	[1][0][0][0][RTW89_ACMA][2] = 58,
	[1][0][0][0][RTW89_CN][2] = 56,
	[1][0][0][0][RTW89_UK][2] = 58,
	[1][0][0][0][RTW89_FCC][3] = 127,
	[1][0][0][0][RTW89_ETSI][3] = 58,
	[1][0][0][0][RTW89_MKK][3] = 76,
	[1][0][0][0][RTW89_IC][3] = 127,
	[1][0][0][0][RTW89_KCC][3] = 68,
	[1][0][0][0][RTW89_ACMA][3] = 58,
	[1][0][0][0][RTW89_CN][3] = 56,
	[1][0][0][0][RTW89_UK][3] = 58,
	[1][0][0][0][RTW89_FCC][4] = 127,
	[1][0][0][0][RTW89_ETSI][4] = 58,
	[1][0][0][0][RTW89_MKK][4] = 76,
	[1][0][0][0][RTW89_IC][4] = 127,
	[1][0][0][0][RTW89_KCC][4] = 68,
	[1][0][0][0][RTW89_ACMA][4] = 58,
	[1][0][0][0][RTW89_CN][4] = 56,
	[1][0][0][0][RTW89_UK][4] = 58,
	[1][0][0][0][RTW89_FCC][5] = 127,
	[1][0][0][0][RTW89_ETSI][5] = 58,
	[1][0][0][0][RTW89_MKK][5] = 76,
	[1][0][0][0][RTW89_IC][5] = 127,
	[1][0][0][0][RTW89_KCC][5] = 68,
	[1][0][0][0][RTW89_ACMA][5] = 58,
	[1][0][0][0][RTW89_CN][5] = 56,
	[1][0][0][0][RTW89_UK][5] = 58,
	[1][0][0][0][RTW89_FCC][6] = 127,
	[1][0][0][0][RTW89_ETSI][6] = 58,
	[1][0][0][0][RTW89_MKK][6] = 76,
	[1][0][0][0][RTW89_IC][6] = 127,
	[1][0][0][0][RTW89_KCC][6] = 68,
	[1][0][0][0][RTW89_ACMA][6] = 58,
	[1][0][0][0][RTW89_CN][6] = 56,
	[1][0][0][0][RTW89_UK][6] = 58,
	[1][0][0][0][RTW89_FCC][7] = 127,
	[1][0][0][0][RTW89_ETSI][7] = 58,
	[1][0][0][0][RTW89_MKK][7] = 76,
	[1][0][0][0][RTW89_IC][7] = 127,
	[1][0][0][0][RTW89_KCC][7] = 68,
	[1][0][0][0][RTW89_ACMA][7] = 58,
	[1][0][0][0][RTW89_CN][7] = 56,
	[1][0][0][0][RTW89_UK][7] = 58,
	[1][0][0][0][RTW89_FCC][8] = 127,
	[1][0][0][0][RTW89_ETSI][8] = 58,
	[1][0][0][0][RTW89_MKK][8] = 76,
	[1][0][0][0][RTW89_IC][8] = 127,
	[1][0][0][0][RTW89_KCC][8] = 68,
	[1][0][0][0][RTW89_ACMA][8] = 58,
	[1][0][0][0][RTW89_CN][8] = 56,
	[1][0][0][0][RTW89_UK][8] = 58,
	[1][0][0][0][RTW89_FCC][9] = 127,
	[1][0][0][0][RTW89_ETSI][9] = 58,
	[1][0][0][0][RTW89_MKK][9] = 76,
	[1][0][0][0][RTW89_IC][9] = 127,
	[1][0][0][0][RTW89_KCC][9] = 68,
	[1][0][0][0][RTW89_ACMA][9] = 58,
	[1][0][0][0][RTW89_CN][9] = 56,
	[1][0][0][0][RTW89_UK][9] = 58,
	[1][0][0][0][RTW89_FCC][10] = 127,
	[1][0][0][0][RTW89_ETSI][10] = 58,
	[1][0][0][0][RTW89_MKK][10] = 66,
	[1][0][0][0][RTW89_IC][10] = 127,
	[1][0][0][0][RTW89_KCC][10] = 68,
	[1][0][0][0][RTW89_ACMA][10] = 58,
	[1][0][0][0][RTW89_CN][10] = 42,
	[1][0][0][0][RTW89_UK][10] = 58,
	[1][0][0][0][RTW89_FCC][11] = 127,
	[1][0][0][0][RTW89_ETSI][11] = 127,
	[1][0][0][0][RTW89_MKK][11] = 127,
	[1][0][0][0][RTW89_IC][11] = 127,
	[1][0][0][0][RTW89_KCC][11] = 127,
	[1][0][0][0][RTW89_ACMA][11] = 127,
	[1][0][0][0][RTW89_CN][11] = 127,
	[1][0][0][0][RTW89_UK][11] = 127,
	[1][0][0][0][RTW89_FCC][12] = 127,
	[1][0][0][0][RTW89_ETSI][12] = 127,
	[1][0][0][0][RTW89_MKK][12] = 127,
	[1][0][0][0][RTW89_IC][12] = 127,
	[1][0][0][0][RTW89_KCC][12] = 127,
	[1][0][0][0][RTW89_ACMA][12] = 127,
	[1][0][0][0][RTW89_CN][12] = 127,
	[1][0][0][0][RTW89_UK][12] = 127,
	[1][0][0][0][RTW89_FCC][13] = 127,
	[1][0][0][0][RTW89_ETSI][13] = 127,
	[1][0][0][0][RTW89_MKK][13] = 127,
	[1][0][0][0][RTW89_IC][13] = 127,
	[1][0][0][0][RTW89_KCC][13] = 127,
	[1][0][0][0][RTW89_ACMA][13] = 127,
	[1][0][0][0][RTW89_CN][13] = 127,
	[1][0][0][0][RTW89_UK][13] = 127,
	[1][1][0][0][RTW89_FCC][0] = 127,
	[1][1][0][0][RTW89_ETSI][0] = 127,
	[1][1][0][0][RTW89_MKK][0] = 127,
	[1][1][0][0][RTW89_IC][0] = 127,
	[1][1][0][0][RTW89_KCC][0] = 127,
	[1][1][0][0][RTW89_ACMA][0] = 127,
	[1][1][0][0][RTW89_CN][0] = 127,
	[1][1][0][0][RTW89_UK][0] = 127,
	[1][1][0][0][RTW89_FCC][1] = 127,
	[1][1][0][0][RTW89_ETSI][1] = 127,
	[1][1][0][0][RTW89_MKK][1] = 127,
	[1][1][0][0][RTW89_IC][1] = 127,
	[1][1][0][0][RTW89_KCC][1] = 127,
	[1][1][0][0][RTW89_ACMA][1] = 127,
	[1][1][0][0][RTW89_CN][1] = 127,
	[1][1][0][0][RTW89_UK][1] = 127,
	[1][1][0][0][RTW89_FCC][2] = 127,
	[1][1][0][0][RTW89_ETSI][2] = 127,
	[1][1][0][0][RTW89_MKK][2] = 127,
	[1][1][0][0][RTW89_IC][2] = 127,
	[1][1][0][0][RTW89_KCC][2] = 127,
	[1][1][0][0][RTW89_ACMA][2] = 127,
	[1][1][0][0][RTW89_CN][2] = 127,
	[1][1][0][0][RTW89_UK][2] = 127,
	[1][1][0][0][RTW89_FCC][3] = 127,
	[1][1][0][0][RTW89_ETSI][3] = 127,
	[1][1][0][0][RTW89_MKK][3] = 127,
	[1][1][0][0][RTW89_IC][3] = 127,
	[1][1][0][0][RTW89_KCC][3] = 127,
	[1][1][0][0][RTW89_ACMA][3] = 127,
	[1][1][0][0][RTW89_CN][3] = 127,
	[1][1][0][0][RTW89_UK][3] = 127,
	[1][1][0][0][RTW89_FCC][4] = 127,
	[1][1][0][0][RTW89_ETSI][4] = 127,
	[1][1][0][0][RTW89_MKK][4] = 127,
	[1][1][0][0][RTW89_IC][4] = 127,
	[1][1][0][0][RTW89_KCC][4] = 127,
	[1][1][0][0][RTW89_ACMA][4] = 127,
	[1][1][0][0][RTW89_CN][4] = 127,
	[1][1][0][0][RTW89_UK][4] = 127,
	[1][1][0][0][RTW89_FCC][5] = 127,
	[1][1][0][0][RTW89_ETSI][5] = 127,
	[1][1][0][0][RTW89_MKK][5] = 127,
	[1][1][0][0][RTW89_IC][5] = 127,
	[1][1][0][0][RTW89_KCC][5] = 127,
	[1][1][0][0][RTW89_ACMA][5] = 127,
	[1][1][0][0][RTW89_CN][5] = 127,
	[1][1][0][0][RTW89_UK][5] = 127,
	[1][1][0][0][RTW89_FCC][6] = 127,
	[1][1][0][0][RTW89_ETSI][6] = 127,
	[1][1][0][0][RTW89_MKK][6] = 127,
	[1][1][0][0][RTW89_IC][6] = 127,
	[1][1][0][0][RTW89_KCC][6] = 127,
	[1][1][0][0][RTW89_ACMA][6] = 127,
	[1][1][0][0][RTW89_CN][6] = 127,
	[1][1][0][0][RTW89_UK][6] = 127,
	[1][1][0][0][RTW89_FCC][7] = 127,
	[1][1][0][0][RTW89_ETSI][7] = 127,
	[1][1][0][0][RTW89_MKK][7] = 127,
	[1][1][0][0][RTW89_IC][7] = 127,
	[1][1][0][0][RTW89_KCC][7] = 127,
	[1][1][0][0][RTW89_ACMA][7] = 127,
	[1][1][0][0][RTW89_CN][7] = 127,
	[1][1][0][0][RTW89_UK][7] = 127,
	[1][1][0][0][RTW89_FCC][8] = 127,
	[1][1][0][0][RTW89_ETSI][8] = 127,
	[1][1][0][0][RTW89_MKK][8] = 127,
	[1][1][0][0][RTW89_IC][8] = 127,
	[1][1][0][0][RTW89_KCC][8] = 127,
	[1][1][0][0][RTW89_ACMA][8] = 127,
	[1][1][0][0][RTW89_CN][8] = 127,
	[1][1][0][0][RTW89_UK][8] = 127,
	[1][1][0][0][RTW89_FCC][9] = 127,
	[1][1][0][0][RTW89_ETSI][9] = 127,
	[1][1][0][0][RTW89_MKK][9] = 127,
	[1][1][0][0][RTW89_IC][9] = 127,
	[1][1][0][0][RTW89_KCC][9] = 127,
	[1][1][0][0][RTW89_ACMA][9] = 127,
	[1][1][0][0][RTW89_CN][9] = 127,
	[1][1][0][0][RTW89_UK][9] = 127,
	[1][1][0][0][RTW89_FCC][10] = 127,
	[1][1][0][0][RTW89_ETSI][10] = 127,
	[1][1][0][0][RTW89_MKK][10] = 127,
	[1][1][0][0][RTW89_IC][10] = 127,
	[1][1][0][0][RTW89_KCC][10] = 127,
	[1][1][0][0][RTW89_ACMA][10] = 127,
	[1][1][0][0][RTW89_CN][10] = 127,
	[1][1][0][0][RTW89_UK][10] = 127,
	[1][1][0][0][RTW89_FCC][11] = 127,
	[1][1][0][0][RTW89_ETSI][11] = 127,
	[1][1][0][0][RTW89_MKK][11] = 127,
	[1][1][0][0][RTW89_IC][11] = 127,
	[1][1][0][0][RTW89_KCC][11] = 127,
	[1][1][0][0][RTW89_ACMA][11] = 127,
	[1][1][0][0][RTW89_CN][11] = 127,
	[1][1][0][0][RTW89_UK][11] = 127,
	[1][1][0][0][RTW89_FCC][12] = 127,
	[1][1][0][0][RTW89_ETSI][12] = 127,
	[1][1][0][0][RTW89_MKK][12] = 127,
	[1][1][0][0][RTW89_IC][12] = 127,
	[1][1][0][0][RTW89_KCC][12] = 127,
	[1][1][0][0][RTW89_ACMA][12] = 127,
	[1][1][0][0][RTW89_CN][12] = 127,
	[1][1][0][0][RTW89_UK][12] = 127,
	[1][1][0][0][RTW89_FCC][13] = 127,
	[1][1][0][0][RTW89_ETSI][13] = 127,
	[1][1][0][0][RTW89_MKK][13] = 127,
	[1][1][0][0][RTW89_IC][13] = 127,
	[1][1][0][0][RTW89_KCC][13] = 127,
	[1][1][0][0][RTW89_ACMA][13] = 127,
	[1][1][0][0][RTW89_CN][13] = 127,
	[1][1][0][0][RTW89_UK][13] = 127,
	[0][0][1][0][RTW89_FCC][0] = 78,
	[0][0][1][0][RTW89_ETSI][0] = 58,
	[0][0][1][0][RTW89_MKK][0] = 72,
	[0][0][1][0][RTW89_IC][0] = 78,
	[0][0][1][0][RTW89_KCC][0] = 76,
	[0][0][1][0][RTW89_ACMA][0] = 58,
	[0][0][1][0][RTW89_CN][0] = 60,
	[0][0][1][0][RTW89_UK][0] = 58,
	[0][0][1][0][RTW89_FCC][1] = 78,
	[0][0][1][0][RTW89_ETSI][1] = 60,
	[0][0][1][0][RTW89_MKK][1] = 74,
	[0][0][1][0][RTW89_IC][1] = 78,
	[0][0][1][0][RTW89_KCC][1] = 76,
	[0][0][1][0][RTW89_ACMA][1] = 60,
	[0][0][1][0][RTW89_CN][1] = 60,
	[0][0][1][0][RTW89_UK][1] = 60,
	[0][0][1][0][RTW89_FCC][2] = 80,
	[0][0][1][0][RTW89_ETSI][2] = 60,
	[0][0][1][0][RTW89_MKK][2] = 74,
	[0][0][1][0][RTW89_IC][2] = 80,
	[0][0][1][0][RTW89_KCC][2] = 76,
	[0][0][1][0][RTW89_ACMA][2] = 60,
	[0][0][1][0][RTW89_CN][2] = 60,
	[0][0][1][0][RTW89_UK][2] = 60,
	[0][0][1][0][RTW89_FCC][3] = 80,
	[0][0][1][0][RTW89_ETSI][3] = 60,
	[0][0][1][0][RTW89_MKK][3] = 74,
	[0][0][1][0][RTW89_IC][3] = 80,
	[0][0][1][0][RTW89_KCC][3] = 76,
	[0][0][1][0][RTW89_ACMA][3] = 60,
	[0][0][1][0][RTW89_CN][3] = 60,
	[0][0][1][0][RTW89_UK][3] = 60,
	[0][0][1][0][RTW89_FCC][4] = 80,
	[0][0][1][0][RTW89_ETSI][4] = 60,
	[0][0][1][0][RTW89_MKK][4] = 74,
	[0][0][1][0][RTW89_IC][4] = 80,
	[0][0][1][0][RTW89_KCC][4] = 76,
	[0][0][1][0][RTW89_ACMA][4] = 60,
	[0][0][1][0][RTW89_CN][4] = 60,
	[0][0][1][0][RTW89_UK][4] = 60,
	[0][0][1][0][RTW89_FCC][5] = 80,
	[0][0][1][0][RTW89_ETSI][5] = 60,
	[0][0][1][0][RTW89_MKK][5] = 74,
	[0][0][1][0][RTW89_IC][5] = 80,
	[0][0][1][0][RTW89_KCC][5] = 76,
	[0][0][1][0][RTW89_ACMA][5] = 60,
	[0][0][1][0][RTW89_CN][5] = 60,
	[0][0][1][0][RTW89_UK][5] = 60,
	[0][0][1][0][RTW89_FCC][6] = 80,
	[0][0][1][0][RTW89_ETSI][6] = 60,
	[0][0][1][0][RTW89_MKK][6] = 74,
	[0][0][1][0][RTW89_IC][6] = 80,
	[0][0][1][0][RTW89_KCC][6] = 76,
	[0][0][1][0][RTW89_ACMA][6] = 60,
	[0][0][1][0][RTW89_CN][6] = 60,
	[0][0][1][0][RTW89_UK][6] = 60,
	[0][0][1][0][RTW89_FCC][7] = 80,
	[0][0][1][0][RTW89_ETSI][7] = 60,
	[0][0][1][0][RTW89_MKK][7] = 74,
	[0][0][1][0][RTW89_IC][7] = 80,
	[0][0][1][0][RTW89_KCC][7] = 76,
	[0][0][1][0][RTW89_ACMA][7] = 60,
	[0][0][1][0][RTW89_CN][7] = 60,
	[0][0][1][0][RTW89_UK][7] = 60,
	[0][0][1][0][RTW89_FCC][8] = 80,
	[0][0][1][0][RTW89_ETSI][8] = 60,
	[0][0][1][0][RTW89_MKK][8] = 74,
	[0][0][1][0][RTW89_IC][8] = 80,
	[0][0][1][0][RTW89_KCC][8] = 76,
	[0][0][1][0][RTW89_ACMA][8] = 60,
	[0][0][1][0][RTW89_CN][8] = 60,
	[0][0][1][0][RTW89_UK][8] = 60,
	[0][0][1][0][RTW89_FCC][9] = 76,
	[0][0][1][0][RTW89_ETSI][9] = 60,
	[0][0][1][0][RTW89_MKK][9] = 74,
	[0][0][1][0][RTW89_IC][9] = 76,
	[0][0][1][0][RTW89_KCC][9] = 74,
	[0][0][1][0][RTW89_ACMA][9] = 60,
	[0][0][1][0][RTW89_CN][9] = 60,
	[0][0][1][0][RTW89_UK][9] = 60,
	[0][0][1][0][RTW89_FCC][10] = 76,
	[0][0][1][0][RTW89_ETSI][10] = 60,
	[0][0][1][0][RTW89_MKK][10] = 74,
	[0][0][1][0][RTW89_IC][10] = 76,
	[0][0][1][0][RTW89_KCC][10] = 74,
	[0][0][1][0][RTW89_ACMA][10] = 60,
	[0][0][1][0][RTW89_CN][10] = 60,
	[0][0][1][0][RTW89_UK][10] = 60,
	[0][0][1][0][RTW89_FCC][11] = 68,
	[0][0][1][0][RTW89_ETSI][11] = 60,
	[0][0][1][0][RTW89_MKK][11] = 74,
	[0][0][1][0][RTW89_IC][11] = 68,
	[0][0][1][0][RTW89_KCC][11] = 74,
	[0][0][1][0][RTW89_ACMA][11] = 60,
	[0][0][1][0][RTW89_CN][11] = 60,
	[0][0][1][0][RTW89_UK][11] = 60,
	[0][0][1][0][RTW89_FCC][12] = 64,
	[0][0][1][0][RTW89_ETSI][12] = 58,
	[0][0][1][0][RTW89_MKK][12] = 70,
	[0][0][1][0][RTW89_IC][12] = 64,
	[0][0][1][0][RTW89_KCC][12] = 74,
	[0][0][1][0][RTW89_ACMA][12] = 58,
	[0][0][1][0][RTW89_CN][12] = 40,
	[0][0][1][0][RTW89_UK][12] = 58,
	[0][0][1][0][RTW89_FCC][13] = 127,
	[0][0][1][0][RTW89_ETSI][13] = 127,
	[0][0][1][0][RTW89_MKK][13] = 127,
	[0][0][1][0][RTW89_IC][13] = 127,
	[0][0][1][0][RTW89_KCC][13] = 127,
	[0][0][1][0][RTW89_ACMA][13] = 127,
	[0][0][1][0][RTW89_CN][13] = 127,
	[0][0][1][0][RTW89_UK][13] = 127,
	[0][1][1][0][RTW89_FCC][0] = 127,
	[0][1][1][0][RTW89_ETSI][0] = 127,
	[0][1][1][0][RTW89_MKK][0] = 127,
	[0][1][1][0][RTW89_IC][0] = 127,
	[0][1][1][0][RTW89_KCC][0] = 127,
	[0][1][1][0][RTW89_ACMA][0] = 127,
	[0][1][1][0][RTW89_CN][0] = 127,
	[0][1][1][0][RTW89_UK][0] = 127,
	[0][1][1][0][RTW89_FCC][1] = 127,
	[0][1][1][0][RTW89_ETSI][1] = 127,
	[0][1][1][0][RTW89_MKK][1] = 127,
	[0][1][1][0][RTW89_IC][1] = 127,
	[0][1][1][0][RTW89_KCC][1] = 127,
	[0][1][1][0][RTW89_ACMA][1] = 127,
	[0][1][1][0][RTW89_CN][1] = 127,
	[0][1][1][0][RTW89_UK][1] = 127,
	[0][1][1][0][RTW89_FCC][2] = 127,
	[0][1][1][0][RTW89_ETSI][2] = 127,
	[0][1][1][0][RTW89_MKK][2] = 127,
	[0][1][1][0][RTW89_IC][2] = 127,
	[0][1][1][0][RTW89_KCC][2] = 127,
	[0][1][1][0][RTW89_ACMA][2] = 127,
	[0][1][1][0][RTW89_CN][2] = 127,
	[0][1][1][0][RTW89_UK][2] = 127,
	[0][1][1][0][RTW89_FCC][3] = 127,
	[0][1][1][0][RTW89_ETSI][3] = 127,
	[0][1][1][0][RTW89_MKK][3] = 127,
	[0][1][1][0][RTW89_IC][3] = 127,
	[0][1][1][0][RTW89_KCC][3] = 127,
	[0][1][1][0][RTW89_ACMA][3] = 127,
	[0][1][1][0][RTW89_CN][3] = 127,
	[0][1][1][0][RTW89_UK][3] = 127,
	[0][1][1][0][RTW89_FCC][4] = 127,
	[0][1][1][0][RTW89_ETSI][4] = 127,
	[0][1][1][0][RTW89_MKK][4] = 127,
	[0][1][1][0][RTW89_IC][4] = 127,
	[0][1][1][0][RTW89_KCC][4] = 127,
	[0][1][1][0][RTW89_ACMA][4] = 127,
	[0][1][1][0][RTW89_CN][4] = 127,
	[0][1][1][0][RTW89_UK][4] = 127,
	[0][1][1][0][RTW89_FCC][5] = 127,
	[0][1][1][0][RTW89_ETSI][5] = 127,
	[0][1][1][0][RTW89_MKK][5] = 127,
	[0][1][1][0][RTW89_IC][5] = 127,
	[0][1][1][0][RTW89_KCC][5] = 127,
	[0][1][1][0][RTW89_ACMA][5] = 127,
	[0][1][1][0][RTW89_CN][5] = 127,
	[0][1][1][0][RTW89_UK][5] = 127,
	[0][1][1][0][RTW89_FCC][6] = 127,
	[0][1][1][0][RTW89_ETSI][6] = 127,
	[0][1][1][0][RTW89_MKK][6] = 127,
	[0][1][1][0][RTW89_IC][6] = 127,
	[0][1][1][0][RTW89_KCC][6] = 127,
	[0][1][1][0][RTW89_ACMA][6] = 127,
	[0][1][1][0][RTW89_CN][6] = 127,
	[0][1][1][0][RTW89_UK][6] = 127,
	[0][1][1][0][RTW89_FCC][7] = 127,
	[0][1][1][0][RTW89_ETSI][7] = 127,
	[0][1][1][0][RTW89_MKK][7] = 127,
	[0][1][1][0][RTW89_IC][7] = 127,
	[0][1][1][0][RTW89_KCC][7] = 127,
	[0][1][1][0][RTW89_ACMA][7] = 127,
	[0][1][1][0][RTW89_CN][7] = 127,
	[0][1][1][0][RTW89_UK][7] = 127,
	[0][1][1][0][RTW89_FCC][8] = 127,
	[0][1][1][0][RTW89_ETSI][8] = 127,
	[0][1][1][0][RTW89_MKK][8] = 127,
	[0][1][1][0][RTW89_IC][8] = 127,
	[0][1][1][0][RTW89_KCC][8] = 127,
	[0][1][1][0][RTW89_ACMA][8] = 127,
	[0][1][1][0][RTW89_CN][8] = 127,
	[0][1][1][0][RTW89_UK][8] = 127,
	[0][1][1][0][RTW89_FCC][9] = 127,
	[0][1][1][0][RTW89_ETSI][9] = 127,
	[0][1][1][0][RTW89_MKK][9] = 127,
	[0][1][1][0][RTW89_IC][9] = 127,
	[0][1][1][0][RTW89_KCC][9] = 127,
	[0][1][1][0][RTW89_ACMA][9] = 127,
	[0][1][1][0][RTW89_CN][9] = 127,
	[0][1][1][0][RTW89_UK][9] = 127,
	[0][1][1][0][RTW89_FCC][10] = 127,
	[0][1][1][0][RTW89_ETSI][10] = 127,
	[0][1][1][0][RTW89_MKK][10] = 127,
	[0][1][1][0][RTW89_IC][10] = 127,
	[0][1][1][0][RTW89_KCC][10] = 127,
	[0][1][1][0][RTW89_ACMA][10] = 127,
	[0][1][1][0][RTW89_CN][10] = 127,
	[0][1][1][0][RTW89_UK][10] = 127,
	[0][1][1][0][RTW89_FCC][11] = 127,
	[0][1][1][0][RTW89_ETSI][11] = 127,
	[0][1][1][0][RTW89_MKK][11] = 127,
	[0][1][1][0][RTW89_IC][11] = 127,
	[0][1][1][0][RTW89_KCC][11] = 127,
	[0][1][1][0][RTW89_ACMA][11] = 127,
	[0][1][1][0][RTW89_CN][11] = 127,
	[0][1][1][0][RTW89_UK][11] = 127,
	[0][1][1][0][RTW89_FCC][12] = 127,
	[0][1][1][0][RTW89_ETSI][12] = 127,
	[0][1][1][0][RTW89_MKK][12] = 127,
	[0][1][1][0][RTW89_IC][12] = 127,
	[0][1][1][0][RTW89_KCC][12] = 127,
	[0][1][1][0][RTW89_ACMA][12] = 127,
	[0][1][1][0][RTW89_CN][12] = 127,
	[0][1][1][0][RTW89_UK][12] = 127,
	[0][1][1][0][RTW89_FCC][13] = 127,
	[0][1][1][0][RTW89_ETSI][13] = 127,
	[0][1][1][0][RTW89_MKK][13] = 127,
	[0][1][1][0][RTW89_IC][13] = 127,
	[0][1][1][0][RTW89_KCC][13] = 127,
	[0][1][1][0][RTW89_ACMA][13] = 127,
	[0][1][1][0][RTW89_CN][13] = 127,
	[0][1][1][0][RTW89_UK][13] = 127,
	[0][0][2][0][RTW89_FCC][0] = 78,
	[0][0][2][0][RTW89_ETSI][0] = 60,
	[0][0][2][0][RTW89_MKK][0] = 72,
	[0][0][2][0][RTW89_IC][0] = 78,
	[0][0][2][0][RTW89_KCC][0] = 76,
	[0][0][2][0][RTW89_ACMA][0] = 60,
	[0][0][2][0][RTW89_CN][0] = 58,
	[0][0][2][0][RTW89_UK][0] = 60,
	[0][0][2][0][RTW89_FCC][1] = 78,
	[0][0][2][0][RTW89_ETSI][1] = 60,
	[0][0][2][0][RTW89_MKK][1] = 76,
	[0][0][2][0][RTW89_IC][1] = 78,
	[0][0][2][0][RTW89_KCC][1] = 76,
	[0][0][2][0][RTW89_ACMA][1] = 60,
	[0][0][2][0][RTW89_CN][1] = 58,
	[0][0][2][0][RTW89_UK][1] = 60,
	[0][0][2][0][RTW89_FCC][2] = 80,
	[0][0][2][0][RTW89_ETSI][2] = 60,
	[0][0][2][0][RTW89_MKK][2] = 76,
	[0][0][2][0][RTW89_IC][2] = 80,
	[0][0][2][0][RTW89_KCC][2] = 76,
	[0][0][2][0][RTW89_ACMA][2] = 60,
	[0][0][2][0][RTW89_CN][2] = 58,
	[0][0][2][0][RTW89_UK][2] = 60,
	[0][0][2][0][RTW89_FCC][3] = 80,
	[0][0][2][0][RTW89_ETSI][3] = 60,
	[0][0][2][0][RTW89_MKK][3] = 76,
	[0][0][2][0][RTW89_IC][3] = 80,
	[0][0][2][0][RTW89_KCC][3] = 76,
	[0][0][2][0][RTW89_ACMA][3] = 60,
	[0][0][2][0][RTW89_CN][3] = 58,
	[0][0][2][0][RTW89_UK][3] = 60,
	[0][0][2][0][RTW89_FCC][4] = 80,
	[0][0][2][0][RTW89_ETSI][4] = 60,
	[0][0][2][0][RTW89_MKK][4] = 76,
	[0][0][2][0][RTW89_IC][4] = 80,
	[0][0][2][0][RTW89_KCC][4] = 76,
	[0][0][2][0][RTW89_ACMA][4] = 60,
	[0][0][2][0][RTW89_CN][4] = 58,
	[0][0][2][0][RTW89_UK][4] = 60,
	[0][0][2][0][RTW89_FCC][5] = 80,
	[0][0][2][0][RTW89_ETSI][5] = 60,
	[0][0][2][0][RTW89_MKK][5] = 76,
	[0][0][2][0][RTW89_IC][5] = 80,
	[0][0][2][0][RTW89_KCC][5] = 76,
	[0][0][2][0][RTW89_ACMA][5] = 60,
	[0][0][2][0][RTW89_CN][5] = 58,
	[0][0][2][0][RTW89_UK][5] = 60,
	[0][0][2][0][RTW89_FCC][6] = 80,
	[0][0][2][0][RTW89_ETSI][6] = 60,
	[0][0][2][0][RTW89_MKK][6] = 76,
	[0][0][2][0][RTW89_IC][6] = 80,
	[0][0][2][0][RTW89_KCC][6] = 76,
	[0][0][2][0][RTW89_ACMA][6] = 60,
	[0][0][2][0][RTW89_CN][6] = 58,
	[0][0][2][0][RTW89_UK][6] = 60,
	[0][0][2][0][RTW89_FCC][7] = 80,
	[0][0][2][0][RTW89_ETSI][7] = 60,
	[0][0][2][0][RTW89_MKK][7] = 76,
	[0][0][2][0][RTW89_IC][7] = 80,
	[0][0][2][0][RTW89_KCC][7] = 76,
	[0][0][2][0][RTW89_ACMA][7] = 60,
	[0][0][2][0][RTW89_CN][7] = 58,
	[0][0][2][0][RTW89_UK][7] = 60,
	[0][0][2][0][RTW89_FCC][8] = 78,
	[0][0][2][0][RTW89_ETSI][8] = 60,
	[0][0][2][0][RTW89_MKK][8] = 76,
	[0][0][2][0][RTW89_IC][8] = 78,
	[0][0][2][0][RTW89_KCC][8] = 76,
	[0][0][2][0][RTW89_ACMA][8] = 60,
	[0][0][2][0][RTW89_CN][8] = 58,
	[0][0][2][0][RTW89_UK][8] = 60,
	[0][0][2][0][RTW89_FCC][9] = 74,
	[0][0][2][0][RTW89_ETSI][9] = 60,
	[0][0][2][0][RTW89_MKK][9] = 76,
	[0][0][2][0][RTW89_IC][9] = 74,
	[0][0][2][0][RTW89_KCC][9] = 76,
	[0][0][2][0][RTW89_ACMA][9] = 60,
	[0][0][2][0][RTW89_CN][9] = 58,
	[0][0][2][0][RTW89_UK][9] = 60,
	[0][0][2][0][RTW89_FCC][10] = 74,
	[0][0][2][0][RTW89_ETSI][10] = 60,
	[0][0][2][0][RTW89_MKK][10] = 76,
	[0][0][2][0][RTW89_IC][10] = 74,
	[0][0][2][0][RTW89_KCC][10] = 76,
	[0][0][2][0][RTW89_ACMA][10] = 60,
	[0][0][2][0][RTW89_CN][10] = 58,
	[0][0][2][0][RTW89_UK][10] = 60,
	[0][0][2][0][RTW89_FCC][11] = 68,
	[0][0][2][0][RTW89_ETSI][11] = 60,
	[0][0][2][0][RTW89_MKK][11] = 76,
	[0][0][2][0][RTW89_IC][11] = 68,
	[0][0][2][0][RTW89_KCC][11] = 76,
	[0][0][2][0][RTW89_ACMA][11] = 60,
	[0][0][2][0][RTW89_CN][11] = 58,
	[0][0][2][0][RTW89_UK][11] = 60,
	[0][0][2][0][RTW89_FCC][12] = 68,
	[0][0][2][0][RTW89_ETSI][12] = 60,
	[0][0][2][0][RTW89_MKK][12] = 70,
	[0][0][2][0][RTW89_IC][12] = 68,
	[0][0][2][0][RTW89_KCC][12] = 76,
	[0][0][2][0][RTW89_ACMA][12] = 60,
	[0][0][2][0][RTW89_CN][12] = 38,
	[0][0][2][0][RTW89_UK][12] = 60,
	[0][0][2][0][RTW89_FCC][13] = 127,
	[0][0][2][0][RTW89_ETSI][13] = 127,
	[0][0][2][0][RTW89_MKK][13] = 127,
	[0][0][2][0][RTW89_IC][13] = 127,
	[0][0][2][0][RTW89_KCC][13] = 127,
	[0][0][2][0][RTW89_ACMA][13] = 127,
	[0][0][2][0][RTW89_CN][13] = 127,
	[0][0][2][0][RTW89_UK][13] = 127,
	[0][1][2][0][RTW89_FCC][0] = 127,
	[0][1][2][0][RTW89_ETSI][0] = 127,
	[0][1][2][0][RTW89_MKK][0] = 127,
	[0][1][2][0][RTW89_IC][0] = 127,
	[0][1][2][0][RTW89_KCC][0] = 127,
	[0][1][2][0][RTW89_ACMA][0] = 127,
	[0][1][2][0][RTW89_CN][0] = 127,
	[0][1][2][0][RTW89_UK][0] = 127,
	[0][1][2][0][RTW89_FCC][1] = 127,
	[0][1][2][0][RTW89_ETSI][1] = 127,
	[0][1][2][0][RTW89_MKK][1] = 127,
	[0][1][2][0][RTW89_IC][1] = 127,
	[0][1][2][0][RTW89_KCC][1] = 127,
	[0][1][2][0][RTW89_ACMA][1] = 127,
	[0][1][2][0][RTW89_CN][1] = 127,
	[0][1][2][0][RTW89_UK][1] = 127,
	[0][1][2][0][RTW89_FCC][2] = 127,
	[0][1][2][0][RTW89_ETSI][2] = 127,
	[0][1][2][0][RTW89_MKK][2] = 127,
	[0][1][2][0][RTW89_IC][2] = 127,
	[0][1][2][0][RTW89_KCC][2] = 127,
	[0][1][2][0][RTW89_ACMA][2] = 127,
	[0][1][2][0][RTW89_CN][2] = 127,
	[0][1][2][0][RTW89_UK][2] = 127,
	[0][1][2][0][RTW89_FCC][3] = 127,
	[0][1][2][0][RTW89_ETSI][3] = 127,
	[0][1][2][0][RTW89_MKK][3] = 127,
	[0][1][2][0][RTW89_IC][3] = 127,
	[0][1][2][0][RTW89_KCC][3] = 127,
	[0][1][2][0][RTW89_ACMA][3] = 127,
	[0][1][2][0][RTW89_CN][3] = 127,
	[0][1][2][0][RTW89_UK][3] = 127,
	[0][1][2][0][RTW89_FCC][4] = 127,
	[0][1][2][0][RTW89_ETSI][4] = 127,
	[0][1][2][0][RTW89_MKK][4] = 127,
	[0][1][2][0][RTW89_IC][4] = 127,
	[0][1][2][0][RTW89_KCC][4] = 127,
	[0][1][2][0][RTW89_ACMA][4] = 127,
	[0][1][2][0][RTW89_CN][4] = 127,
	[0][1][2][0][RTW89_UK][4] = 127,
	[0][1][2][0][RTW89_FCC][5] = 127,
	[0][1][2][0][RTW89_ETSI][5] = 127,
	[0][1][2][0][RTW89_MKK][5] = 127,
	[0][1][2][0][RTW89_IC][5] = 127,
	[0][1][2][0][RTW89_KCC][5] = 127,
	[0][1][2][0][RTW89_ACMA][5] = 127,
	[0][1][2][0][RTW89_CN][5] = 127,
	[0][1][2][0][RTW89_UK][5] = 127,
	[0][1][2][0][RTW89_FCC][6] = 127,
	[0][1][2][0][RTW89_ETSI][6] = 127,
	[0][1][2][0][RTW89_MKK][6] = 127,
	[0][1][2][0][RTW89_IC][6] = 127,
	[0][1][2][0][RTW89_KCC][6] = 127,
	[0][1][2][0][RTW89_ACMA][6] = 127,
	[0][1][2][0][RTW89_CN][6] = 127,
	[0][1][2][0][RTW89_UK][6] = 127,
	[0][1][2][0][RTW89_FCC][7] = 127,
	[0][1][2][0][RTW89_ETSI][7] = 127,
	[0][1][2][0][RTW89_MKK][7] = 127,
	[0][1][2][0][RTW89_IC][7] = 127,
	[0][1][2][0][RTW89_KCC][7] = 127,
	[0][1][2][0][RTW89_ACMA][7] = 127,
	[0][1][2][0][RTW89_CN][7] = 127,
	[0][1][2][0][RTW89_UK][7] = 127,
	[0][1][2][0][RTW89_FCC][8] = 127,
	[0][1][2][0][RTW89_ETSI][8] = 127,
	[0][1][2][0][RTW89_MKK][8] = 127,
	[0][1][2][0][RTW89_IC][8] = 127,
	[0][1][2][0][RTW89_KCC][8] = 127,
	[0][1][2][0][RTW89_ACMA][8] = 127,
	[0][1][2][0][RTW89_CN][8] = 127,
	[0][1][2][0][RTW89_UK][8] = 127,
	[0][1][2][0][RTW89_FCC][9] = 127,
	[0][1][2][0][RTW89_ETSI][9] = 127,
	[0][1][2][0][RTW89_MKK][9] = 127,
	[0][1][2][0][RTW89_IC][9] = 127,
	[0][1][2][0][RTW89_KCC][9] = 127,
	[0][1][2][0][RTW89_ACMA][9] = 127,
	[0][1][2][0][RTW89_CN][9] = 127,
	[0][1][2][0][RTW89_UK][9] = 127,
	[0][1][2][0][RTW89_FCC][10] = 127,
	[0][1][2][0][RTW89_ETSI][10] = 127,
	[0][1][2][0][RTW89_MKK][10] = 127,
	[0][1][2][0][RTW89_IC][10] = 127,
	[0][1][2][0][RTW89_KCC][10] = 127,
	[0][1][2][0][RTW89_ACMA][10] = 127,
	[0][1][2][0][RTW89_CN][10] = 127,
	[0][1][2][0][RTW89_UK][10] = 127,
	[0][1][2][0][RTW89_FCC][11] = 127,
	[0][1][2][0][RTW89_ETSI][11] = 127,
	[0][1][2][0][RTW89_MKK][11] = 127,
	[0][1][2][0][RTW89_IC][11] = 127,
	[0][1][2][0][RTW89_KCC][11] = 127,
	[0][1][2][0][RTW89_ACMA][11] = 127,
	[0][1][2][0][RTW89_CN][11] = 127,
	[0][1][2][0][RTW89_UK][11] = 127,
	[0][1][2][0][RTW89_FCC][12] = 127,
	[0][1][2][0][RTW89_ETSI][12] = 127,
	[0][1][2][0][RTW89_MKK][12] = 127,
	[0][1][2][0][RTW89_IC][12] = 127,
	[0][1][2][0][RTW89_KCC][12] = 127,
	[0][1][2][0][RTW89_ACMA][12] = 127,
	[0][1][2][0][RTW89_CN][12] = 127,
	[0][1][2][0][RTW89_UK][12] = 127,
	[0][1][2][0][RTW89_FCC][13] = 127,
	[0][1][2][0][RTW89_ETSI][13] = 127,
	[0][1][2][0][RTW89_MKK][13] = 127,
	[0][1][2][0][RTW89_IC][13] = 127,
	[0][1][2][0][RTW89_KCC][13] = 127,
	[0][1][2][0][RTW89_ACMA][13] = 127,
	[0][1][2][0][RTW89_CN][13] = 127,
	[0][1][2][0][RTW89_UK][13] = 127,
	[0][1][2][1][RTW89_FCC][0] = 127,
	[0][1][2][1][RTW89_ETSI][0] = 127,
	[0][1][2][1][RTW89_MKK][0] = 127,
	[0][1][2][1][RTW89_IC][0] = 127,
	[0][1][2][1][RTW89_KCC][0] = 127,
	[0][1][2][1][RTW89_ACMA][0] = 127,
	[0][1][2][1][RTW89_CN][0] = 127,
	[0][1][2][1][RTW89_UK][0] = 127,
	[0][1][2][1][RTW89_FCC][1] = 127,
	[0][1][2][1][RTW89_ETSI][1] = 127,
	[0][1][2][1][RTW89_MKK][1] = 127,
	[0][1][2][1][RTW89_IC][1] = 127,
	[0][1][2][1][RTW89_KCC][1] = 127,
	[0][1][2][1][RTW89_ACMA][1] = 127,
	[0][1][2][1][RTW89_CN][1] = 127,
	[0][1][2][1][RTW89_UK][1] = 127,
	[0][1][2][1][RTW89_FCC][2] = 127,
	[0][1][2][1][RTW89_ETSI][2] = 127,
	[0][1][2][1][RTW89_MKK][2] = 127,
	[0][1][2][1][RTW89_IC][2] = 127,
	[0][1][2][1][RTW89_KCC][2] = 127,
	[0][1][2][1][RTW89_ACMA][2] = 127,
	[0][1][2][1][RTW89_CN][2] = 127,
	[0][1][2][1][RTW89_UK][2] = 127,
	[0][1][2][1][RTW89_FCC][3] = 127,
	[0][1][2][1][RTW89_ETSI][3] = 127,
	[0][1][2][1][RTW89_MKK][3] = 127,
	[0][1][2][1][RTW89_IC][3] = 127,
	[0][1][2][1][RTW89_KCC][3] = 127,
	[0][1][2][1][RTW89_ACMA][3] = 127,
	[0][1][2][1][RTW89_CN][3] = 127,
	[0][1][2][1][RTW89_UK][3] = 127,
	[0][1][2][1][RTW89_FCC][4] = 127,
	[0][1][2][1][RTW89_ETSI][4] = 127,
	[0][1][2][1][RTW89_MKK][4] = 127,
	[0][1][2][1][RTW89_IC][4] = 127,
	[0][1][2][1][RTW89_KCC][4] = 127,
	[0][1][2][1][RTW89_ACMA][4] = 127,
	[0][1][2][1][RTW89_CN][4] = 127,
	[0][1][2][1][RTW89_UK][4] = 127,
	[0][1][2][1][RTW89_FCC][5] = 127,
	[0][1][2][1][RTW89_ETSI][5] = 127,
	[0][1][2][1][RTW89_MKK][5] = 127,
	[0][1][2][1][RTW89_IC][5] = 127,
	[0][1][2][1][RTW89_KCC][5] = 127,
	[0][1][2][1][RTW89_ACMA][5] = 127,
	[0][1][2][1][RTW89_CN][5] = 127,
	[0][1][2][1][RTW89_UK][5] = 127,
	[0][1][2][1][RTW89_FCC][6] = 127,
	[0][1][2][1][RTW89_ETSI][6] = 127,
	[0][1][2][1][RTW89_MKK][6] = 127,
	[0][1][2][1][RTW89_IC][6] = 127,
	[0][1][2][1][RTW89_KCC][6] = 127,
	[0][1][2][1][RTW89_ACMA][6] = 127,
	[0][1][2][1][RTW89_CN][6] = 127,
	[0][1][2][1][RTW89_UK][6] = 127,
	[0][1][2][1][RTW89_FCC][7] = 127,
	[0][1][2][1][RTW89_ETSI][7] = 127,
	[0][1][2][1][RTW89_MKK][7] = 127,
	[0][1][2][1][RTW89_IC][7] = 127,
	[0][1][2][1][RTW89_KCC][7] = 127,
	[0][1][2][1][RTW89_ACMA][7] = 127,
	[0][1][2][1][RTW89_CN][7] = 127,
	[0][1][2][1][RTW89_UK][7] = 127,
	[0][1][2][1][RTW89_FCC][8] = 127,
	[0][1][2][1][RTW89_ETSI][8] = 127,
	[0][1][2][1][RTW89_MKK][8] = 127,
	[0][1][2][1][RTW89_IC][8] = 127,
	[0][1][2][1][RTW89_KCC][8] = 127,
	[0][1][2][1][RTW89_ACMA][8] = 127,
	[0][1][2][1][RTW89_CN][8] = 127,
	[0][1][2][1][RTW89_UK][8] = 127,
	[0][1][2][1][RTW89_FCC][9] = 127,
	[0][1][2][1][RTW89_ETSI][9] = 127,
	[0][1][2][1][RTW89_MKK][9] = 127,
	[0][1][2][1][RTW89_IC][9] = 127,
	[0][1][2][1][RTW89_KCC][9] = 127,
	[0][1][2][1][RTW89_ACMA][9] = 127,
	[0][1][2][1][RTW89_CN][9] = 127,
	[0][1][2][1][RTW89_UK][9] = 127,
	[0][1][2][1][RTW89_FCC][10] = 127,
	[0][1][2][1][RTW89_ETSI][10] = 127,
	[0][1][2][1][RTW89_MKK][10] = 127,
	[0][1][2][1][RTW89_IC][10] = 127,
	[0][1][2][1][RTW89_KCC][10] = 127,
	[0][1][2][1][RTW89_ACMA][10] = 127,
	[0][1][2][1][RTW89_CN][10] = 127,
	[0][1][2][1][RTW89_UK][10] = 127,
	[0][1][2][1][RTW89_FCC][11] = 127,
	[0][1][2][1][RTW89_ETSI][11] = 127,
	[0][1][2][1][RTW89_MKK][11] = 127,
	[0][1][2][1][RTW89_IC][11] = 127,
	[0][1][2][1][RTW89_KCC][11] = 127,
	[0][1][2][1][RTW89_ACMA][11] = 127,
	[0][1][2][1][RTW89_CN][11] = 127,
	[0][1][2][1][RTW89_UK][11] = 127,
	[0][1][2][1][RTW89_FCC][12] = 127,
	[0][1][2][1][RTW89_ETSI][12] = 127,
	[0][1][2][1][RTW89_MKK][12] = 127,
	[0][1][2][1][RTW89_IC][12] = 127,
	[0][1][2][1][RTW89_KCC][12] = 127,
	[0][1][2][1][RTW89_ACMA][12] = 127,
	[0][1][2][1][RTW89_CN][12] = 127,
	[0][1][2][1][RTW89_UK][12] = 127,
	[0][1][2][1][RTW89_FCC][13] = 127,
	[0][1][2][1][RTW89_ETSI][13] = 127,
	[0][1][2][1][RTW89_MKK][13] = 127,
	[0][1][2][1][RTW89_IC][13] = 127,
	[0][1][2][1][RTW89_KCC][13] = 127,
	[0][1][2][1][RTW89_ACMA][13] = 127,
	[0][1][2][1][RTW89_CN][13] = 127,
	[0][1][2][1][RTW89_UK][13] = 127,
	[1][0][2][0][RTW89_FCC][0] = 127,
	[1][0][2][0][RTW89_ETSI][0] = 127,
	[1][0][2][0][RTW89_MKK][0] = 127,
	[1][0][2][0][RTW89_IC][0] = 127,
	[1][0][2][0][RTW89_KCC][0] = 127,
	[1][0][2][0][RTW89_ACMA][0] = 127,
	[1][0][2][0][RTW89_CN][0] = 127,
	[1][0][2][0][RTW89_UK][0] = 127,
	[1][0][2][0][RTW89_FCC][1] = 127,
	[1][0][2][0][RTW89_ETSI][1] = 127,
	[1][0][2][0][RTW89_MKK][1] = 127,
	[1][0][2][0][RTW89_IC][1] = 127,
	[1][0][2][0][RTW89_KCC][1] = 127,
	[1][0][2][0][RTW89_ACMA][1] = 127,
	[1][0][2][0][RTW89_CN][1] = 127,
	[1][0][2][0][RTW89_UK][1] = 127,
	[1][0][2][0][RTW89_FCC][2] = 70,
	[1][0][2][0][RTW89_ETSI][2] = 58,
	[1][0][2][0][RTW89_MKK][2] = 76,
	[1][0][2][0][RTW89_IC][2] = 70,
	[1][0][2][0][RTW89_KCC][2] = 76,
	[1][0][2][0][RTW89_ACMA][2] = 58,
	[1][0][2][0][RTW89_CN][2] = 56,
	[1][0][2][0][RTW89_UK][2] = 58,
	[1][0][2][0][RTW89_FCC][3] = 70,
	[1][0][2][0][RTW89_ETSI][3] = 58,
	[1][0][2][0][RTW89_MKK][3] = 76,
	[1][0][2][0][RTW89_IC][3] = 70,
	[1][0][2][0][RTW89_KCC][3] = 76,
	[1][0][2][0][RTW89_ACMA][3] = 58,
	[1][0][2][0][RTW89_CN][3] = 56,
	[1][0][2][0][RTW89_UK][3] = 58,
	[1][0][2][0][RTW89_FCC][4] = 74,
	[1][0][2][0][RTW89_ETSI][4] = 58,
	[1][0][2][0][RTW89_MKK][4] = 76,
	[1][0][2][0][RTW89_IC][4] = 74,
	[1][0][2][0][RTW89_KCC][4] = 76,
	[1][0][2][0][RTW89_ACMA][4] = 58,
	[1][0][2][0][RTW89_CN][4] = 56,
	[1][0][2][0][RTW89_UK][4] = 58,
	[1][0][2][0][RTW89_FCC][5] = 76,
	[1][0][2][0][RTW89_ETSI][5] = 58,
	[1][0][2][0][RTW89_MKK][5] = 76,
	[1][0][2][0][RTW89_IC][5] = 76,
	[1][0][2][0][RTW89_KCC][5] = 76,
	[1][0][2][0][RTW89_ACMA][5] = 58,
	[1][0][2][0][RTW89_CN][5] = 56,
	[1][0][2][0][RTW89_UK][5] = 58,
	[1][0][2][0][RTW89_FCC][6] = 76,
	[1][0][2][0][RTW89_ETSI][6] = 58,
	[1][0][2][0][RTW89_MKK][6] = 76,
	[1][0][2][0][RTW89_IC][6] = 76,
	[1][0][2][0][RTW89_KCC][6] = 76,
	[1][0][2][0][RTW89_ACMA][6] = 58,
	[1][0][2][0][RTW89_CN][6] = 56,
	[1][0][2][0][RTW89_UK][6] = 58,
	[1][0][2][0][RTW89_FCC][7] = 76,
	[1][0][2][0][RTW89_ETSI][7] = 58,
	[1][0][2][0][RTW89_MKK][7] = 76,
	[1][0][2][0][RTW89_IC][7] = 76,
	[1][0][2][0][RTW89_KCC][7] = 76,
	[1][0][2][0][RTW89_ACMA][7] = 58,
	[1][0][2][0][RTW89_CN][7] = 56,
	[1][0][2][0][RTW89_UK][7] = 58,
	[1][0][2][0][RTW89_FCC][8] = 78,
	[1][0][2][0][RTW89_ETSI][8] = 58,
	[1][0][2][0][RTW89_MKK][8] = 76,
	[1][0][2][0][RTW89_IC][8] = 78,
	[1][0][2][0][RTW89_KCC][8] = 76,
	[1][0][2][0][RTW89_ACMA][8] = 58,
	[1][0][2][0][RTW89_CN][8] = 56,
	[1][0][2][0][RTW89_UK][8] = 58,
	[1][0][2][0][RTW89_FCC][9] = 74,
	[1][0][2][0][RTW89_ETSI][9] = 58,
	[1][0][2][0][RTW89_MKK][9] = 76,
	[1][0][2][0][RTW89_IC][9] = 74,
	[1][0][2][0][RTW89_KCC][9] = 76,
	[1][0][2][0][RTW89_ACMA][9] = 58,
	[1][0][2][0][RTW89_CN][9] = 56,
	[1][0][2][0][RTW89_UK][9] = 58,
	[1][0][2][0][RTW89_FCC][10] = 68,
	[1][0][2][0][RTW89_ETSI][10] = 58,
	[1][0][2][0][RTW89_MKK][10] = 76,
	[1][0][2][0][RTW89_IC][10] = 68,
	[1][0][2][0][RTW89_KCC][10] = 76,
	[1][0][2][0][RTW89_ACMA][10] = 58,
	[1][0][2][0][RTW89_CN][10] = 48,
	[1][0][2][0][RTW89_UK][10] = 58,
	[1][0][2][0][RTW89_FCC][11] = 127,
	[1][0][2][0][RTW89_ETSI][11] = 127,
	[1][0][2][0][RTW89_MKK][11] = 127,
	[1][0][2][0][RTW89_IC][11] = 127,
	[1][0][2][0][RTW89_KCC][11] = 127,
	[1][0][2][0][RTW89_ACMA][11] = 127,
	[1][0][2][0][RTW89_CN][11] = 127,
	[1][0][2][0][RTW89_UK][11] = 127,
	[1][0][2][0][RTW89_FCC][12] = 127,
	[1][0][2][0][RTW89_ETSI][12] = 127,
	[1][0][2][0][RTW89_MKK][12] = 127,
	[1][0][2][0][RTW89_IC][12] = 127,
	[1][0][2][0][RTW89_KCC][12] = 127,
	[1][0][2][0][RTW89_ACMA][12] = 127,
	[1][0][2][0][RTW89_CN][12] = 127,
	[1][0][2][0][RTW89_UK][12] = 127,
	[1][0][2][0][RTW89_FCC][13] = 127,
	[1][0][2][0][RTW89_ETSI][13] = 127,
	[1][0][2][0][RTW89_MKK][13] = 127,
	[1][0][2][0][RTW89_IC][13] = 127,
	[1][0][2][0][RTW89_KCC][13] = 127,
	[1][0][2][0][RTW89_ACMA][13] = 127,
	[1][0][2][0][RTW89_CN][13] = 127,
	[1][0][2][0][RTW89_UK][13] = 127,
	[1][1][2][0][RTW89_FCC][0] = 127,
	[1][1][2][0][RTW89_ETSI][0] = 127,
	[1][1][2][0][RTW89_MKK][0] = 127,
	[1][1][2][0][RTW89_IC][0] = 127,
	[1][1][2][0][RTW89_KCC][0] = 127,
	[1][1][2][0][RTW89_ACMA][0] = 127,
	[1][1][2][0][RTW89_CN][0] = 127,
	[1][1][2][0][RTW89_UK][0] = 127,
	[1][1][2][0][RTW89_FCC][1] = 127,
	[1][1][2][0][RTW89_ETSI][1] = 127,
	[1][1][2][0][RTW89_MKK][1] = 127,
	[1][1][2][0][RTW89_IC][1] = 127,
	[1][1][2][0][RTW89_KCC][1] = 127,
	[1][1][2][0][RTW89_ACMA][1] = 127,
	[1][1][2][0][RTW89_CN][1] = 127,
	[1][1][2][0][RTW89_UK][1] = 127,
	[1][1][2][0][RTW89_FCC][2] = 127,
	[1][1][2][0][RTW89_ETSI][2] = 127,
	[1][1][2][0][RTW89_MKK][2] = 127,
	[1][1][2][0][RTW89_IC][2] = 127,
	[1][1][2][0][RTW89_KCC][2] = 127,
	[1][1][2][0][RTW89_ACMA][2] = 127,
	[1][1][2][0][RTW89_CN][2] = 127,
	[1][1][2][0][RTW89_UK][2] = 127,
	[1][1][2][0][RTW89_FCC][3] = 127,
	[1][1][2][0][RTW89_ETSI][3] = 127,
	[1][1][2][0][RTW89_MKK][3] = 127,
	[1][1][2][0][RTW89_IC][3] = 127,
	[1][1][2][0][RTW89_KCC][3] = 127,
	[1][1][2][0][RTW89_ACMA][3] = 127,
	[1][1][2][0][RTW89_CN][3] = 127,
	[1][1][2][0][RTW89_UK][3] = 127,
	[1][1][2][0][RTW89_FCC][4] = 127,
	[1][1][2][0][RTW89_ETSI][4] = 127,
	[1][1][2][0][RTW89_MKK][4] = 127,
	[1][1][2][0][RTW89_IC][4] = 127,
	[1][1][2][0][RTW89_KCC][4] = 127,
	[1][1][2][0][RTW89_ACMA][4] = 127,
	[1][1][2][0][RTW89_CN][4] = 127,
	[1][1][2][0][RTW89_UK][4] = 127,
	[1][1][2][0][RTW89_FCC][5] = 127,
	[1][1][2][0][RTW89_ETSI][5] = 127,
	[1][1][2][0][RTW89_MKK][5] = 127,
	[1][1][2][0][RTW89_IC][5] = 127,
	[1][1][2][0][RTW89_KCC][5] = 127,
	[1][1][2][0][RTW89_ACMA][5] = 127,
	[1][1][2][0][RTW89_CN][5] = 127,
	[1][1][2][0][RTW89_UK][5] = 127,
	[1][1][2][0][RTW89_FCC][6] = 127,
	[1][1][2][0][RTW89_ETSI][6] = 127,
	[1][1][2][0][RTW89_MKK][6] = 127,
	[1][1][2][0][RTW89_IC][6] = 127,
	[1][1][2][0][RTW89_KCC][6] = 127,
	[1][1][2][0][RTW89_ACMA][6] = 127,
	[1][1][2][0][RTW89_CN][6] = 127,
	[1][1][2][0][RTW89_UK][6] = 127,
	[1][1][2][0][RTW89_FCC][7] = 127,
	[1][1][2][0][RTW89_ETSI][7] = 127,
	[1][1][2][0][RTW89_MKK][7] = 127,
	[1][1][2][0][RTW89_IC][7] = 127,
	[1][1][2][0][RTW89_KCC][7] = 127,
	[1][1][2][0][RTW89_ACMA][7] = 127,
	[1][1][2][0][RTW89_CN][7] = 127,
	[1][1][2][0][RTW89_UK][7] = 127,
	[1][1][2][0][RTW89_FCC][8] = 127,
	[1][1][2][0][RTW89_ETSI][8] = 127,
	[1][1][2][0][RTW89_MKK][8] = 127,
	[1][1][2][0][RTW89_IC][8] = 127,
	[1][1][2][0][RTW89_KCC][8] = 127,
	[1][1][2][0][RTW89_ACMA][8] = 127,
	[1][1][2][0][RTW89_CN][8] = 127,
	[1][1][2][0][RTW89_UK][8] = 127,
	[1][1][2][0][RTW89_FCC][9] = 127,
	[1][1][2][0][RTW89_ETSI][9] = 127,
	[1][1][2][0][RTW89_MKK][9] = 127,
	[1][1][2][0][RTW89_IC][9] = 127,
	[1][1][2][0][RTW89_KCC][9] = 127,
	[1][1][2][0][RTW89_ACMA][9] = 127,
	[1][1][2][0][RTW89_CN][9] = 127,
	[1][1][2][0][RTW89_UK][9] = 127,
	[1][1][2][0][RTW89_FCC][10] = 127,
	[1][1][2][0][RTW89_ETSI][10] = 127,
	[1][1][2][0][RTW89_MKK][10] = 127,
	[1][1][2][0][RTW89_IC][10] = 127,
	[1][1][2][0][RTW89_KCC][10] = 127,
	[1][1][2][0][RTW89_ACMA][10] = 127,
	[1][1][2][0][RTW89_CN][10] = 127,
	[1][1][2][0][RTW89_UK][10] = 127,
	[1][1][2][0][RTW89_FCC][11] = 127,
	[1][1][2][0][RTW89_ETSI][11] = 127,
	[1][1][2][0][RTW89_MKK][11] = 127,
	[1][1][2][0][RTW89_IC][11] = 127,
	[1][1][2][0][RTW89_KCC][11] = 127,
	[1][1][2][0][RTW89_ACMA][11] = 127,
	[1][1][2][0][RTW89_CN][11] = 127,
	[1][1][2][0][RTW89_UK][11] = 127,
	[1][1][2][0][RTW89_FCC][12] = 127,
	[1][1][2][0][RTW89_ETSI][12] = 127,
	[1][1][2][0][RTW89_MKK][12] = 127,
	[1][1][2][0][RTW89_IC][12] = 127,
	[1][1][2][0][RTW89_KCC][12] = 127,
	[1][1][2][0][RTW89_ACMA][12] = 127,
	[1][1][2][0][RTW89_CN][12] = 127,
	[1][1][2][0][RTW89_UK][12] = 127,
	[1][1][2][0][RTW89_FCC][13] = 127,
	[1][1][2][0][RTW89_ETSI][13] = 127,
	[1][1][2][0][RTW89_MKK][13] = 127,
	[1][1][2][0][RTW89_IC][13] = 127,
	[1][1][2][0][RTW89_KCC][13] = 127,
	[1][1][2][0][RTW89_ACMA][13] = 127,
	[1][1][2][0][RTW89_CN][13] = 127,
	[1][1][2][0][RTW89_UK][13] = 127,
	[1][1][2][1][RTW89_FCC][0] = 127,
	[1][1][2][1][RTW89_ETSI][0] = 127,
	[1][1][2][1][RTW89_MKK][0] = 127,
	[1][1][2][1][RTW89_IC][0] = 127,
	[1][1][2][1][RTW89_KCC][0] = 127,
	[1][1][2][1][RTW89_ACMA][0] = 127,
	[1][1][2][1][RTW89_CN][0] = 127,
	[1][1][2][1][RTW89_UK][0] = 127,
	[1][1][2][1][RTW89_FCC][1] = 127,
	[1][1][2][1][RTW89_ETSI][1] = 127,
	[1][1][2][1][RTW89_MKK][1] = 127,
	[1][1][2][1][RTW89_IC][1] = 127,
	[1][1][2][1][RTW89_KCC][1] = 127,
	[1][1][2][1][RTW89_ACMA][1] = 127,
	[1][1][2][1][RTW89_CN][1] = 127,
	[1][1][2][1][RTW89_UK][1] = 127,
	[1][1][2][1][RTW89_FCC][2] = 127,
	[1][1][2][1][RTW89_ETSI][2] = 127,
	[1][1][2][1][RTW89_MKK][2] = 127,
	[1][1][2][1][RTW89_IC][2] = 127,
	[1][1][2][1][RTW89_KCC][2] = 127,
	[1][1][2][1][RTW89_ACMA][2] = 127,
	[1][1][2][1][RTW89_CN][2] = 127,
	[1][1][2][1][RTW89_UK][2] = 127,
	[1][1][2][1][RTW89_FCC][3] = 127,
	[1][1][2][1][RTW89_ETSI][3] = 127,
	[1][1][2][1][RTW89_MKK][3] = 127,
	[1][1][2][1][RTW89_IC][3] = 127,
	[1][1][2][1][RTW89_KCC][3] = 127,
	[1][1][2][1][RTW89_ACMA][3] = 127,
	[1][1][2][1][RTW89_CN][3] = 127,
	[1][1][2][1][RTW89_UK][3] = 127,
	[1][1][2][1][RTW89_FCC][4] = 127,
	[1][1][2][1][RTW89_ETSI][4] = 127,
	[1][1][2][1][RTW89_MKK][4] = 127,
	[1][1][2][1][RTW89_IC][4] = 127,
	[1][1][2][1][RTW89_KCC][4] = 127,
	[1][1][2][1][RTW89_ACMA][4] = 127,
	[1][1][2][1][RTW89_CN][4] = 127,
	[1][1][2][1][RTW89_UK][4] = 127,
	[1][1][2][1][RTW89_FCC][5] = 127,
	[1][1][2][1][RTW89_ETSI][5] = 127,
	[1][1][2][1][RTW89_MKK][5] = 127,
	[1][1][2][1][RTW89_IC][5] = 127,
	[1][1][2][1][RTW89_KCC][5] = 127,
	[1][1][2][1][RTW89_ACMA][5] = 127,
	[1][1][2][1][RTW89_CN][5] = 127,
	[1][1][2][1][RTW89_UK][5] = 127,
	[1][1][2][1][RTW89_FCC][6] = 127,
	[1][1][2][1][RTW89_ETSI][6] = 127,
	[1][1][2][1][RTW89_MKK][6] = 127,
	[1][1][2][1][RTW89_IC][6] = 127,
	[1][1][2][1][RTW89_KCC][6] = 127,
	[1][1][2][1][RTW89_ACMA][6] = 127,
	[1][1][2][1][RTW89_CN][6] = 127,
	[1][1][2][1][RTW89_UK][6] = 127,
	[1][1][2][1][RTW89_FCC][7] = 127,
	[1][1][2][1][RTW89_ETSI][7] = 127,
	[1][1][2][1][RTW89_MKK][7] = 127,
	[1][1][2][1][RTW89_IC][7] = 127,
	[1][1][2][1][RTW89_KCC][7] = 127,
	[1][1][2][1][RTW89_ACMA][7] = 127,
	[1][1][2][1][RTW89_CN][7] = 127,
	[1][1][2][1][RTW89_UK][7] = 127,
	[1][1][2][1][RTW89_FCC][8] = 127,
	[1][1][2][1][RTW89_ETSI][8] = 127,
	[1][1][2][1][RTW89_MKK][8] = 127,
	[1][1][2][1][RTW89_IC][8] = 127,
	[1][1][2][1][RTW89_KCC][8] = 127,
	[1][1][2][1][RTW89_ACMA][8] = 127,
	[1][1][2][1][RTW89_CN][8] = 127,
	[1][1][2][1][RTW89_UK][8] = 127,
	[1][1][2][1][RTW89_FCC][9] = 127,
	[1][1][2][1][RTW89_ETSI][9] = 127,
	[1][1][2][1][RTW89_MKK][9] = 127,
	[1][1][2][1][RTW89_IC][9] = 127,
	[1][1][2][1][RTW89_KCC][9] = 127,
	[1][1][2][1][RTW89_ACMA][9] = 127,
	[1][1][2][1][RTW89_CN][9] = 127,
	[1][1][2][1][RTW89_UK][9] = 127,
	[1][1][2][1][RTW89_FCC][10] = 127,
	[1][1][2][1][RTW89_ETSI][10] = 127,
	[1][1][2][1][RTW89_MKK][10] = 127,
	[1][1][2][1][RTW89_IC][10] = 127,
	[1][1][2][1][RTW89_KCC][10] = 127,
	[1][1][2][1][RTW89_ACMA][10] = 127,
	[1][1][2][1][RTW89_CN][10] = 127,
	[1][1][2][1][RTW89_UK][10] = 127,
	[1][1][2][1][RTW89_FCC][11] = 127,
	[1][1][2][1][RTW89_ETSI][11] = 127,
	[1][1][2][1][RTW89_MKK][11] = 127,
	[1][1][2][1][RTW89_IC][11] = 127,
	[1][1][2][1][RTW89_KCC][11] = 127,
	[1][1][2][1][RTW89_ACMA][11] = 127,
	[1][1][2][1][RTW89_CN][11] = 127,
	[1][1][2][1][RTW89_UK][11] = 127,
	[1][1][2][1][RTW89_FCC][12] = 127,
	[1][1][2][1][RTW89_ETSI][12] = 127,
	[1][1][2][1][RTW89_MKK][12] = 127,
	[1][1][2][1][RTW89_IC][12] = 127,
	[1][1][2][1][RTW89_KCC][12] = 127,
	[1][1][2][1][RTW89_ACMA][12] = 127,
	[1][1][2][1][RTW89_CN][12] = 127,
	[1][1][2][1][RTW89_UK][12] = 127,
	[1][1][2][1][RTW89_FCC][13] = 127,
	[1][1][2][1][RTW89_ETSI][13] = 127,
	[1][1][2][1][RTW89_MKK][13] = 127,
	[1][1][2][1][RTW89_IC][13] = 127,
	[1][1][2][1][RTW89_KCC][13] = 127,
	[1][1][2][1][RTW89_ACMA][13] = 127,
	[1][1][2][1][RTW89_CN][13] = 127,
	[1][1][2][1][RTW89_UK][13] = 127,
};

static
const s8 rtw89_8851b_txpwr_lmt_5g_type2[RTW89_5G_BW_NUM][RTW89_NTX_NUM]
				       [RTW89_RS_LMT_NUM][RTW89_BF_NUM]
				       [RTW89_REGD_NUM][RTW89_5G_CH_NUM] = {
	[0][0][1][0][RTW89_WW][0] = 58,
	[0][0][1][0][RTW89_WW][2] = 58,
	[0][0][1][0][RTW89_WW][4] = 58,
	[0][0][1][0][RTW89_WW][6] = 50,
	[0][0][1][0][RTW89_WW][8] = 58,
	[0][0][1][0][RTW89_WW][10] = 58,
	[0][0][1][0][RTW89_WW][12] = 58,
	[0][0][1][0][RTW89_WW][14] = 58,
	[0][0][1][0][RTW89_WW][15] = 58,
	[0][0][1][0][RTW89_WW][17] = 60,
	[0][0][1][0][RTW89_WW][19] = 60,
	[0][0][1][0][RTW89_WW][21] = 60,
	[0][0][1][0][RTW89_WW][23] = 60,
	[0][0][1][0][RTW89_WW][25] = 60,
	[0][0][1][0][RTW89_WW][27] = 60,
	[0][0][1][0][RTW89_WW][29] = 60,
	[0][0][1][0][RTW89_WW][31] = 60,
	[0][0][1][0][RTW89_WW][33] = 60,
	[0][0][1][0][RTW89_WW][35] = 60,
	[0][0][1][0][RTW89_WW][37] = 74,
	[0][0][1][0][RTW89_WW][38] = 30,
	[0][0][1][0][RTW89_WW][40] = 30,
	[0][0][1][0][RTW89_WW][42] = 30,
	[0][0][1][0][RTW89_WW][44] = 30,
	[0][0][1][0][RTW89_WW][46] = 30,
	[0][0][1][0][RTW89_WW][48] = 72,
	[0][0][1][0][RTW89_WW][50] = 72,
	[0][0][1][0][RTW89_WW][52] = 72,
	[0][1][1][0][RTW89_WW][0] = 0,
	[0][1][1][0][RTW89_WW][2] = 0,
	[0][1][1][0][RTW89_WW][4] = 0,
	[0][1][1][0][RTW89_WW][6] = 0,
	[0][1][1][0][RTW89_WW][8] = 0,
	[0][1][1][0][RTW89_WW][10] = 0,
	[0][1][1][0][RTW89_WW][12] = 0,
	[0][1][1][0][RTW89_WW][14] = 0,
	[0][1][1][0][RTW89_WW][15] = 0,
	[0][1][1][0][RTW89_WW][17] = 0,
	[0][1][1][0][RTW89_WW][19] = 0,
	[0][1][1][0][RTW89_WW][21] = 0,
	[0][1][1][0][RTW89_WW][23] = 0,
	[0][1][1][0][RTW89_WW][25] = 0,
	[0][1][1][0][RTW89_WW][27] = 0,
	[0][1][1][0][RTW89_WW][29] = 0,
	[0][1][1][0][RTW89_WW][31] = 0,
	[0][1][1][0][RTW89_WW][33] = 0,
	[0][1][1][0][RTW89_WW][35] = 0,
	[0][1][1][0][RTW89_WW][37] = 0,
	[0][1][1][0][RTW89_WW][38] = 0,
	[0][1][1][0][RTW89_WW][40] = 0,
	[0][1][1][0][RTW89_WW][42] = 0,
	[0][1][1][0][RTW89_WW][44] = 0,
	[0][1][1][0][RTW89_WW][46] = 0,
	[0][1][1][0][RTW89_WW][48] = 0,
	[0][1][1][0][RTW89_WW][50] = 0,
	[0][1][1][0][RTW89_WW][52] = 0,
	[0][0][2][0][RTW89_WW][0] = 60,
	[0][0][2][0][RTW89_WW][2] = 60,
	[0][0][2][0][RTW89_WW][4] = 60,
	[0][0][2][0][RTW89_WW][6] = 54,
	[0][0][2][0][RTW89_WW][8] = 60,
	[0][0][2][0][RTW89_WW][10] = 60,
	[0][0][2][0][RTW89_WW][12] = 60,
	[0][0][2][0][RTW89_WW][14] = 60,
	[0][0][2][0][RTW89_WW][15] = 60,
	[0][0][2][0][RTW89_WW][17] = 62,
	[0][0][2][0][RTW89_WW][19] = 62,
	[0][0][2][0][RTW89_WW][21] = 62,
	[0][0][2][0][RTW89_WW][23] = 62,
	[0][0][2][0][RTW89_WW][25] = 62,
	[0][0][2][0][RTW89_WW][27] = 62,
	[0][0][2][0][RTW89_WW][29] = 62,
	[0][0][2][0][RTW89_WW][31] = 62,
	[0][0][2][0][RTW89_WW][33] = 62,
	[0][0][2][0][RTW89_WW][35] = 62,
	[0][0][2][0][RTW89_WW][37] = 74,
	[0][0][2][0][RTW89_WW][38] = 30,
	[0][0][2][0][RTW89_WW][40] = 30,
	[0][0][2][0][RTW89_WW][42] = 30,
	[0][0][2][0][RTW89_WW][44] = 30,
	[0][0][2][0][RTW89_WW][46] = 30,
	[0][0][2][0][RTW89_WW][48] = 74,
	[0][0][2][0][RTW89_WW][50] = 74,
	[0][0][2][0][RTW89_WW][52] = 74,
	[0][1][2][0][RTW89_WW][0] = 0,
	[0][1][2][0][RTW89_WW][2] = 0,
	[0][1][2][0][RTW89_WW][4] = 0,
	[0][1][2][0][RTW89_WW][6] = 0,
	[0][1][2][0][RTW89_WW][8] = 0,
	[0][1][2][0][RTW89_WW][10] = 0,
	[0][1][2][0][RTW89_WW][12] = 0,
	[0][1][2][0][RTW89_WW][14] = 0,
	[0][1][2][0][RTW89_WW][15] = 0,
	[0][1][2][0][RTW89_WW][17] = 0,
	[0][1][2][0][RTW89_WW][19] = 0,
	[0][1][2][0][RTW89_WW][21] = 0,
	[0][1][2][0][RTW89_WW][23] = 0,
	[0][1][2][0][RTW89_WW][25] = 0,
	[0][1][2][0][RTW89_WW][27] = 0,
	[0][1][2][0][RTW89_WW][29] = 0,
	[0][1][2][0][RTW89_WW][31] = 0,
	[0][1][2][0][RTW89_WW][33] = 0,
	[0][1][2][0][RTW89_WW][35] = 0,
	[0][1][2][0][RTW89_WW][37] = 0,
	[0][1][2][0][RTW89_WW][38] = 0,
	[0][1][2][0][RTW89_WW][40] = 0,
	[0][1][2][0][RTW89_WW][42] = 0,
	[0][1][2][0][RTW89_WW][44] = 0,
	[0][1][2][0][RTW89_WW][46] = 0,
	[0][1][2][0][RTW89_WW][48] = 0,
	[0][1][2][0][RTW89_WW][50] = 0,
	[0][1][2][0][RTW89_WW][52] = 0,
	[0][1][2][1][RTW89_WW][0] = 0,
	[0][1][2][1][RTW89_WW][2] = 0,
	[0][1][2][1][RTW89_WW][4] = 0,
	[0][1][2][1][RTW89_WW][6] = 0,
	[0][1][2][1][RTW89_WW][8] = 0,
	[0][1][2][1][RTW89_WW][10] = 0,
	[0][1][2][1][RTW89_WW][12] = 0,
	[0][1][2][1][RTW89_WW][14] = 0,
	[0][1][2][1][RTW89_WW][15] = 0,
	[0][1][2][1][RTW89_WW][17] = 0,
	[0][1][2][1][RTW89_WW][19] = 0,
	[0][1][2][1][RTW89_WW][21] = 0,
	[0][1][2][1][RTW89_WW][23] = 0,
	[0][1][2][1][RTW89_WW][25] = 0,
	[0][1][2][1][RTW89_WW][27] = 0,
	[0][1][2][1][RTW89_WW][29] = 0,
	[0][1][2][1][RTW89_WW][31] = 0,
	[0][1][2][1][RTW89_WW][33] = 0,
	[0][1][2][1][RTW89_WW][35] = 0,
	[0][1][2][1][RTW89_WW][37] = 0,
	[0][1][2][1][RTW89_WW][38] = 0,
	[0][1][2][1][RTW89_WW][40] = 0,
	[0][1][2][1][RTW89_WW][42] = 0,
	[0][1][2][1][RTW89_WW][44] = 0,
	[0][1][2][1][RTW89_WW][46] = 0,
	[0][1][2][1][RTW89_WW][48] = 0,
	[0][1][2][1][RTW89_WW][50] = 0,
	[0][1][2][1][RTW89_WW][52] = 0,
	[1][0][2][0][RTW89_WW][1] = 64,
	[1][0][2][0][RTW89_WW][5] = 62,
	[1][0][2][0][RTW89_WW][9] = 58,
	[1][0][2][0][RTW89_WW][13] = 58,
	[1][0][2][0][RTW89_WW][16] = 66,
	[1][0][2][0][RTW89_WW][20] = 66,
	[1][0][2][0][RTW89_WW][24] = 66,
	[1][0][2][0][RTW89_WW][28] = 66,
	[1][0][2][0][RTW89_WW][32] = 66,
	[1][0][2][0][RTW89_WW][36] = 76,
	[1][0][2][0][RTW89_WW][39] = 30,
	[1][0][2][0][RTW89_WW][43] = 30,
	[1][0][2][0][RTW89_WW][47] = 80,
	[1][0][2][0][RTW89_WW][51] = 80,
	[1][1][2][0][RTW89_WW][1] = 0,
	[1][1][2][0][RTW89_WW][5] = 0,
	[1][1][2][0][RTW89_WW][9] = 0,
	[1][1][2][0][RTW89_WW][13] = 0,
	[1][1][2][0][RTW89_WW][16] = 0,
	[1][1][2][0][RTW89_WW][20] = 0,
	[1][1][2][0][RTW89_WW][24] = 0,
	[1][1][2][0][RTW89_WW][28] = 0,
	[1][1][2][0][RTW89_WW][32] = 0,
	[1][1][2][0][RTW89_WW][36] = 0,
	[1][1][2][0][RTW89_WW][39] = 0,
	[1][1][2][0][RTW89_WW][43] = 0,
	[1][1][2][0][RTW89_WW][47] = 0,
	[1][1][2][0][RTW89_WW][51] = 0,
	[1][1][2][1][RTW89_WW][1] = 0,
	[1][1][2][1][RTW89_WW][5] = 0,
	[1][1][2][1][RTW89_WW][9] = 0,
	[1][1][2][1][RTW89_WW][13] = 0,
	[1][1][2][1][RTW89_WW][16] = 0,
	[1][1][2][1][RTW89_WW][20] = 0,
	[1][1][2][1][RTW89_WW][24] = 0,
	[1][1][2][1][RTW89_WW][28] = 0,
	[1][1][2][1][RTW89_WW][32] = 0,
	[1][1][2][1][RTW89_WW][36] = 0,
	[1][1][2][1][RTW89_WW][39] = 0,
	[1][1][2][1][RTW89_WW][43] = 0,
	[1][1][2][1][RTW89_WW][47] = 0,
	[1][1][2][1][RTW89_WW][51] = 0,
	[2][0][2][0][RTW89_WW][3] = 60,
	[2][0][2][0][RTW89_WW][11] = 54,
	[2][0][2][0][RTW89_WW][18] = 64,
	[2][0][2][0][RTW89_WW][26] = 64,
	[2][0][2][0][RTW89_WW][34] = 68,
	[2][0][2][0][RTW89_WW][41] = 30,
	[2][0][2][0][RTW89_WW][49] = 72,
	[2][1][2][0][RTW89_WW][3] = 0,
	[2][1][2][0][RTW89_WW][11] = 0,
	[2][1][2][0][RTW89_WW][18] = 0,
	[2][1][2][0][RTW89_WW][26] = 0,
	[2][1][2][0][RTW89_WW][34] = 0,
	[2][1][2][0][RTW89_WW][41] = 0,
	[2][1][2][0][RTW89_WW][49] = 0,
	[2][1][2][1][RTW89_WW][3] = 0,
	[2][1][2][1][RTW89_WW][11] = 0,
	[2][1][2][1][RTW89_WW][18] = 0,
	[2][1][2][1][RTW89_WW][26] = 0,
	[2][1][2][1][RTW89_WW][34] = 0,
	[2][1][2][1][RTW89_WW][41] = 0,
	[2][1][2][1][RTW89_WW][49] = 0,
	[3][0][2][0][RTW89_WW][7] = 0,
	[3][0][2][0][RTW89_WW][22] = 0,
	[3][0][2][0][RTW89_WW][45] = 0,
	[3][1][2][0][RTW89_WW][7] = 0,
	[3][1][2][0][RTW89_WW][22] = 0,
	[3][1][2][0][RTW89_WW][45] = 0,
	[3][1][2][1][RTW89_WW][7] = 0,
	[3][1][2][1][RTW89_WW][22] = 0,
	[3][1][2][1][RTW89_WW][45] = 0,
	[0][0][1][0][RTW89_FCC][0] = 78,
	[0][0][1][0][RTW89_ETSI][0] = 58,
	[0][0][1][0][RTW89_MKK][0] = 60,
	[0][0][1][0][RTW89_IC][0] = 62,
	[0][0][1][0][RTW89_KCC][0] = 74,
	[0][0][1][0][RTW89_ACMA][0] = 58,
	[0][0][1][0][RTW89_CN][0] = 60,
	[0][0][1][0][RTW89_UK][0] = 58,
	[0][0][1][0][RTW89_FCC][2] = 78,
	[0][0][1][0][RTW89_ETSI][2] = 58,
	[0][0][1][0][RTW89_MKK][2] = 60,
	[0][0][1][0][RTW89_IC][2] = 62,
	[0][0][1][0][RTW89_KCC][2] = 74,
	[0][0][1][0][RTW89_ACMA][2] = 58,
	[0][0][1][0][RTW89_CN][2] = 60,
	[0][0][1][0][RTW89_UK][2] = 58,
	[0][0][1][0][RTW89_FCC][4] = 78,
	[0][0][1][0][RTW89_ETSI][4] = 58,
	[0][0][1][0][RTW89_MKK][4] = 60,
	[0][0][1][0][RTW89_IC][4] = 62,
	[0][0][1][0][RTW89_KCC][4] = 74,
	[0][0][1][0][RTW89_ACMA][4] = 58,
	[0][0][1][0][RTW89_CN][4] = 60,
	[0][0][1][0][RTW89_UK][4] = 58,
	[0][0][1][0][RTW89_FCC][6] = 78,
	[0][0][1][0][RTW89_ETSI][6] = 58,
	[0][0][1][0][RTW89_MKK][6] = 60,
	[0][0][1][0][RTW89_IC][6] = 62,
	[0][0][1][0][RTW89_KCC][6] = 50,
	[0][0][1][0][RTW89_ACMA][6] = 58,
	[0][0][1][0][RTW89_CN][6] = 60,
	[0][0][1][0][RTW89_UK][6] = 58,
	[0][0][1][0][RTW89_FCC][8] = 78,
	[0][0][1][0][RTW89_ETSI][8] = 58,
	[0][0][1][0][RTW89_MKK][8] = 60,
	[0][0][1][0][RTW89_IC][8] = 62,
	[0][0][1][0][RTW89_KCC][8] = 74,
	[0][0][1][0][RTW89_ACMA][8] = 58,
	[0][0][1][0][RTW89_CN][8] = 60,
	[0][0][1][0][RTW89_UK][8] = 58,
	[0][0][1][0][RTW89_FCC][10] = 78,
	[0][0][1][0][RTW89_ETSI][10] = 58,
	[0][0][1][0][RTW89_MKK][10] = 60,
	[0][0][1][0][RTW89_IC][10] = 64,
	[0][0][1][0][RTW89_KCC][10] = 74,
	[0][0][1][0][RTW89_ACMA][10] = 58,
	[0][0][1][0][RTW89_CN][10] = 60,
	[0][0][1][0][RTW89_UK][10] = 58,
	[0][0][1][0][RTW89_FCC][12] = 78,
	[0][0][1][0][RTW89_ETSI][12] = 58,
	[0][0][1][0][RTW89_MKK][12] = 60,
	[0][0][1][0][RTW89_IC][12] = 64,
	[0][0][1][0][RTW89_KCC][12] = 74,
	[0][0][1][0][RTW89_ACMA][12] = 58,
	[0][0][1][0][RTW89_CN][12] = 60,
	[0][0][1][0][RTW89_UK][12] = 58,
	[0][0][1][0][RTW89_FCC][14] = 76,
	[0][0][1][0][RTW89_ETSI][14] = 58,
	[0][0][1][0][RTW89_MKK][14] = 60,
	[0][0][1][0][RTW89_IC][14] = 62,
	[0][0][1][0][RTW89_KCC][14] = 74,
	[0][0][1][0][RTW89_ACMA][14] = 58,
	[0][0][1][0][RTW89_CN][14] = 60,
	[0][0][1][0][RTW89_UK][14] = 58,
	[0][0][1][0][RTW89_FCC][15] = 76,
	[0][0][1][0][RTW89_ETSI][15] = 58,
	[0][0][1][0][RTW89_MKK][15] = 74,
	[0][0][1][0][RTW89_IC][15] = 76,
	[0][0][1][0][RTW89_KCC][15] = 74,
	[0][0][1][0][RTW89_ACMA][15] = 58,
	[0][0][1][0][RTW89_CN][15] = 127,
	[0][0][1][0][RTW89_UK][15] = 58,
	[0][0][1][0][RTW89_FCC][17] = 78,
	[0][0][1][0][RTW89_ETSI][17] = 60,
	[0][0][1][0][RTW89_MKK][17] = 74,
	[0][0][1][0][RTW89_IC][17] = 78,
	[0][0][1][0][RTW89_KCC][17] = 74,
	[0][0][1][0][RTW89_ACMA][17] = 60,
	[0][0][1][0][RTW89_CN][17] = 127,
	[0][0][1][0][RTW89_UK][17] = 60,
	[0][0][1][0][RTW89_FCC][19] = 78,
	[0][0][1][0][RTW89_ETSI][19] = 60,
	[0][0][1][0][RTW89_MKK][19] = 74,
	[0][0][1][0][RTW89_IC][19] = 78,
	[0][0][1][0][RTW89_KCC][19] = 74,
	[0][0][1][0][RTW89_ACMA][19] = 60,
	[0][0][1][0][RTW89_CN][19] = 127,
	[0][0][1][0][RTW89_UK][19] = 60,
	[0][0][1][0][RTW89_FCC][21] = 78,
	[0][0][1][0][RTW89_ETSI][21] = 60,
	[0][0][1][0][RTW89_MKK][21] = 74,
	[0][0][1][0][RTW89_IC][21] = 78,
	[0][0][1][0][RTW89_KCC][21] = 74,
	[0][0][1][0][RTW89_ACMA][21] = 60,
	[0][0][1][0][RTW89_CN][21] = 127,
	[0][0][1][0][RTW89_UK][21] = 60,
	[0][0][1][0][RTW89_FCC][23] = 78,
	[0][0][1][0][RTW89_ETSI][23] = 60,
	[0][0][1][0][RTW89_MKK][23] = 74,
	[0][0][1][0][RTW89_IC][23] = 78,
	[0][0][1][0][RTW89_KCC][23] = 74,
	[0][0][1][0][RTW89_ACMA][23] = 60,
	[0][0][1][0][RTW89_CN][23] = 127,
	[0][0][1][0][RTW89_UK][23] = 60,
	[0][0][1][0][RTW89_FCC][25] = 78,
	[0][0][1][0][RTW89_ETSI][25] = 60,
	[0][0][1][0][RTW89_MKK][25] = 74,
	[0][0][1][0][RTW89_IC][25] = 127,
	[0][0][1][0][RTW89_KCC][25] = 74,
	[0][0][1][0][RTW89_ACMA][25] = 127,
	[0][0][1][0][RTW89_CN][25] = 127,
	[0][0][1][0][RTW89_UK][25] = 60,
	[0][0][1][0][RTW89_FCC][27] = 78,
	[0][0][1][0][RTW89_ETSI][27] = 60,
	[0][0][1][0][RTW89_MKK][27] = 74,
	[0][0][1][0][RTW89_IC][27] = 127,
	[0][0][1][0][RTW89_KCC][27] = 74,
	[0][0][1][0][RTW89_ACMA][27] = 127,
	[0][0][1][0][RTW89_CN][27] = 127,
	[0][0][1][0][RTW89_UK][27] = 60,
	[0][0][1][0][RTW89_FCC][29] = 78,
	[0][0][1][0][RTW89_ETSI][29] = 60,
	[0][0][1][0][RTW89_MKK][29] = 74,
	[0][0][1][0][RTW89_IC][29] = 127,
	[0][0][1][0][RTW89_KCC][29] = 74,
	[0][0][1][0][RTW89_ACMA][29] = 127,
	[0][0][1][0][RTW89_CN][29] = 127,
	[0][0][1][0][RTW89_UK][29] = 60,
	[0][0][1][0][RTW89_FCC][31] = 78,
	[0][0][1][0][RTW89_ETSI][31] = 60,
	[0][0][1][0][RTW89_MKK][31] = 74,
	[0][0][1][0][RTW89_IC][31] = 78,
	[0][0][1][0][RTW89_KCC][31] = 74,
	[0][0][1][0][RTW89_ACMA][31] = 60,
	[0][0][1][0][RTW89_CN][31] = 127,
	[0][0][1][0][RTW89_UK][31] = 60,
	[0][0][1][0][RTW89_FCC][33] = 78,
	[0][0][1][0][RTW89_ETSI][33] = 60,
	[0][0][1][0][RTW89_MKK][33] = 74,
	[0][0][1][0][RTW89_IC][33] = 78,
	[0][0][1][0][RTW89_KCC][33] = 74,
	[0][0][1][0][RTW89_ACMA][33] = 60,
	[0][0][1][0][RTW89_CN][33] = 127,
	[0][0][1][0][RTW89_UK][33] = 60,
	[0][0][1][0][RTW89_FCC][35] = 70,
	[0][0][1][0][RTW89_ETSI][35] = 60,
	[0][0][1][0][RTW89_MKK][35] = 74,
	[0][0][1][0][RTW89_IC][35] = 70,
	[0][0][1][0][RTW89_KCC][35] = 74,
	[0][0][1][0][RTW89_ACMA][35] = 60,
	[0][0][1][0][RTW89_CN][35] = 127,
	[0][0][1][0][RTW89_UK][35] = 60,
	[0][0][1][0][RTW89_FCC][37] = 78,
	[0][0][1][0][RTW89_ETSI][37] = 127,
	[0][0][1][0][RTW89_MKK][37] = 74,
	[0][0][1][0][RTW89_IC][37] = 78,
	[0][0][1][0][RTW89_KCC][37] = 74,
	[0][0][1][0][RTW89_ACMA][37] = 74,
	[0][0][1][0][RTW89_CN][37] = 127,
	[0][0][1][0][RTW89_UK][37] = 74,
	[0][0][1][0][RTW89_FCC][38] = 78,
	[0][0][1][0][RTW89_ETSI][38] = 30,
	[0][0][1][0][RTW89_MKK][38] = 127,
	[0][0][1][0][RTW89_IC][38] = 78,
	[0][0][1][0][RTW89_KCC][38] = 70,
	[0][0][1][0][RTW89_ACMA][38] = 74,
	[0][0][1][0][RTW89_CN][38] = 64,
	[0][0][1][0][RTW89_UK][38] = 58,
	[0][0][1][0][RTW89_FCC][40] = 78,
	[0][0][1][0][RTW89_ETSI][40] = 30,
	[0][0][1][0][RTW89_MKK][40] = 127,
	[0][0][1][0][RTW89_IC][40] = 78,
	[0][0][1][0][RTW89_KCC][40] = 74,
	[0][0][1][0][RTW89_ACMA][40] = 74,
	[0][0][1][0][RTW89_CN][40] = 64,
	[0][0][1][0][RTW89_UK][40] = 58,
	[0][0][1][0][RTW89_FCC][42] = 78,
	[0][0][1][0][RTW89_ETSI][42] = 30,
	[0][0][1][0][RTW89_MKK][42] = 127,
	[0][0][1][0][RTW89_IC][42] = 78,
	[0][0][1][0][RTW89_KCC][42] = 74,
	[0][0][1][0][RTW89_ACMA][42] = 74,
	[0][0][1][0][RTW89_CN][42] = 64,
	[0][0][1][0][RTW89_UK][42] = 58,
	[0][0][1][0][RTW89_FCC][44] = 78,
	[0][0][1][0][RTW89_ETSI][44] = 30,
	[0][0][1][0][RTW89_MKK][44] = 127,
	[0][0][1][0][RTW89_IC][44] = 78,
	[0][0][1][0][RTW89_KCC][44] = 74,
	[0][0][1][0][RTW89_ACMA][44] = 74,
	[0][0][1][0][RTW89_CN][44] = 62,
	[0][0][1][0][RTW89_UK][44] = 58,
	[0][0][1][0][RTW89_FCC][46] = 78,
	[0][0][1][0][RTW89_ETSI][46] = 30,
	[0][0][1][0][RTW89_MKK][46] = 127,
	[0][0][1][0][RTW89_IC][46] = 78,
	[0][0][1][0][RTW89_KCC][46] = 74,
	[0][0][1][0][RTW89_ACMA][46] = 74,
	[0][0][1][0][RTW89_CN][46] = 62,
	[0][0][1][0][RTW89_UK][46] = 58,
	[0][0][1][0][RTW89_FCC][48] = 72,
	[0][0][1][0][RTW89_ETSI][48] = 127,
	[0][0][1][0][RTW89_MKK][48] = 127,
	[0][0][1][0][RTW89_IC][48] = 127,
	[0][0][1][0][RTW89_KCC][48] = 127,
	[0][0][1][0][RTW89_ACMA][48] = 127,
	[0][0][1][0][RTW89_CN][48] = 127,
	[0][0][1][0][RTW89_UK][48] = 127,
	[0][0][1][0][RTW89_FCC][50] = 72,
	[0][0][1][0][RTW89_ETSI][50] = 127,
	[0][0][1][0][RTW89_MKK][50] = 127,
	[0][0][1][0][RTW89_IC][50] = 127,
	[0][0][1][0][RTW89_KCC][50] = 127,
	[0][0][1][0][RTW89_ACMA][50] = 127,
	[0][0][1][0][RTW89_CN][50] = 127,
	[0][0][1][0][RTW89_UK][50] = 127,
	[0][0][1][0][RTW89_FCC][52] = 72,
	[0][0][1][0][RTW89_ETSI][52] = 127,
	[0][0][1][0][RTW89_MKK][52] = 127,
	[0][0][1][0][RTW89_IC][52] = 127,
	[0][0][1][0][RTW89_KCC][52] = 127,
	[0][0][1][0][RTW89_ACMA][52] = 127,
	[0][0][1][0][RTW89_CN][52] = 127,
	[0][0][1][0][RTW89_UK][52] = 127,
	[0][1][1][0][RTW89_FCC][0] = 127,
	[0][1][1][0][RTW89_ETSI][0] = 127,
	[0][1][1][0][RTW89_MKK][0] = 127,
	[0][1][1][0][RTW89_IC][0] = 127,
	[0][1][1][0][RTW89_KCC][0] = 127,
	[0][1][1][0][RTW89_ACMA][0] = 127,
	[0][1][1][0][RTW89_CN][0] = 127,
	[0][1][1][0][RTW89_UK][0] = 127,
	[0][1][1][0][RTW89_FCC][2] = 127,
	[0][1][1][0][RTW89_ETSI][2] = 127,
	[0][1][1][0][RTW89_MKK][2] = 127,
	[0][1][1][0][RTW89_IC][2] = 127,
	[0][1][1][0][RTW89_KCC][2] = 127,
	[0][1][1][0][RTW89_ACMA][2] = 127,
	[0][1][1][0][RTW89_CN][2] = 127,
	[0][1][1][0][RTW89_UK][2] = 127,
	[0][1][1][0][RTW89_FCC][4] = 127,
	[0][1][1][0][RTW89_ETSI][4] = 127,
	[0][1][1][0][RTW89_MKK][4] = 127,
	[0][1][1][0][RTW89_IC][4] = 127,
	[0][1][1][0][RTW89_KCC][4] = 127,
	[0][1][1][0][RTW89_ACMA][4] = 127,
	[0][1][1][0][RTW89_CN][4] = 127,
	[0][1][1][0][RTW89_UK][4] = 127,
	[0][1][1][0][RTW89_FCC][6] = 127,
	[0][1][1][0][RTW89_ETSI][6] = 127,
	[0][1][1][0][RTW89_MKK][6] = 127,
	[0][1][1][0][RTW89_IC][6] = 127,
	[0][1][1][0][RTW89_KCC][6] = 127,
	[0][1][1][0][RTW89_ACMA][6] = 127,
	[0][1][1][0][RTW89_CN][6] = 127,
	[0][1][1][0][RTW89_UK][6] = 127,
	[0][1][1][0][RTW89_FCC][8] = 127,
	[0][1][1][0][RTW89_ETSI][8] = 127,
	[0][1][1][0][RTW89_MKK][8] = 127,
	[0][1][1][0][RTW89_IC][8] = 127,
	[0][1][1][0][RTW89_KCC][8] = 127,
	[0][1][1][0][RTW89_ACMA][8] = 127,
	[0][1][1][0][RTW89_CN][8] = 127,
	[0][1][1][0][RTW89_UK][8] = 127,
	[0][1][1][0][RTW89_FCC][10] = 127,
	[0][1][1][0][RTW89_ETSI][10] = 127,
	[0][1][1][0][RTW89_MKK][10] = 127,
	[0][1][1][0][RTW89_IC][10] = 127,
	[0][1][1][0][RTW89_KCC][10] = 127,
	[0][1][1][0][RTW89_ACMA][10] = 127,
	[0][1][1][0][RTW89_CN][10] = 127,
	[0][1][1][0][RTW89_UK][10] = 127,
	[0][1][1][0][RTW89_FCC][12] = 127,
	[0][1][1][0][RTW89_ETSI][12] = 127,
	[0][1][1][0][RTW89_MKK][12] = 127,
	[0][1][1][0][RTW89_IC][12] = 127,
	[0][1][1][0][RTW89_KCC][12] = 127,
	[0][1][1][0][RTW89_ACMA][12] = 127,
	[0][1][1][0][RTW89_CN][12] = 127,
	[0][1][1][0][RTW89_UK][12] = 127,
	[0][1][1][0][RTW89_FCC][14] = 127,
	[0][1][1][0][RTW89_ETSI][14] = 127,
	[0][1][1][0][RTW89_MKK][14] = 127,
	[0][1][1][0][RTW89_IC][14] = 127,
	[0][1][1][0][RTW89_KCC][14] = 127,
	[0][1][1][0][RTW89_ACMA][14] = 127,
	[0][1][1][0][RTW89_CN][14] = 127,
	[0][1][1][0][RTW89_UK][14] = 127,
	[0][1][1][0][RTW89_FCC][15] = 127,
	[0][1][1][0][RTW89_ETSI][15] = 127,
	[0][1][1][0][RTW89_MKK][15] = 127,
	[0][1][1][0][RTW89_IC][15] = 127,
	[0][1][1][0][RTW89_KCC][15] = 127,
	[0][1][1][0][RTW89_ACMA][15] = 127,
	[0][1][1][0][RTW89_CN][15] = 127,
	[0][1][1][0][RTW89_UK][15] = 127,
	[0][1][1][0][RTW89_FCC][17] = 127,
	[0][1][1][0][RTW89_ETSI][17] = 127,
	[0][1][1][0][RTW89_MKK][17] = 127,
	[0][1][1][0][RTW89_IC][17] = 127,
	[0][1][1][0][RTW89_KCC][17] = 127,
	[0][1][1][0][RTW89_ACMA][17] = 127,
	[0][1][1][0][RTW89_CN][17] = 127,
	[0][1][1][0][RTW89_UK][17] = 127,
	[0][1][1][0][RTW89_FCC][19] = 127,
	[0][1][1][0][RTW89_ETSI][19] = 127,
	[0][1][1][0][RTW89_MKK][19] = 127,
	[0][1][1][0][RTW89_IC][19] = 127,
	[0][1][1][0][RTW89_KCC][19] = 127,
	[0][1][1][0][RTW89_ACMA][19] = 127,
	[0][1][1][0][RTW89_CN][19] = 127,
	[0][1][1][0][RTW89_UK][19] = 127,
	[0][1][1][0][RTW89_FCC][21] = 127,
	[0][1][1][0][RTW89_ETSI][21] = 127,
	[0][1][1][0][RTW89_MKK][21] = 127,
	[0][1][1][0][RTW89_IC][21] = 127,
	[0][1][1][0][RTW89_KCC][21] = 127,
	[0][1][1][0][RTW89_ACMA][21] = 127,
	[0][1][1][0][RTW89_CN][21] = 127,
	[0][1][1][0][RTW89_UK][21] = 127,
	[0][1][1][0][RTW89_FCC][23] = 127,
	[0][1][1][0][RTW89_ETSI][23] = 127,
	[0][1][1][0][RTW89_MKK][23] = 127,
	[0][1][1][0][RTW89_IC][23] = 127,
	[0][1][1][0][RTW89_KCC][23] = 127,
	[0][1][1][0][RTW89_ACMA][23] = 127,
	[0][1][1][0][RTW89_CN][23] = 127,
	[0][1][1][0][RTW89_UK][23] = 127,
	[0][1][1][0][RTW89_FCC][25] = 127,
	[0][1][1][0][RTW89_ETSI][25] = 127,
	[0][1][1][0][RTW89_MKK][25] = 127,
	[0][1][1][0][RTW89_IC][25] = 127,
	[0][1][1][0][RTW89_KCC][25] = 127,
	[0][1][1][0][RTW89_ACMA][25] = 127,
	[0][1][1][0][RTW89_CN][25] = 127,
	[0][1][1][0][RTW89_UK][25] = 127,
	[0][1][1][0][RTW89_FCC][27] = 127,
	[0][1][1][0][RTW89_ETSI][27] = 127,
	[0][1][1][0][RTW89_MKK][27] = 127,
	[0][1][1][0][RTW89_IC][27] = 127,
	[0][1][1][0][RTW89_KCC][27] = 127,
	[0][1][1][0][RTW89_ACMA][27] = 127,
	[0][1][1][0][RTW89_CN][27] = 127,
	[0][1][1][0][RTW89_UK][27] = 127,
	[0][1][1][0][RTW89_FCC][29] = 127,
	[0][1][1][0][RTW89_ETSI][29] = 127,
	[0][1][1][0][RTW89_MKK][29] = 127,
	[0][1][1][0][RTW89_IC][29] = 127,
	[0][1][1][0][RTW89_KCC][29] = 127,
	[0][1][1][0][RTW89_ACMA][29] = 127,
	[0][1][1][0][RTW89_CN][29] = 127,
	[0][1][1][0][RTW89_UK][29] = 127,
	[0][1][1][0][RTW89_FCC][31] = 127,
	[0][1][1][0][RTW89_ETSI][31] = 127,
	[0][1][1][0][RTW89_MKK][31] = 127,
	[0][1][1][0][RTW89_IC][31] = 127,
	[0][1][1][0][RTW89_KCC][31] = 127,
	[0][1][1][0][RTW89_ACMA][31] = 127,
	[0][1][1][0][RTW89_CN][31] = 127,
	[0][1][1][0][RTW89_UK][31] = 127,
	[0][1][1][0][RTW89_FCC][33] = 127,
	[0][1][1][0][RTW89_ETSI][33] = 127,
	[0][1][1][0][RTW89_MKK][33] = 127,
	[0][1][1][0][RTW89_IC][33] = 127,
	[0][1][1][0][RTW89_KCC][33] = 127,
	[0][1][1][0][RTW89_ACMA][33] = 127,
	[0][1][1][0][RTW89_CN][33] = 127,
	[0][1][1][0][RTW89_UK][33] = 127,
	[0][1][1][0][RTW89_FCC][35] = 127,
	[0][1][1][0][RTW89_ETSI][35] = 127,
	[0][1][1][0][RTW89_MKK][35] = 127,
	[0][1][1][0][RTW89_IC][35] = 127,
	[0][1][1][0][RTW89_KCC][35] = 127,
	[0][1][1][0][RTW89_ACMA][35] = 127,
	[0][1][1][0][RTW89_CN][35] = 127,
	[0][1][1][0][RTW89_UK][35] = 127,
	[0][1][1][0][RTW89_FCC][37] = 127,
	[0][1][1][0][RTW89_ETSI][37] = 127,
	[0][1][1][0][RTW89_MKK][37] = 127,
	[0][1][1][0][RTW89_IC][37] = 127,
	[0][1][1][0][RTW89_KCC][37] = 127,
	[0][1][1][0][RTW89_ACMA][37] = 127,
	[0][1][1][0][RTW89_CN][37] = 127,
	[0][1][1][0][RTW89_UK][37] = 127,
	[0][1][1][0][RTW89_FCC][38] = 127,
	[0][1][1][0][RTW89_ETSI][38] = 127,
	[0][1][1][0][RTW89_MKK][38] = 127,
	[0][1][1][0][RTW89_IC][38] = 127,
	[0][1][1][0][RTW89_KCC][38] = 127,
	[0][1][1][0][RTW89_ACMA][38] = 127,
	[0][1][1][0][RTW89_CN][38] = 127,
	[0][1][1][0][RTW89_UK][38] = 127,
	[0][1][1][0][RTW89_FCC][40] = 127,
	[0][1][1][0][RTW89_ETSI][40] = 127,
	[0][1][1][0][RTW89_MKK][40] = 127,
	[0][1][1][0][RTW89_IC][40] = 127,
	[0][1][1][0][RTW89_KCC][40] = 127,
	[0][1][1][0][RTW89_ACMA][40] = 127,
	[0][1][1][0][RTW89_CN][40] = 127,
	[0][1][1][0][RTW89_UK][40] = 127,
	[0][1][1][0][RTW89_FCC][42] = 127,
	[0][1][1][0][RTW89_ETSI][42] = 127,
	[0][1][1][0][RTW89_MKK][42] = 127,
	[0][1][1][0][RTW89_IC][42] = 127,
	[0][1][1][0][RTW89_KCC][42] = 127,
	[0][1][1][0][RTW89_ACMA][42] = 127,
	[0][1][1][0][RTW89_CN][42] = 127,
	[0][1][1][0][RTW89_UK][42] = 127,
	[0][1][1][0][RTW89_FCC][44] = 127,
	[0][1][1][0][RTW89_ETSI][44] = 127,
	[0][1][1][0][RTW89_MKK][44] = 127,
	[0][1][1][0][RTW89_IC][44] = 127,
	[0][1][1][0][RTW89_KCC][44] = 127,
	[0][1][1][0][RTW89_ACMA][44] = 127,
	[0][1][1][0][RTW89_CN][44] = 127,
	[0][1][1][0][RTW89_UK][44] = 127,
	[0][1][1][0][RTW89_FCC][46] = 127,
	[0][1][1][0][RTW89_ETSI][46] = 127,
	[0][1][1][0][RTW89_MKK][46] = 127,
	[0][1][1][0][RTW89_IC][46] = 127,
	[0][1][1][0][RTW89_KCC][46] = 127,
	[0][1][1][0][RTW89_ACMA][46] = 127,
	[0][1][1][0][RTW89_CN][46] = 127,
	[0][1][1][0][RTW89_UK][46] = 127,
	[0][1][1][0][RTW89_FCC][48] = 127,
	[0][1][1][0][RTW89_ETSI][48] = 127,
	[0][1][1][0][RTW89_MKK][48] = 127,
	[0][1][1][0][RTW89_IC][48] = 127,
	[0][1][1][0][RTW89_KCC][48] = 127,
	[0][1][1][0][RTW89_ACMA][48] = 127,
	[0][1][1][0][RTW89_CN][48] = 127,
	[0][1][1][0][RTW89_UK][48] = 127,
	[0][1][1][0][RTW89_FCC][50] = 127,
	[0][1][1][0][RTW89_ETSI][50] = 127,
	[0][1][1][0][RTW89_MKK][50] = 127,
	[0][1][1][0][RTW89_IC][50] = 127,
	[0][1][1][0][RTW89_KCC][50] = 127,
	[0][1][1][0][RTW89_ACMA][50] = 127,
	[0][1][1][0][RTW89_CN][50] = 127,
	[0][1][1][0][RTW89_UK][50] = 127,
	[0][1][1][0][RTW89_FCC][52] = 127,
	[0][1][1][0][RTW89_ETSI][52] = 127,
	[0][1][1][0][RTW89_MKK][52] = 127,
	[0][1][1][0][RTW89_IC][52] = 127,
	[0][1][1][0][RTW89_KCC][52] = 127,
	[0][1][1][0][RTW89_ACMA][52] = 127,
	[0][1][1][0][RTW89_CN][52] = 127,
	[0][1][1][0][RTW89_UK][52] = 127,
	[0][0][2][0][RTW89_FCC][0] = 76,
	[0][0][2][0][RTW89_ETSI][0] = 62,
	[0][0][2][0][RTW89_MKK][0] = 62,
	[0][0][2][0][RTW89_IC][0] = 64,
	[0][0][2][0][RTW89_KCC][0] = 74,
	[0][0][2][0][RTW89_ACMA][0] = 62,
	[0][0][2][0][RTW89_CN][0] = 60,
	[0][0][2][0][RTW89_UK][0] = 62,
	[0][0][2][0][RTW89_FCC][2] = 78,
	[0][0][2][0][RTW89_ETSI][2] = 62,
	[0][0][2][0][RTW89_MKK][2] = 62,
	[0][0][2][0][RTW89_IC][2] = 64,
	[0][0][2][0][RTW89_KCC][2] = 74,
	[0][0][2][0][RTW89_ACMA][2] = 62,
	[0][0][2][0][RTW89_CN][2] = 60,
	[0][0][2][0][RTW89_UK][2] = 62,
	[0][0][2][0][RTW89_FCC][4] = 78,
	[0][0][2][0][RTW89_ETSI][4] = 62,
	[0][0][2][0][RTW89_MKK][4] = 62,
	[0][0][2][0][RTW89_IC][4] = 64,
	[0][0][2][0][RTW89_KCC][4] = 74,
	[0][0][2][0][RTW89_ACMA][4] = 62,
	[0][0][2][0][RTW89_CN][4] = 60,
	[0][0][2][0][RTW89_UK][4] = 62,
	[0][0][2][0][RTW89_FCC][6] = 78,
	[0][0][2][0][RTW89_ETSI][6] = 62,
	[0][0][2][0][RTW89_MKK][6] = 62,
	[0][0][2][0][RTW89_IC][6] = 64,
	[0][0][2][0][RTW89_KCC][6] = 54,
	[0][0][2][0][RTW89_ACMA][6] = 62,
	[0][0][2][0][RTW89_CN][6] = 60,
	[0][0][2][0][RTW89_UK][6] = 62,
	[0][0][2][0][RTW89_FCC][8] = 78,
	[0][0][2][0][RTW89_ETSI][8] = 62,
	[0][0][2][0][RTW89_MKK][8] = 62,
	[0][0][2][0][RTW89_IC][8] = 64,
	[0][0][2][0][RTW89_KCC][8] = 74,
	[0][0][2][0][RTW89_ACMA][8] = 62,
	[0][0][2][0][RTW89_CN][8] = 60,
	[0][0][2][0][RTW89_UK][8] = 62,
	[0][0][2][0][RTW89_FCC][10] = 78,
	[0][0][2][0][RTW89_ETSI][10] = 62,
	[0][0][2][0][RTW89_MKK][10] = 62,
	[0][0][2][0][RTW89_IC][10] = 64,
	[0][0][2][0][RTW89_KCC][10] = 74,
	[0][0][2][0][RTW89_ACMA][10] = 62,
	[0][0][2][0][RTW89_CN][10] = 60,
	[0][0][2][0][RTW89_UK][10] = 62,
	[0][0][2][0][RTW89_FCC][12] = 78,
	[0][0][2][0][RTW89_ETSI][12] = 62,
	[0][0][2][0][RTW89_MKK][12] = 62,
	[0][0][2][0][RTW89_IC][12] = 64,
	[0][0][2][0][RTW89_KCC][12] = 74,
	[0][0][2][0][RTW89_ACMA][12] = 62,
	[0][0][2][0][RTW89_CN][12] = 60,
	[0][0][2][0][RTW89_UK][12] = 62,
	[0][0][2][0][RTW89_FCC][14] = 74,
	[0][0][2][0][RTW89_ETSI][14] = 62,
	[0][0][2][0][RTW89_MKK][14] = 62,
	[0][0][2][0][RTW89_IC][14] = 64,
	[0][0][2][0][RTW89_KCC][14] = 74,
	[0][0][2][0][RTW89_ACMA][14] = 62,
	[0][0][2][0][RTW89_CN][14] = 60,
	[0][0][2][0][RTW89_UK][14] = 62,
	[0][0][2][0][RTW89_FCC][15] = 74,
	[0][0][2][0][RTW89_ETSI][15] = 60,
	[0][0][2][0][RTW89_MKK][15] = 74,
	[0][0][2][0][RTW89_IC][15] = 74,
	[0][0][2][0][RTW89_KCC][15] = 74,
	[0][0][2][0][RTW89_ACMA][15] = 60,
	[0][0][2][0][RTW89_CN][15] = 127,
	[0][0][2][0][RTW89_UK][15] = 60,
	[0][0][2][0][RTW89_FCC][17] = 78,
	[0][0][2][0][RTW89_ETSI][17] = 62,
	[0][0][2][0][RTW89_MKK][17] = 74,
	[0][0][2][0][RTW89_IC][17] = 78,
	[0][0][2][0][RTW89_KCC][17] = 74,
	[0][0][2][0][RTW89_ACMA][17] = 62,
	[0][0][2][0][RTW89_CN][17] = 127,
	[0][0][2][0][RTW89_UK][17] = 62,
	[0][0][2][0][RTW89_FCC][19] = 78,
	[0][0][2][0][RTW89_ETSI][19] = 62,
	[0][0][2][0][RTW89_MKK][19] = 74,
	[0][0][2][0][RTW89_IC][19] = 78,
	[0][0][2][0][RTW89_KCC][19] = 74,
	[0][0][2][0][RTW89_ACMA][19] = 62,
	[0][0][2][0][RTW89_CN][19] = 127,
	[0][0][2][0][RTW89_UK][19] = 62,
	[0][0][2][0][RTW89_FCC][21] = 78,
	[0][0][2][0][RTW89_ETSI][21] = 62,
	[0][0][2][0][RTW89_MKK][21] = 74,
	[0][0][2][0][RTW89_IC][21] = 78,
	[0][0][2][0][RTW89_KCC][21] = 74,
	[0][0][2][0][RTW89_ACMA][21] = 62,
	[0][0][2][0][RTW89_CN][21] = 127,
	[0][0][2][0][RTW89_UK][21] = 62,
	[0][0][2][0][RTW89_FCC][23] = 78,
	[0][0][2][0][RTW89_ETSI][23] = 62,
	[0][0][2][0][RTW89_MKK][23] = 74,
	[0][0][2][0][RTW89_IC][23] = 78,
	[0][0][2][0][RTW89_KCC][23] = 74,
	[0][0][2][0][RTW89_ACMA][23] = 62,
	[0][0][2][0][RTW89_CN][23] = 127,
	[0][0][2][0][RTW89_UK][23] = 62,
	[0][0][2][0][RTW89_FCC][25] = 78,
	[0][0][2][0][RTW89_ETSI][25] = 62,
	[0][0][2][0][RTW89_MKK][25] = 74,
	[0][0][2][0][RTW89_IC][25] = 127,
	[0][0][2][0][RTW89_KCC][25] = 74,
	[0][0][2][0][RTW89_ACMA][25] = 127,
	[0][0][2][0][RTW89_CN][25] = 127,
	[0][0][2][0][RTW89_UK][25] = 62,
	[0][0][2][0][RTW89_FCC][27] = 78,
	[0][0][2][0][RTW89_ETSI][27] = 62,
	[0][0][2][0][RTW89_MKK][27] = 74,
	[0][0][2][0][RTW89_IC][27] = 127,
	[0][0][2][0][RTW89_KCC][27] = 74,
	[0][0][2][0][RTW89_ACMA][27] = 127,
	[0][0][2][0][RTW89_CN][27] = 127,
	[0][0][2][0][RTW89_UK][27] = 62,
	[0][0][2][0][RTW89_FCC][29] = 78,
	[0][0][2][0][RTW89_ETSI][29] = 62,
	[0][0][2][0][RTW89_MKK][29] = 74,
	[0][0][2][0][RTW89_IC][29] = 127,
	[0][0][2][0][RTW89_KCC][29] = 74,
	[0][0][2][0][RTW89_ACMA][29] = 127,
	[0][0][2][0][RTW89_CN][29] = 127,
	[0][0][2][0][RTW89_UK][29] = 62,
	[0][0][2][0][RTW89_FCC][31] = 78,
	[0][0][2][0][RTW89_ETSI][31] = 62,
	[0][0][2][0][RTW89_MKK][31] = 74,
	[0][0][2][0][RTW89_IC][31] = 78,
	[0][0][2][0][RTW89_KCC][31] = 74,
	[0][0][2][0][RTW89_ACMA][31] = 62,
	[0][0][2][0][RTW89_CN][31] = 127,
	[0][0][2][0][RTW89_UK][31] = 62,
	[0][0][2][0][RTW89_FCC][33] = 78,
	[0][0][2][0][RTW89_ETSI][33] = 62,
	[0][0][2][0][RTW89_MKK][33] = 74,
	[0][0][2][0][RTW89_IC][33] = 78,
	[0][0][2][0][RTW89_KCC][33] = 74,
	[0][0][2][0][RTW89_ACMA][33] = 62,
	[0][0][2][0][RTW89_CN][33] = 127,
	[0][0][2][0][RTW89_UK][33] = 62,
	[0][0][2][0][RTW89_FCC][35] = 72,
	[0][0][2][0][RTW89_ETSI][35] = 62,
	[0][0][2][0][RTW89_MKK][35] = 74,
	[0][0][2][0][RTW89_IC][35] = 72,
	[0][0][2][0][RTW89_KCC][35] = 74,
	[0][0][2][0][RTW89_ACMA][35] = 62,
	[0][0][2][0][RTW89_CN][35] = 127,
	[0][0][2][0][RTW89_UK][35] = 62,
	[0][0][2][0][RTW89_FCC][37] = 78,
	[0][0][2][0][RTW89_ETSI][37] = 127,
	[0][0][2][0][RTW89_MKK][37] = 74,
	[0][0][2][0][RTW89_IC][37] = 78,
	[0][0][2][0][RTW89_KCC][37] = 74,
	[0][0][2][0][RTW89_ACMA][37] = 74,
	[0][0][2][0][RTW89_CN][37] = 127,
	[0][0][2][0][RTW89_UK][37] = 74,
	[0][0][2][0][RTW89_FCC][38] = 78,
	[0][0][2][0][RTW89_ETSI][38] = 30,
	[0][0][2][0][RTW89_MKK][38] = 127,
	[0][0][2][0][RTW89_IC][38] = 78,
	[0][0][2][0][RTW89_KCC][38] = 66,
	[0][0][2][0][RTW89_ACMA][38] = 74,
	[0][0][2][0][RTW89_CN][38] = 66,
	[0][0][2][0][RTW89_UK][38] = 60,
	[0][0][2][0][RTW89_FCC][40] = 78,
	[0][0][2][0][RTW89_ETSI][40] = 30,
	[0][0][2][0][RTW89_MKK][40] = 127,
	[0][0][2][0][RTW89_IC][40] = 78,
	[0][0][2][0][RTW89_KCC][40] = 74,
	[0][0][2][0][RTW89_ACMA][40] = 74,
	[0][0][2][0][RTW89_CN][40] = 66,
	[0][0][2][0][RTW89_UK][40] = 60,
	[0][0][2][0][RTW89_FCC][42] = 78,
	[0][0][2][0][RTW89_ETSI][42] = 30,
	[0][0][2][0][RTW89_MKK][42] = 127,
	[0][0][2][0][RTW89_IC][42] = 78,
	[0][0][2][0][RTW89_KCC][42] = 74,
	[0][0][2][0][RTW89_ACMA][42] = 74,
	[0][0][2][0][RTW89_CN][42] = 66,
	[0][0][2][0][RTW89_UK][42] = 60,
	[0][0][2][0][RTW89_FCC][44] = 78,
	[0][0][2][0][RTW89_ETSI][44] = 30,
	[0][0][2][0][RTW89_MKK][44] = 127,
	[0][0][2][0][RTW89_IC][44] = 78,
	[0][0][2][0][RTW89_KCC][44] = 74,
	[0][0][2][0][RTW89_ACMA][44] = 74,
	[0][0][2][0][RTW89_CN][44] = 64,
	[0][0][2][0][RTW89_UK][44] = 60,
	[0][0][2][0][RTW89_FCC][46] = 78,
	[0][0][2][0][RTW89_ETSI][46] = 30,
	[0][0][2][0][RTW89_MKK][46] = 127,
	[0][0][2][0][RTW89_IC][46] = 78,
	[0][0][2][0][RTW89_KCC][46] = 74,
	[0][0][2][0][RTW89_ACMA][46] = 74,
	[0][0][2][0][RTW89_CN][46] = 64,
	[0][0][2][0][RTW89_UK][46] = 60,
	[0][0][2][0][RTW89_FCC][48] = 74,
	[0][0][2][0][RTW89_ETSI][48] = 127,
	[0][0][2][0][RTW89_MKK][48] = 127,
	[0][0][2][0][RTW89_IC][48] = 127,
	[0][0][2][0][RTW89_KCC][48] = 127,
	[0][0][2][0][RTW89_ACMA][48] = 127,
	[0][0][2][0][RTW89_CN][48] = 127,
	[0][0][2][0][RTW89_UK][48] = 127,
	[0][0][2][0][RTW89_FCC][50] = 74,
	[0][0][2][0][RTW89_ETSI][50] = 127,
	[0][0][2][0][RTW89_MKK][50] = 127,
	[0][0][2][0][RTW89_IC][50] = 127,
	[0][0][2][0][RTW89_KCC][50] = 127,
	[0][0][2][0][RTW89_ACMA][50] = 127,
	[0][0][2][0][RTW89_CN][50] = 127,
	[0][0][2][0][RTW89_UK][50] = 127,
	[0][0][2][0][RTW89_FCC][52] = 74,
	[0][0][2][0][RTW89_ETSI][52] = 127,
	[0][0][2][0][RTW89_MKK][52] = 127,
	[0][0][2][0][RTW89_IC][52] = 127,
	[0][0][2][0][RTW89_KCC][52] = 127,
	[0][0][2][0][RTW89_ACMA][52] = 127,
	[0][0][2][0][RTW89_CN][52] = 127,
	[0][0][2][0][RTW89_UK][52] = 127,
	[0][1][2][0][RTW89_FCC][0] = 127,
	[0][1][2][0][RTW89_ETSI][0] = 127,
	[0][1][2][0][RTW89_MKK][0] = 127,
	[0][1][2][0][RTW89_IC][0] = 127,
	[0][1][2][0][RTW89_KCC][0] = 127,
	[0][1][2][0][RTW89_ACMA][0] = 127,
	[0][1][2][0][RTW89_CN][0] = 127,
	[0][1][2][0][RTW89_UK][0] = 127,
	[0][1][2][0][RTW89_FCC][2] = 127,
	[0][1][2][0][RTW89_ETSI][2] = 127,
	[0][1][2][0][RTW89_MKK][2] = 127,
	[0][1][2][0][RTW89_IC][2] = 127,
	[0][1][2][0][RTW89_KCC][2] = 127,
	[0][1][2][0][RTW89_ACMA][2] = 127,
	[0][1][2][0][RTW89_CN][2] = 127,
	[0][1][2][0][RTW89_UK][2] = 127,
	[0][1][2][0][RTW89_FCC][4] = 127,
	[0][1][2][0][RTW89_ETSI][4] = 127,
	[0][1][2][0][RTW89_MKK][4] = 127,
	[0][1][2][0][RTW89_IC][4] = 127,
	[0][1][2][0][RTW89_KCC][4] = 127,
	[0][1][2][0][RTW89_ACMA][4] = 127,
	[0][1][2][0][RTW89_CN][4] = 127,
	[0][1][2][0][RTW89_UK][4] = 127,
	[0][1][2][0][RTW89_FCC][6] = 127,
	[0][1][2][0][RTW89_ETSI][6] = 127,
	[0][1][2][0][RTW89_MKK][6] = 127,
	[0][1][2][0][RTW89_IC][6] = 127,
	[0][1][2][0][RTW89_KCC][6] = 127,
	[0][1][2][0][RTW89_ACMA][6] = 127,
	[0][1][2][0][RTW89_CN][6] = 127,
	[0][1][2][0][RTW89_UK][6] = 127,
	[0][1][2][0][RTW89_FCC][8] = 127,
	[0][1][2][0][RTW89_ETSI][8] = 127,
	[0][1][2][0][RTW89_MKK][8] = 127,
	[0][1][2][0][RTW89_IC][8] = 127,
	[0][1][2][0][RTW89_KCC][8] = 127,
	[0][1][2][0][RTW89_ACMA][8] = 127,
	[0][1][2][0][RTW89_CN][8] = 127,
	[0][1][2][0][RTW89_UK][8] = 127,
	[0][1][2][0][RTW89_FCC][10] = 127,
	[0][1][2][0][RTW89_ETSI][10] = 127,
	[0][1][2][0][RTW89_MKK][10] = 127,
	[0][1][2][0][RTW89_IC][10] = 127,
	[0][1][2][0][RTW89_KCC][10] = 127,
	[0][1][2][0][RTW89_ACMA][10] = 127,
	[0][1][2][0][RTW89_CN][10] = 127,
	[0][1][2][0][RTW89_UK][10] = 127,
	[0][1][2][0][RTW89_FCC][12] = 127,
	[0][1][2][0][RTW89_ETSI][12] = 127,
	[0][1][2][0][RTW89_MKK][12] = 127,
	[0][1][2][0][RTW89_IC][12] = 127,
	[0][1][2][0][RTW89_KCC][12] = 127,
	[0][1][2][0][RTW89_ACMA][12] = 127,
	[0][1][2][0][RTW89_CN][12] = 127,
	[0][1][2][0][RTW89_UK][12] = 127,
	[0][1][2][0][RTW89_FCC][14] = 127,
	[0][1][2][0][RTW89_ETSI][14] = 127,
	[0][1][2][0][RTW89_MKK][14] = 127,
	[0][1][2][0][RTW89_IC][14] = 127,
	[0][1][2][0][RTW89_KCC][14] = 127,
	[0][1][2][0][RTW89_ACMA][14] = 127,
	[0][1][2][0][RTW89_CN][14] = 127,
	[0][1][2][0][RTW89_UK][14] = 127,
	[0][1][2][0][RTW89_FCC][15] = 127,
	[0][1][2][0][RTW89_ETSI][15] = 127,
	[0][1][2][0][RTW89_MKK][15] = 127,
	[0][1][2][0][RTW89_IC][15] = 127,
	[0][1][2][0][RTW89_KCC][15] = 127,
	[0][1][2][0][RTW89_ACMA][15] = 127,
	[0][1][2][0][RTW89_CN][15] = 127,
	[0][1][2][0][RTW89_UK][15] = 127,
	[0][1][2][0][RTW89_FCC][17] = 127,
	[0][1][2][0][RTW89_ETSI][17] = 127,
	[0][1][2][0][RTW89_MKK][17] = 127,
	[0][1][2][0][RTW89_IC][17] = 127,
	[0][1][2][0][RTW89_KCC][17] = 127,
	[0][1][2][0][RTW89_ACMA][17] = 127,
	[0][1][2][0][RTW89_CN][17] = 127,
	[0][1][2][0][RTW89_UK][17] = 127,
	[0][1][2][0][RTW89_FCC][19] = 127,
	[0][1][2][0][RTW89_ETSI][19] = 127,
	[0][1][2][0][RTW89_MKK][19] = 127,
	[0][1][2][0][RTW89_IC][19] = 127,
	[0][1][2][0][RTW89_KCC][19] = 127,
	[0][1][2][0][RTW89_ACMA][19] = 127,
	[0][1][2][0][RTW89_CN][19] = 127,
	[0][1][2][0][RTW89_UK][19] = 127,
	[0][1][2][0][RTW89_FCC][21] = 127,
	[0][1][2][0][RTW89_ETSI][21] = 127,
	[0][1][2][0][RTW89_MKK][21] = 127,
	[0][1][2][0][RTW89_IC][21] = 127,
	[0][1][2][0][RTW89_KCC][21] = 127,
	[0][1][2][0][RTW89_ACMA][21] = 127,
	[0][1][2][0][RTW89_CN][21] = 127,
	[0][1][2][0][RTW89_UK][21] = 127,
	[0][1][2][0][RTW89_FCC][23] = 127,
	[0][1][2][0][RTW89_ETSI][23] = 127,
	[0][1][2][0][RTW89_MKK][23] = 127,
	[0][1][2][0][RTW89_IC][23] = 127,
	[0][1][2][0][RTW89_KCC][23] = 127,
	[0][1][2][0][RTW89_ACMA][23] = 127,
	[0][1][2][0][RTW89_CN][23] = 127,
	[0][1][2][0][RTW89_UK][23] = 127,
	[0][1][2][0][RTW89_FCC][25] = 127,
	[0][1][2][0][RTW89_ETSI][25] = 127,
	[0][1][2][0][RTW89_MKK][25] = 127,
	[0][1][2][0][RTW89_IC][25] = 127,
	[0][1][2][0][RTW89_KCC][25] = 127,
	[0][1][2][0][RTW89_ACMA][25] = 127,
	[0][1][2][0][RTW89_CN][25] = 127,
	[0][1][2][0][RTW89_UK][25] = 127,
	[0][1][2][0][RTW89_FCC][27] = 127,
	[0][1][2][0][RTW89_ETSI][27] = 127,
	[0][1][2][0][RTW89_MKK][27] = 127,
	[0][1][2][0][RTW89_IC][27] = 127,
	[0][1][2][0][RTW89_KCC][27] = 127,
	[0][1][2][0][RTW89_ACMA][27] = 127,
	[0][1][2][0][RTW89_CN][27] = 127,
	[0][1][2][0][RTW89_UK][27] = 127,
	[0][1][2][0][RTW89_FCC][29] = 127,
	[0][1][2][0][RTW89_ETSI][29] = 127,
	[0][1][2][0][RTW89_MKK][29] = 127,
	[0][1][2][0][RTW89_IC][29] = 127,
	[0][1][2][0][RTW89_KCC][29] = 127,
	[0][1][2][0][RTW89_ACMA][29] = 127,
	[0][1][2][0][RTW89_CN][29] = 127,
	[0][1][2][0][RTW89_UK][29] = 127,
	[0][1][2][0][RTW89_FCC][31] = 127,
	[0][1][2][0][RTW89_ETSI][31] = 127,
	[0][1][2][0][RTW89_MKK][31] = 127,
	[0][1][2][0][RTW89_IC][31] = 127,
	[0][1][2][0][RTW89_KCC][31] = 127,
	[0][1][2][0][RTW89_ACMA][31] = 127,
	[0][1][2][0][RTW89_CN][31] = 127,
	[0][1][2][0][RTW89_UK][31] = 127,
	[0][1][2][0][RTW89_FCC][33] = 127,
	[0][1][2][0][RTW89_ETSI][33] = 127,
	[0][1][2][0][RTW89_MKK][33] = 127,
	[0][1][2][0][RTW89_IC][33] = 127,
	[0][1][2][0][RTW89_KCC][33] = 127,
	[0][1][2][0][RTW89_ACMA][33] = 127,
	[0][1][2][0][RTW89_CN][33] = 127,
	[0][1][2][0][RTW89_UK][33] = 127,
	[0][1][2][0][RTW89_FCC][35] = 127,
	[0][1][2][0][RTW89_ETSI][35] = 127,
	[0][1][2][0][RTW89_MKK][35] = 127,
	[0][1][2][0][RTW89_IC][35] = 127,
	[0][1][2][0][RTW89_KCC][35] = 127,
	[0][1][2][0][RTW89_ACMA][35] = 127,
	[0][1][2][0][RTW89_CN][35] = 127,
	[0][1][2][0][RTW89_UK][35] = 127,
	[0][1][2][0][RTW89_FCC][37] = 127,
	[0][1][2][0][RTW89_ETSI][37] = 127,
	[0][1][2][0][RTW89_MKK][37] = 127,
	[0][1][2][0][RTW89_IC][37] = 127,
	[0][1][2][0][RTW89_KCC][37] = 127,
	[0][1][2][0][RTW89_ACMA][37] = 127,
	[0][1][2][0][RTW89_CN][37] = 127,
	[0][1][2][0][RTW89_UK][37] = 127,
	[0][1][2][0][RTW89_FCC][38] = 127,
	[0][1][2][0][RTW89_ETSI][38] = 127,
	[0][1][2][0][RTW89_MKK][38] = 127,
	[0][1][2][0][RTW89_IC][38] = 127,
	[0][1][2][0][RTW89_KCC][38] = 127,
	[0][1][2][0][RTW89_ACMA][38] = 127,
	[0][1][2][0][RTW89_CN][38] = 127,
	[0][1][2][0][RTW89_UK][38] = 127,
	[0][1][2][0][RTW89_FCC][40] = 127,
	[0][1][2][0][RTW89_ETSI][40] = 127,
	[0][1][2][0][RTW89_MKK][40] = 127,
	[0][1][2][0][RTW89_IC][40] = 127,
	[0][1][2][0][RTW89_KCC][40] = 127,
	[0][1][2][0][RTW89_ACMA][40] = 127,
	[0][1][2][0][RTW89_CN][40] = 127,
	[0][1][2][0][RTW89_UK][40] = 127,
	[0][1][2][0][RTW89_FCC][42] = 127,
	[0][1][2][0][RTW89_ETSI][42] = 127,
	[0][1][2][0][RTW89_MKK][42] = 127,
	[0][1][2][0][RTW89_IC][42] = 127,
	[0][1][2][0][RTW89_KCC][42] = 127,
	[0][1][2][0][RTW89_ACMA][42] = 127,
	[0][1][2][0][RTW89_CN][42] = 127,
	[0][1][2][0][RTW89_UK][42] = 127,
	[0][1][2][0][RTW89_FCC][44] = 127,
	[0][1][2][0][RTW89_ETSI][44] = 127,
	[0][1][2][0][RTW89_MKK][44] = 127,
	[0][1][2][0][RTW89_IC][44] = 127,
	[0][1][2][0][RTW89_KCC][44] = 127,
	[0][1][2][0][RTW89_ACMA][44] = 127,
	[0][1][2][0][RTW89_CN][44] = 127,
	[0][1][2][0][RTW89_UK][44] = 127,
	[0][1][2][0][RTW89_FCC][46] = 127,
	[0][1][2][0][RTW89_ETSI][46] = 127,
	[0][1][2][0][RTW89_MKK][46] = 127,
	[0][1][2][0][RTW89_IC][46] = 127,
	[0][1][2][0][RTW89_KCC][46] = 127,
	[0][1][2][0][RTW89_ACMA][46] = 127,
	[0][1][2][0][RTW89_CN][46] = 127,
	[0][1][2][0][RTW89_UK][46] = 127,
	[0][1][2][0][RTW89_FCC][48] = 127,
	[0][1][2][0][RTW89_ETSI][48] = 127,
	[0][1][2][0][RTW89_MKK][48] = 127,
	[0][1][2][0][RTW89_IC][48] = 127,
	[0][1][2][0][RTW89_KCC][48] = 127,
	[0][1][2][0][RTW89_ACMA][48] = 127,
	[0][1][2][0][RTW89_CN][48] = 127,
	[0][1][2][0][RTW89_UK][48] = 127,
	[0][1][2][0][RTW89_FCC][50] = 127,
	[0][1][2][0][RTW89_ETSI][50] = 127,
	[0][1][2][0][RTW89_MKK][50] = 127,
	[0][1][2][0][RTW89_IC][50] = 127,
	[0][1][2][0][RTW89_KCC][50] = 127,
	[0][1][2][0][RTW89_ACMA][50] = 127,
	[0][1][2][0][RTW89_CN][50] = 127,
	[0][1][2][0][RTW89_UK][50] = 127,
	[0][1][2][0][RTW89_FCC][52] = 127,
	[0][1][2][0][RTW89_ETSI][52] = 127,
	[0][1][2][0][RTW89_MKK][52] = 127,
	[0][1][2][0][RTW89_IC][52] = 127,
	[0][1][2][0][RTW89_KCC][52] = 127,
	[0][1][2][0][RTW89_ACMA][52] = 127,
	[0][1][2][0][RTW89_CN][52] = 127,
	[0][1][2][0][RTW89_UK][52] = 127,
	[0][1][2][1][RTW89_FCC][0] = 127,
	[0][1][2][1][RTW89_ETSI][0] = 127,
	[0][1][2][1][RTW89_MKK][0] = 127,
	[0][1][2][1][RTW89_IC][0] = 127,
	[0][1][2][1][RTW89_KCC][0] = 127,
	[0][1][2][1][RTW89_ACMA][0] = 127,
	[0][1][2][1][RTW89_CN][0] = 127,
	[0][1][2][1][RTW89_UK][0] = 127,
	[0][1][2][1][RTW89_FCC][2] = 127,
	[0][1][2][1][RTW89_ETSI][2] = 127,
	[0][1][2][1][RTW89_MKK][2] = 127,
	[0][1][2][1][RTW89_IC][2] = 127,
	[0][1][2][1][RTW89_KCC][2] = 127,
	[0][1][2][1][RTW89_ACMA][2] = 127,
	[0][1][2][1][RTW89_CN][2] = 127,
	[0][1][2][1][RTW89_UK][2] = 127,
	[0][1][2][1][RTW89_FCC][4] = 127,
	[0][1][2][1][RTW89_ETSI][4] = 127,
	[0][1][2][1][RTW89_MKK][4] = 127,
	[0][1][2][1][RTW89_IC][4] = 127,
	[0][1][2][1][RTW89_KCC][4] = 127,
	[0][1][2][1][RTW89_ACMA][4] = 127,
	[0][1][2][1][RTW89_CN][4] = 127,
	[0][1][2][1][RTW89_UK][4] = 127,
	[0][1][2][1][RTW89_FCC][6] = 127,
	[0][1][2][1][RTW89_ETSI][6] = 127,
	[0][1][2][1][RTW89_MKK][6] = 127,
	[0][1][2][1][RTW89_IC][6] = 127,
	[0][1][2][1][RTW89_KCC][6] = 127,
	[0][1][2][1][RTW89_ACMA][6] = 127,
	[0][1][2][1][RTW89_CN][6] = 127,
	[0][1][2][1][RTW89_UK][6] = 127,
	[0][1][2][1][RTW89_FCC][8] = 127,
	[0][1][2][1][RTW89_ETSI][8] = 127,
	[0][1][2][1][RTW89_MKK][8] = 127,
	[0][1][2][1][RTW89_IC][8] = 127,
	[0][1][2][1][RTW89_KCC][8] = 127,
	[0][1][2][1][RTW89_ACMA][8] = 127,
	[0][1][2][1][RTW89_CN][8] = 127,
	[0][1][2][1][RTW89_UK][8] = 127,
	[0][1][2][1][RTW89_FCC][10] = 127,
	[0][1][2][1][RTW89_ETSI][10] = 127,
	[0][1][2][1][RTW89_MKK][10] = 127,
	[0][1][2][1][RTW89_IC][10] = 127,
	[0][1][2][1][RTW89_KCC][10] = 127,
	[0][1][2][1][RTW89_ACMA][10] = 127,
	[0][1][2][1][RTW89_CN][10] = 127,
	[0][1][2][1][RTW89_UK][10] = 127,
	[0][1][2][1][RTW89_FCC][12] = 127,
	[0][1][2][1][RTW89_ETSI][12] = 127,
	[0][1][2][1][RTW89_MKK][12] = 127,
	[0][1][2][1][RTW89_IC][12] = 127,
	[0][1][2][1][RTW89_KCC][12] = 127,
	[0][1][2][1][RTW89_ACMA][12] = 127,
	[0][1][2][1][RTW89_CN][12] = 127,
	[0][1][2][1][RTW89_UK][12] = 127,
	[0][1][2][1][RTW89_FCC][14] = 127,
	[0][1][2][1][RTW89_ETSI][14] = 127,
	[0][1][2][1][RTW89_MKK][14] = 127,
	[0][1][2][1][RTW89_IC][14] = 127,
	[0][1][2][1][RTW89_KCC][14] = 127,
	[0][1][2][1][RTW89_ACMA][14] = 127,
	[0][1][2][1][RTW89_CN][14] = 127,
	[0][1][2][1][RTW89_UK][14] = 127,
	[0][1][2][1][RTW89_FCC][15] = 127,
	[0][1][2][1][RTW89_ETSI][15] = 127,
	[0][1][2][1][RTW89_MKK][15] = 127,
	[0][1][2][1][RTW89_IC][15] = 127,
	[0][1][2][1][RTW89_KCC][15] = 127,
	[0][1][2][1][RTW89_ACMA][15] = 127,
	[0][1][2][1][RTW89_CN][15] = 127,
	[0][1][2][1][RTW89_UK][15] = 127,
	[0][1][2][1][RTW89_FCC][17] = 127,
	[0][1][2][1][RTW89_ETSI][17] = 127,
	[0][1][2][1][RTW89_MKK][17] = 127,
	[0][1][2][1][RTW89_IC][17] = 127,
	[0][1][2][1][RTW89_KCC][17] = 127,
	[0][1][2][1][RTW89_ACMA][17] = 127,
	[0][1][2][1][RTW89_CN][17] = 127,
	[0][1][2][1][RTW89_UK][17] = 127,
	[0][1][2][1][RTW89_FCC][19] = 127,
	[0][1][2][1][RTW89_ETSI][19] = 127,
	[0][1][2][1][RTW89_MKK][19] = 127,
	[0][1][2][1][RTW89_IC][19] = 127,
	[0][1][2][1][RTW89_KCC][19] = 127,
	[0][1][2][1][RTW89_ACMA][19] = 127,
	[0][1][2][1][RTW89_CN][19] = 127,
	[0][1][2][1][RTW89_UK][19] = 127,
	[0][1][2][1][RTW89_FCC][21] = 127,
	[0][1][2][1][RTW89_ETSI][21] = 127,
	[0][1][2][1][RTW89_MKK][21] = 127,
	[0][1][2][1][RTW89_IC][21] = 127,
	[0][1][2][1][RTW89_KCC][21] = 127,
	[0][1][2][1][RTW89_ACMA][21] = 127,
	[0][1][2][1][RTW89_CN][21] = 127,
	[0][1][2][1][RTW89_UK][21] = 127,
	[0][1][2][1][RTW89_FCC][23] = 127,
	[0][1][2][1][RTW89_ETSI][23] = 127,
	[0][1][2][1][RTW89_MKK][23] = 127,
	[0][1][2][1][RTW89_IC][23] = 127,
	[0][1][2][1][RTW89_KCC][23] = 127,
	[0][1][2][1][RTW89_ACMA][23] = 127,
	[0][1][2][1][RTW89_CN][23] = 127,
	[0][1][2][1][RTW89_UK][23] = 127,
	[0][1][2][1][RTW89_FCC][25] = 127,
	[0][1][2][1][RTW89_ETSI][25] = 127,
	[0][1][2][1][RTW89_MKK][25] = 127,
	[0][1][2][1][RTW89_IC][25] = 127,
	[0][1][2][1][RTW89_KCC][25] = 127,
	[0][1][2][1][RTW89_ACMA][25] = 127,
	[0][1][2][1][RTW89_CN][25] = 127,
	[0][1][2][1][RTW89_UK][25] = 127,
	[0][1][2][1][RTW89_FCC][27] = 127,
	[0][1][2][1][RTW89_ETSI][27] = 127,
	[0][1][2][1][RTW89_MKK][27] = 127,
	[0][1][2][1][RTW89_IC][27] = 127,
	[0][1][2][1][RTW89_KCC][27] = 127,
	[0][1][2][1][RTW89_ACMA][27] = 127,
	[0][1][2][1][RTW89_CN][27] = 127,
	[0][1][2][1][RTW89_UK][27] = 127,
	[0][1][2][1][RTW89_FCC][29] = 127,
	[0][1][2][1][RTW89_ETSI][29] = 127,
	[0][1][2][1][RTW89_MKK][29] = 127,
	[0][1][2][1][RTW89_IC][29] = 127,
	[0][1][2][1][RTW89_KCC][29] = 127,
	[0][1][2][1][RTW89_ACMA][29] = 127,
	[0][1][2][1][RTW89_CN][29] = 127,
	[0][1][2][1][RTW89_UK][29] = 127,
	[0][1][2][1][RTW89_FCC][31] = 127,
	[0][1][2][1][RTW89_ETSI][31] = 127,
	[0][1][2][1][RTW89_MKK][31] = 127,
	[0][1][2][1][RTW89_IC][31] = 127,
	[0][1][2][1][RTW89_KCC][31] = 127,
	[0][1][2][1][RTW89_ACMA][31] = 127,
	[0][1][2][1][RTW89_CN][31] = 127,
	[0][1][2][1][RTW89_UK][31] = 127,
	[0][1][2][1][RTW89_FCC][33] = 127,
	[0][1][2][1][RTW89_ETSI][33] = 127,
	[0][1][2][1][RTW89_MKK][33] = 127,
	[0][1][2][1][RTW89_IC][33] = 127,
	[0][1][2][1][RTW89_KCC][33] = 127,
	[0][1][2][1][RTW89_ACMA][33] = 127,
	[0][1][2][1][RTW89_CN][33] = 127,
	[0][1][2][1][RTW89_UK][33] = 127,
	[0][1][2][1][RTW89_FCC][35] = 127,
	[0][1][2][1][RTW89_ETSI][35] = 127,
	[0][1][2][1][RTW89_MKK][35] = 127,
	[0][1][2][1][RTW89_IC][35] = 127,
	[0][1][2][1][RTW89_KCC][35] = 127,
	[0][1][2][1][RTW89_ACMA][35] = 127,
	[0][1][2][1][RTW89_CN][35] = 127,
	[0][1][2][1][RTW89_UK][35] = 127,
	[0][1][2][1][RTW89_FCC][37] = 127,
	[0][1][2][1][RTW89_ETSI][37] = 127,
	[0][1][2][1][RTW89_MKK][37] = 127,
	[0][1][2][1][RTW89_IC][37] = 127,
	[0][1][2][1][RTW89_KCC][37] = 127,
	[0][1][2][1][RTW89_ACMA][37] = 127,
	[0][1][2][1][RTW89_CN][37] = 127,
	[0][1][2][1][RTW89_UK][37] = 127,
	[0][1][2][1][RTW89_FCC][38] = 127,
	[0][1][2][1][RTW89_ETSI][38] = 127,
	[0][1][2][1][RTW89_MKK][38] = 127,
	[0][1][2][1][RTW89_IC][38] = 127,
	[0][1][2][1][RTW89_KCC][38] = 127,
	[0][1][2][1][RTW89_ACMA][38] = 127,
	[0][1][2][1][RTW89_CN][38] = 127,
	[0][1][2][1][RTW89_UK][38] = 127,
	[0][1][2][1][RTW89_FCC][40] = 127,
	[0][1][2][1][RTW89_ETSI][40] = 127,
	[0][1][2][1][RTW89_MKK][40] = 127,
	[0][1][2][1][RTW89_IC][40] = 127,
	[0][1][2][1][RTW89_KCC][40] = 127,
	[0][1][2][1][RTW89_ACMA][40] = 127,
	[0][1][2][1][RTW89_CN][40] = 127,
	[0][1][2][1][RTW89_UK][40] = 127,
	[0][1][2][1][RTW89_FCC][42] = 127,
	[0][1][2][1][RTW89_ETSI][42] = 127,
	[0][1][2][1][RTW89_MKK][42] = 127,
	[0][1][2][1][RTW89_IC][42] = 127,
	[0][1][2][1][RTW89_KCC][42] = 127,
	[0][1][2][1][RTW89_ACMA][42] = 127,
	[0][1][2][1][RTW89_CN][42] = 127,
	[0][1][2][1][RTW89_UK][42] = 127,
	[0][1][2][1][RTW89_FCC][44] = 127,
	[0][1][2][1][RTW89_ETSI][44] = 127,
	[0][1][2][1][RTW89_MKK][44] = 127,
	[0][1][2][1][RTW89_IC][44] = 127,
	[0][1][2][1][RTW89_KCC][44] = 127,
	[0][1][2][1][RTW89_ACMA][44] = 127,
	[0][1][2][1][RTW89_CN][44] = 127,
	[0][1][2][1][RTW89_UK][44] = 127,
	[0][1][2][1][RTW89_FCC][46] = 127,
	[0][1][2][1][RTW89_ETSI][46] = 127,
	[0][1][2][1][RTW89_MKK][46] = 127,
	[0][1][2][1][RTW89_IC][46] = 127,
	[0][1][2][1][RTW89_KCC][46] = 127,
	[0][1][2][1][RTW89_ACMA][46] = 127,
	[0][1][2][1][RTW89_CN][46] = 127,
	[0][1][2][1][RTW89_UK][46] = 127,
	[0][1][2][1][RTW89_FCC][48] = 127,
	[0][1][2][1][RTW89_ETSI][48] = 127,
	[0][1][2][1][RTW89_MKK][48] = 127,
	[0][1][2][1][RTW89_IC][48] = 127,
	[0][1][2][1][RTW89_KCC][48] = 127,
	[0][1][2][1][RTW89_ACMA][48] = 127,
	[0][1][2][1][RTW89_CN][48] = 127,
	[0][1][2][1][RTW89_UK][48] = 127,
	[0][1][2][1][RTW89_FCC][50] = 127,
	[0][1][2][1][RTW89_ETSI][50] = 127,
	[0][1][2][1][RTW89_MKK][50] = 127,
	[0][1][2][1][RTW89_IC][50] = 127,
	[0][1][2][1][RTW89_KCC][50] = 127,
	[0][1][2][1][RTW89_ACMA][50] = 127,
	[0][1][2][1][RTW89_CN][50] = 127,
	[0][1][2][1][RTW89_UK][50] = 127,
	[0][1][2][1][RTW89_FCC][52] = 127,
	[0][1][2][1][RTW89_ETSI][52] = 127,
	[0][1][2][1][RTW89_MKK][52] = 127,
	[0][1][2][1][RTW89_IC][52] = 127,
	[0][1][2][1][RTW89_KCC][52] = 127,
	[0][1][2][1][RTW89_ACMA][52] = 127,
	[0][1][2][1][RTW89_CN][52] = 127,
	[0][1][2][1][RTW89_UK][52] = 127,
	[1][0][2][0][RTW89_FCC][1] = 66,
	[1][0][2][0][RTW89_ETSI][1] = 64,
	[1][0][2][0][RTW89_MKK][1] = 64,
	[1][0][2][0][RTW89_IC][1] = 64,
	[1][0][2][0][RTW89_KCC][1] = 74,
	[1][0][2][0][RTW89_ACMA][1] = 64,
	[1][0][2][0][RTW89_CN][1] = 66,
	[1][0][2][0][RTW89_UK][1] = 64,
	[1][0][2][0][RTW89_FCC][5] = 80,
	[1][0][2][0][RTW89_ETSI][5] = 64,
	[1][0][2][0][RTW89_MKK][5] = 62,
	[1][0][2][0][RTW89_IC][5] = 64,
	[1][0][2][0][RTW89_KCC][5] = 66,
	[1][0][2][0][RTW89_ACMA][5] = 64,
	[1][0][2][0][RTW89_CN][5] = 66,
	[1][0][2][0][RTW89_UK][5] = 64,
	[1][0][2][0][RTW89_FCC][9] = 80,
	[1][0][2][0][RTW89_ETSI][9] = 64,
	[1][0][2][0][RTW89_MKK][9] = 64,
	[1][0][2][0][RTW89_IC][9] = 64,
	[1][0][2][0][RTW89_KCC][9] = 76,
	[1][0][2][0][RTW89_ACMA][9] = 64,
	[1][0][2][0][RTW89_CN][9] = 58,
	[1][0][2][0][RTW89_UK][9] = 64,
	[1][0][2][0][RTW89_FCC][13] = 64,
	[1][0][2][0][RTW89_ETSI][13] = 64,
	[1][0][2][0][RTW89_MKK][13] = 64,
	[1][0][2][0][RTW89_IC][13] = 64,
	[1][0][2][0][RTW89_KCC][13] = 72,
	[1][0][2][0][RTW89_ACMA][13] = 64,
	[1][0][2][0][RTW89_CN][13] = 58,
	[1][0][2][0][RTW89_UK][13] = 64,
	[1][0][2][0][RTW89_FCC][16] = 66,
	[1][0][2][0][RTW89_ETSI][16] = 66,
	[1][0][2][0][RTW89_MKK][16] = 76,
	[1][0][2][0][RTW89_IC][16] = 66,
	[1][0][2][0][RTW89_KCC][16] = 74,
	[1][0][2][0][RTW89_ACMA][16] = 66,
	[1][0][2][0][RTW89_CN][16] = 127,
	[1][0][2][0][RTW89_UK][16] = 66,
	[1][0][2][0][RTW89_FCC][20] = 80,
	[1][0][2][0][RTW89_ETSI][20] = 66,
	[1][0][2][0][RTW89_MKK][20] = 76,
	[1][0][2][0][RTW89_IC][20] = 80,
	[1][0][2][0][RTW89_KCC][20] = 74,
	[1][0][2][0][RTW89_ACMA][20] = 66,
	[1][0][2][0][RTW89_CN][20] = 127,
	[1][0][2][0][RTW89_UK][20] = 66,
	[1][0][2][0][RTW89_FCC][24] = 80,
	[1][0][2][0][RTW89_ETSI][24] = 66,
	[1][0][2][0][RTW89_MKK][24] = 76,
	[1][0][2][0][RTW89_IC][24] = 127,
	[1][0][2][0][RTW89_KCC][24] = 74,
	[1][0][2][0][RTW89_ACMA][24] = 127,
	[1][0][2][0][RTW89_CN][24] = 127,
	[1][0][2][0][RTW89_UK][24] = 66,
	[1][0][2][0][RTW89_FCC][28] = 80,
	[1][0][2][0][RTW89_ETSI][28] = 66,
	[1][0][2][0][RTW89_MKK][28] = 76,
	[1][0][2][0][RTW89_IC][28] = 127,
	[1][0][2][0][RTW89_KCC][28] = 74,
	[1][0][2][0][RTW89_ACMA][28] = 127,
	[1][0][2][0][RTW89_CN][28] = 127,
	[1][0][2][0][RTW89_UK][28] = 66,
	[1][0][2][0][RTW89_FCC][32] = 74,
	[1][0][2][0][RTW89_ETSI][32] = 66,
	[1][0][2][0][RTW89_MKK][32] = 76,
	[1][0][2][0][RTW89_IC][32] = 74,
	[1][0][2][0][RTW89_KCC][32] = 76,
	[1][0][2][0][RTW89_ACMA][32] = 66,
	[1][0][2][0][RTW89_CN][32] = 127,
	[1][0][2][0][RTW89_UK][32] = 66,
	[1][0][2][0][RTW89_FCC][36] = 78,
	[1][0][2][0][RTW89_ETSI][36] = 127,
	[1][0][2][0][RTW89_MKK][36] = 76,
	[1][0][2][0][RTW89_IC][36] = 78,
	[1][0][2][0][RTW89_KCC][36] = 76,
	[1][0][2][0][RTW89_ACMA][36] = 76,
	[1][0][2][0][RTW89_CN][36] = 127,
	[1][0][2][0][RTW89_UK][36] = 76,
	[1][0][2][0][RTW89_FCC][39] = 80,
	[1][0][2][0][RTW89_ETSI][39] = 30,
	[1][0][2][0][RTW89_MKK][39] = 127,
	[1][0][2][0][RTW89_IC][39] = 80,
	[1][0][2][0][RTW89_KCC][39] = 68,
	[1][0][2][0][RTW89_ACMA][39] = 76,
	[1][0][2][0][RTW89_CN][39] = 56,
	[1][0][2][0][RTW89_UK][39] = 64,
	[1][0][2][0][RTW89_FCC][43] = 80,
	[1][0][2][0][RTW89_ETSI][43] = 30,
	[1][0][2][0][RTW89_MKK][43] = 127,
	[1][0][2][0][RTW89_IC][43] = 80,
	[1][0][2][0][RTW89_KCC][43] = 76,
	[1][0][2][0][RTW89_ACMA][43] = 76,
	[1][0][2][0][RTW89_CN][43] = 64,
	[1][0][2][0][RTW89_UK][43] = 64,
	[1][0][2][0][RTW89_FCC][47] = 80,
	[1][0][2][0][RTW89_ETSI][47] = 127,
	[1][0][2][0][RTW89_MKK][47] = 127,
	[1][0][2][0][RTW89_IC][47] = 127,
	[1][0][2][0][RTW89_KCC][47] = 127,
	[1][0][2][0][RTW89_ACMA][47] = 127,
	[1][0][2][0][RTW89_CN][47] = 127,
	[1][0][2][0][RTW89_UK][47] = 127,
	[1][0][2][0][RTW89_FCC][51] = 80,
	[1][0][2][0][RTW89_ETSI][51] = 127,
	[1][0][2][0][RTW89_MKK][51] = 127,
	[1][0][2][0][RTW89_IC][51] = 127,
	[1][0][2][0][RTW89_KCC][51] = 127,
	[1][0][2][0][RTW89_ACMA][51] = 127,
	[1][0][2][0][RTW89_CN][51] = 127,
	[1][0][2][0][RTW89_UK][51] = 127,
	[1][1][2][0][RTW89_FCC][1] = 127,
	[1][1][2][0][RTW89_ETSI][1] = 127,
	[1][1][2][0][RTW89_MKK][1] = 127,
	[1][1][2][0][RTW89_IC][1] = 127,
	[1][1][2][0][RTW89_KCC][1] = 127,
	[1][1][2][0][RTW89_ACMA][1] = 127,
	[1][1][2][0][RTW89_CN][1] = 127,
	[1][1][2][0][RTW89_UK][1] = 127,
	[1][1][2][0][RTW89_FCC][5] = 127,
	[1][1][2][0][RTW89_ETSI][5] = 127,
	[1][1][2][0][RTW89_MKK][5] = 127,
	[1][1][2][0][RTW89_IC][5] = 127,
	[1][1][2][0][RTW89_KCC][5] = 127,
	[1][1][2][0][RTW89_ACMA][5] = 127,
	[1][1][2][0][RTW89_CN][5] = 127,
	[1][1][2][0][RTW89_UK][5] = 127,
	[1][1][2][0][RTW89_FCC][9] = 127,
	[1][1][2][0][RTW89_ETSI][9] = 127,
	[1][1][2][0][RTW89_MKK][9] = 127,
	[1][1][2][0][RTW89_IC][9] = 127,
	[1][1][2][0][RTW89_KCC][9] = 127,
	[1][1][2][0][RTW89_ACMA][9] = 127,
	[1][1][2][0][RTW89_CN][9] = 127,
	[1][1][2][0][RTW89_UK][9] = 127,
	[1][1][2][0][RTW89_FCC][13] = 127,
	[1][1][2][0][RTW89_ETSI][13] = 127,
	[1][1][2][0][RTW89_MKK][13] = 127,
	[1][1][2][0][RTW89_IC][13] = 127,
	[1][1][2][0][RTW89_KCC][13] = 127,
	[1][1][2][0][RTW89_ACMA][13] = 127,
	[1][1][2][0][RTW89_CN][13] = 127,
	[1][1][2][0][RTW89_UK][13] = 127,
	[1][1][2][0][RTW89_FCC][16] = 127,
	[1][1][2][0][RTW89_ETSI][16] = 127,
	[1][1][2][0][RTW89_MKK][16] = 127,
	[1][1][2][0][RTW89_IC][16] = 127,
	[1][1][2][0][RTW89_KCC][16] = 127,
	[1][1][2][0][RTW89_ACMA][16] = 127,
	[1][1][2][0][RTW89_CN][16] = 127,
	[1][1][2][0][RTW89_UK][16] = 127,
	[1][1][2][0][RTW89_FCC][20] = 127,
	[1][1][2][0][RTW89_ETSI][20] = 127,
	[1][1][2][0][RTW89_MKK][20] = 127,
	[1][1][2][0][RTW89_IC][20] = 127,
	[1][1][2][0][RTW89_KCC][20] = 127,
	[1][1][2][0][RTW89_ACMA][20] = 127,
	[1][1][2][0][RTW89_CN][20] = 127,
	[1][1][2][0][RTW89_UK][20] = 127,
	[1][1][2][0][RTW89_FCC][24] = 127,
	[1][1][2][0][RTW89_ETSI][24] = 127,
	[1][1][2][0][RTW89_MKK][24] = 127,
	[1][1][2][0][RTW89_IC][24] = 127,
	[1][1][2][0][RTW89_KCC][24] = 127,
	[1][1][2][0][RTW89_ACMA][24] = 127,
	[1][1][2][0][RTW89_CN][24] = 127,
	[1][1][2][0][RTW89_UK][24] = 127,
	[1][1][2][0][RTW89_FCC][28] = 127,
	[1][1][2][0][RTW89_ETSI][28] = 127,
	[1][1][2][0][RTW89_MKK][28] = 127,
	[1][1][2][0][RTW89_IC][28] = 127,
	[1][1][2][0][RTW89_KCC][28] = 127,
	[1][1][2][0][RTW89_ACMA][28] = 127,
	[1][1][2][0][RTW89_CN][28] = 127,
	[1][1][2][0][RTW89_UK][28] = 127,
	[1][1][2][0][RTW89_FCC][32] = 127,
	[1][1][2][0][RTW89_ETSI][32] = 127,
	[1][1][2][0][RTW89_MKK][32] = 127,
	[1][1][2][0][RTW89_IC][32] = 127,
	[1][1][2][0][RTW89_KCC][32] = 127,
	[1][1][2][0][RTW89_ACMA][32] = 127,
	[1][1][2][0][RTW89_CN][32] = 127,
	[1][1][2][0][RTW89_UK][32] = 127,
	[1][1][2][0][RTW89_FCC][36] = 127,
	[1][1][2][0][RTW89_ETSI][36] = 127,
	[1][1][2][0][RTW89_MKK][36] = 127,
	[1][1][2][0][RTW89_IC][36] = 127,
	[1][1][2][0][RTW89_KCC][36] = 127,
	[1][1][2][0][RTW89_ACMA][36] = 127,
	[1][1][2][0][RTW89_CN][36] = 127,
	[1][1][2][0][RTW89_UK][36] = 127,
	[1][1][2][0][RTW89_FCC][39] = 127,
	[1][1][2][0][RTW89_ETSI][39] = 127,
	[1][1][2][0][RTW89_MKK][39] = 127,
	[1][1][2][0][RTW89_IC][39] = 127,
	[1][1][2][0][RTW89_KCC][39] = 127,
	[1][1][2][0][RTW89_ACMA][39] = 127,
	[1][1][2][0][RTW89_CN][39] = 127,
	[1][1][2][0][RTW89_UK][39] = 127,
	[1][1][2][0][RTW89_FCC][43] = 127,
	[1][1][2][0][RTW89_ETSI][43] = 127,
	[1][1][2][0][RTW89_MKK][43] = 127,
	[1][1][2][0][RTW89_IC][43] = 127,
	[1][1][2][0][RTW89_KCC][43] = 127,
	[1][1][2][0][RTW89_ACMA][43] = 127,
	[1][1][2][0][RTW89_CN][43] = 127,
	[1][1][2][0][RTW89_UK][43] = 127,
	[1][1][2][0][RTW89_FCC][47] = 127,
	[1][1][2][0][RTW89_ETSI][47] = 127,
	[1][1][2][0][RTW89_MKK][47] = 127,
	[1][1][2][0][RTW89_IC][47] = 127,
	[1][1][2][0][RTW89_KCC][47] = 127,
	[1][1][2][0][RTW89_ACMA][47] = 127,
	[1][1][2][0][RTW89_CN][47] = 127,
	[1][1][2][0][RTW89_UK][47] = 127,
	[1][1][2][0][RTW89_FCC][51] = 127,
	[1][1][2][0][RTW89_ETSI][51] = 127,
	[1][1][2][0][RTW89_MKK][51] = 127,
	[1][1][2][0][RTW89_IC][51] = 127,
	[1][1][2][0][RTW89_KCC][51] = 127,
	[1][1][2][0][RTW89_ACMA][51] = 127,
	[1][1][2][0][RTW89_CN][51] = 127,
	[1][1][2][0][RTW89_UK][51] = 127,
	[1][1][2][1][RTW89_FCC][1] = 127,
	[1][1][2][1][RTW89_ETSI][1] = 127,
	[1][1][2][1][RTW89_MKK][1] = 127,
	[1][1][2][1][RTW89_IC][1] = 127,
	[1][1][2][1][RTW89_KCC][1] = 127,
	[1][1][2][1][RTW89_ACMA][1] = 127,
	[1][1][2][1][RTW89_CN][1] = 127,
	[1][1][2][1][RTW89_UK][1] = 127,
	[1][1][2][1][RTW89_FCC][5] = 127,
	[1][1][2][1][RTW89_ETSI][5] = 127,
	[1][1][2][1][RTW89_MKK][5] = 127,
	[1][1][2][1][RTW89_IC][5] = 127,
	[1][1][2][1][RTW89_KCC][5] = 127,
	[1][1][2][1][RTW89_ACMA][5] = 127,
	[1][1][2][1][RTW89_CN][5] = 127,
	[1][1][2][1][RTW89_UK][5] = 127,
	[1][1][2][1][RTW89_FCC][9] = 127,
	[1][1][2][1][RTW89_ETSI][9] = 127,
	[1][1][2][1][RTW89_MKK][9] = 127,
	[1][1][2][1][RTW89_IC][9] = 127,
	[1][1][2][1][RTW89_KCC][9] = 127,
	[1][1][2][1][RTW89_ACMA][9] = 127,
	[1][1][2][1][RTW89_CN][9] = 127,
	[1][1][2][1][RTW89_UK][9] = 127,
	[1][1][2][1][RTW89_FCC][13] = 127,
	[1][1][2][1][RTW89_ETSI][13] = 127,
	[1][1][2][1][RTW89_MKK][13] = 127,
	[1][1][2][1][RTW89_IC][13] = 127,
	[1][1][2][1][RTW89_KCC][13] = 127,
	[1][1][2][1][RTW89_ACMA][13] = 127,
	[1][1][2][1][RTW89_CN][13] = 127,
	[1][1][2][1][RTW89_UK][13] = 127,
	[1][1][2][1][RTW89_FCC][16] = 127,
	[1][1][2][1][RTW89_ETSI][16] = 127,
	[1][1][2][1][RTW89_MKK][16] = 127,
	[1][1][2][1][RTW89_IC][16] = 127,
	[1][1][2][1][RTW89_KCC][16] = 127,
	[1][1][2][1][RTW89_ACMA][16] = 127,
	[1][1][2][1][RTW89_CN][16] = 127,
	[1][1][2][1][RTW89_UK][16] = 127,
	[1][1][2][1][RTW89_FCC][20] = 127,
	[1][1][2][1][RTW89_ETSI][20] = 127,
	[1][1][2][1][RTW89_MKK][20] = 127,
	[1][1][2][1][RTW89_IC][20] = 127,
	[1][1][2][1][RTW89_KCC][20] = 127,
	[1][1][2][1][RTW89_ACMA][20] = 127,
	[1][1][2][1][RTW89_CN][20] = 127,
	[1][1][2][1][RTW89_UK][20] = 127,
	[1][1][2][1][RTW89_FCC][24] = 127,
	[1][1][2][1][RTW89_ETSI][24] = 127,
	[1][1][2][1][RTW89_MKK][24] = 127,
	[1][1][2][1][RTW89_IC][24] = 127,
	[1][1][2][1][RTW89_KCC][24] = 127,
	[1][1][2][1][RTW89_ACMA][24] = 127,
	[1][1][2][1][RTW89_CN][24] = 127,
	[1][1][2][1][RTW89_UK][24] = 127,
	[1][1][2][1][RTW89_FCC][28] = 127,
	[1][1][2][1][RTW89_ETSI][28] = 127,
	[1][1][2][1][RTW89_MKK][28] = 127,
	[1][1][2][1][RTW89_IC][28] = 127,
	[1][1][2][1][RTW89_KCC][28] = 127,
	[1][1][2][1][RTW89_ACMA][28] = 127,
	[1][1][2][1][RTW89_CN][28] = 127,
	[1][1][2][1][RTW89_UK][28] = 127,
	[1][1][2][1][RTW89_FCC][32] = 127,
	[1][1][2][1][RTW89_ETSI][32] = 127,
	[1][1][2][1][RTW89_MKK][32] = 127,
	[1][1][2][1][RTW89_IC][32] = 127,
	[1][1][2][1][RTW89_KCC][32] = 127,
	[1][1][2][1][RTW89_ACMA][32] = 127,
	[1][1][2][1][RTW89_CN][32] = 127,
	[1][1][2][1][RTW89_UK][32] = 127,
	[1][1][2][1][RTW89_FCC][36] = 127,
	[1][1][2][1][RTW89_ETSI][36] = 127,
	[1][1][2][1][RTW89_MKK][36] = 127,
	[1][1][2][1][RTW89_IC][36] = 127,
	[1][1][2][1][RTW89_KCC][36] = 127,
	[1][1][2][1][RTW89_ACMA][36] = 127,
	[1][1][2][1][RTW89_CN][36] = 127,
	[1][1][2][1][RTW89_UK][36] = 127,
	[1][1][2][1][RTW89_FCC][39] = 127,
	[1][1][2][1][RTW89_ETSI][39] = 127,
	[1][1][2][1][RTW89_MKK][39] = 127,
	[1][1][2][1][RTW89_IC][39] = 127,
	[1][1][2][1][RTW89_KCC][39] = 127,
	[1][1][2][1][RTW89_ACMA][39] = 127,
	[1][1][2][1][RTW89_CN][39] = 127,
	[1][1][2][1][RTW89_UK][39] = 127,
	[1][1][2][1][RTW89_FCC][43] = 127,
	[1][1][2][1][RTW89_ETSI][43] = 127,
	[1][1][2][1][RTW89_MKK][43] = 127,
	[1][1][2][1][RTW89_IC][43] = 127,
	[1][1][2][1][RTW89_KCC][43] = 127,
	[1][1][2][1][RTW89_ACMA][43] = 127,
	[1][1][2][1][RTW89_CN][43] = 127,
	[1][1][2][1][RTW89_UK][43] = 127,
	[1][1][2][1][RTW89_FCC][47] = 127,
	[1][1][2][1][RTW89_ETSI][47] = 127,
	[1][1][2][1][RTW89_MKK][47] = 127,
	[1][1][2][1][RTW89_IC][47] = 127,
	[1][1][2][1][RTW89_KCC][47] = 127,
	[1][1][2][1][RTW89_ACMA][47] = 127,
	[1][1][2][1][RTW89_CN][47] = 127,
	[1][1][2][1][RTW89_UK][47] = 127,
	[1][1][2][1][RTW89_FCC][51] = 127,
	[1][1][2][1][RTW89_ETSI][51] = 127,
	[1][1][2][1][RTW89_MKK][51] = 127,
	[1][1][2][1][RTW89_IC][51] = 127,
	[1][1][2][1][RTW89_KCC][51] = 127,
	[1][1][2][1][RTW89_ACMA][51] = 127,
	[1][1][2][1][RTW89_CN][51] = 127,
	[1][1][2][1][RTW89_UK][51] = 127,
	[2][0][2][0][RTW89_FCC][3] = 72,
	[2][0][2][0][RTW89_ETSI][3] = 64,
	[2][0][2][0][RTW89_MKK][3] = 62,
	[2][0][2][0][RTW89_IC][3] = 64,
	[2][0][2][0][RTW89_KCC][3] = 68,
	[2][0][2][0][RTW89_ACMA][3] = 64,
	[2][0][2][0][RTW89_CN][3] = 60,
	[2][0][2][0][RTW89_UK][3] = 64,
	[2][0][2][0][RTW89_FCC][11] = 62,
	[2][0][2][0][RTW89_ETSI][11] = 64,
	[2][0][2][0][RTW89_MKK][11] = 64,
	[2][0][2][0][RTW89_IC][11] = 62,
	[2][0][2][0][RTW89_KCC][11] = 68,
	[2][0][2][0][RTW89_ACMA][11] = 64,
	[2][0][2][0][RTW89_CN][11] = 54,
	[2][0][2][0][RTW89_UK][11] = 64,
	[2][0][2][0][RTW89_FCC][18] = 66,
	[2][0][2][0][RTW89_ETSI][18] = 64,
	[2][0][2][0][RTW89_MKK][18] = 68,
	[2][0][2][0][RTW89_IC][18] = 66,
	[2][0][2][0][RTW89_KCC][18] = 68,
	[2][0][2][0][RTW89_ACMA][18] = 64,
	[2][0][2][0][RTW89_CN][18] = 127,
	[2][0][2][0][RTW89_UK][18] = 64,
	[2][0][2][0][RTW89_FCC][26] = 72,
	[2][0][2][0][RTW89_ETSI][26] = 64,
	[2][0][2][0][RTW89_MKK][26] = 68,
	[2][0][2][0][RTW89_IC][26] = 127,
	[2][0][2][0][RTW89_KCC][26] = 68,
	[2][0][2][0][RTW89_ACMA][26] = 127,
	[2][0][2][0][RTW89_CN][26] = 127,
	[2][0][2][0][RTW89_UK][26] = 64,
	[2][0][2][0][RTW89_FCC][34] = 72,
	[2][0][2][0][RTW89_ETSI][34] = 127,
	[2][0][2][0][RTW89_MKK][34] = 68,
	[2][0][2][0][RTW89_IC][34] = 72,
	[2][0][2][0][RTW89_KCC][34] = 68,
	[2][0][2][0][RTW89_ACMA][34] = 68,
	[2][0][2][0][RTW89_CN][34] = 127,
	[2][0][2][0][RTW89_UK][34] = 68,
	[2][0][2][0][RTW89_FCC][41] = 72,
	[2][0][2][0][RTW89_ETSI][41] = 30,
	[2][0][2][0][RTW89_MKK][41] = 127,
	[2][0][2][0][RTW89_IC][41] = 72,
	[2][0][2][0][RTW89_KCC][41] = 64,
	[2][0][2][0][RTW89_ACMA][41] = 68,
	[2][0][2][0][RTW89_CN][41] = 38,
	[2][0][2][0][RTW89_UK][41] = 64,
	[2][0][2][0][RTW89_FCC][49] = 72,
	[2][0][2][0][RTW89_ETSI][49] = 127,
	[2][0][2][0][RTW89_MKK][49] = 127,
	[2][0][2][0][RTW89_IC][49] = 127,
	[2][0][2][0][RTW89_KCC][49] = 127,
	[2][0][2][0][RTW89_ACMA][49] = 127,
	[2][0][2][0][RTW89_CN][49] = 127,
	[2][0][2][0][RTW89_UK][49] = 127,
	[2][1][2][0][RTW89_FCC][3] = 127,
	[2][1][2][0][RTW89_ETSI][3] = 127,
	[2][1][2][0][RTW89_MKK][3] = 127,
	[2][1][2][0][RTW89_IC][3] = 127,
	[2][1][2][0][RTW89_KCC][3] = 127,
	[2][1][2][0][RTW89_ACMA][3] = 127,
	[2][1][2][0][RTW89_CN][3] = 127,
	[2][1][2][0][RTW89_UK][3] = 127,
	[2][1][2][0][RTW89_FCC][11] = 127,
	[2][1][2][0][RTW89_ETSI][11] = 127,
	[2][1][2][0][RTW89_MKK][11] = 127,
	[2][1][2][0][RTW89_IC][11] = 127,
	[2][1][2][0][RTW89_KCC][11] = 127,
	[2][1][2][0][RTW89_ACMA][11] = 127,
	[2][1][2][0][RTW89_CN][11] = 127,
	[2][1][2][0][RTW89_UK][11] = 127,
	[2][1][2][0][RTW89_FCC][18] = 127,
	[2][1][2][0][RTW89_ETSI][18] = 127,
	[2][1][2][0][RTW89_MKK][18] = 127,
	[2][1][2][0][RTW89_IC][18] = 127,
	[2][1][2][0][RTW89_KCC][18] = 127,
	[2][1][2][0][RTW89_ACMA][18] = 127,
	[2][1][2][0][RTW89_CN][18] = 127,
	[2][1][2][0][RTW89_UK][18] = 127,
	[2][1][2][0][RTW89_FCC][26] = 127,
	[2][1][2][0][RTW89_ETSI][26] = 127,
	[2][1][2][0][RTW89_MKK][26] = 127,
	[2][1][2][0][RTW89_IC][26] = 127,
	[2][1][2][0][RTW89_KCC][26] = 127,
	[2][1][2][0][RTW89_ACMA][26] = 127,
	[2][1][2][0][RTW89_CN][26] = 127,
	[2][1][2][0][RTW89_UK][26] = 127,
	[2][1][2][0][RTW89_FCC][34] = 127,
	[2][1][2][0][RTW89_ETSI][34] = 127,
	[2][1][2][0][RTW89_MKK][34] = 127,
	[2][1][2][0][RTW89_IC][34] = 127,
	[2][1][2][0][RTW89_KCC][34] = 127,
	[2][1][2][0][RTW89_ACMA][34] = 127,
	[2][1][2][0][RTW89_CN][34] = 127,
	[2][1][2][0][RTW89_UK][34] = 127,
	[2][1][2][0][RTW89_FCC][41] = 127,
	[2][1][2][0][RTW89_ETSI][41] = 127,
	[2][1][2][0][RTW89_MKK][41] = 127,
	[2][1][2][0][RTW89_IC][41] = 127,
	[2][1][2][0][RTW89_KCC][41] = 127,
	[2][1][2][0][RTW89_ACMA][41] = 127,
	[2][1][2][0][RTW89_CN][41] = 127,
	[2][1][2][0][RTW89_UK][41] = 127,
	[2][1][2][0][RTW89_FCC][49] = 127,
	[2][1][2][0][RTW89_ETSI][49] = 127,
	[2][1][2][0][RTW89_MKK][49] = 127,
	[2][1][2][0][RTW89_IC][49] = 127,
	[2][1][2][0][RTW89_KCC][49] = 127,
	[2][1][2][0][RTW89_ACMA][49] = 127,
	[2][1][2][0][RTW89_CN][49] = 127,
	[2][1][2][0][RTW89_UK][49] = 127,
	[2][1][2][1][RTW89_FCC][3] = 127,
	[2][1][2][1][RTW89_ETSI][3] = 127,
	[2][1][2][1][RTW89_MKK][3] = 127,
	[2][1][2][1][RTW89_IC][3] = 127,
	[2][1][2][1][RTW89_KCC][3] = 127,
	[2][1][2][1][RTW89_ACMA][3] = 127,
	[2][1][2][1][RTW89_CN][3] = 127,
	[2][1][2][1][RTW89_UK][3] = 127,
	[2][1][2][1][RTW89_FCC][11] = 127,
	[2][1][2][1][RTW89_ETSI][11] = 127,
	[2][1][2][1][RTW89_MKK][11] = 127,
	[2][1][2][1][RTW89_IC][11] = 127,
	[2][1][2][1][RTW89_KCC][11] = 127,
	[2][1][2][1][RTW89_ACMA][11] = 127,
	[2][1][2][1][RTW89_CN][11] = 127,
	[2][1][2][1][RTW89_UK][11] = 127,
	[2][1][2][1][RTW89_FCC][18] = 127,
	[2][1][2][1][RTW89_ETSI][18] = 127,
	[2][1][2][1][RTW89_MKK][18] = 127,
	[2][1][2][1][RTW89_IC][18] = 127,
	[2][1][2][1][RTW89_KCC][18] = 127,
	[2][1][2][1][RTW89_ACMA][18] = 127,
	[2][1][2][1][RTW89_CN][18] = 127,
	[2][1][2][1][RTW89_UK][18] = 127,
	[2][1][2][1][RTW89_FCC][26] = 127,
	[2][1][2][1][RTW89_ETSI][26] = 127,
	[2][1][2][1][RTW89_MKK][26] = 127,
	[2][1][2][1][RTW89_IC][26] = 127,
	[2][1][2][1][RTW89_KCC][26] = 127,
	[2][1][2][1][RTW89_ACMA][26] = 127,
	[2][1][2][1][RTW89_CN][26] = 127,
	[2][1][2][1][RTW89_UK][26] = 127,
	[2][1][2][1][RTW89_FCC][34] = 127,
	[2][1][2][1][RTW89_ETSI][34] = 127,
	[2][1][2][1][RTW89_MKK][34] = 127,
	[2][1][2][1][RTW89_IC][34] = 127,
	[2][1][2][1][RTW89_KCC][34] = 127,
	[2][1][2][1][RTW89_ACMA][34] = 127,
	[2][1][2][1][RTW89_CN][34] = 127,
	[2][1][2][1][RTW89_UK][34] = 127,
	[2][1][2][1][RTW89_FCC][41] = 127,
	[2][1][2][1][RTW89_ETSI][41] = 127,
	[2][1][2][1][RTW89_MKK][41] = 127,
	[2][1][2][1][RTW89_IC][41] = 127,
	[2][1][2][1][RTW89_KCC][41] = 127,
	[2][1][2][1][RTW89_ACMA][41] = 127,
	[2][1][2][1][RTW89_CN][41] = 127,
	[2][1][2][1][RTW89_UK][41] = 127,
	[2][1][2][1][RTW89_FCC][49] = 127,
	[2][1][2][1][RTW89_ETSI][49] = 127,
	[2][1][2][1][RTW89_MKK][49] = 127,
	[2][1][2][1][RTW89_IC][49] = 127,
	[2][1][2][1][RTW89_KCC][49] = 127,
	[2][1][2][1][RTW89_ACMA][49] = 127,
	[2][1][2][1][RTW89_CN][49] = 127,
	[2][1][2][1][RTW89_UK][49] = 127,
	[3][0][2][0][RTW89_FCC][7] = 127,
	[3][0][2][0][RTW89_ETSI][7] = 127,
	[3][0][2][0][RTW89_MKK][7] = 127,
	[3][0][2][0][RTW89_IC][7] = 127,
	[3][0][2][0][RTW89_KCC][7] = 127,
	[3][0][2][0][RTW89_ACMA][7] = 127,
	[3][0][2][0][RTW89_CN][7] = 127,
	[3][0][2][0][RTW89_UK][7] = 127,
	[3][0][2][0][RTW89_FCC][22] = 127,
	[3][0][2][0][RTW89_ETSI][22] = 127,
	[3][0][2][0][RTW89_MKK][22] = 127,
	[3][0][2][0][RTW89_IC][22] = 127,
	[3][0][2][0][RTW89_KCC][22] = 127,
	[3][0][2][0][RTW89_ACMA][22] = 127,
	[3][0][2][0][RTW89_CN][22] = 127,
	[3][0][2][0][RTW89_UK][22] = 127,
	[3][0][2][0][RTW89_FCC][45] = 127,
	[3][0][2][0][RTW89_ETSI][45] = 127,
	[3][0][2][0][RTW89_MKK][45] = 127,
	[3][0][2][0][RTW89_IC][45] = 127,
	[3][0][2][0][RTW89_KCC][45] = 127,
	[3][0][2][0][RTW89_ACMA][45] = 127,
	[3][0][2][0][RTW89_CN][45] = 127,
	[3][0][2][0][RTW89_UK][45] = 127,
	[3][1][2][0][RTW89_FCC][7] = 127,
	[3][1][2][0][RTW89_ETSI][7] = 127,
	[3][1][2][0][RTW89_MKK][7] = 127,
	[3][1][2][0][RTW89_IC][7] = 127,
	[3][1][2][0][RTW89_KCC][7] = 127,
	[3][1][2][0][RTW89_ACMA][7] = 127,
	[3][1][2][0][RTW89_CN][7] = 127,
	[3][1][2][0][RTW89_UK][7] = 127,
	[3][1][2][0][RTW89_FCC][22] = 127,
	[3][1][2][0][RTW89_ETSI][22] = 127,
	[3][1][2][0][RTW89_MKK][22] = 127,
	[3][1][2][0][RTW89_IC][22] = 127,
	[3][1][2][0][RTW89_KCC][22] = 127,
	[3][1][2][0][RTW89_ACMA][22] = 127,
	[3][1][2][0][RTW89_CN][22] = 127,
	[3][1][2][0][RTW89_UK][22] = 127,
	[3][1][2][0][RTW89_FCC][45] = 127,
	[3][1][2][0][RTW89_ETSI][45] = 127,
	[3][1][2][0][RTW89_MKK][45] = 127,
	[3][1][2][0][RTW89_IC][45] = 127,
	[3][1][2][0][RTW89_KCC][45] = 127,
	[3][1][2][0][RTW89_ACMA][45] = 127,
	[3][1][2][0][RTW89_CN][45] = 127,
	[3][1][2][0][RTW89_UK][45] = 127,
	[3][1][2][1][RTW89_FCC][7] = 127,
	[3][1][2][1][RTW89_ETSI][7] = 127,
	[3][1][2][1][RTW89_MKK][7] = 127,
	[3][1][2][1][RTW89_IC][7] = 127,
	[3][1][2][1][RTW89_KCC][7] = 127,
	[3][1][2][1][RTW89_ACMA][7] = 127,
	[3][1][2][1][RTW89_CN][7] = 127,
	[3][1][2][1][RTW89_UK][7] = 127,
	[3][1][2][1][RTW89_FCC][22] = 127,
	[3][1][2][1][RTW89_ETSI][22] = 127,
	[3][1][2][1][RTW89_MKK][22] = 127,
	[3][1][2][1][RTW89_IC][22] = 127,
	[3][1][2][1][RTW89_KCC][22] = 127,
	[3][1][2][1][RTW89_ACMA][22] = 127,
	[3][1][2][1][RTW89_CN][22] = 127,
	[3][1][2][1][RTW89_UK][22] = 127,
	[3][1][2][1][RTW89_FCC][45] = 127,
	[3][1][2][1][RTW89_ETSI][45] = 127,
	[3][1][2][1][RTW89_MKK][45] = 127,
	[3][1][2][1][RTW89_IC][45] = 127,
	[3][1][2][1][RTW89_KCC][45] = 127,
	[3][1][2][1][RTW89_ACMA][45] = 127,
	[3][1][2][1][RTW89_CN][45] = 127,
	[3][1][2][1][RTW89_UK][45] = 127,
};

static
const s8 rtw89_8851b_txpwr_lmt_ru_2g_type2[RTW89_RU_NUM][RTW89_NTX_NUM]
					  [RTW89_REGD_NUM][RTW89_2G_CH_NUM] = {
	[0][0][RTW89_WW][0] = 30,
	[0][0][RTW89_WW][1] = 30,
	[0][0][RTW89_WW][2] = 30,
	[0][0][RTW89_WW][3] = 30,
	[0][0][RTW89_WW][4] = 30,
	[0][0][RTW89_WW][5] = 30,
	[0][0][RTW89_WW][6] = 30,
	[0][0][RTW89_WW][7] = 30,
	[0][0][RTW89_WW][8] = 30,
	[0][0][RTW89_WW][9] = 30,
	[0][0][RTW89_WW][10] = 30,
	[0][0][RTW89_WW][11] = 30,
	[0][0][RTW89_WW][12] = 30,
	[0][0][RTW89_WW][13] = 0,
	[0][1][RTW89_WW][0] = 0,
	[0][1][RTW89_WW][1] = 0,
	[0][1][RTW89_WW][2] = 0,
	[0][1][RTW89_WW][3] = 0,
	[0][1][RTW89_WW][4] = 0,
	[0][1][RTW89_WW][5] = 0,
	[0][1][RTW89_WW][6] = 0,
	[0][1][RTW89_WW][7] = 0,
	[0][1][RTW89_WW][8] = 0,
	[0][1][RTW89_WW][9] = 0,
	[0][1][RTW89_WW][10] = 0,
	[0][1][RTW89_WW][11] = 0,
	[0][1][RTW89_WW][12] = 0,
	[0][1][RTW89_WW][13] = 0,
	[1][0][RTW89_WW][0] = 42,
	[1][0][RTW89_WW][1] = 42,
	[1][0][RTW89_WW][2] = 42,
	[1][0][RTW89_WW][3] = 42,
	[1][0][RTW89_WW][4] = 42,
	[1][0][RTW89_WW][5] = 42,
	[1][0][RTW89_WW][6] = 42,
	[1][0][RTW89_WW][7] = 42,
	[1][0][RTW89_WW][8] = 42,
	[1][0][RTW89_WW][9] = 42,
	[1][0][RTW89_WW][10] = 42,
	[1][0][RTW89_WW][11] = 42,
	[1][0][RTW89_WW][12] = 34,
	[1][0][RTW89_WW][13] = 0,
	[1][1][RTW89_WW][0] = 0,
	[1][1][RTW89_WW][1] = 0,
	[1][1][RTW89_WW][2] = 0,
	[1][1][RTW89_WW][3] = 0,
	[1][1][RTW89_WW][4] = 0,
	[1][1][RTW89_WW][5] = 0,
	[1][1][RTW89_WW][6] = 0,
	[1][1][RTW89_WW][7] = 0,
	[1][1][RTW89_WW][8] = 0,
	[1][1][RTW89_WW][9] = 0,
	[1][1][RTW89_WW][10] = 0,
	[1][1][RTW89_WW][11] = 0,
	[1][1][RTW89_WW][12] = 0,
	[1][1][RTW89_WW][13] = 0,
	[2][0][RTW89_WW][0] = 54,
	[2][0][RTW89_WW][1] = 54,
	[2][0][RTW89_WW][2] = 54,
	[2][0][RTW89_WW][3] = 54,
	[2][0][RTW89_WW][4] = 54,
	[2][0][RTW89_WW][5] = 54,
	[2][0][RTW89_WW][6] = 54,
	[2][0][RTW89_WW][7] = 54,
	[2][0][RTW89_WW][8] = 54,
	[2][0][RTW89_WW][9] = 54,
	[2][0][RTW89_WW][10] = 54,
	[2][0][RTW89_WW][11] = 54,
	[2][0][RTW89_WW][12] = 34,
	[2][0][RTW89_WW][13] = 0,
	[2][1][RTW89_WW][0] = 0,
	[2][1][RTW89_WW][1] = 0,
	[2][1][RTW89_WW][2] = 0,
	[2][1][RTW89_WW][3] = 0,
	[2][1][RTW89_WW][4] = 0,
	[2][1][RTW89_WW][5] = 0,
	[2][1][RTW89_WW][6] = 0,
	[2][1][RTW89_WW][7] = 0,
	[2][1][RTW89_WW][8] = 0,
	[2][1][RTW89_WW][9] = 0,
	[2][1][RTW89_WW][10] = 0,
	[2][1][RTW89_WW][11] = 0,
	[2][1][RTW89_WW][12] = 0,
	[2][1][RTW89_WW][13] = 0,
	[0][0][RTW89_FCC][0] = 60,
	[0][0][RTW89_ETSI][0] = 30,
	[0][0][RTW89_MKK][0] = 40,
	[0][0][RTW89_IC][0] = 60,
	[0][0][RTW89_KCC][0] = 46,
	[0][0][RTW89_ACMA][0] = 30,
	[0][0][RTW89_CN][0] = 32,
	[0][0][RTW89_UK][0] = 30,
	[0][0][RTW89_FCC][1] = 60,
	[0][0][RTW89_ETSI][1] = 30,
	[0][0][RTW89_MKK][1] = 44,
	[0][0][RTW89_IC][1] = 60,
	[0][0][RTW89_KCC][1] = 46,
	[0][0][RTW89_ACMA][1] = 30,
	[0][0][RTW89_CN][1] = 32,
	[0][0][RTW89_UK][1] = 30,
	[0][0][RTW89_FCC][2] = 64,
	[0][0][RTW89_ETSI][2] = 30,
	[0][0][RTW89_MKK][2] = 44,
	[0][0][RTW89_IC][2] = 64,
	[0][0][RTW89_KCC][2] = 46,
	[0][0][RTW89_ACMA][2] = 30,
	[0][0][RTW89_CN][2] = 32,
	[0][0][RTW89_UK][2] = 30,
	[0][0][RTW89_FCC][3] = 68,
	[0][0][RTW89_ETSI][3] = 30,
	[0][0][RTW89_MKK][3] = 44,
	[0][0][RTW89_IC][3] = 68,
	[0][0][RTW89_KCC][3] = 46,
	[0][0][RTW89_ACMA][3] = 30,
	[0][0][RTW89_CN][3] = 32,
	[0][0][RTW89_UK][3] = 30,
	[0][0][RTW89_FCC][4] = 68,
	[0][0][RTW89_ETSI][4] = 30,
	[0][0][RTW89_MKK][4] = 44,
	[0][0][RTW89_IC][4] = 68,
	[0][0][RTW89_KCC][4] = 48,
	[0][0][RTW89_ACMA][4] = 30,
	[0][0][RTW89_CN][4] = 32,
	[0][0][RTW89_UK][4] = 30,
	[0][0][RTW89_FCC][5] = 82,
	[0][0][RTW89_ETSI][5] = 30,
	[0][0][RTW89_MKK][5] = 44,
	[0][0][RTW89_IC][5] = 82,
	[0][0][RTW89_KCC][5] = 48,
	[0][0][RTW89_ACMA][5] = 30,
	[0][0][RTW89_CN][5] = 32,
	[0][0][RTW89_UK][5] = 30,
	[0][0][RTW89_FCC][6] = 64,
	[0][0][RTW89_ETSI][6] = 30,
	[0][0][RTW89_MKK][6] = 44,
	[0][0][RTW89_IC][6] = 64,
	[0][0][RTW89_KCC][6] = 48,
	[0][0][RTW89_ACMA][6] = 30,
	[0][0][RTW89_CN][6] = 32,
	[0][0][RTW89_UK][6] = 30,
	[0][0][RTW89_FCC][7] = 64,
	[0][0][RTW89_ETSI][7] = 30,
	[0][0][RTW89_MKK][7] = 44,
	[0][0][RTW89_IC][7] = 64,
	[0][0][RTW89_KCC][7] = 48,
	[0][0][RTW89_ACMA][7] = 30,
	[0][0][RTW89_CN][7] = 32,
	[0][0][RTW89_UK][7] = 30,
	[0][0][RTW89_FCC][8] = 60,
	[0][0][RTW89_ETSI][8] = 30,
	[0][0][RTW89_MKK][8] = 44,
	[0][0][RTW89_IC][8] = 60,
	[0][0][RTW89_KCC][8] = 48,
	[0][0][RTW89_ACMA][8] = 30,
	[0][0][RTW89_CN][8] = 32,
	[0][0][RTW89_UK][8] = 30,
	[0][0][RTW89_FCC][9] = 56,
	[0][0][RTW89_ETSI][9] = 30,
	[0][0][RTW89_MKK][9] = 44,
	[0][0][RTW89_IC][9] = 56,
	[0][0][RTW89_KCC][9] = 44,
	[0][0][RTW89_ACMA][9] = 30,
	[0][0][RTW89_CN][9] = 32,
	[0][0][RTW89_UK][9] = 30,
	[0][0][RTW89_FCC][10] = 56,
	[0][0][RTW89_ETSI][10] = 30,
	[0][0][RTW89_MKK][10] = 44,
	[0][0][RTW89_IC][10] = 56,
	[0][0][RTW89_KCC][10] = 44,
	[0][0][RTW89_ACMA][10] = 30,
	[0][0][RTW89_CN][10] = 32,
	[0][0][RTW89_UK][10] = 30,
	[0][0][RTW89_FCC][11] = 54,
	[0][0][RTW89_ETSI][11] = 30,
	[0][0][RTW89_MKK][11] = 44,
	[0][0][RTW89_IC][11] = 54,
	[0][0][RTW89_KCC][11] = 44,
	[0][0][RTW89_ACMA][11] = 30,
	[0][0][RTW89_CN][11] = 32,
	[0][0][RTW89_UK][11] = 30,
	[0][0][RTW89_FCC][12] = 34,
	[0][0][RTW89_ETSI][12] = 30,
	[0][0][RTW89_MKK][12] = 40,
	[0][0][RTW89_IC][12] = 34,
	[0][0][RTW89_KCC][12] = 44,
	[0][0][RTW89_ACMA][12] = 30,
	[0][0][RTW89_CN][12] = 32,
	[0][0][RTW89_UK][12] = 30,
	[0][0][RTW89_FCC][13] = 127,
	[0][0][RTW89_ETSI][13] = 127,
	[0][0][RTW89_MKK][13] = 127,
	[0][0][RTW89_IC][13] = 127,
	[0][0][RTW89_KCC][13] = 127,
	[0][0][RTW89_ACMA][13] = 127,
	[0][0][RTW89_CN][13] = 127,
	[0][0][RTW89_UK][13] = 127,
	[0][1][RTW89_FCC][0] = 127,
	[0][1][RTW89_ETSI][0] = 127,
	[0][1][RTW89_MKK][0] = 127,
	[0][1][RTW89_IC][0] = 127,
	[0][1][RTW89_KCC][0] = 127,
	[0][1][RTW89_ACMA][0] = 127,
	[0][1][RTW89_CN][0] = 127,
	[0][1][RTW89_UK][0] = 127,
	[0][1][RTW89_FCC][1] = 127,
	[0][1][RTW89_ETSI][1] = 127,
	[0][1][RTW89_MKK][1] = 127,
	[0][1][RTW89_IC][1] = 127,
	[0][1][RTW89_KCC][1] = 127,
	[0][1][RTW89_ACMA][1] = 127,
	[0][1][RTW89_CN][1] = 127,
	[0][1][RTW89_UK][1] = 127,
	[0][1][RTW89_FCC][2] = 127,
	[0][1][RTW89_ETSI][2] = 127,
	[0][1][RTW89_MKK][2] = 127,
	[0][1][RTW89_IC][2] = 127,
	[0][1][RTW89_KCC][2] = 127,
	[0][1][RTW89_ACMA][2] = 127,
	[0][1][RTW89_CN][2] = 127,
	[0][1][RTW89_UK][2] = 127,
	[0][1][RTW89_FCC][3] = 127,
	[0][1][RTW89_ETSI][3] = 127,
	[0][1][RTW89_MKK][3] = 127,
	[0][1][RTW89_IC][3] = 127,
	[0][1][RTW89_KCC][3] = 127,
	[0][1][RTW89_ACMA][3] = 127,
	[0][1][RTW89_CN][3] = 127,
	[0][1][RTW89_UK][3] = 127,
	[0][1][RTW89_FCC][4] = 127,
	[0][1][RTW89_ETSI][4] = 127,
	[0][1][RTW89_MKK][4] = 127,
	[0][1][RTW89_IC][4] = 127,
	[0][1][RTW89_KCC][4] = 127,
	[0][1][RTW89_ACMA][4] = 127,
	[0][1][RTW89_CN][4] = 127,
	[0][1][RTW89_UK][4] = 127,
	[0][1][RTW89_FCC][5] = 127,
	[0][1][RTW89_ETSI][5] = 127,
	[0][1][RTW89_MKK][5] = 127,
	[0][1][RTW89_IC][5] = 127,
	[0][1][RTW89_KCC][5] = 127,
	[0][1][RTW89_ACMA][5] = 127,
	[0][1][RTW89_CN][5] = 127,
	[0][1][RTW89_UK][5] = 127,
	[0][1][RTW89_FCC][6] = 127,
	[0][1][RTW89_ETSI][6] = 127,
	[0][1][RTW89_MKK][6] = 127,
	[0][1][RTW89_IC][6] = 127,
	[0][1][RTW89_KCC][6] = 127,
	[0][1][RTW89_ACMA][6] = 127,
	[0][1][RTW89_CN][6] = 127,
	[0][1][RTW89_UK][6] = 127,
	[0][1][RTW89_FCC][7] = 127,
	[0][1][RTW89_ETSI][7] = 127,
	[0][1][RTW89_MKK][7] = 127,
	[0][1][RTW89_IC][7] = 127,
	[0][1][RTW89_KCC][7] = 127,
	[0][1][RTW89_ACMA][7] = 127,
	[0][1][RTW89_CN][7] = 127,
	[0][1][RTW89_UK][7] = 127,
	[0][1][RTW89_FCC][8] = 127,
	[0][1][RTW89_ETSI][8] = 127,
	[0][1][RTW89_MKK][8] = 127,
	[0][1][RTW89_IC][8] = 127,
	[0][1][RTW89_KCC][8] = 127,
	[0][1][RTW89_ACMA][8] = 127,
	[0][1][RTW89_CN][8] = 127,
	[0][1][RTW89_UK][8] = 127,
	[0][1][RTW89_FCC][9] = 127,
	[0][1][RTW89_ETSI][9] = 127,
	[0][1][RTW89_MKK][9] = 127,
	[0][1][RTW89_IC][9] = 127,
	[0][1][RTW89_KCC][9] = 127,
	[0][1][RTW89_ACMA][9] = 127,
	[0][1][RTW89_CN][9] = 127,
	[0][1][RTW89_UK][9] = 127,
	[0][1][RTW89_FCC][10] = 127,
	[0][1][RTW89_ETSI][10] = 127,
	[0][1][RTW89_MKK][10] = 127,
	[0][1][RTW89_IC][10] = 127,
	[0][1][RTW89_KCC][10] = 127,
	[0][1][RTW89_ACMA][10] = 127,
	[0][1][RTW89_CN][10] = 127,
	[0][1][RTW89_UK][10] = 127,
	[0][1][RTW89_FCC][11] = 127,
	[0][1][RTW89_ETSI][11] = 127,
	[0][1][RTW89_MKK][11] = 127,
	[0][1][RTW89_IC][11] = 127,
	[0][1][RTW89_KCC][11] = 127,
	[0][1][RTW89_ACMA][11] = 127,
	[0][1][RTW89_CN][11] = 127,
	[0][1][RTW89_UK][11] = 127,
	[0][1][RTW89_FCC][12] = 127,
	[0][1][RTW89_ETSI][12] = 127,
	[0][1][RTW89_MKK][12] = 127,
	[0][1][RTW89_IC][12] = 127,
	[0][1][RTW89_KCC][12] = 127,
	[0][1][RTW89_ACMA][12] = 127,
	[0][1][RTW89_CN][12] = 127,
	[0][1][RTW89_UK][12] = 127,
	[0][1][RTW89_FCC][13] = 127,
	[0][1][RTW89_ETSI][13] = 127,
	[0][1][RTW89_MKK][13] = 127,
	[0][1][RTW89_IC][13] = 127,
	[0][1][RTW89_KCC][13] = 127,
	[0][1][RTW89_ACMA][13] = 127,
	[0][1][RTW89_CN][13] = 127,
	[0][1][RTW89_UK][13] = 127,
	[1][0][RTW89_FCC][0] = 70,
	[1][0][RTW89_ETSI][0] = 42,
	[1][0][RTW89_MKK][0] = 52,
	[1][0][RTW89_IC][0] = 70,
	[1][0][RTW89_KCC][0] = 56,
	[1][0][RTW89_ACMA][0] = 42,
	[1][0][RTW89_CN][0] = 42,
	[1][0][RTW89_UK][0] = 42,
	[1][0][RTW89_FCC][1] = 70,
	[1][0][RTW89_ETSI][1] = 42,
	[1][0][RTW89_MKK][1] = 52,
	[1][0][RTW89_IC][1] = 70,
	[1][0][RTW89_KCC][1] = 56,
	[1][0][RTW89_ACMA][1] = 42,
	[1][0][RTW89_CN][1] = 44,
	[1][0][RTW89_UK][1] = 42,
	[1][0][RTW89_FCC][2] = 74,
	[1][0][RTW89_ETSI][2] = 42,
	[1][0][RTW89_MKK][2] = 52,
	[1][0][RTW89_IC][2] = 74,
	[1][0][RTW89_KCC][2] = 56,
	[1][0][RTW89_ACMA][2] = 42,
	[1][0][RTW89_CN][2] = 44,
	[1][0][RTW89_UK][2] = 42,
	[1][0][RTW89_FCC][3] = 76,
	[1][0][RTW89_ETSI][3] = 42,
	[1][0][RTW89_MKK][3] = 52,
	[1][0][RTW89_IC][3] = 76,
	[1][0][RTW89_KCC][3] = 56,
	[1][0][RTW89_ACMA][3] = 42,
	[1][0][RTW89_CN][3] = 44,
	[1][0][RTW89_UK][3] = 42,
	[1][0][RTW89_FCC][4] = 76,
	[1][0][RTW89_ETSI][4] = 42,
	[1][0][RTW89_MKK][4] = 52,
	[1][0][RTW89_IC][4] = 76,
	[1][0][RTW89_KCC][4] = 56,
	[1][0][RTW89_ACMA][4] = 42,
	[1][0][RTW89_CN][4] = 44,
	[1][0][RTW89_UK][4] = 42,
	[1][0][RTW89_FCC][5] = 82,
	[1][0][RTW89_ETSI][5] = 42,
	[1][0][RTW89_MKK][5] = 52,
	[1][0][RTW89_IC][5] = 82,
	[1][0][RTW89_KCC][5] = 56,
	[1][0][RTW89_ACMA][5] = 42,
	[1][0][RTW89_CN][5] = 44,
	[1][0][RTW89_UK][5] = 42,
	[1][0][RTW89_FCC][6] = 72,
	[1][0][RTW89_ETSI][6] = 42,
	[1][0][RTW89_MKK][6] = 52,
	[1][0][RTW89_IC][6] = 72,
	[1][0][RTW89_KCC][6] = 56,
	[1][0][RTW89_ACMA][6] = 42,
	[1][0][RTW89_CN][6] = 44,
	[1][0][RTW89_UK][6] = 42,
	[1][0][RTW89_FCC][7] = 72,
	[1][0][RTW89_ETSI][7] = 42,
	[1][0][RTW89_MKK][7] = 52,
	[1][0][RTW89_IC][7] = 72,
	[1][0][RTW89_KCC][7] = 56,
	[1][0][RTW89_ACMA][7] = 42,
	[1][0][RTW89_CN][7] = 44,
	[1][0][RTW89_UK][7] = 42,
	[1][0][RTW89_FCC][8] = 72,
	[1][0][RTW89_ETSI][8] = 42,
	[1][0][RTW89_MKK][8] = 52,
	[1][0][RTW89_IC][8] = 72,
	[1][0][RTW89_KCC][8] = 56,
	[1][0][RTW89_ACMA][8] = 42,
	[1][0][RTW89_CN][8] = 44,
	[1][0][RTW89_UK][8] = 42,
	[1][0][RTW89_FCC][9] = 68,
	[1][0][RTW89_ETSI][9] = 42,
	[1][0][RTW89_MKK][9] = 52,
	[1][0][RTW89_IC][9] = 68,
	[1][0][RTW89_KCC][9] = 58,
	[1][0][RTW89_ACMA][9] = 42,
	[1][0][RTW89_CN][9] = 44,
	[1][0][RTW89_UK][9] = 42,
	[1][0][RTW89_FCC][10] = 68,
	[1][0][RTW89_ETSI][10] = 42,
	[1][0][RTW89_MKK][10] = 52,
	[1][0][RTW89_IC][10] = 68,
	[1][0][RTW89_KCC][10] = 58,
	[1][0][RTW89_ACMA][10] = 42,
	[1][0][RTW89_CN][10] = 44,
	[1][0][RTW89_UK][10] = 42,
	[1][0][RTW89_FCC][11] = 66,
	[1][0][RTW89_ETSI][11] = 42,
	[1][0][RTW89_MKK][11] = 52,
	[1][0][RTW89_IC][11] = 66,
	[1][0][RTW89_KCC][11] = 58,
	[1][0][RTW89_ACMA][11] = 42,
	[1][0][RTW89_CN][11] = 44,
	[1][0][RTW89_UK][11] = 42,
	[1][0][RTW89_FCC][12] = 34,
	[1][0][RTW89_ETSI][12] = 42,
	[1][0][RTW89_MKK][12] = 52,
	[1][0][RTW89_IC][12] = 34,
	[1][0][RTW89_KCC][12] = 58,
	[1][0][RTW89_ACMA][12] = 42,
	[1][0][RTW89_CN][12] = 42,
	[1][0][RTW89_UK][12] = 42,
	[1][0][RTW89_FCC][13] = 127,
	[1][0][RTW89_ETSI][13] = 127,
	[1][0][RTW89_MKK][13] = 127,
	[1][0][RTW89_IC][13] = 127,
	[1][0][RTW89_KCC][13] = 127,
	[1][0][RTW89_ACMA][13] = 127,
	[1][0][RTW89_CN][13] = 127,
	[1][0][RTW89_UK][13] = 127,
	[1][1][RTW89_FCC][0] = 127,
	[1][1][RTW89_ETSI][0] = 127,
	[1][1][RTW89_MKK][0] = 127,
	[1][1][RTW89_IC][0] = 127,
	[1][1][RTW89_KCC][0] = 127,
	[1][1][RTW89_ACMA][0] = 127,
	[1][1][RTW89_CN][0] = 127,
	[1][1][RTW89_UK][0] = 127,
	[1][1][RTW89_FCC][1] = 127,
	[1][1][RTW89_ETSI][1] = 127,
	[1][1][RTW89_MKK][1] = 127,
	[1][1][RTW89_IC][1] = 127,
	[1][1][RTW89_KCC][1] = 127,
	[1][1][RTW89_ACMA][1] = 127,
	[1][1][RTW89_CN][1] = 127,
	[1][1][RTW89_UK][1] = 127,
	[1][1][RTW89_FCC][2] = 127,
	[1][1][RTW89_ETSI][2] = 127,
	[1][1][RTW89_MKK][2] = 127,
	[1][1][RTW89_IC][2] = 127,
	[1][1][RTW89_KCC][2] = 127,
	[1][1][RTW89_ACMA][2] = 127,
	[1][1][RTW89_CN][2] = 127,
	[1][1][RTW89_UK][2] = 127,
	[1][1][RTW89_FCC][3] = 127,
	[1][1][RTW89_ETSI][3] = 127,
	[1][1][RTW89_MKK][3] = 127,
	[1][1][RTW89_IC][3] = 127,
	[1][1][RTW89_KCC][3] = 127,
	[1][1][RTW89_ACMA][3] = 127,
	[1][1][RTW89_CN][3] = 127,
	[1][1][RTW89_UK][3] = 127,
	[1][1][RTW89_FCC][4] = 127,
	[1][1][RTW89_ETSI][4] = 127,
	[1][1][RTW89_MKK][4] = 127,
	[1][1][RTW89_IC][4] = 127,
	[1][1][RTW89_KCC][4] = 127,
	[1][1][RTW89_ACMA][4] = 127,
	[1][1][RTW89_CN][4] = 127,
	[1][1][RTW89_UK][4] = 127,
	[1][1][RTW89_FCC][5] = 127,
	[1][1][RTW89_ETSI][5] = 127,
	[1][1][RTW89_MKK][5] = 127,
	[1][1][RTW89_IC][5] = 127,
	[1][1][RTW89_KCC][5] = 127,
	[1][1][RTW89_ACMA][5] = 127,
	[1][1][RTW89_CN][5] = 127,
	[1][1][RTW89_UK][5] = 127,
	[1][1][RTW89_FCC][6] = 127,
	[1][1][RTW89_ETSI][6] = 127,
	[1][1][RTW89_MKK][6] = 127,
	[1][1][RTW89_IC][6] = 127,
	[1][1][RTW89_KCC][6] = 127,
	[1][1][RTW89_ACMA][6] = 127,
	[1][1][RTW89_CN][6] = 127,
	[1][1][RTW89_UK][6] = 127,
	[1][1][RTW89_FCC][7] = 127,
	[1][1][RTW89_ETSI][7] = 127,
	[1][1][RTW89_MKK][7] = 127,
	[1][1][RTW89_IC][7] = 127,
	[1][1][RTW89_KCC][7] = 127,
	[1][1][RTW89_ACMA][7] = 127,
	[1][1][RTW89_CN][7] = 127,
	[1][1][RTW89_UK][7] = 127,
	[1][1][RTW89_FCC][8] = 127,
	[1][1][RTW89_ETSI][8] = 127,
	[1][1][RTW89_MKK][8] = 127,
	[1][1][RTW89_IC][8] = 127,
	[1][1][RTW89_KCC][8] = 127,
	[1][1][RTW89_ACMA][8] = 127,
	[1][1][RTW89_CN][8] = 127,
	[1][1][RTW89_UK][8] = 127,
	[1][1][RTW89_FCC][9] = 127,
	[1][1][RTW89_ETSI][9] = 127,
	[1][1][RTW89_MKK][9] = 127,
	[1][1][RTW89_IC][9] = 127,
	[1][1][RTW89_KCC][9] = 127,
	[1][1][RTW89_ACMA][9] = 127,
	[1][1][RTW89_CN][9] = 127,
	[1][1][RTW89_UK][9] = 127,
	[1][1][RTW89_FCC][10] = 127,
	[1][1][RTW89_ETSI][10] = 127,
	[1][1][RTW89_MKK][10] = 127,
	[1][1][RTW89_IC][10] = 127,
	[1][1][RTW89_KCC][10] = 127,
	[1][1][RTW89_ACMA][10] = 127,
	[1][1][RTW89_CN][10] = 127,
	[1][1][RTW89_UK][10] = 127,
	[1][1][RTW89_FCC][11] = 127,
	[1][1][RTW89_ETSI][11] = 127,
	[1][1][RTW89_MKK][11] = 127,
	[1][1][RTW89_IC][11] = 127,
	[1][1][RTW89_KCC][11] = 127,
	[1][1][RTW89_ACMA][11] = 127,
	[1][1][RTW89_CN][11] = 127,
	[1][1][RTW89_UK][11] = 127,
	[1][1][RTW89_FCC][12] = 127,
	[1][1][RTW89_ETSI][12] = 127,
	[1][1][RTW89_MKK][12] = 127,
	[1][1][RTW89_IC][12] = 127,
	[1][1][RTW89_KCC][12] = 127,
	[1][1][RTW89_ACMA][12] = 127,
	[1][1][RTW89_CN][12] = 127,
	[1][1][RTW89_UK][12] = 127,
	[1][1][RTW89_FCC][13] = 127,
	[1][1][RTW89_ETSI][13] = 127,
	[1][1][RTW89_MKK][13] = 127,
	[1][1][RTW89_IC][13] = 127,
	[1][1][RTW89_KCC][13] = 127,
	[1][1][RTW89_ACMA][13] = 127,
	[1][1][RTW89_CN][13] = 127,
	[1][1][RTW89_UK][13] = 127,
	[2][0][RTW89_FCC][0] = 74,
	[2][0][RTW89_ETSI][0] = 54,
	[2][0][RTW89_MKK][0] = 64,
	[2][0][RTW89_IC][0] = 74,
	[2][0][RTW89_KCC][0] = 68,
	[2][0][RTW89_ACMA][0] = 54,
	[2][0][RTW89_CN][0] = 56,
	[2][0][RTW89_UK][0] = 54,
	[2][0][RTW89_FCC][1] = 74,
	[2][0][RTW89_ETSI][1] = 54,
	[2][0][RTW89_MKK][1] = 64,
	[2][0][RTW89_IC][1] = 74,
	[2][0][RTW89_KCC][1] = 68,
	[2][0][RTW89_ACMA][1] = 54,
	[2][0][RTW89_CN][1] = 56,
	[2][0][RTW89_UK][1] = 54,
	[2][0][RTW89_FCC][2] = 76,
	[2][0][RTW89_ETSI][2] = 54,
	[2][0][RTW89_MKK][2] = 64,
	[2][0][RTW89_IC][2] = 76,
	[2][0][RTW89_KCC][2] = 68,
	[2][0][RTW89_ACMA][2] = 54,
	[2][0][RTW89_CN][2] = 56,
	[2][0][RTW89_UK][2] = 54,
	[2][0][RTW89_FCC][3] = 76,
	[2][0][RTW89_ETSI][3] = 54,
	[2][0][RTW89_MKK][3] = 64,
	[2][0][RTW89_IC][3] = 76,
	[2][0][RTW89_KCC][3] = 68,
	[2][0][RTW89_ACMA][3] = 54,
	[2][0][RTW89_CN][3] = 56,
	[2][0][RTW89_UK][3] = 54,
	[2][0][RTW89_FCC][4] = 76,
	[2][0][RTW89_ETSI][4] = 54,
	[2][0][RTW89_MKK][4] = 64,
	[2][0][RTW89_IC][4] = 76,
	[2][0][RTW89_KCC][4] = 68,
	[2][0][RTW89_ACMA][4] = 54,
	[2][0][RTW89_CN][4] = 56,
	[2][0][RTW89_UK][4] = 54,
	[2][0][RTW89_FCC][5] = 80,
	[2][0][RTW89_ETSI][5] = 54,
	[2][0][RTW89_MKK][5] = 64,
	[2][0][RTW89_IC][5] = 80,
	[2][0][RTW89_KCC][5] = 68,
	[2][0][RTW89_ACMA][5] = 54,
	[2][0][RTW89_CN][5] = 56,
	[2][0][RTW89_UK][5] = 54,
	[2][0][RTW89_FCC][6] = 72,
	[2][0][RTW89_ETSI][6] = 54,
	[2][0][RTW89_MKK][6] = 64,
	[2][0][RTW89_IC][6] = 72,
	[2][0][RTW89_KCC][6] = 68,
	[2][0][RTW89_ACMA][6] = 54,
	[2][0][RTW89_CN][6] = 56,
	[2][0][RTW89_UK][6] = 54,
	[2][0][RTW89_FCC][7] = 72,
	[2][0][RTW89_ETSI][7] = 54,
	[2][0][RTW89_MKK][7] = 64,
	[2][0][RTW89_IC][7] = 72,
	[2][0][RTW89_KCC][7] = 68,
	[2][0][RTW89_ACMA][7] = 54,
	[2][0][RTW89_CN][7] = 56,
	[2][0][RTW89_UK][7] = 54,
	[2][0][RTW89_FCC][8] = 72,
	[2][0][RTW89_ETSI][8] = 54,
	[2][0][RTW89_MKK][8] = 64,
	[2][0][RTW89_IC][8] = 72,
	[2][0][RTW89_KCC][8] = 68,
	[2][0][RTW89_ACMA][8] = 54,
	[2][0][RTW89_CN][8] = 56,
	[2][0][RTW89_UK][8] = 54,
	[2][0][RTW89_FCC][9] = 70,
	[2][0][RTW89_ETSI][9] = 54,
	[2][0][RTW89_MKK][9] = 64,
	[2][0][RTW89_IC][9] = 70,
	[2][0][RTW89_KCC][9] = 68,
	[2][0][RTW89_ACMA][9] = 54,
	[2][0][RTW89_CN][9] = 56,
	[2][0][RTW89_UK][9] = 54,
	[2][0][RTW89_FCC][10] = 70,
	[2][0][RTW89_ETSI][10] = 54,
	[2][0][RTW89_MKK][10] = 64,
	[2][0][RTW89_IC][10] = 70,
	[2][0][RTW89_KCC][10] = 68,
	[2][0][RTW89_ACMA][10] = 54,
	[2][0][RTW89_CN][10] = 56,
	[2][0][RTW89_UK][10] = 54,
	[2][0][RTW89_FCC][11] = 62,
	[2][0][RTW89_ETSI][11] = 54,
	[2][0][RTW89_MKK][11] = 64,
	[2][0][RTW89_IC][11] = 62,
	[2][0][RTW89_KCC][11] = 68,
	[2][0][RTW89_ACMA][11] = 54,
	[2][0][RTW89_CN][11] = 56,
	[2][0][RTW89_UK][11] = 54,
	[2][0][RTW89_FCC][12] = 34,
	[2][0][RTW89_ETSI][12] = 54,
	[2][0][RTW89_MKK][12] = 64,
	[2][0][RTW89_IC][12] = 34,
	[2][0][RTW89_KCC][12] = 68,
	[2][0][RTW89_ACMA][12] = 54,
	[2][0][RTW89_CN][12] = 56,
	[2][0][RTW89_UK][12] = 54,
	[2][0][RTW89_FCC][13] = 127,
	[2][0][RTW89_ETSI][13] = 127,
	[2][0][RTW89_MKK][13] = 127,
	[2][0][RTW89_IC][13] = 127,
	[2][0][RTW89_KCC][13] = 127,
	[2][0][RTW89_ACMA][13] = 127,
	[2][0][RTW89_CN][13] = 127,
	[2][0][RTW89_UK][13] = 127,
	[2][1][RTW89_FCC][0] = 127,
	[2][1][RTW89_ETSI][0] = 127,
	[2][1][RTW89_MKK][0] = 127,
	[2][1][RTW89_IC][0] = 127,
	[2][1][RTW89_KCC][0] = 127,
	[2][1][RTW89_ACMA][0] = 127,
	[2][1][RTW89_CN][0] = 127,
	[2][1][RTW89_UK][0] = 127,
	[2][1][RTW89_FCC][1] = 127,
	[2][1][RTW89_ETSI][1] = 127,
	[2][1][RTW89_MKK][1] = 127,
	[2][1][RTW89_IC][1] = 127,
	[2][1][RTW89_KCC][1] = 127,
	[2][1][RTW89_ACMA][1] = 127,
	[2][1][RTW89_CN][1] = 127,
	[2][1][RTW89_UK][1] = 127,
	[2][1][RTW89_FCC][2] = 127,
	[2][1][RTW89_ETSI][2] = 127,
	[2][1][RTW89_MKK][2] = 127,
	[2][1][RTW89_IC][2] = 127,
	[2][1][RTW89_KCC][2] = 127,
	[2][1][RTW89_ACMA][2] = 127,
	[2][1][RTW89_CN][2] = 127,
	[2][1][RTW89_UK][2] = 127,
	[2][1][RTW89_FCC][3] = 127,
	[2][1][RTW89_ETSI][3] = 127,
	[2][1][RTW89_MKK][3] = 127,
	[2][1][RTW89_IC][3] = 127,
	[2][1][RTW89_KCC][3] = 127,
	[2][1][RTW89_ACMA][3] = 127,
	[2][1][RTW89_CN][3] = 127,
	[2][1][RTW89_UK][3] = 127,
	[2][1][RTW89_FCC][4] = 127,
	[2][1][RTW89_ETSI][4] = 127,
	[2][1][RTW89_MKK][4] = 127,
	[2][1][RTW89_IC][4] = 127,
	[2][1][RTW89_KCC][4] = 127,
	[2][1][RTW89_ACMA][4] = 127,
	[2][1][RTW89_CN][4] = 127,
	[2][1][RTW89_UK][4] = 127,
	[2][1][RTW89_FCC][5] = 127,
	[2][1][RTW89_ETSI][5] = 127,
	[2][1][RTW89_MKK][5] = 127,
	[2][1][RTW89_IC][5] = 127,
	[2][1][RTW89_KCC][5] = 127,
	[2][1][RTW89_ACMA][5] = 127,
	[2][1][RTW89_CN][5] = 127,
	[2][1][RTW89_UK][5] = 127,
	[2][1][RTW89_FCC][6] = 127,
	[2][1][RTW89_ETSI][6] = 127,
	[2][1][RTW89_MKK][6] = 127,
	[2][1][RTW89_IC][6] = 127,
	[2][1][RTW89_KCC][6] = 127,
	[2][1][RTW89_ACMA][6] = 127,
	[2][1][RTW89_CN][6] = 127,
	[2][1][RTW89_UK][6] = 127,
	[2][1][RTW89_FCC][7] = 127,
	[2][1][RTW89_ETSI][7] = 127,
	[2][1][RTW89_MKK][7] = 127,
	[2][1][RTW89_IC][7] = 127,
	[2][1][RTW89_KCC][7] = 127,
	[2][1][RTW89_ACMA][7] = 127,
	[2][1][RTW89_CN][7] = 127,
	[2][1][RTW89_UK][7] = 127,
	[2][1][RTW89_FCC][8] = 127,
	[2][1][RTW89_ETSI][8] = 127,
	[2][1][RTW89_MKK][8] = 127,
	[2][1][RTW89_IC][8] = 127,
	[2][1][RTW89_KCC][8] = 127,
	[2][1][RTW89_ACMA][8] = 127,
	[2][1][RTW89_CN][8] = 127,
	[2][1][RTW89_UK][8] = 127,
	[2][1][RTW89_FCC][9] = 127,
	[2][1][RTW89_ETSI][9] = 127,
	[2][1][RTW89_MKK][9] = 127,
	[2][1][RTW89_IC][9] = 127,
	[2][1][RTW89_KCC][9] = 127,
	[2][1][RTW89_ACMA][9] = 127,
	[2][1][RTW89_CN][9] = 127,
	[2][1][RTW89_UK][9] = 127,
	[2][1][RTW89_FCC][10] = 127,
	[2][1][RTW89_ETSI][10] = 127,
	[2][1][RTW89_MKK][10] = 127,
	[2][1][RTW89_IC][10] = 127,
	[2][1][RTW89_KCC][10] = 127,
	[2][1][RTW89_ACMA][10] = 127,
	[2][1][RTW89_CN][10] = 127,
	[2][1][RTW89_UK][10] = 127,
	[2][1][RTW89_FCC][11] = 127,
	[2][1][RTW89_ETSI][11] = 127,
	[2][1][RTW89_MKK][11] = 127,
	[2][1][RTW89_IC][11] = 127,
	[2][1][RTW89_KCC][11] = 127,
	[2][1][RTW89_ACMA][11] = 127,
	[2][1][RTW89_CN][11] = 127,
	[2][1][RTW89_UK][11] = 127,
	[2][1][RTW89_FCC][12] = 127,
	[2][1][RTW89_ETSI][12] = 127,
	[2][1][RTW89_MKK][12] = 127,
	[2][1][RTW89_IC][12] = 127,
	[2][1][RTW89_KCC][12] = 127,
	[2][1][RTW89_ACMA][12] = 127,
	[2][1][RTW89_CN][12] = 127,
	[2][1][RTW89_UK][12] = 127,
	[2][1][RTW89_FCC][13] = 127,
	[2][1][RTW89_ETSI][13] = 127,
	[2][1][RTW89_MKK][13] = 127,
	[2][1][RTW89_IC][13] = 127,
	[2][1][RTW89_KCC][13] = 127,
	[2][1][RTW89_ACMA][13] = 127,
	[2][1][RTW89_CN][13] = 127,
	[2][1][RTW89_UK][13] = 127,
};

static
const s8 rtw89_8851b_txpwr_lmt_ru_5g_type2[RTW89_RU_NUM][RTW89_NTX_NUM]
					  [RTW89_REGD_NUM][RTW89_5G_CH_NUM] = {
	[0][0][RTW89_WW][0] = 16,
	[0][0][RTW89_WW][2] = 16,
	[0][0][RTW89_WW][4] = 16,
	[0][0][RTW89_WW][6] = 16,
	[0][0][RTW89_WW][8] = 16,
	[0][0][RTW89_WW][10] = 16,
	[0][0][RTW89_WW][12] = 16,
	[0][0][RTW89_WW][14] = 16,
	[0][0][RTW89_WW][15] = 24,
	[0][0][RTW89_WW][17] = 24,
	[0][0][RTW89_WW][19] = 24,
	[0][0][RTW89_WW][21] = 24,
	[0][0][RTW89_WW][23] = 24,
	[0][0][RTW89_WW][25] = 24,
	[0][0][RTW89_WW][27] = 24,
	[0][0][RTW89_WW][29] = 24,
	[0][0][RTW89_WW][31] = 24,
	[0][0][RTW89_WW][33] = 24,
	[0][0][RTW89_WW][35] = 24,
	[0][0][RTW89_WW][37] = 44,
	[0][0][RTW89_WW][38] = 24,
	[0][0][RTW89_WW][40] = 24,
	[0][0][RTW89_WW][42] = 24,
	[0][0][RTW89_WW][44] = 24,
	[0][0][RTW89_WW][46] = 24,
	[0][0][RTW89_WW][48] = 40,
	[0][0][RTW89_WW][50] = 42,
	[0][0][RTW89_WW][52] = 38,
	[0][1][RTW89_WW][0] = 0,
	[0][1][RTW89_WW][2] = 0,
	[0][1][RTW89_WW][4] = 0,
	[0][1][RTW89_WW][6] = 0,
	[0][1][RTW89_WW][8] = 0,
	[0][1][RTW89_WW][10] = 0,
	[0][1][RTW89_WW][12] = 0,
	[0][1][RTW89_WW][14] = 0,
	[0][1][RTW89_WW][15] = 0,
	[0][1][RTW89_WW][17] = 0,
	[0][1][RTW89_WW][19] = 0,
	[0][1][RTW89_WW][21] = 0,
	[0][1][RTW89_WW][23] = 0,
	[0][1][RTW89_WW][25] = 0,
	[0][1][RTW89_WW][27] = 0,
	[0][1][RTW89_WW][29] = 0,
	[0][1][RTW89_WW][31] = 0,
	[0][1][RTW89_WW][33] = 0,
	[0][1][RTW89_WW][35] = 0,
	[0][1][RTW89_WW][37] = 0,
	[0][1][RTW89_WW][38] = 0,
	[0][1][RTW89_WW][40] = 0,
	[0][1][RTW89_WW][42] = 0,
	[0][1][RTW89_WW][44] = 0,
	[0][1][RTW89_WW][46] = 0,
	[0][1][RTW89_WW][48] = 0,
	[0][1][RTW89_WW][50] = 0,
	[0][1][RTW89_WW][52] = 0,
	[1][0][RTW89_WW][0] = 26,
	[1][0][RTW89_WW][2] = 26,
	[1][0][RTW89_WW][4] = 26,
	[1][0][RTW89_WW][6] = 26,
	[1][0][RTW89_WW][8] = 26,
	[1][0][RTW89_WW][10] = 26,
	[1][0][RTW89_WW][12] = 26,
	[1][0][RTW89_WW][14] = 26,
	[1][0][RTW89_WW][15] = 34,
	[1][0][RTW89_WW][17] = 34,
	[1][0][RTW89_WW][19] = 34,
	[1][0][RTW89_WW][21] = 34,
	[1][0][RTW89_WW][23] = 34,
	[1][0][RTW89_WW][25] = 34,
	[1][0][RTW89_WW][27] = 34,
	[1][0][RTW89_WW][29] = 34,
	[1][0][RTW89_WW][31] = 34,
	[1][0][RTW89_WW][33] = 34,
	[1][0][RTW89_WW][35] = 34,
	[1][0][RTW89_WW][37] = 54,
	[1][0][RTW89_WW][38] = 28,
	[1][0][RTW89_WW][40] = 28,
	[1][0][RTW89_WW][42] = 28,
	[1][0][RTW89_WW][44] = 28,
	[1][0][RTW89_WW][46] = 28,
	[1][0][RTW89_WW][48] = 52,
	[1][0][RTW89_WW][50] = 52,
	[1][0][RTW89_WW][52] = 50,
	[1][1][RTW89_WW][0] = 0,
	[1][1][RTW89_WW][2] = 0,
	[1][1][RTW89_WW][4] = 0,
	[1][1][RTW89_WW][6] = 0,
	[1][1][RTW89_WW][8] = 0,
	[1][1][RTW89_WW][10] = 0,
	[1][1][RTW89_WW][12] = 0,
	[1][1][RTW89_WW][14] = 0,
	[1][1][RTW89_WW][15] = 0,
	[1][1][RTW89_WW][17] = 0,
	[1][1][RTW89_WW][19] = 0,
	[1][1][RTW89_WW][21] = 0,
	[1][1][RTW89_WW][23] = 0,
	[1][1][RTW89_WW][25] = 0,
	[1][1][RTW89_WW][27] = 0,
	[1][1][RTW89_WW][29] = 0,
	[1][1][RTW89_WW][31] = 0,
	[1][1][RTW89_WW][33] = 0,
	[1][1][RTW89_WW][35] = 0,
	[1][1][RTW89_WW][37] = 0,
	[1][1][RTW89_WW][38] = 0,
	[1][1][RTW89_WW][40] = 0,
	[1][1][RTW89_WW][42] = 0,
	[1][1][RTW89_WW][44] = 0,
	[1][1][RTW89_WW][46] = 0,
	[1][1][RTW89_WW][48] = 0,
	[1][1][RTW89_WW][50] = 0,
	[1][1][RTW89_WW][52] = 0,
	[2][0][RTW89_WW][0] = 40,
	[2][0][RTW89_WW][2] = 40,
	[2][0][RTW89_WW][4] = 40,
	[2][0][RTW89_WW][6] = 40,
	[2][0][RTW89_WW][8] = 40,
	[2][0][RTW89_WW][10] = 40,
	[2][0][RTW89_WW][12] = 40,
	[2][0][RTW89_WW][14] = 40,
	[2][0][RTW89_WW][15] = 46,
	[2][0][RTW89_WW][17] = 46,
	[2][0][RTW89_WW][19] = 46,
	[2][0][RTW89_WW][21] = 46,
	[2][0][RTW89_WW][23] = 46,
	[2][0][RTW89_WW][25] = 46,
	[2][0][RTW89_WW][27] = 46,
	[2][0][RTW89_WW][29] = 46,
	[2][0][RTW89_WW][31] = 46,
	[2][0][RTW89_WW][33] = 46,
	[2][0][RTW89_WW][35] = 46,
	[2][0][RTW89_WW][37] = 66,
	[2][0][RTW89_WW][38] = 28,
	[2][0][RTW89_WW][40] = 28,
	[2][0][RTW89_WW][42] = 28,
	[2][0][RTW89_WW][44] = 28,
	[2][0][RTW89_WW][46] = 28,
	[2][0][RTW89_WW][48] = 62,
	[2][0][RTW89_WW][50] = 62,
	[2][0][RTW89_WW][52] = 60,
	[2][1][RTW89_WW][0] = 0,
	[2][1][RTW89_WW][2] = 0,
	[2][1][RTW89_WW][4] = 0,
	[2][1][RTW89_WW][6] = 0,
	[2][1][RTW89_WW][8] = 0,
	[2][1][RTW89_WW][10] = 0,
	[2][1][RTW89_WW][12] = 0,
	[2][1][RTW89_WW][14] = 0,
	[2][1][RTW89_WW][15] = 0,
	[2][1][RTW89_WW][17] = 0,
	[2][1][RTW89_WW][19] = 0,
	[2][1][RTW89_WW][21] = 0,
	[2][1][RTW89_WW][23] = 0,
	[2][1][RTW89_WW][25] = 0,
	[2][1][RTW89_WW][27] = 0,
	[2][1][RTW89_WW][29] = 0,
	[2][1][RTW89_WW][31] = 0,
	[2][1][RTW89_WW][33] = 0,
	[2][1][RTW89_WW][35] = 0,
	[2][1][RTW89_WW][37] = 0,
	[2][1][RTW89_WW][38] = 0,
	[2][1][RTW89_WW][40] = 0,
	[2][1][RTW89_WW][42] = 0,
	[2][1][RTW89_WW][44] = 0,
	[2][1][RTW89_WW][46] = 0,
	[2][1][RTW89_WW][48] = 0,
	[2][1][RTW89_WW][50] = 0,
	[2][1][RTW89_WW][52] = 0,
	[0][0][RTW89_FCC][0] = 50,
	[0][0][RTW89_ETSI][0] = 24,
	[0][0][RTW89_MKK][0] = 26,
	[0][0][RTW89_IC][0] = 28,
	[0][0][RTW89_KCC][0] = 42,
	[0][0][RTW89_ACMA][0] = 24,
	[0][0][RTW89_CN][0] = 16,
	[0][0][RTW89_UK][0] = 24,
	[0][0][RTW89_FCC][2] = 54,
	[0][0][RTW89_ETSI][2] = 24,
	[0][0][RTW89_MKK][2] = 26,
	[0][0][RTW89_IC][2] = 28,
	[0][0][RTW89_KCC][2] = 42,
	[0][0][RTW89_ACMA][2] = 24,
	[0][0][RTW89_CN][2] = 16,
	[0][0][RTW89_UK][2] = 24,
	[0][0][RTW89_FCC][4] = 50,
	[0][0][RTW89_ETSI][4] = 24,
	[0][0][RTW89_MKK][4] = 26,
	[0][0][RTW89_IC][4] = 28,
	[0][0][RTW89_KCC][4] = 42,
	[0][0][RTW89_ACMA][4] = 24,
	[0][0][RTW89_CN][4] = 16,
	[0][0][RTW89_UK][4] = 24,
	[0][0][RTW89_FCC][6] = 50,
	[0][0][RTW89_ETSI][6] = 24,
	[0][0][RTW89_MKK][6] = 26,
	[0][0][RTW89_IC][6] = 28,
	[0][0][RTW89_KCC][6] = 18,
	[0][0][RTW89_ACMA][6] = 24,
	[0][0][RTW89_CN][6] = 16,
	[0][0][RTW89_UK][6] = 24,
	[0][0][RTW89_FCC][8] = 52,
	[0][0][RTW89_ETSI][8] = 24,
	[0][0][RTW89_MKK][8] = 26,
	[0][0][RTW89_IC][8] = 52,
	[0][0][RTW89_KCC][8] = 42,
	[0][0][RTW89_ACMA][8] = 24,
	[0][0][RTW89_CN][8] = 16,
	[0][0][RTW89_UK][8] = 24,
	[0][0][RTW89_FCC][10] = 52,
	[0][0][RTW89_ETSI][10] = 24,
	[0][0][RTW89_MKK][10] = 26,
	[0][0][RTW89_IC][10] = 52,
	[0][0][RTW89_KCC][10] = 42,
	[0][0][RTW89_ACMA][10] = 24,
	[0][0][RTW89_CN][10] = 16,
	[0][0][RTW89_UK][10] = 24,
	[0][0][RTW89_FCC][12] = 56,
	[0][0][RTW89_ETSI][12] = 24,
	[0][0][RTW89_MKK][12] = 26,
	[0][0][RTW89_IC][12] = 56,
	[0][0][RTW89_KCC][12] = 44,
	[0][0][RTW89_ACMA][12] = 24,
	[0][0][RTW89_CN][12] = 16,
	[0][0][RTW89_UK][12] = 24,
	[0][0][RTW89_FCC][14] = 56,
	[0][0][RTW89_ETSI][14] = 24,
	[0][0][RTW89_MKK][14] = 26,
	[0][0][RTW89_IC][14] = 56,
	[0][0][RTW89_KCC][14] = 44,
	[0][0][RTW89_ACMA][14] = 24,
	[0][0][RTW89_CN][14] = 16,
	[0][0][RTW89_UK][14] = 24,
	[0][0][RTW89_FCC][15] = 52,
	[0][0][RTW89_ETSI][15] = 24,
	[0][0][RTW89_MKK][15] = 46,
	[0][0][RTW89_IC][15] = 52,
	[0][0][RTW89_KCC][15] = 44,
	[0][0][RTW89_ACMA][15] = 24,
	[0][0][RTW89_CN][15] = 127,
	[0][0][RTW89_UK][15] = 24,
	[0][0][RTW89_FCC][17] = 52,
	[0][0][RTW89_ETSI][17] = 24,
	[0][0][RTW89_MKK][17] = 50,
	[0][0][RTW89_IC][17] = 52,
	[0][0][RTW89_KCC][17] = 44,
	[0][0][RTW89_ACMA][17] = 24,
	[0][0][RTW89_CN][17] = 127,
	[0][0][RTW89_UK][17] = 24,
	[0][0][RTW89_FCC][19] = 52,
	[0][0][RTW89_ETSI][19] = 24,
	[0][0][RTW89_MKK][19] = 50,
	[0][0][RTW89_IC][19] = 52,
	[0][0][RTW89_KCC][19] = 44,
	[0][0][RTW89_ACMA][19] = 24,
	[0][0][RTW89_CN][19] = 127,
	[0][0][RTW89_UK][19] = 24,
	[0][0][RTW89_FCC][21] = 52,
	[0][0][RTW89_ETSI][21] = 24,
	[0][0][RTW89_MKK][21] = 50,
	[0][0][RTW89_IC][21] = 52,
	[0][0][RTW89_KCC][21] = 44,
	[0][0][RTW89_ACMA][21] = 24,
	[0][0][RTW89_CN][21] = 127,
	[0][0][RTW89_UK][21] = 24,
	[0][0][RTW89_FCC][23] = 52,
	[0][0][RTW89_ETSI][23] = 24,
	[0][0][RTW89_MKK][23] = 50,
	[0][0][RTW89_IC][23] = 52,
	[0][0][RTW89_KCC][23] = 44,
	[0][0][RTW89_ACMA][23] = 24,
	[0][0][RTW89_CN][23] = 127,
	[0][0][RTW89_UK][23] = 24,
	[0][0][RTW89_FCC][25] = 52,
	[0][0][RTW89_ETSI][25] = 24,
	[0][0][RTW89_MKK][25] = 50,
	[0][0][RTW89_IC][25] = 127,
	[0][0][RTW89_KCC][25] = 44,
	[0][0][RTW89_ACMA][25] = 127,
	[0][0][RTW89_CN][25] = 127,
	[0][0][RTW89_UK][25] = 24,
	[0][0][RTW89_FCC][27] = 52,
	[0][0][RTW89_ETSI][27] = 24,
	[0][0][RTW89_MKK][27] = 50,
	[0][0][RTW89_IC][27] = 127,
	[0][0][RTW89_KCC][27] = 42,
	[0][0][RTW89_ACMA][27] = 127,
	[0][0][RTW89_CN][27] = 127,
	[0][0][RTW89_UK][27] = 24,
	[0][0][RTW89_FCC][29] = 52,
	[0][0][RTW89_ETSI][29] = 24,
	[0][0][RTW89_MKK][29] = 50,
	[0][0][RTW89_IC][29] = 127,
	[0][0][RTW89_KCC][29] = 42,
	[0][0][RTW89_ACMA][29] = 127,
	[0][0][RTW89_CN][29] = 127,
	[0][0][RTW89_UK][29] = 24,
	[0][0][RTW89_FCC][31] = 52,
	[0][0][RTW89_ETSI][31] = 24,
	[0][0][RTW89_MKK][31] = 50,
	[0][0][RTW89_IC][31] = 56,
	[0][0][RTW89_KCC][31] = 42,
	[0][0][RTW89_ACMA][31] = 24,
	[0][0][RTW89_CN][31] = 127,
	[0][0][RTW89_UK][31] = 24,
	[0][0][RTW89_FCC][33] = 56,
	[0][0][RTW89_ETSI][33] = 24,
	[0][0][RTW89_MKK][33] = 50,
	[0][0][RTW89_IC][33] = 56,
	[0][0][RTW89_KCC][33] = 42,
	[0][0][RTW89_ACMA][33] = 24,
	[0][0][RTW89_CN][33] = 127,
	[0][0][RTW89_UK][33] = 24,
	[0][0][RTW89_FCC][35] = 56,
	[0][0][RTW89_ETSI][35] = 24,
	[0][0][RTW89_MKK][35] = 50,
	[0][0][RTW89_IC][35] = 56,
	[0][0][RTW89_KCC][35] = 42,
	[0][0][RTW89_ACMA][35] = 24,
	[0][0][RTW89_CN][35] = 127,
	[0][0][RTW89_UK][35] = 24,
	[0][0][RTW89_FCC][37] = 84,
	[0][0][RTW89_ETSI][37] = 127,
	[0][0][RTW89_MKK][37] = 46,
	[0][0][RTW89_IC][37] = 84,
	[0][0][RTW89_KCC][37] = 44,
	[0][0][RTW89_ACMA][37] = 50,
	[0][0][RTW89_CN][37] = 127,
	[0][0][RTW89_UK][37] = 52,
	[0][0][RTW89_FCC][38] = 68,
	[0][0][RTW89_ETSI][38] = 28,
	[0][0][RTW89_MKK][38] = 127,
	[0][0][RTW89_IC][38] = 68,
	[0][0][RTW89_KCC][38] = 44,
	[0][0][RTW89_ACMA][38] = 84,
	[0][0][RTW89_CN][38] = 54,
	[0][0][RTW89_UK][38] = 24,
	[0][0][RTW89_FCC][40] = 68,
	[0][0][RTW89_ETSI][40] = 28,
	[0][0][RTW89_MKK][40] = 127,
	[0][0][RTW89_IC][40] = 68,
	[0][0][RTW89_KCC][40] = 44,
	[0][0][RTW89_ACMA][40] = 84,
	[0][0][RTW89_CN][40] = 54,
	[0][0][RTW89_UK][40] = 24,
	[0][0][RTW89_FCC][42] = 70,
	[0][0][RTW89_ETSI][42] = 28,
	[0][0][RTW89_MKK][42] = 127,
	[0][0][RTW89_IC][42] = 70,
	[0][0][RTW89_KCC][42] = 44,
	[0][0][RTW89_ACMA][42] = 84,
	[0][0][RTW89_CN][42] = 54,
	[0][0][RTW89_UK][42] = 24,
	[0][0][RTW89_FCC][44] = 62,
	[0][0][RTW89_ETSI][44] = 28,
	[0][0][RTW89_MKK][44] = 127,
	[0][0][RTW89_IC][44] = 62,
	[0][0][RTW89_KCC][44] = 44,
	[0][0][RTW89_ACMA][44] = 84,
	[0][0][RTW89_CN][44] = 54,
	[0][0][RTW89_UK][44] = 24,
	[0][0][RTW89_FCC][46] = 62,
	[0][0][RTW89_ETSI][46] = 28,
	[0][0][RTW89_MKK][46] = 127,
	[0][0][RTW89_IC][46] = 62,
	[0][0][RTW89_KCC][46] = 44,
	[0][0][RTW89_ACMA][46] = 84,
	[0][0][RTW89_CN][46] = 54,
	[0][0][RTW89_UK][46] = 24,
	[0][0][RTW89_FCC][48] = 40,
	[0][0][RTW89_ETSI][48] = 127,
	[0][0][RTW89_MKK][48] = 127,
	[0][0][RTW89_IC][48] = 127,
	[0][0][RTW89_KCC][48] = 127,
	[0][0][RTW89_ACMA][48] = 127,
	[0][0][RTW89_CN][48] = 127,
	[0][0][RTW89_UK][48] = 127,
	[0][0][RTW89_FCC][50] = 42,
	[0][0][RTW89_ETSI][50] = 127,
	[0][0][RTW89_MKK][50] = 127,
	[0][0][RTW89_IC][50] = 127,
	[0][0][RTW89_KCC][50] = 127,
	[0][0][RTW89_ACMA][50] = 127,
	[0][0][RTW89_CN][50] = 127,
	[0][0][RTW89_UK][50] = 127,
	[0][0][RTW89_FCC][52] = 38,
	[0][0][RTW89_ETSI][52] = 127,
	[0][0][RTW89_MKK][52] = 127,
	[0][0][RTW89_IC][52] = 127,
	[0][0][RTW89_KCC][52] = 127,
	[0][0][RTW89_ACMA][52] = 127,
	[0][0][RTW89_CN][52] = 127,
	[0][0][RTW89_UK][52] = 127,
	[0][1][RTW89_FCC][0] = 127,
	[0][1][RTW89_ETSI][0] = 127,
	[0][1][RTW89_MKK][0] = 127,
	[0][1][RTW89_IC][0] = 127,
	[0][1][RTW89_KCC][0] = 127,
	[0][1][RTW89_ACMA][0] = 127,
	[0][1][RTW89_CN][0] = 127,
	[0][1][RTW89_UK][0] = 127,
	[0][1][RTW89_FCC][2] = 127,
	[0][1][RTW89_ETSI][2] = 127,
	[0][1][RTW89_MKK][2] = 127,
	[0][1][RTW89_IC][2] = 127,
	[0][1][RTW89_KCC][2] = 127,
	[0][1][RTW89_ACMA][2] = 127,
	[0][1][RTW89_CN][2] = 127,
	[0][1][RTW89_UK][2] = 127,
	[0][1][RTW89_FCC][4] = 127,
	[0][1][RTW89_ETSI][4] = 127,
	[0][1][RTW89_MKK][4] = 127,
	[0][1][RTW89_IC][4] = 127,
	[0][1][RTW89_KCC][4] = 127,
	[0][1][RTW89_ACMA][4] = 127,
	[0][1][RTW89_CN][4] = 127,
	[0][1][RTW89_UK][4] = 127,
	[0][1][RTW89_FCC][6] = 127,
	[0][1][RTW89_ETSI][6] = 127,
	[0][1][RTW89_MKK][6] = 127,
	[0][1][RTW89_IC][6] = 127,
	[0][1][RTW89_KCC][6] = 127,
	[0][1][RTW89_ACMA][6] = 127,
	[0][1][RTW89_CN][6] = 127,
	[0][1][RTW89_UK][6] = 127,
	[0][1][RTW89_FCC][8] = 127,
	[0][1][RTW89_ETSI][8] = 127,
	[0][1][RTW89_MKK][8] = 127,
	[0][1][RTW89_IC][8] = 127,
	[0][1][RTW89_KCC][8] = 127,
	[0][1][RTW89_ACMA][8] = 127,
	[0][1][RTW89_CN][8] = 127,
	[0][1][RTW89_UK][8] = 127,
	[0][1][RTW89_FCC][10] = 127,
	[0][1][RTW89_ETSI][10] = 127,
	[0][1][RTW89_MKK][10] = 127,
	[0][1][RTW89_IC][10] = 127,
	[0][1][RTW89_KCC][10] = 127,
	[0][1][RTW89_ACMA][10] = 127,
	[0][1][RTW89_CN][10] = 127,
	[0][1][RTW89_UK][10] = 127,
	[0][1][RTW89_FCC][12] = 127,
	[0][1][RTW89_ETSI][12] = 127,
	[0][1][RTW89_MKK][12] = 127,
	[0][1][RTW89_IC][12] = 127,
	[0][1][RTW89_KCC][12] = 127,
	[0][1][RTW89_ACMA][12] = 127,
	[0][1][RTW89_CN][12] = 127,
	[0][1][RTW89_UK][12] = 127,
	[0][1][RTW89_FCC][14] = 127,
	[0][1][RTW89_ETSI][14] = 127,
	[0][1][RTW89_MKK][14] = 127,
	[0][1][RTW89_IC][14] = 127,
	[0][1][RTW89_KCC][14] = 127,
	[0][1][RTW89_ACMA][14] = 127,
	[0][1][RTW89_CN][14] = 127,
	[0][1][RTW89_UK][14] = 127,
	[0][1][RTW89_FCC][15] = 127,
	[0][1][RTW89_ETSI][15] = 127,
	[0][1][RTW89_MKK][15] = 127,
	[0][1][RTW89_IC][15] = 127,
	[0][1][RTW89_KCC][15] = 127,
	[0][1][RTW89_ACMA][15] = 127,
	[0][1][RTW89_CN][15] = 127,
	[0][1][RTW89_UK][15] = 127,
	[0][1][RTW89_FCC][17] = 127,
	[0][1][RTW89_ETSI][17] = 127,
	[0][1][RTW89_MKK][17] = 127,
	[0][1][RTW89_IC][17] = 127,
	[0][1][RTW89_KCC][17] = 127,
	[0][1][RTW89_ACMA][17] = 127,
	[0][1][RTW89_CN][17] = 127,
	[0][1][RTW89_UK][17] = 127,
	[0][1][RTW89_FCC][19] = 127,
	[0][1][RTW89_ETSI][19] = 127,
	[0][1][RTW89_MKK][19] = 127,
	[0][1][RTW89_IC][19] = 127,
	[0][1][RTW89_KCC][19] = 127,
	[0][1][RTW89_ACMA][19] = 127,
	[0][1][RTW89_CN][19] = 127,
	[0][1][RTW89_UK][19] = 127,
	[0][1][RTW89_FCC][21] = 127,
	[0][1][RTW89_ETSI][21] = 127,
	[0][1][RTW89_MKK][21] = 127,
	[0][1][RTW89_IC][21] = 127,
	[0][1][RTW89_KCC][21] = 127,
	[0][1][RTW89_ACMA][21] = 127,
	[0][1][RTW89_CN][21] = 127,
	[0][1][RTW89_UK][21] = 127,
	[0][1][RTW89_FCC][23] = 127,
	[0][1][RTW89_ETSI][23] = 127,
	[0][1][RTW89_MKK][23] = 127,
	[0][1][RTW89_IC][23] = 127,
	[0][1][RTW89_KCC][23] = 127,
	[0][1][RTW89_ACMA][23] = 127,
	[0][1][RTW89_CN][23] = 127,
	[0][1][RTW89_UK][23] = 127,
	[0][1][RTW89_FCC][25] = 127,
	[0][1][RTW89_ETSI][25] = 127,
	[0][1][RTW89_MKK][25] = 127,
	[0][1][RTW89_IC][25] = 127,
	[0][1][RTW89_KCC][25] = 127,
	[0][1][RTW89_ACMA][25] = 127,
	[0][1][RTW89_CN][25] = 127,
	[0][1][RTW89_UK][25] = 127,
	[0][1][RTW89_FCC][27] = 127,
	[0][1][RTW89_ETSI][27] = 127,
	[0][1][RTW89_MKK][27] = 127,
	[0][1][RTW89_IC][27] = 127,
	[0][1][RTW89_KCC][27] = 127,
	[0][1][RTW89_ACMA][27] = 127,
	[0][1][RTW89_CN][27] = 127,
	[0][1][RTW89_UK][27] = 127,
	[0][1][RTW89_FCC][29] = 127,
	[0][1][RTW89_ETSI][29] = 127,
	[0][1][RTW89_MKK][29] = 127,
	[0][1][RTW89_IC][29] = 127,
	[0][1][RTW89_KCC][29] = 127,
	[0][1][RTW89_ACMA][29] = 127,
	[0][1][RTW89_CN][29] = 127,
	[0][1][RTW89_UK][29] = 127,
	[0][1][RTW89_FCC][31] = 127,
	[0][1][RTW89_ETSI][31] = 127,
	[0][1][RTW89_MKK][31] = 127,
	[0][1][RTW89_IC][31] = 127,
	[0][1][RTW89_KCC][31] = 127,
	[0][1][RTW89_ACMA][31] = 127,
	[0][1][RTW89_CN][31] = 127,
	[0][1][RTW89_UK][31] = 127,
	[0][1][RTW89_FCC][33] = 127,
	[0][1][RTW89_ETSI][33] = 127,
	[0][1][RTW89_MKK][33] = 127,
	[0][1][RTW89_IC][33] = 127,
	[0][1][RTW89_KCC][33] = 127,
	[0][1][RTW89_ACMA][33] = 127,
	[0][1][RTW89_CN][33] = 127,
	[0][1][RTW89_UK][33] = 127,
	[0][1][RTW89_FCC][35] = 127,
	[0][1][RTW89_ETSI][35] = 127,
	[0][1][RTW89_MKK][35] = 127,
	[0][1][RTW89_IC][35] = 127,
	[0][1][RTW89_KCC][35] = 127,
	[0][1][RTW89_ACMA][35] = 127,
	[0][1][RTW89_CN][35] = 127,
	[0][1][RTW89_UK][35] = 127,
	[0][1][RTW89_FCC][37] = 127,
	[0][1][RTW89_ETSI][37] = 127,
	[0][1][RTW89_MKK][37] = 127,
	[0][1][RTW89_IC][37] = 127,
	[0][1][RTW89_KCC][37] = 127,
	[0][1][RTW89_ACMA][37] = 127,
	[0][1][RTW89_CN][37] = 127,
	[0][1][RTW89_UK][37] = 127,
	[0][1][RTW89_FCC][38] = 127,
	[0][1][RTW89_ETSI][38] = 127,
	[0][1][RTW89_MKK][38] = 127,
	[0][1][RTW89_IC][38] = 127,
	[0][1][RTW89_KCC][38] = 127,
	[0][1][RTW89_ACMA][38] = 127,
	[0][1][RTW89_CN][38] = 127,
	[0][1][RTW89_UK][38] = 127,
	[0][1][RTW89_FCC][40] = 127,
	[0][1][RTW89_ETSI][40] = 127,
	[0][1][RTW89_MKK][40] = 127,
	[0][1][RTW89_IC][40] = 127,
	[0][1][RTW89_KCC][40] = 127,
	[0][1][RTW89_ACMA][40] = 127,
	[0][1][RTW89_CN][40] = 127,
	[0][1][RTW89_UK][40] = 127,
	[0][1][RTW89_FCC][42] = 127,
	[0][1][RTW89_ETSI][42] = 127,
	[0][1][RTW89_MKK][42] = 127,
	[0][1][RTW89_IC][42] = 127,
	[0][1][RTW89_KCC][42] = 127,
	[0][1][RTW89_ACMA][42] = 127,
	[0][1][RTW89_CN][42] = 127,
	[0][1][RTW89_UK][42] = 127,
	[0][1][RTW89_FCC][44] = 127,
	[0][1][RTW89_ETSI][44] = 127,
	[0][1][RTW89_MKK][44] = 127,
	[0][1][RTW89_IC][44] = 127,
	[0][1][RTW89_KCC][44] = 127,
	[0][1][RTW89_ACMA][44] = 127,
	[0][1][RTW89_CN][44] = 127,
	[0][1][RTW89_UK][44] = 127,
	[0][1][RTW89_FCC][46] = 127,
	[0][1][RTW89_ETSI][46] = 127,
	[0][1][RTW89_MKK][46] = 127,
	[0][1][RTW89_IC][46] = 127,
	[0][1][RTW89_KCC][46] = 127,
	[0][1][RTW89_ACMA][46] = 127,
	[0][1][RTW89_CN][46] = 127,
	[0][1][RTW89_UK][46] = 127,
	[0][1][RTW89_FCC][48] = 127,
	[0][1][RTW89_ETSI][48] = 127,
	[0][1][RTW89_MKK][48] = 127,
	[0][1][RTW89_IC][48] = 127,
	[0][1][RTW89_KCC][48] = 127,
	[0][1][RTW89_ACMA][48] = 127,
	[0][1][RTW89_CN][48] = 127,
	[0][1][RTW89_UK][48] = 127,
	[0][1][RTW89_FCC][50] = 127,
	[0][1][RTW89_ETSI][50] = 127,
	[0][1][RTW89_MKK][50] = 127,
	[0][1][RTW89_IC][50] = 127,
	[0][1][RTW89_KCC][50] = 127,
	[0][1][RTW89_ACMA][50] = 127,
	[0][1][RTW89_CN][50] = 127,
	[0][1][RTW89_UK][50] = 127,
	[0][1][RTW89_FCC][52] = 127,
	[0][1][RTW89_ETSI][52] = 127,
	[0][1][RTW89_MKK][52] = 127,
	[0][1][RTW89_IC][52] = 127,
	[0][1][RTW89_KCC][52] = 127,
	[0][1][RTW89_ACMA][52] = 127,
	[0][1][RTW89_CN][52] = 127,
	[0][1][RTW89_UK][52] = 127,
	[1][0][RTW89_FCC][0] = 64,
	[1][0][RTW89_ETSI][0] = 34,
	[1][0][RTW89_MKK][0] = 38,
	[1][0][RTW89_IC][0] = 38,
	[1][0][RTW89_KCC][0] = 52,
	[1][0][RTW89_ACMA][0] = 34,
	[1][0][RTW89_CN][0] = 26,
	[1][0][RTW89_UK][0] = 34,
	[1][0][RTW89_FCC][2] = 66,
	[1][0][RTW89_ETSI][2] = 34,
	[1][0][RTW89_MKK][2] = 38,
	[1][0][RTW89_IC][2] = 38,
	[1][0][RTW89_KCC][2] = 52,
	[1][0][RTW89_ACMA][2] = 34,
	[1][0][RTW89_CN][2] = 26,
	[1][0][RTW89_UK][2] = 34,
	[1][0][RTW89_FCC][4] = 60,
	[1][0][RTW89_ETSI][4] = 34,
	[1][0][RTW89_MKK][4] = 36,
	[1][0][RTW89_IC][4] = 38,
	[1][0][RTW89_KCC][4] = 52,
	[1][0][RTW89_ACMA][4] = 34,
	[1][0][RTW89_CN][4] = 26,
	[1][0][RTW89_UK][4] = 34,
	[1][0][RTW89_FCC][6] = 60,
	[1][0][RTW89_ETSI][6] = 34,
	[1][0][RTW89_MKK][6] = 36,
	[1][0][RTW89_IC][6] = 38,
	[1][0][RTW89_KCC][6] = 32,
	[1][0][RTW89_ACMA][6] = 34,
	[1][0][RTW89_CN][6] = 26,
	[1][0][RTW89_UK][6] = 34,
	[1][0][RTW89_FCC][8] = 62,
	[1][0][RTW89_ETSI][8] = 34,
	[1][0][RTW89_MKK][8] = 38,
	[1][0][RTW89_IC][8] = 62,
	[1][0][RTW89_KCC][8] = 52,
	[1][0][RTW89_ACMA][8] = 34,
	[1][0][RTW89_CN][8] = 26,
	[1][0][RTW89_UK][8] = 34,
	[1][0][RTW89_FCC][10] = 62,
	[1][0][RTW89_ETSI][10] = 34,
	[1][0][RTW89_MKK][10] = 38,
	[1][0][RTW89_IC][10] = 62,
	[1][0][RTW89_KCC][10] = 52,
	[1][0][RTW89_ACMA][10] = 34,
	[1][0][RTW89_CN][10] = 26,
	[1][0][RTW89_UK][10] = 34,
	[1][0][RTW89_FCC][12] = 62,
	[1][0][RTW89_ETSI][12] = 34,
	[1][0][RTW89_MKK][12] = 38,
	[1][0][RTW89_IC][12] = 62,
	[1][0][RTW89_KCC][12] = 54,
	[1][0][RTW89_ACMA][12] = 34,
	[1][0][RTW89_CN][12] = 26,
	[1][0][RTW89_UK][12] = 34,
	[1][0][RTW89_FCC][14] = 62,
	[1][0][RTW89_ETSI][14] = 34,
	[1][0][RTW89_MKK][14] = 38,
	[1][0][RTW89_IC][14] = 62,
	[1][0][RTW89_KCC][14] = 54,
	[1][0][RTW89_ACMA][14] = 34,
	[1][0][RTW89_CN][14] = 26,
	[1][0][RTW89_UK][14] = 34,
	[1][0][RTW89_FCC][15] = 60,
	[1][0][RTW89_ETSI][15] = 34,
	[1][0][RTW89_MKK][15] = 58,
	[1][0][RTW89_IC][15] = 60,
	[1][0][RTW89_KCC][15] = 54,
	[1][0][RTW89_ACMA][15] = 34,
	[1][0][RTW89_CN][15] = 127,
	[1][0][RTW89_UK][15] = 34,
	[1][0][RTW89_FCC][17] = 60,
	[1][0][RTW89_ETSI][17] = 34,
	[1][0][RTW89_MKK][17] = 58,
	[1][0][RTW89_IC][17] = 60,
	[1][0][RTW89_KCC][17] = 54,
	[1][0][RTW89_ACMA][17] = 34,
	[1][0][RTW89_CN][17] = 127,
	[1][0][RTW89_UK][17] = 34,
	[1][0][RTW89_FCC][19] = 62,
	[1][0][RTW89_ETSI][19] = 34,
	[1][0][RTW89_MKK][19] = 58,
	[1][0][RTW89_IC][19] = 62,
	[1][0][RTW89_KCC][19] = 54,
	[1][0][RTW89_ACMA][19] = 34,
	[1][0][RTW89_CN][19] = 127,
	[1][0][RTW89_UK][19] = 34,
	[1][0][RTW89_FCC][21] = 62,
	[1][0][RTW89_ETSI][21] = 34,
	[1][0][RTW89_MKK][21] = 58,
	[1][0][RTW89_IC][21] = 62,
	[1][0][RTW89_KCC][21] = 54,
	[1][0][RTW89_ACMA][21] = 34,
	[1][0][RTW89_CN][21] = 127,
	[1][0][RTW89_UK][21] = 34,
	[1][0][RTW89_FCC][23] = 62,
	[1][0][RTW89_ETSI][23] = 34,
	[1][0][RTW89_MKK][23] = 58,
	[1][0][RTW89_IC][23] = 62,
	[1][0][RTW89_KCC][23] = 54,
	[1][0][RTW89_ACMA][23] = 34,
	[1][0][RTW89_CN][23] = 127,
	[1][0][RTW89_UK][23] = 34,
	[1][0][RTW89_FCC][25] = 62,
	[1][0][RTW89_ETSI][25] = 34,
	[1][0][RTW89_MKK][25] = 58,
	[1][0][RTW89_IC][25] = 127,
	[1][0][RTW89_KCC][25] = 54,
	[1][0][RTW89_ACMA][25] = 127,
	[1][0][RTW89_CN][25] = 127,
	[1][0][RTW89_UK][25] = 34,
	[1][0][RTW89_FCC][27] = 62,
	[1][0][RTW89_ETSI][27] = 34,
	[1][0][RTW89_MKK][27] = 58,
	[1][0][RTW89_IC][27] = 127,
	[1][0][RTW89_KCC][27] = 54,
	[1][0][RTW89_ACMA][27] = 127,
	[1][0][RTW89_CN][27] = 127,
	[1][0][RTW89_UK][27] = 34,
	[1][0][RTW89_FCC][29] = 62,
	[1][0][RTW89_ETSI][29] = 34,
	[1][0][RTW89_MKK][29] = 58,
	[1][0][RTW89_IC][29] = 127,
	[1][0][RTW89_KCC][29] = 54,
	[1][0][RTW89_ACMA][29] = 127,
	[1][0][RTW89_CN][29] = 127,
	[1][0][RTW89_UK][29] = 34,
	[1][0][RTW89_FCC][31] = 62,
	[1][0][RTW89_ETSI][31] = 34,
	[1][0][RTW89_MKK][31] = 58,
	[1][0][RTW89_IC][31] = 64,
	[1][0][RTW89_KCC][31] = 54,
	[1][0][RTW89_ACMA][31] = 34,
	[1][0][RTW89_CN][31] = 127,
	[1][0][RTW89_UK][31] = 34,
	[1][0][RTW89_FCC][33] = 64,
	[1][0][RTW89_ETSI][33] = 34,
	[1][0][RTW89_MKK][33] = 58,
	[1][0][RTW89_IC][33] = 64,
	[1][0][RTW89_KCC][33] = 54,
	[1][0][RTW89_ACMA][33] = 34,
	[1][0][RTW89_CN][33] = 127,
	[1][0][RTW89_UK][33] = 34,
	[1][0][RTW89_FCC][35] = 64,
	[1][0][RTW89_ETSI][35] = 34,
	[1][0][RTW89_MKK][35] = 58,
	[1][0][RTW89_IC][35] = 64,
	[1][0][RTW89_KCC][35] = 54,
	[1][0][RTW89_ACMA][35] = 34,
	[1][0][RTW89_CN][35] = 127,
	[1][0][RTW89_UK][35] = 34,
	[1][0][RTW89_FCC][37] = 76,
	[1][0][RTW89_ETSI][37] = 127,
	[1][0][RTW89_MKK][37] = 56,
	[1][0][RTW89_IC][37] = 76,
	[1][0][RTW89_KCC][37] = 54,
	[1][0][RTW89_ACMA][37] = 62,
	[1][0][RTW89_CN][37] = 127,
	[1][0][RTW89_UK][37] = 62,
	[1][0][RTW89_FCC][38] = 82,
	[1][0][RTW89_ETSI][38] = 28,
	[1][0][RTW89_MKK][38] = 127,
	[1][0][RTW89_IC][38] = 82,
	[1][0][RTW89_KCC][38] = 54,
	[1][0][RTW89_ACMA][38] = 84,
	[1][0][RTW89_CN][38] = 66,
	[1][0][RTW89_UK][38] = 34,
	[1][0][RTW89_FCC][40] = 82,
	[1][0][RTW89_ETSI][40] = 28,
	[1][0][RTW89_MKK][40] = 127,
	[1][0][RTW89_IC][40] = 82,
	[1][0][RTW89_KCC][40] = 54,
	[1][0][RTW89_ACMA][40] = 84,
	[1][0][RTW89_CN][40] = 66,
	[1][0][RTW89_UK][40] = 34,
	[1][0][RTW89_FCC][42] = 78,
	[1][0][RTW89_ETSI][42] = 28,
	[1][0][RTW89_MKK][42] = 127,
	[1][0][RTW89_IC][42] = 78,
	[1][0][RTW89_KCC][42] = 54,
	[1][0][RTW89_ACMA][42] = 84,
	[1][0][RTW89_CN][42] = 66,
	[1][0][RTW89_UK][42] = 34,
	[1][0][RTW89_FCC][44] = 82,
	[1][0][RTW89_ETSI][44] = 28,
	[1][0][RTW89_MKK][44] = 127,
	[1][0][RTW89_IC][44] = 82,
	[1][0][RTW89_KCC][44] = 54,
	[1][0][RTW89_ACMA][44] = 84,
	[1][0][RTW89_CN][44] = 66,
	[1][0][RTW89_UK][44] = 34,
	[1][0][RTW89_FCC][46] = 82,
	[1][0][RTW89_ETSI][46] = 28,
	[1][0][RTW89_MKK][46] = 127,
	[1][0][RTW89_IC][46] = 82,
	[1][0][RTW89_KCC][46] = 54,
	[1][0][RTW89_ACMA][46] = 84,
	[1][0][RTW89_CN][46] = 66,
	[1][0][RTW89_UK][46] = 34,
	[1][0][RTW89_FCC][48] = 52,
	[1][0][RTW89_ETSI][48] = 127,
	[1][0][RTW89_MKK][48] = 127,
	[1][0][RTW89_IC][48] = 127,
	[1][0][RTW89_KCC][48] = 127,
	[1][0][RTW89_ACMA][48] = 127,
	[1][0][RTW89_CN][48] = 127,
	[1][0][RTW89_UK][48] = 127,
	[1][0][RTW89_FCC][50] = 52,
	[1][0][RTW89_ETSI][50] = 127,
	[1][0][RTW89_MKK][50] = 127,
	[1][0][RTW89_IC][50] = 127,
	[1][0][RTW89_KCC][50] = 127,
	[1][0][RTW89_ACMA][50] = 127,
	[1][0][RTW89_CN][50] = 127,
	[1][0][RTW89_UK][50] = 127,
	[1][0][RTW89_FCC][52] = 50,
	[1][0][RTW89_ETSI][52] = 127,
	[1][0][RTW89_MKK][52] = 127,
	[1][0][RTW89_IC][52] = 127,
	[1][0][RTW89_KCC][52] = 127,
	[1][0][RTW89_ACMA][52] = 127,
	[1][0][RTW89_CN][52] = 127,
	[1][0][RTW89_UK][52] = 127,
	[1][1][RTW89_FCC][0] = 127,
	[1][1][RTW89_ETSI][0] = 127,
	[1][1][RTW89_MKK][0] = 127,
	[1][1][RTW89_IC][0] = 127,
	[1][1][RTW89_KCC][0] = 127,
	[1][1][RTW89_ACMA][0] = 127,
	[1][1][RTW89_CN][0] = 127,
	[1][1][RTW89_UK][0] = 127,
	[1][1][RTW89_FCC][2] = 127,
	[1][1][RTW89_ETSI][2] = 127,
	[1][1][RTW89_MKK][2] = 127,
	[1][1][RTW89_IC][2] = 127,
	[1][1][RTW89_KCC][2] = 127,
	[1][1][RTW89_ACMA][2] = 127,
	[1][1][RTW89_CN][2] = 127,
	[1][1][RTW89_UK][2] = 127,
	[1][1][RTW89_FCC][4] = 127,
	[1][1][RTW89_ETSI][4] = 127,
	[1][1][RTW89_MKK][4] = 127,
	[1][1][RTW89_IC][4] = 127,
	[1][1][RTW89_KCC][4] = 127,
	[1][1][RTW89_ACMA][4] = 127,
	[1][1][RTW89_CN][4] = 127,
	[1][1][RTW89_UK][4] = 127,
	[1][1][RTW89_FCC][6] = 127,
	[1][1][RTW89_ETSI][6] = 127,
	[1][1][RTW89_MKK][6] = 127,
	[1][1][RTW89_IC][6] = 127,
	[1][1][RTW89_KCC][6] = 127,
	[1][1][RTW89_ACMA][6] = 127,
	[1][1][RTW89_CN][6] = 127,
	[1][1][RTW89_UK][6] = 127,
	[1][1][RTW89_FCC][8] = 127,
	[1][1][RTW89_ETSI][8] = 127,
	[1][1][RTW89_MKK][8] = 127,
	[1][1][RTW89_IC][8] = 127,
	[1][1][RTW89_KCC][8] = 127,
	[1][1][RTW89_ACMA][8] = 127,
	[1][1][RTW89_CN][8] = 127,
	[1][1][RTW89_UK][8] = 127,
	[1][1][RTW89_FCC][10] = 127,
	[1][1][RTW89_ETSI][10] = 127,
	[1][1][RTW89_MKK][10] = 127,
	[1][1][RTW89_IC][10] = 127,
	[1][1][RTW89_KCC][10] = 127,
	[1][1][RTW89_ACMA][10] = 127,
	[1][1][RTW89_CN][10] = 127,
	[1][1][RTW89_UK][10] = 127,
	[1][1][RTW89_FCC][12] = 127,
	[1][1][RTW89_ETSI][12] = 127,
	[1][1][RTW89_MKK][12] = 127,
	[1][1][RTW89_IC][12] = 127,
	[1][1][RTW89_KCC][12] = 127,
	[1][1][RTW89_ACMA][12] = 127,
	[1][1][RTW89_CN][12] = 127,
	[1][1][RTW89_UK][12] = 127,
	[1][1][RTW89_FCC][14] = 127,
	[1][1][RTW89_ETSI][14] = 127,
	[1][1][RTW89_MKK][14] = 127,
	[1][1][RTW89_IC][14] = 127,
	[1][1][RTW89_KCC][14] = 127,
	[1][1][RTW89_ACMA][14] = 127,
	[1][1][RTW89_CN][14] = 127,
	[1][1][RTW89_UK][14] = 127,
	[1][1][RTW89_FCC][15] = 127,
	[1][1][RTW89_ETSI][15] = 127,
	[1][1][RTW89_MKK][15] = 127,
	[1][1][RTW89_IC][15] = 127,
	[1][1][RTW89_KCC][15] = 127,
	[1][1][RTW89_ACMA][15] = 127,
	[1][1][RTW89_CN][15] = 127,
	[1][1][RTW89_UK][15] = 127,
	[1][1][RTW89_FCC][17] = 127,
	[1][1][RTW89_ETSI][17] = 127,
	[1][1][RTW89_MKK][17] = 127,
	[1][1][RTW89_IC][17] = 127,
	[1][1][RTW89_KCC][17] = 127,
	[1][1][RTW89_ACMA][17] = 127,
	[1][1][RTW89_CN][17] = 127,
	[1][1][RTW89_UK][17] = 127,
	[1][1][RTW89_FCC][19] = 127,
	[1][1][RTW89_ETSI][19] = 127,
	[1][1][RTW89_MKK][19] = 127,
	[1][1][RTW89_IC][19] = 127,
	[1][1][RTW89_KCC][19] = 127,
	[1][1][RTW89_ACMA][19] = 127,
	[1][1][RTW89_CN][19] = 127,
	[1][1][RTW89_UK][19] = 127,
	[1][1][RTW89_FCC][21] = 127,
	[1][1][RTW89_ETSI][21] = 127,
	[1][1][RTW89_MKK][21] = 127,
	[1][1][RTW89_IC][21] = 127,
	[1][1][RTW89_KCC][21] = 127,
	[1][1][RTW89_ACMA][21] = 127,
	[1][1][RTW89_CN][21] = 127,
	[1][1][RTW89_UK][21] = 127,
	[1][1][RTW89_FCC][23] = 127,
	[1][1][RTW89_ETSI][23] = 127,
	[1][1][RTW89_MKK][23] = 127,
	[1][1][RTW89_IC][23] = 127,
	[1][1][RTW89_KCC][23] = 127,
	[1][1][RTW89_ACMA][23] = 127,
	[1][1][RTW89_CN][23] = 127,
	[1][1][RTW89_UK][23] = 127,
	[1][1][RTW89_FCC][25] = 127,
	[1][1][RTW89_ETSI][25] = 127,
	[1][1][RTW89_MKK][25] = 127,
	[1][1][RTW89_IC][25] = 127,
	[1][1][RTW89_KCC][25] = 127,
	[1][1][RTW89_ACMA][25] = 127,
	[1][1][RTW89_CN][25] = 127,
	[1][1][RTW89_UK][25] = 127,
	[1][1][RTW89_FCC][27] = 127,
	[1][1][RTW89_ETSI][27] = 127,
	[1][1][RTW89_MKK][27] = 127,
	[1][1][RTW89_IC][27] = 127,
	[1][1][RTW89_KCC][27] = 127,
	[1][1][RTW89_ACMA][27] = 127,
	[1][1][RTW89_CN][27] = 127,
	[1][1][RTW89_UK][27] = 127,
	[1][1][RTW89_FCC][29] = 127,
	[1][1][RTW89_ETSI][29] = 127,
	[1][1][RTW89_MKK][29] = 127,
	[1][1][RTW89_IC][29] = 127,
	[1][1][RTW89_KCC][29] = 127,
	[1][1][RTW89_ACMA][29] = 127,
	[1][1][RTW89_CN][29] = 127,
	[1][1][RTW89_UK][29] = 127,
	[1][1][RTW89_FCC][31] = 127,
	[1][1][RTW89_ETSI][31] = 127,
	[1][1][RTW89_MKK][31] = 127,
	[1][1][RTW89_IC][31] = 127,
	[1][1][RTW89_KCC][31] = 127,
	[1][1][RTW89_ACMA][31] = 127,
	[1][1][RTW89_CN][31] = 127,
	[1][1][RTW89_UK][31] = 127,
	[1][1][RTW89_FCC][33] = 127,
	[1][1][RTW89_ETSI][33] = 127,
	[1][1][RTW89_MKK][33] = 127,
	[1][1][RTW89_IC][33] = 127,
	[1][1][RTW89_KCC][33] = 127,
	[1][1][RTW89_ACMA][33] = 127,
	[1][1][RTW89_CN][33] = 127,
	[1][1][RTW89_UK][33] = 127,
	[1][1][RTW89_FCC][35] = 127,
	[1][1][RTW89_ETSI][35] = 127,
	[1][1][RTW89_MKK][35] = 127,
	[1][1][RTW89_IC][35] = 127,
	[1][1][RTW89_KCC][35] = 127,
	[1][1][RTW89_ACMA][35] = 127,
	[1][1][RTW89_CN][35] = 127,
	[1][1][RTW89_UK][35] = 127,
	[1][1][RTW89_FCC][37] = 127,
	[1][1][RTW89_ETSI][37] = 127,
	[1][1][RTW89_MKK][37] = 127,
	[1][1][RTW89_IC][37] = 127,
	[1][1][RTW89_KCC][37] = 127,
	[1][1][RTW89_ACMA][37] = 127,
	[1][1][RTW89_CN][37] = 127,
	[1][1][RTW89_UK][37] = 127,
	[1][1][RTW89_FCC][38] = 127,
	[1][1][RTW89_ETSI][38] = 127,
	[1][1][RTW89_MKK][38] = 127,
	[1][1][RTW89_IC][38] = 127,
	[1][1][RTW89_KCC][38] = 127,
	[1][1][RTW89_ACMA][38] = 127,
	[1][1][RTW89_CN][38] = 127,
	[1][1][RTW89_UK][38] = 127,
	[1][1][RTW89_FCC][40] = 127,
	[1][1][RTW89_ETSI][40] = 127,
	[1][1][RTW89_MKK][40] = 127,
	[1][1][RTW89_IC][40] = 127,
	[1][1][RTW89_KCC][40] = 127,
	[1][1][RTW89_ACMA][40] = 127,
	[1][1][RTW89_CN][40] = 127,
	[1][1][RTW89_UK][40] = 127,
	[1][1][RTW89_FCC][42] = 127,
	[1][1][RTW89_ETSI][42] = 127,
	[1][1][RTW89_MKK][42] = 127,
	[1][1][RTW89_IC][42] = 127,
	[1][1][RTW89_KCC][42] = 127,
	[1][1][RTW89_ACMA][42] = 127,
	[1][1][RTW89_CN][42] = 127,
	[1][1][RTW89_UK][42] = 127,
	[1][1][RTW89_FCC][44] = 127,
	[1][1][RTW89_ETSI][44] = 127,
	[1][1][RTW89_MKK][44] = 127,
	[1][1][RTW89_IC][44] = 127,
	[1][1][RTW89_KCC][44] = 127,
	[1][1][RTW89_ACMA][44] = 127,
	[1][1][RTW89_CN][44] = 127,
	[1][1][RTW89_UK][44] = 127,
	[1][1][RTW89_FCC][46] = 127,
	[1][1][RTW89_ETSI][46] = 127,
	[1][1][RTW89_MKK][46] = 127,
	[1][1][RTW89_IC][46] = 127,
	[1][1][RTW89_KCC][46] = 127,
	[1][1][RTW89_ACMA][46] = 127,
	[1][1][RTW89_CN][46] = 127,
	[1][1][RTW89_UK][46] = 127,
	[1][1][RTW89_FCC][48] = 127,
	[1][1][RTW89_ETSI][48] = 127,
	[1][1][RTW89_MKK][48] = 127,
	[1][1][RTW89_IC][48] = 127,
	[1][1][RTW89_KCC][48] = 127,
	[1][1][RTW89_ACMA][48] = 127,
	[1][1][RTW89_CN][48] = 127,
	[1][1][RTW89_UK][48] = 127,
	[1][1][RTW89_FCC][50] = 127,
	[1][1][RTW89_ETSI][50] = 127,
	[1][1][RTW89_MKK][50] = 127,
	[1][1][RTW89_IC][50] = 127,
	[1][1][RTW89_KCC][50] = 127,
	[1][1][RTW89_ACMA][50] = 127,
	[1][1][RTW89_CN][50] = 127,
	[1][1][RTW89_UK][50] = 127,
	[1][1][RTW89_FCC][52] = 127,
	[1][1][RTW89_ETSI][52] = 127,
	[1][1][RTW89_MKK][52] = 127,
	[1][1][RTW89_IC][52] = 127,
	[1][1][RTW89_KCC][52] = 127,
	[1][1][RTW89_ACMA][52] = 127,
	[1][1][RTW89_CN][52] = 127,
	[1][1][RTW89_UK][52] = 127,
	[2][0][RTW89_FCC][0] = 76,
	[2][0][RTW89_ETSI][0] = 46,
	[2][0][RTW89_MKK][0] = 48,
	[2][0][RTW89_IC][0] = 50,
	[2][0][RTW89_KCC][0] = 64,
	[2][0][RTW89_ACMA][0] = 46,
	[2][0][RTW89_CN][0] = 40,
	[2][0][RTW89_UK][0] = 46,
	[2][0][RTW89_FCC][2] = 72,
	[2][0][RTW89_ETSI][2] = 46,
	[2][0][RTW89_MKK][2] = 48,
	[2][0][RTW89_IC][2] = 48,
	[2][0][RTW89_KCC][2] = 64,
	[2][0][RTW89_ACMA][2] = 46,
	[2][0][RTW89_CN][2] = 40,
	[2][0][RTW89_UK][2] = 46,
	[2][0][RTW89_FCC][4] = 74,
	[2][0][RTW89_ETSI][4] = 46,
	[2][0][RTW89_MKK][4] = 48,
	[2][0][RTW89_IC][4] = 48,
	[2][0][RTW89_KCC][4] = 64,
	[2][0][RTW89_ACMA][4] = 46,
	[2][0][RTW89_CN][4] = 40,
	[2][0][RTW89_UK][4] = 46,
	[2][0][RTW89_FCC][6] = 74,
	[2][0][RTW89_ETSI][6] = 46,
	[2][0][RTW89_MKK][6] = 48,
	[2][0][RTW89_IC][6] = 48,
	[2][0][RTW89_KCC][6] = 40,
	[2][0][RTW89_ACMA][6] = 46,
	[2][0][RTW89_CN][6] = 40,
	[2][0][RTW89_UK][6] = 46,
	[2][0][RTW89_FCC][8] = 72,
	[2][0][RTW89_ETSI][8] = 46,
	[2][0][RTW89_MKK][8] = 48,
	[2][0][RTW89_IC][8] = 64,
	[2][0][RTW89_KCC][8] = 66,
	[2][0][RTW89_ACMA][8] = 46,
	[2][0][RTW89_CN][8] = 40,
	[2][0][RTW89_UK][8] = 46,
	[2][0][RTW89_FCC][10] = 72,
	[2][0][RTW89_ETSI][10] = 46,
	[2][0][RTW89_MKK][10] = 48,
	[2][0][RTW89_IC][10] = 64,
	[2][0][RTW89_KCC][10] = 66,
	[2][0][RTW89_ACMA][10] = 46,
	[2][0][RTW89_CN][10] = 40,
	[2][0][RTW89_UK][10] = 46,
	[2][0][RTW89_FCC][12] = 74,
	[2][0][RTW89_ETSI][12] = 46,
	[2][0][RTW89_MKK][12] = 48,
	[2][0][RTW89_IC][12] = 64,
	[2][0][RTW89_KCC][12] = 64,
	[2][0][RTW89_ACMA][12] = 46,
	[2][0][RTW89_CN][12] = 40,
	[2][0][RTW89_UK][12] = 46,
	[2][0][RTW89_FCC][14] = 80,
	[2][0][RTW89_ETSI][14] = 46,
	[2][0][RTW89_MKK][14] = 48,
	[2][0][RTW89_IC][14] = 64,
	[2][0][RTW89_KCC][14] = 64,
	[2][0][RTW89_ACMA][14] = 46,
	[2][0][RTW89_CN][14] = 40,
	[2][0][RTW89_UK][14] = 46,
	[2][0][RTW89_FCC][15] = 72,
	[2][0][RTW89_ETSI][15] = 46,
	[2][0][RTW89_MKK][15] = 70,
	[2][0][RTW89_IC][15] = 72,
	[2][0][RTW89_KCC][15] = 66,
	[2][0][RTW89_ACMA][15] = 46,
	[2][0][RTW89_CN][15] = 127,
	[2][0][RTW89_UK][15] = 46,
	[2][0][RTW89_FCC][17] = 72,
	[2][0][RTW89_ETSI][17] = 46,
	[2][0][RTW89_MKK][17] = 70,
	[2][0][RTW89_IC][17] = 72,
	[2][0][RTW89_KCC][17] = 66,
	[2][0][RTW89_ACMA][17] = 46,
	[2][0][RTW89_CN][17] = 127,
	[2][0][RTW89_UK][17] = 46,
	[2][0][RTW89_FCC][19] = 68,
	[2][0][RTW89_ETSI][19] = 46,
	[2][0][RTW89_MKK][19] = 70,
	[2][0][RTW89_IC][19] = 68,
	[2][0][RTW89_KCC][19] = 66,
	[2][0][RTW89_ACMA][19] = 46,
	[2][0][RTW89_CN][19] = 127,
	[2][0][RTW89_UK][19] = 46,
	[2][0][RTW89_FCC][21] = 68,
	[2][0][RTW89_ETSI][21] = 46,
	[2][0][RTW89_MKK][21] = 70,
	[2][0][RTW89_IC][21] = 68,
	[2][0][RTW89_KCC][21] = 66,
	[2][0][RTW89_ACMA][21] = 46,
	[2][0][RTW89_CN][21] = 127,
	[2][0][RTW89_UK][21] = 46,
	[2][0][RTW89_FCC][23] = 68,
	[2][0][RTW89_ETSI][23] = 46,
	[2][0][RTW89_MKK][23] = 70,
	[2][0][RTW89_IC][23] = 68,
	[2][0][RTW89_KCC][23] = 66,
	[2][0][RTW89_ACMA][23] = 46,
	[2][0][RTW89_CN][23] = 127,
	[2][0][RTW89_UK][23] = 46,
	[2][0][RTW89_FCC][25] = 68,
	[2][0][RTW89_ETSI][25] = 46,
	[2][0][RTW89_MKK][25] = 70,
	[2][0][RTW89_IC][25] = 127,
	[2][0][RTW89_KCC][25] = 66,
	[2][0][RTW89_ACMA][25] = 127,
	[2][0][RTW89_CN][25] = 127,
	[2][0][RTW89_UK][25] = 46,
	[2][0][RTW89_FCC][27] = 68,
	[2][0][RTW89_ETSI][27] = 46,
	[2][0][RTW89_MKK][27] = 70,
	[2][0][RTW89_IC][27] = 127,
	[2][0][RTW89_KCC][27] = 64,
	[2][0][RTW89_ACMA][27] = 127,
	[2][0][RTW89_CN][27] = 127,
	[2][0][RTW89_UK][27] = 46,
	[2][0][RTW89_FCC][29] = 68,
	[2][0][RTW89_ETSI][29] = 46,
	[2][0][RTW89_MKK][29] = 70,
	[2][0][RTW89_IC][29] = 127,
	[2][0][RTW89_KCC][29] = 64,
	[2][0][RTW89_ACMA][29] = 127,
	[2][0][RTW89_CN][29] = 127,
	[2][0][RTW89_UK][29] = 46,
	[2][0][RTW89_FCC][31] = 68,
	[2][0][RTW89_ETSI][31] = 46,
	[2][0][RTW89_MKK][31] = 70,
	[2][0][RTW89_IC][31] = 70,
	[2][0][RTW89_KCC][31] = 64,
	[2][0][RTW89_ACMA][31] = 46,
	[2][0][RTW89_CN][31] = 127,
	[2][0][RTW89_UK][31] = 46,
	[2][0][RTW89_FCC][33] = 70,
	[2][0][RTW89_ETSI][33] = 46,
	[2][0][RTW89_MKK][33] = 70,
	[2][0][RTW89_IC][33] = 70,
	[2][0][RTW89_KCC][33] = 64,
	[2][0][RTW89_ACMA][33] = 46,
	[2][0][RTW89_CN][33] = 127,
	[2][0][RTW89_UK][33] = 46,
	[2][0][RTW89_FCC][35] = 70,
	[2][0][RTW89_ETSI][35] = 46,
	[2][0][RTW89_MKK][35] = 70,
	[2][0][RTW89_IC][35] = 70,
	[2][0][RTW89_KCC][35] = 64,
	[2][0][RTW89_ACMA][35] = 46,
	[2][0][RTW89_CN][35] = 127,
	[2][0][RTW89_UK][35] = 46,
	[2][0][RTW89_FCC][37] = 84,
	[2][0][RTW89_ETSI][37] = 127,
	[2][0][RTW89_MKK][37] = 68,
	[2][0][RTW89_IC][37] = 84,
	[2][0][RTW89_KCC][37] = 66,
	[2][0][RTW89_ACMA][37] = 74,
	[2][0][RTW89_CN][37] = 127,
	[2][0][RTW89_UK][37] = 74,
	[2][0][RTW89_FCC][38] = 84,
	[2][0][RTW89_ETSI][38] = 28,
	[2][0][RTW89_MKK][38] = 127,
	[2][0][RTW89_IC][38] = 84,
	[2][0][RTW89_KCC][38] = 64,
	[2][0][RTW89_ACMA][38] = 84,
	[2][0][RTW89_CN][38] = 68,
	[2][0][RTW89_UK][38] = 46,
	[2][0][RTW89_FCC][40] = 84,
	[2][0][RTW89_ETSI][40] = 28,
	[2][0][RTW89_MKK][40] = 127,
	[2][0][RTW89_IC][40] = 84,
	[2][0][RTW89_KCC][40] = 64,
	[2][0][RTW89_ACMA][40] = 84,
	[2][0][RTW89_CN][40] = 68,
	[2][0][RTW89_UK][40] = 46,
	[2][0][RTW89_FCC][42] = 78,
	[2][0][RTW89_ETSI][42] = 28,
	[2][0][RTW89_MKK][42] = 127,
	[2][0][RTW89_IC][42] = 78,
	[2][0][RTW89_KCC][42] = 66,
	[2][0][RTW89_ACMA][42] = 84,
	[2][0][RTW89_CN][42] = 68,
	[2][0][RTW89_UK][42] = 46,
	[2][0][RTW89_FCC][44] = 80,
	[2][0][RTW89_ETSI][44] = 28,
	[2][0][RTW89_MKK][44] = 127,
	[2][0][RTW89_IC][44] = 80,
	[2][0][RTW89_KCC][44] = 66,
	[2][0][RTW89_ACMA][44] = 84,
	[2][0][RTW89_CN][44] = 68,
	[2][0][RTW89_UK][44] = 46,
	[2][0][RTW89_FCC][46] = 80,
	[2][0][RTW89_ETSI][46] = 28,
	[2][0][RTW89_MKK][46] = 127,
	[2][0][RTW89_IC][46] = 80,
	[2][0][RTW89_KCC][46] = 66,
	[2][0][RTW89_ACMA][46] = 84,
	[2][0][RTW89_CN][46] = 68,
	[2][0][RTW89_UK][46] = 46,
	[2][0][RTW89_FCC][48] = 62,
	[2][0][RTW89_ETSI][48] = 127,
	[2][0][RTW89_MKK][48] = 127,
	[2][0][RTW89_IC][48] = 127,
	[2][0][RTW89_KCC][48] = 127,
	[2][0][RTW89_ACMA][48] = 127,
	[2][0][RTW89_CN][48] = 127,
	[2][0][RTW89_UK][48] = 127,
	[2][0][RTW89_FCC][50] = 62,
	[2][0][RTW89_ETSI][50] = 127,
	[2][0][RTW89_MKK][50] = 127,
	[2][0][RTW89_IC][50] = 127,
	[2][0][RTW89_KCC][50] = 127,
	[2][0][RTW89_ACMA][50] = 127,
	[2][0][RTW89_CN][50] = 127,
	[2][0][RTW89_UK][50] = 127,
	[2][0][RTW89_FCC][52] = 60,
	[2][0][RTW89_ETSI][52] = 127,
	[2][0][RTW89_MKK][52] = 127,
	[2][0][RTW89_IC][52] = 127,
	[2][0][RTW89_KCC][52] = 127,
	[2][0][RTW89_ACMA][52] = 127,
	[2][0][RTW89_CN][52] = 127,
	[2][0][RTW89_UK][52] = 127,
	[2][1][RTW89_FCC][0] = 127,
	[2][1][RTW89_ETSI][0] = 127,
	[2][1][RTW89_MKK][0] = 127,
	[2][1][RTW89_IC][0] = 127,
	[2][1][RTW89_KCC][0] = 127,
	[2][1][RTW89_ACMA][0] = 127,
	[2][1][RTW89_CN][0] = 127,
	[2][1][RTW89_UK][0] = 127,
	[2][1][RTW89_FCC][2] = 127,
	[2][1][RTW89_ETSI][2] = 127,
	[2][1][RTW89_MKK][2] = 127,
	[2][1][RTW89_IC][2] = 127,
	[2][1][RTW89_KCC][2] = 127,
	[2][1][RTW89_ACMA][2] = 127,
	[2][1][RTW89_CN][2] = 127,
	[2][1][RTW89_UK][2] = 127,
	[2][1][RTW89_FCC][4] = 127,
	[2][1][RTW89_ETSI][4] = 127,
	[2][1][RTW89_MKK][4] = 127,
	[2][1][RTW89_IC][4] = 127,
	[2][1][RTW89_KCC][4] = 127,
	[2][1][RTW89_ACMA][4] = 127,
	[2][1][RTW89_CN][4] = 127,
	[2][1][RTW89_UK][4] = 127,
	[2][1][RTW89_FCC][6] = 127,
	[2][1][RTW89_ETSI][6] = 127,
	[2][1][RTW89_MKK][6] = 127,
	[2][1][RTW89_IC][6] = 127,
	[2][1][RTW89_KCC][6] = 127,
	[2][1][RTW89_ACMA][6] = 127,
	[2][1][RTW89_CN][6] = 127,
	[2][1][RTW89_UK][6] = 127,
	[2][1][RTW89_FCC][8] = 127,
	[2][1][RTW89_ETSI][8] = 127,
	[2][1][RTW89_MKK][8] = 127,
	[2][1][RTW89_IC][8] = 127,
	[2][1][RTW89_KCC][8] = 127,
	[2][1][RTW89_ACMA][8] = 127,
	[2][1][RTW89_CN][8] = 127,
	[2][1][RTW89_UK][8] = 127,
	[2][1][RTW89_FCC][10] = 127,
	[2][1][RTW89_ETSI][10] = 127,
	[2][1][RTW89_MKK][10] = 127,
	[2][1][RTW89_IC][10] = 127,
	[2][1][RTW89_KCC][10] = 127,
	[2][1][RTW89_ACMA][10] = 127,
	[2][1][RTW89_CN][10] = 127,
	[2][1][RTW89_UK][10] = 127,
	[2][1][RTW89_FCC][12] = 127,
	[2][1][RTW89_ETSI][12] = 127,
	[2][1][RTW89_MKK][12] = 127,
	[2][1][RTW89_IC][12] = 127,
	[2][1][RTW89_KCC][12] = 127,
	[2][1][RTW89_ACMA][12] = 127,
	[2][1][RTW89_CN][12] = 127,
	[2][1][RTW89_UK][12] = 127,
	[2][1][RTW89_FCC][14] = 127,
	[2][1][RTW89_ETSI][14] = 127,
	[2][1][RTW89_MKK][14] = 127,
	[2][1][RTW89_IC][14] = 127,
	[2][1][RTW89_KCC][14] = 127,
	[2][1][RTW89_ACMA][14] = 127,
	[2][1][RTW89_CN][14] = 127,
	[2][1][RTW89_UK][14] = 127,
	[2][1][RTW89_FCC][15] = 127,
	[2][1][RTW89_ETSI][15] = 127,
	[2][1][RTW89_MKK][15] = 127,
	[2][1][RTW89_IC][15] = 127,
	[2][1][RTW89_KCC][15] = 127,
	[2][1][RTW89_ACMA][15] = 127,
	[2][1][RTW89_CN][15] = 127,
	[2][1][RTW89_UK][15] = 127,
	[2][1][RTW89_FCC][17] = 127,
	[2][1][RTW89_ETSI][17] = 127,
	[2][1][RTW89_MKK][17] = 127,
	[2][1][RTW89_IC][17] = 127,
	[2][1][RTW89_KCC][17] = 127,
	[2][1][RTW89_ACMA][17] = 127,
	[2][1][RTW89_CN][17] = 127,
	[2][1][RTW89_UK][17] = 127,
	[2][1][RTW89_FCC][19] = 127,
	[2][1][RTW89_ETSI][19] = 127,
	[2][1][RTW89_MKK][19] = 127,
	[2][1][RTW89_IC][19] = 127,
	[2][1][RTW89_KCC][19] = 127,
	[2][1][RTW89_ACMA][19] = 127,
	[2][1][RTW89_CN][19] = 127,
	[2][1][RTW89_UK][19] = 127,
	[2][1][RTW89_FCC][21] = 127,
	[2][1][RTW89_ETSI][21] = 127,
	[2][1][RTW89_MKK][21] = 127,
	[2][1][RTW89_IC][21] = 127,
	[2][1][RTW89_KCC][21] = 127,
	[2][1][RTW89_ACMA][21] = 127,
	[2][1][RTW89_CN][21] = 127,
	[2][1][RTW89_UK][21] = 127,
	[2][1][RTW89_FCC][23] = 127,
	[2][1][RTW89_ETSI][23] = 127,
	[2][1][RTW89_MKK][23] = 127,
	[2][1][RTW89_IC][23] = 127,
	[2][1][RTW89_KCC][23] = 127,
	[2][1][RTW89_ACMA][23] = 127,
	[2][1][RTW89_CN][23] = 127,
	[2][1][RTW89_UK][23] = 127,
	[2][1][RTW89_FCC][25] = 127,
	[2][1][RTW89_ETSI][25] = 127,
	[2][1][RTW89_MKK][25] = 127,
	[2][1][RTW89_IC][25] = 127,
	[2][1][RTW89_KCC][25] = 127,
	[2][1][RTW89_ACMA][25] = 127,
	[2][1][RTW89_CN][25] = 127,
	[2][1][RTW89_UK][25] = 127,
	[2][1][RTW89_FCC][27] = 127,
	[2][1][RTW89_ETSI][27] = 127,
	[2][1][RTW89_MKK][27] = 127,
	[2][1][RTW89_IC][27] = 127,
	[2][1][RTW89_KCC][27] = 127,
	[2][1][RTW89_ACMA][27] = 127,
	[2][1][RTW89_CN][27] = 127,
	[2][1][RTW89_UK][27] = 127,
	[2][1][RTW89_FCC][29] = 127,
	[2][1][RTW89_ETSI][29] = 127,
	[2][1][RTW89_MKK][29] = 127,
	[2][1][RTW89_IC][29] = 127,
	[2][1][RTW89_KCC][29] = 127,
	[2][1][RTW89_ACMA][29] = 127,
	[2][1][RTW89_CN][29] = 127,
	[2][1][RTW89_UK][29] = 127,
	[2][1][RTW89_FCC][31] = 127,
	[2][1][RTW89_ETSI][31] = 127,
	[2][1][RTW89_MKK][31] = 127,
	[2][1][RTW89_IC][31] = 127,
	[2][1][RTW89_KCC][31] = 127,
	[2][1][RTW89_ACMA][31] = 127,
	[2][1][RTW89_CN][31] = 127,
	[2][1][RTW89_UK][31] = 127,
	[2][1][RTW89_FCC][33] = 127,
	[2][1][RTW89_ETSI][33] = 127,
	[2][1][RTW89_MKK][33] = 127,
	[2][1][RTW89_IC][33] = 127,
	[2][1][RTW89_KCC][33] = 127,
	[2][1][RTW89_ACMA][33] = 127,
	[2][1][RTW89_CN][33] = 127,
	[2][1][RTW89_UK][33] = 127,
	[2][1][RTW89_FCC][35] = 127,
	[2][1][RTW89_ETSI][35] = 127,
	[2][1][RTW89_MKK][35] = 127,
	[2][1][RTW89_IC][35] = 127,
	[2][1][RTW89_KCC][35] = 127,
	[2][1][RTW89_ACMA][35] = 127,
	[2][1][RTW89_CN][35] = 127,
	[2][1][RTW89_UK][35] = 127,
	[2][1][RTW89_FCC][37] = 127,
	[2][1][RTW89_ETSI][37] = 127,
	[2][1][RTW89_MKK][37] = 127,
	[2][1][RTW89_IC][37] = 127,
	[2][1][RTW89_KCC][37] = 127,
	[2][1][RTW89_ACMA][37] = 127,
	[2][1][RTW89_CN][37] = 127,
	[2][1][RTW89_UK][37] = 127,
	[2][1][RTW89_FCC][38] = 127,
	[2][1][RTW89_ETSI][38] = 127,
	[2][1][RTW89_MKK][38] = 127,
	[2][1][RTW89_IC][38] = 127,
	[2][1][RTW89_KCC][38] = 127,
	[2][1][RTW89_ACMA][38] = 127,
	[2][1][RTW89_CN][38] = 127,
	[2][1][RTW89_UK][38] = 127,
	[2][1][RTW89_FCC][40] = 127,
	[2][1][RTW89_ETSI][40] = 127,
	[2][1][RTW89_MKK][40] = 127,
	[2][1][RTW89_IC][40] = 127,
	[2][1][RTW89_KCC][40] = 127,
	[2][1][RTW89_ACMA][40] = 127,
	[2][1][RTW89_CN][40] = 127,
	[2][1][RTW89_UK][40] = 127,
	[2][1][RTW89_FCC][42] = 127,
	[2][1][RTW89_ETSI][42] = 127,
	[2][1][RTW89_MKK][42] = 127,
	[2][1][RTW89_IC][42] = 127,
	[2][1][RTW89_KCC][42] = 127,
	[2][1][RTW89_ACMA][42] = 127,
	[2][1][RTW89_CN][42] = 127,
	[2][1][RTW89_UK][42] = 127,
	[2][1][RTW89_FCC][44] = 127,
	[2][1][RTW89_ETSI][44] = 127,
	[2][1][RTW89_MKK][44] = 127,
	[2][1][RTW89_IC][44] = 127,
	[2][1][RTW89_KCC][44] = 127,
	[2][1][RTW89_ACMA][44] = 127,
	[2][1][RTW89_CN][44] = 127,
	[2][1][RTW89_UK][44] = 127,
	[2][1][RTW89_FCC][46] = 127,
	[2][1][RTW89_ETSI][46] = 127,
	[2][1][RTW89_MKK][46] = 127,
	[2][1][RTW89_IC][46] = 127,
	[2][1][RTW89_KCC][46] = 127,
	[2][1][RTW89_ACMA][46] = 127,
	[2][1][RTW89_CN][46] = 127,
	[2][1][RTW89_UK][46] = 127,
	[2][1][RTW89_FCC][48] = 127,
	[2][1][RTW89_ETSI][48] = 127,
	[2][1][RTW89_MKK][48] = 127,
	[2][1][RTW89_IC][48] = 127,
	[2][1][RTW89_KCC][48] = 127,
	[2][1][RTW89_ACMA][48] = 127,
	[2][1][RTW89_CN][48] = 127,
	[2][1][RTW89_UK][48] = 127,
	[2][1][RTW89_FCC][50] = 127,
	[2][1][RTW89_ETSI][50] = 127,
	[2][1][RTW89_MKK][50] = 127,
	[2][1][RTW89_IC][50] = 127,
	[2][1][RTW89_KCC][50] = 127,
	[2][1][RTW89_ACMA][50] = 127,
	[2][1][RTW89_CN][50] = 127,
	[2][1][RTW89_UK][50] = 127,
	[2][1][RTW89_FCC][52] = 127,
	[2][1][RTW89_ETSI][52] = 127,
	[2][1][RTW89_MKK][52] = 127,
	[2][1][RTW89_IC][52] = 127,
	[2][1][RTW89_KCC][52] = 127,
	[2][1][RTW89_ACMA][52] = 127,
	[2][1][RTW89_CN][52] = 127,
	[2][1][RTW89_UK][52] = 127,
};

const struct rtw89_phy_table rtw89_8851b_phy_bb_table = {
	.regs		= rtw89_8851b_phy_bb_regs,
	.n_regs		= ARRAY_SIZE(rtw89_8851b_phy_bb_regs),
	.rf_path	= 0, /* don't care */
};

const struct rtw89_phy_table rtw89_8851b_phy_bb_gain_table = {
	.regs		= rtw89_8851b_phy_bb_reg_gain,
	.n_regs		= ARRAY_SIZE(rtw89_8851b_phy_bb_reg_gain),
	.rf_path	= 0, /* don't care */
};

const struct rtw89_phy_table rtw89_8851b_phy_radioa_table = {
	.regs		= rtw89_8851b_phy_radioa_regs,
	.n_regs		= ARRAY_SIZE(rtw89_8851b_phy_radioa_regs),
	.rf_path	= RF_PATH_A,
	.config		= rtw89_phy_config_rf_reg_v1,
};

const struct rtw89_phy_table rtw89_8851b_phy_nctl_table = {
	.regs		= rtw89_8851b_phy_nctl_regs,
	.n_regs		= ARRAY_SIZE(rtw89_8851b_phy_nctl_regs),
	.rf_path	= 0, /* don't care */
};

static
const struct rtw89_txpwr_table rtw89_8851b_byr_table = {
	.data = rtw89_8851b_txpwr_byrate,
	.size = ARRAY_SIZE(rtw89_8851b_txpwr_byrate),
	.load = rtw89_phy_load_txpwr_byrate,
};

static
const struct rtw89_txpwr_table rtw89_8851b_byr_table_type2 = {
	.data = rtw89_8851b_txpwr_byrate_type2,
	.size = ARRAY_SIZE(rtw89_8851b_txpwr_byrate_type2),
	.load = rtw89_phy_load_txpwr_byrate,
};

const struct rtw89_txpwr_track_cfg rtw89_8851b_trk_cfg = {
	.delta_swingidx_5ga_n = _txpwr_track_delta_swingidx_5ga_n,
	.delta_swingidx_5ga_p = _txpwr_track_delta_swingidx_5ga_p,
	.delta_swingidx_2ga_n = _txpwr_track_delta_swingidx_2ga_n,
	.delta_swingidx_2ga_p = _txpwr_track_delta_swingidx_2ga_p,
	.delta_swingidx_2g_cck_a_n = _txpwr_track_delta_swingidx_2g_cck_a_n,
	.delta_swingidx_2g_cck_a_p = _txpwr_track_delta_swingidx_2g_cck_a_p,
};

const struct rtw89_rfe_parms rtw89_8851b_dflt_parms = {
	.byr_tbl = &rtw89_8851b_byr_table,
	.rule_2ghz = {
		.lmt = &rtw89_8851b_txpwr_lmt_2g,
		.lmt_ru = &rtw89_8851b_txpwr_lmt_ru_2g,
	},
	.rule_5ghz = {
		.lmt = &rtw89_8851b_txpwr_lmt_5g,
		.lmt_ru = &rtw89_8851b_txpwr_lmt_ru_5g,
	},
	.tx_shape = {
		.lmt = &rtw89_8851b_tx_shape_lmt,
		.lmt_ru = &rtw89_8851b_tx_shape_lmt_ru,
	},
};

static const struct rtw89_rfe_parms rtw89_8851b_rfe_parms_type2 = {
	.byr_tbl = &rtw89_8851b_byr_table_type2,
	.rule_2ghz = {
		.lmt = &rtw89_8851b_txpwr_lmt_2g_type2,
		.lmt_ru = &rtw89_8851b_txpwr_lmt_ru_2g_type2,
	},
	.rule_5ghz = {
		.lmt = &rtw89_8851b_txpwr_lmt_5g_type2,
		.lmt_ru = &rtw89_8851b_txpwr_lmt_ru_5g_type2,
	},
	.tx_shape = {
		.lmt = &rtw89_8851b_tx_shape_lmt,
		.lmt_ru = &rtw89_8851b_tx_shape_lmt_ru,
	},
};

const struct rtw89_rfe_parms_conf rtw89_8851b_rfe_parms_conf[] = {
	{
		.rfe_parms = &rtw89_8851b_rfe_parms_type2,
		.rfe_type = 2,
	},
	{},
};
