; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-BE

define <2 x i64> @test2elt(i64 %a.coerce) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xxmrghd vs0, vs0, vs1
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v2, vs0
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xxmrghd vs0, vs0, vs1
; CHECK-P9-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrd f0, r3
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-BE-NEXT:    xvcvdpuxds v2, vs0
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i64 %a.coerce to <2 x float>
  %1 = fptoui <2 x float> %0 to <2 x i64>
  ret <2 x i64> %1
}

define void @test4elt(<4 x i64>* noalias nocapture sret %agg.result, <4 x float> %a) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-P8-NEXT:    xxmrghd vs1, vs2, vs3
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P8-NEXT:    xvcvdpuxds v3, vs1
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxswapd vs0, v3
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r4
; CHECK-P8-NEXT:    stxvd2x vs1, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P9-NEXT:    xxswapd vs1, v2
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xxsldwi vs2, v2, v2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, v2
; CHECK-P9-NEXT:    xxmrghd vs1, vs1, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxsldwi vs1, v2, v2, 1
; CHECK-BE-NEXT:    xscvspdpn f0, v2
; CHECK-BE-NEXT:    xxswapd vs2, v2
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xxmrghd vs0, vs0, vs1
; CHECK-BE-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    xxmrghd vs1, vs2, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = fptoui <4 x float> %a to <4 x i64>
  store <4 x i64> %0, <4 x i64>* %agg.result, align 32
  ret void
}

define void @test8elt(<8 x i64>* noalias nocapture sret %agg.result, <8 x float>* nocapture readonly) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test8elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    lvx v3, 0, r4
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    lvx v2, r4, r5
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    xxsldwi vs5, v3, v3, 3
; CHECK-P8-NEXT:    xxswapd vs6, v3
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xxsldwi vs7, v3, v3, 1
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xscvspdpn f4, v3
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvspdpn f6, vs6
; CHECK-P8-NEXT:    xscvspdpn f7, vs7
; CHECK-P8-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-P8-NEXT:    xxmrghd vs1, vs2, vs3
; CHECK-P8-NEXT:    xxmrghd vs2, vs6, vs5
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P8-NEXT:    xxmrghd vs3, vs4, vs7
; CHECK-P8-NEXT:    xvcvdpuxds v3, vs1
; CHECK-P8-NEXT:    xvcvdpuxds v4, vs2
; CHECK-P8-NEXT:    xvcvdpuxds v5, vs3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxswapd vs0, v3
; CHECK-P8-NEXT:    xxswapd vs3, v4
; CHECK-P8-NEXT:    xxswapd vs2, v5
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r4
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs3, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 0(r4)
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xxswapd vs2, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvspdpn f3, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxmrghd vs1, vs2, vs1
; CHECK-P9-NEXT:    lxv vs2, 16(r4)
; CHECK-P9-NEXT:    xxmrghd vs0, vs3, vs0
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    xxsldwi vs3, vs2, vs2, 3
; CHECK-P9-NEXT:    xxswapd vs4, vs2
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xscvspdpn f4, vs4
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    xxmrghd vs3, vs4, vs3
; CHECK-P9-NEXT:    xscvspdpn f4, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P9-NEXT:    xxmrghd vs2, vs4, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P9-NEXT:    stxv vs3, 32(r3)
; CHECK-P9-NEXT:    stxv vs2, 48(r3)
; CHECK-P9-NEXT:    stxv vs1, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs1, 0(r4)
; CHECK-BE-NEXT:    xxsldwi vs3, vs1, vs1, 1
; CHECK-BE-NEXT:    xscvspdpn f2, vs1
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    lxv vs0, 16(r4)
; CHECK-BE-NEXT:    xxsldwi vs4, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xxmrghd vs2, vs2, vs3
; CHECK-BE-NEXT:    xxsldwi vs3, vs1, vs1, 3
; CHECK-BE-NEXT:    xxswapd vs1, vs1
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xxmrghd vs1, vs1, vs3
; CHECK-BE-NEXT:    xscvspdpn f3, vs0
; CHECK-BE-NEXT:    xxmrghd vs3, vs3, vs4
; CHECK-BE-NEXT:    xxsldwi vs4, vs0, vs0, 3
; CHECK-BE-NEXT:    xxswapd vs0, vs0
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xxmrghd vs0, vs0, vs4
; CHECK-BE-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs3, 32(r3)
; CHECK-BE-NEXT:    stxv vs0, 48(r3)
; CHECK-BE-NEXT:    stxv vs2, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <8 x float>, <8 x float>* %0, align 32
  %1 = fptoui <8 x float> %a to <8 x i64>
  store <8 x i64> %1, <8 x i64>* %agg.result, align 64
  ret void
}

define void @test16elt(<16 x i64>* noalias nocapture sret %agg.result, <16 x float>* nocapture readonly) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test16elt:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    li r7, 48
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    lvx v4, 0, r4
; CHECK-P8-NEXT:    li r8, 64
; CHECK-P8-NEXT:    lvx v5, r4, r5
; CHECK-P8-NEXT:    lvx v3, r4, r7
; CHECK-P8-NEXT:    lvx v2, r4, r6
; CHECK-P8-NEXT:    li r4, 112
; CHECK-P8-NEXT:    xxsldwi vs13, v4, v4, 3
; CHECK-P8-NEXT:    xscvspdpn f6, v4
; CHECK-P8-NEXT:    xxsldwi vs1, v5, v5, 3
; CHECK-P8-NEXT:    xxswapd vs3, v5
; CHECK-P8-NEXT:    xxsldwi vs9, v3, v3, 1
; CHECK-P8-NEXT:    xscvspdpn f4, v3
; CHECK-P8-NEXT:    xxsldwi vs5, v5, v5, 1
; CHECK-P8-NEXT:    xxsldwi vs10, v3, v3, 3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xxswapd vs11, v3
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xxsldwi vs7, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f9, vs9
; CHECK-P8-NEXT:    xxswapd vs8, v2
; CHECK-P8-NEXT:    xscvspdpn f0, v5
; CHECK-P8-NEXT:    xxsldwi vs12, v2, v2, 1
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xxswapd v2, v4
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xxsldwi v3, v4, v4, 1
; CHECK-P8-NEXT:    xscvspdpn f10, vs10
; CHECK-P8-NEXT:    xscvspdpn f11, vs11
; CHECK-P8-NEXT:    xxmrghd vs1, vs3, vs1
; CHECK-P8-NEXT:    xscvspdpn f7, vs7
; CHECK-P8-NEXT:    xxmrghd vs4, vs4, vs9
; CHECK-P8-NEXT:    xscvspdpn f8, vs8
; CHECK-P8-NEXT:    xscvspdpn f12, vs12
; CHECK-P8-NEXT:    xscvspdpn f13, vs13
; CHECK-P8-NEXT:    xxmrghd vs0, vs0, vs5
; CHECK-P8-NEXT:    xscvspdpn f3, v2
; CHECK-P8-NEXT:    xscvspdpn f9, v3
; CHECK-P8-NEXT:    xxmrghd vs5, vs11, vs10
; CHECK-P8-NEXT:    xvcvdpuxds v3, vs4
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs1
; CHECK-P8-NEXT:    xxmrghd vs1, vs2, vs12
; CHECK-P8-NEXT:    xxmrghd vs2, vs8, vs7
; CHECK-P8-NEXT:    xvcvdpuxds v4, vs0
; CHECK-P8-NEXT:    xxmrghd vs0, vs3, vs13
; CHECK-P8-NEXT:    xvcvdpuxds v5, vs5
; CHECK-P8-NEXT:    xxmrghd vs3, vs6, vs9
; CHECK-P8-NEXT:    xvcvdpuxds v0, vs1
; CHECK-P8-NEXT:    xvcvdpuxds v1, vs2
; CHECK-P8-NEXT:    xvcvdpuxds v6, vs0
; CHECK-P8-NEXT:    xxswapd vs0, v3
; CHECK-P8-NEXT:    xvcvdpuxds v7, vs3
; CHECK-P8-NEXT:    xxswapd vs4, v2
; CHECK-P8-NEXT:    xxswapd vs3, v4
; CHECK-P8-NEXT:    xxswapd vs1, v5
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r4
; CHECK-P8-NEXT:    li r4, 96
; CHECK-P8-NEXT:    xxswapd vs2, v0
; CHECK-P8-NEXT:    xxswapd vs0, v1
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    xxswapd vs5, v6
; CHECK-P8-NEXT:    li r4, 80
; CHECK-P8-NEXT:    xxswapd vs1, v7
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r4
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r8
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r7
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs5, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs4, 16(r4)
; CHECK-P9-NEXT:    xxsldwi vs5, vs4, vs4, 3
; CHECK-P9-NEXT:    xxswapd vs6, vs4
; CHECK-P9-NEXT:    lxv vs0, 0(r4)
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xxswapd vs2, vs0
; CHECK-P9-NEXT:    xscvspdpn f5, vs5
; CHECK-P9-NEXT:    xscvspdpn f6, vs6
; CHECK-P9-NEXT:    xxmrghd vs5, vs6, vs5
; CHECK-P9-NEXT:    xscvspdpn f6, vs4
; CHECK-P9-NEXT:    xxsldwi vs4, vs4, vs4, 1
; CHECK-P9-NEXT:    lxv vs3, 32(r4)
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xxswapd vs7, vs3
; CHECK-P9-NEXT:    xscvspdpn f7, vs7
; CHECK-P9-NEXT:    xscvspdpn f4, vs4
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xxmrghd vs1, vs2, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxmrghd vs0, vs2, vs0
; CHECK-P9-NEXT:    xxmrghd vs4, vs6, vs4
; CHECK-P9-NEXT:    xxsldwi vs6, vs3, vs3, 3
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpuxds vs5, vs5
; CHECK-P9-NEXT:    xscvspdpn f6, vs6
; CHECK-P9-NEXT:    xxmrghd vs6, vs7, vs6
; CHECK-P9-NEXT:    xscvspdpn f7, vs3
; CHECK-P9-NEXT:    xxsldwi vs3, vs3, vs3, 1
; CHECK-P9-NEXT:    lxv vs2, 48(r4)
; CHECK-P9-NEXT:    xxswapd vs8, vs2
; CHECK-P9-NEXT:    xscvspdpn f8, vs8
; CHECK-P9-NEXT:    xvcvdpuxds vs4, vs4
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xxmrghd vs3, vs7, vs3
; CHECK-P9-NEXT:    xxsldwi vs7, vs2, vs2, 3
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    xvcvdpuxds vs6, vs6
; CHECK-P9-NEXT:    stxv vs6, 64(r3)
; CHECK-P9-NEXT:    xscvspdpn f7, vs7
; CHECK-P9-NEXT:    xxmrghd vs7, vs8, vs7
; CHECK-P9-NEXT:    xscvspdpn f8, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xxmrghd vs2, vs8, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P9-NEXT:    xvcvdpuxds vs7, vs7
; CHECK-P9-NEXT:    stxv vs3, 80(r3)
; CHECK-P9-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P9-NEXT:    stxv vs7, 96(r3)
; CHECK-P9-NEXT:    stxv vs2, 112(r3)
; CHECK-P9-NEXT:    stxv vs4, 48(r3)
; CHECK-P9-NEXT:    stxv vs5, 32(r3)
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    stxv vs1, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 0(r4)
; CHECK-BE-NEXT:    lxv vs4, 16(r4)
; CHECK-BE-NEXT:    xxsldwi vs2, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs5, vs0, vs0, 3
; CHECK-BE-NEXT:    xxswapd vs0, vs0
; CHECK-BE-NEXT:    xscvspdpn f5, vs5
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xxsldwi vs6, vs4, vs4, 1
; CHECK-BE-NEXT:    xscvspdpn f6, vs6
; CHECK-BE-NEXT:    xxmrghd vs0, vs0, vs5
; CHECK-BE-NEXT:    xscvspdpn f5, vs4
; CHECK-BE-NEXT:    lxv vs3, 32(r4)
; CHECK-BE-NEXT:    xxsldwi vs7, vs3, vs3, 1
; CHECK-BE-NEXT:    xscvspdpn f7, vs7
; CHECK-BE-NEXT:    xxmrghd vs5, vs5, vs6
; CHECK-BE-NEXT:    xxsldwi vs6, vs4, vs4, 3
; CHECK-BE-NEXT:    xxswapd vs4, vs4
; CHECK-BE-NEXT:    xscvspdpn f6, vs6
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xxmrghd vs1, vs1, vs2
; CHECK-BE-NEXT:    lxv vs2, 48(r4)
; CHECK-BE-NEXT:    xxsldwi vs8, vs2, vs2, 1
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    xvcvdpuxds vs5, vs5
; CHECK-BE-NEXT:    xscvspdpn f8, vs8
; CHECK-BE-NEXT:    xxmrghd vs4, vs4, vs6
; CHECK-BE-NEXT:    xscvspdpn f6, vs3
; CHECK-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-BE-NEXT:    xxmrghd vs6, vs6, vs7
; CHECK-BE-NEXT:    xxsldwi vs7, vs3, vs3, 3
; CHECK-BE-NEXT:    xxswapd vs3, vs3
; CHECK-BE-NEXT:    xscvspdpn f7, vs7
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    xxmrghd vs3, vs3, vs7
; CHECK-BE-NEXT:    xscvspdpn f7, vs2
; CHECK-BE-NEXT:    xxmrghd vs7, vs7, vs8
; CHECK-BE-NEXT:    xxsldwi vs8, vs2, vs2, 3
; CHECK-BE-NEXT:    xxswapd vs2, vs2
; CHECK-BE-NEXT:    xscvspdpn f8, vs8
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xxmrghd vs2, vs2, vs8
; CHECK-BE-NEXT:    stxv vs5, 32(r3)
; CHECK-BE-NEXT:    xvcvdpuxds vs4, vs4
; CHECK-BE-NEXT:    xvcvdpuxds vs6, vs6
; CHECK-BE-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-BE-NEXT:    xvcvdpuxds vs7, vs7
; CHECK-BE-NEXT:    stxv vs3, 80(r3)
; CHECK-BE-NEXT:    stxv vs7, 96(r3)
; CHECK-BE-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-BE-NEXT:    stxv vs2, 112(r3)
; CHECK-BE-NEXT:    stxv vs6, 64(r3)
; CHECK-BE-NEXT:    stxv vs4, 48(r3)
; CHECK-BE-NEXT:    stxv vs1, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <16 x float>, <16 x float>* %0, align 64
  %1 = fptoui <16 x float> %a to <16 x i64>
  store <16 x i64> %1, <16 x i64>* %agg.result, align 128
  ret void
}

define <2 x i64> @test2elt_signed(i64 %a.coerce) local_unnamed_addr #0 {
; CHECK-P8-LABEL: test2elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    mtvsrd f0, r3
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xxmrghd vs0, vs0, vs1
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test2elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    mtvsrd f0, r3
; CHECK-P9-NEXT:    xxswapd v2, vs0
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xxmrghd vs0, vs0, vs1
; CHECK-P9-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test2elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    mtvsrd f0, r3
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-BE-NEXT:    xvcvdpuxds v2, vs0
; CHECK-BE-NEXT:    blr
entry:
  %0 = bitcast i64 %a.coerce to <2 x float>
  %1 = fptoui <2 x float> %0 to <2 x i64>
  ret <2 x i64> %1
}

define void @test4elt_signed(<4 x i64>* noalias nocapture sret %agg.result, <4 x float> %a) local_unnamed_addr #1 {
; CHECK-P8-LABEL: test4elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    li r4, 16
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-P8-NEXT:    xxmrghd vs1, vs2, vs3
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P8-NEXT:    xvcvdpuxds v3, vs1
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxswapd vs0, v3
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r4
; CHECK-P8-NEXT:    stxvd2x vs1, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test4elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P9-NEXT:    xxswapd vs1, v2
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xxsldwi vs2, v2, v2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, v2
; CHECK-P9-NEXT:    xxmrghd vs1, vs1, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    stxv vs1, 16(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test4elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    xxsldwi vs1, v2, v2, 1
; CHECK-BE-NEXT:    xscvspdpn f0, v2
; CHECK-BE-NEXT:    xxswapd vs2, v2
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xxmrghd vs0, vs0, vs1
; CHECK-BE-NEXT:    xxsldwi vs1, v2, v2, 3
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    xxmrghd vs1, vs2, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    blr
entry:
  %0 = fptoui <4 x float> %a to <4 x i64>
  store <4 x i64> %0, <4 x i64>* %agg.result, align 32
  ret void
}

define void @test8elt_signed(<8 x i64>* noalias nocapture sret %agg.result, <8 x float>* nocapture readonly) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test8elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    lvx v3, 0, r4
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    lvx v2, r4, r5
; CHECK-P8-NEXT:    li r4, 48
; CHECK-P8-NEXT:    xxsldwi vs5, v3, v3, 3
; CHECK-P8-NEXT:    xxswapd vs6, v3
; CHECK-P8-NEXT:    xxsldwi vs0, v2, v2, 3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxsldwi vs3, v2, v2, 1
; CHECK-P8-NEXT:    xxsldwi vs7, v3, v3, 1
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xscvspdpn f4, v3
; CHECK-P8-NEXT:    xscvspdpn f0, vs0
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xscvspdpn f6, vs6
; CHECK-P8-NEXT:    xscvspdpn f7, vs7
; CHECK-P8-NEXT:    xxmrghd vs0, vs1, vs0
; CHECK-P8-NEXT:    xxmrghd vs1, vs2, vs3
; CHECK-P8-NEXT:    xxmrghd vs2, vs6, vs5
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs0
; CHECK-P8-NEXT:    xxmrghd vs3, vs4, vs7
; CHECK-P8-NEXT:    xvcvdpuxds v3, vs1
; CHECK-P8-NEXT:    xvcvdpuxds v4, vs2
; CHECK-P8-NEXT:    xvcvdpuxds v5, vs3
; CHECK-P8-NEXT:    xxswapd vs1, v2
; CHECK-P8-NEXT:    xxswapd vs0, v3
; CHECK-P8-NEXT:    xxswapd vs3, v4
; CHECK-P8-NEXT:    xxswapd vs2, v5
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r4
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs3, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test8elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs0, 0(r4)
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xxswapd vs2, vs0
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xscvspdpn f3, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxmrghd vs1, vs2, vs1
; CHECK-P9-NEXT:    lxv vs2, 16(r4)
; CHECK-P9-NEXT:    xxmrghd vs0, vs3, vs0
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    xxsldwi vs3, vs2, vs2, 3
; CHECK-P9-NEXT:    xxswapd vs4, vs2
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xscvspdpn f4, vs4
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    xxmrghd vs3, vs4, vs3
; CHECK-P9-NEXT:    xscvspdpn f4, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P9-NEXT:    xxmrghd vs2, vs4, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P9-NEXT:    stxv vs3, 32(r3)
; CHECK-P9-NEXT:    stxv vs2, 48(r3)
; CHECK-P9-NEXT:    stxv vs1, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test8elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs1, 0(r4)
; CHECK-BE-NEXT:    xxsldwi vs3, vs1, vs1, 1
; CHECK-BE-NEXT:    xscvspdpn f2, vs1
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    lxv vs0, 16(r4)
; CHECK-BE-NEXT:    xxsldwi vs4, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xxmrghd vs2, vs2, vs3
; CHECK-BE-NEXT:    xxsldwi vs3, vs1, vs1, 3
; CHECK-BE-NEXT:    xxswapd vs1, vs1
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    xscvspdpn f1, vs1
; CHECK-BE-NEXT:    xxmrghd vs1, vs1, vs3
; CHECK-BE-NEXT:    xscvspdpn f3, vs0
; CHECK-BE-NEXT:    xxmrghd vs3, vs3, vs4
; CHECK-BE-NEXT:    xxsldwi vs4, vs0, vs0, 3
; CHECK-BE-NEXT:    xxswapd vs0, vs0
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xxmrghd vs0, vs0, vs4
; CHECK-BE-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-BE-NEXT:    stxv vs1, 16(r3)
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    stxv vs3, 32(r3)
; CHECK-BE-NEXT:    stxv vs0, 48(r3)
; CHECK-BE-NEXT:    stxv vs2, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <8 x float>, <8 x float>* %0, align 32
  %1 = fptoui <8 x float> %a to <8 x i64>
  store <8 x i64> %1, <8 x i64>* %agg.result, align 64
  ret void
}

define void @test16elt_signed(<16 x i64>* noalias nocapture sret %agg.result, <16 x float>* nocapture readonly) local_unnamed_addr #2 {
; CHECK-P8-LABEL: test16elt_signed:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 16
; CHECK-P8-NEXT:    li r7, 48
; CHECK-P8-NEXT:    li r6, 32
; CHECK-P8-NEXT:    lvx v4, 0, r4
; CHECK-P8-NEXT:    li r8, 64
; CHECK-P8-NEXT:    lvx v5, r4, r5
; CHECK-P8-NEXT:    lvx v3, r4, r7
; CHECK-P8-NEXT:    lvx v2, r4, r6
; CHECK-P8-NEXT:    li r4, 112
; CHECK-P8-NEXT:    xxsldwi vs13, v4, v4, 3
; CHECK-P8-NEXT:    xscvspdpn f6, v4
; CHECK-P8-NEXT:    xxsldwi vs1, v5, v5, 3
; CHECK-P8-NEXT:    xxswapd vs3, v5
; CHECK-P8-NEXT:    xxsldwi vs9, v3, v3, 1
; CHECK-P8-NEXT:    xscvspdpn f4, v3
; CHECK-P8-NEXT:    xxsldwi vs5, v5, v5, 1
; CHECK-P8-NEXT:    xxsldwi vs10, v3, v3, 3
; CHECK-P8-NEXT:    xscvspdpn f1, vs1
; CHECK-P8-NEXT:    xxswapd vs11, v3
; CHECK-P8-NEXT:    xscvspdpn f3, vs3
; CHECK-P8-NEXT:    xxsldwi vs7, v2, v2, 3
; CHECK-P8-NEXT:    xscvspdpn f9, vs9
; CHECK-P8-NEXT:    xxswapd vs8, v2
; CHECK-P8-NEXT:    xscvspdpn f0, v5
; CHECK-P8-NEXT:    xxsldwi vs12, v2, v2, 1
; CHECK-P8-NEXT:    xscvspdpn f2, v2
; CHECK-P8-NEXT:    xxswapd v2, v4
; CHECK-P8-NEXT:    xscvspdpn f5, vs5
; CHECK-P8-NEXT:    xxsldwi v3, v4, v4, 1
; CHECK-P8-NEXT:    xscvspdpn f10, vs10
; CHECK-P8-NEXT:    xscvspdpn f11, vs11
; CHECK-P8-NEXT:    xxmrghd vs1, vs3, vs1
; CHECK-P8-NEXT:    xscvspdpn f7, vs7
; CHECK-P8-NEXT:    xxmrghd vs4, vs4, vs9
; CHECK-P8-NEXT:    xscvspdpn f8, vs8
; CHECK-P8-NEXT:    xscvspdpn f12, vs12
; CHECK-P8-NEXT:    xscvspdpn f13, vs13
; CHECK-P8-NEXT:    xxmrghd vs0, vs0, vs5
; CHECK-P8-NEXT:    xscvspdpn f3, v2
; CHECK-P8-NEXT:    xscvspdpn f9, v3
; CHECK-P8-NEXT:    xxmrghd vs5, vs11, vs10
; CHECK-P8-NEXT:    xvcvdpuxds v3, vs4
; CHECK-P8-NEXT:    xvcvdpuxds v2, vs1
; CHECK-P8-NEXT:    xxmrghd vs1, vs2, vs12
; CHECK-P8-NEXT:    xxmrghd vs2, vs8, vs7
; CHECK-P8-NEXT:    xvcvdpuxds v4, vs0
; CHECK-P8-NEXT:    xxmrghd vs0, vs3, vs13
; CHECK-P8-NEXT:    xvcvdpuxds v5, vs5
; CHECK-P8-NEXT:    xxmrghd vs3, vs6, vs9
; CHECK-P8-NEXT:    xvcvdpuxds v0, vs1
; CHECK-P8-NEXT:    xvcvdpuxds v1, vs2
; CHECK-P8-NEXT:    xvcvdpuxds v6, vs0
; CHECK-P8-NEXT:    xxswapd vs0, v3
; CHECK-P8-NEXT:    xvcvdpuxds v7, vs3
; CHECK-P8-NEXT:    xxswapd vs4, v2
; CHECK-P8-NEXT:    xxswapd vs3, v4
; CHECK-P8-NEXT:    xxswapd vs1, v5
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r4
; CHECK-P8-NEXT:    li r4, 96
; CHECK-P8-NEXT:    xxswapd vs2, v0
; CHECK-P8-NEXT:    xxswapd vs0, v1
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r4
; CHECK-P8-NEXT:    xxswapd vs5, v6
; CHECK-P8-NEXT:    li r4, 80
; CHECK-P8-NEXT:    xxswapd vs1, v7
; CHECK-P8-NEXT:    stxvd2x vs2, r3, r4
; CHECK-P8-NEXT:    stxvd2x vs0, r3, r8
; CHECK-P8-NEXT:    stxvd2x vs3, r3, r7
; CHECK-P8-NEXT:    stxvd2x vs4, r3, r6
; CHECK-P8-NEXT:    stxvd2x vs1, r3, r5
; CHECK-P8-NEXT:    stxvd2x vs5, 0, r3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: test16elt_signed:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxv vs4, 16(r4)
; CHECK-P9-NEXT:    xxsldwi vs5, vs4, vs4, 3
; CHECK-P9-NEXT:    xxswapd vs6, vs4
; CHECK-P9-NEXT:    lxv vs0, 0(r4)
; CHECK-P9-NEXT:    xxsldwi vs1, vs0, vs0, 3
; CHECK-P9-NEXT:    xxswapd vs2, vs0
; CHECK-P9-NEXT:    xscvspdpn f5, vs5
; CHECK-P9-NEXT:    xscvspdpn f6, vs6
; CHECK-P9-NEXT:    xxmrghd vs5, vs6, vs5
; CHECK-P9-NEXT:    xscvspdpn f6, vs4
; CHECK-P9-NEXT:    xxsldwi vs4, vs4, vs4, 1
; CHECK-P9-NEXT:    lxv vs3, 32(r4)
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xxswapd vs7, vs3
; CHECK-P9-NEXT:    xscvspdpn f7, vs7
; CHECK-P9-NEXT:    xscvspdpn f4, vs4
; CHECK-P9-NEXT:    xscvspdpn f1, vs1
; CHECK-P9-NEXT:    xxmrghd vs1, vs2, vs1
; CHECK-P9-NEXT:    xscvspdpn f2, vs0
; CHECK-P9-NEXT:    xxsldwi vs0, vs0, vs0, 1
; CHECK-P9-NEXT:    xscvspdpn f0, vs0
; CHECK-P9-NEXT:    xxmrghd vs0, vs2, vs0
; CHECK-P9-NEXT:    xxmrghd vs4, vs6, vs4
; CHECK-P9-NEXT:    xxsldwi vs6, vs3, vs3, 3
; CHECK-P9-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-P9-NEXT:    xvcvdpuxds vs5, vs5
; CHECK-P9-NEXT:    xscvspdpn f6, vs6
; CHECK-P9-NEXT:    xxmrghd vs6, vs7, vs6
; CHECK-P9-NEXT:    xscvspdpn f7, vs3
; CHECK-P9-NEXT:    xxsldwi vs3, vs3, vs3, 1
; CHECK-P9-NEXT:    lxv vs2, 48(r4)
; CHECK-P9-NEXT:    xxswapd vs8, vs2
; CHECK-P9-NEXT:    xscvspdpn f8, vs8
; CHECK-P9-NEXT:    xvcvdpuxds vs4, vs4
; CHECK-P9-NEXT:    xscvspdpn f3, vs3
; CHECK-P9-NEXT:    xxmrghd vs3, vs7, vs3
; CHECK-P9-NEXT:    xxsldwi vs7, vs2, vs2, 3
; CHECK-P9-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-P9-NEXT:    xvcvdpuxds vs6, vs6
; CHECK-P9-NEXT:    stxv vs6, 64(r3)
; CHECK-P9-NEXT:    xscvspdpn f7, vs7
; CHECK-P9-NEXT:    xxmrghd vs7, vs8, vs7
; CHECK-P9-NEXT:    xscvspdpn f8, vs2
; CHECK-P9-NEXT:    xxsldwi vs2, vs2, vs2, 1
; CHECK-P9-NEXT:    xscvspdpn f2, vs2
; CHECK-P9-NEXT:    xxmrghd vs2, vs8, vs2
; CHECK-P9-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-P9-NEXT:    xvcvdpuxds vs7, vs7
; CHECK-P9-NEXT:    stxv vs3, 80(r3)
; CHECK-P9-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-P9-NEXT:    stxv vs7, 96(r3)
; CHECK-P9-NEXT:    stxv vs2, 112(r3)
; CHECK-P9-NEXT:    stxv vs4, 48(r3)
; CHECK-P9-NEXT:    stxv vs5, 32(r3)
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    stxv vs1, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-BE-LABEL: test16elt_signed:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxv vs0, 0(r4)
; CHECK-BE-NEXT:    lxv vs4, 16(r4)
; CHECK-BE-NEXT:    xxsldwi vs2, vs0, vs0, 1
; CHECK-BE-NEXT:    xscvspdpn f1, vs0
; CHECK-BE-NEXT:    xxsldwi vs5, vs0, vs0, 3
; CHECK-BE-NEXT:    xxswapd vs0, vs0
; CHECK-BE-NEXT:    xscvspdpn f5, vs5
; CHECK-BE-NEXT:    xscvspdpn f0, vs0
; CHECK-BE-NEXT:    xxsldwi vs6, vs4, vs4, 1
; CHECK-BE-NEXT:    xscvspdpn f6, vs6
; CHECK-BE-NEXT:    xxmrghd vs0, vs0, vs5
; CHECK-BE-NEXT:    xscvspdpn f5, vs4
; CHECK-BE-NEXT:    lxv vs3, 32(r4)
; CHECK-BE-NEXT:    xxsldwi vs7, vs3, vs3, 1
; CHECK-BE-NEXT:    xscvspdpn f7, vs7
; CHECK-BE-NEXT:    xxmrghd vs5, vs5, vs6
; CHECK-BE-NEXT:    xxsldwi vs6, vs4, vs4, 3
; CHECK-BE-NEXT:    xxswapd vs4, vs4
; CHECK-BE-NEXT:    xscvspdpn f6, vs6
; CHECK-BE-NEXT:    xscvspdpn f4, vs4
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xxmrghd vs1, vs1, vs2
; CHECK-BE-NEXT:    lxv vs2, 48(r4)
; CHECK-BE-NEXT:    xxsldwi vs8, vs2, vs2, 1
; CHECK-BE-NEXT:    xvcvdpuxds vs1, vs1
; CHECK-BE-NEXT:    xvcvdpuxds vs0, vs0
; CHECK-BE-NEXT:    xvcvdpuxds vs5, vs5
; CHECK-BE-NEXT:    xscvspdpn f8, vs8
; CHECK-BE-NEXT:    xxmrghd vs4, vs4, vs6
; CHECK-BE-NEXT:    xscvspdpn f6, vs3
; CHECK-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-BE-NEXT:    xxmrghd vs6, vs6, vs7
; CHECK-BE-NEXT:    xxsldwi vs7, vs3, vs3, 3
; CHECK-BE-NEXT:    xxswapd vs3, vs3
; CHECK-BE-NEXT:    xscvspdpn f7, vs7
; CHECK-BE-NEXT:    xscvspdpn f3, vs3
; CHECK-BE-NEXT:    xxmrghd vs3, vs3, vs7
; CHECK-BE-NEXT:    xscvspdpn f7, vs2
; CHECK-BE-NEXT:    xxmrghd vs7, vs7, vs8
; CHECK-BE-NEXT:    xxsldwi vs8, vs2, vs2, 3
; CHECK-BE-NEXT:    xxswapd vs2, vs2
; CHECK-BE-NEXT:    xscvspdpn f8, vs8
; CHECK-BE-NEXT:    xscvspdpn f2, vs2
; CHECK-BE-NEXT:    xxmrghd vs2, vs2, vs8
; CHECK-BE-NEXT:    stxv vs5, 32(r3)
; CHECK-BE-NEXT:    xvcvdpuxds vs4, vs4
; CHECK-BE-NEXT:    xvcvdpuxds vs6, vs6
; CHECK-BE-NEXT:    xvcvdpuxds vs3, vs3
; CHECK-BE-NEXT:    xvcvdpuxds vs7, vs7
; CHECK-BE-NEXT:    stxv vs3, 80(r3)
; CHECK-BE-NEXT:    stxv vs7, 96(r3)
; CHECK-BE-NEXT:    xvcvdpuxds vs2, vs2
; CHECK-BE-NEXT:    stxv vs2, 112(r3)
; CHECK-BE-NEXT:    stxv vs6, 64(r3)
; CHECK-BE-NEXT:    stxv vs4, 48(r3)
; CHECK-BE-NEXT:    stxv vs1, 0(r3)
; CHECK-BE-NEXT:    blr
entry:
  %a = load <16 x float>, <16 x float>* %0, align 64
  %1 = fptoui <16 x float> %a to <16 x i64>
  store <16 x i64> %1, <16 x i64>* %agg.result, align 128
  ret void
}
