/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.logging;

import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.CacheSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private static CacheSet<Object> warningsDone = CacheFactory.createCacheSet(100);

    private Log() {
    }

    public static void info(String caller, String msg) {
        Log.log(caller).info(msg);
    }

    public static void info(Object caller, String msg) {
        Log.log(caller.getClass()).info(msg);
    }

    public static void info(Class<?> cls, String msg) {
        Log.log(cls).info(msg);
    }

    public static void info(Object caller, String msg, Throwable th) {
        Log.log(caller.getClass()).info(msg, th);
    }

    public static void info(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).info(msg, th);
    }

    public static void debug(String caller, String msg) {
        Log.log(caller).debug(msg);
    }

    public static void debug(Object caller, String msg) {
        Log.log(caller.getClass()).debug(msg);
    }

    public static void debug(Class<?> cls, String msg) {
        Log.log(cls).debug(msg);
    }

    public static void debug(Object caller, String msg, Throwable th) {
        Log.log(caller.getClass()).debug(msg, th);
    }

    public static void debug(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).debug(msg, th);
    }

    public static void warn(String caller, String msg) {
        Log.log(caller).warn(msg);
    }

    public static void warn(Object caller, String msg) {
        Log.warn(caller.getClass(), msg);
    }

    public static void warn(Class<?> cls, String msg) {
        Log.log(cls).warn(msg);
    }

    public static void warn(Object caller, String msg, Throwable th) {
        Log.warn(caller.getClass(), msg, th);
    }

    public static void warn(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).warn(msg, th);
    }

    public static void error(Object caller, String msg) {
        Log.error(caller.getClass(), msg);
    }

    public static void error(Class<?> cls, String msg) {
        Log.log(cls).error(msg);
    }

    public static void error(Object caller, String msg, Throwable th) {
        Log.error(caller.getClass(), msg, th);
    }

    public static void error(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).error(msg, th);
    }

    public static void error(String caller, String msg) {
        Log.log(caller).error(msg);
    }

    @Deprecated
    public static void fatal(Object caller, String msg) {
        Log.fatal(caller.getClass(), msg);
    }

    @Deprecated
    public static void fatal(Class<?> cls, String msg) {
        Log.log(cls).error(msg);
    }

    @Deprecated
    public static void fatal(Object caller, String msg, Throwable th) {
        Log.fatal(caller.getClass(), msg, th);
    }

    @Deprecated
    public static void fatal(Class<?> cls, String msg, Throwable th) {
        Log.log(cls).error(msg, th);
    }

    @Deprecated
    public static void fatal(String caller, String msg) {
        Log.log(caller).error(msg);
    }

    private static Logger log(Class<?> cls) {
        return LoggerFactory.getLogger(cls);
    }

    private static Logger log(String loggerName) {
        return LoggerFactory.getLogger(loggerName);
    }

    public static void warnOnce(Class<?> cls, String message, Object key) {
        if (!warningsDone.contains(key)) {
            Log.warn(cls, message);
            warningsDone.add(key);
        }
    }
}

