/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.Assignment;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.FunctionNode;
import com.google.javascript.rhino.head.ast.Name;
import com.google.javascript.rhino.head.ast.ObjectProperty;

public class AstUtil {
    private static final String PROTOTYPE_SUFFIX = ".prototype";

    static boolean hasParentOfType(AstNode astNode, int n) {
        AstNode astNode2 = astNode.getParent();
        if (astNode2 == null) {
            return false;
        }
        return astNode2.getType() == n;
    }

    static AstNode getFunctionNameNode(FunctionNode functionNode) {
        Assignment assignment;
        Name name = functionNode.getFunctionName();
        if (name != null) {
            return name;
        }
        if (AstUtil.hasParentOfType(functionNode, 103)) {
            return ((ObjectProperty)functionNode.getParent()).getLeft();
        }
        if (AstUtil.hasParentOfType(functionNode, 90) && (assignment = (Assignment)functionNode.getParent()).getRight() == functionNode) {
            return assignment.getLeft();
        }
        return null;
    }

    static String getTypeNameFromPrototype(String string) {
        return string.substring(0, string.length() - PROTOTYPE_SUFFIX.length());
    }

    static boolean isPrototypeName(String string) {
        return string.endsWith(PROTOTYPE_SUFFIX);
    }

    static AstNode getAssignedTypeNameNode(Assignment assignment) {
        AstNode astNode = assignment.getLeft();
        if (astNode.getType() != 33 && astNode.getType() != 39) {
            return null;
        }
        return astNode;
    }

    static Comment getJsDocNode(AstNode astNode) {
        if (astNode.getType() == 109) {
            return AstUtil.getJsDocNode((FunctionNode)astNode);
        }
        return astNode.getJsDocNode();
    }

    static Comment getJsDocNode(FunctionNode functionNode) {
        Assignment assignment;
        Comment comment = functionNode.getJsDocNode();
        if (comment != null) {
            return comment;
        }
        if (AstUtil.hasParentOfType(functionNode, 90) && (assignment = (Assignment)functionNode.getParent()).getRight() == functionNode && (comment = assignment.getJsDocNode()) != null) {
            return comment;
        }
        if (AstUtil.hasParentOfType(functionNode, 103) && (comment = ((ObjectProperty)functionNode.getParent()).getLeft().getJsDocNode()) != null) {
            return comment;
        }
        return null;
    }

    private AstUtil() {
    }
}

