function sscsv_write (ss_index, kinds)
%SSCSV_WRITE: create the ssstats.csv file

if (nargin < 2)
    kinds = sskinds ;
end
if (nargin < 1)
    ss_index = ssget ;
end

f = fopen ('ssstats.csv', 'w') ;
nmat = length (ss_index.nrows) ;
fprintf (f, '%d\n', nmat) ;
fprintf (f, '%s\n', ss_index.LastRevisionDate) ;
for id = 1:nmat
    fprintf (f,'%s,%s,%d,%d,%d,%d,%d,%d,%d,%.16g,%.16g,%s,%d\n', ...
        ss_index.Group {id}, ...
        ss_index.Name {id}, ...
        ss_index.nrows (id), ...
        ss_index.ncols (id), ...
        ss_index.nnz (id), ...
        ss_index.isReal (id), ...
        ss_index.isBinary (id), ...
        ss_index.isND (id), ...
        ss_index.posdef (id), ...
        ss_index.pattern_symmetry (id), ...   % formatted with %.16g
        ss_index.numerical_symmetry (id), ... % formatted with %.16g
        kinds {id}, ...
        ss_index.nentries (id)) ;       % added # entries
end
fclose (f) ;

