Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
    .getService(Components.interfaces.nsIConsoleService);

function UnityWindowHelper (aWindow) {
    this.window = aWindow;
}

UnityWindowHelper.prototype.FindToplevelContentWindow = function (aWindow) {
    var toplevelContentWindow = aWindow;
    
    while (toplevelContentWindow.parent != toplevelContentWindow){
	toplevelContentWindow = toplevelContentWindow.parent;
    }
    
    return toplevelContentWindow;
}

UnityWindowHelper.prototype.makeCloseCallback = function () {
    var window = this.window;
    var self = this;
    
    var closeCallback = function(context, userData) {
	var mainWindow = window.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
            .getInterface(Components.interfaces.nsIWebNavigation)
            .QueryInterface(Components.interfaces.nsIDocShellTreeItem)
            .rootTreeItem
            .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
            .getInterface(Components.interfaces.nsIDOMWindow);

	var toplevelContentWindow = self.FindToplevelContentWindow(window);	
	var tab = mainWindow.gBrowser.tabs.item(mainWindow.gBrowser.getBrowserIndexForDocument (toplevelContentWindow.document));
	
	mainWindow.gBrowser.removeTab (tab);
    }
    
    return closeCallback;
}

UnityWindowHelper.prototype.makeRaiseCallback = function (unity) {
    var window = this.window;
    var uwin = XPCNativeWrapper.unwrap(window);
    var self = this;

    var raiseCallback = function(context, file, userData) {
	var toplevelContentWindow = self.FindToplevelContentWindow(window);
	var mainWindow = toplevelContentWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
            .getInterface(Components.interfaces.nsIWebNavigation)
            .QueryInterface(Components.interfaces.nsIDocShellTreeItem)
            .rootTreeItem
            .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
            .getInterface(Components.interfaces.nsIDOMWindow);

        var chromeWindow = mainWindow.QueryInterface(Components.interfaces.nsIInterfaceRequestor).getInterface(Components.interfaces.nsIDOMChromeWindow);
        uwin.focus();
        mainWindow.focus();
        chromeWindow.getAttention();

        var index = mainWindow.gBrowser.getBrowserIndexForDocument (toplevelContentWindow.document);

        var tab = mainWindow.gBrowser.tabContainer.childNodes[index];
        index = mainWindow.gBrowser.visibleTabs.indexOf(tab);
        if (index == -1) {
            if (mainWindow.TabView.getContentWindow())
                mainWindow.TabView.getContentWindow().UI.goToTab(tab);
        } else {
            mainWindow.gBrowser.selectTabAtIndex(index);
        }
        if (!file.isNull()) {
            if (unity.acceptDataCallback)
                unity.acceptDataCallback(File(file.readString()));
        }
    };

    return raiseCallback;
};

var EXPORTED_SYMBOLS = ["UnityWindowHelper"];
