/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class TernaryExpr
extends Expr {
    TernaryExpr(Expr pred, Expr ifTrue, Expr ifFalse) {
        super(pred, ifTrue, ifFalse);
    }

    public Expr getPred() {
        return this.getChildren().get(0);
    }

    public Expr getIfTrue() {
        return this.getChildren().get(1);
    }

    public Expr getIfFalse() {
        return this.getChildren().get(2);
    }

    @Override
    protected String computeUniqueKey() {
        return "?:" + super.computeUniqueKey();
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return modelAnalyzer.findCommonParentOf(this.getIfTrue().getResolvedType(), this.getIfFalse().getResolvedType());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        Expr ifFalseExpr;
        Expr ifTrueExpr;
        ArrayList<Dependency> deps = Lists.newArrayList();
        Expr predExpr = this.getPred();
        if (predExpr.isDynamic()) {
            Dependency pred = new Dependency(this, predExpr);
            pred.setMandatory(true);
            deps.add(pred);
        }
        if ((ifTrueExpr = this.getIfTrue()).isDynamic()) {
            deps.add(new Dependency(this, ifTrueExpr, predExpr, true));
        }
        if ((ifFalseExpr = this.getIfFalse()).isDynamic()) {
            deps.add(new Dependency(this, ifFalseExpr, predExpr, false));
        }
        return deps;
    }

    @Override
    protected BitSet getPredicateInvalidFlags() {
        return this.getPred().getInvalidFlags();
    }

    @Override
    public boolean isConditional() {
        return true;
    }
}

