// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/docker/swarmkit/api/dispatcher.proto

package api

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	github_com_moby_swarmkit_v2_api_deepcopy "github.com/moby/swarmkit/v2/api/deepcopy"
	raftselector "github.com/moby/swarmkit/v2/manager/raftselector"
	_ "github.com/moby/swarmkit/v2/protobuf/plugin"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	metadata "google.golang.org/grpc/metadata"
	peer "google.golang.org/grpc/peer"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
	rafttime "time"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type AssignmentChange_AssignmentAction int32

const (
	AssignmentChange_AssignmentActionUpdate AssignmentChange_AssignmentAction = 0
	AssignmentChange_AssignmentActionRemove AssignmentChange_AssignmentAction = 1
)

var AssignmentChange_AssignmentAction_name = map[int32]string{
	0: "UPDATE",
	1: "REMOVE",
}

var AssignmentChange_AssignmentAction_value = map[string]int32{
	"UPDATE": 0,
	"REMOVE": 1,
}

func (x AssignmentChange_AssignmentAction) String() string {
	return proto.EnumName(AssignmentChange_AssignmentAction_name, int32(x))
}

func (AssignmentChange_AssignmentAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{12, 0}
}

// AssignmentType specifies whether this assignment message carries
// the full state, or is an update to an existing state.
type AssignmentsMessage_Type int32

const (
	AssignmentsMessage_COMPLETE    AssignmentsMessage_Type = 0
	AssignmentsMessage_INCREMENTAL AssignmentsMessage_Type = 1
)

var AssignmentsMessage_Type_name = map[int32]string{
	0: "COMPLETE",
	1: "INCREMENTAL",
}

var AssignmentsMessage_Type_value = map[string]int32{
	"COMPLETE":    0,
	"INCREMENTAL": 1,
}

func (x AssignmentsMessage_Type) String() string {
	return proto.EnumName(AssignmentsMessage_Type_name, int32(x))
}

func (AssignmentsMessage_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{13, 0}
}

// SessionRequest starts a session.
type SessionRequest struct {
	Description *NodeDescription `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// SessionID can be provided to attempt resuming an existing session. If the
	// SessionID is empty or invalid, a new SessionID will be assigned.
	//
	// See SessionMessage.SessionID for details.
	SessionID string `protobuf:"bytes,2,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *SessionRequest) Reset()      { *m = SessionRequest{} }
func (*SessionRequest) ProtoMessage() {}
func (*SessionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{0}
}
func (m *SessionRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SessionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SessionRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SessionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SessionRequest.Merge(m, src)
}
func (m *SessionRequest) XXX_Size() int {
	return m.Size()
}
func (m *SessionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SessionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SessionRequest proto.InternalMessageInfo

// SessionMessage instructs an agent on various actions as part of the current
// session. An agent should act immediately on the contents.
type SessionMessage struct {
	// SessionID is allocated after a successful registration. It should be
	// used on all RPC calls after registration. A dispatcher may choose to
	// change the SessionID, at which time an agent must re-register and obtain
	// a new one.
	//
	// All Dispatcher calls after register should include the SessionID. If the
	// Dispatcher so chooses, it may reject the call with an InvalidArgument
	// error code, at which time the agent should call Register to start a new
	// session.
	//
	// As a rule, once an agent has a SessionID, it should never save it to
	// disk or try to otherwise reuse. If the agent loses its SessionID, it
	// must start a new session through a call to Register. A Dispatcher may
	// choose to reuse the SessionID, if it sees fit, but it is not advised.
	//
	// The actual implementation of the SessionID is Dispatcher specific and
	// should be treated as opaque by agents.
	//
	// From a Dispatcher perspective, there are many ways to use the SessionID
	// to ensure uniqueness of a set of client RPC calls. One method is to keep
	// the SessionID unique to every call to Register in a single Dispatcher
	// instance. This ensures that the SessionID represents the unique
	// session from a single Agent to Manager. If the Agent restarts, we
	// allocate a new session, since the restarted Agent is not aware of the
	// new SessionID.
	//
	// The most compelling use case is to support duplicate node detection. If
	// one clones a virtual machine, including certificate material, two nodes
	// may end up with the same identity. This can also happen if two identical
	// agent processes are coming from the same node. If the SessionID is
	// replicated through the cluster, we can immediately detect the condition
	// and address it.
	//
	// Extending from the case above, we can actually detect a compromised
	// identity. Coupled with provisions to rebuild node identity, we can ban
	// the compromised node identity and have the nodes re-authenticate and
	// build a new identity. At this time, an administrator can then
	// re-authorize the compromised nodes, if it was a mistake or ensure that a
	// misbehaved node can no longer connect to the cluster.
	//
	// We considered placing this field in a GRPC header. Because this is a
	// critical feature of the protocol, we thought it should be represented
	// directly in the RPC message set.
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Node identifies the registering node.
	Node *Node `protobuf:"bytes,2,opt,name=node,proto3" json:"node,omitempty"`
	// Managers provides a weight list of alternative dispatchers
	Managers []*WeightedPeer `protobuf:"bytes,3,rep,name=managers,proto3" json:"managers,omitempty"`
	// Symmetric encryption key distributed by the lead manager. Used by agents
	// for securing network bootstrapping and communication.
	NetworkBootstrapKeys []*EncryptionKey `protobuf:"bytes,4,rep,name=network_bootstrap_keys,json=networkBootstrapKeys,proto3" json:"network_bootstrap_keys,omitempty"`
	// Which root certificates to trust
	RootCA []byte `protobuf:"bytes,5,opt,name=RootCA,proto3" json:"RootCA,omitempty"`
}

func (m *SessionMessage) Reset()      { *m = SessionMessage{} }
func (*SessionMessage) ProtoMessage() {}
func (*SessionMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{1}
}
func (m *SessionMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SessionMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SessionMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SessionMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SessionMessage.Merge(m, src)
}
func (m *SessionMessage) XXX_Size() int {
	return m.Size()
}
func (m *SessionMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_SessionMessage.DiscardUnknown(m)
}

var xxx_messageInfo_SessionMessage proto.InternalMessageInfo

// HeartbeatRequest provides identifying properties for a single heartbeat.
type HeartbeatRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *HeartbeatRequest) Reset()      { *m = HeartbeatRequest{} }
func (*HeartbeatRequest) ProtoMessage() {}
func (*HeartbeatRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{2}
}
func (m *HeartbeatRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeartbeatRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HeartbeatRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HeartbeatRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeartbeatRequest.Merge(m, src)
}
func (m *HeartbeatRequest) XXX_Size() int {
	return m.Size()
}
func (m *HeartbeatRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HeartbeatRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HeartbeatRequest proto.InternalMessageInfo

type HeartbeatResponse struct {
	// Period is the duration to wait before sending the next heartbeat.
	// Well-behaved agents should update this on every heartbeat round trip.
	Period time.Duration `protobuf:"bytes,1,opt,name=period,proto3,stdduration" json:"period"`
}

func (m *HeartbeatResponse) Reset()      { *m = HeartbeatResponse{} }
func (*HeartbeatResponse) ProtoMessage() {}
func (*HeartbeatResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{3}
}
func (m *HeartbeatResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeartbeatResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HeartbeatResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HeartbeatResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeartbeatResponse.Merge(m, src)
}
func (m *HeartbeatResponse) XXX_Size() int {
	return m.Size()
}
func (m *HeartbeatResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_HeartbeatResponse.DiscardUnknown(m)
}

var xxx_messageInfo_HeartbeatResponse proto.InternalMessageInfo

type UpdateTaskStatusRequest struct {
	// Tasks should contain all statuses for running tasks. Only the status
	// field must be set. The spec is not required.
	SessionID string                                      `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	Updates   []*UpdateTaskStatusRequest_TaskStatusUpdate `protobuf:"bytes,3,rep,name=updates,proto3" json:"updates,omitempty"`
}

func (m *UpdateTaskStatusRequest) Reset()      { *m = UpdateTaskStatusRequest{} }
func (*UpdateTaskStatusRequest) ProtoMessage() {}
func (*UpdateTaskStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{4}
}
func (m *UpdateTaskStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateTaskStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateTaskStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateTaskStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTaskStatusRequest.Merge(m, src)
}
func (m *UpdateTaskStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateTaskStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTaskStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTaskStatusRequest proto.InternalMessageInfo

type UpdateTaskStatusRequest_TaskStatusUpdate struct {
	TaskID string      `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	Status *TaskStatus `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Reset() {
	*m = UpdateTaskStatusRequest_TaskStatusUpdate{}
}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) ProtoMessage() {}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{4, 0}
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateTaskStatusRequest_TaskStatusUpdate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTaskStatusRequest_TaskStatusUpdate.Merge(m, src)
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) XXX_Size() int {
	return m.Size()
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTaskStatusRequest_TaskStatusUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTaskStatusRequest_TaskStatusUpdate proto.InternalMessageInfo

type UpdateTaskStatusResponse struct {
}

func (m *UpdateTaskStatusResponse) Reset()      { *m = UpdateTaskStatusResponse{} }
func (*UpdateTaskStatusResponse) ProtoMessage() {}
func (*UpdateTaskStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{5}
}
func (m *UpdateTaskStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateTaskStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateTaskStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateTaskStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTaskStatusResponse.Merge(m, src)
}
func (m *UpdateTaskStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateTaskStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTaskStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTaskStatusResponse proto.InternalMessageInfo

type UpdateVolumeStatusRequest struct {
	SessionID string                                          `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	Updates   []*UpdateVolumeStatusRequest_VolumeStatusUpdate `protobuf:"bytes,2,rep,name=updates,proto3" json:"updates,omitempty"`
}

func (m *UpdateVolumeStatusRequest) Reset()      { *m = UpdateVolumeStatusRequest{} }
func (*UpdateVolumeStatusRequest) ProtoMessage() {}
func (*UpdateVolumeStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{6}
}
func (m *UpdateVolumeStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateVolumeStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateVolumeStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateVolumeStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateVolumeStatusRequest.Merge(m, src)
}
func (m *UpdateVolumeStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateVolumeStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateVolumeStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateVolumeStatusRequest proto.InternalMessageInfo

type UpdateVolumeStatusRequest_VolumeStatusUpdate struct {
	// ID is the ID of the volume being updated. This is the Swarmkit ID,
	// not the CSI VolumeID.
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Unpublished is set to true when the volume is affirmatively
	// unpublished on the Node side. We don't need to report that a Volume
	// is published on the the node; as soon as the Volume is assigned to
	// the Node, we must assume that it has been published until informed
	// otherwise.
	//
	// Further, the Node must not send unpublished = true unless it will
	// definitely no longer attempt to call NodePublishVolume.
	Unpublished bool `protobuf:"varint,2,opt,name=unpublished,proto3" json:"unpublished,omitempty"`
}

func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) Reset() {
	*m = UpdateVolumeStatusRequest_VolumeStatusUpdate{}
}
func (*UpdateVolumeStatusRequest_VolumeStatusUpdate) ProtoMessage() {}
func (*UpdateVolumeStatusRequest_VolumeStatusUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{6, 0}
}
func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateVolumeStatusRequest_VolumeStatusUpdate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateVolumeStatusRequest_VolumeStatusUpdate.Merge(m, src)
}
func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) XXX_Size() int {
	return m.Size()
}
func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateVolumeStatusRequest_VolumeStatusUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateVolumeStatusRequest_VolumeStatusUpdate proto.InternalMessageInfo

type UpdateVolumeStatusResponse struct {
}

func (m *UpdateVolumeStatusResponse) Reset()      { *m = UpdateVolumeStatusResponse{} }
func (*UpdateVolumeStatusResponse) ProtoMessage() {}
func (*UpdateVolumeStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{7}
}
func (m *UpdateVolumeStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateVolumeStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateVolumeStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateVolumeStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateVolumeStatusResponse.Merge(m, src)
}
func (m *UpdateVolumeStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *UpdateVolumeStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateVolumeStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateVolumeStatusResponse proto.InternalMessageInfo

type TasksRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *TasksRequest) Reset()      { *m = TasksRequest{} }
func (*TasksRequest) ProtoMessage() {}
func (*TasksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{8}
}
func (m *TasksRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TasksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TasksRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TasksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TasksRequest.Merge(m, src)
}
func (m *TasksRequest) XXX_Size() int {
	return m.Size()
}
func (m *TasksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TasksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TasksRequest proto.InternalMessageInfo

type TasksMessage struct {
	// Tasks is the set of tasks that should be running on the node.
	// Tasks outside of this set running on the node should be terminated.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks,proto3" json:"tasks,omitempty"`
}

func (m *TasksMessage) Reset()      { *m = TasksMessage{} }
func (*TasksMessage) ProtoMessage() {}
func (*TasksMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{9}
}
func (m *TasksMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TasksMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TasksMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TasksMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TasksMessage.Merge(m, src)
}
func (m *TasksMessage) XXX_Size() int {
	return m.Size()
}
func (m *TasksMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_TasksMessage.DiscardUnknown(m)
}

var xxx_messageInfo_TasksMessage proto.InternalMessageInfo

type AssignmentsRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *AssignmentsRequest) Reset()      { *m = AssignmentsRequest{} }
func (*AssignmentsRequest) ProtoMessage() {}
func (*AssignmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{10}
}
func (m *AssignmentsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssignmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssignmentsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssignmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssignmentsRequest.Merge(m, src)
}
func (m *AssignmentsRequest) XXX_Size() int {
	return m.Size()
}
func (m *AssignmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AssignmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AssignmentsRequest proto.InternalMessageInfo

type Assignment struct {
	// Types that are valid to be assigned to Item:
	//	*Assignment_Task
	//	*Assignment_Secret
	//	*Assignment_Config
	//	*Assignment_Volume
	Item isAssignment_Item `protobuf_oneof:"item"`
}

func (m *Assignment) Reset()      { *m = Assignment{} }
func (*Assignment) ProtoMessage() {}
func (*Assignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{11}
}
func (m *Assignment) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Assignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Assignment.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Assignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assignment.Merge(m, src)
}
func (m *Assignment) XXX_Size() int {
	return m.Size()
}
func (m *Assignment) XXX_DiscardUnknown() {
	xxx_messageInfo_Assignment.DiscardUnknown(m)
}

var xxx_messageInfo_Assignment proto.InternalMessageInfo

type isAssignment_Item interface {
	isAssignment_Item()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Assignment_Task struct {
	Task *Task `protobuf:"bytes,1,opt,name=task,proto3,oneof" json:"task,omitempty"`
}
type Assignment_Secret struct {
	Secret *Secret `protobuf:"bytes,2,opt,name=secret,proto3,oneof" json:"secret,omitempty"`
}
type Assignment_Config struct {
	Config *Config `protobuf:"bytes,3,opt,name=config,proto3,oneof" json:"config,omitempty"`
}
type Assignment_Volume struct {
	Volume *VolumeAssignment `protobuf:"bytes,4,opt,name=volume,proto3,oneof" json:"volume,omitempty"`
}

func (*Assignment_Task) isAssignment_Item()   {}
func (*Assignment_Secret) isAssignment_Item() {}
func (*Assignment_Config) isAssignment_Item() {}
func (*Assignment_Volume) isAssignment_Item() {}

func (m *Assignment) GetItem() isAssignment_Item {
	if m != nil {
		return m.Item
	}
	return nil
}

func (m *Assignment) GetTask() *Task {
	if x, ok := m.GetItem().(*Assignment_Task); ok {
		return x.Task
	}
	return nil
}

func (m *Assignment) GetSecret() *Secret {
	if x, ok := m.GetItem().(*Assignment_Secret); ok {
		return x.Secret
	}
	return nil
}

func (m *Assignment) GetConfig() *Config {
	if x, ok := m.GetItem().(*Assignment_Config); ok {
		return x.Config
	}
	return nil
}

func (m *Assignment) GetVolume() *VolumeAssignment {
	if x, ok := m.GetItem().(*Assignment_Volume); ok {
		return x.Volume
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Assignment) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Assignment_Task)(nil),
		(*Assignment_Secret)(nil),
		(*Assignment_Config)(nil),
		(*Assignment_Volume)(nil),
	}
}

type AssignmentChange struct {
	Assignment *Assignment                       `protobuf:"bytes,1,opt,name=assignment,proto3" json:"assignment,omitempty"`
	Action     AssignmentChange_AssignmentAction `protobuf:"varint,2,opt,name=action,proto3,enum=docker.swarmkit.v1.AssignmentChange_AssignmentAction" json:"action,omitempty"`
}

func (m *AssignmentChange) Reset()      { *m = AssignmentChange{} }
func (*AssignmentChange) ProtoMessage() {}
func (*AssignmentChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{12}
}
func (m *AssignmentChange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssignmentChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssignmentChange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssignmentChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssignmentChange.Merge(m, src)
}
func (m *AssignmentChange) XXX_Size() int {
	return m.Size()
}
func (m *AssignmentChange) XXX_DiscardUnknown() {
	xxx_messageInfo_AssignmentChange.DiscardUnknown(m)
}

var xxx_messageInfo_AssignmentChange proto.InternalMessageInfo

type AssignmentsMessage struct {
	Type AssignmentsMessage_Type `protobuf:"varint,1,opt,name=type,proto3,enum=docker.swarmkit.v1.AssignmentsMessage_Type" json:"type,omitempty"`
	// AppliesTo references the previous ResultsIn value, to chain
	// incremental updates together. For the first update in a stream,
	// AppliesTo is empty.  If AppliesTo does not match the previously
	// received ResultsIn, the consumer of the stream should start a new
	// Assignments stream to re-sync.
	AppliesTo string `protobuf:"bytes,2,opt,name=applies_to,json=appliesTo,proto3" json:"applies_to,omitempty"`
	// ResultsIn identifies the result of this assignments message, to
	// match against the next message's AppliesTo value and protect
	// against missed messages.
	ResultsIn string `protobuf:"bytes,3,opt,name=results_in,json=resultsIn,proto3" json:"results_in,omitempty"`
	// AssignmentChange is a set of changes to apply on this node.
	Changes []*AssignmentChange `protobuf:"bytes,4,rep,name=changes,proto3" json:"changes,omitempty"`
}

func (m *AssignmentsMessage) Reset()      { *m = AssignmentsMessage{} }
func (*AssignmentsMessage) ProtoMessage() {}
func (*AssignmentsMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_71002346457e55a8, []int{13}
}
func (m *AssignmentsMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssignmentsMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssignmentsMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssignmentsMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssignmentsMessage.Merge(m, src)
}
func (m *AssignmentsMessage) XXX_Size() int {
	return m.Size()
}
func (m *AssignmentsMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_AssignmentsMessage.DiscardUnknown(m)
}

var xxx_messageInfo_AssignmentsMessage proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("docker.swarmkit.v1.AssignmentChange_AssignmentAction", AssignmentChange_AssignmentAction_name, AssignmentChange_AssignmentAction_value)
	proto.RegisterEnum("docker.swarmkit.v1.AssignmentsMessage_Type", AssignmentsMessage_Type_name, AssignmentsMessage_Type_value)
	proto.RegisterType((*SessionRequest)(nil), "docker.swarmkit.v1.SessionRequest")
	proto.RegisterType((*SessionMessage)(nil), "docker.swarmkit.v1.SessionMessage")
	proto.RegisterType((*HeartbeatRequest)(nil), "docker.swarmkit.v1.HeartbeatRequest")
	proto.RegisterType((*HeartbeatResponse)(nil), "docker.swarmkit.v1.HeartbeatResponse")
	proto.RegisterType((*UpdateTaskStatusRequest)(nil), "docker.swarmkit.v1.UpdateTaskStatusRequest")
	proto.RegisterType((*UpdateTaskStatusRequest_TaskStatusUpdate)(nil), "docker.swarmkit.v1.UpdateTaskStatusRequest.TaskStatusUpdate")
	proto.RegisterType((*UpdateTaskStatusResponse)(nil), "docker.swarmkit.v1.UpdateTaskStatusResponse")
	proto.RegisterType((*UpdateVolumeStatusRequest)(nil), "docker.swarmkit.v1.UpdateVolumeStatusRequest")
	proto.RegisterType((*UpdateVolumeStatusRequest_VolumeStatusUpdate)(nil), "docker.swarmkit.v1.UpdateVolumeStatusRequest.VolumeStatusUpdate")
	proto.RegisterType((*UpdateVolumeStatusResponse)(nil), "docker.swarmkit.v1.UpdateVolumeStatusResponse")
	proto.RegisterType((*TasksRequest)(nil), "docker.swarmkit.v1.TasksRequest")
	proto.RegisterType((*TasksMessage)(nil), "docker.swarmkit.v1.TasksMessage")
	proto.RegisterType((*AssignmentsRequest)(nil), "docker.swarmkit.v1.AssignmentsRequest")
	proto.RegisterType((*Assignment)(nil), "docker.swarmkit.v1.Assignment")
	proto.RegisterType((*AssignmentChange)(nil), "docker.swarmkit.v1.AssignmentChange")
	proto.RegisterType((*AssignmentsMessage)(nil), "docker.swarmkit.v1.AssignmentsMessage")
}

func init() {
	proto.RegisterFile("github.com/docker/swarmkit/api/dispatcher.proto", fileDescriptor_71002346457e55a8)
}

var fileDescriptor_71002346457e55a8 = []byte{
	// 1138 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xbf, 0x6f, 0xdb, 0x46,
	0x14, 0x16, 0x15, 0x85, 0xb6, 0x9e, 0x9c, 0x54, 0x3d, 0x04, 0xae, 0x42, 0x34, 0xb2, 0xca, 0x24,
	0x86, 0xd1, 0x38, 0x54, 0xaa, 0xfe, 0x1a, 0x1a, 0xb8, 0xb1, 0x2c, 0x01, 0x11, 0x12, 0x3b, 0xc6,
	0xc5, 0x71, 0x80, 0x2e, 0x06, 0x25, 0x5e, 0x68, 0x56, 0x12, 0x8f, 0xe5, 0x1d, 0x9d, 0x6a, 0x28,
	0xd0, 0xa1, 0x01, 0x8a, 0x4e, 0x41, 0x27, 0x03, 0x45, 0xff, 0x85, 0x2e, 0xfd, 0x27, 0x8c, 0x4e,
	0x19, 0x33, 0xb9, 0x8d, 0xbc, 0x17, 0x5d, 0xba, 0x74, 0x2a, 0x78, 0x3c, 0x4a, 0xaa, 0x4c, 0xd9,
	0xb2, 0x3b, 0x49, 0x7c, 0xf7, 0x7d, 0xef, 0x3e, 0x7e, 0xf7, 0xde, 0x3d, 0x42, 0xd9, 0x76, 0xf8,
	0x6e, 0xd0, 0x34, 0x5a, 0xb4, 0x5b, 0xb6, 0x68, 0xab, 0x4d, 0xfc, 0x32, 0x7b, 0x6e, 0xfa, 0xdd,
	0xb6, 0xc3, 0xcb, 0xa6, 0xe7, 0x94, 0x2d, 0x87, 0x79, 0x26, 0x6f, 0xed, 0x12, 0xdf, 0xf0, 0x7c,
	0xca, 0x29, 0x42, 0x11, 0xca, 0x88, 0x51, 0xc6, 0xde, 0x07, 0xda, 0xfb, 0xa7, 0x24, 0xe1, 0x3d,
	0x8f, 0xb0, 0x88, 0xaf, 0x2d, 0x9f, 0x82, 0xa5, 0xcd, 0x2f, 0x49, 0x8b, 0xc7, 0xe8, 0x2b, 0x36,
	0xb5, 0xa9, 0xf8, 0x5b, 0x0e, 0xff, 0xc9, 0xe8, 0xa7, 0x27, 0xe4, 0x10, 0x88, 0x66, 0xf0, 0xac,
	0xec, 0x75, 0x02, 0xdb, 0x71, 0xe5, 0x8f, 0x24, 0x16, 0x6d, 0x4a, 0xed, 0x0e, 0x19, 0x82, 0xac,
	0xc0, 0x37, 0xb9, 0x43, 0xe5, 0xba, 0xfe, 0x42, 0x81, 0xcb, 0x8f, 0x09, 0x63, 0x0e, 0x75, 0x31,
	0xf9, 0x2a, 0x20, 0x8c, 0xa3, 0x3a, 0xe4, 0x2c, 0xc2, 0x5a, 0xbe, 0xe3, 0x85, 0xb8, 0x82, 0x52,
	0x52, 0x96, 0x72, 0x95, 0xeb, 0xc6, 0x71, 0x17, 0x8c, 0x0d, 0x6a, 0x91, 0xda, 0x10, 0x8a, 0x47,
	0x79, 0x68, 0x19, 0x80, 0x45, 0x89, 0x77, 0x1c, 0xab, 0x90, 0x2e, 0x29, 0x4b, 0xd9, 0xea, 0xa5,
	0xfe, 0xe1, 0x42, 0x56, 0x6e, 0xd7, 0xa8, 0xe1, 0xac, 0x04, 0x34, 0x2c, 0xfd, 0xa7, 0xf4, 0x40,
	0xc7, 0x3a, 0x61, 0xcc, 0xb4, 0xc9, 0x58, 0x02, 0xe5, 0xe4, 0x04, 0x68, 0x19, 0x32, 0x2e, 0xb5,
	0x88, 0xd8, 0x28, 0x57, 0x29, 0x4c, 0x92, 0x8b, 0x05, 0x0a, 0xdd, 0x85, 0xd9, 0xae, 0xe9, 0x9a,
	0x36, 0xf1, 0x59, 0xe1, 0x42, 0xe9, 0xc2, 0x52, 0xae, 0x52, 0x4a, 0x62, 0x3c, 0x25, 0x8e, 0xbd,
	0xcb, 0x89, 0xb5, 0x49, 0x88, 0x8f, 0x07, 0x0c, 0xf4, 0x14, 0xe6, 0x5d, 0xc2, 0x9f, 0x53, 0xbf,
	0xbd, 0xd3, 0xa4, 0x94, 0x33, 0xee, 0x9b, 0xde, 0x4e, 0x9b, 0xf4, 0x58, 0x21, 0x23, 0x72, 0xbd,
	0x97, 0x94, 0xab, 0xee, 0xb6, 0xfc, 0x9e, 0xb0, 0xe6, 0x01, 0xe9, 0xe1, 0x2b, 0x32, 0x41, 0x35,
	0xe6, 0x3f, 0x20, 0x3d, 0x86, 0xe6, 0x41, 0xc5, 0x94, 0xf2, 0xb5, 0xd5, 0xc2, 0xc5, 0x92, 0xb2,
	0x34, 0x87, 0xe5, 0x93, 0x7e, 0x0f, 0xf2, 0xf7, 0x89, 0xe9, 0xf3, 0x26, 0x31, 0x79, 0x7c, 0x4c,
	0x67, 0xb2, 0x47, 0xdf, 0x84, 0xb7, 0x47, 0x32, 0x30, 0x8f, 0xba, 0x8c, 0xa0, 0xcf, 0x40, 0xf5,
	0x88, 0xef, 0x50, 0x4b, 0x1e, 0xf2, 0x55, 0x23, 0xaa, 0x16, 0x23, 0xae, 0x16, 0xa3, 0x26, 0xab,
	0xa5, 0x3a, 0x7b, 0x70, 0xb8, 0x90, 0xda, 0xff, 0x7d, 0x41, 0xc1, 0x92, 0xa2, 0xbf, 0x4c, 0xc3,
	0x3b, 0x4f, 0x3c, 0xcb, 0xe4, 0x64, 0xcb, 0x64, 0xed, 0xc7, 0xdc, 0xe4, 0x01, 0x3b, 0x97, 0x36,
	0xb4, 0x0d, 0x33, 0x81, 0x48, 0x14, 0x9f, 0xc5, 0xdd, 0x24, 0xff, 0x26, 0xec, 0x65, 0x0c, 0x23,
	0x11, 0x02, 0xc7, 0xc9, 0x34, 0x0a, 0xf9, 0xf1, 0x45, 0x74, 0x1d, 0x66, 0xb8, 0xc9, 0xda, 0x43,
	0x59, 0xd0, 0x3f, 0x5c, 0x50, 0x43, 0x58, 0xa3, 0x86, 0xd5, 0x70, 0xa9, 0x61, 0xa1, 0x4f, 0x40,
	0x65, 0x82, 0x24, 0xab, 0xa9, 0x98, 0xa4, 0x67, 0x44, 0x89, 0x44, 0xeb, 0x1a, 0x14, 0x8e, 0xab,
	0x8c, 0xbc, 0xd6, 0xff, 0x56, 0xe0, 0x6a, 0xb4, 0xb8, 0x4d, 0x3b, 0x41, 0x97, 0xfc, 0x1f, 0xc3,
	0xbe, 0x18, 0x1a, 0x96, 0x16, 0x86, 0xdd, 0x9b, 0x6c, 0x58, 0xc2, 0x6e, 0xc6, 0x68, 0x6c, 0xdc,
	0xb4, 0x0d, 0x40, 0xc7, 0x97, 0xd1, 0x3c, 0xa4, 0x07, 0xba, 0xd4, 0xfe, 0xe1, 0x42, 0xba, 0x51,
	0xc3, 0x69, 0xc7, 0x42, 0x25, 0xc8, 0x05, 0xae, 0x17, 0x34, 0x3b, 0x0e, 0xdb, 0x25, 0x51, 0x97,
	0xcf, 0xe2, 0xd1, 0x90, 0xfe, 0x2e, 0x68, 0x49, 0x42, 0xa4, 0x2b, 0x77, 0x61, 0x2e, 0xf4, 0xea,
	0x7c, 0x3e, 0xe8, 0x2b, 0x92, 0x1d, 0xdf, 0x18, 0x06, 0x5c, 0x0c, 0x4f, 0x90, 0x15, 0x14, 0xe1,
	0x4a, 0x61, 0xd2, 0xb1, 0xe1, 0x08, 0xa6, 0x57, 0x01, 0xad, 0x32, 0xe6, 0xd8, 0x6e, 0x97, 0xb8,
	0xfc, 0x9c, 0x1a, 0xfe, 0x52, 0x00, 0x86, 0x49, 0x90, 0x01, 0x99, 0x30, 0xb7, 0x6c, 0xa8, 0x89,
	0x0a, 0xee, 0xa7, 0xb0, 0xc0, 0xa1, 0x8f, 0x40, 0x65, 0xa4, 0xe5, 0x13, 0x2e, 0x4b, 0x4d, 0x4b,
	0x62, 0x3c, 0x16, 0x88, 0xfb, 0x29, 0x2c, 0xb1, 0x21, 0xab, 0x45, 0xdd, 0x67, 0x8e, 0x5d, 0xb8,
	0x30, 0x99, 0xb5, 0x26, 0x10, 0x21, 0x2b, 0xc2, 0xa2, 0x15, 0x50, 0xf7, 0xc4, 0x21, 0x14, 0x32,
	0x82, 0x75, 0x23, 0x89, 0x15, 0x1d, 0xd3, 0xf0, 0x8d, 0x42, 0x7e, 0xc4, 0xaa, 0xaa, 0x90, 0x71,
	0x38, 0xe9, 0xea, 0x2f, 0xd2, 0x90, 0x1f, 0x02, 0xd6, 0x76, 0x4d, 0xd7, 0x26, 0x68, 0x05, 0xc0,
	0x1c, 0xc4, 0xe4, 0xeb, 0x27, 0xf6, 0xcd, 0x90, 0x89, 0x47, 0x18, 0x68, 0x1d, 0x54, 0xb3, 0x25,
	0x06, 0x4e, 0x68, 0xc4, 0xe5, 0xca, 0xc7, 0x27, 0x73, 0xa3, 0x5d, 0x47, 0x02, 0xab, 0x82, 0x8c,
	0x65, 0x12, 0xbd, 0x39, 0x2a, 0x31, 0x5a, 0x43, 0x8b, 0xa0, 0x3e, 0xd9, 0xac, 0xad, 0x6e, 0xd5,
	0xf3, 0x29, 0x4d, 0xfb, 0xe1, 0xe7, 0xd2, 0xfc, 0x38, 0x42, 0x16, 0xfb, 0x22, 0xa8, 0xb8, 0xbe,
	0xfe, 0x68, 0xbb, 0x9e, 0x57, 0x92, 0x71, 0x98, 0x74, 0xe9, 0x1e, 0xd1, 0xff, 0x51, 0xfe, 0x53,
	0x3f, 0x71, 0x15, 0x7e, 0x0e, 0x99, 0x70, 0xfc, 0x0b, 0x0f, 0x2e, 0x57, 0x6e, 0x9d, 0xfc, 0x1e,
	0x31, 0xcb, 0xd8, 0xea, 0x79, 0x04, 0x0b, 0x22, 0xba, 0x06, 0x60, 0x7a, 0x5e, 0xc7, 0x21, 0x6c,
	0x87, 0xd3, 0x68, 0x72, 0xe2, 0xac, 0x8c, 0x6c, 0xd1, 0x70, 0xd9, 0x27, 0x2c, 0xe8, 0x70, 0xb6,
	0xe3, 0xb8, 0xa2, 0x00, 0xb2, 0x38, 0x2b, 0x23, 0x0d, 0x17, 0xad, 0xc0, 0x4c, 0x4b, 0x98, 0x13,
	0x4f, 0xa3, 0x1b, 0xd3, 0x38, 0x89, 0x63, 0x92, 0x7e, 0x13, 0x32, 0xa1, 0x16, 0x34, 0x07, 0xb3,
	0x6b, 0x8f, 0xd6, 0x37, 0x1f, 0xd6, 0x43, 0xbf, 0xd0, 0x5b, 0x90, 0x6b, 0x6c, 0xac, 0xe1, 0xfa,
	0x7a, 0x7d, 0x63, 0x6b, 0xf5, 0x61, 0x5e, 0xa9, 0xfc, 0xaa, 0x02, 0xd4, 0x06, 0x9f, 0x4a, 0xe8,
	0x6b, 0x98, 0x91, 0xed, 0x81, 0xf4, 0xe4, 0x12, 0x1e, 0xfd, 0xc6, 0xd0, 0x4e, 0xc2, 0x48, 0x47,
	0xf4, 0xeb, 0xbf, 0xfd, 0xf2, 0xe7, 0x7e, 0xfa, 0x1a, 0xcc, 0x09, 0xcc, 0xed, 0x70, 0x5a, 0x12,
	0x1f, 0x2e, 0x45, 0x4f, 0x72, 0x16, 0xdf, 0x51, 0xd0, 0x37, 0x90, 0x1d, 0x4c, 0x36, 0x94, 0xf8,
	0xae, 0xe3, 0xa3, 0x53, 0xbb, 0x79, 0x0a, 0x4a, 0x5e, 0x4e, 0xd3, 0x08, 0x40, 0x3f, 0x2a, 0x90,
	0x1f, 0xbf, 0xf4, 0xd1, 0xad, 0x33, 0x0c, 0x30, 0x6d, 0x79, 0x3a, 0xf0, 0x59, 0x44, 0xed, 0x2b,
	0x80, 0x8e, 0xdf, 0xba, 0xe8, 0xf6, 0x99, 0xc6, 0x84, 0x66, 0x4c, 0x0b, 0x3f, 0x8b, 0xb4, 0x00,
	0x2e, 0x8a, 0x3b, 0x1b, 0x95, 0x26, 0xdd, 0x8d, 0x83, 0xfd, 0x27, 0x23, 0xe2, 0x12, 0x59, 0x9c,
	0x62, 0xc7, 0xef, 0xd3, 0xca, 0x1d, 0x05, 0x7d, 0xa7, 0x40, 0x6e, 0xa4, 0xeb, 0xd0, 0xe2, 0x29,
	0x6d, 0x19, 0x6b, 0x58, 0x9c, 0xae, 0x7d, 0xa7, 0x2c, 0xd6, 0xea, 0x8d, 0x83, 0x37, 0xc5, 0xd4,
	0xeb, 0x37, 0xc5, 0xd4, 0xb7, 0xfd, 0xa2, 0x72, 0xd0, 0x2f, 0x2a, 0xaf, 0xfa, 0x45, 0xe5, 0x8f,
	0x7e, 0x51, 0x79, 0x79, 0x54, 0x4c, 0xbd, 0x3a, 0x2a, 0xa6, 0x5e, 0x1f, 0x15, 0x53, 0x4d, 0x55,
	0x7c, 0x7f, 0x7d, 0xf8, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x78, 0x3b, 0xe2, 0x0b, 0xab, 0x0c,
	0x00, 0x00,
}

type authenticatedWrapperDispatcherServer struct {
	local     DispatcherServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperDispatcherServer(local DispatcherServer, authorize func(context.Context, []string) error) DispatcherServer {
	return &authenticatedWrapperDispatcherServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperDispatcherServer) Session(r *SessionRequest, stream Dispatcher_SessionServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Session(r, stream)
}

func (p *authenticatedWrapperDispatcherServer) Heartbeat(ctx context.Context, r *HeartbeatRequest) (*HeartbeatResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-worker", "swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.Heartbeat(ctx, r)
}

func (p *authenticatedWrapperDispatcherServer) UpdateTaskStatus(ctx context.Context, r *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-worker", "swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.UpdateTaskStatus(ctx, r)
}

func (p *authenticatedWrapperDispatcherServer) UpdateVolumeStatus(ctx context.Context, r *UpdateVolumeStatusRequest) (*UpdateVolumeStatusResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-worker", "swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.UpdateVolumeStatus(ctx, r)
}

func (p *authenticatedWrapperDispatcherServer) Tasks(r *TasksRequest, stream Dispatcher_TasksServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Tasks(r, stream)
}

func (p *authenticatedWrapperDispatcherServer) Assignments(r *AssignmentsRequest, stream Dispatcher_AssignmentsServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Assignments(r, stream)
}

func (m *SessionRequest) Copy() *SessionRequest {
	if m == nil {
		return nil
	}
	o := &SessionRequest{}
	o.CopyFrom(m)
	return o
}

func (m *SessionRequest) CopyFrom(src interface{}) {

	o := src.(*SessionRequest)
	*m = *o
	if o.Description != nil {
		m.Description = &NodeDescription{}
		github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Description, o.Description)
	}
}

func (m *SessionMessage) Copy() *SessionMessage {
	if m == nil {
		return nil
	}
	o := &SessionMessage{}
	o.CopyFrom(m)
	return o
}

func (m *SessionMessage) CopyFrom(src interface{}) {

	o := src.(*SessionMessage)
	*m = *o
	if o.Node != nil {
		m.Node = &Node{}
		github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Node, o.Node)
	}
	if o.Managers != nil {
		m.Managers = make([]*WeightedPeer, len(o.Managers))
		for i := range m.Managers {
			m.Managers[i] = &WeightedPeer{}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Managers[i], o.Managers[i])
		}
	}

	if o.NetworkBootstrapKeys != nil {
		m.NetworkBootstrapKeys = make([]*EncryptionKey, len(o.NetworkBootstrapKeys))
		for i := range m.NetworkBootstrapKeys {
			m.NetworkBootstrapKeys[i] = &EncryptionKey{}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.NetworkBootstrapKeys[i], o.NetworkBootstrapKeys[i])
		}
	}

	if o.RootCA != nil {
		m.RootCA = make([]byte, len(o.RootCA))
		copy(m.RootCA, o.RootCA)
	}
}

func (m *HeartbeatRequest) Copy() *HeartbeatRequest {
	if m == nil {
		return nil
	}
	o := &HeartbeatRequest{}
	o.CopyFrom(m)
	return o
}

func (m *HeartbeatRequest) CopyFrom(src interface{}) {

	o := src.(*HeartbeatRequest)
	*m = *o
}

func (m *HeartbeatResponse) Copy() *HeartbeatResponse {
	if m == nil {
		return nil
	}
	o := &HeartbeatResponse{}
	o.CopyFrom(m)
	return o
}

func (m *HeartbeatResponse) CopyFrom(src interface{}) {

	o := src.(*HeartbeatResponse)
	*m = *o
	github_com_moby_swarmkit_v2_api_deepcopy.Copy(&m.Period, &o.Period)
}

func (m *UpdateTaskStatusRequest) Copy() *UpdateTaskStatusRequest {
	if m == nil {
		return nil
	}
	o := &UpdateTaskStatusRequest{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateTaskStatusRequest) CopyFrom(src interface{}) {

	o := src.(*UpdateTaskStatusRequest)
	*m = *o
	if o.Updates != nil {
		m.Updates = make([]*UpdateTaskStatusRequest_TaskStatusUpdate, len(o.Updates))
		for i := range m.Updates {
			m.Updates[i] = &UpdateTaskStatusRequest_TaskStatusUpdate{}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Updates[i], o.Updates[i])
		}
	}

}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Copy() *UpdateTaskStatusRequest_TaskStatusUpdate {
	if m == nil {
		return nil
	}
	o := &UpdateTaskStatusRequest_TaskStatusUpdate{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) CopyFrom(src interface{}) {

	o := src.(*UpdateTaskStatusRequest_TaskStatusUpdate)
	*m = *o
	if o.Status != nil {
		m.Status = &TaskStatus{}
		github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Status, o.Status)
	}
}

func (m *UpdateTaskStatusResponse) Copy() *UpdateTaskStatusResponse {
	if m == nil {
		return nil
	}
	o := &UpdateTaskStatusResponse{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateTaskStatusResponse) CopyFrom(src interface{}) {}
func (m *UpdateVolumeStatusRequest) Copy() *UpdateVolumeStatusRequest {
	if m == nil {
		return nil
	}
	o := &UpdateVolumeStatusRequest{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateVolumeStatusRequest) CopyFrom(src interface{}) {

	o := src.(*UpdateVolumeStatusRequest)
	*m = *o
	if o.Updates != nil {
		m.Updates = make([]*UpdateVolumeStatusRequest_VolumeStatusUpdate, len(o.Updates))
		for i := range m.Updates {
			m.Updates[i] = &UpdateVolumeStatusRequest_VolumeStatusUpdate{}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Updates[i], o.Updates[i])
		}
	}

}

func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) Copy() *UpdateVolumeStatusRequest_VolumeStatusUpdate {
	if m == nil {
		return nil
	}
	o := &UpdateVolumeStatusRequest_VolumeStatusUpdate{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) CopyFrom(src interface{}) {

	o := src.(*UpdateVolumeStatusRequest_VolumeStatusUpdate)
	*m = *o
}

func (m *UpdateVolumeStatusResponse) Copy() *UpdateVolumeStatusResponse {
	if m == nil {
		return nil
	}
	o := &UpdateVolumeStatusResponse{}
	o.CopyFrom(m)
	return o
}

func (m *UpdateVolumeStatusResponse) CopyFrom(src interface{}) {}
func (m *TasksRequest) Copy() *TasksRequest {
	if m == nil {
		return nil
	}
	o := &TasksRequest{}
	o.CopyFrom(m)
	return o
}

func (m *TasksRequest) CopyFrom(src interface{}) {

	o := src.(*TasksRequest)
	*m = *o
}

func (m *TasksMessage) Copy() *TasksMessage {
	if m == nil {
		return nil
	}
	o := &TasksMessage{}
	o.CopyFrom(m)
	return o
}

func (m *TasksMessage) CopyFrom(src interface{}) {

	o := src.(*TasksMessage)
	*m = *o
	if o.Tasks != nil {
		m.Tasks = make([]*Task, len(o.Tasks))
		for i := range m.Tasks {
			m.Tasks[i] = &Task{}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Tasks[i], o.Tasks[i])
		}
	}

}

func (m *AssignmentsRequest) Copy() *AssignmentsRequest {
	if m == nil {
		return nil
	}
	o := &AssignmentsRequest{}
	o.CopyFrom(m)
	return o
}

func (m *AssignmentsRequest) CopyFrom(src interface{}) {

	o := src.(*AssignmentsRequest)
	*m = *o
}

func (m *Assignment) Copy() *Assignment {
	if m == nil {
		return nil
	}
	o := &Assignment{}
	o.CopyFrom(m)
	return o
}

func (m *Assignment) CopyFrom(src interface{}) {

	o := src.(*Assignment)
	*m = *o
	if o.Item != nil {
		switch o.Item.(type) {
		case *Assignment_Task:
			v := Assignment_Task{
				Task: &Task{},
			}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(v.Task, o.GetTask())
			m.Item = &v
		case *Assignment_Secret:
			v := Assignment_Secret{
				Secret: &Secret{},
			}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(v.Secret, o.GetSecret())
			m.Item = &v
		case *Assignment_Config:
			v := Assignment_Config{
				Config: &Config{},
			}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(v.Config, o.GetConfig())
			m.Item = &v
		case *Assignment_Volume:
			v := Assignment_Volume{
				Volume: &VolumeAssignment{},
			}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(v.Volume, o.GetVolume())
			m.Item = &v
		}
	}

}

func (m *AssignmentChange) Copy() *AssignmentChange {
	if m == nil {
		return nil
	}
	o := &AssignmentChange{}
	o.CopyFrom(m)
	return o
}

func (m *AssignmentChange) CopyFrom(src interface{}) {

	o := src.(*AssignmentChange)
	*m = *o
	if o.Assignment != nil {
		m.Assignment = &Assignment{}
		github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Assignment, o.Assignment)
	}
}

func (m *AssignmentsMessage) Copy() *AssignmentsMessage {
	if m == nil {
		return nil
	}
	o := &AssignmentsMessage{}
	o.CopyFrom(m)
	return o
}

func (m *AssignmentsMessage) CopyFrom(src interface{}) {

	o := src.(*AssignmentsMessage)
	*m = *o
	if o.Changes != nil {
		m.Changes = make([]*AssignmentChange, len(o.Changes))
		for i := range m.Changes {
			m.Changes[i] = &AssignmentChange{}
			github_com_moby_swarmkit_v2_api_deepcopy.Copy(m.Changes[i], o.Changes[i])
		}
	}

}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DispatcherClient is the client API for Dispatcher service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DispatcherClient interface {
	// Session starts an agent session with the dispatcher. The session is
	// started after the first SessionMessage is received.
	//
	// Once started, the agent is controlled with a stream of SessionMessage.
	// Agents should list on the stream at all times for instructions.
	Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error)
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	//
	// Whether receiving batch updates or single status updates, this method
	// should be accepting. Errors should only be returned if the entire update
	// should be retried, due to data loss or other problems.
	//
	// If a task is unknown the dispatcher, the status update should be
	// accepted regardless.
	UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error)
	// UpdateVolumeStatus updates the status of a Volume. Like
	// UpdateTaskStatus, the node should send such updates on every status
	// change of its volumes.
	UpdateVolumeStatus(ctx context.Context, in *UpdateVolumeStatusRequest, opts ...grpc.CallOption) (*UpdateVolumeStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error)
	// Assignments is a stream of assignments such as tasks and secrets for node.
	// The first message in the stream contains all of the tasks and secrets
	// that are relevant to the node. Future messages in the stream are updates to
	// the set of assignments.
	Assignments(ctx context.Context, in *AssignmentsRequest, opts ...grpc.CallOption) (Dispatcher_AssignmentsClient, error)
}

type dispatcherClient struct {
	cc *grpc.ClientConn
}

func NewDispatcherClient(cc *grpc.ClientConn) DispatcherClient {
	return &dispatcherClient{cc}
}

func (c *dispatcherClient) Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Dispatcher_serviceDesc.Streams[0], "/docker.swarmkit.v1.Dispatcher/Session", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherSessionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_SessionClient interface {
	Recv() (*SessionMessage, error)
	grpc.ClientStream
}

type dispatcherSessionClient struct {
	grpc.ClientStream
}

func (x *dispatcherSessionClient) Recv() (*SessionMessage, error) {
	m := new(SessionMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *dispatcherClient) Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error) {
	out := new(HeartbeatResponse)
	err := c.cc.Invoke(ctx, "/docker.swarmkit.v1.Dispatcher/Heartbeat", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error) {
	out := new(UpdateTaskStatusResponse)
	err := c.cc.Invoke(ctx, "/docker.swarmkit.v1.Dispatcher/UpdateTaskStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) UpdateVolumeStatus(ctx context.Context, in *UpdateVolumeStatusRequest, opts ...grpc.CallOption) (*UpdateVolumeStatusResponse, error) {
	out := new(UpdateVolumeStatusResponse)
	err := c.cc.Invoke(ctx, "/docker.swarmkit.v1.Dispatcher/UpdateVolumeStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dispatcherClient) Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Dispatcher_serviceDesc.Streams[1], "/docker.swarmkit.v1.Dispatcher/Tasks", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherTasksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_TasksClient interface {
	Recv() (*TasksMessage, error)
	grpc.ClientStream
}

type dispatcherTasksClient struct {
	grpc.ClientStream
}

func (x *dispatcherTasksClient) Recv() (*TasksMessage, error) {
	m := new(TasksMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *dispatcherClient) Assignments(ctx context.Context, in *AssignmentsRequest, opts ...grpc.CallOption) (Dispatcher_AssignmentsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Dispatcher_serviceDesc.Streams[2], "/docker.swarmkit.v1.Dispatcher/Assignments", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherAssignmentsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_AssignmentsClient interface {
	Recv() (*AssignmentsMessage, error)
	grpc.ClientStream
}

type dispatcherAssignmentsClient struct {
	grpc.ClientStream
}

func (x *dispatcherAssignmentsClient) Recv() (*AssignmentsMessage, error) {
	m := new(AssignmentsMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// DispatcherServer is the server API for Dispatcher service.
type DispatcherServer interface {
	// Session starts an agent session with the dispatcher. The session is
	// started after the first SessionMessage is received.
	//
	// Once started, the agent is controlled with a stream of SessionMessage.
	// Agents should list on the stream at all times for instructions.
	Session(*SessionRequest, Dispatcher_SessionServer) error
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	//
	// Whether receiving batch updates or single status updates, this method
	// should be accepting. Errors should only be returned if the entire update
	// should be retried, due to data loss or other problems.
	//
	// If a task is unknown the dispatcher, the status update should be
	// accepted regardless.
	UpdateTaskStatus(context.Context, *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error)
	// UpdateVolumeStatus updates the status of a Volume. Like
	// UpdateTaskStatus, the node should send such updates on every status
	// change of its volumes.
	UpdateVolumeStatus(context.Context, *UpdateVolumeStatusRequest) (*UpdateVolumeStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(*TasksRequest, Dispatcher_TasksServer) error
	// Assignments is a stream of assignments such as tasks and secrets for node.
	// The first message in the stream contains all of the tasks and secrets
	// that are relevant to the node. Future messages in the stream are updates to
	// the set of assignments.
	Assignments(*AssignmentsRequest, Dispatcher_AssignmentsServer) error
}

// UnimplementedDispatcherServer can be embedded to have forward compatible implementations.
type UnimplementedDispatcherServer struct {
}

func (*UnimplementedDispatcherServer) Session(req *SessionRequest, srv Dispatcher_SessionServer) error {
	return status.Errorf(codes.Unimplemented, "method Session not implemented")
}
func (*UnimplementedDispatcherServer) Heartbeat(ctx context.Context, req *HeartbeatRequest) (*HeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Heartbeat not implemented")
}
func (*UnimplementedDispatcherServer) UpdateTaskStatus(ctx context.Context, req *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTaskStatus not implemented")
}
func (*UnimplementedDispatcherServer) UpdateVolumeStatus(ctx context.Context, req *UpdateVolumeStatusRequest) (*UpdateVolumeStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVolumeStatus not implemented")
}
func (*UnimplementedDispatcherServer) Tasks(req *TasksRequest, srv Dispatcher_TasksServer) error {
	return status.Errorf(codes.Unimplemented, "method Tasks not implemented")
}
func (*UnimplementedDispatcherServer) Assignments(req *AssignmentsRequest, srv Dispatcher_AssignmentsServer) error {
	return status.Errorf(codes.Unimplemented, "method Assignments not implemented")
}

func RegisterDispatcherServer(s *grpc.Server, srv DispatcherServer) {
	s.RegisterService(&_Dispatcher_serviceDesc, srv)
}

func _Dispatcher_Session_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SessionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Session(m, &dispatcherSessionServer{stream})
}

type Dispatcher_SessionServer interface {
	Send(*SessionMessage) error
	grpc.ServerStream
}

type dispatcherSessionServer struct {
	grpc.ServerStream
}

func (x *dispatcherSessionServer) Send(m *SessionMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Dispatcher_Heartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DispatcherServer).Heartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Dispatcher/Heartbeat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DispatcherServer).Heartbeat(ctx, req.(*HeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dispatcher_UpdateTaskStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DispatcherServer).UpdateTaskStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Dispatcher/UpdateTaskStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DispatcherServer).UpdateTaskStatus(ctx, req.(*UpdateTaskStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dispatcher_UpdateVolumeStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVolumeStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DispatcherServer).UpdateVolumeStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Dispatcher/UpdateVolumeStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DispatcherServer).UpdateVolumeStatus(ctx, req.(*UpdateVolumeStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dispatcher_Tasks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TasksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Tasks(m, &dispatcherTasksServer{stream})
}

type Dispatcher_TasksServer interface {
	Send(*TasksMessage) error
	grpc.ServerStream
}

type dispatcherTasksServer struct {
	grpc.ServerStream
}

func (x *dispatcherTasksServer) Send(m *TasksMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Dispatcher_Assignments_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(AssignmentsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Assignments(m, &dispatcherAssignmentsServer{stream})
}

type Dispatcher_AssignmentsServer interface {
	Send(*AssignmentsMessage) error
	grpc.ServerStream
}

type dispatcherAssignmentsServer struct {
	grpc.ServerStream
}

func (x *dispatcherAssignmentsServer) Send(m *AssignmentsMessage) error {
	return x.ServerStream.SendMsg(m)
}

var _Dispatcher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.Dispatcher",
	HandlerType: (*DispatcherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Heartbeat",
			Handler:    _Dispatcher_Heartbeat_Handler,
		},
		{
			MethodName: "UpdateTaskStatus",
			Handler:    _Dispatcher_UpdateTaskStatus_Handler,
		},
		{
			MethodName: "UpdateVolumeStatus",
			Handler:    _Dispatcher_UpdateVolumeStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Session",
			Handler:       _Dispatcher_Session_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Tasks",
			Handler:       _Dispatcher_Tasks_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Assignments",
			Handler:       _Dispatcher_Assignments_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "github.com/docker/swarmkit/api/dispatcher.proto",
}

func (m *SessionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SessionRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		i -= len(m.SessionID)
		copy(dAtA[i:], m.SessionID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.SessionID)))
		i--
		dAtA[i] = 0x12
	}
	if m.Description != nil {
		{
			size, err := m.Description.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SessionMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SessionMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SessionMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RootCA) > 0 {
		i -= len(m.RootCA)
		copy(dAtA[i:], m.RootCA)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.RootCA)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.NetworkBootstrapKeys) > 0 {
		for iNdEx := len(m.NetworkBootstrapKeys) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.NetworkBootstrapKeys[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDispatcher(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Managers) > 0 {
		for iNdEx := len(m.Managers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Managers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDispatcher(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.Node != nil {
		{
			size, err := m.Node.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.SessionID) > 0 {
		i -= len(m.SessionID)
		copy(dAtA[i:], m.SessionID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.SessionID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HeartbeatRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HeartbeatRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		i -= len(m.SessionID)
		copy(dAtA[i:], m.SessionID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.SessionID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *HeartbeatResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HeartbeatResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	n3, err3 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.Period, dAtA[i-github_com_gogo_protobuf_types.SizeOfStdDuration(m.Period):])
	if err3 != nil {
		return 0, err3
	}
	i -= n3
	i = encodeVarintDispatcher(dAtA, i, uint64(n3))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *UpdateTaskStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateTaskStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateTaskStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Updates) > 0 {
		for iNdEx := len(m.Updates) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Updates[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDispatcher(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.SessionID) > 0 {
		i -= len(m.SessionID)
		copy(dAtA[i:], m.SessionID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.SessionID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.TaskID) > 0 {
		i -= len(m.TaskID)
		copy(dAtA[i:], m.TaskID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.TaskID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateTaskStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateTaskStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateTaskStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *UpdateVolumeStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateVolumeStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateVolumeStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Updates) > 0 {
		for iNdEx := len(m.Updates) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Updates[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDispatcher(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.SessionID) > 0 {
		i -= len(m.SessionID)
		copy(dAtA[i:], m.SessionID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.SessionID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Unpublished {
		i--
		if m.Unpublished {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *UpdateVolumeStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateVolumeStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateVolumeStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *TasksRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TasksRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TasksRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		i -= len(m.SessionID)
		copy(dAtA[i:], m.SessionID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.SessionID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TasksMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TasksMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TasksMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for iNdEx := len(m.Tasks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tasks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDispatcher(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *AssignmentsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssignmentsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssignmentsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		i -= len(m.SessionID)
		copy(dAtA[i:], m.SessionID)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.SessionID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Assignment) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Assignment) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Assignment) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Item != nil {
		{
			size := m.Item.Size()
			i -= size
			if _, err := m.Item.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *Assignment_Task) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Assignment_Task) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Task != nil {
		{
			size, err := m.Task.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *Assignment_Secret) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Assignment_Secret) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Secret != nil {
		{
			size, err := m.Secret.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *Assignment_Config) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Assignment_Config) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *Assignment_Volume) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Assignment_Volume) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Volume != nil {
		{
			size, err := m.Volume.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *AssignmentChange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssignmentChange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssignmentChange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Action != 0 {
		i = encodeVarintDispatcher(dAtA, i, uint64(m.Action))
		i--
		dAtA[i] = 0x10
	}
	if m.Assignment != nil {
		{
			size, err := m.Assignment.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDispatcher(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AssignmentsMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssignmentsMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssignmentsMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Changes) > 0 {
		for iNdEx := len(m.Changes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Changes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDispatcher(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.ResultsIn) > 0 {
		i -= len(m.ResultsIn)
		copy(dAtA[i:], m.ResultsIn)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.ResultsIn)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AppliesTo) > 0 {
		i -= len(m.AppliesTo)
		copy(dAtA[i:], m.AppliesTo)
		i = encodeVarintDispatcher(dAtA, i, uint64(len(m.AppliesTo)))
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintDispatcher(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintDispatcher(dAtA []byte, offset int, v uint64) int {
	offset -= sovDispatcher(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}

type raftProxyDispatcherServer struct {
	local                       DispatcherServer
	connSelector                raftselector.ConnProvider
	localCtxMods, remoteCtxMods []func(context.Context) (context.Context, error)
}

func NewRaftProxyDispatcherServer(local DispatcherServer, connSelector raftselector.ConnProvider, localCtxMod, remoteCtxMod func(context.Context) (context.Context, error)) DispatcherServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		p, ok := peer.FromContext(ctx)
		if !ok {
			return ctx, status.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := p.Addr.String()
		md, ok := metadata.FromIncomingContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, status.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewOutgoingContext(ctx, md), nil
	}
	remoteMods := []func(context.Context) (context.Context, error){redirectChecker}
	remoteMods = append(remoteMods, remoteCtxMod)

	var localMods []func(context.Context) (context.Context, error)
	if localCtxMod != nil {
		localMods = []func(context.Context) (context.Context, error){localCtxMod}
	}

	return &raftProxyDispatcherServer{
		local:         local,
		connSelector:  connSelector,
		localCtxMods:  localMods,
		remoteCtxMods: remoteMods,
	}
}
func (p *raftProxyDispatcherServer) runCtxMods(ctx context.Context, ctxMods []func(context.Context) (context.Context, error)) (context.Context, error) {
	var err error
	for _, mod := range ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyDispatcherServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := rafttime.NewTicker(500 * rafttime.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

type Dispatcher_SessionServerWrapper struct {
	Dispatcher_SessionServer
	ctx context.Context
}

func (s Dispatcher_SessionServerWrapper) Context() context.Context {
	return s.ctx
}

func (p *raftProxyDispatcherServer) Session(r *SessionRequest, stream Dispatcher_SessionServer) error {
	ctx := stream.Context()
	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return err
			}
			streamWrapper := Dispatcher_SessionServerWrapper{
				Dispatcher_SessionServer: stream,
				ctx:                      ctx,
			}
			return p.local.Session(r, streamWrapper)
		}
		return err
	}
	ctx, err = p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return err
	}
	clientStream, err := NewDispatcherClient(conn).Session(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (p *raftProxyDispatcherServer) Heartbeat(ctx context.Context, r *HeartbeatRequest) (*HeartbeatResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.Heartbeat(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewDispatcherClient(conn).Heartbeat(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.Heartbeat(ctx, r)
			}
			return nil, err
		}
		return NewDispatcherClient(conn).Heartbeat(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyDispatcherServer) UpdateTaskStatus(ctx context.Context, r *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.UpdateTaskStatus(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewDispatcherClient(conn).UpdateTaskStatus(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.UpdateTaskStatus(ctx, r)
			}
			return nil, err
		}
		return NewDispatcherClient(conn).UpdateTaskStatus(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyDispatcherServer) UpdateVolumeStatus(ctx context.Context, r *UpdateVolumeStatusRequest) (*UpdateVolumeStatusResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.UpdateVolumeStatus(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewDispatcherClient(conn).UpdateVolumeStatus(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.UpdateVolumeStatus(ctx, r)
			}
			return nil, err
		}
		return NewDispatcherClient(conn).UpdateVolumeStatus(modCtx, r)
	}
	return resp, err
}

type Dispatcher_TasksServerWrapper struct {
	Dispatcher_TasksServer
	ctx context.Context
}

func (s Dispatcher_TasksServerWrapper) Context() context.Context {
	return s.ctx
}

func (p *raftProxyDispatcherServer) Tasks(r *TasksRequest, stream Dispatcher_TasksServer) error {
	ctx := stream.Context()
	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return err
			}
			streamWrapper := Dispatcher_TasksServerWrapper{
				Dispatcher_TasksServer: stream,
				ctx:                    ctx,
			}
			return p.local.Tasks(r, streamWrapper)
		}
		return err
	}
	ctx, err = p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return err
	}
	clientStream, err := NewDispatcherClient(conn).Tasks(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

type Dispatcher_AssignmentsServerWrapper struct {
	Dispatcher_AssignmentsServer
	ctx context.Context
}

func (s Dispatcher_AssignmentsServerWrapper) Context() context.Context {
	return s.ctx
}

func (p *raftProxyDispatcherServer) Assignments(r *AssignmentsRequest, stream Dispatcher_AssignmentsServer) error {
	ctx := stream.Context()
	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return err
			}
			streamWrapper := Dispatcher_AssignmentsServerWrapper{
				Dispatcher_AssignmentsServer: stream,
				ctx:                          ctx,
			}
			return p.local.Assignments(r, streamWrapper)
		}
		return err
	}
	ctx, err = p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return err
	}
	clientStream, err := NewDispatcherClient(conn).Assignments(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (m *SessionRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Description != nil {
		l = m.Description.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *SessionMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Managers) > 0 {
		for _, e := range m.Managers {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	if len(m.NetworkBootstrapKeys) > 0 {
		for _, e := range m.NetworkBootstrapKeys {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	l = len(m.RootCA)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *HeartbeatRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *HeartbeatResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.Period)
	n += 1 + l + sovDispatcher(uint64(l))
	return n
}

func (m *UpdateTaskStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Updates) > 0 {
		for _, e := range m.Updates {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TaskID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *UpdateTaskStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *UpdateVolumeStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Updates) > 0 {
		for _, e := range m.Updates {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Unpublished {
		n += 2
	}
	return n
}

func (m *UpdateVolumeStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *TasksRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *TasksMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *AssignmentsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *Assignment) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Item != nil {
		n += m.Item.Size()
	}
	return n
}

func (m *Assignment_Task) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Task != nil {
		l = m.Task.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}
func (m *Assignment_Secret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}
func (m *Assignment_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}
func (m *Assignment_Volume) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Volume != nil {
		l = m.Volume.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}
func (m *AssignmentChange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Assignment != nil {
		l = m.Assignment.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Action != 0 {
		n += 1 + sovDispatcher(uint64(m.Action))
	}
	return n
}

func (m *AssignmentsMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovDispatcher(uint64(m.Type))
	}
	l = len(m.AppliesTo)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	l = len(m.ResultsIn)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Changes) > 0 {
		for _, e := range m.Changes {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func sovDispatcher(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozDispatcher(x uint64) (n int) {
	return sovDispatcher(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *SessionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest{`,
		`Description:` + strings.Replace(fmt.Sprintf("%v", this.Description), "NodeDescription", "NodeDescription", 1) + `,`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionMessage) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForManagers := "[]*WeightedPeer{"
	for _, f := range this.Managers {
		repeatedStringForManagers += strings.Replace(fmt.Sprintf("%v", f), "WeightedPeer", "WeightedPeer", 1) + ","
	}
	repeatedStringForManagers += "}"
	repeatedStringForNetworkBootstrapKeys := "[]*EncryptionKey{"
	for _, f := range this.NetworkBootstrapKeys {
		repeatedStringForNetworkBootstrapKeys += strings.Replace(fmt.Sprintf("%v", f), "EncryptionKey", "EncryptionKey", 1) + ","
	}
	repeatedStringForNetworkBootstrapKeys += "}"
	s := strings.Join([]string{`&SessionMessage{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`Managers:` + repeatedStringForManagers + `,`,
		`NetworkBootstrapKeys:` + repeatedStringForNetworkBootstrapKeys + `,`,
		`RootCA:` + fmt.Sprintf("%v", this.RootCA) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatResponse{`,
		`Period:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Period), "Duration", "types.Duration", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForUpdates := "[]*UpdateTaskStatusRequest_TaskStatusUpdate{"
	for _, f := range this.Updates {
		repeatedStringForUpdates += strings.Replace(fmt.Sprintf("%v", f), "UpdateTaskStatusRequest_TaskStatusUpdate", "UpdateTaskStatusRequest_TaskStatusUpdate", 1) + ","
	}
	repeatedStringForUpdates += "}"
	s := strings.Join([]string{`&UpdateTaskStatusRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Updates:` + repeatedStringForUpdates + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest_TaskStatusUpdate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusRequest_TaskStatusUpdate{`,
		`TaskID:` + fmt.Sprintf("%v", this.TaskID) + `,`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "TaskStatus", "TaskStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusResponse{`,
		`}`,
	}, "")
	return s
}
func (this *UpdateVolumeStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForUpdates := "[]*UpdateVolumeStatusRequest_VolumeStatusUpdate{"
	for _, f := range this.Updates {
		repeatedStringForUpdates += strings.Replace(fmt.Sprintf("%v", f), "UpdateVolumeStatusRequest_VolumeStatusUpdate", "UpdateVolumeStatusRequest_VolumeStatusUpdate", 1) + ","
	}
	repeatedStringForUpdates += "}"
	s := strings.Join([]string{`&UpdateVolumeStatusRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Updates:` + repeatedStringForUpdates + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateVolumeStatusRequest_VolumeStatusUpdate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateVolumeStatusRequest_VolumeStatusUpdate{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Unpublished:` + fmt.Sprintf("%v", this.Unpublished) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateVolumeStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateVolumeStatusResponse{`,
		`}`,
	}, "")
	return s
}
func (this *TasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TasksRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TasksMessage) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTasks := "[]*Task{"
	for _, f := range this.Tasks {
		repeatedStringForTasks += strings.Replace(fmt.Sprintf("%v", f), "Task", "Task", 1) + ","
	}
	repeatedStringForTasks += "}"
	s := strings.Join([]string{`&TasksMessage{`,
		`Tasks:` + repeatedStringForTasks + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignmentsRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AssignmentsRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment{`,
		`Item:` + fmt.Sprintf("%v", this.Item) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment_Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment_Task{`,
		`Task:` + strings.Replace(fmt.Sprintf("%v", this.Task), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment_Secret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment_Secret{`,
		`Secret:` + strings.Replace(fmt.Sprintf("%v", this.Secret), "Secret", "Secret", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment_Config) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment_Config{`,
		`Config:` + strings.Replace(fmt.Sprintf("%v", this.Config), "Config", "Config", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Assignment_Volume) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Assignment_Volume{`,
		`Volume:` + strings.Replace(fmt.Sprintf("%v", this.Volume), "VolumeAssignment", "VolumeAssignment", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignmentChange) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&AssignmentChange{`,
		`Assignment:` + strings.Replace(this.Assignment.String(), "Assignment", "Assignment", 1) + `,`,
		`Action:` + fmt.Sprintf("%v", this.Action) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AssignmentsMessage) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForChanges := "[]*AssignmentChange{"
	for _, f := range this.Changes {
		repeatedStringForChanges += strings.Replace(f.String(), "AssignmentChange", "AssignmentChange", 1) + ","
	}
	repeatedStringForChanges += "}"
	s := strings.Join([]string{`&AssignmentsMessage{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`AppliesTo:` + fmt.Sprintf("%v", this.AppliesTo) + `,`,
		`ResultsIn:` + fmt.Sprintf("%v", this.ResultsIn) + `,`,
		`Changes:` + repeatedStringForChanges + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringDispatcher(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *SessionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Description == nil {
				m.Description = &NodeDescription{}
			}
			if err := m.Description.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SessionMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &Node{}
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Managers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Managers = append(m.Managers, &WeightedPeer{})
			if err := m.Managers[len(m.Managers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkBootstrapKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkBootstrapKeys = append(m.NetworkBootstrapKeys, &EncryptionKey{})
			if err := m.NetworkBootstrapKeys[len(m.NetworkBootstrapKeys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootCA", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RootCA = append(m.RootCA[:0], dAtA[iNdEx:postIndex]...)
			if m.RootCA == nil {
				m.RootCA = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.Period, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Updates = append(m.Updates, &UpdateTaskStatusRequest_TaskStatusUpdate{})
			if err := m.Updates[len(m.Updates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatusUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatusUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &TaskStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateVolumeStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateVolumeStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateVolumeStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Updates = append(m.Updates, &UpdateVolumeStatusRequest_VolumeStatusUpdate{})
			if err := m.Updates[len(m.Updates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateVolumeStatusRequest_VolumeStatusUpdate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VolumeStatusUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VolumeStatusUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unpublished", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Unpublished = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateVolumeStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateVolumeStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateVolumeStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignmentsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignmentsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignmentsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Assignment) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Assignment: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Assignment: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Task{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Item = &Assignment_Task{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Secret{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Item = &Assignment_Secret{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Config{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Item = &Assignment_Config{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Volume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &VolumeAssignment{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Item = &Assignment_Volume{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignmentChange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignmentChange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignmentChange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Assignment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Assignment == nil {
				m.Assignment = &Assignment{}
			}
			if err := m.Assignment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= AssignmentChange_AssignmentAction(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssignmentsMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssignmentsMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssignmentsMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= AssignmentsMessage_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppliesTo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppliesTo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultsIn", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResultsIn = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Changes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDispatcher
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Changes = append(m.Changes, &AssignmentChange{})
			if err := m.Changes[len(m.Changes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDispatcher(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthDispatcher
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupDispatcher
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthDispatcher
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthDispatcher        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDispatcher          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupDispatcher = fmt.Errorf("proto: unexpected end of group")
)
