/*
   FALCON - The Falcon Programming Language.
   FILE: error_ext.cpp

   Error for WOPI exceptions.

   -------------------------------------------------------------------
   Author: Giancarlo Niccolai
   Begin: Sun, 28 Mar 2010 17:12:01 +0200

   -------------------------------------------------------------------
   (C) Copyright 2010: the FALCON developers (see list in AUTHORS file)

   See LICENSE file for licensing details.
*/


#include <falcon/error.h>
#include <falcon/wopi/error_ext.h>

#include <falcon/coreobject.h>
#include <falcon/vm.h>

namespace Falcon {
namespace WOPI {

/*#
   @beginmodule WOPI
*/

/*#
   @class WopiError
   @brief Error generated by wopi in case of failures.
   @optparam code A numeric error code.
   @optparam description A textual description of the error code.
   @optparam extra A descriptive message explaining the error conditions.
   @from Error code, description, extra

   Possible error codes are:
   - WopiError.SessionFailed - Failed to restore a session.
   - WopiError.SessionInvalid - Invalid session ID.

*/

void  WopiError_init ( ::Falcon::VMachine *vm )
{
   CoreObject *einst = vm->self().asObject();
   if( einst->getUserData() == 0 )
      einst->setUserData( new WopiError );

   ::Falcon::core::Error_init( vm );
}


void InitErrorClass( Module* self )
{
   // create a singleton instance of %Request class
   Falcon::Symbol *error_class = self->addExternalRef( "Error" ); // it's external

   Falcon::Symbol *c_wopi_error = self->addClass( "WopiError", &WopiError_init );
   c_wopi_error->getClassDef()->addInheritance( new Falcon::InheritDef( error_class ) );

   self->addClassProperty( c_wopi_error, "SessionError" )
                     .setInteger( FALCON_ERROR_WOPI_SESS_IO );

   self->addClassProperty( c_wopi_error, "SessionExpired" )
                     .setInteger( FALCON_ERROR_WOPI_SESS_EXPIRED );

   self->addClassProperty( c_wopi_error, "AppdataSer" )
                     .setInteger( FALCON_ERROR_WOPI_APPDATA_SER );

   self->addClassProperty( c_wopi_error, "AppdataDeser" )
                     .setInteger( FALCON_ERROR_WOPI_APPDATA_DESER );

   self->addClassProperty( c_wopi_error, "InvalidSessionID" )
                     .setInteger( FALCON_ERROR_WOPI_SESS_INVALID_ID );

}


}
}

/* end of error_ext.cpp */
