/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.Control;
import visad.CoordinateSystem;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.MathType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ShadowType;
import visad.VisADException;

public class ShadowScalarType
extends ShadowType {
    int Index;
    private Vector SelectedMapVector;
    private DisplayTupleType DisplaySpatialTuple = null;
    private int[] DisplaySpatialTupleIndex = new int[3];
    private int DisplaySpatialTupleIndexIndex;
    private int[] inherited_values;

    public ShadowScalarType(MathType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(type, link, parent);
        for (int k = 0; k < 3; ++k) {
            this.DisplaySpatialTupleIndex[k] = -1;
        }
        this.DisplaySpatialTupleIndexIndex = 0;
        int spatial_count = 0;
        this.Index = -1;
        this.SelectedMapVector = new Vector();
        Enumeration maps = this.display.getMapVector().elements();
        while (maps.hasMoreElements()) {
            CoordinateSystem coord_sys;
            ScalarMap map = (ScalarMap)maps.nextElement();
            if (!map.getScalar().equals(this.Type)) continue;
            this.Index = map.getScalarIndex();
            this.SelectedMapVector.addElement(map);
            this.Link.addSelectedMapVector(map);
            int n = map.getDisplayScalarIndex();
            this.DisplayIndices[n] = this.DisplayIndices[n] + 1;
            int n2 = map.getValueIndex();
            this.ValueIndices[n2] = this.ValueIndices[n2] + 1;
            DisplayTupleType tuple = map.getDisplayScalar().getTuple();
            if (!(tuple == null || tuple.equals(Display.DisplaySpatialCartesianTuple) || (coord_sys = tuple.getCoordinateSystem()) != null && coord_sys.getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                tuple = null;
            }
            if (tuple == null) continue;
            ++spatial_count;
            if (this.DisplaySpatialTuple != null) {
                if (!tuple.equals(this.DisplaySpatialTuple)) {
                    ScalarType real = (ScalarType)this.Type;
                    throw new BadMappingException(real.getName() + " mapped to multiple spatial DisplayTupleType-s: " + "ShadowScalarType");
                }
            } else {
                this.DisplaySpatialTuple = tuple;
            }
            this.DisplaySpatialTupleIndex[this.DisplaySpatialTupleIndexIndex] = map.getDisplayScalar().getTupleIndex();
            ++this.DisplaySpatialTupleIndexIndex;
        }
        this.MultipleSpatialDisplayScalar = spatial_count > 1;
        this.MultipleDisplayScalar = this.SelectedMapVector.size() > 1;
        this.MappedDisplayScalar = this.SelectedMapVector.size() > 0;
    }

    void incrementIndices(int[] indices) {
        if (this.MappedDisplayScalar && this.Index < indices.length) {
            int n = this.Index;
            indices[n] = indices[n] + 1;
        }
    }

    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        int[] local_indices = ShadowScalarType.copyIndices(indices);
        this.incrementIndices(local_indices);
        int[] local_display_indices = ShadowScalarType.addIndices(display_indices, this.DisplayIndices);
        int[] local_value_indices = ShadowScalarType.addIndices(value_indices, this.ValueIndices);
        this.markTransform(isTransform);
        this.inherited_values = ShadowScalarType.copyIndices(value_indices);
        if (levelOfDifficulty == 6 && this.checkAny(this.DisplayIndices)) {
            levelOfDifficulty = 2;
        }
        if (this.checkAnimationOrValue(this.DisplayIndices) > 0) {
            throw new BadMappingException("Animation and SelectValue may not occur in range: ShadowScalarType.checkIndices");
        }
        this.anyContour = this.checkContour(local_display_indices);
        this.anyFlow = this.checkFlow(local_display_indices);
        this.anyShape = this.checkShape(local_display_indices);
        this.anyText = this.checkText(local_display_indices);
        this.adjustProjectionSeam = this.getAdjustProjectionSeam();
        this.LevelOfDifficulty = this.testIndices(local_indices, local_display_indices, levelOfDifficulty);
        if (this.LevelOfDifficulty == 2) {
            this.LevelOfDifficulty = this.checkR2D2(this.DisplayIndices) ? 5 : 1;
        }
        return this.LevelOfDifficulty;
    }

    public int[] getInheritedValues() {
        return this.inherited_values;
    }

    public boolean getMappedDisplayScalar() {
        return this.MappedDisplayScalar;
    }

    public DisplayTupleType getDisplaySpatialTuple() {
        return this.DisplaySpatialTuple;
    }

    public int[] getDisplaySpatialTupleIndex() {
        return this.DisplaySpatialTupleIndex;
    }

    public int getIndex() {
        return this.Index;
    }

    public Vector getSelectedMapVector() {
        return (Vector)this.SelectedMapVector.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markTransform(boolean[] isTransform) {
        Vector vector = this.SelectedMapVector;
        synchronized (vector) {
            Enumeration maps = this.SelectedMapVector.elements();
            while (maps.hasMoreElements()) {
                Control control;
                ScalarMap map = (ScalarMap)maps.nextElement();
                DisplayRealType real = map.getDisplayScalar();
                if (!real.equals(Display.Animation) && !real.equals(Display.SelectValue) && !real.equals(Display.SelectRange) || (control = map.getControl()) == null) continue;
                isTransform[control.getIndex()] = true;
            }
        }
    }
}

