/* /root/build/gfal2/src/common/http/delegation.h
   Generated by wsdl2h 1.2.13 from /afs/cern.ch/user/a/aalvarez/Source/gfal2/src/common/http/delegation-1.1.0.wsdl and typemap.dat
   2012-11-16 15:20:37 GMT
   gSOAP XML Web services tools.
   Copyright (C) 2001-2009 Robert van Engelen, Genivia Inc. All Rights Reserved.
   Part of this software is released under one of the following licenses:
   GPL or Genivia's license for commercial use.
*/

/* NOTE:

 - Compile this file with soapcpp2 to complete the code generation process.
 - Use soapcpp2 option -I to specify paths for #import
   To build with STL, 'stlvector.h' is imported from 'import' dir in package.
 - Use wsdl2h options -c and -s to generate pure C code or C++ code without STL.
 - Use 'typemap.dat' to control namespace bindings and type mappings.
   It is strongly recommended to customize the names of the namespace prefixes
   generated by wsdl2h. To do so, modify the prefix bindings in the Namespaces
   section below and add the modified lines to 'typemap.dat' to rerun wsdl2h.
 - Use Doxygen (www.doxygen.org) to browse this file.
 - Use wsdl2h option -l to view the software license terms.

   DO NOT include this file directly into your project.
   Include only the soapcpp2-generated headers and source code files.
*/

//gsoapopt w

/******************************************************************************\
 *                                                                            *
 * http://www.gridsite.org/namespaces/delegation-1                            *
 *                                                                            *
\******************************************************************************/


/******************************************************************************\
 *                                                                            *
 * Import                                                                     *
 *                                                                            *
\******************************************************************************/


// STL vector containers (use option -s to disable)
#import "stlvector.h"

/******************************************************************************\
 *                                                                            *
 * Schema Namespaces                                                          *
 *                                                                            *
\******************************************************************************/


/* NOTE:

It is strongly recommended to customize the names of the namespace prefixes
generated by wsdl2h. To do so, modify the prefix bindings below and add the
modified lines to typemap.dat to rerun wsdl2h:

tns = "http://www.gridsite.org/namespaces/delegation-1"

*/

//gsoap tns   schema namespace:	http://www.gridsite.org/namespaces/delegation-1
//gsoap tns   schema form:	unqualified

/******************************************************************************\
 *                                                                            *
 * Schema Types                                                               *
 *                                                                            *
\******************************************************************************/



//  Forward declaration of class tns__DelegationExceptionType.
class tns__DelegationExceptionType;

//  Forward declaration of class tns__NewProxyReq.
class tns__NewProxyReq;

/// "http://www.gridsite.org/namespaces/delegation-1":DelegationExceptionType is a complexType.
class tns__DelegationExceptionType
{ public:
/// @brief The cause of the delegation exception on the server side.
/// Element message of type xs:string.
    std::string*                         message                       ;	///< Nullable pointer.
/// A handle to the soap struct that manages this instance (automatically set)
    struct soap                         *soap                          ;
};

/// "http://www.gridsite.org/namespaces/delegation-1":NewProxyReq is a complexType.
/// @brief New proxy certificate request, containing the certificate request and a generated delegation ID.
class tns__NewProxyReq
{ public:
/// @brief The new RFC 3280 style proxy certificate request in PEM format with Base64 encoding.
/// Element proxyRequest of type xs:string.
    std::string*                         proxyRequest                  ;	///< Nullable pointer.
/// @brief The ID associated with the new delegation session.
/// Element delegationID of type xs:string.
    std::string*                         delegationID                  ;	///< Nullable pointer.
/// A handle to the soap struct that manages this instance (automatically set)
    struct soap                         *soap                          ;
};

/// Element "http://www.gridsite.org/namespaces/delegation-1":DelegationException of type "http://www.gridsite.org/namespaces/delegation-1":DelegationExceptionType.
/// Note: use wsdl2h option -g to generate this global element declaration.

/******************************************************************************\
 *                                                                            *
 * Services                                                                   *
 *                                                                            *
\******************************************************************************/


//gsoap tns  service name:	DelegationSoapBinding 
//gsoap tns  service type:	Delegation 
//gsoap tns  service port:	https://localhost:8443/glite-security-delegation 
//gsoap tns  service namespace:	http://www.gridsite.org/namespaces/delegation-1 
//gsoap tns  service transport:	http://schemas.xmlsoap.org/soap/http 

/** @mainpage Service Definitions

@section Service_bindings Bindings
  - @ref DelegationSoapBinding

*/

/**

@page DelegationSoapBinding Binding "DelegationSoapBinding"

@section DelegationSoapBinding_operations Operations of Binding  "DelegationSoapBinding"
  - @ref tns__getProxyReq
  - @ref tns__getNewProxyReq
  - @ref tns__renewProxyReq
  - @ref tns__putProxy
  - @ref tns__getTerminationTime
  - @ref tns__destroy

@section DelegationSoapBinding_ports Endpoints of Binding  "DelegationSoapBinding"
  - https://localhost:8443/glite-security-delegation

Note: use wsdl2h option -N to change the service binding prefix name

*/

/******************************************************************************\
 *                                                                            *
 * SOAP Fault Detail                                                          *
 *                                                                            *
\******************************************************************************/

/**

The SOAP Fault is part of the gSOAP context and its content is accessed
through the soap.fault->detail variable (SOAP 1.1) or the
soap.fault->SOAP_ENV__Detail variable (SOAP 1.2).
Use option -j to omit.

*/
struct SOAP_ENV__Detail
{
    tns__DelegationExceptionType*        tns__DelegationException      ;
///< SOAP Fault element ""http://www.gridsite.org/namespaces/delegation-1":DelegationException" part "fault"
    int                                  __type                        ;	///< set to SOAP_TYPE_X for a serializable type X
    void                                *fault                         ;	///< points to serializable object X or NULL
    _XML                                 __any                         ;	///< Catch any element content in XML string.
};

/******************************************************************************\
 *                                                                            *
 * DelegationSoapBinding                                                      *
 *                                                                            *
\******************************************************************************/


/******************************************************************************\
 *                                                                            *
 * tns__getProxyReq                                                           *
 *                                                                            *
\******************************************************************************/

/// Operation response struct "tns__getProxyReqResponse" of service binding "DelegationSoapBinding" operation "tns__getProxyReq"
struct tns__getProxyReqResponse
{
/**  getProxyReqReturn parameter documentation:

            The new RFC 3280 style proxy certificate request 
            in PEM format with Base64 encoding.
        
*/

    std::string                         _getProxyReqReturn;
};

/// Operation "tns__getProxyReq" of service binding "DelegationSoapBinding"

/**

Operation details:


            <para>
                Starts the delegation procedure by asking for a certificate 
                signing request from the server. The server answers with a
                certificate signing request which includes the public key 
                for the new delegated credentials. putProxy() has to be
                called to finish the procedure.
            </para>
            <orderedlist>
                <listitem><para>
                    Check if a delegation ID was provided.  If not, generate a delegation
                    id by hashing the client DN and client VOMS attributes.
                </para></listitem>
                <listitem><para>
                    Check if the delegation ID already exists in the
                    <emphasis>storage-area</emphasis>.  If it does 
                    (a credential renewal is happening), check
                    existing info (DN and VOMS attributes) against client info.
                    Throw exception if they do not match.
                </para></listitem>
                <listitem><para>
                    Create a new private/public key-pair (see also <emphasis>Key
                    Generation Semantics</emphasis>).
                </para></listitem>
                <listitem><para>
                    Generate a new proxy certificate request.
                </para></listitem>
                <listitem><para>
                    Store private key and cert request in
                    <emphasis>storage-cache-area</emphasis>, along with the
                    requesting DN and VOMS attributes.
                </para></listitem>
            </orderedlist>
         
  - SOAP RPC literal style
  - SOAP Fault: "http://www.gridsite.org/namespaces/delegation-1":DelegationException (literal)

C stub function (defined in soapClient.c[pp] generated by soapcpp2):
@code
  int soap_call_tns__getProxyReq(
    struct soap *soap,
    NULL, // char *endpoint = NULL selects default endpoint for this operation
    NULL, // char *action = NULL selects default action for this operation
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__getProxyReqResponse&
  );
@endcode

C server function (called from the service dispatcher defined in soapServer.c[pp]):
@code
  int tns__getProxyReq(
    struct soap *soap,
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__getProxyReqResponse&
  );
@endcode

C++ proxy class (defined in soapDelegationSoapBindingProxy.h):
  class DelegationSoapBinding;

Note: use soapcpp2 option '-i' to generate improved proxy and service classes;

*/

//gsoap tns  service method-style:	getProxyReq rpc
//gsoap tns  service method-encoding:	getProxyReq literal
//gsoap tns  service method-action:	getProxyReq ""
//gsoap tns  service method-fault:	getProxyReq tns__DelegationException
int tns__getProxyReq(
/**  delegationID parameter documentation:

            The ID of the new delegation session, specified by the client.
            The ID can be empty.
        
*/

    std::string                         _delegationID,	///< Request parameter
    struct tns__getProxyReqResponse    &	///< Response struct parameter
);

/******************************************************************************\
 *                                                                            *
 * tns__getNewProxyReq                                                        *
 *                                                                            *
\******************************************************************************/

/// Operation response struct "tns__getNewProxyReqResponse" of service binding "DelegationSoapBinding" operation "tns__getNewProxyReq"
struct tns__getNewProxyReqResponse
{
/**  getNewProxyReqReturn parameter documentation:

            The server side generated ID of the new delegation
            session and the new RFC 3280 style proxy certificate 
            request in PEM format with Base64 encoding.
        
*/

    tns__NewProxyReq*                   getNewProxyReqReturn;
};

/// Operation "tns__getNewProxyReq" of service binding "DelegationSoapBinding"

/**

Operation details:


            <para>
                Starts the delegation procedure by asking for a certificate
                signing request from the server. The server answers with a
                certificate signing request which includes the public key
                for the new delegated credentials. putProxy() has to be
                called to finish the procedure.
            </para>
            <orderedlist>
                <listitem><para>
                    Generate a delegation
                    ID by hashing the client DN and client VOMS attributes.
                </para></listitem>
                <listitem><para>
                    Check if the delegation ID already exists in the
                    <emphasis>storage-area</emphasis>.  If it does, check
                    existing info (DN and VOMS attributes) against client info.
                    Throw exception if they do not match, because then this is 
                    the rare case of hash collision, i.e. two different clients 
                    are mapped to the same delegation ID.
                </para></listitem>
                <listitem><para>
                    Create a new private/public key-pair (see also <emphasis>Key
                    Generation Semantics</emphasis>).
                </para></listitem>
                <listitem><para>
                    Generate a new certificate request.
                </para></listitem>
                <listitem><para>
                    Store private key and cert request in
                    <emphasis>storage-cache-area</emphasis>, along with the
                    requesting DN and VOMS attributes.
                </para></listitem>
            </orderedlist>
         
  - SOAP RPC literal style
  - SOAP Fault: "http://www.gridsite.org/namespaces/delegation-1":DelegationException (literal)

C stub function (defined in soapClient.c[pp] generated by soapcpp2):
@code
  int soap_call_tns__getNewProxyReq(
    struct soap *soap,
    NULL, // char *endpoint = NULL selects default endpoint for this operation
    NULL, // char *action = NULL selects default action for this operation
    // request parameters:
    // response parameters:
    struct tns__getNewProxyReqResponse&
  );
@endcode

C server function (called from the service dispatcher defined in soapServer.c[pp]):
@code
  int tns__getNewProxyReq(
    struct soap *soap,
    // request parameters:
    // response parameters:
    struct tns__getNewProxyReqResponse&
  );
@endcode

C++ proxy class (defined in soapDelegationSoapBindingProxy.h):
  class DelegationSoapBinding;

Note: use soapcpp2 option '-i' to generate improved proxy and service classes;

*/

//gsoap tns  service method-style:	getNewProxyReq rpc
//gsoap tns  service method-encoding:	getNewProxyReq literal
//gsoap tns  service method-action:	getNewProxyReq ""
//gsoap tns  service method-fault:	getNewProxyReq tns__DelegationException
int tns__getNewProxyReq(
    struct tns__getNewProxyReqResponse &	///< Response struct parameter
);

/******************************************************************************\
 *                                                                            *
 * tns__renewProxyReq                                                         *
 *                                                                            *
\******************************************************************************/

/// Operation response struct "tns__renewProxyReqResponse" of service binding "DelegationSoapBinding" operation "tns__renewProxyReq"
struct tns__renewProxyReqResponse
{
/**  renewProxyReqReturn parameter documentation:

            The new RFC 3280 style proxy certificate request,
            which is to replace the existing one,
            in PEM format with Base64 encoding.
        
*/

    std::string                         _renewProxyReqReturn;
};

/// Operation "tns__renewProxyReq" of service binding "DelegationSoapBinding"

/**

Operation details:


            <para>
            Restarts the delegation procedure by asking for a certificate
            signing request from the server for an already existing delegation ID.
            The server answers with a certificate signing request which includes 
            the public key for new delegated credentials. putProxy() has to be
            called to finish the procedure.
            </para>
            <orderedlist>
                <listitem><para>
                    Check if a delegation ID was provided. If not, generate a delegation
                    id by hashing the client DN and client VOMS attributes.
                </para></listitem>
                <listitem><para>
                    Check if the delegation ID already exists in the
                    <emphasis>storage-area</emphasis>. If it does
                    not, then throw an exception.
                </para></listitem>
                <listitem><para>
                    Check if the existing info (DN and VOMS attributes) against client info.
                    Throw exception if they do not match.
                </para></listitem>
                <listitem><para>
                    Create a new private/public key-pair (see also <emphasis>Key
                    Generation Semantics</emphasis>).
                </para></listitem>
                <listitem><para>
                    Generate a new certificate request.
                </para></listitem>
                <listitem><para>
                    Store private key and cert request in
                    <emphasis>storage-cache-area</emphasis>, along with the
                    requesting DN and VOMS attributes.
                </para></listitem>
            </orderedlist>
         
  - SOAP RPC literal style
  - SOAP Fault: "http://www.gridsite.org/namespaces/delegation-1":DelegationException (literal)

C stub function (defined in soapClient.c[pp] generated by soapcpp2):
@code
  int soap_call_tns__renewProxyReq(
    struct soap *soap,
    NULL, // char *endpoint = NULL selects default endpoint for this operation
    NULL, // char *action = NULL selects default action for this operation
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__renewProxyReqResponse&
  );
@endcode

C server function (called from the service dispatcher defined in soapServer.c[pp]):
@code
  int tns__renewProxyReq(
    struct soap *soap,
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__renewProxyReqResponse&
  );
@endcode

C++ proxy class (defined in soapDelegationSoapBindingProxy.h):
  class DelegationSoapBinding;

Note: use soapcpp2 option '-i' to generate improved proxy and service classes;

*/

//gsoap tns  service method-style:	renewProxyReq rpc
//gsoap tns  service method-encoding:	renewProxyReq literal
//gsoap tns  service method-action:	renewProxyReq ""
//gsoap tns  service method-fault:	renewProxyReq tns__DelegationException
int tns__renewProxyReq(
/**  delegationID parameter documentation:

            The ID of an already existing delegation session,
            where the client wants to renew the delegated 
            credential.
        
*/

    std::string                         _delegationID,	///< Request parameter
    struct tns__renewProxyReqResponse  &	///< Response struct parameter
);

/******************************************************************************\
 *                                                                            *
 * tns__putProxy                                                              *
 *                                                                            *
\******************************************************************************/

/// Operation response struct "tns__putProxyResponse" of service binding "DelegationSoapBinding" operation "tns__putProxy"
struct tns__putProxyResponse
{
};

/// Operation "tns__putProxy" of service binding "DelegationSoapBinding"

/**

Operation details:


            <para>
            Finishes the delegation procedure by sending the signed 
            proxy certificate to the server.
            </para>
            <orderedlist>
                <listitem><para>
                    Check if a delegation ID was provided.  If not, generate a
                    delegation id by hashing the client DN and client VOMS
                    attributes.
                </para></listitem>
                <listitem><para>
                    Check if the delegation ID already exists in the
                    <emphasis>storage-area</emphasis>.  If it does, check
                    existing info (DN and VOMS attributes) against client info.
                    Throw exception if it does not match.
                </para></listitem>
                <listitem><para>
                    Check, if client information matches proxy information.
                </para></listitem>
                <listitem><para>
                    Check given proxy against private key of delegation ID in
                    <emphasis>storage-cache-area</emphasis>.  If they do not
                    match, throw exception.
                </para></listitem>
                <listitem><para>
                    Store proxy in <emphasis>storage-area</emphasis>
                    and clean up the <emphasis>storage-cache-area</emphasis>.
                </para></listitem>
            </orderedlist>
         
  - SOAP RPC literal style
  - SOAP Fault: "http://www.gridsite.org/namespaces/delegation-1":DelegationException (literal)

C stub function (defined in soapClient.c[pp] generated by soapcpp2):
@code
  int soap_call_tns__putProxy(
    struct soap *soap,
    NULL, // char *endpoint = NULL selects default endpoint for this operation
    NULL, // char *action = NULL selects default action for this operation
    // request parameters:
    std::string                         delegationID,
    std::string                         proxy,
    // response parameters:
    struct tns__putProxyResponse&
  );
@endcode

C server function (called from the service dispatcher defined in soapServer.c[pp]):
@code
  int tns__putProxy(
    struct soap *soap,
    // request parameters:
    std::string                         delegationID,
    std::string                         proxy,
    // response parameters:
    struct tns__putProxyResponse&
  );
@endcode

C++ proxy class (defined in soapDelegationSoapBindingProxy.h):
  class DelegationSoapBinding;

Note: use soapcpp2 option '-i' to generate improved proxy and service classes;

*/

//gsoap tns  service method-style:	putProxy rpc
//gsoap tns  service method-encoding:	putProxy literal
//gsoap tns  service method-action:	putProxy ""
//gsoap tns  service method-fault:	putProxy tns__DelegationException
int tns__putProxy(
/**  delegationID parameter documentation:

            The ID of an already existing delegation session, 
            initiated by getProxyReq() or getNewProxyReq().
        
*/

    std::string                         _delegationID,	///< Request parameter
/**  proxy parameter documentation:

            RFC 3280 style proxy certificate, signed by the
            client, in PEM format with Base64 encoding.
        
*/

    std::string                         _proxy,	///< Request parameter
    struct tns__putProxyResponse       &	///< Response struct parameter
);

/******************************************************************************\
 *                                                                            *
 * tns__getTerminationTime                                                    *
 *                                                                            *
\******************************************************************************/

/// Operation response struct "tns__getTerminationTimeResponse" of service binding "DelegationSoapBinding" operation "tns__getTerminationTime"
struct tns__getTerminationTimeResponse
{
/**  getTerminationTimeReturn parameter documentation:

            The date and time when the delegated credentials will expire.
        
*/

    time_t                              _getTerminationTimeReturn;
};

/// Operation "tns__getTerminationTime" of service binding "DelegationSoapBinding"

/**

Operation details:


            Returns the termination (expiration) date and time of the credential,
            associated with the given delegaion ID. If there was no delegation ID, 
            then generate one by hashing the client DN and client VOMS attributes.
         
  - SOAP RPC literal style
  - SOAP Fault: "http://www.gridsite.org/namespaces/delegation-1":DelegationException (literal)

C stub function (defined in soapClient.c[pp] generated by soapcpp2):
@code
  int soap_call_tns__getTerminationTime(
    struct soap *soap,
    NULL, // char *endpoint = NULL selects default endpoint for this operation
    NULL, // char *action = NULL selects default action for this operation
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__getTerminationTimeResponse&
  );
@endcode

C server function (called from the service dispatcher defined in soapServer.c[pp]):
@code
  int tns__getTerminationTime(
    struct soap *soap,
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__getTerminationTimeResponse&
  );
@endcode

C++ proxy class (defined in soapDelegationSoapBindingProxy.h):
  class DelegationSoapBinding;

Note: use soapcpp2 option '-i' to generate improved proxy and service classes;

*/

//gsoap tns  service method-style:	getTerminationTime rpc
//gsoap tns  service method-encoding:	getTerminationTime literal
//gsoap tns  service method-action:	getTerminationTime ""
//gsoap tns  service method-fault:	getTerminationTime tns__DelegationException
int tns__getTerminationTime(
/**  delegationID parameter documentation:

            The ID of an already existing delegation session to be queried.
        
*/

    std::string                         _delegationID,	///< Request parameter
    struct tns__getTerminationTimeResponse&	///< Response struct parameter
);

/******************************************************************************\
 *                                                                            *
 * tns__destroy                                                               *
 *                                                                            *
\******************************************************************************/

/// Operation response struct "tns__destroyResponse" of service binding "DelegationSoapBinding" operation "tns__destroy"
struct tns__destroyResponse
{
};

/// Operation "tns__destroy" of service binding "DelegationSoapBinding"

/**

Operation details:


            Destroys the delegated credentials associated with the
            given delegation ID immediately. If there was no delegation ID, 
            then generate one by hashing the client DN and client VOMS attributes.
         
  - SOAP RPC literal style
  - SOAP Fault: "http://www.gridsite.org/namespaces/delegation-1":DelegationException (literal)

C stub function (defined in soapClient.c[pp] generated by soapcpp2):
@code
  int soap_call_tns__destroy(
    struct soap *soap,
    NULL, // char *endpoint = NULL selects default endpoint for this operation
    NULL, // char *action = NULL selects default action for this operation
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__destroyResponse&
  );
@endcode

C server function (called from the service dispatcher defined in soapServer.c[pp]):
@code
  int tns__destroy(
    struct soap *soap,
    // request parameters:
    std::string                         delegationID,
    // response parameters:
    struct tns__destroyResponse&
  );
@endcode

C++ proxy class (defined in soapDelegationSoapBindingProxy.h):
  class DelegationSoapBinding;

Note: use soapcpp2 option '-i' to generate improved proxy and service classes;

*/

//gsoap tns  service method-style:	destroy rpc
//gsoap tns  service method-encoding:	destroy literal
//gsoap tns  service method-action:	destroy ""
//gsoap tns  service method-fault:	destroy tns__DelegationException
int tns__destroy(
/**  delegationID parameter documentation:

            The ID of an already existing delegation session to be destroyed.
        
*/

    std::string                         _delegationID,	///< Request parameter
    struct tns__destroyResponse        &	///< Response struct parameter
);

/* End of /root/build/gfal2/src/common/http/delegation.h */
